// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// UserGroupPrivileges user group privileges
//
// swagger:model user_group_privileges
type UserGroupPrivileges struct {

	// links
	Links *UserGroupPrivilegesInlineLinks `json:"_links,omitempty"`

	// Local or Active Directory user or group name.
	//
	// Example: user1
	Name *string `json:"name,omitempty"`

	// An array of privileges associated with the local or Active Directory user or group.
	// The available values are:
	// * SeTcbPrivilege              - Allows user to act as part of the operating system
	// * SeBackupPrivilege           - Allows user to back up files and directories, overriding any ACLs
	// * SeRestorePrivilege          - Allows user to restore files and directories, overriding any ACLs
	// * SeTakeOwnershipPrivilege    - Allows user to take ownership of files or other objects
	// * SeSecurityPrivilege         - Allows user to manage auditing and viewing/dumping/clearing the security log
	// * SeChangeNotifyPrivilege     - Allows user to bypass traverse checking
	//
	Privileges []*string `json:"privileges,omitempty"`

	// svm
	Svm *UserGroupPrivilegesInlineSvm `json:"svm,omitempty"`
}

// Validate validates this user group privileges
func (m *UserGroupPrivileges) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrivileges(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivileges) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var userGroupPrivilegesPrivilegesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["setcbprivilege","sebackupprivilege","serestoreprivilege","setakeownershipprivilege","sesecurityprivilege","sechangenotifyprivilege"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		userGroupPrivilegesPrivilegesItemsEnum = append(userGroupPrivilegesPrivilegesItemsEnum, v)
	}
}

func (m *UserGroupPrivileges) validatePrivilegesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, userGroupPrivilegesPrivilegesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *UserGroupPrivileges) validatePrivileges(formats strfmt.Registry) error {
	if swag.IsZero(m.Privileges) { // not required
		return nil
	}

	for i := 0; i < len(m.Privileges); i++ {
		if swag.IsZero(m.Privileges[i]) { // not required
			continue
		}

		// value enum
		if err := m.validatePrivilegesItemsEnum("privileges"+"."+strconv.Itoa(i), "body", *m.Privileges[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *UserGroupPrivileges) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this user group privileges based on the context it is used
func (m *UserGroupPrivileges) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivileges) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *UserGroupPrivileges) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UserGroupPrivileges) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UserGroupPrivileges) UnmarshalBinary(b []byte) error {
	var res UserGroupPrivileges
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UserGroupPrivilegesInlineLinks user group privileges inline links
//
// swagger:model user_group_privileges_inline__links
type UserGroupPrivilegesInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this user group privileges inline links
func (m *UserGroupPrivilegesInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivilegesInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this user group privileges inline links based on the context it is used
func (m *UserGroupPrivilegesInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivilegesInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UserGroupPrivilegesInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UserGroupPrivilegesInlineLinks) UnmarshalBinary(b []byte) error {
	var res UserGroupPrivilegesInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UserGroupPrivilegesInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model user_group_privileges_inline_svm
type UserGroupPrivilegesInlineSvm struct {

	// links
	Links *UserGroupPrivilegesInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this user group privileges inline svm
func (m *UserGroupPrivilegesInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivilegesInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this user group privileges inline svm based on the context it is used
func (m *UserGroupPrivilegesInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivilegesInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UserGroupPrivilegesInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UserGroupPrivilegesInlineSvm) UnmarshalBinary(b []byte) error {
	var res UserGroupPrivilegesInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UserGroupPrivilegesInlineSvmInlineLinks user group privileges inline svm inline links
//
// swagger:model user_group_privileges_inline_svm_inline__links
type UserGroupPrivilegesInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this user group privileges inline svm inline links
func (m *UserGroupPrivilegesInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivilegesInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this user group privileges inline svm inline links based on the context it is used
func (m *UserGroupPrivilegesInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UserGroupPrivilegesInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UserGroupPrivilegesInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UserGroupPrivilegesInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res UserGroupPrivilegesInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
