// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Usm User-based Security Model (USM) object defines SNMPv3-specific parameters required to configure an SNMPv3 user.
//
// swagger:model usm
type Usm struct {

	// links
	Links *UsmInlineLinks `json:"_links,omitempty"`

	// Authentication protocol password.
	// Example: humTdumt*@t0nAwa11
	// Min Length: 8
	AuthenticationPassword *string `json:"authentication_password,omitempty"`

	// Authentication protocol.
	// Example: sha2_256
	// Enum: ["none","md5","sha","sha2_256"]
	AuthenticationProtocol *string `json:"authentication_protocol,omitempty"`

	// Privacy protocol password.
	// Example: p@**GOandCLCt*200
	// Min Length: 8
	PrivacyPassword *string `json:"privacy_password,omitempty"`

	// Privacy protocol.
	// Example: aes128
	// Enum: ["none","des","aes128"]
	PrivacyProtocol *string `json:"privacy_protocol,omitempty"`
}

// Validate validates this usm
func (m *Usm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrivacyPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrivacyProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Usm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Usm) validateAuthenticationPassword(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationPassword) { // not required
		return nil
	}

	if err := validate.MinLength("authentication_password", "body", *m.AuthenticationPassword, 8); err != nil {
		return err
	}

	return nil
}

var usmTypeAuthenticationProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","md5","sha","sha2_256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		usmTypeAuthenticationProtocolPropEnum = append(usmTypeAuthenticationProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// usm
	// Usm
	// authentication_protocol
	// AuthenticationProtocol
	// none
	// END DEBUGGING
	// UsmAuthenticationProtocolNone captures enum value "none"
	UsmAuthenticationProtocolNone string = "none"

	// BEGIN DEBUGGING
	// usm
	// Usm
	// authentication_protocol
	// AuthenticationProtocol
	// md5
	// END DEBUGGING
	// UsmAuthenticationProtocolMd5 captures enum value "md5"
	UsmAuthenticationProtocolMd5 string = "md5"

	// BEGIN DEBUGGING
	// usm
	// Usm
	// authentication_protocol
	// AuthenticationProtocol
	// sha
	// END DEBUGGING
	// UsmAuthenticationProtocolSha captures enum value "sha"
	UsmAuthenticationProtocolSha string = "sha"

	// BEGIN DEBUGGING
	// usm
	// Usm
	// authentication_protocol
	// AuthenticationProtocol
	// sha2_256
	// END DEBUGGING
	// UsmAuthenticationProtocolSha2256 captures enum value "sha2_256"
	UsmAuthenticationProtocolSha2256 string = "sha2_256"
)

// prop value enum
func (m *Usm) validateAuthenticationProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, usmTypeAuthenticationProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Usm) validateAuthenticationProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationProtocolEnum("authentication_protocol", "body", *m.AuthenticationProtocol); err != nil {
		return err
	}

	return nil
}

func (m *Usm) validatePrivacyPassword(formats strfmt.Registry) error {
	if swag.IsZero(m.PrivacyPassword) { // not required
		return nil
	}

	if err := validate.MinLength("privacy_password", "body", *m.PrivacyPassword, 8); err != nil {
		return err
	}

	return nil
}

var usmTypePrivacyProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","des","aes128"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		usmTypePrivacyProtocolPropEnum = append(usmTypePrivacyProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// usm
	// Usm
	// privacy_protocol
	// PrivacyProtocol
	// none
	// END DEBUGGING
	// UsmPrivacyProtocolNone captures enum value "none"
	UsmPrivacyProtocolNone string = "none"

	// BEGIN DEBUGGING
	// usm
	// Usm
	// privacy_protocol
	// PrivacyProtocol
	// des
	// END DEBUGGING
	// UsmPrivacyProtocolDes captures enum value "des"
	UsmPrivacyProtocolDes string = "des"

	// BEGIN DEBUGGING
	// usm
	// Usm
	// privacy_protocol
	// PrivacyProtocol
	// aes128
	// END DEBUGGING
	// UsmPrivacyProtocolAes128 captures enum value "aes128"
	UsmPrivacyProtocolAes128 string = "aes128"
)

// prop value enum
func (m *Usm) validatePrivacyProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, usmTypePrivacyProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Usm) validatePrivacyProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.PrivacyProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validatePrivacyProtocolEnum("privacy_protocol", "body", *m.PrivacyProtocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this usm based on the context it is used
func (m *Usm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Usm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Usm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Usm) UnmarshalBinary(b []byte) error {
	var res Usm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UsmInlineLinks usm inline links
//
// swagger:model usm_inline__links
type UsmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this usm inline links
func (m *UsmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UsmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this usm inline links based on the context it is used
func (m *UsmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UsmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UsmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UsmInlineLinks) UnmarshalBinary(b []byte) error {
	var res UsmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
