// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VdiOnNas A VDI application using NAS.
//
// swagger:model vdi_on_nas
type VdiOnNas struct {

	// desktops
	// Required: true
	Desktops *VdiOnNasInlineDesktops `json:"desktops"`

	// hyper v access
	HypervAccess *VdiOnNasInlineHypervAccess `json:"hyper_v_access,omitempty"`

	// protection type
	ProtectionType *VdiOnNasInlineProtectionType `json:"protection_type,omitempty"`

	// The list of NFS access controls. You must provide either 'host' or 'access' to enable NFS access.
	VdiOnNasInlineNfsAccess []*AppNfsAccess `json:"nfs_access,omitempty"`
}

// Validate validates this vdi on nas
func (m *VdiOnNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDesktops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHypervAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiOnNasInlineNfsAccess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnNas) validateDesktops(formats strfmt.Registry) error {

	if err := validate.Required("desktops", "body", m.Desktops); err != nil {
		return err
	}

	if m.Desktops != nil {
		if err := m.Desktops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnNas) validateHypervAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.HypervAccess) { // not required
		return nil
	}

	if m.HypervAccess != nil {
		if err := m.HypervAccess.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hyper_v_access")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnNas) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnNas) validateVdiOnNasInlineNfsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiOnNasInlineNfsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.VdiOnNasInlineNfsAccess); i++ {
		if swag.IsZero(m.VdiOnNasInlineNfsAccess[i]) { // not required
			continue
		}

		if m.VdiOnNasInlineNfsAccess[i] != nil {
			if err := m.VdiOnNasInlineNfsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vdi on nas based on the context it is used
func (m *VdiOnNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDesktops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHypervAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVdiOnNasInlineNfsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnNas) contextValidateDesktops(ctx context.Context, formats strfmt.Registry) error {

	if m.Desktops != nil {
		if err := m.Desktops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnNas) contextValidateHypervAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.HypervAccess != nil {
		if err := m.HypervAccess.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hyper_v_access")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnNas) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnNas) contextValidateVdiOnNasInlineNfsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VdiOnNasInlineNfsAccess); i++ {

		if m.VdiOnNasInlineNfsAccess[i] != nil {
			if err := m.VdiOnNasInlineNfsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnNas) UnmarshalBinary(b []byte) error {
	var res VdiOnNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnNasInlineDesktops vdi on nas inline desktops
//
// swagger:model vdi_on_nas_inline_desktops
type VdiOnNasInlineDesktops struct {

	// The number of desktops to support.
	// Maximum: 8000
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The size of the desktops. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *VdiOnNasInlineDesktopsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this vdi on nas inline desktops
func (m *VdiOnNasInlineDesktops) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnNasInlineDesktops) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("desktops"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("desktops"+"."+"count", "body", *m.Count, 8000, false); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnNasInlineDesktops) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("desktops"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnNasInlineDesktops) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vdi on nas inline desktops based on the context it is used
func (m *VdiOnNasInlineDesktops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnNasInlineDesktops) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnNasInlineDesktops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnNasInlineDesktops) UnmarshalBinary(b []byte) error {
	var res VdiOnNasInlineDesktops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnNasInlineDesktopsInlineStorageService vdi on nas inline desktops inline storage service
//
// swagger:model vdi_on_nas_inline_desktops_inline_storage_service
type VdiOnNasInlineDesktopsInlineStorageService struct {

	// The storage service of the desktops.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this vdi on nas inline desktops inline storage service
func (m *VdiOnNasInlineDesktopsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var vdiOnNasInlineDesktopsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnNasInlineDesktopsInlineStorageServiceTypeNamePropEnum = append(vdiOnNasInlineDesktopsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_desktops_inline_storage_service
	// VdiOnNasInlineDesktopsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// VdiOnNasInlineDesktopsInlineStorageServiceNameExtreme captures enum value "extreme"
	VdiOnNasInlineDesktopsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_desktops_inline_storage_service
	// VdiOnNasInlineDesktopsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// VdiOnNasInlineDesktopsInlineStorageServiceNamePerformance captures enum value "performance"
	VdiOnNasInlineDesktopsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_desktops_inline_storage_service
	// VdiOnNasInlineDesktopsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// VdiOnNasInlineDesktopsInlineStorageServiceNameValue captures enum value "value"
	VdiOnNasInlineDesktopsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *VdiOnNasInlineDesktopsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnNasInlineDesktopsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnNasInlineDesktopsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("desktops"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this vdi on nas inline desktops inline storage service based on context it is used
func (m *VdiOnNasInlineDesktopsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnNasInlineDesktopsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnNasInlineDesktopsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res VdiOnNasInlineDesktopsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnNasInlineHypervAccess vdi on nas inline hyper v access
//
// swagger:model vdi_on_nas_inline_hyper_v_access
type VdiOnNasInlineHypervAccess struct {

	// Hyper-V service account.
	// Max Length: 256
	// Min Length: 1
	ServiceAccount *string `json:"service_account,omitempty"`
}

// Validate validates this vdi on nas inline hyper v access
func (m *VdiOnNasInlineHypervAccess) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateServiceAccount(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnNasInlineHypervAccess) validateServiceAccount(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceAccount) { // not required
		return nil
	}

	if err := validate.MinLength("hyper_v_access"+"."+"service_account", "body", *m.ServiceAccount, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("hyper_v_access"+"."+"service_account", "body", *m.ServiceAccount, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this vdi on nas inline hyper v access based on context it is used
func (m *VdiOnNasInlineHypervAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnNasInlineHypervAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnNasInlineHypervAccess) UnmarshalBinary(b []byte) error {
	var res VdiOnNasInlineHypervAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnNasInlineProtectionType vdi on nas inline protection type
//
// swagger:model vdi_on_nas_inline_protection_type
type VdiOnNasInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this vdi on nas inline protection type
func (m *VdiOnNasInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var vdiOnNasInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnNasInlineProtectionTypeTypeLocalRpoPropEnum = append(vdiOnNasInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_protection_type
	// VdiOnNasInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// VdiOnNasInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	VdiOnNasInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_protection_type
	// VdiOnNasInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// VdiOnNasInlineProtectionTypeLocalRpoNone captures enum value "none"
	VdiOnNasInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *VdiOnNasInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnNasInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnNasInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var vdiOnNasInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnNasInlineProtectionTypeTypeRemoteRpoPropEnum = append(vdiOnNasInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_protection_type
	// VdiOnNasInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// VdiOnNasInlineProtectionTypeRemoteRpoNone captures enum value "none"
	VdiOnNasInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// vdi_on_nas_inline_protection_type
	// VdiOnNasInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// VdiOnNasInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	VdiOnNasInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *VdiOnNasInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnNasInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnNasInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this vdi on nas inline protection type based on context it is used
func (m *VdiOnNasInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnNasInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnNasInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res VdiOnNasInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
