// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VdiOnSan A VDI application using SAN.
//
// swagger:model vdi_on_san
type VdiOnSan struct {

	// desktops
	// Required: true
	Desktops *VdiOnSanInlineDesktops `json:"desktops"`

	// The name of the hypervisor hosting the application.
	// Required: true
	// Enum: ["hyper_v","vmware","xen"]
	Hypervisor *string `json:"hypervisor"`

	// The name of the initiator group through which the contents of this application will be accessed. Modification of this parameter is a disruptive operation. All LUNs in the application component will be unmapped from the current igroup and re-mapped to the new igroup.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	IgroupName *string `json:"igroup_name"`

	// protection type
	ProtectionType *VdiOnSanInlineProtectionType `json:"protection_type,omitempty"`

	// The list of initiator groups to create.
	// Max Items: 1
	// Min Items: 0
	VdiOnSanInlineNewIgroups []*VdiOnSanNewIgroups `json:"new_igroups,omitempty"`
}

// Validate validates this vdi on san
func (m *VdiOnSan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDesktops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHypervisor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiOnSanInlineNewIgroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnSan) validateDesktops(formats strfmt.Registry) error {

	if err := validate.Required("desktops", "body", m.Desktops); err != nil {
		return err
	}

	if m.Desktops != nil {
		if err := m.Desktops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops")
			}
			return err
		}
	}

	return nil
}

var vdiOnSanTypeHypervisorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hyper_v","vmware","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnSanTypeHypervisorPropEnum = append(vdiOnSanTypeHypervisorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_san
	// VdiOnSan
	// hypervisor
	// Hypervisor
	// hyper_v
	// END DEBUGGING
	// VdiOnSanHypervisorHyperv captures enum value "hyper_v"
	VdiOnSanHypervisorHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// vdi_on_san
	// VdiOnSan
	// hypervisor
	// Hypervisor
	// vmware
	// END DEBUGGING
	// VdiOnSanHypervisorVmware captures enum value "vmware"
	VdiOnSanHypervisorVmware string = "vmware"

	// BEGIN DEBUGGING
	// vdi_on_san
	// VdiOnSan
	// hypervisor
	// Hypervisor
	// xen
	// END DEBUGGING
	// VdiOnSanHypervisorXen captures enum value "xen"
	VdiOnSanHypervisorXen string = "xen"
)

// prop value enum
func (m *VdiOnSan) validateHypervisorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnSanTypeHypervisorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnSan) validateHypervisor(formats strfmt.Registry) error {

	if err := validate.Required("hypervisor", "body", m.Hypervisor); err != nil {
		return err
	}

	// value enum
	if err := m.validateHypervisorEnum("hypervisor", "body", *m.Hypervisor); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnSan) validateIgroupName(formats strfmt.Registry) error {

	if err := validate.Required("igroup_name", "body", m.IgroupName); err != nil {
		return err
	}

	if err := validate.MinLength("igroup_name", "body", *m.IgroupName, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup_name", "body", *m.IgroupName, 96); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnSan) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnSan) validateVdiOnSanInlineNewIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiOnSanInlineNewIgroups) { // not required
		return nil
	}

	iVdiOnSanInlineNewIgroupsSize := int64(len(m.VdiOnSanInlineNewIgroups))

	if err := validate.MinItems("new_igroups", "body", iVdiOnSanInlineNewIgroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("new_igroups", "body", iVdiOnSanInlineNewIgroupsSize, 1); err != nil {
		return err
	}

	for i := 0; i < len(m.VdiOnSanInlineNewIgroups); i++ {
		if swag.IsZero(m.VdiOnSanInlineNewIgroups[i]) { // not required
			continue
		}

		if m.VdiOnSanInlineNewIgroups[i] != nil {
			if err := m.VdiOnSanInlineNewIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vdi on san based on the context it is used
func (m *VdiOnSan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDesktops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVdiOnSanInlineNewIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnSan) contextValidateDesktops(ctx context.Context, formats strfmt.Registry) error {

	if m.Desktops != nil {
		if err := m.Desktops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnSan) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *VdiOnSan) contextValidateVdiOnSanInlineNewIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VdiOnSanInlineNewIgroups); i++ {

		if m.VdiOnSanInlineNewIgroups[i] != nil {
			if err := m.VdiOnSanInlineNewIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSan) UnmarshalBinary(b []byte) error {
	var res VdiOnSan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnSanInlineDesktops vdi on san inline desktops
//
// swagger:model vdi_on_san_inline_desktops
type VdiOnSanInlineDesktops struct {

	// The number of desktops to support.
	// Maximum: 8000
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The size of the desktops. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *VdiOnSanInlineDesktopsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this vdi on san inline desktops
func (m *VdiOnSanInlineDesktops) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnSanInlineDesktops) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("desktops"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("desktops"+"."+"count", "body", *m.Count, 8000, false); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnSanInlineDesktops) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("desktops"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnSanInlineDesktops) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vdi on san inline desktops based on the context it is used
func (m *VdiOnSanInlineDesktops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnSanInlineDesktops) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("desktops" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSanInlineDesktops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSanInlineDesktops) UnmarshalBinary(b []byte) error {
	var res VdiOnSanInlineDesktops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnSanInlineDesktopsInlineStorageService vdi on san inline desktops inline storage service
//
// swagger:model vdi_on_san_inline_desktops_inline_storage_service
type VdiOnSanInlineDesktopsInlineStorageService struct {

	// The storage service of the desktops.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this vdi on san inline desktops inline storage service
func (m *VdiOnSanInlineDesktopsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var vdiOnSanInlineDesktopsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnSanInlineDesktopsInlineStorageServiceTypeNamePropEnum = append(vdiOnSanInlineDesktopsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_san_inline_desktops_inline_storage_service
	// VdiOnSanInlineDesktopsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// VdiOnSanInlineDesktopsInlineStorageServiceNameExtreme captures enum value "extreme"
	VdiOnSanInlineDesktopsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// vdi_on_san_inline_desktops_inline_storage_service
	// VdiOnSanInlineDesktopsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// VdiOnSanInlineDesktopsInlineStorageServiceNamePerformance captures enum value "performance"
	VdiOnSanInlineDesktopsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// vdi_on_san_inline_desktops_inline_storage_service
	// VdiOnSanInlineDesktopsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// VdiOnSanInlineDesktopsInlineStorageServiceNameValue captures enum value "value"
	VdiOnSanInlineDesktopsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *VdiOnSanInlineDesktopsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnSanInlineDesktopsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnSanInlineDesktopsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("desktops"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this vdi on san inline desktops inline storage service based on context it is used
func (m *VdiOnSanInlineDesktopsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSanInlineDesktopsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSanInlineDesktopsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res VdiOnSanInlineDesktopsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnSanInlineProtectionType vdi on san inline protection type
//
// swagger:model vdi_on_san_inline_protection_type
type VdiOnSanInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this vdi on san inline protection type
func (m *VdiOnSanInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var vdiOnSanInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnSanInlineProtectionTypeTypeLocalRpoPropEnum = append(vdiOnSanInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_san_inline_protection_type
	// VdiOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// VdiOnSanInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	VdiOnSanInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// vdi_on_san_inline_protection_type
	// VdiOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// VdiOnSanInlineProtectionTypeLocalRpoNone captures enum value "none"
	VdiOnSanInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *VdiOnSanInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnSanInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnSanInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var vdiOnSanInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnSanInlineProtectionTypeTypeRemoteRpoPropEnum = append(vdiOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_san_inline_protection_type
	// VdiOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// VdiOnSanInlineProtectionTypeRemoteRpoNone captures enum value "none"
	VdiOnSanInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// vdi_on_san_inline_protection_type
	// VdiOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// VdiOnSanInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	VdiOnSanInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *VdiOnSanInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnSanInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this vdi on san inline protection type based on context it is used
func (m *VdiOnSanInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSanInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSanInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res VdiOnSanInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
