// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VdiOnSanNewIgroups The list of initiator groups to create.
//
// swagger:model vdi_on_san_new_igroups
type VdiOnSanNewIgroups struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The name of the new initiator group.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name"`

	// The protocol of the new initiator group.
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// vdi on san new igroups inline igroups
	VdiOnSanNewIgroupsInlineIgroups []*VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// vdi on san new igroups inline initiator objects
	VdiOnSanNewIgroupsInlineInitiatorObjects []*VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem `json:"initiator_objects,omitempty"`

	// vdi on san new igroups inline initiators
	VdiOnSanNewIgroupsInlineInitiators []*string `json:"initiators,omitempty"`
}

// Validate validates this vdi on san new igroups
func (m *VdiOnSanNewIgroups) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiOnSanNewIgroupsInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiOnSanNewIgroupsInlineInitiatorObjects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnSanNewIgroups) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var vdiOnSanNewIgroupsTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vdiOnSanNewIgroupsTypeProtocolPropEnum = append(vdiOnSanNewIgroupsTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vdi_on_san_new_igroups
	// VdiOnSanNewIgroups
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// VdiOnSanNewIgroupsProtocolFcp captures enum value "fcp"
	VdiOnSanNewIgroupsProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// vdi_on_san_new_igroups
	// VdiOnSanNewIgroups
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// VdiOnSanNewIgroupsProtocolIscsi captures enum value "iscsi"
	VdiOnSanNewIgroupsProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// vdi_on_san_new_igroups
	// VdiOnSanNewIgroups
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// VdiOnSanNewIgroupsProtocolMixed captures enum value "mixed"
	VdiOnSanNewIgroupsProtocolMixed string = "mixed"
)

// prop value enum
func (m *VdiOnSanNewIgroups) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vdiOnSanNewIgroupsTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VdiOnSanNewIgroups) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *VdiOnSanNewIgroups) validateVdiOnSanNewIgroupsInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiOnSanNewIgroupsInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.VdiOnSanNewIgroupsInlineIgroups); i++ {
		if swag.IsZero(m.VdiOnSanNewIgroupsInlineIgroups[i]) { // not required
			continue
		}

		if m.VdiOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.VdiOnSanNewIgroupsInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VdiOnSanNewIgroups) validateVdiOnSanNewIgroupsInlineInitiatorObjects(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiOnSanNewIgroupsInlineInitiatorObjects) { // not required
		return nil
	}

	for i := 0; i < len(m.VdiOnSanNewIgroupsInlineInitiatorObjects); i++ {
		if swag.IsZero(m.VdiOnSanNewIgroupsInlineInitiatorObjects[i]) { // not required
			continue
		}

		if m.VdiOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.VdiOnSanNewIgroupsInlineInitiatorObjects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vdi on san new igroups based on the context it is used
func (m *VdiOnSanNewIgroups) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateVdiOnSanNewIgroupsInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVdiOnSanNewIgroupsInlineInitiatorObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiOnSanNewIgroups) contextValidateVdiOnSanNewIgroupsInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VdiOnSanNewIgroupsInlineIgroups); i++ {

		if m.VdiOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.VdiOnSanNewIgroupsInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VdiOnSanNewIgroups) contextValidateVdiOnSanNewIgroupsInlineInitiatorObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VdiOnSanNewIgroupsInlineInitiatorObjects); i++ {

		if m.VdiOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.VdiOnSanNewIgroupsInlineInitiatorObjects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSanNewIgroups) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSanNewIgroups) UnmarshalBinary(b []byte) error {
	var res VdiOnSanNewIgroups
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem vdi on san new igroups inline igroups inline array item
//
// swagger:model vdi_on_san_new_igroups_inline_igroups_inline_array_item
type VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem struct {

	// The name of an igroup to nest within a parent igroup. Mutually exclusive with initiators and initiator_objects.
	Name *string `json:"name,omitempty"`

	// The UUID of an igroup to nest within a parent igroup Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this vdi on san new igroups inline igroups inline array item
func (m *VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this vdi on san new igroups inline igroups inline array item based on context it is used
func (m *VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VdiOnSanNewIgroupsInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem vdi on san new igroups inline initiator objects inline array item
//
// swagger:model vdi_on_san_new_igroups_inline_initiator_objects_inline_array_item
type VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The WWPN, IQN, or Alias of the initiator. Mutually exclusive with nested igroups and the initiators array.
	Name *string `json:"name,omitempty"`
}

// Validate validates this vdi on san new igroups inline initiator objects inline array item
func (m *VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this vdi on san new igroups inline initiator objects inline array item based on context it is used
func (m *VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VdiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
