// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VdiskSpaceSnapshot vdisk space snapshot
//
// swagger:model vdisk_space_snapshot
type VdiskSpaceSnapshot struct {

	// autodelete
	Autodelete *VdiskSpaceSnapshotInlineAutodelete `json:"autodelete,omitempty"`

	// Size available for snapshots within the snapshot reserve, in bytes.
	// Read Only: true
	ReserveAvailable *int64 `json:"reserve_available,omitempty"`

	// The space that has been reserved for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Size that has been reserved for snapshot usage, in bytes.
	// Read Only: true
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// Percentage of snapshot reserve size that has been used.
	// Read Only: true
	SpaceUsedPercent *int64 `json:"space_used_percent,omitempty"`

	// The total space used by snapshots, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this vdisk space snapshot
func (m *VdiskSpaceSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutodelete(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiskSpaceSnapshot) validateAutodelete(formats strfmt.Registry) error {
	if swag.IsZero(m.Autodelete) { // not required
		return nil
	}

	if m.Autodelete != nil {
		if err := m.Autodelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("autodelete")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vdisk space snapshot based on the context it is used
func (m *VdiskSpaceSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutodelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpaceUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VdiskSpaceSnapshot) contextValidateAutodelete(ctx context.Context, formats strfmt.Registry) error {

	if m.Autodelete != nil {
		if err := m.Autodelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("autodelete")
			}
			return err
		}
	}

	return nil
}

func (m *VdiskSpaceSnapshot) contextValidateReserveAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reserve_available", "body", m.ReserveAvailable); err != nil {
		return err
	}

	return nil
}

func (m *VdiskSpaceSnapshot) contextValidateReserveSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reserve_size", "body", m.ReserveSize); err != nil {
		return err
	}

	return nil
}

func (m *VdiskSpaceSnapshot) contextValidateSpaceUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space_used_percent", "body", m.SpaceUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *VdiskSpaceSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VdiskSpaceSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiskSpaceSnapshot) UnmarshalBinary(b []byte) error {
	var res VdiskSpaceSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VdiskSpaceSnapshotInlineAutodelete vdisk space snapshot inline autodelete
//
// swagger:model vdisk_space_snapshot_inline_autodelete
type VdiskSpaceSnapshotInlineAutodelete struct {

	// Specifies whether snapshot autodelete is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this vdisk space snapshot inline autodelete
func (m *VdiskSpaceSnapshotInlineAutodelete) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this vdisk space snapshot inline autodelete based on context it is used
func (m *VdiskSpaceSnapshotInlineAutodelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VdiskSpaceSnapshotInlineAutodelete) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VdiskSpaceSnapshotInlineAutodelete) UnmarshalBinary(b []byte) error {
	var res VdiskSpaceSnapshotInlineAutodelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
