// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Volume volume
//
// swagger:model volume
type Volume struct {

	// links
	Links *VolumeInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not access time updates are enabled on the volume.
	AccessTimeEnabled *bool `json:"access_time_enabled,omitempty"`

	// activity tracking
	ActivityTracking *VolumeInlineActivityTracking `json:"activity_tracking,omitempty"`

	// Specifies the `aggressive_readahead_mode` enabled on the volume. When set to _file_prefetch_, on a file read, the system aggressively issues readaheads for all of the blocks in the file and retains those blocks in a cache for a finite period of time. When the option is set to _sequential_read_, the system aggressively prefetches the file completely, or to a certain length based on the file size limit, and continues as the read makes progress. If the option is set to _cross_file_sequential_read_, then the system aggressively prefetches multiple files completely, or to a certain length, and continues as the read makes progress.
	// Enum: ["none","file_prefetch","sequential_read","cross_file_sequential_read"]
	AggressiveReadaheadMode *string `json:"aggressive_readahead_mode,omitempty"`

	// analytics
	Analytics *VolumeInlineAnalytics `json:"analytics,omitempty"`

	// anti ransomware
	AntiRansomware *VolumeInlineAntiRansomware `json:"anti_ransomware,omitempty"`

	// application
	Application *VolumeInlineApplication `json:"application,omitempty"`

	// asynchronous directory delete
	AsynchronousDirectoryDelete *VolumeInlineAsynchronousDirectoryDelete `json:"asynchronous_directory_delete,omitempty"`

	// autosize
	Autosize *VolumeInlineAutosize `json:"autosize,omitempty"`

	// clone
	Clone *VolumeInlineClone `json:"clone,omitempty"`

	// This parameter specifies the cloud retrieval policy for the volume. This policy determines which tiered out blocks to retrieve from the capacity tier to the performance tier. The available cloud retrieval policies are
	// "default" policy retrieves tiered data based on the underlying tiering policy. If the tiering policy is 'auto', tiered data is retrieved only for random client driven data reads. If the tiering policy is 'none' or 'snapshot_only', tiered data is retrieved for random and sequential client driven data reads. If the tiering policy is 'all', tiered data is not retrieved.
	// "on_read" policy retrieves tiered data for all client driven data reads.
	// "never" policy never retrieves tiered data.
	// "promote" policy retrieves all eligible tiered data automatically during the next scheduled scan. It is only supported when the tiering policy is 'none' or 'snapshot_only'. If the tiering policy is 'snapshot_only', the only data brought back is the data in the AFS. Data that is only in a snapshot copy stays in the cloud and if tiering policy is 'none' then all data is retrieved.
	//
	// Enum: ["default","on_read","never","promote"]
	CloudRetrievalPolicy *string `json:"cloud_retrieval_policy,omitempty"`

	// Indicates whether or not cloud writes are enabled on the volume. NFS writes to this volume are sent to the cloud directly instead of the local performance tier.
	// This feature is only available on volumes in FabricPools.
	//
	CloudWriteEnabled *bool `json:"cloud_write_enabled,omitempty"`

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *VolumeInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// Specifies the number of total constituents in the FlexGroup volume. Valid for POST, PATCH and GET requests. In volume create (POST), you can alternatively specify the number of constituents in the constituents_per_aggregate parameter and specify the storage availability zone in the aggregates parameter. If none of these values are specified, ONTAP determines the number of constituents to create based on the size of the FlexGroup volume.
	// Minimum: 1
	ConstituentCount *int64 `json:"constituent_count,omitempty"`

	// <personalities supports=unified,asar2>
	// Specifies the number of times to iterate over the aggregates listed with the "aggregates.name" or "aggregates.uuid" when creating or expanding a FlexGroup volume. If a volume is being created on a single aggregate, the system creates a flexible volume if the "constituents_per_aggregate" field is not specified, or a FlexGroup volume if it is specified. If a volume is being created on multiple aggregates, the system always creates a FlexGroup volume. If a volume is being created on multiple aggregates and the "constituents_per_aggregate" field is not specified, the default value of the "constituents_per_aggregate" field is 4. The root constituent of a FlexGroup volume is always placed on the first aggregate in the list, unless 'optimize_aggregates' is specified as 'true'. If the "aggregates.name" or "aggregates.uuid" is specified in a PATCH request to expand an existing FlexGroup volume, the default value of the "constituents_per_aggregate" field is 1. The volume expand operation is only supported on FlexGroup volumes.
	// </personalities>
	// <personalities supports=aiml>
	// Optional. Only supported in volume create (POST), and specifies how many constituents the FlexGroup volume should have. If supplied, the aggregates must also be supplied, and it must contain only the storage availability zone. Provided for backward-compatibility only. Using constituent_count instead of it and aggregates is always preferred.
	// </personalities>
	//
	// Maximum: 1000
	// Minimum: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// Specifies whether directory Unicode format conversion is enabled when directories are accessed by NFS clients.
	ConvertUnicode *bool `json:"convert_unicode,omitempty"`

	// Creation time of the volume. This field is generated when the volume is created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// efficiency
	Efficiency *VolumeInlineEfficiency `json:"efficiency,omitempty"`

	// encryption
	Encryption *VolumeInlineEncryption `json:"encryption,omitempty"`

	// error state
	ErrorState *VolumeInlineErrorState `json:"error_state,omitempty"`

	// files
	Files *VolumeInlineFiles `json:"files,omitempty"`

	// flash pool
	FlashPool *VolumeInlineFlashPool `json:"flash_pool,omitempty"`

	// FlexCache endpoint type. <br>none &dash; The volume is neither a FlexCache nor origin of any FlexCache. <br>cache &dash; The volume is a FlexCache volume. <br>origin &dash; The volume is origin of a FlexCache volume.
	// Read Only: true
	// Enum: ["none","cache","origin"]
	FlexcacheEndpointType *string `json:"flexcache_endpoint_type,omitempty"`

	// flexgroup
	Flexgroup *VolumeInlineFlexgroup `json:"flexgroup,omitempty"`

	// State of granular data on the volume. This setting is `true` by default when creating an AWS S3 FlexGroup volume via a POST request and `false` by default for creating any other type of FlexGroup volume via a POST request. On FlexVol volumes, the setting is always `false`, as only FlexGroup volumes support this feature. Once enabled, this setting can only be disabled by restoring a snapshot. Earlier versions of ONTAP (pre 9.12) are not compatible with this feature. Therefore, reverting to an earlier version of ONTAP is not possible unless this volume is deleted or restored to a snapshot that was taken before the setting was enabled.
	GranularData *bool `json:"granular_data,omitempty"`

	// Mode of granular data on the volume. This setting defaults to `basic` when the `granular_data` parameter is set to `true`, but can be specified at the time of creation via a POST request. Earlier versions of ONTAP (pre 9.12) are not compatible with the `basic` setting. Therefore, when set to `basic`, reverting to an earlier version of ONTAP is not possible unless this volume is deleted or restored to a snapshot that was taken before the `basic` mode was enabled. Earlier versions of ONTAP (pre 9.16) are not compatible with the `advanced` setting. Therefore, when set to `advanced`, reverting to an earlier version of ONTAP is not possible unless this volume is deleted or restored to a snapshot that was taken before the `advanced` mode was enabled.
	// Enum: ["disabled","basic","advanced"]
	GranularDataMode *string `json:"granular_data_mode,omitempty"`

	// guarantee
	Guarantee *VolumeInlineGuarantee `json:"guarantee,omitempty"`

	// Specifies whether the volume has directories with public index files.
	HasDirIndexPublic *bool `json:"has_dir_index_public,omitempty"`

	// Specifies whether the volume has directories bigger than 4GB.
	HasLargeDir *bool `json:"has_large_dir,omitempty"`

	// When set to true, this field enables support for directory index transfer.
	IsDirIndexTransferEnabled *bool `json:"is_dir_index_transfer_enabled,omitempty"`

	// When set to true, this field enables the large directory feature on a volume.
	IsLargeDirEnabled *bool `json:"is_large_dir_enabled,omitempty"`

	// Specifies whether the volume is provisioned for an object store server.
	// Read Only: true
	IsObjectStore *bool `json:"is_object_store,omitempty"`

	// Specifies that the volume should allow Amazon S3 multipart uploads with arbitrary part lengths. This is only supported for FlexGroup volumes with `advanced` granular_data. The default value is `false`. When set to `true`, it cannot be reverted to `false`. Clusters with any volumes where this is `true` cannot be reverted to a release that does not support this feature.
	IsS3ArbitraryPartSizeEnabled *bool `json:"is_s3_arbitrary_part_size_enabled,omitempty"`

	// Specifies whether the volume is a root volume of the SVM it belongs to.
	// Read Only: true
	IsSvmRoot *bool `json:"is_svm_root,omitempty"`

	// Language encoding setting for volume. If no language is specified, the volume inherits its SVM language encoding setting.
	// Enum: ["ar","ar.utf_8","c","c.utf_8","cs","cs.utf_8","da","da.utf_8","de","de.utf_8","en","en.utf_8","en_us","en_us.utf_8","es","es.utf_8","fi","fi.utf_8","fr","fr.utf_8","he","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it","it.utf_8","ja","ja.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck","ja_jp.pck.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ja_v1","ja_v1.utf_8","ko","ko.utf_8","nl","nl.utf_8","no","no.utf_8","pl","pl.utf_8","pt","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv","sv.utf_8","tr","tr.utf_8","utf8mb4","zh","zh.gbk","zh.gbk.utf_8","zh.utf_8","zh_tw","zh_tw.big5","zh_tw.big5.utf_8","zh_tw.utf_8"]
	Language *string `json:"language,omitempty"`

	// Maximum directory size. This value sets maximum size, in bytes, to which a directory can grow. The default maximum directory size for FlexVol volumes is model-dependent, and optimized for the size of system memory. Before increasing the maximum directory size, involve technical support.
	MaxDirSize *int64 `json:"max_dir_size,omitempty"`

	// metric
	Metric *VolumeInlineMetric `json:"metric,omitempty"`

	// movement
	Movement *VolumeInlineMovement `json:"movement,omitempty"`

	// The volume's Master Set ID.
	Msid *int64 `json:"msid,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *VolumeInlineNas `json:"nas,omitempty"`

	// Specifies whether to create the constituents of the FlexGroup volume on the aggregates specified in the order they are specified, or whether the system should optimize the ordering of the aggregates. If this value is 'true', the system optimizes the ordering of the aggregates specified. If this value is false, the order of the aggregates is unchanged. The default value is 'false'.
	OptimizeAggregates *bool `json:"optimize_aggregates,omitempty"`

	// qos
	Qos *VolumeInlineQos `json:"qos,omitempty"`

	// Specifies whether the volume is queued for encryption.
	QueueForEncryption *bool `json:"queue_for_encryption,omitempty"`

	// quota
	Quota *VolumeInlineQuota `json:"quota,omitempty"`

	// rebalancing
	Rebalancing *VolumeInlineRebalancing `json:"rebalancing,omitempty"`

	// Naming Scheme for automatic snapshots:
	// * create_time - Automatic snapshots are saved as per the start of their current date and time.
	// * ordinal - Latest automatic snapshot copy is saved as <scheduled_frequency>.0 and subsequent copies will follow the create_time naming convention.
	//
	// Enum: ["create_time","ordinal"]
	ScheduledSnapshotNamingScheme *string `json:"scheduled_snapshot_naming_scheme,omitempty"`

	// Physical size of the volume, in bytes. The minimum size for a FlexVol volume is 20MB and the minimum size for a FlexGroup volume is 200MB per constituent. The recommended size for a FlexGroup volume is a minimum of 100GB per constituent. For all volumes, the default size is equal to the minimum size.
	Size *int64 `json:"size,omitempty"`

	// When expanding a FlexGroup volume, this specifies whether to add new constituents, or to resize the current constituents.
	// Enum: ["use_existing_resources","add_new_resources"]
	SizingMethod *string `json:"sizing_method,omitempty"`

	// snaplock
	Snaplock *VolumeInlineSnaplock `json:"snaplock,omitempty"`

	// snapmirror
	Snapmirror *VolumeInlineSnapmirror `json:"snapmirror,omitempty"`

	// Number of snapshots in the volume.
	// Read Only: true
	// Maximum: 1023
	// Minimum: 0
	SnapshotCount *int64 `json:"snapshot_count,omitempty"`

	// This field, if true, enables the visible ".snapshot" directory from the client. The ".snapshot" directory will be available in every directory on the volume.
	SnapshotDirectoryAccessEnabled *bool `json:"snapshot_directory_access_enabled,omitempty"`

	// Specifies whether or not snapshot copy locking is enabled on the volume.
	SnapshotLockingEnabled *bool `json:"snapshot_locking_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *VolumeInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// space
	Space *VolumeInlineSpace `json:"space,omitempty"`

	// Volume state. Client access is supported only when volume is online and junctioned. Taking volume to offline or restricted state removes its junction path and blocks client access. When volume is in restricted state some operations like parity reconstruction and iron on commit are allowed. The 'mixed' state applies to FlexGroup volumes only and cannot be specified as a target state. An 'error' state implies that the volume is not in a state to serve data.
	// Enum: ["error","mixed","offline","online","restricted"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *VolumeInlineStatistics `json:"statistics,omitempty"`

	// The style of the volume. If "style" is not specified, the volume type is determined based on the specified aggregates or license. Specifying a single aggregate, without "constituents_per_aggregate", creates a flexible volume. Specifying multiple aggregates, or a single aggregate with "constituents_per_aggregate", creates a FlexGroup volume. When the UDO License is installed, and no aggregates are specified, the system automatically provisions a FlexGroup volume on system selected aggregates. Specifying a volume "style" creates a volume of that type. For example, if the style is "flexvol", you must specify a single aggregate. If the style is "flexgroup", the system either uses the specified aggregates or automatically provisions aggregates if there are no specified aggregates. The style "flexgroup_constituent" is not supported when creating a volume.<br>flexvol &dash; flexible volumes and FlexClone volumes<br>flexgroup &dash; FlexGroup volumes<br>flexgroup_constituent &dash; FlexGroup volume constituents.
	// Enum: ["flexvol","flexgroup","flexgroup_constituent"]
	Style *string `json:"style,omitempty"`

	// svm
	Svm *VolumeInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *VolumeInlineTiering `json:"tiering,omitempty"`

	// Type of the volume.<br>rw &dash; read-write volume.<br>dp &dash; data-protection volume.<br>ls &dash; load-sharing `dp` volume. Valid in GET.
	// Enum: ["rw","dp","ls"]
	Type *string `json:"type,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning a FlexGroup without specifying "aggregates.name" or "aggregates.uuid". Only mirrored aggregates are used if this parameter is set to 'true' and only unmirrored aggregates are used if this parameter is set to 'false'. Aggregate level mirroring for a FlexGroup volume can be changed by moving all of the constituents to the required aggregates. The default value is 'true' for a MetroCluster configuration and is 'false' for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Validate the volume move or volume conversion operations and their parameters, without actually performing the operation.
	ValidateOnly *bool `json:"validate_only,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VolumeInlineTags []*string `json:"_tags,omitempty"`

	// <personalities supports=unified,asar2>
	// Aggregate(s) hosting the volume. Optional.
	// </personalities>
	// <personalities supports=aiml>
	// Optional. Only supported in volume create (POST), and must hold only the storage availability zone. If supplied, the constituents_per_aggregate must also be supplied. Provided for backward-compatibility only. Using constituent_count instead of it and constituents_per_aggregate is always preferred.
	// </personalities>
	//
	VolumeInlineAggregates []*VolumeInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// FlexGroup volume constituents. FlexGroup volume constituents can be retrieved more efficiently by specifying "is_constituent=true" or "is_constituent=true&flexgroup.uuid=<flexgroup.uuid>" as query parameters.
	VolumeInlineConstituents []*VolumeInlineConstituentsInlineArrayItem `json:"constituents,omitempty"`

	// List of the nodes hosting the volume.
	VolumeInlineNodes []*VolumeInlineNodesInlineArrayItem `json:"nodes,omitempty"`

	// Describes the current status of a volume.
	// Read Only: true
	VolumeInlineStatus []*string `json:"status,omitempty"`
}

// Validate validates this volume
func (m *Volume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggressiveReadaheadMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAnalytics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAntiRansomware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAsynchronousDirectoryDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutosize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudRetrievalPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConstituentCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConstituentsPerAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlashPool(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcacheEndpointType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGranularDataMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLanguage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuota(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRebalancing(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduledSnapshotNamingScheme(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSizingMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirror(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeInlineConstituents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Volume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateActivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(m.ActivityTracking) { // not required
		return nil
	}

	if m.ActivityTracking != nil {
		if err := m.ActivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("activity_tracking")
			}
			return err
		}
	}

	return nil
}

var volumeTypeAggressiveReadaheadModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","file_prefetch","sequential_read","cross_file_sequential_read"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeAggressiveReadaheadModePropEnum = append(volumeTypeAggressiveReadaheadModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// none
	// END DEBUGGING
	// VolumeAggressiveReadaheadModeNone captures enum value "none"
	VolumeAggressiveReadaheadModeNone string = "none"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// file_prefetch
	// END DEBUGGING
	// VolumeAggressiveReadaheadModeFilePrefetch captures enum value "file_prefetch"
	VolumeAggressiveReadaheadModeFilePrefetch string = "file_prefetch"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// sequential_read
	// END DEBUGGING
	// VolumeAggressiveReadaheadModeSequentialRead captures enum value "sequential_read"
	VolumeAggressiveReadaheadModeSequentialRead string = "sequential_read"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// aggressive_readahead_mode
	// AggressiveReadaheadMode
	// cross_file_sequential_read
	// END DEBUGGING
	// VolumeAggressiveReadaheadModeCrossFileSequentialRead captures enum value "cross_file_sequential_read"
	VolumeAggressiveReadaheadModeCrossFileSequentialRead string = "cross_file_sequential_read"
)

// prop value enum
func (m *Volume) validateAggressiveReadaheadModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeAggressiveReadaheadModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateAggressiveReadaheadMode(formats strfmt.Registry) error {
	if swag.IsZero(m.AggressiveReadaheadMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateAggressiveReadaheadModeEnum("aggressive_readahead_mode", "body", *m.AggressiveReadaheadMode); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateAnalytics(formats strfmt.Registry) error {
	if swag.IsZero(m.Analytics) { // not required
		return nil
	}

	if m.Analytics != nil {
		if err := m.Analytics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateAntiRansomware(formats strfmt.Registry) error {
	if swag.IsZero(m.AntiRansomware) { // not required
		return nil
	}

	if m.AntiRansomware != nil {
		if err := m.AntiRansomware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateAsynchronousDirectoryDelete(formats strfmt.Registry) error {
	if swag.IsZero(m.AsynchronousDirectoryDelete) { // not required
		return nil
	}

	if m.AsynchronousDirectoryDelete != nil {
		if err := m.AsynchronousDirectoryDelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("asynchronous_directory_delete")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateAutosize(formats strfmt.Registry) error {
	if swag.IsZero(m.Autosize) { // not required
		return nil
	}

	if m.Autosize != nil {
		if err := m.Autosize.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("autosize")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

var volumeTypeCloudRetrievalPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","on_read","never","promote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeCloudRetrievalPolicyPropEnum = append(volumeTypeCloudRetrievalPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// default
	// END DEBUGGING
	// VolumeCloudRetrievalPolicyDefault captures enum value "default"
	VolumeCloudRetrievalPolicyDefault string = "default"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// on_read
	// END DEBUGGING
	// VolumeCloudRetrievalPolicyOnRead captures enum value "on_read"
	VolumeCloudRetrievalPolicyOnRead string = "on_read"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// never
	// END DEBUGGING
	// VolumeCloudRetrievalPolicyNever captures enum value "never"
	VolumeCloudRetrievalPolicyNever string = "never"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// cloud_retrieval_policy
	// CloudRetrievalPolicy
	// promote
	// END DEBUGGING
	// VolumeCloudRetrievalPolicyPromote captures enum value "promote"
	VolumeCloudRetrievalPolicyPromote string = "promote"
)

// prop value enum
func (m *Volume) validateCloudRetrievalPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeCloudRetrievalPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateCloudRetrievalPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudRetrievalPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateCloudRetrievalPolicyEnum("cloud_retrieval_policy", "body", *m.CloudRetrievalPolicy); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroup) { // not required
		return nil
	}

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateConstituentCount(formats strfmt.Registry) error {
	if swag.IsZero(m.ConstituentCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("constituent_count", "body", *m.ConstituentCount, 1, false); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateConstituentsPerAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.ConstituentsPerAggregate) { // not required
		return nil
	}

	if err := validate.MinimumInt("constituents_per_aggregate", "body", *m.ConstituentsPerAggregate, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("constituents_per_aggregate", "body", *m.ConstituentsPerAggregate, 1000, false); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateEfficiency(formats strfmt.Registry) error {
	if swag.IsZero(m.Efficiency) { // not required
		return nil
	}

	if m.Efficiency != nil {
		if err := m.Efficiency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateErrorState(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorState) { // not required
		return nil
	}

	if m.ErrorState != nil {
		if err := m.ErrorState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error_state")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.Files) { // not required
		return nil
	}

	if m.Files != nil {
		if err := m.Files.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateFlashPool(formats strfmt.Registry) error {
	if swag.IsZero(m.FlashPool) { // not required
		return nil
	}

	if m.FlashPool != nil {
		if err := m.FlashPool.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flash_pool")
			}
			return err
		}
	}

	return nil
}

var volumeTypeFlexcacheEndpointTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","cache","origin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeFlexcacheEndpointTypePropEnum = append(volumeTypeFlexcacheEndpointTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// flexcache_endpoint_type
	// FlexcacheEndpointType
	// none
	// END DEBUGGING
	// VolumeFlexcacheEndpointTypeNone captures enum value "none"
	VolumeFlexcacheEndpointTypeNone string = "none"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// flexcache_endpoint_type
	// FlexcacheEndpointType
	// cache
	// END DEBUGGING
	// VolumeFlexcacheEndpointTypeCache captures enum value "cache"
	VolumeFlexcacheEndpointTypeCache string = "cache"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// flexcache_endpoint_type
	// FlexcacheEndpointType
	// origin
	// END DEBUGGING
	// VolumeFlexcacheEndpointTypeOrigin captures enum value "origin"
	VolumeFlexcacheEndpointTypeOrigin string = "origin"
)

// prop value enum
func (m *Volume) validateFlexcacheEndpointTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeFlexcacheEndpointTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateFlexcacheEndpointType(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexcacheEndpointType) { // not required
		return nil
	}

	// value enum
	if err := m.validateFlexcacheEndpointTypeEnum("flexcache_endpoint_type", "body", *m.FlexcacheEndpointType); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateFlexgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexgroup) { // not required
		return nil
	}

	if m.Flexgroup != nil {
		if err := m.Flexgroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexgroup")
			}
			return err
		}
	}

	return nil
}

var volumeTypeGranularDataModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","basic","advanced"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeGranularDataModePropEnum = append(volumeTypeGranularDataModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// granular_data_mode
	// GranularDataMode
	// disabled
	// END DEBUGGING
	// VolumeGranularDataModeDisabled captures enum value "disabled"
	VolumeGranularDataModeDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// granular_data_mode
	// GranularDataMode
	// basic
	// END DEBUGGING
	// VolumeGranularDataModeBasic captures enum value "basic"
	VolumeGranularDataModeBasic string = "basic"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// granular_data_mode
	// GranularDataMode
	// advanced
	// END DEBUGGING
	// VolumeGranularDataModeAdvanced captures enum value "advanced"
	VolumeGranularDataModeAdvanced string = "advanced"
)

// prop value enum
func (m *Volume) validateGranularDataModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeGranularDataModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateGranularDataMode(formats strfmt.Registry) error {
	if swag.IsZero(m.GranularDataMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateGranularDataModeEnum("granular_data_mode", "body", *m.GranularDataMode); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guarantee")
			}
			return err
		}
	}

	return nil
}

var volumeTypeLanguagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ar","ar.utf_8","c","c.utf_8","cs","cs.utf_8","da","da.utf_8","de","de.utf_8","en","en.utf_8","en_us","en_us.utf_8","es","es.utf_8","fi","fi.utf_8","fr","fr.utf_8","he","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it","it.utf_8","ja","ja.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck","ja_jp.pck.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ja_v1","ja_v1.utf_8","ko","ko.utf_8","nl","nl.utf_8","no","no.utf_8","pl","pl.utf_8","pt","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv","sv.utf_8","tr","tr.utf_8","utf8mb4","zh","zh.gbk","zh.gbk.utf_8","zh.utf_8","zh_tw","zh_tw.big5","zh_tw.big5.utf_8","zh_tw.utf_8"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeLanguagePropEnum = append(volumeTypeLanguagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ar
	// END DEBUGGING
	// VolumeLanguageAr captures enum value "ar"
	VolumeLanguageAr string = "ar"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ar.utf_8
	// END DEBUGGING
	// VolumeLanguageArDotUTF8 captures enum value "ar.utf_8"
	VolumeLanguageArDotUTF8 string = "ar.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// c
	// END DEBUGGING
	// VolumeLanguageC captures enum value "c"
	VolumeLanguageC string = "c"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// c.utf_8
	// END DEBUGGING
	// VolumeLanguageCDotUTF8 captures enum value "c.utf_8"
	VolumeLanguageCDotUTF8 string = "c.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// cs
	// END DEBUGGING
	// VolumeLanguageCs captures enum value "cs"
	VolumeLanguageCs string = "cs"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// cs.utf_8
	// END DEBUGGING
	// VolumeLanguageCsDotUTF8 captures enum value "cs.utf_8"
	VolumeLanguageCsDotUTF8 string = "cs.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// da
	// END DEBUGGING
	// VolumeLanguageDa captures enum value "da"
	VolumeLanguageDa string = "da"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// da.utf_8
	// END DEBUGGING
	// VolumeLanguageDaDotUTF8 captures enum value "da.utf_8"
	VolumeLanguageDaDotUTF8 string = "da.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// de
	// END DEBUGGING
	// VolumeLanguageDe captures enum value "de"
	VolumeLanguageDe string = "de"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// de.utf_8
	// END DEBUGGING
	// VolumeLanguageDeDotUTF8 captures enum value "de.utf_8"
	VolumeLanguageDeDotUTF8 string = "de.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// en
	// END DEBUGGING
	// VolumeLanguageEn captures enum value "en"
	VolumeLanguageEn string = "en"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// en.utf_8
	// END DEBUGGING
	// VolumeLanguageEnDotUTF8 captures enum value "en.utf_8"
	VolumeLanguageEnDotUTF8 string = "en.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// en_us
	// END DEBUGGING
	// VolumeLanguageEnUs captures enum value "en_us"
	VolumeLanguageEnUs string = "en_us"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// en_us.utf_8
	// END DEBUGGING
	// VolumeLanguageEnUsDotUTF8 captures enum value "en_us.utf_8"
	VolumeLanguageEnUsDotUTF8 string = "en_us.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// es
	// END DEBUGGING
	// VolumeLanguageEs captures enum value "es"
	VolumeLanguageEs string = "es"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// es.utf_8
	// END DEBUGGING
	// VolumeLanguageEsDotUTF8 captures enum value "es.utf_8"
	VolumeLanguageEsDotUTF8 string = "es.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// fi
	// END DEBUGGING
	// VolumeLanguageFi captures enum value "fi"
	VolumeLanguageFi string = "fi"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// fi.utf_8
	// END DEBUGGING
	// VolumeLanguageFiDotUTF8 captures enum value "fi.utf_8"
	VolumeLanguageFiDotUTF8 string = "fi.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// fr
	// END DEBUGGING
	// VolumeLanguageFr captures enum value "fr"
	VolumeLanguageFr string = "fr"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// fr.utf_8
	// END DEBUGGING
	// VolumeLanguageFrDotUTF8 captures enum value "fr.utf_8"
	VolumeLanguageFrDotUTF8 string = "fr.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// he
	// END DEBUGGING
	// VolumeLanguageHe captures enum value "he"
	VolumeLanguageHe string = "he"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// he.utf_8
	// END DEBUGGING
	// VolumeLanguageHeDotUTF8 captures enum value "he.utf_8"
	VolumeLanguageHeDotUTF8 string = "he.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// hr
	// END DEBUGGING
	// VolumeLanguageHr captures enum value "hr"
	VolumeLanguageHr string = "hr"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// hr.utf_8
	// END DEBUGGING
	// VolumeLanguageHrDotUTF8 captures enum value "hr.utf_8"
	VolumeLanguageHrDotUTF8 string = "hr.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// hu
	// END DEBUGGING
	// VolumeLanguageHu captures enum value "hu"
	VolumeLanguageHu string = "hu"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// hu.utf_8
	// END DEBUGGING
	// VolumeLanguageHuDotUTF8 captures enum value "hu.utf_8"
	VolumeLanguageHuDotUTF8 string = "hu.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// it
	// END DEBUGGING
	// VolumeLanguageIt captures enum value "it"
	VolumeLanguageIt string = "it"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// it.utf_8
	// END DEBUGGING
	// VolumeLanguageItDotUTF8 captures enum value "it.utf_8"
	VolumeLanguageItDotUTF8 string = "it.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja
	// END DEBUGGING
	// VolumeLanguageJa captures enum value "ja"
	VolumeLanguageJa string = "ja"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja.utf_8
	// END DEBUGGING
	// VolumeLanguageJaDotUTF8 captures enum value "ja.utf_8"
	VolumeLanguageJaDotUTF8 string = "ja.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_jp.932
	// END DEBUGGING
	// VolumeLanguageJaJpDot932 captures enum value "ja_jp.932"
	VolumeLanguageJaJpDot932 string = "ja_jp.932"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_jp.932.utf_8
	// END DEBUGGING
	// VolumeLanguageJaJpDot932DotUTF8 captures enum value "ja_jp.932.utf_8"
	VolumeLanguageJaJpDot932DotUTF8 string = "ja_jp.932.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_jp.pck
	// END DEBUGGING
	// VolumeLanguageJaJpDotPck captures enum value "ja_jp.pck"
	VolumeLanguageJaJpDotPck string = "ja_jp.pck"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_jp.pck.utf_8
	// END DEBUGGING
	// VolumeLanguageJaJpDotPckDotUTF8 captures enum value "ja_jp.pck.utf_8"
	VolumeLanguageJaJpDotPckDotUTF8 string = "ja_jp.pck.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_jp.pck_v2
	// END DEBUGGING
	// VolumeLanguageJaJpDotPckV2 captures enum value "ja_jp.pck_v2"
	VolumeLanguageJaJpDotPckV2 string = "ja_jp.pck_v2"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_jp.pck_v2.utf_8
	// END DEBUGGING
	// VolumeLanguageJaJpDotPckV2DotUTF8 captures enum value "ja_jp.pck_v2.utf_8"
	VolumeLanguageJaJpDotPckV2DotUTF8 string = "ja_jp.pck_v2.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_v1
	// END DEBUGGING
	// VolumeLanguageJaV1 captures enum value "ja_v1"
	VolumeLanguageJaV1 string = "ja_v1"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ja_v1.utf_8
	// END DEBUGGING
	// VolumeLanguageJaV1DotUTF8 captures enum value "ja_v1.utf_8"
	VolumeLanguageJaV1DotUTF8 string = "ja_v1.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ko
	// END DEBUGGING
	// VolumeLanguageKo captures enum value "ko"
	VolumeLanguageKo string = "ko"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ko.utf_8
	// END DEBUGGING
	// VolumeLanguageKoDotUTF8 captures enum value "ko.utf_8"
	VolumeLanguageKoDotUTF8 string = "ko.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// nl
	// END DEBUGGING
	// VolumeLanguageNl captures enum value "nl"
	VolumeLanguageNl string = "nl"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// nl.utf_8
	// END DEBUGGING
	// VolumeLanguageNlDotUTF8 captures enum value "nl.utf_8"
	VolumeLanguageNlDotUTF8 string = "nl.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// no
	// END DEBUGGING
	// VolumeLanguageNo captures enum value "no"
	VolumeLanguageNo string = "no"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// no.utf_8
	// END DEBUGGING
	// VolumeLanguageNoDotUTF8 captures enum value "no.utf_8"
	VolumeLanguageNoDotUTF8 string = "no.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// pl
	// END DEBUGGING
	// VolumeLanguagePl captures enum value "pl"
	VolumeLanguagePl string = "pl"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// pl.utf_8
	// END DEBUGGING
	// VolumeLanguagePlDotUTF8 captures enum value "pl.utf_8"
	VolumeLanguagePlDotUTF8 string = "pl.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// pt
	// END DEBUGGING
	// VolumeLanguagePt captures enum value "pt"
	VolumeLanguagePt string = "pt"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// pt.utf_8
	// END DEBUGGING
	// VolumeLanguagePtDotUTF8 captures enum value "pt.utf_8"
	VolumeLanguagePtDotUTF8 string = "pt.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ro
	// END DEBUGGING
	// VolumeLanguageRo captures enum value "ro"
	VolumeLanguageRo string = "ro"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ro.utf_8
	// END DEBUGGING
	// VolumeLanguageRoDotUTF8 captures enum value "ro.utf_8"
	VolumeLanguageRoDotUTF8 string = "ro.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ru
	// END DEBUGGING
	// VolumeLanguageRu captures enum value "ru"
	VolumeLanguageRu string = "ru"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// ru.utf_8
	// END DEBUGGING
	// VolumeLanguageRuDotUTF8 captures enum value "ru.utf_8"
	VolumeLanguageRuDotUTF8 string = "ru.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// sk
	// END DEBUGGING
	// VolumeLanguageSk captures enum value "sk"
	VolumeLanguageSk string = "sk"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// sk.utf_8
	// END DEBUGGING
	// VolumeLanguageSkDotUTF8 captures enum value "sk.utf_8"
	VolumeLanguageSkDotUTF8 string = "sk.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// sl
	// END DEBUGGING
	// VolumeLanguageSl captures enum value "sl"
	VolumeLanguageSl string = "sl"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// sl.utf_8
	// END DEBUGGING
	// VolumeLanguageSlDotUTF8 captures enum value "sl.utf_8"
	VolumeLanguageSlDotUTF8 string = "sl.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// sv
	// END DEBUGGING
	// VolumeLanguageSv captures enum value "sv"
	VolumeLanguageSv string = "sv"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// sv.utf_8
	// END DEBUGGING
	// VolumeLanguageSvDotUTF8 captures enum value "sv.utf_8"
	VolumeLanguageSvDotUTF8 string = "sv.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// tr
	// END DEBUGGING
	// VolumeLanguageTr captures enum value "tr"
	VolumeLanguageTr string = "tr"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// tr.utf_8
	// END DEBUGGING
	// VolumeLanguageTrDotUTF8 captures enum value "tr.utf_8"
	VolumeLanguageTrDotUTF8 string = "tr.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// utf8mb4
	// END DEBUGGING
	// VolumeLanguageUtf8mb4 captures enum value "utf8mb4"
	VolumeLanguageUtf8mb4 string = "utf8mb4"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh
	// END DEBUGGING
	// VolumeLanguageZh captures enum value "zh"
	VolumeLanguageZh string = "zh"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh.gbk
	// END DEBUGGING
	// VolumeLanguageZhDotGbk captures enum value "zh.gbk"
	VolumeLanguageZhDotGbk string = "zh.gbk"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh.gbk.utf_8
	// END DEBUGGING
	// VolumeLanguageZhDotGbkDotUTF8 captures enum value "zh.gbk.utf_8"
	VolumeLanguageZhDotGbkDotUTF8 string = "zh.gbk.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh.utf_8
	// END DEBUGGING
	// VolumeLanguageZhDotUTF8 captures enum value "zh.utf_8"
	VolumeLanguageZhDotUTF8 string = "zh.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh_tw
	// END DEBUGGING
	// VolumeLanguageZhTw captures enum value "zh_tw"
	VolumeLanguageZhTw string = "zh_tw"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh_tw.big5
	// END DEBUGGING
	// VolumeLanguageZhTwDotBig5 captures enum value "zh_tw.big5"
	VolumeLanguageZhTwDotBig5 string = "zh_tw.big5"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh_tw.big5.utf_8
	// END DEBUGGING
	// VolumeLanguageZhTwDotBig5DotUTF8 captures enum value "zh_tw.big5.utf_8"
	VolumeLanguageZhTwDotBig5DotUTF8 string = "zh_tw.big5.utf_8"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// language
	// Language
	// zh_tw.utf_8
	// END DEBUGGING
	// VolumeLanguageZhTwDotUTF8 captures enum value "zh_tw.utf_8"
	VolumeLanguageZhTwDotUTF8 string = "zh_tw.utf_8"
)

// prop value enum
func (m *Volume) validateLanguageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeLanguagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateLanguage(formats strfmt.Registry) error {
	if swag.IsZero(m.Language) { // not required
		return nil
	}

	// value enum
	if err := m.validateLanguageEnum("language", "body", *m.Language); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(m.Movement) { // not required
		return nil
	}

	if m.Movement != nil {
		if err := m.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateQuota(formats strfmt.Registry) error {
	if swag.IsZero(m.Quota) { // not required
		return nil
	}

	if m.Quota != nil {
		if err := m.Quota.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("quota")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateRebalancing(formats strfmt.Registry) error {
	if swag.IsZero(m.Rebalancing) { // not required
		return nil
	}

	if m.Rebalancing != nil {
		if err := m.Rebalancing.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing")
			}
			return err
		}
	}

	return nil
}

var volumeTypeScheduledSnapshotNamingSchemePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create_time","ordinal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeScheduledSnapshotNamingSchemePropEnum = append(volumeTypeScheduledSnapshotNamingSchemePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// scheduled_snapshot_naming_scheme
	// ScheduledSnapshotNamingScheme
	// create_time
	// END DEBUGGING
	// VolumeScheduledSnapshotNamingSchemeCreateTime captures enum value "create_time"
	VolumeScheduledSnapshotNamingSchemeCreateTime string = "create_time"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// scheduled_snapshot_naming_scheme
	// ScheduledSnapshotNamingScheme
	// ordinal
	// END DEBUGGING
	// VolumeScheduledSnapshotNamingSchemeOrdinal captures enum value "ordinal"
	VolumeScheduledSnapshotNamingSchemeOrdinal string = "ordinal"
)

// prop value enum
func (m *Volume) validateScheduledSnapshotNamingSchemeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeScheduledSnapshotNamingSchemePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateScheduledSnapshotNamingScheme(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduledSnapshotNamingScheme) { // not required
		return nil
	}

	// value enum
	if err := m.validateScheduledSnapshotNamingSchemeEnum("scheduled_snapshot_naming_scheme", "body", *m.ScheduledSnapshotNamingScheme); err != nil {
		return err
	}

	return nil
}

var volumeTypeSizingMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["use_existing_resources","add_new_resources"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeSizingMethodPropEnum = append(volumeTypeSizingMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// sizing_method
	// SizingMethod
	// use_existing_resources
	// END DEBUGGING
	// VolumeSizingMethodUseExistingResources captures enum value "use_existing_resources"
	VolumeSizingMethodUseExistingResources string = "use_existing_resources"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// sizing_method
	// SizingMethod
	// add_new_resources
	// END DEBUGGING
	// VolumeSizingMethodAddNewResources captures enum value "add_new_resources"
	VolumeSizingMethodAddNewResources string = "add_new_resources"
)

// prop value enum
func (m *Volume) validateSizingMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeSizingMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateSizingMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.SizingMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateSizingMethodEnum("sizing_method", "body", *m.SizingMethod); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateSnapmirror(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapmirror) { // not required
		return nil
	}

	if m.Snapmirror != nil {
		if err := m.Snapmirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapmirror")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateSnapshotCount(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("snapshot_count", "body", *m.SnapshotCount, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("snapshot_count", "body", *m.SnapshotCount, 1023, false); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var volumeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["error","mixed","offline","online","restricted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeStatePropEnum = append(volumeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// state
	// State
	// error
	// END DEBUGGING
	// VolumeStateError captures enum value "error"
	VolumeStateError string = "error"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// state
	// State
	// mixed
	// END DEBUGGING
	// VolumeStateMixed captures enum value "mixed"
	VolumeStateMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// state
	// State
	// offline
	// END DEBUGGING
	// VolumeStateOffline captures enum value "offline"
	VolumeStateOffline string = "offline"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// state
	// State
	// online
	// END DEBUGGING
	// VolumeStateOnline captures enum value "online"
	VolumeStateOnline string = "online"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// state
	// State
	// restricted
	// END DEBUGGING
	// VolumeStateRestricted captures enum value "restricted"
	VolumeStateRestricted string = "restricted"
)

// prop value enum
func (m *Volume) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

var volumeTypeStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["flexvol","flexgroup","flexgroup_constituent"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeStylePropEnum = append(volumeTypeStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// style
	// Style
	// flexvol
	// END DEBUGGING
	// VolumeStyleFlexvol captures enum value "flexvol"
	VolumeStyleFlexvol string = "flexvol"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// style
	// Style
	// flexgroup
	// END DEBUGGING
	// VolumeStyleFlexgroup captures enum value "flexgroup"
	VolumeStyleFlexgroup string = "flexgroup"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// style
	// Style
	// flexgroup_constituent
	// END DEBUGGING
	// VolumeStyleFlexgroupConstituent captures enum value "flexgroup_constituent"
	VolumeStyleFlexgroupConstituent string = "flexgroup_constituent"
)

// prop value enum
func (m *Volume) validateStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.Style) { // not required
		return nil
	}

	// value enum
	if err := m.validateStyleEnum("style", "body", *m.Style); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

var volumeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["rw","dp","ls"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeTypeTypePropEnum = append(volumeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume
	// Volume
	// type
	// Type
	// rw
	// END DEBUGGING
	// VolumeTypeRw captures enum value "rw"
	VolumeTypeRw string = "rw"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// type
	// Type
	// dp
	// END DEBUGGING
	// VolumeTypeDp captures enum value "dp"
	VolumeTypeDp string = "dp"

	// BEGIN DEBUGGING
	// volume
	// Volume
	// type
	// Type
	// ls
	// END DEBUGGING
	// VolumeTypeLs captures enum value "ls"
	VolumeTypeLs string = "ls"
)

// prop value enum
func (m *Volume) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Volume) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateVolumeInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeInlineTags) { // not required
		return nil
	}

	iVolumeInlineTagsSize := int64(len(m.VolumeInlineTags))

	if err := validate.MaxItems("_tags", "body", iVolumeInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *Volume) validateVolumeInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.VolumeInlineAggregates); i++ {
		if swag.IsZero(m.VolumeInlineAggregates[i]) { // not required
			continue
		}

		if m.VolumeInlineAggregates[i] != nil {
			if err := m.VolumeInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Volume) validateVolumeInlineConstituents(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeInlineConstituents) { // not required
		return nil
	}

	for i := 0; i < len(m.VolumeInlineConstituents); i++ {
		if swag.IsZero(m.VolumeInlineConstituents[i]) { // not required
			continue
		}

		if m.VolumeInlineConstituents[i] != nil {
			if err := m.VolumeInlineConstituents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("constituents" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Volume) validateVolumeInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.VolumeInlineNodes); i++ {
		if swag.IsZero(m.VolumeInlineNodes[i]) { // not required
			continue
		}

		if m.VolumeInlineNodes[i] != nil {
			if err := m.VolumeInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this volume based on the context it is used
func (m *Volume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateActivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnalytics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAsynchronousDirectoryDelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAutosize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlashPool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcacheEndpointType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsObjectStore(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSvmRoot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQuota(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRebalancing(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeInlineConstituents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeInlineStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Volume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateActivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if m.ActivityTracking != nil {
		if err := m.ActivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("activity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateAnalytics(ctx context.Context, formats strfmt.Registry) error {

	if m.Analytics != nil {
		if err := m.Analytics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateAntiRansomware(ctx context.Context, formats strfmt.Registry) error {

	if m.AntiRansomware != nil {
		if err := m.AntiRansomware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateAsynchronousDirectoryDelete(ctx context.Context, formats strfmt.Registry) error {

	if m.AsynchronousDirectoryDelete != nil {
		if err := m.AsynchronousDirectoryDelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("asynchronous_directory_delete")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateAutosize(ctx context.Context, formats strfmt.Registry) error {

	if m.Autosize != nil {
		if err := m.Autosize.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("autosize")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *Volume) contextValidateEfficiency(ctx context.Context, formats strfmt.Registry) error {

	if m.Efficiency != nil {
		if err := m.Efficiency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateErrorState(ctx context.Context, formats strfmt.Registry) error {

	if m.ErrorState != nil {
		if err := m.ErrorState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error_state")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateFiles(ctx context.Context, formats strfmt.Registry) error {

	if m.Files != nil {
		if err := m.Files.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateFlashPool(ctx context.Context, formats strfmt.Registry) error {

	if m.FlashPool != nil {
		if err := m.FlashPool.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flash_pool")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateFlexcacheEndpointType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexcache_endpoint_type", "body", m.FlexcacheEndpointType); err != nil {
		return err
	}

	return nil
}

func (m *Volume) contextValidateFlexgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexgroup != nil {
		if err := m.Flexgroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexgroup")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateIsObjectStore(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_object_store", "body", m.IsObjectStore); err != nil {
		return err
	}

	return nil
}

func (m *Volume) contextValidateIsSvmRoot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_svm_root", "body", m.IsSvmRoot); err != nil {
		return err
	}

	return nil
}

func (m *Volume) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if m.Movement != nil {
		if err := m.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateQuota(ctx context.Context, formats strfmt.Registry) error {

	if m.Quota != nil {
		if err := m.Quota.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("quota")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateRebalancing(ctx context.Context, formats strfmt.Registry) error {

	if m.Rebalancing != nil {
		if err := m.Rebalancing.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateSnapmirror(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapmirror != nil {
		if err := m.Snapmirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapmirror")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateSnapshotCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot_count", "body", m.SnapshotCount); err != nil {
		return err
	}

	return nil
}

func (m *Volume) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *Volume) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Volume) contextValidateVolumeInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeInlineAggregates); i++ {

		if m.VolumeInlineAggregates[i] != nil {
			if err := m.VolumeInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Volume) contextValidateVolumeInlineConstituents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeInlineConstituents); i++ {

		if m.VolumeInlineConstituents[i] != nil {
			if err := m.VolumeInlineConstituents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("constituents" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Volume) contextValidateVolumeInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeInlineNodes); i++ {

		if m.VolumeInlineNodes[i] != nil {
			if err := m.VolumeInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Volume) contextValidateVolumeInlineStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", []*string(m.VolumeInlineStatus)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Volume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Volume) UnmarshalBinary(b []byte) error {
	var res Volume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineActivityTracking volume inline activity tracking
//
// swagger:model volume_inline_activity_tracking
type VolumeInlineActivityTracking struct {

	// List of activity-tracking notices.
	Notices []*VolumeActivityTrackingNoticesItems0 `json:"notices,omitempty"`

	// Activity tracking state of the volume. If this value is "on", ONTAP collects top metrics information for the volume in real time. There is a slight impact to I/O performance in order to collect this information. If this value is "off", no activity tracking information is collected or available to view.
	// Enum: ["off","on"]
	State *string `json:"state,omitempty"`

	// This field indicates whether or not volume activity tracking is supported on the volume. If volume activity tracking is not supported, the reason why is provided in the "activity_tracking.unsupported_reason" field.
	// Read Only: true
	Supported *bool `json:"supported,omitempty"`

	// unsupported reason
	UnsupportedReason *VolumeInlineActivityTrackingInlineUnsupportedReason `json:"unsupported_reason,omitempty"`
}

// Validate validates this volume inline activity tracking
func (m *VolumeInlineActivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNotices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnsupportedReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineActivityTracking) validateNotices(formats strfmt.Registry) error {
	if swag.IsZero(m.Notices) { // not required
		return nil
	}

	for i := 0; i < len(m.Notices); i++ {
		if swag.IsZero(m.Notices[i]) { // not required
			continue
		}

		if m.Notices[i] != nil {
			if err := m.Notices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("activity_tracking" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var volumeInlineActivityTrackingTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","on"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineActivityTrackingTypeStatePropEnum = append(volumeInlineActivityTrackingTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_activity_tracking
	// VolumeInlineActivityTracking
	// state
	// State
	// off
	// END DEBUGGING
	// VolumeInlineActivityTrackingStateOff captures enum value "off"
	VolumeInlineActivityTrackingStateOff string = "off"

	// BEGIN DEBUGGING
	// volume_inline_activity_tracking
	// VolumeInlineActivityTracking
	// state
	// State
	// on
	// END DEBUGGING
	// VolumeInlineActivityTrackingStateOn captures enum value "on"
	VolumeInlineActivityTrackingStateOn string = "on"
)

// prop value enum
func (m *VolumeInlineActivityTracking) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineActivityTrackingTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineActivityTracking) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("activity_tracking"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineActivityTracking) validateUnsupportedReason(formats strfmt.Registry) error {
	if swag.IsZero(m.UnsupportedReason) { // not required
		return nil
	}

	if m.UnsupportedReason != nil {
		if err := m.UnsupportedReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("activity_tracking" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline activity tracking based on the context it is used
func (m *VolumeInlineActivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNotices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnsupportedReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineActivityTracking) contextValidateNotices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Notices); i++ {

		if m.Notices[i] != nil {
			if err := m.Notices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("activity_tracking" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineActivityTracking) contextValidateSupported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "activity_tracking"+"."+"supported", "body", m.Supported); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineActivityTracking) contextValidateUnsupportedReason(ctx context.Context, formats strfmt.Registry) error {

	if m.UnsupportedReason != nil {
		if err := m.UnsupportedReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("activity_tracking" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineActivityTracking) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineActivityTracking) UnmarshalBinary(b []byte) error {
	var res VolumeInlineActivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeActivityTrackingNoticesItems0 volume activity tracking notices items0
//
// swagger:model VolumeActivityTrackingNoticesItems0
type VolumeActivityTrackingNoticesItems0 struct {

	// An error code related to activity tracking.
	// Example: 124518424
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A notice message related to activity tracking.
	// Example: The top metrics report contains partial data for read operations because NFSv4 reads using Multi-Processor I/O (MPIO) are not tracked.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume activity tracking notices items0
func (m *VolumeActivityTrackingNoticesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume activity tracking notices items0 based on the context it is used
func (m *VolumeActivityTrackingNoticesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeActivityTrackingNoticesItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeActivityTrackingNoticesItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeActivityTrackingNoticesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeActivityTrackingNoticesItems0) UnmarshalBinary(b []byte) error {
	var res VolumeActivityTrackingNoticesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineActivityTrackingInlineUnsupportedReason volume inline activity tracking inline unsupported reason
//
// swagger:model volume_inline_activity_tracking_inline_unsupported_reason
type VolumeInlineActivityTrackingInlineUnsupportedReason struct {

	// If volume activity tracking is not supported on the volume, this field provides an appropriate error code.
	// Example: 124518405
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// If volume activity tracking is not supported on the volume, this field provides an error message detailing why this is the case.
	// Example: Volume activity tracking cannot be enabled on volumes that contain LUNs.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline activity tracking inline unsupported reason
func (m *VolumeInlineActivityTrackingInlineUnsupportedReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline activity tracking inline unsupported reason based on the context it is used
func (m *VolumeInlineActivityTrackingInlineUnsupportedReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineActivityTrackingInlineUnsupportedReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "activity_tracking"+"."+"unsupported_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineActivityTrackingInlineUnsupportedReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "activity_tracking"+"."+"unsupported_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineActivityTrackingInlineUnsupportedReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineActivityTrackingInlineUnsupportedReason) UnmarshalBinary(b []byte) error {
	var res VolumeInlineActivityTrackingInlineUnsupportedReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAggregatesInlineArrayItem Aggregate
//
// swagger:model volume_inline_aggregates_inline_array_item
type VolumeInlineAggregatesInlineArrayItem struct {

	// links
	Links *VolumeInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline aggregates inline array item
func (m *VolumeInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline aggregates inline array item based on the context it is used
func (m *VolumeInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAggregatesInlineArrayItemInlineLinks volume inline aggregates inline array item inline links
//
// swagger:model volume_inline_aggregates_inline_array_item_inline__links
type VolumeInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline aggregates inline array item inline links
func (m *VolumeInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline aggregates inline array item inline links based on the context it is used
func (m *VolumeInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalytics volume inline analytics
//
// swagger:model volume_inline_analytics
type VolumeInlineAnalytics struct {

	// by accessed time
	ByAccessedTime *VolumeInlineAnalyticsInlineByAccessedTime `json:"by_accessed_time,omitempty"`

	// by modified time
	ByModifiedTime *VolumeInlineAnalyticsInlineByModifiedTime `json:"by_modified_time,omitempty"`

	// Number of bytes used on-disk.
	// Example: 15436648448
	// Read Only: true
	BytesUsed *int64 `json:"bytes_used,omitempty"`

	// Number of descendants.
	// Example: 21134
	// Read Only: true
	FileCount *int64 `json:"file_count,omitempty"`

	// Number of files in the volume that the file system analytics initialization scan has processed. Only returned when the state is `initializing`.
	// Example: 43002
	// Read Only: true
	FilesScanned *int64 `json:"files_scanned,omitempty"`

	// Returns true if data collection is incomplete for this directory tree.
	// Read Only: true
	IncompleteData *bool `json:"incomplete_data,omitempty"`

	// initialization
	Initialization *VolumeInlineAnalyticsInlineInitialization `json:"initialization,omitempty"`

	// Time of data collection.
	// Example: 2024-11-06 13:57:15-05:00
	// Read Only: true
	// Format: date-time
	ReportTime *strfmt.DateTime `json:"report_time,omitempty"`

	// Percentage of files in the volume that the file system analytics initialization scan has processed. Only returned when the state is `initializing`.
	// Example: 17
	// Read Only: true
	ScanProgress *int64 `json:"scan_progress,omitempty"`

	// scan throttle reason
	ScanThrottleReason *VolumeInlineAnalyticsInlineScanThrottleReason `json:"scan_throttle_reason,omitempty"`

	// File system analytics state of the volume. If this value is "on", ONTAP collects extra file system analytics information for all directories on the volume. There will be a slight impact to I/O performance to collect this information. If this value is "off", file system analytics information is not collected and not available to be viewed. If this value is "initializing", that means file system analytics was recently turned on, and the initialization scan to gather information for all existing files and directories is currently running. If this value is "initialization_paused", this means that the initialization scan is currently paused. If this value is 'unknown', this means that there was an internal error when determining the file system analytics state for the volume.
	// Enum: ["unknown","initializing","initialization_paused","off","on"]
	State *string `json:"state,omitempty"`

	// Number of sub-directories.
	// Example: 35
	// Read Only: true
	SubdirCount *int64 `json:"subdir_count,omitempty"`

	// This field indicates whether or not file system analytics is supported on the volume. If file system analytics is not supported, the reason will be specified in the "analytics.unsupported_reason" field.
	// Read Only: true
	Supported *bool `json:"supported,omitempty"`

	// Total number of files in the volume that the file system analytics initialization scan will process. Only returned when the state is `initializing`.
	// Example: 101890
	// Read Only: true
	TotalFiles *int64 `json:"total_files,omitempty"`

	// unsupported reason
	UnsupportedReason *VolumeInlineAnalyticsInlineUnsupportedReason `json:"unsupported_reason,omitempty"`
}

// Validate validates this volume inline analytics
func (m *VolumeInlineAnalytics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateByAccessedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateByModifiedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitialization(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReportTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanThrottleReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnsupportedReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalytics) validateByAccessedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ByAccessedTime) { // not required
		return nil
	}

	if m.ByAccessedTime != nil {
		if err := m.ByAccessedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) validateByModifiedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ByModifiedTime) { // not required
		return nil
	}

	if m.ByModifiedTime != nil {
		if err := m.ByModifiedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) validateInitialization(formats strfmt.Registry) error {
	if swag.IsZero(m.Initialization) { // not required
		return nil
	}

	if m.Initialization != nil {
		if err := m.Initialization.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "initialization")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) validateReportTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ReportTime) { // not required
		return nil
	}

	if err := validate.FormatOf("analytics"+"."+"report_time", "body", "date-time", m.ReportTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) validateScanThrottleReason(formats strfmt.Registry) error {
	if swag.IsZero(m.ScanThrottleReason) { // not required
		return nil
	}

	if m.ScanThrottleReason != nil {
		if err := m.ScanThrottleReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "scan_throttle_reason")
			}
			return err
		}
	}

	return nil
}

var volumeInlineAnalyticsTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","initializing","initialization_paused","off","on"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAnalyticsTypeStatePropEnum = append(volumeInlineAnalyticsTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// unknown
	// END DEBUGGING
	// VolumeInlineAnalyticsStateUnknown captures enum value "unknown"
	VolumeInlineAnalyticsStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// initializing
	// END DEBUGGING
	// VolumeInlineAnalyticsStateInitializing captures enum value "initializing"
	VolumeInlineAnalyticsStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// initialization_paused
	// END DEBUGGING
	// VolumeInlineAnalyticsStateInitializationPaused captures enum value "initialization_paused"
	VolumeInlineAnalyticsStateInitializationPaused string = "initialization_paused"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// off
	// END DEBUGGING
	// VolumeInlineAnalyticsStateOff captures enum value "off"
	VolumeInlineAnalyticsStateOff string = "off"

	// BEGIN DEBUGGING
	// volume_inline_analytics
	// VolumeInlineAnalytics
	// state
	// State
	// on
	// END DEBUGGING
	// VolumeInlineAnalyticsStateOn captures enum value "on"
	VolumeInlineAnalyticsStateOn string = "on"
)

// prop value enum
func (m *VolumeInlineAnalytics) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAnalyticsTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAnalytics) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("analytics"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) validateUnsupportedReason(formats strfmt.Registry) error {
	if swag.IsZero(m.UnsupportedReason) { // not required
		return nil
	}

	if m.UnsupportedReason != nil {
		if err := m.UnsupportedReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics based on the context it is used
func (m *VolumeInlineAnalytics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateByAccessedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateByModifiedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIncompleteData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitialization(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReportTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScanProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScanThrottleReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubdirCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnsupportedReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalytics) contextValidateByAccessedTime(ctx context.Context, formats strfmt.Registry) error {

	if m.ByAccessedTime != nil {
		if err := m.ByAccessedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateByModifiedTime(ctx context.Context, formats strfmt.Registry) error {

	if m.ByModifiedTime != nil {
		if err := m.ByModifiedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"bytes_used", "body", m.BytesUsed); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateFileCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"file_count", "body", m.FileCount); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateFilesScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"files_scanned", "body", m.FilesScanned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateIncompleteData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"incomplete_data", "body", m.IncompleteData); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateInitialization(ctx context.Context, formats strfmt.Registry) error {

	if m.Initialization != nil {
		if err := m.Initialization.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "initialization")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateReportTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"report_time", "body", m.ReportTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateScanProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"scan_progress", "body", m.ScanProgress); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateScanThrottleReason(ctx context.Context, formats strfmt.Registry) error {

	if m.ScanThrottleReason != nil {
		if err := m.ScanThrottleReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "scan_throttle_reason")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateSubdirCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"subdir_count", "body", m.SubdirCount); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateSupported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"supported", "body", m.Supported); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateTotalFiles(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"total_files", "body", m.TotalFiles); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalytics) contextValidateUnsupportedReason(ctx context.Context, formats strfmt.Registry) error {

	if m.UnsupportedReason != nil {
		if err := m.UnsupportedReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "unsupported_reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalytics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalytics) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalytics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineByAccessedTime File system analytics information, broken down by date of last access.
//
// swagger:model volume_inline_analytics_inline_by_accessed_time
type VolumeInlineAnalyticsInlineByAccessedTime struct {

	// bytes used
	BytesUsed *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this volume inline analytics inline by accessed time
func (m *VolumeInlineAnalyticsInlineByAccessedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.BytesUsed) { // not required
		return nil
	}

	if m.BytesUsed != nil {
		if err := m.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by accessed time based on the context it is used
func (m *VolumeInlineAnalyticsInlineByAccessedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.BytesUsed != nil {
		if err := m.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByAccessedTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByAccessedTime) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByAccessedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last access.
//
// swagger:model volume_inline_analytics_inline_by_accessed_time_inline_bytes_used
type VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	Percentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	Values []*int64 `json:"values,omitempty"`
}

// Validate validates this volume inline analytics inline by accessed time inline bytes used
func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.NewestLabel) { // not required
		return nil
	}

	if m.NewestLabel != nil {
		if err := m.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.OldestLabel) { // not required
		return nil
	}

	if m.OldestLabel != nil {
		if err := m.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by accessed time inline bytes used based on the context it is used
func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.NewestLabel != nil {
		if err := m.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.OldestLabel != nil {
		if err := m.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByAccessedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineByModifiedTime File system analytics information, broken down by date of last modification.
//
// swagger:model volume_inline_analytics_inline_by_modified_time
type VolumeInlineAnalyticsInlineByModifiedTime struct {

	// bytes used
	BytesUsed *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this volume inline analytics inline by modified time
func (m *VolumeInlineAnalyticsInlineByModifiedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.BytesUsed) { // not required
		return nil
	}

	if m.BytesUsed != nil {
		if err := m.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by modified time based on the context it is used
func (m *VolumeInlineAnalyticsInlineByModifiedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.BytesUsed != nil {
		if err := m.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByModifiedTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByModifiedTime) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByModifiedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last modification.
//
// swagger:model volume_inline_analytics_inline_by_modified_time_inline_bytes_used
type VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	Percentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	Values []*int64 `json:"values,omitempty"`
}

// Validate validates this volume inline analytics inline by modified time inline bytes used
func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.NewestLabel) { // not required
		return nil
	}

	if m.NewestLabel != nil {
		if err := m.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.OldestLabel) { // not required
		return nil
	}

	if m.OldestLabel != nil {
		if err := m.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline analytics inline by modified time inline bytes used based on the context it is used
func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.NewestLabel != nil {
		if err := m.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.OldestLabel != nil {
		if err := m.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineByModifiedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineInitialization volume inline analytics inline initialization
//
// swagger:model volume_inline_analytics_inline_initialization
type VolumeInlineAnalyticsInlineInitialization struct {

	// State of the analytics file system scan.
	// Enum: ["running","paused"]
	State *string `json:"state,omitempty"`
}

// Validate validates this volume inline analytics inline initialization
func (m *VolumeInlineAnalyticsInlineInitialization) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAnalyticsInlineInitializationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["running","paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAnalyticsInlineInitializationTypeStatePropEnum = append(volumeInlineAnalyticsInlineInitializationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_analytics_inline_initialization
	// VolumeInlineAnalyticsInlineInitialization
	// state
	// State
	// running
	// END DEBUGGING
	// VolumeInlineAnalyticsInlineInitializationStateRunning captures enum value "running"
	VolumeInlineAnalyticsInlineInitializationStateRunning string = "running"

	// BEGIN DEBUGGING
	// volume_inline_analytics_inline_initialization
	// VolumeInlineAnalyticsInlineInitialization
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineAnalyticsInlineInitializationStatePaused captures enum value "paused"
	VolumeInlineAnalyticsInlineInitializationStatePaused string = "paused"
)

// prop value enum
func (m *VolumeInlineAnalyticsInlineInitialization) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAnalyticsInlineInitializationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineInitialization) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("analytics"+"."+"initialization"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline analytics inline initialization based on context it is used
func (m *VolumeInlineAnalyticsInlineInitialization) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineInitialization) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineInitialization) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineInitialization
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineScanThrottleReason volume inline analytics inline scan throttle reason
//
// swagger:model volume_inline_analytics_inline_scan_throttle_reason
type VolumeInlineAnalyticsInlineScanThrottleReason struct {

	// Arguments present in the warning message encountered.
	Arguments []*string `json:"arguments,omitempty"`

	// Warning code indicating why scanner throttling is reported.
	// Example: 6739881
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A message that provides details for scan throttling.
	// Example: The file system analytics scan running on volume \"fsavol2\" in SVM \"vs2\" has slowed down on node \"my_node\". Reason: Computing resources are being used by higher priority workloads.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline analytics inline scan throttle reason
func (m *VolumeInlineAnalyticsInlineScanThrottleReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline analytics inline scan throttle reason based on the context it is used
func (m *VolumeInlineAnalyticsInlineScanThrottleReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineScanThrottleReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"scan_throttle_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineScanThrottleReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"scan_throttle_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineScanThrottleReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineScanThrottleReason) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineScanThrottleReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAnalyticsInlineUnsupportedReason volume inline analytics inline unsupported reason
//
// swagger:model volume_inline_analytics_inline_unsupported_reason
type VolumeInlineAnalyticsInlineUnsupportedReason struct {

	// If file system analytics is not supported on the volume, this field provides the error code explaining why.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// If file system analytics is not supported on the volume, this field provides the error message explaining why.
	// Example: File system analytics cannot be enabled on volumes that contain LUNs.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline analytics inline unsupported reason
func (m *VolumeInlineAnalyticsInlineUnsupportedReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline analytics inline unsupported reason based on the context it is used
func (m *VolumeInlineAnalyticsInlineUnsupportedReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAnalyticsInlineUnsupportedReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"unsupported_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAnalyticsInlineUnsupportedReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "analytics"+"."+"unsupported_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineUnsupportedReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAnalyticsInlineUnsupportedReason) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAnalyticsInlineUnsupportedReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAntiRansomware Anti-ransomware related information of the volume.
//
// swagger:model volume_inline_anti_ransomware
type VolumeInlineAntiRansomware struct {

	// This field specifies whether the attack was reported by `File Analysis` or `Encrypted data percentage analysis`.
	// Read Only: true
	// Enum: ["file_analysis","encryption_percentage_analysis"]
	AttackDetectedBy *string `json:"attack_detected_by,omitempty"`

	// attack detection parameters
	AttackDetectionParameters *AntiRansomwareVolumeAttackDetectionParameters `json:"attack_detection_parameters,omitempty"`

	// Probability of a ransomware attack.<br>`none` No suspected ransomware activity.<br>`low` Minimally suspected ransomware activity.<br>`moderate` Moderately suspected ransomware activity.<br>`high` Significantly suspected ransomware activity.
	// Read Only: true
	// Enum: ["none","low","moderate","high"]
	AttackProbability *string `json:"attack_probability,omitempty"`

	// attack reports
	// Read Only: true
	AttackReports []*AntiRansomwareAttackReport `json:"attack_reports,omitempty"`

	// This field specifies the block device evaluation start time.
	// Read Only: true
	// Format: date-time
	BlockDeviceDetectionStartTime *strfmt.DateTime `json:"block_device_detection_start_time,omitempty"`

	// This field specifies the block device attack detection status. <br> `evaluation_period` Attack detection is currently in its evaluation phase. <br> `active_unsuitable_workload` Attack detection is active, but the current workload is not suitable for Anti-ransomware protection. <br> `active_suitable_workload` Attack detection is active, and the current workload is appropriate for Anti-ransomware protection.
	// Read Only: true
	// Enum: ["evaluation_period","active_unsuitable_workload","active_suitable_workload"]
	BlockDeviceDetectionState *string `json:"block_device_detection_state,omitempty"`

	// clear suspect
	ClearSuspect *VolumeInlineAntiRansomwareInlineClearSuspect `json:"clear_suspect,omitempty"`

	// Time when Anti-ransomware monitoring `state` is set to dry-run value for starting evaluation mode.
	// Read Only: true
	// Format: date-time
	DryRunStartTime *strfmt.DateTime `json:"dry_run_start_time,omitempty"`

	// event log
	EventLog *VolumeInlineAntiRansomwareInlineEventLog `json:"event_log,omitempty"`

	// space
	Space *VolumeInlineAntiRansomwareInlineSpace `json:"space,omitempty"`

	// Anti-ransomware state.<br>`disabled` Anti-ransomware monitoring is disabled on the volume. This is the default state in a POST operation.<br>`disable_in_progress` Anti-ransomware monitoring is being disabled and a cleanup operation is in effect. Valid in GET operation.<br>`dry_run` Anti-ransomware monitoring is enabled in the evaluation mode.<br>`enabled` Anti-ransomware monitoring is active on the volume.<br>`paused` Anti-ransomware monitoring is paused on the volume.<br>`enable_paused` Anti-ransomware monitoring is paused on the volume from its earlier enabled state. Valid in GET operation. <br>`dry_run_paused` Anti-ransomware monitoring is paused on the volume from its earlier dry_run state. Valid in GET operation. <br>For POST, the valid Anti-ransomware states are only `disabled`, `enabled` and `dry_run`, whereas for PATCH, `paused` is also valid along with the three valid states for POST.
	// Enum: ["disabled","disable_in_progress","dry_run","enabled","paused","enable_paused","dry_run_paused"]
	State *string `json:"state,omitempty"`

	// Indicates whether or not to set the surge values as historical values. This field is no longer supported. Use update_baseline_from_surge instead.
	SurgeAsNormal *bool `json:"surge_as_normal,omitempty"`

	// surge usage
	SurgeUsage *VolumeInlineAntiRansomwareInlineSurgeUsage `json:"surge_usage,omitempty"`

	// suspect files
	// Read Only: true
	SuspectFiles []*VolumeAntiRansomwareSuspectFilesItems0 `json:"suspect_files,omitempty"`

	// typical usage
	TypicalUsage *VolumeInlineAntiRansomwareInlineTypicalUsage `json:"typical_usage,omitempty"`

	// Sets the observed surge value as the new baseline on a volume.
	UpdateBaselineFromSurge *bool `json:"update_baseline_from_surge,omitempty"`

	// workload
	Workload *AntiRansomwareVolumeWorkload `json:"workload,omitempty"`
}

// Validate validates this volume inline anti ransomware
func (m *VolumeInlineAntiRansomware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAttackDetectedBy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttackDetectionParameters(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttackProbability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttackReports(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlockDeviceDetectionStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlockDeviceDetectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClearSuspect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDryRunStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEventLog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSurgeUsage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSuspectFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTypicalUsage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkload(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file_analysis","encryption_percentage_analysis"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum = append(volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_detected_by
	// AttackDetectedBy
	// file_analysis
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackDetectedByFileAnalysis captures enum value "file_analysis"
	VolumeInlineAntiRansomwareAttackDetectedByFileAnalysis string = "file_analysis"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_detected_by
	// AttackDetectedBy
	// encryption_percentage_analysis
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackDetectedByEncryptionPercentageAnalysis captures enum value "encryption_percentage_analysis"
	VolumeInlineAntiRansomwareAttackDetectedByEncryptionPercentageAnalysis string = "encryption_percentage_analysis"
)

// prop value enum
func (m *VolumeInlineAntiRansomware) validateAttackDetectedByEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeAttackDetectedByPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAntiRansomware) validateAttackDetectedBy(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackDetectedBy) { // not required
		return nil
	}

	// value enum
	if err := m.validateAttackDetectedByEnum("anti_ransomware"+"."+"attack_detected_by", "body", *m.AttackDetectedBy); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateAttackDetectionParameters(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackDetectionParameters) { // not required
		return nil
	}

	if m.AttackDetectionParameters != nil {
		if err := m.AttackDetectionParameters.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "attack_detection_parameters")
			}
			return err
		}
	}

	return nil
}

var volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","low","moderate","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum = append(volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// none
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityNone captures enum value "none"
	VolumeInlineAntiRansomwareAttackProbabilityNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// low
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityLow captures enum value "low"
	VolumeInlineAntiRansomwareAttackProbabilityLow string = "low"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// moderate
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityModerate captures enum value "moderate"
	VolumeInlineAntiRansomwareAttackProbabilityModerate string = "moderate"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// high
	// END DEBUGGING
	// VolumeInlineAntiRansomwareAttackProbabilityHigh captures enum value "high"
	VolumeInlineAntiRansomwareAttackProbabilityHigh string = "high"
)

// prop value enum
func (m *VolumeInlineAntiRansomware) validateAttackProbabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeAttackProbabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAntiRansomware) validateAttackProbability(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackProbability) { // not required
		return nil
	}

	// value enum
	if err := m.validateAttackProbabilityEnum("anti_ransomware"+"."+"attack_probability", "body", *m.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateAttackReports(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackReports) { // not required
		return nil
	}

	for i := 0; i < len(m.AttackReports); i++ {
		if swag.IsZero(m.AttackReports[i]) { // not required
			continue
		}

		if m.AttackReports[i] != nil {
			if err := m.AttackReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateBlockDeviceDetectionStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockDeviceDetectionStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("anti_ransomware"+"."+"block_device_detection_start_time", "body", "date-time", m.BlockDeviceDetectionStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["evaluation_period","active_unsuitable_workload","active_suitable_workload"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum = append(volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// block_device_detection_state
	// BlockDeviceDetectionState
	// evaluation_period
	// END DEBUGGING
	// VolumeInlineAntiRansomwareBlockDeviceDetectionStateEvaluationPeriod captures enum value "evaluation_period"
	VolumeInlineAntiRansomwareBlockDeviceDetectionStateEvaluationPeriod string = "evaluation_period"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// block_device_detection_state
	// BlockDeviceDetectionState
	// active_unsuitable_workload
	// END DEBUGGING
	// VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveUnsuitableWorkload captures enum value "active_unsuitable_workload"
	VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveUnsuitableWorkload string = "active_unsuitable_workload"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// block_device_detection_state
	// BlockDeviceDetectionState
	// active_suitable_workload
	// END DEBUGGING
	// VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveSuitableWorkload captures enum value "active_suitable_workload"
	VolumeInlineAntiRansomwareBlockDeviceDetectionStateActiveSuitableWorkload string = "active_suitable_workload"
)

// prop value enum
func (m *VolumeInlineAntiRansomware) validateBlockDeviceDetectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeBlockDeviceDetectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAntiRansomware) validateBlockDeviceDetectionState(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockDeviceDetectionState) { // not required
		return nil
	}

	// value enum
	if err := m.validateBlockDeviceDetectionStateEnum("anti_ransomware"+"."+"block_device_detection_state", "body", *m.BlockDeviceDetectionState); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateClearSuspect(formats strfmt.Registry) error {
	if swag.IsZero(m.ClearSuspect) { // not required
		return nil
	}

	if m.ClearSuspect != nil {
		if err := m.ClearSuspect.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "clear_suspect")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateDryRunStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.DryRunStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("anti_ransomware"+"."+"dry_run_start_time", "body", "date-time", m.DryRunStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateEventLog(formats strfmt.Registry) error {
	if swag.IsZero(m.EventLog) { // not required
		return nil
	}

	if m.EventLog != nil {
		if err := m.EventLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "event_log")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "space")
			}
			return err
		}
	}

	return nil
}

var volumeInlineAntiRansomwareTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","disable_in_progress","dry_run","enabled","paused","enable_paused","dry_run_paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareTypeStatePropEnum = append(volumeInlineAntiRansomwareTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// disabled
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDisabled captures enum value "disabled"
	VolumeInlineAntiRansomwareStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// disable_in_progress
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDisableInProgress captures enum value "disable_in_progress"
	VolumeInlineAntiRansomwareStateDisableInProgress string = "disable_in_progress"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// dry_run
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDryRun captures enum value "dry_run"
	VolumeInlineAntiRansomwareStateDryRun string = "dry_run"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// enabled
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateEnabled captures enum value "enabled"
	VolumeInlineAntiRansomwareStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStatePaused captures enum value "paused"
	VolumeInlineAntiRansomwareStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// enable_paused
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateEnablePaused captures enum value "enable_paused"
	VolumeInlineAntiRansomwareStateEnablePaused string = "enable_paused"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware
	// VolumeInlineAntiRansomware
	// state
	// State
	// dry_run_paused
	// END DEBUGGING
	// VolumeInlineAntiRansomwareStateDryRunPaused captures enum value "dry_run_paused"
	VolumeInlineAntiRansomwareStateDryRunPaused string = "dry_run_paused"
)

// prop value enum
func (m *VolumeInlineAntiRansomware) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAntiRansomware) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("anti_ransomware"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateSurgeUsage(formats strfmt.Registry) error {
	if swag.IsZero(m.SurgeUsage) { // not required
		return nil
	}

	if m.SurgeUsage != nil {
		if err := m.SurgeUsage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "surge_usage")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateSuspectFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.SuspectFiles) { // not required
		return nil
	}

	for i := 0; i < len(m.SuspectFiles); i++ {
		if swag.IsZero(m.SuspectFiles[i]) { // not required
			continue
		}

		if m.SuspectFiles[i] != nil {
			if err := m.SuspectFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("anti_ransomware" + "." + "suspect_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateTypicalUsage(formats strfmt.Registry) error {
	if swag.IsZero(m.TypicalUsage) { // not required
		return nil
	}

	if m.TypicalUsage != nil {
		if err := m.TypicalUsage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "typical_usage")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) validateWorkload(formats strfmt.Registry) error {
	if swag.IsZero(m.Workload) { // not required
		return nil
	}

	if m.Workload != nil {
		if err := m.Workload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "workload")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline anti ransomware based on the context it is used
func (m *VolumeInlineAntiRansomware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAttackDetectedBy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttackDetectionParameters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttackProbability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttackReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockDeviceDetectionStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockDeviceDetectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClearSuspect(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDryRunStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEventLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSurgeUsage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSuspectFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTypicalUsage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateAttackDetectedBy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"attack_detected_by", "body", m.AttackDetectedBy); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateAttackDetectionParameters(ctx context.Context, formats strfmt.Registry) error {

	if m.AttackDetectionParameters != nil {
		if err := m.AttackDetectionParameters.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "attack_detection_parameters")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateAttackProbability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"attack_probability", "body", m.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateAttackReports(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"attack_reports", "body", []*AntiRansomwareAttackReport(m.AttackReports)); err != nil {
		return err
	}

	for i := 0; i < len(m.AttackReports); i++ {

		if m.AttackReports[i] != nil {
			if err := m.AttackReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateBlockDeviceDetectionStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"block_device_detection_start_time", "body", m.BlockDeviceDetectionStartTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateBlockDeviceDetectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"block_device_detection_state", "body", m.BlockDeviceDetectionState); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateClearSuspect(ctx context.Context, formats strfmt.Registry) error {

	if m.ClearSuspect != nil {
		if err := m.ClearSuspect.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "clear_suspect")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateDryRunStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"dry_run_start_time", "body", m.DryRunStartTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateEventLog(ctx context.Context, formats strfmt.Registry) error {

	if m.EventLog != nil {
		if err := m.EventLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "event_log")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateSurgeUsage(ctx context.Context, formats strfmt.Registry) error {

	if m.SurgeUsage != nil {
		if err := m.SurgeUsage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "surge_usage")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateSuspectFiles(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"suspect_files", "body", []*VolumeAntiRansomwareSuspectFilesItems0(m.SuspectFiles)); err != nil {
		return err
	}

	for i := 0; i < len(m.SuspectFiles); i++ {

		if m.SuspectFiles[i] != nil {
			if err := m.SuspectFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("anti_ransomware" + "." + "suspect_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateTypicalUsage(ctx context.Context, formats strfmt.Registry) error {

	if m.TypicalUsage != nil {
		if err := m.TypicalUsage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "typical_usage")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineAntiRansomware) contextValidateWorkload(ctx context.Context, formats strfmt.Registry) error {

	if m.Workload != nil {
		if err := m.Workload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware" + "." + "workload")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAntiRansomware) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAntiRansomware) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAntiRansomwareInlineClearSuspect Clear suspect status.
//
// swagger:model volume_inline_anti_ransomware_inline_clear_suspect
type VolumeInlineAntiRansomwareInlineClearSuspect struct {

	// Clear suspect phase.
	// Enum: ["file_extension_processing","snapshot_processing","done"]
	Phase *string `json:"phase,omitempty"`

	// Clear suspect start time.
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this volume inline anti ransomware inline clear suspect
func (m *VolumeInlineAntiRansomwareInlineClearSuspect) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePhase(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file_extension_processing","snapshot_processing","done"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum = append(volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware_inline_clear_suspect
	// VolumeInlineAntiRansomwareInlineClearSuspect
	// phase
	// Phase
	// file_extension_processing
	// END DEBUGGING
	// VolumeInlineAntiRansomwareInlineClearSuspectPhaseFileExtensionProcessing captures enum value "file_extension_processing"
	VolumeInlineAntiRansomwareInlineClearSuspectPhaseFileExtensionProcessing string = "file_extension_processing"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware_inline_clear_suspect
	// VolumeInlineAntiRansomwareInlineClearSuspect
	// phase
	// Phase
	// snapshot_processing
	// END DEBUGGING
	// VolumeInlineAntiRansomwareInlineClearSuspectPhaseSnapshotProcessing captures enum value "snapshot_processing"
	VolumeInlineAntiRansomwareInlineClearSuspectPhaseSnapshotProcessing string = "snapshot_processing"

	// BEGIN DEBUGGING
	// volume_inline_anti_ransomware_inline_clear_suspect
	// VolumeInlineAntiRansomwareInlineClearSuspect
	// phase
	// Phase
	// done
	// END DEBUGGING
	// VolumeInlineAntiRansomwareInlineClearSuspectPhaseDone captures enum value "done"
	VolumeInlineAntiRansomwareInlineClearSuspectPhaseDone string = "done"
)

// prop value enum
func (m *VolumeInlineAntiRansomwareInlineClearSuspect) validatePhaseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAntiRansomwareInlineClearSuspectTypePhasePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAntiRansomwareInlineClearSuspect) validatePhase(formats strfmt.Registry) error {
	if swag.IsZero(m.Phase) { // not required
		return nil
	}

	// value enum
	if err := m.validatePhaseEnum("anti_ransomware"+"."+"clear_suspect"+"."+"phase", "body", *m.Phase); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineClearSuspect) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("anti_ransomware"+"."+"clear_suspect"+"."+"start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline anti ransomware inline clear suspect based on context it is used
func (m *VolumeInlineAntiRansomwareInlineClearSuspect) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineClearSuspect) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineClearSuspect) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineClearSuspect
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAntiRansomwareInlineEventLog volume inline anti ransomware inline event log
//
// swagger:model volume_inline_anti_ransomware_inline_event_log
type VolumeInlineAntiRansomwareInlineEventLog struct {

	// Specifies whether to send an EMS when a new file extension is discovered.
	IsEnabledOnNewFileExtensionSeen *bool `json:"is_enabled_on_new_file_extension_seen,omitempty"`

	// Specifies whether to send an EMS when a snapshot is created.
	IsEnabledOnSnapshotCopyCreation *bool `json:"is_enabled_on_snapshot_copy_creation,omitempty"`
}

// Validate validates this volume inline anti ransomware inline event log
func (m *VolumeInlineAntiRansomwareInlineEventLog) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline anti ransomware inline event log based on context it is used
func (m *VolumeInlineAntiRansomwareInlineEventLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineEventLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineEventLog) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineEventLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAntiRansomwareInlineSpace volume inline anti ransomware inline space
//
// swagger:model volume_inline_anti_ransomware_inline_space
type VolumeInlineAntiRansomwareInlineSpace struct {

	// Total number of Anti-ransomware backup snapshots.
	// Read Only: true
	SnapshotCount *int64 `json:"snapshot_count,omitempty"`

	// Total space in bytes used by the Anti-ransomware feature.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Space in bytes used by the Anti-ransomware analytics logs.
	// Read Only: true
	UsedByLogs *int64 `json:"used_by_logs,omitempty"`

	// Space in bytes used by the Anti-ransomware backup snapshots.
	// Read Only: true
	UsedBySnapshots *int64 `json:"used_by_snapshots,omitempty"`
}

// Validate validates this volume inline anti ransomware inline space
func (m *VolumeInlineAntiRansomwareInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline anti ransomware inline space based on the context it is used
func (m *VolumeInlineAntiRansomwareInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSnapshotCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedByLogs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSpace) contextValidateSnapshotCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"space"+"."+"snapshot_count", "body", m.SnapshotCount); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSpace) contextValidateUsedByLogs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"space"+"."+"used_by_logs", "body", m.UsedByLogs); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSpace) contextValidateUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"space"+"."+"used_by_snapshots", "body", m.UsedBySnapshots); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAntiRansomwareInlineSurgeUsage Usage values of the volume's workload during surge. This object is no longer supported use surge_statistics instead.
//
// swagger:model volume_inline_anti_ransomware_inline_surge_usage
type VolumeInlineAntiRansomwareInlineSurgeUsage struct {

	// Peak rate of file creates per minute in the workload of the volume during surge.
	// Example: 10
	// Read Only: true
	FileCreatePeakRatePerMinute *int64 `json:"file_create_peak_rate_per_minute,omitempty"`

	// Peak rate of file deletes per minute in the workload of the volume during surge.
	// Example: 50
	// Read Only: true
	FileDeletePeakRatePerMinute *int64 `json:"file_delete_peak_rate_per_minute,omitempty"`

	// Peak rate of file renames per minute in the workload of the volume during surge.
	// Example: 30
	// Read Only: true
	FileRenamePeakRatePerMinute *int64 `json:"file_rename_peak_rate_per_minute,omitempty"`

	// Peak percentage of high entropy data writes in the volume during surge.
	// Example: 30
	// Read Only: true
	HighEntropyDataWritePeakPercent *int64 `json:"high_entropy_data_write_peak_percent,omitempty"`

	// Peak high entropy data write rate in the volume during surge, in KBs per minute.
	// Example: 2500
	// Read Only: true
	HighEntropyDataWritePeakRateKbPerMinute *int64 `json:"high_entropy_data_write_peak_rate_kb_per_minute,omitempty"`

	// Timestamp at which the first surge in the volume's workload is observed.
	// Example: 2021-12-01 23:16:20+05:30
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this volume inline anti ransomware inline surge usage
func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("anti_ransomware"+"."+"surge_usage"+"."+"time", "body", "date-time", m.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline anti ransomware inline surge usage based on the context it is used
func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFileCreatePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileDeletePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileRenamePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHighEntropyDataWritePeakPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateFileCreatePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"surge_usage"+"."+"file_create_peak_rate_per_minute", "body", m.FileCreatePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateFileDeletePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"surge_usage"+"."+"file_delete_peak_rate_per_minute", "body", m.FileDeletePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateFileRenamePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"surge_usage"+"."+"file_rename_peak_rate_per_minute", "body", m.FileRenamePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateHighEntropyDataWritePeakPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"surge_usage"+"."+"high_entropy_data_write_peak_percent", "body", m.HighEntropyDataWritePeakPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"surge_usage"+"."+"high_entropy_data_write_peak_rate_kb_per_minute", "body", m.HighEntropyDataWritePeakRateKbPerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"surge_usage"+"."+"time", "body", m.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineSurgeUsage) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineSurgeUsage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeAntiRansomwareSuspectFilesItems0 volume anti ransomware suspect files items0
//
// swagger:model VolumeAntiRansomwareSuspectFilesItems0
type VolumeAntiRansomwareSuspectFilesItems0 struct {

	// Total number of `suspect_files.format` files observed by the Anti-ransomware analytics engine on the volume.
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Indicates the entropy level of this file type.
	// Read Only: true
	Entropy *string `json:"entropy,omitempty"`

	// File formats observed by the Anti-ransomware analytics engine on the volume.
	// Read Only: true
	Format *string `json:"format,omitempty"`
}

// Validate validates this volume anti ransomware suspect files items0
func (m *VolumeAntiRansomwareSuspectFilesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume anti ransomware suspect files items0 based on the context it is used
func (m *VolumeAntiRansomwareSuspectFilesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntropy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeAntiRansomwareSuspectFilesItems0) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeAntiRansomwareSuspectFilesItems0) contextValidateEntropy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entropy", "body", m.Entropy); err != nil {
		return err
	}

	return nil
}

func (m *VolumeAntiRansomwareSuspectFilesItems0) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeAntiRansomwareSuspectFilesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeAntiRansomwareSuspectFilesItems0) UnmarshalBinary(b []byte) error {
	var res VolumeAntiRansomwareSuspectFilesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAntiRansomwareInlineTypicalUsage Typical usage values of volume workload. This object is no longer supported use historical_statistics instead.
//
// swagger:model volume_inline_anti_ransomware_inline_typical_usage
type VolumeInlineAntiRansomwareInlineTypicalUsage struct {

	// Typical peak rate of file creates per minute in the workload of the volume.
	// Example: 50
	// Read Only: true
	FileCreatePeakRatePerMinute *int64 `json:"file_create_peak_rate_per_minute,omitempty"`

	// Typical peak rate of file deletes per minute in the workload of the volume.
	// Example: 10
	// Read Only: true
	FileDeletePeakRatePerMinute *int64 `json:"file_delete_peak_rate_per_minute,omitempty"`

	// Typical peak rate of file renames per minute in the workload of the volume.
	// Example: 5
	// Read Only: true
	FileRenamePeakRatePerMinute *int64 `json:"file_rename_peak_rate_per_minute,omitempty"`

	// Typical peak percentage of high entropy data writes in the volume.
	// Example: 10
	// Read Only: true
	HighEntropyDataWritePeakPercent *int64 `json:"high_entropy_data_write_peak_percent,omitempty"`

	// Typical peak high entropy data write rate in the volume, in KBs per minute.
	// Example: 1200
	// Read Only: true
	HighEntropyDataWritePeakRateKbPerMinute *int64 `json:"high_entropy_data_write_peak_rate_kb_per_minute,omitempty"`
}

// Validate validates this volume inline anti ransomware inline typical usage
func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline anti ransomware inline typical usage based on the context it is used
func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFileCreatePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileDeletePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileRenamePeakRatePerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHighEntropyDataWritePeakPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateFileCreatePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"typical_usage"+"."+"file_create_peak_rate_per_minute", "body", m.FileCreatePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateFileDeletePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"typical_usage"+"."+"file_delete_peak_rate_per_minute", "body", m.FileDeletePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateFileRenamePeakRatePerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"typical_usage"+"."+"file_rename_peak_rate_per_minute", "body", m.FileRenamePeakRatePerMinute); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateHighEntropyDataWritePeakPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"typical_usage"+"."+"high_entropy_data_write_peak_percent", "body", m.HighEntropyDataWritePeakPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) contextValidateHighEntropyDataWritePeakRateKbPerMinute(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"typical_usage"+"."+"high_entropy_data_write_peak_rate_kb_per_minute", "body", m.HighEntropyDataWritePeakRateKbPerMinute); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAntiRansomwareInlineTypicalUsage) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAntiRansomwareInlineTypicalUsage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineApplication volume inline application
//
// swagger:model volume_inline_application
type VolumeInlineApplication struct {

	// Name of the application to which the volume belongs. Available only when the volume is part of an application.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// UUID of the application to which the volume belongs. Available only when the volume is part of an application.
	// Example: 1cd8a442-86d1-11e0-ae1d-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline application
func (m *VolumeInlineApplication) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline application based on the context it is used
func (m *VolumeInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineApplication) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "application"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineApplication) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "application"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineApplication) UnmarshalBinary(b []byte) error {
	var res VolumeInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAsynchronousDirectoryDelete Configuration for asynchronous directory delete from the client. This is only supported on Flexible volumes and FlexGroup volumes.
//
// swagger:model volume_inline_asynchronous_directory_delete
type VolumeInlineAsynchronousDirectoryDelete struct {

	// Specifies whether asynchronous directory delete from the client is enabled on the volume.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of the trash bin directory. If no "trash_bin" property is specified when enabling, the default trash bin name, "._ontaptrashbin", is used.
	TrashBin *string `json:"trash_bin,omitempty"`
}

// Validate validates this volume inline asynchronous directory delete
func (m *VolumeInlineAsynchronousDirectoryDelete) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline asynchronous directory delete based on context it is used
func (m *VolumeInlineAsynchronousDirectoryDelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAsynchronousDirectoryDelete) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAsynchronousDirectoryDelete) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAsynchronousDirectoryDelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineAutosize volume inline autosize
//
// swagger:model volume_inline_autosize
type VolumeInlineAutosize struct {

	// Used space threshold size, in percentage, for the automatic growth of the volume. When the amount of used space in the volume becomes greater than this threshold, the volume automatically grows unless it has reached the maximum size. The volume grows when 'space.used' is greater than this percent of 'space.size'. The 'grow_threshold' size cannot be less than or equal to the 'shrink_threshold' size..
	GrowThreshold *int64 `json:"grow_threshold,omitempty"`

	// Maximum size in bytes up to which a volume grows automatically. This size cannot be less than the current volume size, or less than or equal to the minimum size of volume.
	Maximum *int64 `json:"maximum,omitempty"`

	// Minimum size in bytes up to which the volume shrinks automatically. This size cannot be greater than or equal to the maximum size of volume.
	Minimum *int64 `json:"minimum,omitempty"`

	// Autosize mode for the volume.<br>grow &dash; Volume automatically grows when the amount of used space is above the 'grow_threshold' value.<br>grow_shrink &dash; Volume grows or shrinks in response to the amount of space used.<br>off &dash; Autosizing of the volume is disabled.
	// Enum: ["grow","grow_shrink","off"]
	Mode *string `json:"mode,omitempty"`

	// Used space threshold size, in percentage, for the automatic shrinkage of the volume.  When the amount of used space in the volume drops below this threshold, the volume automatically shrinks unless it has reached the minimum size. The volume shrinks when the 'space.used' is less than the 'shrink_threshold' percent of 'space.size'. The 'shrink_threshold' size cannot be greater than or equal to the 'grow_threshold' size.
	ShrinkThreshold *int64 `json:"shrink_threshold,omitempty"`
}

// Validate validates this volume inline autosize
func (m *VolumeInlineAutosize) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineAutosizeTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["grow","grow_shrink","off"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineAutosizeTypeModePropEnum = append(volumeInlineAutosizeTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_autosize
	// VolumeInlineAutosize
	// mode
	// Mode
	// grow
	// END DEBUGGING
	// VolumeInlineAutosizeModeGrow captures enum value "grow"
	VolumeInlineAutosizeModeGrow string = "grow"

	// BEGIN DEBUGGING
	// volume_inline_autosize
	// VolumeInlineAutosize
	// mode
	// Mode
	// grow_shrink
	// END DEBUGGING
	// VolumeInlineAutosizeModeGrowShrink captures enum value "grow_shrink"
	VolumeInlineAutosizeModeGrowShrink string = "grow_shrink"

	// BEGIN DEBUGGING
	// volume_inline_autosize
	// VolumeInlineAutosize
	// mode
	// Mode
	// off
	// END DEBUGGING
	// VolumeInlineAutosizeModeOff captures enum value "off"
	VolumeInlineAutosizeModeOff string = "off"
)

// prop value enum
func (m *VolumeInlineAutosize) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineAutosizeTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineAutosize) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("autosize"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline autosize based on context it is used
func (m *VolumeInlineAutosize) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineAutosize) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineAutosize) UnmarshalBinary(b []byte) error {
	var res VolumeInlineAutosize
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineClone volume inline clone
//
// swagger:model volume_inline_clone
type VolumeInlineClone struct {

	// Specifies whether this volume is a parent of any FlexClone volume.
	// Read Only: true
	HasFlexclone *bool `json:"has_flexclone,omitempty"`

	// Inherited physical used from the clone's base snapshot.
	// Read Only: true
	InheritedPhysicalUsed *int64 `json:"inherited_physical_used,omitempty"`

	// Inherited savings from the clone's base snapshot.
	// Read Only: true
	InheritedSavings *int64 `json:"inherited_savings,omitempty"`

	// Specifies if this volume is a normal FlexVol volume or FlexClone volume. This field needs to be set when creating a FlexClone volume. Valid in POST.
	IsFlexclone *bool `json:"is_flexclone,omitempty"`

	// This optional parameter specifies the name of a LUN that will be non-disruptively migrated to the newly created FlexClone volume. If not specified, no LUNs are migrated.
	LunName *string `json:"lun_name,omitempty"`

	// parent snapshot
	ParentSnapshot *SnapshotReference `json:"parent_snapshot,omitempty"`

	// parent svm
	ParentSvm *VolumeInlineCloneInlineParentSvm `json:"parent_svm,omitempty"`

	// parent volume
	ParentVolume *VolumeInlineCloneInlineParentVolume `json:"parent_volume,omitempty"`

	// This optional parameter specifies the name of the qtree containing the LUN that will be non-disruptively migrated to the newly created FlexClone volume.
	QtreeName *string `json:"qtree_name,omitempty"`

	// Percentage of FlexClone volume blocks split from its parent volume.
	// Read Only: true
	SplitCompletePercent *int64 `json:"split_complete_percent,omitempty"`

	// Space required by the containing-aggregate to split the FlexClone volume.
	// Read Only: true
	SplitEstimate *int64 `json:"split_estimate,omitempty"`

	// This field is set when a split is executed on any FlexClone volume, that is when the FlexClone volume is split from its parent FlexVol volume. Setting this field initiates a split of a FlexClone volume from a FlexVol volume. Valid in PATCH.
	SplitInitiated *bool `json:"split_initiated,omitempty"`
}

// Validate validates this volume inline clone
func (m *VolumeInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateParentSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineClone) validateParentSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentSnapshot) { // not required
		return nil
	}

	if m.ParentSnapshot != nil {
		if err := m.ParentSnapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineClone) validateParentSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentSvm) { // not required
		return nil
	}

	if m.ParentSvm != nil {
		if err := m.ParentSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineClone) validateParentVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentVolume) { // not required
		return nil
	}

	if m.ParentVolume != nil {
		if err := m.ParentVolume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone based on the context it is used
func (m *VolumeInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHasFlexclone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInheritedPhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInheritedSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitCompletePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineClone) contextValidateHasFlexclone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"has_flexclone", "body", m.HasFlexclone); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateInheritedPhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"inherited_physical_used", "body", m.InheritedPhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateInheritedSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"inherited_savings", "body", m.InheritedSavings); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateParentSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentSnapshot != nil {
		if err := m.ParentSnapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateParentSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentSvm != nil {
		if err := m.ParentSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateParentVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentVolume != nil {
		if err := m.ParentVolume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_volume")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateSplitCompletePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"split_complete_percent", "body", m.SplitCompletePercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineClone) contextValidateSplitEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"split_estimate", "body", m.SplitEstimate); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineClone) UnmarshalBinary(b []byte) error {
	var res VolumeInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineCloneInlineParentSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model volume_inline_clone_inline_parent_svm
type VolumeInlineCloneInlineParentSvm struct {

	// links
	Links *VolumeInlineCloneInlineParentSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline clone inline parent svm
func (m *VolumeInlineCloneInlineParentSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent svm based on the context it is used
func (m *VolumeInlineCloneInlineParentSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentSvm) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineCloneInlineParentSvmInlineLinks volume inline clone inline parent svm inline links
//
// swagger:model volume_inline_clone_inline_parent_svm_inline__links
type VolumeInlineCloneInlineParentSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline clone inline parent svm inline links
func (m *VolumeInlineCloneInlineParentSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent svm inline links based on the context it is used
func (m *VolumeInlineCloneInlineParentSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineCloneInlineParentVolume volume inline clone inline parent volume
//
// swagger:model volume_inline_clone_inline_parent_volume
type VolumeInlineCloneInlineParentVolume struct {

	// links
	Links *VolumeInlineCloneInlineParentVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline clone inline parent volume
func (m *VolumeInlineCloneInlineParentVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent volume based on the context it is used
func (m *VolumeInlineCloneInlineParentVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentVolume) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineCloneInlineParentVolumeInlineLinks volume inline clone inline parent volume inline links
//
// swagger:model volume_inline_clone_inline_parent_volume_inline__links
type VolumeInlineCloneInlineParentVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline clone inline parent volume inline links
func (m *VolumeInlineCloneInlineParentVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline clone inline parent volume inline links based on the context it is used
func (m *VolumeInlineCloneInlineParentVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineCloneInlineParentVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineCloneInlineParentVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineCloneInlineParentVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConsistencyGroup Consistency group the volume is part of.
//
// swagger:model volume_inline_consistency_group
type VolumeInlineConsistencyGroup struct {

	// The name of the consistency group to which the volume belongs. Available only when the volume is part of a consistency group. If this volume belongs to a child consistency group, then this will be the UUID of the parent consistency group.
	// Example: consistency_group_1
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group to which the volume belongs. Available only when the volume is part of a consistency group. If this volume belongs to a child consistency group, then this will be the UUID of the parent consistency group.
	// Example: 1cd8a442-86d1-11e0-ae1d-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline consistency group
func (m *VolumeInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline consistency group based on the context it is used
func (m *VolumeInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItem volume inline constituents inline array item
//
// swagger:model volume_inline_constituents_inline_array_item
type VolumeInlineConstituentsInlineArrayItem struct {

	// aggregates
	Aggregates *VolumeInlineConstituentsInlineArrayItemInlineAggregates `json:"aggregates,omitempty"`

	// movement
	Movement *VolumeInlineConstituentsInlineArrayItemInlineMovement `json:"movement,omitempty"`

	// FlexGroup volume constituent name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *VolumeInlineConstituentsInlineArrayItemInlineNode `json:"node,omitempty"`

	// space
	Space *VolumeInlineConstituentsInlineArrayItemInlineSpace `json:"space,omitempty"`
}

// Validate validates this volume inline constituents inline array item
func (m *VolumeInlineConstituentsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) validateAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregates) { // not required
		return nil
	}

	if m.Aggregates != nil {
		if err := m.Aggregates.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregates")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(m.Movement) { // not required
		return nil
	}

	if m.Movement != nil {
		if err := m.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) contextValidateAggregates(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregates != nil {
		if err := m.Aggregates.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregates")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if m.Movement != nil {
		if err := m.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineAggregates volume inline constituents inline array item inline aggregates
//
// swagger:model volume_inline_constituents_inline_array_item_inline_aggregates
type VolumeInlineConstituentsInlineArrayItemInlineAggregates struct {

	// Name of the aggregate hosting the FlexGroup volume constituent.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Unique identifier for the aggregate.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline aggregates
func (m *VolumeInlineConstituentsInlineArrayItemInlineAggregates) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline aggregates based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineAggregates) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineAggregates) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregates"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineAggregates) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregates"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineAggregates) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineAggregates) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineAggregates
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineMovement Volume movement. All attributes are modify, that is, not writable through POST. Set PATCH state to destination_aggregate to initiate a volume move operation.
//
// swagger:model volume_inline_constituents_inline_array_item_inline_movement
type VolumeInlineConstituentsInlineArrayItemInlineMovement struct {

	// Time window in seconds for cutover. The allowed range is between 30 to 300 seconds.
	// Example: 30
	CutoverWindow *int64 `json:"cutover_window,omitempty"`

	// destination aggregate
	DestinationAggregate *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate `json:"destination_aggregate,omitempty"`

	// Completion percentage
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// State of volume move operation. PATCH the state to "aborted" to abort the move operation. PATCH the state to "cutover" to trigger cutover. PATCH the state to "paused" to pause the volume move operation in progress. PATCH the state to "replicating" to resume the paused volume move operation. PATCH the state to "cutover_wait" to go into cutover manually. When volume move operation is waiting to go into "cutover" state, this is indicated by the "cutover_pending" state. A change of state is only supported if volume movement is in progress.
	// Example: replicating
	// Enum: ["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]
	State *string `json:"state,omitempty"`

	// Tiering policy for FabricPool
	// Enum: ["all","auto","backup","none","snapshot_only"]
	TieringPolicy *string `json:"tiering_policy,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline movement
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestinationAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTieringPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateDestinationAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.DestinationAggregate) { // not required
		return nil
	}

	if m.DestinationAggregate != nil {
		if err := m.DestinationAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

var volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum = append(volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// aborted
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateAborted captures enum value "aborted"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// cutover
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutover captures enum value "cutover"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutover string = "cutover"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// cutover_wait
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverWait captures enum value "cutover_wait"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverWait string = "cutover_wait"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// cutover_pending
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverPending captures enum value "cutover_pending"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateCutoverPending string = "cutover_pending"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// failed
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateFailed captures enum value "failed"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateFailed string = "failed"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStatePaused captures enum value "paused"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// queued
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateQueued captures enum value "queued"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateQueued string = "queued"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// replicating
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateReplicating captures enum value "replicating"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// state
	// State
	// success
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementStateSuccess captures enum value "success"
	VolumeInlineConstituentsInlineArrayItemInlineMovementStateSuccess string = "success"
)

// prop value enum
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineConstituentsInlineArrayItemInlineMovementTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("movement"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum = append(volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// all
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAll captures enum value "all"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// auto
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAuto captures enum value "auto"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// backup
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyBackup captures enum value "backup"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// none
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyNone captures enum value "none"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_movement
	// VolumeInlineConstituentsInlineArrayItemInlineMovement
	// tiering_policy
	// TieringPolicy
	// snapshot_only
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicySnapshotOnly captures enum value "snapshot_only"
	VolumeInlineConstituentsInlineArrayItemInlineMovementTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateTieringPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineConstituentsInlineArrayItemInlineMovementTypeTieringPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) validateTieringPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.TieringPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateTieringPolicyEnum("movement"+"."+"tiering_policy", "body", *m.TieringPolicy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline movement based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestinationAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) contextValidateDestinationAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.DestinationAggregate != nil {
		if err := m.DestinationAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate Aggregate
//
// swagger:model volume_inline_constituents_inline_array_item_inline_movement_inline_destination_aggregate
type VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate struct {

	// links
	Links *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline movement inline destination aggregate
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline movement inline destination aggregate based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks volume inline constituents inline array item inline movement inline destination aggregate inline links
//
// swagger:model volume_inline_constituents_inline_array_item_inline_movement_inline_destination_aggregate_inline__links
type VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline movement inline destination aggregate inline links
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline movement inline destination aggregate inline links based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineMovementInlineDestinationAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineNode volume inline constituents inline array item inline node
//
// swagger:model volume_inline_constituents_inline_array_item_inline_node
type VolumeInlineConstituentsInlineArrayItemInlineNode struct {

	// List of the node names hosting the FlexGroup volume constituent.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// List of the node UUIDs hosting the FlexGroup volume constituent.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline node
func (m *VolumeInlineConstituentsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline node based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineNode) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineNode) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineSpace volume inline constituents inline array item inline space
//
// swagger:model volume_inline_constituents_inline_array_item_inline_space
type VolumeInlineConstituentsInlineArrayItemInlineSpace struct {

	// Total size of AFS, excluding snap-reserve, in bytes.
	AfsTotal *int64 `json:"afs_total,omitempty"`

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The space available, as a percent.
	AvailablePercent *int64 `json:"available_percent,omitempty"`

	// The size that is physically used in the block storage of the volume and has a cold temperature. In bytes. This parameter is only supported if the volume is in an aggregate that is either attached to a cloud store or could be attached to a cloud store.
	// Read Only: true
	BlockStorageInactiveUserData *int64 `json:"block_storage_inactive_user_data,omitempty"`

	// Space used by capacity tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	CapacityTierFootprint *int64 `json:"capacity_tier_footprint,omitempty"`

	// Data used for this volume in the aggregate, in bytes.
	// Read Only: true
	Footprint *int64 `json:"footprint,omitempty"`

	// Specifies whether the support for large volumes and large files is enabled on the volume.
	LargeSizeEnabled *bool `json:"large_size_enabled,omitempty"`

	// Space used by the local tier for this volume in the aggregate, in bytes.
	// Read Only: true
	LocalTierFootprint *int64 `json:"local_tier_footprint,omitempty"`

	// logical space
	LogicalSpace *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace `json:"logical_space,omitempty"`

	// Indicates the maximum size supported for each constituent of the FlexGroup volume.
	// Enum: ["100T","300T","600T"]
	MaxSize *string `json:"max_size,omitempty"`

	// Space used by the volume metadata in the aggregate, in bytes.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// The amount of space not available for this volume in the aggregate, in bytes.
	// Read Only: true
	OverProvisioned *int64 `json:"over_provisioned,omitempty"`

	// Space used by the performance tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	PerformanceTierFootprint *int64 `json:"performance_tier_footprint,omitempty"`

	// Total provisioned size. The default size is equal to the minimum size of 20MB, in bytes.
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// Data and metadata used for this volume in the aggregate, in bytes.
	// Read Only: true
	TotalFootprint *int64 `json:"total_footprint,omitempty"`

	// Space used by the total metadata in the volume, in bytes.
	// Read Only: true
	TotalMetadata *int64 `json:"total_metadata,omitempty"`

	// Space used by the volume metadata footprint in the aggregate, in bytes.
	// Read Only: true
	TotalMetadataFootprint *int64 `json:"total_metadata_footprint,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The space used by Active Filesystem, in bytes.
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, as a percent.
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline space
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLogicalSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateLogicalSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.LogicalSpace) { // not required
		return nil
	}

	if m.LogicalSpace != nil {
		if err := m.LogicalSpace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

var volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["100T","300T","600T"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum = append(volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_space
	// VolumeInlineConstituentsInlineArrayItemInlineSpace
	// max_size
	// MaxSize
	// 100T
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr100T captures enum value "100T"
	VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr100T string = "100T"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_space
	// VolumeInlineConstituentsInlineArrayItemInlineSpace
	// max_size
	// MaxSize
	// 300T
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr300T captures enum value "300T"
	VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr300T string = "300T"

	// BEGIN DEBUGGING
	// volume_inline_constituents_inline_array_item_inline_space
	// VolumeInlineConstituentsInlineArrayItemInlineSpace
	// max_size
	// MaxSize
	// 600T
	// END DEBUGGING
	// VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr600T captures enum value "600T"
	VolumeInlineConstituentsInlineArrayItemInlineSpaceMaxSizeNr600T string = "600T"
)

// prop value enum
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateMaxSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineConstituentsInlineArrayItemInlineSpaceTypeMaxSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateMaxSize(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateMaxSizeEnum("space"+"."+"max_size", "body", *m.MaxSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline space based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockStorageInactiveUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacityTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePerformanceTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalMetadataFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateBlockStorageInactiveUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage_inactive_user_data", "body", m.BlockStorageInactiveUserData); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateCapacityTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"capacity_tier_footprint", "body", m.CapacityTierFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"footprint", "body", m.Footprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateLocalTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"local_tier_footprint", "body", m.LocalTierFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateLogicalSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.LogicalSpace != nil {
		if err := m.LogicalSpace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"metadata", "body", m.Metadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateOverProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"over_provisioned", "body", m.OverProvisioned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidatePerformanceTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"performance_tier_footprint", "body", m.PerformanceTierFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateTotalFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_footprint", "body", m.TotalFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateTotalMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata", "body", m.TotalMetadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateTotalMetadataFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata_footprint", "body", m.TotalMetadataFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace volume inline constituents inline array item inline space inline logical space
//
// swagger:model volume_inline_constituents_inline_array_item_inline_space_inline_logical_space
type VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace struct {

	// The amount of space available in this volume with storage efficiency space considered used, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Specifies whether space accounting for operations on the volume is done along with storage efficiency.
	Enforcement *bool `json:"enforcement,omitempty"`

	// Specifies whether space reporting on the volume is done along with storage efficiency.
	Reporting *bool `json:"reporting,omitempty"`

	// The virtual space used by AFS alone (includes volume reserves) and along with storage efficiency, in bytes.
	// Read Only: true
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline space inline logical space
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline space inline logical space based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedByAfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) contextValidateUsedByAfs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"used_by_afs", "body", m.UsedByAfs); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineLogicalSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot volume inline constituents inline array item inline space inline snapshot
//
// swagger:model volume_inline_constituents_inline_array_item_inline_space_inline_snapshot
type VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot struct {

	// Specifies whether snapshot autodelete is currently enabled on this volume.
	AutodeleteEnabled *bool `json:"autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// The total space used by snapshots in the volume, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this volume inline constituents inline array item inline space inline snapshot
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline constituents inline array item inline space inline snapshot based on the context it is used
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res VolumeInlineConstituentsInlineArrayItemInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEfficiency volume inline efficiency
//
// swagger:model volume_inline_efficiency
type VolumeInlineEfficiency struct {

	// Block size to use by compression. 8k and auto are only allowed for POST. Only auto is supported on QAT supported platforms.
	// Enum: ["8k","16k","32k","auto"]
	ApplicationIoSize *string `json:"application_io_size,omitempty"`

	// Automatic deduplication schedule volume state.<br>auto &dash; Volumes with auto_state set to auto start post-process deduplication automatically.<br>deprioritized &dash; Volumes with auto_state set to deprioritized do not start post-process deduplication automatically.
	// Read Only: true
	// Enum: ["auto","deprioritized"]
	AutoState *string `json:"auto_state,omitempty"`

	// The system can be enabled/disabled compaction.<br>inline &dash; Data will be compacted first and written to the volume.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are compaction enabled and some are disabled.
	// Enum: ["inline","none","mixed"]
	Compaction *string `json:"compaction,omitempty"`

	// The system can be enabled/disabled compression. Disabling compression is not allowed on Capacity optimized Flash with QAT supported platforms.<br>inline &dash; Data will be compressed first and written to the volume. <br>background &dash; Data will be written to the volume and compressed later. <br>both &dash; Inline compression compresses the data and write to the volume, background compression compresses only the blocks on which inline compression is not run.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are compression enabled and some are disabled. <br>Note that On volumes with container compression enabled, background compression refers to inactive data compression scan enabled on the volume.
	// Enum: ["inline","background","both","none","mixed"]
	Compression *string `json:"compression,omitempty"`

	// Compression type to use by compression. Valid for PATCH and GET.
	// Enum: ["none","secondary","adaptive"]
	CompressionType *string `json:"compression_type,omitempty"`

	// The system can be enabled/disabled cross volume dedupe. it can be enabled only when dedupe is enabled. Disabling cross volume dedupe is not allowed on Capacity optimized Flash with QAT supported platforms.<br>inline &dash; Data will be cross volume deduped first and written to the volume.<br>background &dash; Data will be written to the volume and cross volume deduped later.<br>both &dash; Inline cross volume dedupe dedupes the data and write to the volume, background cross volume dedupe dedupes only the blocks on which inline dedupe is not run.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are cross volume dedupe enabled and some are disabled.
	// Enum: ["inline","background","both","none","mixed"]
	CrossVolumeDedupe *string `json:"cross_volume_dedupe,omitempty"`

	// The system can be enabled/disabled dedupe. Disabling dedupe is not allowed on Capacity optimized Flash with QAT supported platforms.<br>inline &dash; Data will be deduped first and written to the volume.<br>background &dash; Data will be written to the volume and deduped later.<br>both &dash; Inline dedupe dedupes the data and write to the volume, background dedupe dedupes only the blocks on which inline dedupe is not run.<br>none &dash; None<br>mixed &dash; Read only field for FlexGroup volumes, where some of the constituent volumes are dedupe enabled and some are disabled.
	// Enum: ["inline","background","both","none","mixed"]
	Dedupe *string `json:"dedupe,omitempty"`

	// When true, indicates that the volume contains shared(deduplication, file clones) or compressed data.
	// Read Only: true
	HasSavings *bool `json:"has_savings,omitempty"`

	// idcs scanner
	IdcsScanner *VolumeInlineEfficiencyInlineIdcsScanner `json:"idcs_scanner,omitempty"`

	// Last sis operation begin timestamp.
	// Read Only: true
	LastOpBegin *string `json:"last_op_begin,omitempty"`

	// Last sis operation end timestamp.
	// Read Only: true
	LastOpEnd *string `json:"last_op_end,omitempty"`

	// Last sis operation error text.
	// Read Only: true
	LastOpErr *string `json:"last_op_err,omitempty"`

	// Last sis operation size.
	// Read Only: true
	LastOpSize *int64 `json:"last_op_size,omitempty"`

	// Last sis operation state.
	// Read Only: true
	LastOpState *string `json:"last_op_state,omitempty"`

	// When true, indicates that space savings for any newly-written data are being logged.
	// Read Only: true
	LoggingEnabled *bool `json:"logging_enabled,omitempty"`

	// Sis status of the volume.
	// Read Only: true
	// Enum: ["idle","initializing","active","undoing","pending","downgrading","disabled"]
	OpState *string `json:"op_state,omitempty"`

	// policy
	Policy *VolumeInlineEfficiencyInlinePolicy `json:"policy,omitempty"`

	// Sis progress of the volume.
	// Read Only: true
	Progress *string `json:"progress,omitempty"`

	// Storage efficiency that does not include the savings provided by snapshots.
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// scanner
	Scanner *VolumeInlineEfficiencyInlineScanner `json:"scanner,omitempty"`

	// Schedule associated with volume.
	// Read Only: true
	Schedule *string `json:"schedule,omitempty"`

	// space savings
	SpaceSavings *VolumeInlineEfficiencyInlineSpaceSavings `json:"space_savings,omitempty"`

	// Storage efficiency state of the volume. Currently, this field supports POST/PATCH only for RW (Read-Write) volumes on FSx for ONTAP and Cloud Volumes ONTAP.<br>disabled &dash; All storage efficiency features are disabled.<br>mixed &dash; Read-only field for FlexGroup volumes, storage efficiency is enabled on certain constituents and disabled on others.<br>On FSx for ONTAP and Cloud Volumes ONTAP &dash; <br> &emsp; enabled &dash; All supported storage efficiency features for the volume are enabled.<br> &emsp; custom &dash; Read-only field currently only supported for the FSx for ONTAP and Cloud Volumes ONTAP, user-defined storage efficiency features are enabled.<br>For other platforms &dash; <br> &emsp; enabled &dash; At least one storage efficiency feature for the volume is enabled.
	// Enum: ["disabled","enabled","mixed","custom"]
	State *string `json:"state,omitempty"`

	// Storage efficiency mode used by volume. This parameter is supported only on AFF platforms. There is no difference between default and efficient modes on QAT supported platforms and auto adaptive compression is set irrespective of the modes.
	// Enum: ["default","efficient"]
	StorageEfficiencyMode *string `json:"storage_efficiency_mode,omitempty"`

	// Sis Type of the volume.
	// Read Only: true
	// Enum: ["regular","snapvault"]
	Type *string `json:"type,omitempty"`

	// Absolute volume path of the volume.
	// Read Only: true
	VolumePath *string `json:"volume_path,omitempty"`
}

// Validate validates this volume inline efficiency
func (m *VolumeInlineEfficiency) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplicationIoSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutoState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompaction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompression(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompressionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCrossVolumeDedupe(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDedupe(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdcsScanner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpaceSavings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageEfficiencyMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEfficiencyTypeApplicationIoSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["8k","16k","32k","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeApplicationIoSizePropEnum = append(volumeInlineEfficiencyTypeApplicationIoSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// 8k
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeNr8k captures enum value "8k"
	VolumeInlineEfficiencyApplicationIoSizeNr8k string = "8k"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// 16k
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeNr16k captures enum value "16k"
	VolumeInlineEfficiencyApplicationIoSizeNr16k string = "16k"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// 32k
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeNr32k captures enum value "32k"
	VolumeInlineEfficiencyApplicationIoSizeNr32k string = "32k"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// application_io_size
	// ApplicationIoSize
	// auto
	// END DEBUGGING
	// VolumeInlineEfficiencyApplicationIoSizeAuto captures enum value "auto"
	VolumeInlineEfficiencyApplicationIoSizeAuto string = "auto"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateApplicationIoSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeApplicationIoSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateApplicationIoSize(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationIoSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateApplicationIoSizeEnum("efficiency"+"."+"application_io_size", "body", *m.ApplicationIoSize); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeAutoStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["auto","deprioritized"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeAutoStatePropEnum = append(volumeInlineEfficiencyTypeAutoStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// auto_state
	// AutoState
	// auto
	// END DEBUGGING
	// VolumeInlineEfficiencyAutoStateAuto captures enum value "auto"
	VolumeInlineEfficiencyAutoStateAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// auto_state
	// AutoState
	// deprioritized
	// END DEBUGGING
	// VolumeInlineEfficiencyAutoStateDeprioritized captures enum value "deprioritized"
	VolumeInlineEfficiencyAutoStateDeprioritized string = "deprioritized"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateAutoStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeAutoStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateAutoState(formats strfmt.Registry) error {
	if swag.IsZero(m.AutoState) { // not required
		return nil
	}

	// value enum
	if err := m.validateAutoStateEnum("efficiency"+"."+"auto_state", "body", *m.AutoState); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCompactionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCompactionPropEnum = append(volumeInlineEfficiencyTypeCompactionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compaction
	// Compaction
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyCompactionInline captures enum value "inline"
	VolumeInlineEfficiencyCompactionInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compaction
	// Compaction
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCompactionNone captures enum value "none"
	VolumeInlineEfficiencyCompactionNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compaction
	// Compaction
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyCompactionMixed captures enum value "mixed"
	VolumeInlineEfficiencyCompactionMixed string = "mixed"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateCompactionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCompactionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateCompaction(formats strfmt.Registry) error {
	if swag.IsZero(m.Compaction) { // not required
		return nil
	}

	// value enum
	if err := m.validateCompactionEnum("efficiency"+"."+"compaction", "body", *m.Compaction); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCompressionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","background","both","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCompressionPropEnum = append(volumeInlineEfficiencyTypeCompressionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionInline captures enum value "inline"
	VolumeInlineEfficiencyCompressionInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// background
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionBackground captures enum value "background"
	VolumeInlineEfficiencyCompressionBackground string = "background"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// both
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionBoth captures enum value "both"
	VolumeInlineEfficiencyCompressionBoth string = "both"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionNone captures enum value "none"
	VolumeInlineEfficiencyCompressionNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression
	// Compression
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionMixed captures enum value "mixed"
	VolumeInlineEfficiencyCompressionMixed string = "mixed"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateCompressionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCompressionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateCompression(formats strfmt.Registry) error {
	if swag.IsZero(m.Compression) { // not required
		return nil
	}

	// value enum
	if err := m.validateCompressionEnum("efficiency"+"."+"compression", "body", *m.Compression); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCompressionTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","secondary","adaptive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCompressionTypePropEnum = append(volumeInlineEfficiencyTypeCompressionTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression_type
	// CompressionType
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionTypeNone captures enum value "none"
	VolumeInlineEfficiencyCompressionTypeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression_type
	// CompressionType
	// secondary
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionTypeSecondary captures enum value "secondary"
	VolumeInlineEfficiencyCompressionTypeSecondary string = "secondary"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// compression_type
	// CompressionType
	// adaptive
	// END DEBUGGING
	// VolumeInlineEfficiencyCompressionTypeAdaptive captures enum value "adaptive"
	VolumeInlineEfficiencyCompressionTypeAdaptive string = "adaptive"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateCompressionTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCompressionTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateCompressionType(formats strfmt.Registry) error {
	if swag.IsZero(m.CompressionType) { // not required
		return nil
	}

	// value enum
	if err := m.validateCompressionTypeEnum("efficiency"+"."+"compression_type", "body", *m.CompressionType); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","background","both","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum = append(volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeInline captures enum value "inline"
	VolumeInlineEfficiencyCrossVolumeDedupeInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// background
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeBackground captures enum value "background"
	VolumeInlineEfficiencyCrossVolumeDedupeBackground string = "background"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// both
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeBoth captures enum value "both"
	VolumeInlineEfficiencyCrossVolumeDedupeBoth string = "both"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeNone captures enum value "none"
	VolumeInlineEfficiencyCrossVolumeDedupeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// cross_volume_dedupe
	// CrossVolumeDedupe
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyCrossVolumeDedupeMixed captures enum value "mixed"
	VolumeInlineEfficiencyCrossVolumeDedupeMixed string = "mixed"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateCrossVolumeDedupeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeCrossVolumeDedupePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateCrossVolumeDedupe(formats strfmt.Registry) error {
	if swag.IsZero(m.CrossVolumeDedupe) { // not required
		return nil
	}

	// value enum
	if err := m.validateCrossVolumeDedupeEnum("efficiency"+"."+"cross_volume_dedupe", "body", *m.CrossVolumeDedupe); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeDedupePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["inline","background","both","none","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeDedupePropEnum = append(volumeInlineEfficiencyTypeDedupePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// inline
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeInline captures enum value "inline"
	VolumeInlineEfficiencyDedupeInline string = "inline"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// background
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeBackground captures enum value "background"
	VolumeInlineEfficiencyDedupeBackground string = "background"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// both
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeBoth captures enum value "both"
	VolumeInlineEfficiencyDedupeBoth string = "both"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// none
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeNone captures enum value "none"
	VolumeInlineEfficiencyDedupeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// dedupe
	// Dedupe
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyDedupeMixed captures enum value "mixed"
	VolumeInlineEfficiencyDedupeMixed string = "mixed"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateDedupeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeDedupePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateDedupe(formats strfmt.Registry) error {
	if swag.IsZero(m.Dedupe) { // not required
		return nil
	}

	// value enum
	if err := m.validateDedupeEnum("efficiency"+"."+"dedupe", "body", *m.Dedupe); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) validateIdcsScanner(formats strfmt.Registry) error {
	if swag.IsZero(m.IdcsScanner) { // not required
		return nil
	}

	if m.IdcsScanner != nil {
		if err := m.IdcsScanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "idcs_scanner")
			}
			return err
		}
	}

	return nil
}

var volumeInlineEfficiencyTypeOpStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","initializing","active","undoing","pending","downgrading","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeOpStatePropEnum = append(volumeInlineEfficiencyTypeOpStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// idle
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateIdle captures enum value "idle"
	VolumeInlineEfficiencyOpStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// initializing
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateInitializing captures enum value "initializing"
	VolumeInlineEfficiencyOpStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// active
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateActive captures enum value "active"
	VolumeInlineEfficiencyOpStateActive string = "active"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// undoing
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateUndoing captures enum value "undoing"
	VolumeInlineEfficiencyOpStateUndoing string = "undoing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// pending
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStatePending captures enum value "pending"
	VolumeInlineEfficiencyOpStatePending string = "pending"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// downgrading
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateDowngrading captures enum value "downgrading"
	VolumeInlineEfficiencyOpStateDowngrading string = "downgrading"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// op_state
	// OpState
	// disabled
	// END DEBUGGING
	// VolumeInlineEfficiencyOpStateDisabled captures enum value "disabled"
	VolumeInlineEfficiencyOpStateDisabled string = "disabled"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateOpStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeOpStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateOpState(formats strfmt.Registry) error {
	if swag.IsZero(m.OpState) { // not required
		return nil
	}

	// value enum
	if err := m.validateOpStateEnum("efficiency"+"."+"op_state", "body", *m.OpState); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEfficiency) validateScanner(formats strfmt.Registry) error {
	if swag.IsZero(m.Scanner) { // not required
		return nil
	}

	if m.Scanner != nil {
		if err := m.Scanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEfficiency) validateSpaceSavings(formats strfmt.Registry) error {
	if swag.IsZero(m.SpaceSavings) { // not required
		return nil
	}

	if m.SpaceSavings != nil {
		if err := m.SpaceSavings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "space_savings")
			}
			return err
		}
	}

	return nil
}

var volumeInlineEfficiencyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","mixed","custom"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeStatePropEnum = append(volumeInlineEfficiencyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// disabled
	// END DEBUGGING
	// VolumeInlineEfficiencyStateDisabled captures enum value "disabled"
	VolumeInlineEfficiencyStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// enabled
	// END DEBUGGING
	// VolumeInlineEfficiencyStateEnabled captures enum value "enabled"
	VolumeInlineEfficiencyStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// mixed
	// END DEBUGGING
	// VolumeInlineEfficiencyStateMixed captures enum value "mixed"
	VolumeInlineEfficiencyStateMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// state
	// State
	// custom
	// END DEBUGGING
	// VolumeInlineEfficiencyStateCustom captures enum value "custom"
	VolumeInlineEfficiencyStateCustom string = "custom"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("efficiency"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","efficient"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum = append(volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// storage_efficiency_mode
	// StorageEfficiencyMode
	// default
	// END DEBUGGING
	// VolumeInlineEfficiencyStorageEfficiencyModeDefault captures enum value "default"
	VolumeInlineEfficiencyStorageEfficiencyModeDefault string = "default"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// storage_efficiency_mode
	// StorageEfficiencyMode
	// efficient
	// END DEBUGGING
	// VolumeInlineEfficiencyStorageEfficiencyModeEfficient captures enum value "efficient"
	VolumeInlineEfficiencyStorageEfficiencyModeEfficient string = "efficient"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateStorageEfficiencyModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeStorageEfficiencyModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateStorageEfficiencyMode(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageEfficiencyMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageEfficiencyModeEnum("efficiency"+"."+"storage_efficiency_mode", "body", *m.StorageEfficiencyMode); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","snapvault"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyTypeTypePropEnum = append(volumeInlineEfficiencyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// type
	// Type
	// regular
	// END DEBUGGING
	// VolumeInlineEfficiencyTypeRegular captures enum value "regular"
	VolumeInlineEfficiencyTypeRegular string = "regular"

	// BEGIN DEBUGGING
	// volume_inline_efficiency
	// VolumeInlineEfficiency
	// type
	// Type
	// snapvault
	// END DEBUGGING
	// VolumeInlineEfficiencyTypeSnapvault captures enum value "snapvault"
	VolumeInlineEfficiencyTypeSnapvault string = "snapvault"
)

// prop value enum
func (m *VolumeInlineEfficiency) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiency) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("efficiency"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline efficiency based on the context it is used
func (m *VolumeInlineEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutoState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIdcsScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastOpBegin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastOpEnd(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastOpErr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastOpSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastOpState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLoggingEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpaceSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineEfficiency) contextValidateAutoState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"auto_state", "body", m.AutoState); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateHasSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"has_savings", "body", m.HasSavings); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateIdcsScanner(ctx context.Context, formats strfmt.Registry) error {

	if m.IdcsScanner != nil {
		if err := m.IdcsScanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "idcs_scanner")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateLastOpBegin(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"last_op_begin", "body", m.LastOpBegin); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateLastOpEnd(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"last_op_end", "body", m.LastOpEnd); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateLastOpErr(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"last_op_err", "body", m.LastOpErr); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateLastOpSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"last_op_size", "body", m.LastOpSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateLastOpState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"last_op_state", "body", m.LastOpState); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateLoggingEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"logging_enabled", "body", m.LoggingEnabled); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateOpState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"op_state", "body", m.OpState); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"progress", "body", m.Progress); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateScanner(ctx context.Context, formats strfmt.Registry) error {

	if m.Scanner != nil {
		if err := m.Scanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateSchedule(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"schedule", "body", m.Schedule); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateSpaceSavings(ctx context.Context, formats strfmt.Registry) error {

	if m.SpaceSavings != nil {
		if err := m.SpaceSavings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency" + "." + "space_savings")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiency) contextValidateVolumePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"volume_path", "body", m.VolumePath); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEfficiency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEfficiency) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEfficiencyInlineIdcsScanner Inactive data compression scan looks and picks up blocks that have not been read for a certain amount of time(threshold_inactive_days). These blocks are then compressed in 32K chunks. All attributes are valid for GET only, except for 'operation_state' which is valid for PATCH and GET, and is used to start/stop the scanner.
//
// swagger:model volume_inline_efficiency_inline_idcs_scanner
type VolumeInlineEfficiencyInlineIdcsScanner struct {

	// Specifies the administrative state of the inactive data compression scanner. Disabling inactive data compression is not allowed on Capacity optimized Flash with QAT supported platforms.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Data blocks older than, or equal to, 'inactive_days' are picked up by the inactive data compression scanner. Valid for PATCH only. Only applicable when 'operation_state' set to 'active'.
	InactiveDays *int64 `json:"inactive_days,omitempty"`

	// Specifies the mode of inactive data compression scanner. Valid for PATCH and GET.
	// Enum: ["default","compute_compression_savings"]
	Mode *string `json:"mode,omitempty"`

	// Specifies the operational state of the inactive data compression scanner. VALID for PATCH and GET. Valid options for PATCH are "idle" and "active".
	// Enum: ["idle","active"]
	OperationState *string `json:"operation_state,omitempty"`

	// Status of last inactive data compression scan on the volume.
	// Read Only: true
	// Enum: ["success","failure"]
	Status *string `json:"status,omitempty"`

	// Time interval after which inactive data compression is automatically triggered. The value is in days and is represented in the ISO-8601 format "P<num>D", for example "P3D" represents a duration of 3 days. This field is not supported on QAT supported platforms.
	// Example: P14D
	// Read Only: true
	ThresholdInactiveTime *string `json:"threshold_inactive_time,omitempty"`
}

// Validate validates this volume inline efficiency inline idcs scanner
func (m *VolumeInlineEfficiencyInlineIdcsScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperationState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","compute_compression_savings"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum = append(volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// mode
	// Mode
	// default
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerModeDefault captures enum value "default"
	VolumeInlineEfficiencyInlineIdcsScannerModeDefault string = "default"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// mode
	// Mode
	// compute_compression_savings
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerModeComputeCompressionSavings captures enum value "compute_compression_savings"
	VolumeInlineEfficiencyInlineIdcsScannerModeComputeCompressionSavings string = "compute_compression_savings"
)

// prop value enum
func (m *VolumeInlineEfficiencyInlineIdcsScanner) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineIdcsScannerTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiencyInlineIdcsScanner) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("efficiency"+"."+"idcs_scanner"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","active"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum = append(volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// operation_state
	// OperationState
	// idle
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerOperationStateIdle captures enum value "idle"
	VolumeInlineEfficiencyInlineIdcsScannerOperationStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// operation_state
	// OperationState
	// active
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerOperationStateActive captures enum value "active"
	VolumeInlineEfficiencyInlineIdcsScannerOperationStateActive string = "active"
)

// prop value enum
func (m *VolumeInlineEfficiencyInlineIdcsScanner) validateOperationStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineIdcsScannerTypeOperationStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiencyInlineIdcsScanner) validateOperationState(formats strfmt.Registry) error {
	if swag.IsZero(m.OperationState) { // not required
		return nil
	}

	// value enum
	if err := m.validateOperationStateEnum("efficiency"+"."+"idcs_scanner"+"."+"operation_state", "body", *m.OperationState); err != nil {
		return err
	}

	return nil
}

var volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum = append(volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// status
	// Status
	// success
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerStatusSuccess captures enum value "success"
	VolumeInlineEfficiencyInlineIdcsScannerStatusSuccess string = "success"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_idcs_scanner
	// VolumeInlineEfficiencyInlineIdcsScanner
	// status
	// Status
	// failure
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineIdcsScannerStatusFailure captures enum value "failure"
	VolumeInlineEfficiencyInlineIdcsScannerStatusFailure string = "failure"
)

// prop value enum
func (m *VolumeInlineEfficiencyInlineIdcsScanner) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineIdcsScannerTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiencyInlineIdcsScanner) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("efficiency"+"."+"idcs_scanner"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline efficiency inline idcs scanner based on the context it is used
func (m *VolumeInlineEfficiencyInlineIdcsScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThresholdInactiveTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineEfficiencyInlineIdcsScanner) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"idcs_scanner"+"."+"enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineIdcsScanner) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"idcs_scanner"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineIdcsScanner) contextValidateThresholdInactiveTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"idcs_scanner"+"."+"threshold_inactive_time", "body", m.ThresholdInactiveTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlineIdcsScanner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlineIdcsScanner) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlineIdcsScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEfficiencyInlinePolicy volume inline efficiency inline policy
//
// swagger:model volume_inline_efficiency_inline_policy
type VolumeInlineEfficiencyInlinePolicy struct {

	// Specifies the name of the efficiency policy. The "inline-only" and "none" policies are not supported on Capacity optimized Flash with QAT supported platform.
	Name *string `json:"name,omitempty"`
}

// Validate validates this volume inline efficiency inline policy
func (m *VolumeInlineEfficiencyInlinePolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline efficiency inline policy based on context it is used
func (m *VolumeInlineEfficiencyInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlinePolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEfficiencyInlineScanner volume inline efficiency inline scanner
//
// swagger:model volume_inline_efficiency_inline_scanner
type VolumeInlineEfficiencyInlineScanner struct {

	// Start compression if scanning old data. Valid for PATCH and GET. This option is not supported for FSX/CVO platforms.
	Compression *bool `json:"compression,omitempty"`

	// Start deduplication if scanning old data. Valid for PATCH and GET.
	Dedupe *bool `json:"dedupe,omitempty"`

	// Indicates whether or not to scan old data. Valid for PATCH and GET.
	ScanOldData *bool `json:"scan_old_data,omitempty"`

	// State of the volume efficiency scanner. Valid for PATCH and GET. Valid options for PATCH are "idle" and "active".
	// Enum: ["idle","initializing","active","undoing","pending","downgrading","disabled"]
	State *string `json:"state,omitempty"`
}

// Validate validates this volume inline efficiency inline scanner
func (m *VolumeInlineEfficiencyInlineScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEfficiencyInlineScannerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","initializing","active","undoing","pending","downgrading","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEfficiencyInlineScannerTypeStatePropEnum = append(volumeInlineEfficiencyInlineScannerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// idle
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateIdle captures enum value "idle"
	VolumeInlineEfficiencyInlineScannerStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// initializing
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateInitializing captures enum value "initializing"
	VolumeInlineEfficiencyInlineScannerStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// active
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateActive captures enum value "active"
	VolumeInlineEfficiencyInlineScannerStateActive string = "active"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// undoing
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateUndoing captures enum value "undoing"
	VolumeInlineEfficiencyInlineScannerStateUndoing string = "undoing"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// pending
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStatePending captures enum value "pending"
	VolumeInlineEfficiencyInlineScannerStatePending string = "pending"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// downgrading
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateDowngrading captures enum value "downgrading"
	VolumeInlineEfficiencyInlineScannerStateDowngrading string = "downgrading"

	// BEGIN DEBUGGING
	// volume_inline_efficiency_inline_scanner
	// VolumeInlineEfficiencyInlineScanner
	// state
	// State
	// disabled
	// END DEBUGGING
	// VolumeInlineEfficiencyInlineScannerStateDisabled captures enum value "disabled"
	VolumeInlineEfficiencyInlineScannerStateDisabled string = "disabled"
)

// prop value enum
func (m *VolumeInlineEfficiencyInlineScanner) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEfficiencyInlineScannerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEfficiencyInlineScanner) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("efficiency"+"."+"scanner"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline efficiency inline scanner based on context it is used
func (m *VolumeInlineEfficiencyInlineScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlineScanner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlineScanner) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlineScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEfficiencyInlineSpaceSavings volume inline efficiency inline space savings
//
// swagger:model volume_inline_efficiency_inline_space_savings
type VolumeInlineEfficiencyInlineSpaceSavings struct {

	// Total disk space that is saved by compressing blocks on the referenced file system, in bytes.
	// Read Only: true
	Compression *int64 `json:"compression,omitempty"`

	// Percentage of total disk space that is saved by compressing blocks on the referenced file system.
	// Read Only: true
	CompressionPercent *int64 `json:"compression_percent,omitempty"`

	// Total disk space that is saved by deduplication and file cloning, in bytes.
	// Read Only: true
	Dedupe *int64 `json:"dedupe,omitempty"`

	// Percentage of total disk space that is saved by deduplication and file cloning.
	// Read Only: true
	DedupePercent *int64 `json:"dedupe_percent,omitempty"`

	// Total disk space that is shared due to deduplication and file cloning.
	// Read Only: true
	DedupeSharing *int64 `json:"dedupe_sharing,omitempty"`

	// Total disk space saved in the volume due to deduplication, compression and file cloning, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// Percentage of total disk space saved in the volume due to deduplication, compression and file cloning.
	// Read Only: true
	TotalPercent *int64 `json:"total_percent,omitempty"`
}

// Validate validates this volume inline efficiency inline space savings
func (m *VolumeInlineEfficiencyInlineSpaceSavings) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline efficiency inline space savings based on the context it is used
func (m *VolumeInlineEfficiencyInlineSpaceSavings) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCompression(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompressionPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDedupePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDedupeSharing(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateCompression(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"compression", "body", m.Compression); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateCompressionPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"compression_percent", "body", m.CompressionPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"dedupe", "body", m.Dedupe); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateDedupePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"dedupe_percent", "body", m.DedupePercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateDedupeSharing(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"dedupe_sharing", "body", m.DedupeSharing); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEfficiencyInlineSpaceSavings) contextValidateTotalPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"space_savings"+"."+"total_percent", "body", m.TotalPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlineSpaceSavings) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEfficiencyInlineSpaceSavings) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEfficiencyInlineSpaceSavings
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEncryption volume inline encryption
//
// swagger:model volume_inline_encryption
type VolumeInlineEncryption struct {

	// This field can be used to pause an ongoing rekey or conversion operation or resume a paused rekey or conversion operation. Valid in PATCH. The following actions are supported for this field:<br>conversion_pause &dash; Pause an encryption conversion operation currently in progress.<br>conversion_resume &dash; Resume a paused encryption conversion operation.<br>rekey_pause &dash; Pause an encryption rekey operation currently in progress.<br>rekey_resume &dash; Resume a paused encryption rekey operation.
	// Enum: ["conversion_pause","conversion_resume","rekey_pause","rekey_resume"]
	Action *string `json:"action,omitempty"`

	// Creates an encrypted or an unencrypted volume. For POST, when set to 'true', a new key is generated and used to encrypt the given volume. In that case, the underlying SVM must be configured with the key manager. When set to 'false', the volume created will be unencrypted. For PATCH, when set to 'true', it encrypts an unencrypted volume. Specifying the parameter as 'false' in a PATCH operation for an encrypted volume is only supported when moving the volume to another aggregate.
	Enabled *bool `json:"enabled,omitempty"`

	// Encryption key creation time of the volume.
	// Example: 2022-01-01 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	KeyCreateTime *strfmt.DateTime `json:"key_create_time,omitempty"`

	// The key ID used for creating encrypted volume. A new key-id is generated for creating an encrypted volume. This key-id is associated with the generated key.
	// Read Only: true
	KeyID *string `json:"key_id,omitempty"`

	// Specifies an additional key manager attribute that is an identifier-value pair, separated by '='. For example, CRN=unique-value. This parameter is required when using the POST method and an IBM Key Lore key manager is configured on the SVM.
	// Example: CRN=v1:bluemix:public:containers-kubernetes:us-south:a/asdfghjkl1234:asdfghjkl1234:worker:kubernetes-asdfghjkl-worker1
	KeyManagerAttribute *string `json:"key_manager_attribute,omitempty"`

	// If set to 'true', re-encrypts the volume with a new key. Valid in PATCH.
	Rekey *bool `json:"rekey,omitempty"`

	// Volume encryption state.<br>encrypted &dash; The volume is completely encrypted.<br>encrypting &dash; Encryption operation is in progress.<br>partial &dash; Some constituents are encrypted and some are not. Applicable only for FlexGroup volume.<br>rekeying. Encryption of volume with a new key is in progress.<br>unencrypted &dash; The volume is a plain-text one.
	// Read Only: true
	// Enum: ["encrypted","encrypting","partial","rekeying","unencrypted"]
	State *string `json:"state,omitempty"`

	// status
	Status *VolumeInlineEncryptionInlineStatus `json:"status,omitempty"`

	// Volume encryption type.<br>none &dash; The volume is a plain-text one.<br>volume &dash; The volume is encrypted with NVE (NetApp Volume Encryption).<br>aggregate &dash; The volume is encrypted with NAE (NetApp Aggregate Encryption).
	// Read Only: true
	// Enum: ["none","volume","aggregate"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this volume inline encryption
func (m *VolumeInlineEncryption) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineEncryptionTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["conversion_pause","conversion_resume","rekey_pause","rekey_resume"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEncryptionTypeActionPropEnum = append(volumeInlineEncryptionTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// conversion_pause
	// END DEBUGGING
	// VolumeInlineEncryptionActionConversionPause captures enum value "conversion_pause"
	VolumeInlineEncryptionActionConversionPause string = "conversion_pause"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// conversion_resume
	// END DEBUGGING
	// VolumeInlineEncryptionActionConversionResume captures enum value "conversion_resume"
	VolumeInlineEncryptionActionConversionResume string = "conversion_resume"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// rekey_pause
	// END DEBUGGING
	// VolumeInlineEncryptionActionRekeyPause captures enum value "rekey_pause"
	VolumeInlineEncryptionActionRekeyPause string = "rekey_pause"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// action
	// Action
	// rekey_resume
	// END DEBUGGING
	// VolumeInlineEncryptionActionRekeyResume captures enum value "rekey_resume"
	VolumeInlineEncryptionActionRekeyResume string = "rekey_resume"
)

// prop value enum
func (m *VolumeInlineEncryption) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEncryptionTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEncryption) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("encryption"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEncryption) validateKeyCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyCreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("encryption"+"."+"key_create_time", "body", "date-time", m.KeyCreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineEncryptionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["encrypted","encrypting","partial","rekeying","unencrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEncryptionTypeStatePropEnum = append(volumeInlineEncryptionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// encrypted
	// END DEBUGGING
	// VolumeInlineEncryptionStateEncrypted captures enum value "encrypted"
	VolumeInlineEncryptionStateEncrypted string = "encrypted"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// encrypting
	// END DEBUGGING
	// VolumeInlineEncryptionStateEncrypting captures enum value "encrypting"
	VolumeInlineEncryptionStateEncrypting string = "encrypting"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// partial
	// END DEBUGGING
	// VolumeInlineEncryptionStatePartial captures enum value "partial"
	VolumeInlineEncryptionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// rekeying
	// END DEBUGGING
	// VolumeInlineEncryptionStateRekeying captures enum value "rekeying"
	VolumeInlineEncryptionStateRekeying string = "rekeying"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// state
	// State
	// unencrypted
	// END DEBUGGING
	// VolumeInlineEncryptionStateUnencrypted captures enum value "unencrypted"
	VolumeInlineEncryptionStateUnencrypted string = "unencrypted"
)

// prop value enum
func (m *VolumeInlineEncryption) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEncryptionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEncryption) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("encryption"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEncryption) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption" + "." + "status")
			}
			return err
		}
	}

	return nil
}

var volumeInlineEncryptionTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","volume","aggregate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineEncryptionTypeTypePropEnum = append(volumeInlineEncryptionTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// type
	// Type
	// none
	// END DEBUGGING
	// VolumeInlineEncryptionTypeNone captures enum value "none"
	VolumeInlineEncryptionTypeNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// type
	// Type
	// volume
	// END DEBUGGING
	// VolumeInlineEncryptionTypeVolume captures enum value "volume"
	VolumeInlineEncryptionTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_encryption
	// VolumeInlineEncryption
	// type
	// Type
	// aggregate
	// END DEBUGGING
	// VolumeInlineEncryptionTypeAggregate captures enum value "aggregate"
	VolumeInlineEncryptionTypeAggregate string = "aggregate"
)

// prop value enum
func (m *VolumeInlineEncryption) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineEncryptionTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineEncryption) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("encryption"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline encryption based on the context it is used
func (m *VolumeInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateKeyCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeyID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineEncryption) contextValidateKeyCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"key_create_time", "body", m.KeyCreateTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEncryption) contextValidateKeyID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"key_id", "body", m.KeyID); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEncryption) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEncryption) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineEncryption) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEncryption) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineEncryptionInlineStatus volume inline encryption inline status
//
// swagger:model volume_inline_encryption_inline_status
type VolumeInlineEncryptionInlineStatus struct {

	// Encryption progress message code.
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Encryption progress message.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this volume inline encryption inline status
func (m *VolumeInlineEncryptionInlineStatus) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline encryption inline status based on the context it is used
func (m *VolumeInlineEncryptionInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineEncryptionInlineStatus) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"status"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineEncryptionInlineStatus) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"status"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineEncryptionInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineEncryptionInlineStatus) UnmarshalBinary(b []byte) error {
	var res VolumeInlineEncryptionInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineErrorState volume inline error state
//
// swagger:model volume_inline_error_state
type VolumeInlineErrorState struct {

	// Indicates whether the volume has any corrupt data blocks. If the damaged data block is accessed, an IO error, such as EIO for NFS or STATUS_FILE_CORRUPT for CIFS, is returned.
	// Read Only: true
	HasBadBlocks *bool `json:"has_bad_blocks,omitempty"`

	// Indicates whether the file system has any inconsistencies.<br>true &dash; File system is inconsistent.<br>false &dash; File system in not inconsistent.
	// Read Only: true
	IsInconsistent *bool `json:"is_inconsistent,omitempty"`
}

// Validate validates this volume inline error state
func (m *VolumeInlineErrorState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline error state based on the context it is used
func (m *VolumeInlineErrorState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHasBadBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsInconsistent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineErrorState) contextValidateHasBadBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error_state"+"."+"has_bad_blocks", "body", m.HasBadBlocks); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineErrorState) contextValidateIsInconsistent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error_state"+"."+"is_inconsistent", "body", m.IsInconsistent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineErrorState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineErrorState) UnmarshalBinary(b []byte) error {
	var res VolumeInlineErrorState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineFiles volume inline files
//
// swagger:model volume_inline_files
type VolumeInlineFiles struct {

	// Number of inodes that can currently be stored on the volume for user-visible files.  This number dynamically increases as more user-visible files are created.
	// Read Only: true
	InodefileCapacity *int64 `json:"inodefile_capacity,omitempty"`

	// The maximum number of files (inodes) for user-visible data allowed on the volume. This value can be increased or decreased. Increasing the maximum number of files does not immediately cause additional disk space to be used to track files. Instead, as more files are created on the volume, the system dynamically increases the number of disk blocks that are used to track files. The space assigned to track files is never freed, and this value cannot be decreased below the current number of files that can be tracked within the assigned space for the volume. Valid in PATCH.
	Maximum *int64 `json:"maximum,omitempty"`

	// Number of files (inodes) used for user-visible data permitted on the volume. This field is valid only when the volume is online.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this volume inline files
func (m *VolumeInlineFiles) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline files based on the context it is used
func (m *VolumeInlineFiles) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInodefileCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineFiles) contextValidateInodefileCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"inodefile_capacity", "body", m.InodefileCapacity); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineFiles) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineFiles) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineFiles) UnmarshalBinary(b []byte) error {
	var res VolumeInlineFiles
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineFlashPool volume inline flash pool
//
// swagger:model volume_inline_flash_pool
type VolumeInlineFlashPool struct {

	// If this parameter is specified, the command displays information only about the volume or volumes with the specified Flash Pool caching attributes.
	// Read Only: true
	// Enum: ["read","read_write","none"]
	CacheEligibility *string `json:"cache_eligibility,omitempty"`

	// If this parameter is specified, the command displays the volumes that match the specified cache retention priority policy. A cache retention priority defines how long the blocks of a volume will be cached in the Flash Pool once they become cold.
	// Read Only: true
	// Enum: ["normal","low","high"]
	CacheRetentionPriority *string `json:"cache_retention_priority,omitempty"`

	// This optionally specifies the caching policy to apply to the volume. A caching policy defines how the system caches a volume's data in Flash Cache modules. If a caching policy is not assigned to a volume, the system uses the caching policy that is assigned to the containing SVM. If a caching policy is not assigned to the containing SVM, the system uses the default cluster-wide policy.
	// Read Only: true
	// Enum: ["none","auto","meta","random_read","random_read_write","all_read","all_read_random_write","all","noread_random_write","meta_random_write","random_read_write_random_write","all_read_random_write_random_write","all_random_write"]
	CachingPolicy *string `json:"caching_policy,omitempty"`
}

// Validate validates this volume inline flash pool
func (m *VolumeInlineFlashPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCacheEligibility(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCacheRetentionPriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCachingPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineFlashPoolTypeCacheEligibilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","read_write","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineFlashPoolTypeCacheEligibilityPropEnum = append(volumeInlineFlashPoolTypeCacheEligibilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_eligibility
	// CacheEligibility
	// read
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheEligibilityRead captures enum value "read"
	VolumeInlineFlashPoolCacheEligibilityRead string = "read"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_eligibility
	// CacheEligibility
	// read_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheEligibilityReadWrite captures enum value "read_write"
	VolumeInlineFlashPoolCacheEligibilityReadWrite string = "read_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_eligibility
	// CacheEligibility
	// none
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheEligibilityNone captures enum value "none"
	VolumeInlineFlashPoolCacheEligibilityNone string = "none"
)

// prop value enum
func (m *VolumeInlineFlashPool) validateCacheEligibilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineFlashPoolTypeCacheEligibilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineFlashPool) validateCacheEligibility(formats strfmt.Registry) error {
	if swag.IsZero(m.CacheEligibility) { // not required
		return nil
	}

	// value enum
	if err := m.validateCacheEligibilityEnum("flash_pool"+"."+"cache_eligibility", "body", *m.CacheEligibility); err != nil {
		return err
	}

	return nil
}

var volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","low","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum = append(volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_retention_priority
	// CacheRetentionPriority
	// normal
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheRetentionPriorityNormal captures enum value "normal"
	VolumeInlineFlashPoolCacheRetentionPriorityNormal string = "normal"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_retention_priority
	// CacheRetentionPriority
	// low
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheRetentionPriorityLow captures enum value "low"
	VolumeInlineFlashPoolCacheRetentionPriorityLow string = "low"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// cache_retention_priority
	// CacheRetentionPriority
	// high
	// END DEBUGGING
	// VolumeInlineFlashPoolCacheRetentionPriorityHigh captures enum value "high"
	VolumeInlineFlashPoolCacheRetentionPriorityHigh string = "high"
)

// prop value enum
func (m *VolumeInlineFlashPool) validateCacheRetentionPriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineFlashPoolTypeCacheRetentionPriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineFlashPool) validateCacheRetentionPriority(formats strfmt.Registry) error {
	if swag.IsZero(m.CacheRetentionPriority) { // not required
		return nil
	}

	// value enum
	if err := m.validateCacheRetentionPriorityEnum("flash_pool"+"."+"cache_retention_priority", "body", *m.CacheRetentionPriority); err != nil {
		return err
	}

	return nil
}

var volumeInlineFlashPoolTypeCachingPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","auto","meta","random_read","random_read_write","all_read","all_read_random_write","all","noread_random_write","meta_random_write","random_read_write_random_write","all_read_random_write_random_write","all_random_write"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineFlashPoolTypeCachingPolicyPropEnum = append(volumeInlineFlashPoolTypeCachingPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// none
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyNone captures enum value "none"
	VolumeInlineFlashPoolCachingPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// auto
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAuto captures enum value "auto"
	VolumeInlineFlashPoolCachingPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// meta
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyMeta captures enum value "meta"
	VolumeInlineFlashPoolCachingPolicyMeta string = "meta"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// random_read
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyRandomRead captures enum value "random_read"
	VolumeInlineFlashPoolCachingPolicyRandomRead string = "random_read"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// random_read_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyRandomReadWrite captures enum value "random_read_write"
	VolumeInlineFlashPoolCachingPolicyRandomReadWrite string = "random_read_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_read
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllRead captures enum value "all_read"
	VolumeInlineFlashPoolCachingPolicyAllRead string = "all_read"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_read_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllReadRandomWrite captures enum value "all_read_random_write"
	VolumeInlineFlashPoolCachingPolicyAllReadRandomWrite string = "all_read_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAll captures enum value "all"
	VolumeInlineFlashPoolCachingPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// noread_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyNoreadRandomWrite captures enum value "noread_random_write"
	VolumeInlineFlashPoolCachingPolicyNoreadRandomWrite string = "noread_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// meta_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyMetaRandomWrite captures enum value "meta_random_write"
	VolumeInlineFlashPoolCachingPolicyMetaRandomWrite string = "meta_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// random_read_write_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyRandomReadWriteRandomWrite captures enum value "random_read_write_random_write"
	VolumeInlineFlashPoolCachingPolicyRandomReadWriteRandomWrite string = "random_read_write_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_read_random_write_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllReadRandomWriteRandomWrite captures enum value "all_read_random_write_random_write"
	VolumeInlineFlashPoolCachingPolicyAllReadRandomWriteRandomWrite string = "all_read_random_write_random_write"

	// BEGIN DEBUGGING
	// volume_inline_flash_pool
	// VolumeInlineFlashPool
	// caching_policy
	// CachingPolicy
	// all_random_write
	// END DEBUGGING
	// VolumeInlineFlashPoolCachingPolicyAllRandomWrite captures enum value "all_random_write"
	VolumeInlineFlashPoolCachingPolicyAllRandomWrite string = "all_random_write"
)

// prop value enum
func (m *VolumeInlineFlashPool) validateCachingPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineFlashPoolTypeCachingPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineFlashPool) validateCachingPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.CachingPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateCachingPolicyEnum("flash_pool"+"."+"caching_policy", "body", *m.CachingPolicy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline flash pool based on the context it is used
func (m *VolumeInlineFlashPool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCacheEligibility(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCacheRetentionPriority(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCachingPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineFlashPool) contextValidateCacheEligibility(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flash_pool"+"."+"cache_eligibility", "body", m.CacheEligibility); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineFlashPool) contextValidateCacheRetentionPriority(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flash_pool"+"."+"cache_retention_priority", "body", m.CacheRetentionPriority); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineFlashPool) contextValidateCachingPolicy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flash_pool"+"."+"caching_policy", "body", m.CachingPolicy); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineFlashPool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineFlashPool) UnmarshalBinary(b []byte) error {
	var res VolumeInlineFlashPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineFlexgroup volume inline flexgroup
//
// swagger:model volume_inline_flexgroup
type VolumeInlineFlexgroup struct {

	// Name of the FlexGroup volume that the constituent is part of.
	// Example: my_flexgroup
	// Read Only: true
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the FlexGroup volume that the constituent is part of.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline flexgroup
func (m *VolumeInlineFlexgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineFlexgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("flexgroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("flexgroup"+"."+"name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline flexgroup based on the context it is used
func (m *VolumeInlineFlexgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineFlexgroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexgroup"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineFlexgroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexgroup"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineFlexgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineFlexgroup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineFlexgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineGuarantee volume inline guarantee
//
// swagger:model volume_inline_guarantee
type VolumeInlineGuarantee struct {

	// Is the space guarantee of this volume honored in the aggregate?
	// Read Only: true
	Honored *bool `json:"honored,omitempty"`

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this volume inline guarantee
func (m *VolumeInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineGuaranteeTypeTypePropEnum = append(volumeInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_guarantee
	// VolumeInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// VolumeInlineGuaranteeTypeVolume captures enum value "volume"
	VolumeInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_guarantee
	// VolumeInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// VolumeInlineGuaranteeTypeNone captures enum value "none"
	VolumeInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (m *VolumeInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("guarantee"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline guarantee based on the context it is used
func (m *VolumeInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHonored(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineGuarantee) contextValidateHonored(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "guarantee"+"."+"honored", "body", m.Honored); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res VolumeInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineLinks volume inline links
//
// swagger:model volume_inline__links
type VolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline links
func (m *VolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline links based on the context it is used
func (m *VolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetric Performance numbers, such as IOPS, latency and throughput.
//
// swagger:model volume_inline_metric
type VolumeInlineMetric struct {

	// links
	Links *VolumeInlineMetricInlineLinks `json:"_links,omitempty"`

	// cloud
	Cloud *VolumeInlineMetricInlineCloud `json:"cloud,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// flexcache
	Flexcache *VolumeInlineMetricInlineFlexcache `json:"flexcache,omitempty"`

	// iops
	Iops *VolumeInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *VolumeInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *VolumeInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline metric
func (m *VolumeInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloud(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) validateCloud(formats strfmt.Registry) error {
	if swag.IsZero(m.Cloud) { // not required
		return nil
	}

	if m.Cloud != nil {
		if err := m.Cloud.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

var volumeInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricTypeDurationPropEnum = append(volumeInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeInlineMetricDurationPT15S captures enum value "PT15S"
	VolumeInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// VolumeInlineMetricDurationPT4M captures enum value "PT4M"
	VolumeInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeInlineMetricDurationPT30M captures enum value "PT30M"
	VolumeInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeInlineMetricDurationPT2H captures enum value "PT2H"
	VolumeInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// VolumeInlineMetricDurationP1D captures enum value "P1D"
	VolumeInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeInlineMetricDurationPT5M captures enum value "PT5M"
	VolumeInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *VolumeInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetric) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexcache) { // not required
		return nil
	}

	if m.Flexcache != nil {
		if err := m.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var volumeInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricTypeStatusPropEnum = append(volumeInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineMetricStatusOk captures enum value "ok"
	VolumeInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineMetricStatusError captures enum value "error"
	VolumeInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_metric
	// VolumeInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline metric based on the context it is used
func (m *VolumeInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateCloud(ctx context.Context, formats strfmt.Registry) error {

	if m.Cloud != nil {
		if err := m.Cloud.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexcache != nil {
		if err := m.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetric) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineCloud Performance numbers (IOPS and latency) for cloud store. These numbers are relevant only for volumes hosted on FabricPools.
//
// swagger:model volume_inline_metric_inline_cloud
type VolumeInlineMetricInlineCloud struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *VolumeInlineMetricInlineCloudInlineIops `json:"iops,omitempty"`

	// latency
	Latency *VolumeInlineMetricInlineCloudInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline metric inline cloud
func (m *VolumeInlineMetricInlineCloud) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineMetricInlineCloudTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineCloudTypeDurationPropEnum = append(volumeInlineMetricInlineCloudTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT15S captures enum value "PT15S"
	VolumeInlineMetricInlineCloudDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT4M captures enum value "PT4M"
	VolumeInlineMetricInlineCloudDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT30M captures enum value "PT30M"
	VolumeInlineMetricInlineCloudDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT2H captures enum value "PT2H"
	VolumeInlineMetricInlineCloudDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationP1D captures enum value "P1D"
	VolumeInlineMetricInlineCloudDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudDurationPT5M captures enum value "PT5M"
	VolumeInlineMetricInlineCloudDurationPT5M string = "PT5M"
)

// prop value enum
func (m *VolumeInlineMetricInlineCloud) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineCloudTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMetricInlineCloud) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"cloud"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "cloud" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "cloud" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var volumeInlineMetricInlineCloudTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineCloudTypeStatusPropEnum = append(volumeInlineMetricInlineCloudTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusOk captures enum value "ok"
	VolumeInlineMetricInlineCloudStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusError captures enum value "error"
	VolumeInlineMetricInlineCloudStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineMetricInlineCloudStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineMetricInlineCloudStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineMetricInlineCloudStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineMetricInlineCloudStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineMetricInlineCloudStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineMetricInlineCloudStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineMetricInlineCloudStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_cloud
	// VolumeInlineMetricInlineCloud
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineMetricInlineCloudStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineMetricInlineCloudStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeInlineMetricInlineCloud) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineCloudTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMetricInlineCloud) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"cloud"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"cloud"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline metric inline cloud based on the context it is used
func (m *VolumeInlineMetricInlineCloud) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMetricInlineCloud) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"cloud"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "cloud" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "cloud" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"cloud"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineCloud) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"cloud"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineCloud) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineCloud) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineCloud
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineCloudInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model volume_inline_metric_inline_cloud_inline_iops
type VolumeInlineMetricInlineCloudInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline cloud inline iops
func (m *VolumeInlineMetricInlineCloudInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline cloud inline iops based on the context it is used
func (m *VolumeInlineMetricInlineCloudInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineCloudInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineCloudInlineIops) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineCloudInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineCloudInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model volume_inline_metric_inline_cloud_inline_latency
type VolumeInlineMetricInlineCloudInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline cloud inline latency
func (m *VolumeInlineMetricInlineCloudInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline cloud inline latency based on the context it is used
func (m *VolumeInlineMetricInlineCloudInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineCloudInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineCloudInlineLatency) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineCloudInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineFlexcache Performance number for FlexCache used to measure cache effectiveness.
//
// swagger:model volume_inline_metric_inline_flexcache
type VolumeInlineMetricInlineFlexcache struct {

	// Bandwidth savings denoting the amount of data served locally by the cache, in bytes.
	// Example: 4096
	BandwidthSavings *int64 `json:"bandwidth_savings,omitempty"`

	// Cache miss percentage.
	// Example: 20
	CacheMissPercent *int64 `json:"cache_miss_percent,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT1D
	// Read Only: true
	// Enum: ["PT15S","PT5M","PT30M","PT2H","PT1D"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline metric inline flexcache
func (m *VolumeInlineMetricInlineFlexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineMetricInlineFlexcacheTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","PT1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineFlexcacheTypeDurationPropEnum = append(volumeInlineMetricInlineFlexcacheTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT15S captures enum value "PT15S"
	VolumeInlineMetricInlineFlexcacheDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT5M captures enum value "PT5M"
	VolumeInlineMetricInlineFlexcacheDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT30M captures enum value "PT30M"
	VolumeInlineMetricInlineFlexcacheDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT2H captures enum value "PT2H"
	VolumeInlineMetricInlineFlexcacheDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// duration
	// Duration
	// PT1D
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheDurationPT1D captures enum value "PT1D"
	VolumeInlineMetricInlineFlexcacheDurationPT1D string = "PT1D"
)

// prop value enum
func (m *VolumeInlineMetricInlineFlexcache) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineFlexcacheTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMetricInlineFlexcache) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"flexcache"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var volumeInlineMetricInlineFlexcacheTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMetricInlineFlexcacheTypeStatusPropEnum = append(volumeInlineMetricInlineFlexcacheTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusOk captures enum value "ok"
	VolumeInlineMetricInlineFlexcacheStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusError captures enum value "error"
	VolumeInlineMetricInlineFlexcacheStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineMetricInlineFlexcacheStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineMetricInlineFlexcacheStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineMetricInlineFlexcacheStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineMetricInlineFlexcacheStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineMetricInlineFlexcacheStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineMetricInlineFlexcacheStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineMetricInlineFlexcacheStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_metric_inline_flexcache
	// VolumeInlineMetricInlineFlexcache
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineMetricInlineFlexcacheStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineMetricInlineFlexcacheStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeInlineMetricInlineFlexcache) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMetricInlineFlexcacheTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMetricInlineFlexcache) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"flexcache"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineFlexcache) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"flexcache"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline metric inline flexcache based on the context it is used
func (m *VolumeInlineMetricInlineFlexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMetricInlineFlexcache) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"flexcache"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineFlexcache) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"flexcache"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMetricInlineFlexcache) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"flexcache"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineFlexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineFlexcache) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineFlexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model volume_inline_metric_inline_iops
type VolumeInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline iops
func (m *VolumeInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline iops based on the context it is used
func (m *VolumeInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model volume_inline_metric_inline_latency
type VolumeInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline latency
func (m *VolumeInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline latency based on the context it is used
func (m *VolumeInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineLinks volume inline metric inline links
//
// swagger:model volume_inline_metric_inline__links
type VolumeInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline metric inline links
func (m *VolumeInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline metric inline links based on the context it is used
func (m *VolumeInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model volume_inline_metric_inline_throughput
type VolumeInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline metric inline throughput
func (m *VolumeInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline metric inline throughput based on the context it is used
func (m *VolumeInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMovement Volume movement. All attributes are modify, that is, not writable through POST. Set PATCH state to destination_aggregate to initiate a volume move operation.
//
// swagger:model volume_inline_movement
type VolumeInlineMovement struct {

	// Specifies whether this move should perform optimized volume move for the capacity tier, in which data in the capacity tier does not need to be copied over.
	CapacityTierOptimized *bool `json:"capacity_tier_optimized,omitempty"`

	// Time window in seconds for cutover. The allowed range is between 30 to 300 seconds.
	// Example: 30
	CutoverWindow *int64 `json:"cutover_window,omitempty"`

	// destination aggregate
	DestinationAggregate *VolumeInlineMovementInlineDestinationAggregate `json:"destination_aggregate,omitempty"`

	// Completion percentage
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// Start time of volume move.
	// Example: 2020-12-07 03:45:12-05:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// State of volume move operation. PATCH the state to "aborted" to abort the move operation. PATCH the state to "cutover" to trigger cutover. PATCH the state to "paused" to pause the volume move operation in progress. PATCH the state to "replicating" to resume the paused volume move operation. PATCH the state to "cutover_wait" to go into cutover manually. When volume move operation is waiting to go into "cutover" state, this is indicated by the "cutover_pending" state. A change of state is only supported if volume movement is in progress.
	// Example: replicating
	// Enum: ["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]
	State *string `json:"state,omitempty"`

	// Tiering policy for FabricPool
	// Enum: ["all","auto","backup","none","snapshot_only"]
	TieringPolicy *string `json:"tiering_policy,omitempty"`
}

// Validate validates this volume inline movement
func (m *VolumeInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestinationAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTieringPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMovement) validateDestinationAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.DestinationAggregate) { // not required
		return nil
	}

	if m.DestinationAggregate != nil {
		if err := m.DestinationAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMovement) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("movement"+"."+"start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineMovementTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMovementTypeStatePropEnum = append(volumeInlineMovementTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// aborted
	// END DEBUGGING
	// VolumeInlineMovementStateAborted captures enum value "aborted"
	VolumeInlineMovementStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// cutover
	// END DEBUGGING
	// VolumeInlineMovementStateCutover captures enum value "cutover"
	VolumeInlineMovementStateCutover string = "cutover"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// cutover_wait
	// END DEBUGGING
	// VolumeInlineMovementStateCutoverWait captures enum value "cutover_wait"
	VolumeInlineMovementStateCutoverWait string = "cutover_wait"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// cutover_pending
	// END DEBUGGING
	// VolumeInlineMovementStateCutoverPending captures enum value "cutover_pending"
	VolumeInlineMovementStateCutoverPending string = "cutover_pending"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// failed
	// END DEBUGGING
	// VolumeInlineMovementStateFailed captures enum value "failed"
	VolumeInlineMovementStateFailed string = "failed"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineMovementStatePaused captures enum value "paused"
	VolumeInlineMovementStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// queued
	// END DEBUGGING
	// VolumeInlineMovementStateQueued captures enum value "queued"
	VolumeInlineMovementStateQueued string = "queued"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// replicating
	// END DEBUGGING
	// VolumeInlineMovementStateReplicating captures enum value "replicating"
	VolumeInlineMovementStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// state
	// State
	// success
	// END DEBUGGING
	// VolumeInlineMovementStateSuccess captures enum value "success"
	VolumeInlineMovementStateSuccess string = "success"
)

// prop value enum
func (m *VolumeInlineMovement) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMovementTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMovement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("movement"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var volumeInlineMovementTypeTieringPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineMovementTypeTieringPolicyPropEnum = append(volumeInlineMovementTypeTieringPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// all
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyAll captures enum value "all"
	VolumeInlineMovementTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// auto
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyAuto captures enum value "auto"
	VolumeInlineMovementTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// backup
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyBackup captures enum value "backup"
	VolumeInlineMovementTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// none
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicyNone captures enum value "none"
	VolumeInlineMovementTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_movement
	// VolumeInlineMovement
	// tiering_policy
	// TieringPolicy
	// snapshot_only
	// END DEBUGGING
	// VolumeInlineMovementTieringPolicySnapshotOnly captures enum value "snapshot_only"
	VolumeInlineMovementTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *VolumeInlineMovement) validateTieringPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineMovementTypeTieringPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineMovement) validateTieringPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.TieringPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateTieringPolicyEnum("movement"+"."+"tiering_policy", "body", *m.TieringPolicy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline movement based on the context it is used
func (m *VolumeInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestinationAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMovement) contextValidateDestinationAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.DestinationAggregate != nil {
		if err := m.DestinationAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineMovement) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineMovement) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMovement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMovementInlineDestinationAggregate Aggregate
//
// swagger:model volume_inline_movement_inline_destination_aggregate
type VolumeInlineMovementInlineDestinationAggregate struct {

	// links
	Links *VolumeInlineMovementInlineDestinationAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline movement inline destination aggregate
func (m *VolumeInlineMovementInlineDestinationAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMovementInlineDestinationAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline movement inline destination aggregate based on the context it is used
func (m *VolumeInlineMovementInlineDestinationAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMovementInlineDestinationAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMovementInlineDestinationAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMovementInlineDestinationAggregate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMovementInlineDestinationAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineMovementInlineDestinationAggregateInlineLinks volume inline movement inline destination aggregate inline links
//
// swagger:model volume_inline_movement_inline_destination_aggregate_inline__links
type VolumeInlineMovementInlineDestinationAggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline movement inline destination aggregate inline links
func (m *VolumeInlineMovementInlineDestinationAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMovementInlineDestinationAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline movement inline destination aggregate inline links based on the context it is used
func (m *VolumeInlineMovementInlineDestinationAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineMovementInlineDestinationAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineMovementInlineDestinationAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineMovementInlineDestinationAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineMovementInlineDestinationAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineNas volume inline nas
//
// swagger:model volume_inline_nas
type VolumeInlineNas struct {

	// export policy
	ExportPolicy *VolumeInlineNasInlineExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *VolumeInlineNasInlineJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within a SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; Unix-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number. It consists of 4 digits derived by adding up bits 4 (read), 2 (write) and 1 (execute). First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. The second digit selects permission for the owner of the file; the third selects permissions for other users in the same group; the fourth for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group and other permissions are given (as in 755, representing the second, third and fourth dight), first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this volume inline nas
func (m *VolumeInlineNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineNas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var volumeInlineNasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineNasTypeSecurityStylePropEnum = append(volumeInlineNasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleMixed captures enum value "mixed"
	VolumeInlineNasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleNtfs captures enum value "ntfs"
	VolumeInlineNasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleUnified captures enum value "unified"
	VolumeInlineNasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// volume_inline_nas
	// VolumeInlineNas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// VolumeInlineNasSecurityStyleUnix captures enum value "unix"
	VolumeInlineNasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *VolumeInlineNas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineNasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineNas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline nas based on the context it is used
func (m *VolumeInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineNas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineNas) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineNasInlineExportPolicy Export Policy
//
// swagger:model volume_inline_nas_inline_export_policy
type VolumeInlineNasInlineExportPolicy struct {

	// links
	Links *VolumeInlineNasInlineExportPolicyInlineLinks `json:"_links,omitempty"`

	// id
	// Example: 100
	ID *int64 `json:"id,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`
}

// Validate validates this volume inline nas inline export policy
func (m *VolumeInlineNasInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline export policy based on the context it is used
func (m *VolumeInlineNasInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineNasInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineNasInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineNasInlineExportPolicyInlineLinks volume inline nas inline export policy inline links
//
// swagger:model volume_inline_nas_inline_export_policy_inline__links
type VolumeInlineNasInlineExportPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline nas inline export policy inline links
func (m *VolumeInlineNasInlineExportPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineExportPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline export policy inline links based on the context it is used
func (m *VolumeInlineNasInlineExportPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineExportPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineNasInlineExportPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineNasInlineExportPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineExportPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineNasInlineJunctionParent volume inline nas inline junction parent
//
// swagger:model volume_inline_nas_inline_junction_parent
type VolumeInlineNasInlineJunctionParent struct {

	// links
	Links *VolumeInlineNasInlineJunctionParentInlineLinks `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline nas inline junction parent
func (m *VolumeInlineNasInlineJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline junction parent based on the context it is used
func (m *VolumeInlineNasInlineJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineNasInlineJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineNasInlineJunctionParent) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineNasInlineJunctionParentInlineLinks volume inline nas inline junction parent inline links
//
// swagger:model volume_inline_nas_inline_junction_parent_inline__links
type VolumeInlineNasInlineJunctionParentInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline nas inline junction parent inline links
func (m *VolumeInlineNasInlineJunctionParentInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineJunctionParentInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline nas inline junction parent inline links based on the context it is used
func (m *VolumeInlineNasInlineJunctionParentInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNasInlineJunctionParentInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineNasInlineJunctionParentInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineNasInlineJunctionParentInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNasInlineJunctionParentInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineNodesInlineArrayItem volume inline nodes inline array item
//
// swagger:model volume_inline_nodes_inline_array_item
type VolumeInlineNodesInlineArrayItem struct {

	// List of the node names hosting the volume.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// List of the node UUIDs hosting the volume.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline nodes inline array item
func (m *VolumeInlineNodesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline nodes inline array item based on the context it is used
func (m *VolumeInlineNodesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineNodesInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineNodesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineNodesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineNodesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VolumeInlineNodesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineQos QoS information
//
// swagger:model volume_inline_qos
type VolumeInlineQos struct {

	// policy
	Policy *VolumeInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this volume inline qos
func (m *VolumeInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline qos based on the context it is used
func (m *VolumeInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineQos) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineQosInlinePolicy When "min_throughput_iops", "min_throughput_mbps", "min_throughput", "max_throughput_iops", "max_throughput_mbps" or "max_throughput" attributes are specified, the storage object is assigned to an auto-generated QoS policy group. If the attributes are later modified, the auto-generated QoS policy-group attributes are modified. Attributes can be removed by specifying "0" and policy group by specifying "none". Upon deletion of the storage object or if the attributes are removed, then the QoS policy-group is also removed.
//
// swagger:model volume_inline_qos_inline_policy
type VolumeInlineQosInlinePolicy struct {

	// links
	Links *VolumeInlineQosInlinePolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline qos inline policy
func (m *VolumeInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineQosInlinePolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineQosInlinePolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineQosInlinePolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineQosInlinePolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline qos inline policy based on the context it is used
func (m *VolumeInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineQosInlinePolicyInlineLinks volume inline qos inline policy inline links
//
// swagger:model volume_inline_qos_inline_policy_inline__links
type VolumeInlineQosInlinePolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline qos inline policy inline links
func (m *VolumeInlineQosInlinePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQosInlinePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline qos inline policy inline links based on the context it is used
func (m *VolumeInlineQosInlinePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQosInlinePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineQosInlinePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineQosInlinePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQosInlinePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineQuota Quotas track the space or file usage of a user, group, or qtree in a FlexVol volume or a FlexGroup volume.
//
// swagger:model volume_inline_quota
type VolumeInlineQuota struct {

	// This option is used to enable or disable the quota for the volume. This option is valid only in PATCH. Quotas are enabled for FlexVol volumes or FlexGroup volumes when the quota state is "on". Quotas are disabled for FlexVol volumes or FlexGroup volumes when the quota state is "off".
	Enabled *bool `json:"enabled,omitempty"`

	// Quota state of the volume
	// Read Only: true
	// Enum: ["corrupt","initializing","mixed","off","on","resizing"]
	State *string `json:"state,omitempty"`
}

// Validate validates this volume inline quota
func (m *VolumeInlineQuota) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineQuotaTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["corrupt","initializing","mixed","off","on","resizing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineQuotaTypeStatePropEnum = append(volumeInlineQuotaTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// corrupt
	// END DEBUGGING
	// VolumeInlineQuotaStateCorrupt captures enum value "corrupt"
	VolumeInlineQuotaStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// initializing
	// END DEBUGGING
	// VolumeInlineQuotaStateInitializing captures enum value "initializing"
	VolumeInlineQuotaStateInitializing string = "initializing"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// mixed
	// END DEBUGGING
	// VolumeInlineQuotaStateMixed captures enum value "mixed"
	VolumeInlineQuotaStateMixed string = "mixed"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// off
	// END DEBUGGING
	// VolumeInlineQuotaStateOff captures enum value "off"
	VolumeInlineQuotaStateOff string = "off"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// on
	// END DEBUGGING
	// VolumeInlineQuotaStateOn captures enum value "on"
	VolumeInlineQuotaStateOn string = "on"

	// BEGIN DEBUGGING
	// volume_inline_quota
	// VolumeInlineQuota
	// state
	// State
	// resizing
	// END DEBUGGING
	// VolumeInlineQuotaStateResizing captures enum value "resizing"
	VolumeInlineQuotaStateResizing string = "resizing"
)

// prop value enum
func (m *VolumeInlineQuota) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineQuotaTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineQuota) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("quota"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline quota based on the context it is used
func (m *VolumeInlineQuota) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineQuota) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "quota"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineQuota) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineQuota) UnmarshalBinary(b []byte) error {
	var res VolumeInlineQuota
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancing Configuration and runtime properties involving non-disruptive volume capacity rebalancing for a FlexGroup volume.
//
// swagger:model volume_inline_rebalancing
type VolumeInlineRebalancing struct {

	// links
	Links *VolumeInlineRebalancingInlineLinks `json:"_links,omitempty"`

	// The amount of data that has been moved in or out of a constituent. A positive value represents data moving into the constituent while a negative value is data moving out of the constituent.
	// Read Only: true
	DataMoved *int64 `json:"data_moved,omitempty"`

	// engine
	Engine *VolumeInlineRebalancingInlineEngine `json:"engine,omitempty"`

	// Specifies whether or not to exclude files that are stuck in snapshots during rebalancing operation. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "exclude_snapshots" value. Once the operation is started, any changes to the "exclude_snapshots" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "exclude_snapshots" value.
	ExcludeSnapshots *bool `json:"exclude_snapshots,omitempty"`

	// Represents the percentage the volume is out of balance.
	// Read Only: true
	ImbalancePercent *int64 `json:"imbalance_percent,omitempty"`

	// Represents how much the volume is out of balance, in bytes.
	// Read Only: true
	ImbalanceSize *int64 `json:"imbalance_size,omitempty"`

	// Absolute percentage of the constituent that is most out of balance. This value will update every 30 seconds when rebalancing is not active and every 10 seconds when rebalancing is active.
	// Read Only: true
	MaxConstituentImbalancePercent *int64 `json:"max_constituent_imbalance_percent,omitempty"`

	// Specifies the maximum number of concurrent file moves in a volume capacity rebalancing operation on a constituent of the FlexGroup volume. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "max_file_moves" value. Once the operation is started, any changes to the "max_file_moves" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "max_file_moves" value.
	MaxFileMoves *int64 `json:"max_file_moves,omitempty"`

	// This optional field specifies the maximum time a capacity rebalancing operation runs for. Once the maximum runtime has passed, the capacity rebalancing operation stops. If it is not set, the default value is 6 hours. This value cannot be updated while a capacity rebalancing operation is running.  The maximum runtime can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P3D" represents a duration of 3 days. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively.
	MaxRuntime *string `json:"max_runtime,omitempty"`

	// Specifies the maximum imbalance percentage for FlexGroup volume constituents. When a constituent's imbalance percentage is larger than this value, files are moved from the constituent. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "max_threshold" value. Once the operation is started, any changes to the "max_threshold" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "max_threshold" value.
	MaxThreshold *int64 `json:"max_threshold,omitempty"`

	// Specifies the minimum file size to consider for a volume capacity rebalancing operation. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "min_file_size" value. Once the operation is started, any changes to the "min_file_size" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "min_file_size" value. The value must be a multiple of 4KB. If it is not set, the default value is 100MB. Setting "min-file-size" to less than the default value leads to more files being moved. Moved files use granular data, which may impact read/write I/O performance.
	MinFileSize *int64 `json:"min_file_size,omitempty"`

	// Specifies the minimum imbalance percentage for FlexGroup volume constituents. When a constituent's imbalance percentage is smaller than this value, files are not moved from the constituent. When a new capacity rebalancing operation is started on a FlexGroup volume, it will use the current "min_threshold" value. Once the operation is started, any changes to the "min_threshold" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "min_threshold" value.
	MinThreshold *int64 `json:"min_threshold,omitempty"`

	// Capacity rebalancing notice messages.
	// Read Only: true
	Notices []*Error `json:"notices,omitempty"`

	// Duration the capacity rebalancing operation has been running.
	// Read Only: true
	Runtime *string `json:"runtime,omitempty"`

	// Time when the current capacity rebalancing operation started, or when a future scheduled rebalancing operation begins.
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// State of the volume capacity rebalancing operation. PATCH the state to "starting" to trigger the capacity rebalance operation, and include start_time to schedule rebalancing. PATCH the state to "stopping" to stop the capacity rebalance operation, or cancel a scheduled rebalancing operation. PATCH without the state with a valid start_time to modify the start_time of an existing scheduled rebalance operation.<br><br>While a FlexGroup volume is rebalancing, every constituent will have a rebalancing engine that can either be scanning the filesystem for space usage and files to move, actively moving files or temporarily doing neither.<br><br>If one or more constituents has a state of "rebalancing_source" or "rebalancing_dest", then files are being moved to rebalance the FlexGroup volume.<br><br>If no files are being moved, more information about what the rebalancing engine is doing for each constituent is available using the "rebalancing.engine" property.<br><br>The following values apply to FlexGroup volumes.<br>not_running &dash; capacity rebalancing is not running on the volume.<br>starting &dash; used in a PATCH operation to start a capacity rebalancing operation.<br>rebalancing &dash; capacity rebalancing is running on the volume.<br> paused &dash; volume capacity rebalancing is paused on the volume.<br>stopping &dash; used in a PATCH operation to stop a capacity rebalancing operation.<br>unknown &dash; the system was unable to determine the rebalancing state for the volume.<br><br>The following values apply to FlexGroup volume constituents.<br>idle &dash; capacity rebalancing is running on the constituent, however, no active scanning or file movement is currently occurring.<br>scanning &dash; the constituent's file system is being scanned to find files to move and determine free space.<br>rebalancing_source &dash; a file is being moved off of the constituent.<br>rebalancing_dest &dash; a file is being moved to the constituent.<br>not_running &dash; capacity rebalancing is not running on the constituent.<br>unknown &dash; the system was unable to determine the rebalancing state for the constituent.
	// Example: rebalancing
	// Enum: ["not_running","starting","rebalancing","paused","stopping","idle","scanning","rebalancing_source","rebalancing_dest","unknown"]
	State *string `json:"state,omitempty"`

	// Time when the capacity rebalancing operation stopped.
	// Read Only: true
	// Format: date-time
	StopTime *strfmt.DateTime `json:"stop_time,omitempty"`

	// Represents the ideal used size of each constituent. Calculated by dividing the total FlexGroup volume used size by the number of constituents.
	// Read Only: true
	TargetUsed *int64 `json:"target_used,omitempty"`

	// Represents the used size of each constituent, as determined by the rebalancing engine. Calculated by subtracting the size used by snapshots, the size of files pending deletion and the size of filesystem metadata from the volume used size.
	// Read Only: true
	UsedForImbalance *int64 `json:"used_for_imbalance,omitempty"`
}

// Validate validates this volume inline rebalancing
func (m *VolumeInlineRebalancing) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEngine(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancing) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancing) validateEngine(formats strfmt.Registry) error {
	if swag.IsZero(m.Engine) { // not required
		return nil
	}

	if m.Engine != nil {
		if err := m.Engine.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancing) validateNotices(formats strfmt.Registry) error {
	if swag.IsZero(m.Notices) { // not required
		return nil
	}

	for i := 0; i < len(m.Notices); i++ {
		if swag.IsZero(m.Notices[i]) { // not required
			continue
		}

		if m.Notices[i] != nil {
			if err := m.Notices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rebalancing" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineRebalancing) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("rebalancing"+"."+"start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineRebalancingTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_running","starting","rebalancing","paused","stopping","idle","scanning","rebalancing_source","rebalancing_dest","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineRebalancingTypeStatePropEnum = append(volumeInlineRebalancingTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// not_running
	// END DEBUGGING
	// VolumeInlineRebalancingStateNotRunning captures enum value "not_running"
	VolumeInlineRebalancingStateNotRunning string = "not_running"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// starting
	// END DEBUGGING
	// VolumeInlineRebalancingStateStarting captures enum value "starting"
	VolumeInlineRebalancingStateStarting string = "starting"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// rebalancing
	// END DEBUGGING
	// VolumeInlineRebalancingStateRebalancing captures enum value "rebalancing"
	VolumeInlineRebalancingStateRebalancing string = "rebalancing"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeInlineRebalancingStatePaused captures enum value "paused"
	VolumeInlineRebalancingStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// stopping
	// END DEBUGGING
	// VolumeInlineRebalancingStateStopping captures enum value "stopping"
	VolumeInlineRebalancingStateStopping string = "stopping"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// idle
	// END DEBUGGING
	// VolumeInlineRebalancingStateIdle captures enum value "idle"
	VolumeInlineRebalancingStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// scanning
	// END DEBUGGING
	// VolumeInlineRebalancingStateScanning captures enum value "scanning"
	VolumeInlineRebalancingStateScanning string = "scanning"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// rebalancing_source
	// END DEBUGGING
	// VolumeInlineRebalancingStateRebalancingSource captures enum value "rebalancing_source"
	VolumeInlineRebalancingStateRebalancingSource string = "rebalancing_source"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// rebalancing_dest
	// END DEBUGGING
	// VolumeInlineRebalancingStateRebalancingDest captures enum value "rebalancing_dest"
	VolumeInlineRebalancingStateRebalancingDest string = "rebalancing_dest"

	// BEGIN DEBUGGING
	// volume_inline_rebalancing
	// VolumeInlineRebalancing
	// state
	// State
	// unknown
	// END DEBUGGING
	// VolumeInlineRebalancingStateUnknown captures enum value "unknown"
	VolumeInlineRebalancingStateUnknown string = "unknown"
)

// prop value enum
func (m *VolumeInlineRebalancing) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineRebalancingTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineRebalancing) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("rebalancing"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) validateStopTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StopTime) { // not required
		return nil
	}

	if err := validate.FormatOf("rebalancing"+"."+"stop_time", "body", "date-time", m.StopTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing based on the context it is used
func (m *VolumeInlineRebalancing) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataMoved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEngine(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImbalancePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImbalanceSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxConstituentImbalancePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNotices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRuntime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedForImbalance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancing) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateDataMoved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"data_moved", "body", m.DataMoved); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateEngine(ctx context.Context, formats strfmt.Registry) error {

	if m.Engine != nil {
		if err := m.Engine.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateImbalancePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"imbalance_percent", "body", m.ImbalancePercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateImbalanceSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"imbalance_size", "body", m.ImbalanceSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateMaxConstituentImbalancePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"max_constituent_imbalance_percent", "body", m.MaxConstituentImbalancePercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateNotices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"notices", "body", []*Error(m.Notices)); err != nil {
		return err
	}

	for i := 0; i < len(m.Notices); i++ {

		if m.Notices[i] != nil {
			if err := m.Notices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rebalancing" + "." + "notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateRuntime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"runtime", "body", m.Runtime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateStopTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"stop_time", "body", m.StopTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateTargetUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"target_used", "body", m.TargetUsed); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancing) contextValidateUsedForImbalance(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"used_for_imbalance", "body", m.UsedForImbalance); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancing) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancing) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancing
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineEngine Each constituent has one rebalancing engine that co-ordinates scanning constituents for free space and files to move, as well as moving files between constituents. The engine properties must be explicitly requested, are meant for helping diagnose why the volume rebalancer is making decisions.
//
// swagger:model volume_inline_rebalancing_inline_engine
type VolumeInlineRebalancingInlineEngine struct {

	// movement
	Movement *VolumeInlineRebalancingInlineEngineInlineMovement `json:"movement,omitempty"`

	// scanner
	Scanner *VolumeInlineRebalancingInlineEngineInlineScanner `json:"scanner,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine
func (m *VolumeInlineRebalancingInlineEngine) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngine) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(m.Movement) { // not required
		return nil
	}

	if m.Movement != nil {
		if err := m.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngine) validateScanner(formats strfmt.Registry) error {
	if swag.IsZero(m.Scanner) { // not required
		return nil
	}

	if m.Scanner != nil {
		if err := m.Scanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine based on the context it is used
func (m *VolumeInlineRebalancingInlineEngine) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngine) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if m.Movement != nil {
		if err := m.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngine) contextValidateScanner(ctx context.Context, formats strfmt.Registry) error {

	if m.Scanner != nil {
		if err := m.Scanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngine) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngine) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngine
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineEngineInlineMovement Properties on this constituent related to file movement.
//
// swagger:model volume_inline_rebalancing_inline_engine_inline_movement
type VolumeInlineRebalancingInlineEngineInlineMovement struct {

	// Number of file moves started on this constituent.
	// Read Only: true
	FileMovesStarted *int64 `json:"file_moves_started,omitempty"`

	// last error
	LastError *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError `json:"last_error,omitempty"`

	// Start time of the most recent file move on the constituent.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	MostRecentStartTime *strfmt.DateTime `json:"most_recent_start_time,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline movement
func (m *VolumeInlineRebalancingInlineEngineInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLastError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMostRecentStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovement) validateLastError(formats strfmt.Registry) error {
	if swag.IsZero(m.LastError) { // not required
		return nil
	}

	if m.LastError != nil {
		if err := m.LastError.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "movement" + "." + "last_error")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovement) validateMostRecentStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.MostRecentStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("rebalancing"+"."+"engine"+"."+"movement"+"."+"most_recent_start_time", "body", "date-time", m.MostRecentStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline movement based on the context it is used
func (m *VolumeInlineRebalancingInlineEngineInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFileMovesStarted(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMostRecentStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovement) contextValidateFileMovesStarted(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"movement"+"."+"file_moves_started", "body", m.FileMovesStarted); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovement) contextValidateLastError(ctx context.Context, formats strfmt.Registry) error {

	if m.LastError != nil {
		if err := m.LastError.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "movement" + "." + "last_error")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovement) contextValidateMostRecentStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"movement"+"."+"most_recent_start_time", "body", m.MostRecentStartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineMovement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError Error information for the last failed file move on the constituent.
//
// swagger:model volume_inline_rebalancing_inline_engine_inline_movement_inline_last_error
type VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError struct {

	// Error code of the last file move error on the constituent.
	// Read Only: true
	Code *int64 `json:"code,omitempty"`

	// DSID of the destination constituent of the last file move error on the constituent.
	// Read Only: true
	Destination *int64 `json:"destination,omitempty"`

	// File ID of the last file move error on the constituent.
	// Read Only: true
	FileID *int64 `json:"file_id,omitempty"`

	// Time of the last file move error on the constituent.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline movement inline last error
func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"time", "body", "date-time", m.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline movement inline last error based on the context it is used
func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"destination", "body", m.Destination); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateFileID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"file_id", "body", m.FileID); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"movement"+"."+"last_error"+"."+"time", "body", m.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineMovementInlineLastError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineEngineInlineScanner Properties related to determining which files to move and where to move them to.
//
// swagger:model volume_inline_rebalancing_inline_engine_inline_scanner
type VolumeInlineRebalancingInlineEngineInlineScanner struct {

	// Number of blocks scanned on this constituent.
	// Read Only: true
	BlocksScanned *int64 `json:"blocks_scanned,omitempty"`

	// blocks skipped
	BlocksSkipped *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped `json:"blocks_skipped,omitempty"`

	// Number of files scanned on this constituent.
	// Read Only: true
	FilesScanned *int64 `json:"files_scanned,omitempty"`

	// files skipped
	FilesSkipped *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped `json:"files_skipped,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline scanner
func (m *VolumeInlineRebalancingInlineEngineInlineScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlocksSkipped(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilesSkipped(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScanner) validateBlocksSkipped(formats strfmt.Registry) error {
	if swag.IsZero(m.BlocksSkipped) { // not required
		return nil
	}

	if m.BlocksSkipped != nil {
		if err := m.BlocksSkipped.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "scanner" + "." + "blocks_skipped")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScanner) validateFilesSkipped(formats strfmt.Registry) error {
	if swag.IsZero(m.FilesSkipped) { // not required
		return nil
	}

	if m.FilesSkipped != nil {
		if err := m.FilesSkipped.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "scanner" + "." + "files_skipped")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline scanner based on the context it is used
func (m *VolumeInlineRebalancingInlineEngineInlineScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlocksScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlocksSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateBlocksScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_scanned", "body", m.BlocksScanned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateBlocksSkipped(ctx context.Context, formats strfmt.Registry) error {

	if m.BlocksSkipped != nil {
		if err := m.BlocksSkipped.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "scanner" + "." + "blocks_skipped")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateFilesScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_scanned", "body", m.FilesScanned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScanner) contextValidateFilesSkipped(ctx context.Context, formats strfmt.Registry) error {

	if m.FilesSkipped != nil {
		if err := m.FilesSkipped.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "engine" + "." + "scanner" + "." + "files_skipped")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineScanner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineScanner) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped Number of blocks skipped by the scanner on this constituent due to various reasons.
//
// swagger:model volume_inline_rebalancing_inline_engine_inline_scanner_inline_blocks_skipped
type VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped struct {

	// Number of blocks skipped by the scanner on this constituent because storage efficiency lost, in blocks, would be too high.
	// Read Only: true
	EfficiencyBlocks *int64 `json:"efficiency_blocks,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because storage efficiency lost, in percent, would be too high.
	// Read Only: true
	EfficiencyPercent *int64 `json:"efficiency_percent,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because fast truncate is currently running on files.
	// Read Only: true
	FastTruncate *int64 `json:"fast_truncate,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files with invalid space footprints.
	// Read Only: true
	FootprintInvalid *int64 `json:"footprint_invalid,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files in snapshots.
	// Read Only: true
	InSnapshot *int64 `json:"in_snapshot,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of incompatible files.
	// Read Only: true
	Incompatible *int64 `json:"incompatible,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of metadata files.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of on demand destination files.
	// Read Only: true
	OnDemandDestination *int64 `json:"on_demand_destination,omitempty"`

	// Number of blocks skipped by the scanner on this constituent for all other reasons.
	// Read Only: true
	Other *int64 `json:"other,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of remote caches.
	// Read Only: true
	RemoteCache *int64 `json:"remote_cache,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files that are larger than rebalancing.max_file_size.
	// Read Only: true
	TooLarge *int64 `json:"too_large,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files that are smaller than rebalancing.min_file_size.
	// Read Only: true
	TooSmall *int64 `json:"too_small,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files fenced for write operations.
	// Read Only: true
	WriteFenced *int64 `json:"write_fenced,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline scanner inline blocks skipped
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline scanner inline blocks skipped based on the context it is used
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFastTruncate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprintInvalid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIncompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnDemandDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooLarge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooSmall(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateEfficiencyBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"efficiency_blocks", "body", m.EfficiencyBlocks); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateEfficiencyPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"efficiency_percent", "body", m.EfficiencyPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateFastTruncate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"fast_truncate", "body", m.FastTruncate); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateFootprintInvalid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"footprint_invalid", "body", m.FootprintInvalid); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateInSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"in_snapshot", "body", m.InSnapshot); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateIncompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"incompatible", "body", m.Incompatible); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"metadata", "body", m.Metadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateOnDemandDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"on_demand_destination", "body", m.OnDemandDestination); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"other", "body", m.Other); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateRemoteCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"remote_cache", "body", m.RemoteCache); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateTooLarge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"too_large", "body", m.TooLarge); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateTooSmall(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"too_small", "body", m.TooSmall); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateWriteFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"write_fenced", "body", m.WriteFenced); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineScannerInlineBlocksSkipped
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped Number of files skipped by the scanner on this constituent due to various reasons.
//
// swagger:model volume_inline_rebalancing_inline_engine_inline_scanner_inline_files_skipped
type VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped struct {

	// Number of files skipped by the scanner on this constituent because storage efficiency lost, in blocks, would be too high.
	// Read Only: true
	EfficiencyBlocks *int64 `json:"efficiency_blocks,omitempty"`

	// Number of files skipped by the scanner on this constituent because storage efficiency lost, in percent, would be too high.
	// Read Only: true
	EfficiencyPercent *int64 `json:"efficiency_percent,omitempty"`

	// Number of files skipped by the scanner on this constituent because fast truncate is currently running on the file.
	// Read Only: true
	FastTruncate *int64 `json:"fast_truncate,omitempty"`

	// Number of files skipped by the scanner on this constituent because their space footprints are invalid.
	// Read Only: true
	FootprintInvalid *int64 `json:"footprint_invalid,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are trapped in snapshots.
	// Read Only: true
	InSnapshot *int64 `json:"in_snapshot,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are incompatible.
	// Read Only: true
	Incompatible *int64 `json:"incompatible,omitempty"`

	// Number of files skipped by the scanner on this constituent because they metadata files.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are on demand destinations.
	// Read Only: true
	OnDemandDestination *int64 `json:"on_demand_destination,omitempty"`

	// Number of files skipped by the scanner on this constituent for all other reasons.
	// Read Only: true
	Other *int64 `json:"other,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are remote caches.
	// Read Only: true
	RemoteCache *int64 `json:"remote_cache,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are larger than rebalancing.max_file_size.
	// Read Only: true
	TooLarge *int64 `json:"too_large,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are smaller than rebalancing.min_file_size.
	// Read Only: true
	TooSmall *int64 `json:"too_small,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are fenced for write operations.
	// Read Only: true
	WriteFenced *int64 `json:"write_fenced,omitempty"`
}

// Validate validates this volume inline rebalancing inline engine inline scanner inline files skipped
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline rebalancing inline engine inline scanner inline files skipped based on the context it is used
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFastTruncate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprintInvalid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIncompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnDemandDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooLarge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooSmall(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateEfficiencyBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"efficiency_blocks", "body", m.EfficiencyBlocks); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateEfficiencyPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"efficiency_percent", "body", m.EfficiencyPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateFastTruncate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"fast_truncate", "body", m.FastTruncate); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateFootprintInvalid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"footprint_invalid", "body", m.FootprintInvalid); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateInSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"in_snapshot", "body", m.InSnapshot); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateIncompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"incompatible", "body", m.Incompatible); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"metadata", "body", m.Metadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateOnDemandDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"on_demand_destination", "body", m.OnDemandDestination); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"other", "body", m.Other); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateRemoteCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"remote_cache", "body", m.RemoteCache); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateTooLarge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"too_large", "body", m.TooLarge); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateTooSmall(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"too_small", "body", m.TooSmall); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateWriteFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rebalancing"+"."+"engine"+"."+"scanner"+"."+"files_skipped"+"."+"write_fenced", "body", m.WriteFenced); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineEngineInlineScannerInlineFilesSkipped
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineRebalancingInlineLinks volume inline rebalancing inline links
//
// swagger:model volume_inline_rebalancing_inline__links
type VolumeInlineRebalancingInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline rebalancing inline links
func (m *VolumeInlineRebalancingInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline rebalancing inline links based on the context it is used
func (m *VolumeInlineRebalancingInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineRebalancingInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rebalancing" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineRebalancingInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineRebalancingInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSnaplock volume inline snaplock
//
// swagger:model volume_inline_snaplock
type VolumeInlineSnaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Example: false
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string "none".
	// Example: P30M
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// This is the volume compliance clock time which is used to manage the SnapLock objects in the volume.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`

	// Expiry time of the volume. For volumes with an infinite, indefinite or unspecified SnapLock expiry time, "9999-12-31T23:59:59" is used to denote the time.
	// Example: Wed Sep  5 11:02:42 GMT 2018
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates if this volume has been configured as SnapLock audit log volume for the SVM .
	// Example: true
	// Read Only: true
	IsAuditLog *bool `json:"is_audit_log,omitempty"`

	// Litigation count indicates the number of active legal-holds on the volume.
	// Example: 10
	// Read Only: true
	LitigationCount *int64 `json:"litigation_count,omitempty"`

	// Specifies the privileged-delete attribute of a SnapLock volume. On a SnapLock Enterprise (SLE) volume, a designated privileged user can selectively delete files irrespective of the retention time of the file. SLE volumes can have privileged delete as disabled, enabled or permanently_disabled and for SnapLock Compliance (SLC) volumes it is always permanently_disabled.
	// Example: enabled
	// Enum: ["disabled","enabled","permanently_disabled"]
	PrivilegedDelete *string `json:"privileged_delete,omitempty"`

	// retention
	Retention *VolumeInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the volume. <br>compliance &dash; A SnapLock Compliance(SLC) volume provides the highest level of WORM protection and an administrator cannot destroy a SLC volume if it contains unexpired WORM files. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise(SLE) volume.<br> non_snaplock &dash; Indicates the volume is non-snaplock.
	// Example: enterprise
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`

	// Indicates the number of files with an unspecified retention time in the volume.
	// Example: 10
	// Read Only: true
	UnspecifiedRetentionFileCount *int64 `json:"unspecified_retention_file_count,omitempty"`
}

// Validate validates this volume inline snaplock
func (m *VolumeInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrivilegedDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"compliance_clock_time", "body", "date-time", m.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeInlineSnaplockTypePrivilegedDeletePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","permanently_disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSnaplockTypePrivilegedDeletePropEnum = append(volumeInlineSnaplockTypePrivilegedDeletePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// privileged_delete
	// PrivilegedDelete
	// disabled
	// END DEBUGGING
	// VolumeInlineSnaplockPrivilegedDeleteDisabled captures enum value "disabled"
	VolumeInlineSnaplockPrivilegedDeleteDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// privileged_delete
	// PrivilegedDelete
	// enabled
	// END DEBUGGING
	// VolumeInlineSnaplockPrivilegedDeleteEnabled captures enum value "enabled"
	VolumeInlineSnaplockPrivilegedDeleteEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// privileged_delete
	// PrivilegedDelete
	// permanently_disabled
	// END DEBUGGING
	// VolumeInlineSnaplockPrivilegedDeletePermanentlyDisabled captures enum value "permanently_disabled"
	VolumeInlineSnaplockPrivilegedDeletePermanentlyDisabled string = "permanently_disabled"
)

// prop value enum
func (m *VolumeInlineSnaplock) validatePrivilegedDeleteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSnaplockTypePrivilegedDeletePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSnaplock) validatePrivilegedDelete(formats strfmt.Registry) error {
	if swag.IsZero(m.PrivilegedDelete) { // not required
		return nil
	}

	// value enum
	if err := m.validatePrivilegedDeleteEnum("snaplock"+"."+"privileged_delete", "body", *m.PrivilegedDelete); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var volumeInlineSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSnaplockTypeTypePropEnum = append(volumeInlineSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// VolumeInlineSnaplockTypeCompliance captures enum value "compliance"
	VolumeInlineSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// VolumeInlineSnaplockTypeEnterprise captures enum value "enterprise"
	VolumeInlineSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// volume_inline_snaplock
	// VolumeInlineSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// VolumeInlineSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	VolumeInlineSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *VolumeInlineSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("snaplock"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline snaplock based on the context it is used
func (m *VolumeInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComplianceClockTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsAuditLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLitigationCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnspecifiedRetentionFileCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnaplock) contextValidateComplianceClockTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"compliance_clock_time", "body", m.ComplianceClockTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnaplock) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"expiry_time", "body", m.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnaplock) contextValidateIsAuditLog(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"is_audit_log", "body", m.IsAuditLog); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnaplock) contextValidateLitigationCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"litigation_count", "body", m.LitigationCount); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineSnaplock) contextValidateUnspecifiedRetentionFileCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"unspecified_retention_file_count", "body", m.UnspecifiedRetentionFileCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSnaplockInlineRetention volume inline snaplock inline retention
//
// swagger:model volume_inline_snaplock_inline_retention
type VolumeInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
	// Example: P30Y
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this volume inline snaplock inline retention
func (m *VolumeInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline snaplock inline retention based on context it is used
func (m *VolumeInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSnapmirror Specifies attributes for SnapMirror protection.
//
// swagger:model volume_inline_snapmirror
type VolumeInlineSnapmirror struct {

	// destinations
	Destinations *VolumeInlineSnapmirrorInlineDestinations `json:"destinations,omitempty"`

	// Specifies whether a volume is a SnapMirror source volume, using SnapMirror to protect its data.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`
}

// Validate validates this volume inline snapmirror
func (m *VolumeInlineSnapmirror) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestinations(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapmirror) validateDestinations(formats strfmt.Registry) error {
	if swag.IsZero(m.Destinations) { // not required
		return nil
	}

	if m.Destinations != nil {
		if err := m.Destinations.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapmirror" + "." + "destinations")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline snapmirror based on the context it is used
func (m *VolumeInlineSnapmirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestinations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapmirror) contextValidateDestinations(ctx context.Context, formats strfmt.Registry) error {

	if m.Destinations != nil {
		if err := m.Destinations.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapmirror" + "." + "destinations")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineSnapmirror) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapmirror"+"."+"is_protected", "body", m.IsProtected); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSnapmirror) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSnapmirror) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapmirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSnapmirrorInlineDestinations volume inline snapmirror inline destinations
//
// swagger:model volume_inline_snapmirror_inline_destinations
type VolumeInlineSnapmirrorInlineDestinations struct {

	// Specifies whether a volume is a SnapMirror source volume, using SnapMirror to protect its data to a cloud destination.
	// Read Only: true
	IsCloud *bool `json:"is_cloud,omitempty"`

	// Specifies whether a volume is a SnapMirror source volume, using SnapMirror to protect its data to an ONTAP destination.
	// Read Only: true
	IsOntap *bool `json:"is_ontap,omitempty"`
}

// Validate validates this volume inline snapmirror inline destinations
func (m *VolumeInlineSnapmirrorInlineDestinations) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline snapmirror inline destinations based on the context it is used
func (m *VolumeInlineSnapmirrorInlineDestinations) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsOntap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapmirrorInlineDestinations) contextValidateIsCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapmirror"+"."+"destinations"+"."+"is_cloud", "body", m.IsCloud); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSnapmirrorInlineDestinations) contextValidateIsOntap(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapmirror"+"."+"destinations"+"."+"is_ontap", "body", m.IsOntap); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSnapmirrorInlineDestinations) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSnapmirrorInlineDestinations) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapmirrorInlineDestinations
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSnapshotPolicy This is a reference to the snapshot policy.
//
// swagger:model volume_inline_snapshot_policy
type VolumeInlineSnapshotPolicy struct {

	// links
	Links *VolumeInlineSnapshotPolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline snapshot policy
func (m *VolumeInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline snapshot policy based on the context it is used
func (m *VolumeInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSnapshotPolicyInlineLinks volume inline snapshot policy inline links
//
// swagger:model volume_inline_snapshot_policy_inline__links
type VolumeInlineSnapshotPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline snapshot policy inline links
func (m *VolumeInlineSnapshotPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapshotPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline snapshot policy inline links based on the context it is used
func (m *VolumeInlineSnapshotPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSnapshotPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSnapshotPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSnapshotPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSnapshotPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSpace volume inline space
//
// swagger:model volume_inline_space
type VolumeInlineSpace struct {

	// Total size of AFS, excluding snap-reserve, in bytes.
	AfsTotal *int64 `json:"afs_total,omitempty"`

	// Savings achieved due to Auto Adaptive Compression, in bytes.
	// Read Only: true
	AutoAdaptiveCompressionFootprintDataReduction *int64 `json:"auto_adaptive_compression_footprint_data_reduction,omitempty"`

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The space available, as a percent.
	AvailablePercent *int64 `json:"available_percent,omitempty"`

	// The size that is physically used in the block storage of the volume and has a cold temperature. In bytes. This parameter is only supported if the volume is in an aggregate that is either attached to a cloud store or could be attached to a cloud store.
	// Read Only: true
	BlockStorageInactiveUserData *int64 `json:"block_storage_inactive_user_data,omitempty"`

	// Percentage of size that is physically used in the performance tier of the volume.
	// Read Only: true
	BlockStorageInactiveUserDataPercent *int64 `json:"block_storage_inactive_user_data_percent,omitempty"`

	// Space used by capacity tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	CapacityTierFootprint *int64 `json:"capacity_tier_footprint,omitempty"`

	// Savings achieved in the space used by the capacity tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	CapacityTierFootprintDataReduction *int64 `json:"capacity_tier_footprint_data_reduction,omitempty"`

	// Savings achieved due to Data Compaction, in bytes.
	// Read Only: true
	CompactionFootprintDataReduction *int64 `json:"compaction_footprint_data_reduction,omitempty"`

	// Cross volume deduplication metadata footprint, in bytes.
	// Read Only: true
	CrossVolumeDedupeMetafilesFootprint *int64 `json:"cross_volume_dedupe_metafiles_footprint,omitempty"`

	// Cross volume temporary deduplication metadata footprint, in bytes.
	// Read Only: true
	CrossVolumeDedupeMetafilesTemporaryFootprint *int64 `json:"cross_volume_dedupe_metafiles_temporary_footprint,omitempty"`

	// Deduplication metadata footprint, in bytes.
	// Read Only: true
	DedupeMetafilesFootprint *int64 `json:"dedupe_metafiles_footprint,omitempty"`

	// Temporary deduplication metadata footprint, in bytes.
	// Read Only: true
	DedupeMetafilesTemporaryFootprint *int64 `json:"dedupe_metafiles_temporary_footprint,omitempty"`

	// Delayed free blocks footprint, in bytes.
	// Read Only: true
	DelayedFreeFootprint *int64 `json:"delayed_free_footprint,omitempty"`

	// Volume footprint after efficiency savings, in bytes. effective total footprint represents total footprint after deducting auto adaptive compression and compaction savings. effective-footprint includes aggregate metadata used by volume.
	// Read Only: true
	EffectiveTotalFootprint *int64 `json:"effective_total_footprint,omitempty"`

	// Size that should be available for the volume, irrespective of available size in the aggregate, in bytes.
	ExpectedAvailable *int64 `json:"expected_available,omitempty"`

	// File operation metadata footprint, in bytes.
	// Read Only: true
	FileOperationMetadata *int64 `json:"file_operation_metadata,omitempty"`

	// Total usable size of the volume, in bytes.
	// Read Only: true
	FilesystemSize *int64 `json:"filesystem_size,omitempty"`

	// Specifies whether the file system is to remain of the same size when set to true or to grow when set to false. This option is automatically set to true when a volume becomes SnapMirrored.
	FilesystemSizeFixed *bool `json:"filesystem_size_fixed,omitempty"`

	// Data used for this volume in the aggregate, in bytes.
	// Read Only: true
	Footprint *int64 `json:"footprint,omitempty"`

	// Used to change the amount of space reserved for overwrites of reserved objects in a volume.
	FractionalReserve *int64 `json:"fractional_reserve,omitempty"`

	// Volume full threshold percentage at which EMS warnings can be sent.
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// Specifies if the virtual space used is stale.
	// Read Only: true
	IsUsedStale *bool `json:"is_used_stale,omitempty"`

	// Indicates if the support for large FlexVol volumes and large files is enabled on this volume. When configured to true, FlexVol volume size can reach up to 300TB and single file size can reach 128TB.
	LargeSizeEnabled *bool `json:"large_size_enabled,omitempty"`

	// Space used by the local tier for this volume in the aggregate, in bytes.
	// Read Only: true
	LocalTierFootprint *int64 `json:"local_tier_footprint,omitempty"`

	// logical space
	LogicalSpace *VolumeInlineSpaceInlineLogicalSpace `json:"logical_space,omitempty"`

	// Indicates the maximum size supported for the FlexVol volume or for each constituent of the FlexGroup volume.
	// Enum: ["100T","300T","600T"]
	MaxSize *string `json:"max_size,omitempty"`

	// Space used by the volume metadata in the aggregate, in bytes.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Volume nearly full threshold percentage at which EMS warnings can be sent.
	NearlyFullThresholdPercent *int64 `json:"nearly_full_threshold_percent,omitempty"`

	// The amount of space not available for this volume in the aggregate, in bytes.
	// Read Only: true
	OverProvisioned *int64 `json:"over_provisioned,omitempty"`

	// Reserved space for overwrites, in bytes.
	// Read Only: true
	OverwriteReserve *int64 `json:"overwrite_reserve,omitempty"`

	// Overwrite logical reserve space used, in bytes.
	// Read Only: true
	OverwriteReserveUsed *int64 `json:"overwrite_reserve_used,omitempty"`

	// Percentage of the volume size that is used.
	// Read Only: true
	PercentUsed *int64 `json:"percent_used,omitempty"`

	// Space used by the performance tier for this volume in the FabricPool aggregate, in bytes.
	// Read Only: true
	PerformanceTierFootprint *int64 `json:"performance_tier_footprint,omitempty"`

	// Size that is physically used in the volume, in bytes. Physical used is effective total footprint which is equivalent to total footprint after deducting auto adaptive compression and compaction savings. Physical-used also includes aggregate metadata used by volume.
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// Size that is physically used in the volume, as a percentage.
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// Total provisioned size. The default size is equal to the minimum size of 20MB, in bytes.
	Size *int64 `json:"size,omitempty"`

	// Available space for snapshots from snap-reserve, in bytes.
	// Read Only: true
	SizeAvailableForSnapshots *int64 `json:"size_available_for_snapshots,omitempty"`

	// SnapMirror destination footprint, in bytes.
	// Read Only: true
	SnapmirrorDestinationFootprint *int64 `json:"snapmirror_destination_footprint,omitempty"`

	// snapshot
	Snapshot *VolumeInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// Snapshot reserve that is not available for snapshot creation, in bytes.
	// Read Only: true
	SnapshotReserveUnusable *int64 `json:"snapshot_reserve_unusable,omitempty"`

	// Space used by the snapshot copies beyond the snap-reserve, in bytes.
	// Read Only: true
	SnapshotSpill *int64 `json:"snapshot_spill,omitempty"`

	// Data and metadata used for this volume in the aggregate, in bytes.
	// Read Only: true
	TotalFootprint *int64 `json:"total_footprint,omitempty"`

	// Space used by the total metadata in the volume, in bytes.
	// Read Only: true
	TotalMetadata *int64 `json:"total_metadata,omitempty"`

	// Space used by the volume metadata footprint in the aggregate, in bytes.
	// Read Only: true
	TotalMetadataFootprint *int64 `json:"total_metadata_footprint,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The space used by Active Filesystem, in bytes.
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`

	// User data, in bytes.
	// Read Only: true
	UserData *int64 `json:"user_data,omitempty"`

	// Space reserved for future writes in the volume, in bytes.
	// Read Only: true
	VolumeGuaranteeFootprint *int64 `json:"volume_guarantee_footprint,omitempty"`
}

// Validate validates this volume inline space
func (m *VolumeInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLogicalSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSpace) validateLogicalSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.LogicalSpace) { // not required
		return nil
	}

	if m.LogicalSpace != nil {
		if err := m.LogicalSpace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

var volumeInlineSpaceTypeMaxSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["100T","300T","600T"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceTypeMaxSizePropEnum = append(volumeInlineSpaceTypeMaxSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space
	// VolumeInlineSpace
	// max_size
	// MaxSize
	// 100T
	// END DEBUGGING
	// VolumeInlineSpaceMaxSizeNr100T captures enum value "100T"
	VolumeInlineSpaceMaxSizeNr100T string = "100T"

	// BEGIN DEBUGGING
	// volume_inline_space
	// VolumeInlineSpace
	// max_size
	// MaxSize
	// 300T
	// END DEBUGGING
	// VolumeInlineSpaceMaxSizeNr300T captures enum value "300T"
	VolumeInlineSpaceMaxSizeNr300T string = "300T"

	// BEGIN DEBUGGING
	// volume_inline_space
	// VolumeInlineSpace
	// max_size
	// MaxSize
	// 600T
	// END DEBUGGING
	// VolumeInlineSpaceMaxSizeNr600T captures enum value "600T"
	VolumeInlineSpaceMaxSizeNr600T string = "600T"
)

// prop value enum
func (m *VolumeInlineSpace) validateMaxSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceTypeMaxSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSpace) validateMaxSize(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateMaxSizeEnum("space"+"."+"max_size", "body", *m.MaxSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline space based on the context it is used
func (m *VolumeInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutoAdaptiveCompressionFootprintDataReduction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockStorageInactiveUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockStorageInactiveUserDataPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacityTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacityTierFootprintDataReduction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompactionFootprintDataReduction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeDedupeMetafilesFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeDedupeMetafilesTemporaryFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDedupeMetafilesFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDedupeMetafilesTemporaryFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDelayedFreeFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEffectiveTotalFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileOperationMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesystemSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsUsedStale(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverwriteReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverwriteReserveUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePerformanceTierFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSizeAvailableForSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirrorDestinationFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotReserveUnusable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotSpill(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalMetadataFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeGuaranteeFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSpace) contextValidateAutoAdaptiveCompressionFootprintDataReduction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"auto_adaptive_compression_footprint_data_reduction", "body", m.AutoAdaptiveCompressionFootprintDataReduction); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateBlockStorageInactiveUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage_inactive_user_data", "body", m.BlockStorageInactiveUserData); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateBlockStorageInactiveUserDataPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage_inactive_user_data_percent", "body", m.BlockStorageInactiveUserDataPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateCapacityTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"capacity_tier_footprint", "body", m.CapacityTierFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateCapacityTierFootprintDataReduction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"capacity_tier_footprint_data_reduction", "body", m.CapacityTierFootprintDataReduction); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateCompactionFootprintDataReduction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"compaction_footprint_data_reduction", "body", m.CompactionFootprintDataReduction); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateCrossVolumeDedupeMetafilesFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"cross_volume_dedupe_metafiles_footprint", "body", m.CrossVolumeDedupeMetafilesFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateCrossVolumeDedupeMetafilesTemporaryFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"cross_volume_dedupe_metafiles_temporary_footprint", "body", m.CrossVolumeDedupeMetafilesTemporaryFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateDedupeMetafilesFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"dedupe_metafiles_footprint", "body", m.DedupeMetafilesFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateDedupeMetafilesTemporaryFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"dedupe_metafiles_temporary_footprint", "body", m.DedupeMetafilesTemporaryFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateDelayedFreeFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"delayed_free_footprint", "body", m.DelayedFreeFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateEffectiveTotalFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"effective_total_footprint", "body", m.EffectiveTotalFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateFileOperationMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"file_operation_metadata", "body", m.FileOperationMetadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateFilesystemSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"filesystem_size", "body", m.FilesystemSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"footprint", "body", m.Footprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateIsUsedStale(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"is_used_stale", "body", m.IsUsedStale); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateLocalTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"local_tier_footprint", "body", m.LocalTierFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateLogicalSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.LogicalSpace != nil {
		if err := m.LogicalSpace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "logical_space")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"metadata", "body", m.Metadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateOverProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"over_provisioned", "body", m.OverProvisioned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateOverwriteReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"overwrite_reserve", "body", m.OverwriteReserve); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateOverwriteReserveUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"overwrite_reserve_used", "body", m.OverwriteReserveUsed); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidatePercentUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"percent_used", "body", m.PercentUsed); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidatePerformanceTierFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"performance_tier_footprint", "body", m.PerformanceTierFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateSizeAvailableForSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"size_available_for_snapshots", "body", m.SizeAvailableForSnapshots); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateSnapmirrorDestinationFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapmirror_destination_footprint", "body", m.SnapmirrorDestinationFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateSnapshotReserveUnusable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot_reserve_unusable", "body", m.SnapshotReserveUnusable); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateSnapshotSpill(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot_spill", "body", m.SnapshotSpill); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateTotalFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_footprint", "body", m.TotalFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateTotalMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata", "body", m.TotalMetadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateTotalMetadataFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata_footprint", "body", m.TotalMetadataFootprint); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"user_data", "body", m.UserData); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpace) contextValidateVolumeGuaranteeFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"volume_guarantee_footprint", "body", m.VolumeGuaranteeFootprint); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSpaceInlineLogicalSpace volume inline space inline logical space
//
// swagger:model volume_inline_space_inline_logical_space
type VolumeInlineSpaceInlineLogicalSpace struct {

	// The amount of space available in this volume with storage efficiency space considered used, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Specifies whether space accounting for operations on the volume is done along with storage efficiency.
	Enforcement *bool `json:"enforcement,omitempty"`

	// Specifies whether space reporting on the volume is done along with storage efficiency.
	Reporting *bool `json:"reporting,omitempty"`

	// SUM of (physical-used, shared_refs, compression_saved_in_plane0, vbn_zero, future_blk_cnt), in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The virtual space used by AFS alone (includes volume reserves) and along with storage efficiency, in bytes.
	// Read Only: true
	UsedByAfs *int64 `json:"used_by_afs,omitempty"`

	// Size that is logically used across all snapshots in the volume, in bytes.
	// Read Only: true
	UsedBySnapshots *int64 `json:"used_by_snapshots,omitempty"`

	// SUM of (physical-used, shared_refs, compression_saved_in_plane0, vbn_zero, future_blk_cnt), as a percentage.
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this volume inline space inline logical space
func (m *VolumeInlineSpaceInlineLogicalSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline space inline logical space based on the context it is used
func (m *VolumeInlineSpaceInlineLogicalSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedByAfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSpaceInlineLogicalSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsedByAfs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"used_by_afs", "body", m.UsedByAfs); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"used_by_snapshots", "body", m.UsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineLogicalSpace) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_space"+"."+"used_percent", "body", m.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSpaceInlineLogicalSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSpaceInlineLogicalSpace) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpaceInlineLogicalSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSpaceInlineSnapshot volume inline space inline snapshot
//
// swagger:model volume_inline_space_inline_snapshot
type VolumeInlineSpaceInlineSnapshot struct {

	// autodelete
	Autodelete *VolumeInlineSpaceInlineSnapshotInlineAutodelete `json:"autodelete,omitempty"`

	// Specifies whether snapshot autodelete is currently enabled on this volume. This field will no longer be supported in a future release. Use autodelete.enabled instead.
	AutodeleteEnabled *bool `json:"autodelete_enabled,omitempty"`

	// Specifies when the system should trigger an autodelete of snapshots. When set to _volume_, autodelete is triggered based on volume fullness. When set to _snap_reserve_, autodelete is triggered based on snapshot reserve fullness. The default value is _volume_. This field will no longer be supported in a future release. Use autodelete.trigger instead.
	// Enum: ["volume","snap_reserve"]
	AutodeleteTrigger *string `json:"autodelete_trigger,omitempty"`

	// Size available for snapshots within the snapshot reserve, in bytes.
	// Read Only: true
	ReserveAvailable *int64 `json:"reserve_available,omitempty"`

	// The space that has been set aside as a reserve for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Size in the volume that has been set aside as a reserve for snapshot usage, in bytes.
	// Read Only: true
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// Percentage of snapshot reserve size that has been used.
	// Read Only: true
	SpaceUsedPercent *int64 `json:"space_used_percent,omitempty"`

	// The total space used by snapshots in the volume, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this volume inline space inline snapshot
func (m *VolumeInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutodelete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutodeleteTrigger(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) validateAutodelete(formats strfmt.Registry) error {
	if swag.IsZero(m.Autodelete) { // not required
		return nil
	}

	if m.Autodelete != nil {
		if err := m.Autodelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","snap_reserve"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum = append(volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot
	// VolumeInlineSpaceInlineSnapshot
	// autodelete_trigger
	// AutodeleteTrigger
	// volume
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotAutodeleteTriggerVolume captures enum value "volume"
	VolumeInlineSpaceInlineSnapshotAutodeleteTriggerVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot
	// VolumeInlineSpaceInlineSnapshot
	// autodelete_trigger
	// AutodeleteTrigger
	// snap_reserve
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotAutodeleteTriggerSnapReserve captures enum value "snap_reserve"
	VolumeInlineSpaceInlineSnapshotAutodeleteTriggerSnapReserve string = "snap_reserve"
)

// prop value enum
func (m *VolumeInlineSpaceInlineSnapshot) validateAutodeleteTriggerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotTypeAutodeleteTriggerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) validateAutodeleteTrigger(formats strfmt.Registry) error {
	if swag.IsZero(m.AutodeleteTrigger) { // not required
		return nil
	}

	// value enum
	if err := m.validateAutodeleteTriggerEnum("space"+"."+"snapshot"+"."+"autodelete_trigger", "body", *m.AutodeleteTrigger); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline space inline snapshot based on the context it is used
func (m *VolumeInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutodelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpaceUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) contextValidateAutodelete(ctx context.Context, formats strfmt.Registry) error {

	if m.Autodelete != nil {
		if err := m.Autodelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) contextValidateReserveAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"reserve_available", "body", m.ReserveAvailable); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) contextValidateReserveSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"reserve_size", "body", m.ReserveSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) contextValidateSpaceUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"space_used_percent", "body", m.SpaceUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSpaceInlineSnapshotInlineAutodelete volume inline space inline snapshot inline autodelete
//
// swagger:model volume_inline_space_inline_snapshot_inline_autodelete
type VolumeInlineSpaceInlineSnapshotInlineAutodelete struct {

	// By default, snapshot autodelete does not delete snapshots locked by Snapmirror, clones of a volume, a LUN, an NVMe namespace, or a file.  Deletion of snapshots locked by these applications is specified using this option. The default value is try.
	// Enum: ["try","disrupt","destroy"]
	Commitment *string `json:"commitment,omitempty"`

	// Allows the user to inform snapshot autodelete to defer the deletion of a specified snapshot until the end. The default value is user_created.
	// Enum: ["scheduled","user_created","prefix","none"]
	DeferDelete *string `json:"defer_delete,omitempty"`

	// Specifies the order in which snapshot autodelete occurs. Ordering is done using the date and time the snapshot is created. The default value is oldest_first.
	// Enum: ["newest_first","oldest_first"]
	DeleteOrder *string `json:"delete_order,omitempty"`

	// Specifies whether snapshot autodelete is currently enabled on this volume.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the prefix of the snapshot which if matched, is deleted last. Used with autodelete_defer_delete when used with a prefix value.
	Prefix *string `json:"prefix,omitempty"`

	// Snapshots are deleted, one at a time, until the used volume space reaches the value specified. The default is 20% free space or 80% utilized.
	TargetFreeSpace *int64 `json:"target_free_space,omitempty"`

	// Specifies when the system should trigger an autodelete of snapshots. When set to _volume_, autodelete is triggered based on volume fullness. When set to _snap_reserve_, autodelete is triggered based on snapshot reserve fullness. The default value is _volume_.
	// Enum: ["volume","snap_reserve"]
	Trigger *string `json:"trigger,omitempty"`
}

// Validate validates this volume inline space inline snapshot inline autodelete
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCommitment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeferDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeleteOrder(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTrigger(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["try","disrupt","destroy"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// commitment
	// Commitment
	// try
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentTry captures enum value "try"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentTry string = "try"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// commitment
	// Commitment
	// disrupt
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDisrupt captures enum value "disrupt"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDisrupt string = "disrupt"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// commitment
	// Commitment
	// destroy
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDestroy captures enum value "destroy"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteCommitmentDestroy string = "destroy"
)

// prop value enum
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateCommitmentEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeCommitmentPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateCommitment(formats strfmt.Registry) error {
	if swag.IsZero(m.Commitment) { // not required
		return nil
	}

	// value enum
	if err := m.validateCommitmentEnum("space"+"."+"snapshot"+"."+"autodelete"+"."+"commitment", "body", *m.Commitment); err != nil {
		return err
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["scheduled","user_created","prefix","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// scheduled
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteScheduled captures enum value "scheduled"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteScheduled string = "scheduled"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// user_created
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteUserCreated captures enum value "user_created"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteUserCreated string = "user_created"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// prefix
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeletePrefix captures enum value "prefix"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeletePrefix string = "prefix"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// defer_delete
	// DeferDelete
	// none
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteNone captures enum value "none"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeferDeleteNone string = "none"
)

// prop value enum
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeferDeleteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeferDeletePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeferDelete(formats strfmt.Registry) error {
	if swag.IsZero(m.DeferDelete) { // not required
		return nil
	}

	// value enum
	if err := m.validateDeferDeleteEnum("space"+"."+"snapshot"+"."+"autodelete"+"."+"defer_delete", "body", *m.DeferDelete); err != nil {
		return err
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["newest_first","oldest_first"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// delete_order
	// DeleteOrder
	// newest_first
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderNewestFirst captures enum value "newest_first"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderNewestFirst string = "newest_first"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// delete_order
	// DeleteOrder
	// oldest_first
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderOldestFirst captures enum value "oldest_first"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteDeleteOrderOldestFirst string = "oldest_first"
)

// prop value enum
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeleteOrderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeDeleteOrderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateDeleteOrder(formats strfmt.Registry) error {
	if swag.IsZero(m.DeleteOrder) { // not required
		return nil
	}

	// value enum
	if err := m.validateDeleteOrderEnum("space"+"."+"snapshot"+"."+"autodelete"+"."+"delete_order", "body", *m.DeleteOrder); err != nil {
		return err
	}

	return nil
}

var volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","snap_reserve"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum = append(volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// trigger
	// Trigger
	// volume
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerVolume captures enum value "volume"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerVolume string = "volume"

	// BEGIN DEBUGGING
	// volume_inline_space_inline_snapshot_inline_autodelete
	// VolumeInlineSpaceInlineSnapshotInlineAutodelete
	// trigger
	// Trigger
	// snap_reserve
	// END DEBUGGING
	// VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerSnapReserve captures enum value "snap_reserve"
	VolumeInlineSpaceInlineSnapshotInlineAutodeleteTriggerSnapReserve string = "snap_reserve"
)

// prop value enum
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateTriggerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineSpaceInlineSnapshotInlineAutodeleteTypeTriggerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) validateTrigger(formats strfmt.Registry) error {
	if swag.IsZero(m.Trigger) { // not required
		return nil
	}

	// value enum
	if err := m.validateTriggerEnum("space"+"."+"snapshot"+"."+"autodelete"+"."+"trigger", "body", *m.Trigger); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline space inline snapshot inline autodelete based on context it is used
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSpaceInlineSnapshotInlineAutodelete) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSpaceInlineSnapshotInlineAutodelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model volume_inline_statistics
type VolumeInlineStatistics struct {

	// cifs ops raw
	CifsOpsRaw *VolumeInlineStatisticsInlineCifsOpsRaw `json:"cifs_ops_raw,omitempty"`

	// cloud
	Cloud *VolumeInlineStatisticsInlineCloud `json:"cloud,omitempty"`

	// flexcache raw
	FlexcacheRaw *VolumeInlineStatisticsInlineFlexcacheRaw `json:"flexcache_raw,omitempty"`

	// iops raw
	IopsRaw *VolumeInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *VolumeInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// nfs ops raw
	NfsOpsRaw *VolumeInlineStatisticsInlineNfsOpsRaw `json:"nfs_ops_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *VolumeInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline statistics
func (m *VolumeInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifsOpsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloud(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcacheRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNfsOpsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatistics) validateCifsOpsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsOpsRaw) { // not required
		return nil
	}

	if m.CifsOpsRaw != nil {
		if err := m.CifsOpsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) validateCloud(formats strfmt.Registry) error {
	if swag.IsZero(m.Cloud) { // not required
		return nil
	}

	if m.Cloud != nil {
		if err := m.Cloud.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) validateFlexcacheRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexcacheRaw) { // not required
		return nil
	}

	if m.FlexcacheRaw != nil {
		if err := m.FlexcacheRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "flexcache_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) validateNfsOpsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.NfsOpsRaw) { // not required
		return nil
	}

	if m.NfsOpsRaw != nil {
		if err := m.NfsOpsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw")
			}
			return err
		}
	}

	return nil
}

var volumeInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineStatisticsTypeStatusPropEnum = append(volumeInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineStatisticsStatusOk captures enum value "ok"
	VolumeInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineStatisticsStatusError captures enum value "error"
	VolumeInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_statistics
	// VolumeInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline statistics based on the context it is used
func (m *VolumeInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifsOpsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcacheRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNfsOpsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatistics) contextValidateCifsOpsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.CifsOpsRaw != nil {
		if err := m.CifsOpsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateCloud(ctx context.Context, formats strfmt.Registry) error {

	if m.Cloud != nil {
		if err := m.Cloud.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cloud")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateFlexcacheRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.FlexcacheRaw != nil {
		if err := m.FlexcacheRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "flexcache_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateNfsOpsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.NfsOpsRaw != nil {
		if err := m.NfsOpsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatistics) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRaw Raw data component performance values for CIFS operations on this volume, including number of operations and raw latency, in microseconds for each operation. The values are cumulative and increase while the volume is online.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw
type VolumeInlineStatisticsInlineCifsOpsRaw struct {

	// access
	Access *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess `json:"access,omitempty"`

	// audit
	Audit *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit `json:"audit,omitempty"`

	// create
	Create *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *VolumeInlineStatisticsInlineCifsOpsRawInlineLink `json:"link,omitempty"`

	// lock
	Lock *VolumeInlineStatisticsInlineCifsOpsRawInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup `json:"lookup,omitempty"`

	// open
	Open *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen `json:"open,omitempty"`

	// read
	Read *VolumeInlineStatisticsInlineCifsOpsRawInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *VolumeInlineStatisticsInlineCifsOpsRawInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch `json:"watch,omitempty"`

	// write
	Write *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw
func (m *VolumeInlineStatisticsInlineCifsOpsRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(m.Audit) { // not required
		return nil
	}

	if m.Audit != nil {
		if err := m.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(m.Create) { // not required
		return nil
	}

	if m.Create != nil {
		if err := m.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Getattr) { // not required
		return nil
	}

	if m.Getattr != nil {
		if err := m.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(m.Link) { // not required
		return nil
	}

	if m.Link != nil {
		if err := m.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(m.Lock) { // not required
		return nil
	}

	if m.Lock != nil {
		if err := m.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(m.Lookup) { // not required
		return nil
	}

	if m.Lookup != nil {
		if err := m.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(m.Open) { // not required
		return nil
	}

	if m.Open != nil {
		if err := m.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(m.Read) { // not required
		return nil
	}

	if m.Read != nil {
		if err := m.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(m.Readdir) { // not required
		return nil
	}

	if m.Readdir != nil {
		if err := m.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Readlink) { // not required
		return nil
	}

	if m.Readlink != nil {
		if err := m.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(m.Rename) { // not required
		return nil
	}

	if m.Rename != nil {
		if err := m.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Setattr) { // not required
		return nil
	}

	if m.Setattr != nil {
		if err := m.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Unlink) { // not required
		return nil
	}

	if m.Unlink != nil {
		if err := m.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Watch) { // not required
		return nil
	}

	if m.Watch != nil {
		if err := m.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(m.Write) { // not required
		return nil
	}

	if m.Write != nil {
		if err := m.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw based on the context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {
		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if m.Audit != nil {
		if err := m.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if m.Create != nil {
		if err := m.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Getattr != nil {
		if err := m.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if m.Link != nil {
		if err := m.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if m.Lock != nil {
		if err := m.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if m.Lookup != nil {
		if err := m.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if m.Open != nil {
		if err := m.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if m.Read != nil {
		if err := m.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if m.Readdir != nil {
		if err := m.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Readlink != nil {
		if err := m.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if m.Rename != nil {
		if err := m.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Setattr != nil {
		if err := m.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Unlink != nil {
		if err := m.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Watch != nil {
		if err := m.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRaw) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if m.Write != nil {
		if err := m.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineAccess Raw count and latency data for access operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_access
type VolumeInlineStatisticsInlineCifsOpsRawInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline access
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline access based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_audit
type VolumeInlineStatisticsInlineCifsOpsRawInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline audit
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline audit based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineCreate Raw count and latency data for create operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreate struct {

	// dir
	Dir *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(m.Dir) { // not required
		return nil
	}

	if m.Dir != nil {
		if err := m.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(m.Other) { // not required
		return nil
	}

	if m.Other != nil {
		if err := m.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Symlink) { // not required
		return nil
	}

	if m.Symlink != nil {
		if err := m.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw inline create based on the context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if m.Dir != nil {
		if err := m.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if m.Other != nil {
		if err := m.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Symlink != nil {
		if err := m.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cifs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir Raw count and latency data for directory-create operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_dir
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline dir
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline dir based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile Raw count and latency data for file-create operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_file
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline file
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline file based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_other
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline other
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline other based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_create_inline_symlink
type VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline create inline symlink
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline create inline symlink based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr Raw count and latency data for getattr operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_getattr
type VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline getattr
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline getattr based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineLink Raw count and latency data for link operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_link
type VolumeInlineStatisticsInlineCifsOpsRawInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline link
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline link based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineLock Raw count and latency data for lock operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_lock
type VolumeInlineStatisticsInlineCifsOpsRawInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline lock
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline lock based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineLookup Raw count and latency data for lookup operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_lookup
type VolumeInlineStatisticsInlineCifsOpsRawInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline lookup
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline lookup based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineOpen Raw count and latency data for open operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_open
type VolumeInlineStatisticsInlineCifsOpsRawInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline open
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline open based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_read
type VolumeInlineStatisticsInlineCifsOpsRawInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline read
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw inline read based on the context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir Raw count and latency data for readdir operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_readdir
type VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline readdir
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline readdir based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink Raw count and latency data for readlink operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_readlink
type VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline readlink
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline readlink based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineRename Raw count and latency data for rename operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_rename
type VolumeInlineStatisticsInlineCifsOpsRawInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline rename
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline rename based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr Raw count and latency data for setattr operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_setattr
type VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline setattr
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline setattr based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink Raw count and latency data for unlink operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_unlink
type VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline unlink
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline unlink based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_watch
type VolumeInlineStatisticsInlineCifsOpsRawInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline watch
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline cifs ops raw inline watch based on context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCifsOpsRawInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_inline_statistics_inline_cifs_ops_raw_inline_write
type VolumeInlineStatisticsInlineCifsOpsRawInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline cifs ops raw inline write
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cifs ops raw inline write based on the context it is used
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"cifs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCifsOpsRawInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCifsOpsRawInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCloud These are raw performance numbers (IOPS and latency) for the cloud store. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster. These numbers are relevant only for volumes hosted on FabricPools.
//
// swagger:model volume_inline_statistics_inline_cloud
type VolumeInlineStatisticsInlineCloud struct {

	// iops raw
	IopsRaw *VolumeInlineStatisticsInlineCloudInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *VolumeInlineStatisticsInlineCloudInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline statistics inline cloud
func (m *VolumeInlineStatisticsInlineCloud) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cloud" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cloud" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var volumeInlineStatisticsInlineCloudTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineStatisticsInlineCloudTypeStatusPropEnum = append(volumeInlineStatisticsInlineCloudTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusOk captures enum value "ok"
	VolumeInlineStatisticsInlineCloudStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusError captures enum value "error"
	VolumeInlineStatisticsInlineCloudStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineStatisticsInlineCloudStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineStatisticsInlineCloudStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineStatisticsInlineCloudStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineStatisticsInlineCloudStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineStatisticsInlineCloudStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineStatisticsInlineCloudStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineStatisticsInlineCloudStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_cloud
	// VolumeInlineStatisticsInlineCloud
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineCloudStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineStatisticsInlineCloudStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeInlineStatisticsInlineCloud) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineStatisticsInlineCloudTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"cloud"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"cloud"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline cloud based on the context it is used
func (m *VolumeInlineStatisticsInlineCloud) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cloud" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "cloud" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"cloud"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineCloud) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"cloud"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCloud) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCloud) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCloud
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCloudInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model volume_inline_statistics_inline_cloud_inline_iops_raw
type VolumeInlineStatisticsInlineCloudInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline cloud inline iops raw
func (m *VolumeInlineStatisticsInlineCloudInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cloud inline iops raw based on the context it is used
func (m *VolumeInlineStatisticsInlineCloudInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCloudInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCloudInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCloudInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineCloudInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model volume_inline_statistics_inline_cloud_inline_latency_raw
type VolumeInlineStatisticsInlineCloudInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline cloud inline latency raw
func (m *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline cloud inline latency raw based on the context it is used
func (m *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineCloudInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineCloudInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineFlexcacheRaw Performance numbers for FlexCache used to measure cache effectiveness.
//
// swagger:model volume_inline_statistics_inline_flexcache_raw
type VolumeInlineStatisticsInlineFlexcacheRaw struct {

	// Blocks retrieved from origin in case of a cache miss. This can be divided by the raw client_requested_blocks and multiplied by 100 to calculate the cache miss percentage.
	// Example: 10
	CacheMissBlocks *int64 `json:"cache_miss_blocks,omitempty"`

	// Total blocks requested by the client.
	// Example: 500
	ClientRequestedBlocks *int64 `json:"client_requested_blocks,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume inline statistics inline flexcache raw
func (m *VolumeInlineStatisticsInlineFlexcacheRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum = append(volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusOk captures enum value "ok"
	VolumeInlineStatisticsInlineFlexcacheRawStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusError captures enum value "error"
	VolumeInlineStatisticsInlineFlexcacheRawStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoData captures enum value "partial_no_data"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusPartialOtherError captures enum value "partial_other_error"
	VolumeInlineStatisticsInlineFlexcacheRawStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusNegativeDelta captures enum value "negative_delta"
	VolumeInlineStatisticsInlineFlexcacheRawStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusBackfilledData captures enum value "backfilled_data"
	VolumeInlineStatisticsInlineFlexcacheRawStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_inline_statistics_inline_flexcache_raw
	// VolumeInlineStatisticsInlineFlexcacheRaw
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeInlineStatisticsInlineFlexcacheRawStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeInlineStatisticsInlineFlexcacheRaw) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineStatisticsInlineFlexcacheRawTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineFlexcacheRaw) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"flexcache_raw"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineFlexcacheRaw) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"flexcache_raw"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline flexcache raw based on the context it is used
func (m *VolumeInlineStatisticsInlineFlexcacheRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineFlexcacheRaw) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"flexcache_raw"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineFlexcacheRaw) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"flexcache_raw"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineFlexcacheRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineFlexcacheRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineFlexcacheRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model volume_inline_statistics_inline_iops_raw
type VolumeInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline iops raw
func (m *VolumeInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline iops raw based on the context it is used
func (m *VolumeInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model volume_inline_statistics_inline_latency_raw
type VolumeInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline latency raw
func (m *VolumeInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline latency raw based on the context it is used
func (m *VolumeInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRaw Raw data component performance values for NFS operations on this volume, including number of operations and raw latency, in microseconds for each operation. The values are cumulative and increase while the volume is online.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw
type VolumeInlineStatisticsInlineNfsOpsRaw struct {

	// access
	Access *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess `json:"access,omitempty"`

	// audit
	Audit *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit `json:"audit,omitempty"`

	// create
	Create *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *VolumeInlineStatisticsInlineNfsOpsRawInlineLink `json:"link,omitempty"`

	// lock
	Lock *VolumeInlineStatisticsInlineNfsOpsRawInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup `json:"lookup,omitempty"`

	// open
	Open *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen `json:"open,omitempty"`

	// read
	Read *VolumeInlineStatisticsInlineNfsOpsRawInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *VolumeInlineStatisticsInlineNfsOpsRawInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch `json:"watch,omitempty"`

	// write
	Write *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw
func (m *VolumeInlineStatisticsInlineNfsOpsRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(m.Audit) { // not required
		return nil
	}

	if m.Audit != nil {
		if err := m.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(m.Create) { // not required
		return nil
	}

	if m.Create != nil {
		if err := m.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Getattr) { // not required
		return nil
	}

	if m.Getattr != nil {
		if err := m.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(m.Link) { // not required
		return nil
	}

	if m.Link != nil {
		if err := m.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(m.Lock) { // not required
		return nil
	}

	if m.Lock != nil {
		if err := m.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(m.Lookup) { // not required
		return nil
	}

	if m.Lookup != nil {
		if err := m.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(m.Open) { // not required
		return nil
	}

	if m.Open != nil {
		if err := m.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(m.Read) { // not required
		return nil
	}

	if m.Read != nil {
		if err := m.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(m.Readdir) { // not required
		return nil
	}

	if m.Readdir != nil {
		if err := m.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Readlink) { // not required
		return nil
	}

	if m.Readlink != nil {
		if err := m.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(m.Rename) { // not required
		return nil
	}

	if m.Rename != nil {
		if err := m.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Setattr) { // not required
		return nil
	}

	if m.Setattr != nil {
		if err := m.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Unlink) { // not required
		return nil
	}

	if m.Unlink != nil {
		if err := m.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Watch) { // not required
		return nil
	}

	if m.Watch != nil {
		if err := m.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(m.Write) { // not required
		return nil
	}

	if m.Write != nil {
		if err := m.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw based on the context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {
		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if m.Audit != nil {
		if err := m.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if m.Create != nil {
		if err := m.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Getattr != nil {
		if err := m.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if m.Link != nil {
		if err := m.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if m.Lock != nil {
		if err := m.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if m.Lookup != nil {
		if err := m.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if m.Open != nil {
		if err := m.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if m.Read != nil {
		if err := m.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if m.Readdir != nil {
		if err := m.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Readlink != nil {
		if err := m.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if m.Rename != nil {
		if err := m.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Setattr != nil {
		if err := m.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Unlink != nil {
		if err := m.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Watch != nil {
		if err := m.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRaw) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if m.Write != nil {
		if err := m.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineAccess Raw count and latency data for access operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_access
type VolumeInlineStatisticsInlineNfsOpsRawInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline access
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline access based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_audit
type VolumeInlineStatisticsInlineNfsOpsRawInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline audit
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline audit based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineCreate Raw count and latency data for create operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreate struct {

	// dir
	Dir *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(m.Dir) { // not required
		return nil
	}

	if m.Dir != nil {
		if err := m.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(m.Other) { // not required
		return nil
	}

	if m.Other != nil {
		if err := m.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Symlink) { // not required
		return nil
	}

	if m.Symlink != nil {
		if err := m.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw inline create based on the context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if m.Dir != nil {
		if err := m.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if m.Other != nil {
		if err := m.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Symlink != nil {
		if err := m.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "nfs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir Raw count and latency data for directory-create operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_dir
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline dir
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline dir based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile Raw count and latency data for file-create operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_file
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline file
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline file based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_other
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline other
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline other based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_create_inline_symlink
type VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline create inline symlink
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline create inline symlink based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr Raw count and latency data for getattr operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_getattr
type VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline getattr
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline getattr based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineLink Raw count and latency data for link operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_link
type VolumeInlineStatisticsInlineNfsOpsRawInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline link
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline link based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineLock Raw count and latency data for lock operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_lock
type VolumeInlineStatisticsInlineNfsOpsRawInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline lock
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline lock based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineLookup Raw count and latency data for lookup operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_lookup
type VolumeInlineStatisticsInlineNfsOpsRawInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline lookup
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline lookup based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineOpen Raw count and latency data for open operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_open
type VolumeInlineStatisticsInlineNfsOpsRawInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline open
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline open based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_read
type VolumeInlineStatisticsInlineNfsOpsRawInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline read
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw inline read based on the context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir Raw count and latency data for readdir operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_readdir
type VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline readdir
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline readdir based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink Raw count and latency data for readlink operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_readlink
type VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline readlink
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline readlink based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineRename Raw count and latency data for rename operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_rename
type VolumeInlineStatisticsInlineNfsOpsRawInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline rename
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline rename based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr Raw count and latency data for setattr operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_setattr
type VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline setattr
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline setattr based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink Raw count and latency data for unlink operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_unlink
type VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline unlink
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline unlink based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_watch
type VolumeInlineStatisticsInlineNfsOpsRawInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline watch
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume inline statistics inline nfs ops raw inline watch based on context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineNfsOpsRawInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_inline_statistics_inline_nfs_ops_raw_inline_write
type VolumeInlineStatisticsInlineNfsOpsRawInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume inline statistics inline nfs ops raw inline write
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline nfs ops raw inline write based on the context it is used
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "statistics"+"."+"nfs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineNfsOpsRawInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineNfsOpsRawInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model volume_inline_statistics_inline_throughput_raw
type VolumeInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume inline statistics inline throughput raw
func (m *VolumeInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume inline statistics inline throughput raw based on the context it is used
func (m *VolumeInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res VolumeInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSvm SVM containing the volume. Required on POST.
//
// swagger:model volume_inline_svm
type VolumeInlineSvm struct {

	// links
	Links *VolumeInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this volume inline svm
func (m *VolumeInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline svm based on the context it is used
func (m *VolumeInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSvm) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineSvmInlineLinks volume inline svm inline links
//
// swagger:model volume_inline_svm_inline__links
type VolumeInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume inline svm inline links
func (m *VolumeInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume inline svm inline links based on the context it is used
func (m *VolumeInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeInlineTiering volume inline tiering
//
// swagger:model volume_inline_tiering
type VolumeInlineTiering struct {

	// This parameter specifies the minimum number of days that user data blocks of the volume must be cooled before they can be considered cold and tiered out to the cloud tier. Note that this parameter is only used for tiering purposes and does not affect the reporting of inactive data. The value specified should be greater than the frequency with which applications in the volume shift between different sets of data. This parameter cannot be set when volume tiering policy is either "none" or "all". The default value of this parameter depends on the volume's tiering policy. See the tiering policy section of this documentation for corresponding default values. If the tiering policy on the volume gets changed, then this parameter will be reset to the default value corresponding to the new tiering policy.
	// Maximum: 183
	// Minimum: 2
	MinCoolingDays *int64 `json:"min_cooling_days,omitempty"`

	// This parameter specifies tags of a volume for objects stored on a FabricPool-enabled aggregate. Each tag is a key,value pair and should be in the format "key=value".
	// Max Items: 4
	// Min Items: 0
	// Unique: true
	ObjectTags []*string `json:"object_tags,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold. FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br>all &dash; This policy allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br>auto &dash; This policy allows tiering of both snapshot and active file system user data to the cloud store<br>none &dash; Volume blocks will not be tiered to the cloud store.<br>snapshot_only &dash; This policy allows tiering of only the volume snapshots not associated with the active file system. The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy is 31 days.
	// Enum: ["all","auto","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`

	// This parameter specifies whether or not FabricPools are selected when provisioning a FlexGroup volume without specifying "aggregates.name" or "aggregates.uuid". Only FabricPool aggregates are used if this parameter is set to true and only non FabricPool aggregates are used if this parameter is set to false. Tiering support for a FlexGroup volume can be changed by moving all of the constituents to the required aggregates. Note that in order to tier data, not only does the volume need to support tiering by using FabricPools, the tiering "policy" must not be 'none'. A volume that uses FabricPools but has a tiering "policy" of 'none' supports tiering, but will not tier any data.
	Supported *bool `json:"supported,omitempty"`
}

// Validate validates this volume inline tiering
func (m *VolumeInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMinCoolingDays(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeInlineTiering) validateMinCoolingDays(formats strfmt.Registry) error {
	if swag.IsZero(m.MinCoolingDays) { // not required
		return nil
	}

	if err := validate.MinimumInt("tiering"+"."+"min_cooling_days", "body", *m.MinCoolingDays, 2, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("tiering"+"."+"min_cooling_days", "body", *m.MinCoolingDays, 183, false); err != nil {
		return err
	}

	return nil
}

func (m *VolumeInlineTiering) validateObjectTags(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectTags) { // not required
		return nil
	}

	iObjectTagsSize := int64(len(m.ObjectTags))

	if err := validate.MinItems("tiering"+"."+"object_tags", "body", iObjectTagsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_tags", "body", iObjectTagsSize, 4); err != nil {
		return err
	}

	if err := validate.UniqueItems("tiering"+"."+"object_tags", "body", m.ObjectTags); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectTags); i++ {
		if swag.IsZero(m.ObjectTags[i]) { // not required
			continue
		}

		if err := validate.MaxLength("tiering"+"."+"object_tags"+"."+strconv.Itoa(i), "body", *m.ObjectTags[i], 257); err != nil {
			return err
		}

		if err := validate.Pattern("tiering"+"."+"object_tags"+"."+strconv.Itoa(i), "body", *m.ObjectTags[i], `[_a-zA-Z][_a-zA-Z0-9]{0,126}=[_a-zA-Z0-9]{1,127}`); err != nil {
			return err
		}

	}

	return nil
}

var volumeInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeInlineTieringTypePolicyPropEnum = append(volumeInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// VolumeInlineTieringPolicyAll captures enum value "all"
	VolumeInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// VolumeInlineTieringPolicyAuto captures enum value "auto"
	VolumeInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// VolumeInlineTieringPolicyNone captures enum value "none"
	VolumeInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// volume_inline_tiering
	// VolumeInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// VolumeInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	VolumeInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *VolumeInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this volume inline tiering based on context it is used
func (m *VolumeInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeInlineTiering) UnmarshalBinary(b []byte) error {
	var res VolumeInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
