// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumeMetrics Performance numbers, such as IOPS, latency and throughput.
//
// swagger:model volume_metrics
type VolumeMetrics struct {

	// links
	Links *VolumeMetricsInlineLinks `json:"_links,omitempty"`

	// cloud
	Cloud *VolumeMetricsInlineCloud `json:"cloud,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// flexcache
	Flexcache *VolumeMetricsInlineFlexcache `json:"flexcache,omitempty"`

	// iops
	Iops *VolumeMetricsInlineIops `json:"iops,omitempty"`

	// latency
	Latency *VolumeMetricsInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *VolumeMetricsInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume metrics
func (m *VolumeMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloud(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeMetrics) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) validateCloud(formats strfmt.Registry) error {
	if swag.IsZero(m.Cloud) { // not required
		return nil
	}

	if m.Cloud != nil {
		if err := m.Cloud.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud")
			}
			return err
		}
	}

	return nil
}

var volumeMetricsTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeMetricsTypeDurationPropEnum = append(volumeMetricsTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeMetricsDurationPT15S captures enum value "PT15S"
	VolumeMetricsDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// VolumeMetricsDurationPT4M captures enum value "PT4M"
	VolumeMetricsDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeMetricsDurationPT30M captures enum value "PT30M"
	VolumeMetricsDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeMetricsDurationPT2H captures enum value "PT2H"
	VolumeMetricsDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// VolumeMetricsDurationP1D captures enum value "P1D"
	VolumeMetricsDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeMetricsDurationPT5M captures enum value "PT5M"
	VolumeMetricsDurationPT5M string = "PT5M"
)

// prop value enum
func (m *VolumeMetrics) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeMetricsTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeMetrics) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetrics) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexcache) { // not required
		return nil
	}

	if m.Flexcache != nil {
		if err := m.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var volumeMetricsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeMetricsTypeStatusPropEnum = append(volumeMetricsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeMetricsStatusOk captures enum value "ok"
	VolumeMetricsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeMetricsStatusError captures enum value "error"
	VolumeMetricsStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeMetricsStatusPartialNoData captures enum value "partial_no_data"
	VolumeMetricsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeMetricsStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeMetricsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeMetricsStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeMetricsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeMetricsStatusPartialOtherError captures enum value "partial_other_error"
	VolumeMetricsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeMetricsStatusNegativeDelta captures enum value "negative_delta"
	VolumeMetricsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeMetricsStatusBackfilledData captures enum value "backfilled_data"
	VolumeMetricsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeMetricsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeMetricsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_metrics
	// VolumeMetrics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeMetricsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeMetricsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeMetrics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeMetricsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeMetrics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetrics) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume metrics based on the context it is used
func (m *VolumeMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeMetrics) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) contextValidateCloud(ctx context.Context, formats strfmt.Registry) error {

	if m.Cloud != nil {
		if err := m.Cloud.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetrics) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexcache != nil {
		if err := m.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetrics) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetrics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetrics) UnmarshalBinary(b []byte) error {
	var res VolumeMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineCloud Performance numbers (IOPS and latency) for cloud store. These numbers are relevant only for volumes hosted on FabricPools.
//
// swagger:model volume_metrics_inline_cloud
type VolumeMetricsInlineCloud struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *VolumeMetricsInlineCloudInlineIops `json:"iops,omitempty"`

	// latency
	Latency *VolumeMetricsInlineCloudInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume metrics inline cloud
func (m *VolumeMetricsInlineCloud) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeMetricsInlineCloudTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeMetricsInlineCloudTypeDurationPropEnum = append(volumeMetricsInlineCloudTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeMetricsInlineCloudDurationPT15S captures enum value "PT15S"
	VolumeMetricsInlineCloudDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// VolumeMetricsInlineCloudDurationPT4M captures enum value "PT4M"
	VolumeMetricsInlineCloudDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeMetricsInlineCloudDurationPT30M captures enum value "PT30M"
	VolumeMetricsInlineCloudDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeMetricsInlineCloudDurationPT2H captures enum value "PT2H"
	VolumeMetricsInlineCloudDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// VolumeMetricsInlineCloudDurationP1D captures enum value "P1D"
	VolumeMetricsInlineCloudDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeMetricsInlineCloudDurationPT5M captures enum value "PT5M"
	VolumeMetricsInlineCloudDurationPT5M string = "PT5M"
)

// prop value enum
func (m *VolumeMetricsInlineCloud) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeMetricsInlineCloudTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeMetricsInlineCloud) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("cloud"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var volumeMetricsInlineCloudTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeMetricsInlineCloudTypeStatusPropEnum = append(volumeMetricsInlineCloudTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusOk captures enum value "ok"
	VolumeMetricsInlineCloudStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusError captures enum value "error"
	VolumeMetricsInlineCloudStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusPartialNoData captures enum value "partial_no_data"
	VolumeMetricsInlineCloudStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeMetricsInlineCloudStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeMetricsInlineCloudStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusPartialOtherError captures enum value "partial_other_error"
	VolumeMetricsInlineCloudStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusNegativeDelta captures enum value "negative_delta"
	VolumeMetricsInlineCloudStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusBackfilledData captures enum value "backfilled_data"
	VolumeMetricsInlineCloudStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeMetricsInlineCloudStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_metrics_inline_cloud
	// VolumeMetricsInlineCloud
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeMetricsInlineCloudStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeMetricsInlineCloudStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeMetricsInlineCloud) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeMetricsInlineCloudTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeMetricsInlineCloud) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("cloud"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("cloud"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume metrics inline cloud based on the context it is used
func (m *VolumeMetricsInlineCloud) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeMetricsInlineCloud) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineCloud) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineCloud) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineCloud) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineCloud
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineCloudInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model volume_metrics_inline_cloud_inline_iops
type VolumeMetricsInlineCloudInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume metrics inline cloud inline iops
func (m *VolumeMetricsInlineCloudInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume metrics inline cloud inline iops based on the context it is used
func (m *VolumeMetricsInlineCloudInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineCloudInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineCloudInlineIops) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineCloudInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineCloudInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model volume_metrics_inline_cloud_inline_latency
type VolumeMetricsInlineCloudInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume metrics inline cloud inline latency
func (m *VolumeMetricsInlineCloudInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume metrics inline cloud inline latency based on the context it is used
func (m *VolumeMetricsInlineCloudInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineCloudInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineCloudInlineLatency) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineCloudInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineFlexcache Performance number for FlexCache used to measure cache effectiveness.
//
// swagger:model volume_metrics_inline_flexcache
type VolumeMetricsInlineFlexcache struct {

	// Bandwidth savings denoting the amount of data served locally by the cache, in bytes.
	// Example: 4096
	BandwidthSavings *int64 `json:"bandwidth_savings,omitempty"`

	// Cache miss percentage.
	// Example: 20
	CacheMissPercent *int64 `json:"cache_miss_percent,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT1D
	// Read Only: true
	// Enum: ["PT15S","PT5M","PT30M","PT2H","PT1D"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume metrics inline flexcache
func (m *VolumeMetricsInlineFlexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeMetricsInlineFlexcacheTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","PT1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeMetricsInlineFlexcacheTypeDurationPropEnum = append(volumeMetricsInlineFlexcacheTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheDurationPT15S captures enum value "PT15S"
	VolumeMetricsInlineFlexcacheDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheDurationPT5M captures enum value "PT5M"
	VolumeMetricsInlineFlexcacheDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheDurationPT30M captures enum value "PT30M"
	VolumeMetricsInlineFlexcacheDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheDurationPT2H captures enum value "PT2H"
	VolumeMetricsInlineFlexcacheDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// duration
	// Duration
	// PT1D
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheDurationPT1D captures enum value "PT1D"
	VolumeMetricsInlineFlexcacheDurationPT1D string = "PT1D"
)

// prop value enum
func (m *VolumeMetricsInlineFlexcache) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeMetricsInlineFlexcacheTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeMetricsInlineFlexcache) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("flexcache"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var volumeMetricsInlineFlexcacheTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeMetricsInlineFlexcacheTypeStatusPropEnum = append(volumeMetricsInlineFlexcacheTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusOk captures enum value "ok"
	VolumeMetricsInlineFlexcacheStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusError captures enum value "error"
	VolumeMetricsInlineFlexcacheStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusPartialNoData captures enum value "partial_no_data"
	VolumeMetricsInlineFlexcacheStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeMetricsInlineFlexcacheStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeMetricsInlineFlexcacheStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusPartialOtherError captures enum value "partial_other_error"
	VolumeMetricsInlineFlexcacheStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusNegativeDelta captures enum value "negative_delta"
	VolumeMetricsInlineFlexcacheStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusBackfilledData captures enum value "backfilled_data"
	VolumeMetricsInlineFlexcacheStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeMetricsInlineFlexcacheStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_metrics_inline_flexcache
	// VolumeMetricsInlineFlexcache
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeMetricsInlineFlexcacheStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeMetricsInlineFlexcacheStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeMetricsInlineFlexcache) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeMetricsInlineFlexcacheTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeMetricsInlineFlexcache) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("flexcache"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineFlexcache) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("flexcache"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume metrics inline flexcache based on the context it is used
func (m *VolumeMetricsInlineFlexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeMetricsInlineFlexcache) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexcache"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineFlexcache) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexcache"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeMetricsInlineFlexcache) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexcache"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineFlexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineFlexcache) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineFlexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model volume_metrics_inline_iops
type VolumeMetricsInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume metrics inline iops
func (m *VolumeMetricsInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume metrics inline iops based on the context it is used
func (m *VolumeMetricsInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineIops) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model volume_metrics_inline_latency
type VolumeMetricsInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume metrics inline latency
func (m *VolumeMetricsInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume metrics inline latency based on the context it is used
func (m *VolumeMetricsInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineLatency) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineLinks volume metrics inline links
//
// swagger:model volume_metrics_inline__links
type VolumeMetricsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume metrics inline links
func (m *VolumeMetricsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeMetricsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume metrics inline links based on the context it is used
func (m *VolumeMetricsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeMetricsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeMetricsInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model volume_metrics_inline_throughput
type VolumeMetricsInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume metrics inline throughput
func (m *VolumeMetricsInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume metrics inline throughput based on the context it is used
func (m *VolumeMetricsInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeMetricsInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeMetricsInlineThroughput) UnmarshalBinary(b []byte) error {
	var res VolumeMetricsInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
