// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumeProtocolRawPerformanceStatRw volume protocol raw performance stat rw
//
// swagger:model volume_protocol_raw_performance_stat_rw
type VolumeProtocolRawPerformanceStatRw struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol raw performance stat rw inline volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol raw performance stat rw inline volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume protocol raw performance stat rw
func (m *VolumeProtocolRawPerformanceStatRw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume protocol raw performance stat rw based on the context it is used
func (m *VolumeProtocolRawPerformanceStatRw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStatRw) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatRw) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatRw) contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatRw) contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatRw) contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatRw) contextValidateVolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolRawPerformanceStatRwInlineVolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatRw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatRw) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatRw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
