// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumeProtocolRawPerformanceStats volume protocol raw performance stats
//
// swagger:model volume_protocol_raw_performance_stats
type VolumeProtocolRawPerformanceStats struct {

	// access
	Access *VolumeProtocolRawPerformanceStatsInlineAccess `json:"access,omitempty"`

	// audit
	Audit *VolumeProtocolRawPerformanceStatsInlineAudit `json:"audit,omitempty"`

	// create
	Create *VolumeProtocolRawPerformanceStatsInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *VolumeProtocolRawPerformanceStatsInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *VolumeProtocolRawPerformanceStatsInlineLink `json:"link,omitempty"`

	// lock
	Lock *VolumeProtocolRawPerformanceStatsInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *VolumeProtocolRawPerformanceStatsInlineLookup `json:"lookup,omitempty"`

	// open
	Open *VolumeProtocolRawPerformanceStatsInlineOpen `json:"open,omitempty"`

	// read
	Read *VolumeProtocolRawPerformanceStatsInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *VolumeProtocolRawPerformanceStatsInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *VolumeProtocolRawPerformanceStatsInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *VolumeProtocolRawPerformanceStatsInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *VolumeProtocolRawPerformanceStatsInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *VolumeProtocolRawPerformanceStatsInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *VolumeProtocolRawPerformanceStatsInlineWatch `json:"watch,omitempty"`

	// write
	Write *VolumeProtocolRawPerformanceStatsInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume protocol raw performance stats
func (m *VolumeProtocolRawPerformanceStats) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(m.Audit) { // not required
		return nil
	}

	if m.Audit != nil {
		if err := m.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(m.Create) { // not required
		return nil
	}

	if m.Create != nil {
		if err := m.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Getattr) { // not required
		return nil
	}

	if m.Getattr != nil {
		if err := m.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(m.Link) { // not required
		return nil
	}

	if m.Link != nil {
		if err := m.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(m.Lock) { // not required
		return nil
	}

	if m.Lock != nil {
		if err := m.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(m.Lookup) { // not required
		return nil
	}

	if m.Lookup != nil {
		if err := m.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(m.Open) { // not required
		return nil
	}

	if m.Open != nil {
		if err := m.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(m.Read) { // not required
		return nil
	}

	if m.Read != nil {
		if err := m.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(m.Readdir) { // not required
		return nil
	}

	if m.Readdir != nil {
		if err := m.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Readlink) { // not required
		return nil
	}

	if m.Readlink != nil {
		if err := m.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(m.Rename) { // not required
		return nil
	}

	if m.Rename != nil {
		if err := m.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Setattr) { // not required
		return nil
	}

	if m.Setattr != nil {
		if err := m.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Unlink) { // not required
		return nil
	}

	if m.Unlink != nil {
		if err := m.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Watch) { // not required
		return nil
	}

	if m.Watch != nil {
		if err := m.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(m.Write) { // not required
		return nil
	}

	if m.Write != nil {
		if err := m.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume protocol raw performance stats based on the context it is used
func (m *VolumeProtocolRawPerformanceStats) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {
		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if m.Audit != nil {
		if err := m.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if m.Create != nil {
		if err := m.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Getattr != nil {
		if err := m.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if m.Link != nil {
		if err := m.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if m.Lock != nil {
		if err := m.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if m.Lookup != nil {
		if err := m.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if m.Open != nil {
		if err := m.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if m.Read != nil {
		if err := m.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if m.Readdir != nil {
		if err := m.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Readlink != nil {
		if err := m.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if m.Rename != nil {
		if err := m.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Setattr != nil {
		if err := m.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Unlink != nil {
		if err := m.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Watch != nil {
		if err := m.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStats) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if m.Write != nil {
		if err := m.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStats) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStats) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStats
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineAccess Raw count and latency data for access operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_access
type VolumeProtocolRawPerformanceStatsInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline access
func (m *VolumeProtocolRawPerformanceStatsInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline access based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_audit
type VolumeProtocolRawPerformanceStatsInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline audit
func (m *VolumeProtocolRawPerformanceStatsInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline audit based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineAudit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineCreate Raw count and latency data for create operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_create
type VolumeProtocolRawPerformanceStatsInlineCreate struct {

	// dir
	Dir *VolumeProtocolRawPerformanceStatsInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *VolumeProtocolRawPerformanceStatsInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *VolumeProtocolRawPerformanceStatsInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline create
func (m *VolumeProtocolRawPerformanceStatsInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(m.Dir) { // not required
		return nil
	}

	if m.Dir != nil {
		if err := m.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(m.Other) { // not required
		return nil
	}

	if m.Other != nil {
		if err := m.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Symlink) { // not required
		return nil
	}

	if m.Symlink != nil {
		if err := m.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume protocol raw performance stats inline create based on the context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if m.Dir != nil {
		if err := m.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if m.Other != nil {
		if err := m.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Symlink != nil {
		if err := m.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineCreateInlineDir Raw count and latency data for directory-create operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_create_inline_dir
type VolumeProtocolRawPerformanceStatsInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline create inline dir
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline create inline dir based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineCreateInlineFile Raw count and latency data for file-create operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_create_inline_file
type VolumeProtocolRawPerformanceStatsInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline create inline file
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline create inline file based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
//
// swagger:model volume_protocol_raw_performance_stats_inline_create_inline_other
type VolumeProtocolRawPerformanceStatsInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline create inline other
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline create inline other based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_create_inline_symlink
type VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline create inline symlink
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline create inline symlink based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineGetattr Raw count and latency data for getattr operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_getattr
type VolumeProtocolRawPerformanceStatsInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline getattr
func (m *VolumeProtocolRawPerformanceStatsInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline getattr based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineGetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineLink Raw count and latency data for link operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_link
type VolumeProtocolRawPerformanceStatsInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline link
func (m *VolumeProtocolRawPerformanceStatsInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline link based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineLock Raw count and latency data for lock operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_lock
type VolumeProtocolRawPerformanceStatsInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline lock
func (m *VolumeProtocolRawPerformanceStatsInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline lock based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineLookup Raw count and latency data for lookup operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_lookup
type VolumeProtocolRawPerformanceStatsInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline lookup
func (m *VolumeProtocolRawPerformanceStatsInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline lookup based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineLookup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineOpen Raw count and latency data for open operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_open
type VolumeProtocolRawPerformanceStatsInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline open
func (m *VolumeProtocolRawPerformanceStatsInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline open based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineOpen) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_protocol_raw_performance_stats_inline_read
type VolumeProtocolRawPerformanceStatsInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline read
func (m *VolumeProtocolRawPerformanceStatsInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume protocol raw performance stats inline read based on the context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "read"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "read"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineRead) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineReaddir Raw count and latency data for readdir operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_readdir
type VolumeProtocolRawPerformanceStatsInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline readdir
func (m *VolumeProtocolRawPerformanceStatsInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline readdir based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineReaddir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineReadlink Raw count and latency data for readlink operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_readlink
type VolumeProtocolRawPerformanceStatsInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline readlink
func (m *VolumeProtocolRawPerformanceStatsInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline readlink based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineReadlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineRename Raw count and latency data for rename operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_rename
type VolumeProtocolRawPerformanceStatsInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline rename
func (m *VolumeProtocolRawPerformanceStatsInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline rename based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineRename) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineSetattr Raw count and latency data for setattr operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_setattr
type VolumeProtocolRawPerformanceStatsInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline setattr
func (m *VolumeProtocolRawPerformanceStatsInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline setattr based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineSetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineUnlink Raw count and latency data for unlink operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_unlink
type VolumeProtocolRawPerformanceStatsInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline unlink
func (m *VolumeProtocolRawPerformanceStatsInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline unlink based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineUnlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_protocol_raw_performance_stats_inline_watch
type VolumeProtocolRawPerformanceStatsInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline watch
func (m *VolumeProtocolRawPerformanceStatsInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume protocol raw performance stats inline watch based on context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineWatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeProtocolRawPerformanceStatsInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_protocol_raw_performance_stats_inline_write
type VolumeProtocolRawPerformanceStatsInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume protocol raw performance stats inline write
func (m *VolumeProtocolRawPerformanceStatsInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume protocol raw performance stats inline write based on the context it is used
func (m *VolumeProtocolRawPerformanceStatsInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "write"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "write"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeProtocolRawPerformanceStatsInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineWrite) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeProtocolRawPerformanceStatsInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeProtocolRawPerformanceStatsInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
