// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumeRebalancing Configuration and runtime properties involving non-disruptive volume capacity rebalancing for a FlexGroup volume.
//
// swagger:model volume_rebalancing
type VolumeRebalancing struct {

	// links
	Links *VolumeRebalancingInlineLinks `json:"_links,omitempty"`

	// The amount of data that has been moved in or out of a constituent. A positive value represents data moving into the constituent while a negative value is data moving out of the constituent.
	// Read Only: true
	DataMoved *int64 `json:"data_moved,omitempty"`

	// engine
	Engine *VolumeRebalancingInlineEngine `json:"engine,omitempty"`

	// Specifies whether or not to exclude files that are stuck in snapshots during rebalancing operation. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "exclude_snapshots" value. Once the operation is started, any changes to the "exclude_snapshots" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "exclude_snapshots" value.
	ExcludeSnapshots *bool `json:"exclude_snapshots,omitempty"`

	// Represents the percentage the volume is out of balance.
	// Read Only: true
	ImbalancePercent *int64 `json:"imbalance_percent,omitempty"`

	// Represents how much the volume is out of balance, in bytes.
	// Read Only: true
	ImbalanceSize *int64 `json:"imbalance_size,omitempty"`

	// Absolute percentage of the constituent that is most out of balance. This value will update every 30 seconds when rebalancing is not active and every 10 seconds when rebalancing is active.
	// Read Only: true
	MaxConstituentImbalancePercent *int64 `json:"max_constituent_imbalance_percent,omitempty"`

	// Specifies the maximum number of concurrent file moves in a volume capacity rebalancing operation on a constituent of the FlexGroup volume. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "max_file_moves" value. Once the operation is started, any changes to the "max_file_moves" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "max_file_moves" value.
	MaxFileMoves *int64 `json:"max_file_moves,omitempty"`

	// This optional field specifies the maximum time a capacity rebalancing operation runs for. Once the maximum runtime has passed, the capacity rebalancing operation stops. If it is not set, the default value is 6 hours. This value cannot be updated while a capacity rebalancing operation is running.  The maximum runtime can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P3D" represents a duration of 3 days. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively.
	MaxRuntime *string `json:"max_runtime,omitempty"`

	// Specifies the maximum imbalance percentage for FlexGroup volume constituents. When a constituent's imbalance percentage is larger than this value, files are moved from the constituent. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "max_threshold" value. Once the operation is started, any changes to the "max_threshold" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "max_threshold" value.
	MaxThreshold *int64 `json:"max_threshold,omitempty"`

	// Specifies the minimum file size to consider for a volume capacity rebalancing operation. When a new capacity rebalancing operation is started on a FlexGroup volume, it uses the current "min_file_size" value. Once the operation is started, any changes to the "min_file_size" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "min_file_size" value. The value must be a multiple of 4KB. If it is not set, the default value is 100MB. Setting "min-file-size" to less than the default value leads to more files being moved. Moved files use granular data, which may impact read/write I/O performance.
	MinFileSize *int64 `json:"min_file_size,omitempty"`

	// Specifies the minimum imbalance percentage for FlexGroup volume constituents. When a constituent's imbalance percentage is smaller than this value, files are not moved from the constituent. When a new capacity rebalancing operation is started on a FlexGroup volume, it will use the current "min_threshold" value. Once the operation is started, any changes to the "min_threshold" value do not affect the currently running capacity rebalancing operation. Only future capacity rebalancing operations will use the new "min_threshold" value.
	MinThreshold *int64 `json:"min_threshold,omitempty"`

	// Duration the capacity rebalancing operation has been running.
	// Read Only: true
	Runtime *string `json:"runtime,omitempty"`

	// Time when the current capacity rebalancing operation started, or when a future scheduled rebalancing operation begins.
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// State of the volume capacity rebalancing operation. PATCH the state to "starting" to trigger the capacity rebalance operation, and include start_time to schedule rebalancing. PATCH the state to "stopping" to stop the capacity rebalance operation, or cancel a scheduled rebalancing operation. PATCH without the state with a valid start_time to modify the start_time of an existing scheduled rebalance operation.<br><br>While a FlexGroup volume is rebalancing, every constituent will have a rebalancing engine that can either be scanning the filesystem for space usage and files to move, actively moving files or temporarily doing neither.<br><br>If one or more constituents has a state of "rebalancing_source" or "rebalancing_dest", then files are being moved to rebalance the FlexGroup volume.<br><br>If no files are being moved, more information about what the rebalancing engine is doing for each constituent is available using the "rebalancing.engine" property.<br><br>The following values apply to FlexGroup volumes.<br>not_running &dash; capacity rebalancing is not running on the volume.<br>starting &dash; used in a PATCH operation to start a capacity rebalancing operation.<br>rebalancing &dash; capacity rebalancing is running on the volume.<br> paused &dash; volume capacity rebalancing is paused on the volume.<br>stopping &dash; used in a PATCH operation to stop a capacity rebalancing operation.<br>unknown &dash; the system was unable to determine the rebalancing state for the volume.<br><br>The following values apply to FlexGroup volume constituents.<br>idle &dash; capacity rebalancing is running on the constituent, however, no active scanning or file movement is currently occurring.<br>scanning &dash; the constituent's file system is being scanned to find files to move and determine free space.<br>rebalancing_source &dash; a file is being moved off of the constituent.<br>rebalancing_dest &dash; a file is being moved to the constituent.<br>not_running &dash; capacity rebalancing is not running on the constituent.<br>unknown &dash; the system was unable to determine the rebalancing state for the constituent.
	// Example: rebalancing
	// Enum: ["not_running","starting","rebalancing","paused","stopping","idle","scanning","rebalancing_source","rebalancing_dest","unknown"]
	State *string `json:"state,omitempty"`

	// Time when the capacity rebalancing operation stopped.
	// Read Only: true
	// Format: date-time
	StopTime *strfmt.DateTime `json:"stop_time,omitempty"`

	// Represents the ideal used size of each constituent. Calculated by dividing the total FlexGroup volume used size by the number of constituents.
	// Read Only: true
	TargetUsed *int64 `json:"target_used,omitempty"`

	// Represents the used size of each constituent, as determined by the rebalancing engine. Calculated by subtracting the size used by snapshots, the size of files pending deletion and the size of filesystem metadata from the volume used size.
	// Read Only: true
	UsedForImbalance *int64 `json:"used_for_imbalance,omitempty"`

	// Capacity rebalancing notice messages.
	// Read Only: true
	VolumeRebalancingInlineNotices []*Error `json:"notices,omitempty"`
}

// Validate validates this volume rebalancing
func (m *VolumeRebalancing) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEngine(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeRebalancingInlineNotices(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancing) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancing) validateEngine(formats strfmt.Registry) error {
	if swag.IsZero(m.Engine) { // not required
		return nil
	}

	if m.Engine != nil {
		if err := m.Engine.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancing) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeRebalancingTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_running","starting","rebalancing","paused","stopping","idle","scanning","rebalancing_source","rebalancing_dest","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeRebalancingTypeStatePropEnum = append(volumeRebalancingTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// not_running
	// END DEBUGGING
	// VolumeRebalancingStateNotRunning captures enum value "not_running"
	VolumeRebalancingStateNotRunning string = "not_running"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// starting
	// END DEBUGGING
	// VolumeRebalancingStateStarting captures enum value "starting"
	VolumeRebalancingStateStarting string = "starting"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// rebalancing
	// END DEBUGGING
	// VolumeRebalancingStateRebalancing captures enum value "rebalancing"
	VolumeRebalancingStateRebalancing string = "rebalancing"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// paused
	// END DEBUGGING
	// VolumeRebalancingStatePaused captures enum value "paused"
	VolumeRebalancingStatePaused string = "paused"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// stopping
	// END DEBUGGING
	// VolumeRebalancingStateStopping captures enum value "stopping"
	VolumeRebalancingStateStopping string = "stopping"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// idle
	// END DEBUGGING
	// VolumeRebalancingStateIdle captures enum value "idle"
	VolumeRebalancingStateIdle string = "idle"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// scanning
	// END DEBUGGING
	// VolumeRebalancingStateScanning captures enum value "scanning"
	VolumeRebalancingStateScanning string = "scanning"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// rebalancing_source
	// END DEBUGGING
	// VolumeRebalancingStateRebalancingSource captures enum value "rebalancing_source"
	VolumeRebalancingStateRebalancingSource string = "rebalancing_source"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// rebalancing_dest
	// END DEBUGGING
	// VolumeRebalancingStateRebalancingDest captures enum value "rebalancing_dest"
	VolumeRebalancingStateRebalancingDest string = "rebalancing_dest"

	// BEGIN DEBUGGING
	// volume_rebalancing
	// VolumeRebalancing
	// state
	// State
	// unknown
	// END DEBUGGING
	// VolumeRebalancingStateUnknown captures enum value "unknown"
	VolumeRebalancingStateUnknown string = "unknown"
)

// prop value enum
func (m *VolumeRebalancing) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeRebalancingTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeRebalancing) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) validateStopTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StopTime) { // not required
		return nil
	}

	if err := validate.FormatOf("stop_time", "body", "date-time", m.StopTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) validateVolumeRebalancingInlineNotices(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeRebalancingInlineNotices) { // not required
		return nil
	}

	for i := 0; i < len(m.VolumeRebalancingInlineNotices); i++ {
		if swag.IsZero(m.VolumeRebalancingInlineNotices[i]) { // not required
			continue
		}

		if m.VolumeRebalancingInlineNotices[i] != nil {
			if err := m.VolumeRebalancingInlineNotices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this volume rebalancing based on the context it is used
func (m *VolumeRebalancing) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataMoved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEngine(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImbalancePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImbalanceSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxConstituentImbalancePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRuntime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedForImbalance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeRebalancingInlineNotices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancing) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateDataMoved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_moved", "body", m.DataMoved); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateEngine(ctx context.Context, formats strfmt.Registry) error {

	if m.Engine != nil {
		if err := m.Engine.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateImbalancePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "imbalance_percent", "body", m.ImbalancePercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateImbalanceSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "imbalance_size", "body", m.ImbalanceSize); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateMaxConstituentImbalancePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "max_constituent_imbalance_percent", "body", m.MaxConstituentImbalancePercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateRuntime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "runtime", "body", m.Runtime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateStopTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "stop_time", "body", m.StopTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateTargetUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target_used", "body", m.TargetUsed); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateUsedForImbalance(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used_for_imbalance", "body", m.UsedForImbalance); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancing) contextValidateVolumeRebalancingInlineNotices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notices", "body", []*Error(m.VolumeRebalancingInlineNotices)); err != nil {
		return err
	}

	for i := 0; i < len(m.VolumeRebalancingInlineNotices); i++ {

		if m.VolumeRebalancingInlineNotices[i] != nil {
			if err := m.VolumeRebalancingInlineNotices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("notices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancing) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancing) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancing
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineEngine Each constituent has one rebalancing engine that co-ordinates scanning constituents for free space and files to move, as well as moving files between constituents. The engine properties must be explicitly requested, are meant for helping diagnose why the volume rebalancer is making decisions.
//
// swagger:model volume_rebalancing_inline_engine
type VolumeRebalancingInlineEngine struct {

	// movement
	Movement *VolumeRebalancingInlineEngineInlineMovement `json:"movement,omitempty"`

	// scanner
	Scanner *VolumeRebalancingInlineEngineInlineScanner `json:"scanner,omitempty"`
}

// Validate validates this volume rebalancing inline engine
func (m *VolumeRebalancingInlineEngine) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngine) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(m.Movement) { // not required
		return nil
	}

	if m.Movement != nil {
		if err := m.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancingInlineEngine) validateScanner(formats strfmt.Registry) error {
	if swag.IsZero(m.Scanner) { // not required
		return nil
	}

	if m.Scanner != nil {
		if err := m.Scanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume rebalancing inline engine based on the context it is used
func (m *VolumeRebalancingInlineEngine) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngine) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if m.Movement != nil {
		if err := m.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancingInlineEngine) contextValidateScanner(ctx context.Context, formats strfmt.Registry) error {

	if m.Scanner != nil {
		if err := m.Scanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "scanner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngine) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngine) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineEngine
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineEngineInlineMovement Properties on this constituent related to file movement.
//
// swagger:model volume_rebalancing_inline_engine_inline_movement
type VolumeRebalancingInlineEngineInlineMovement struct {

	// Number of file moves started on this constituent.
	// Read Only: true
	FileMovesStarted *int64 `json:"file_moves_started,omitempty"`

	// last error
	LastError *VolumeRebalancingInlineEngineInlineMovementInlineLastError `json:"last_error,omitempty"`

	// Start time of the most recent file move on the constituent.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	MostRecentStartTime *strfmt.DateTime `json:"most_recent_start_time,omitempty"`
}

// Validate validates this volume rebalancing inline engine inline movement
func (m *VolumeRebalancingInlineEngineInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLastError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMostRecentStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovement) validateLastError(formats strfmt.Registry) error {
	if swag.IsZero(m.LastError) { // not required
		return nil
	}

	if m.LastError != nil {
		if err := m.LastError.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "movement" + "." + "last_error")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovement) validateMostRecentStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.MostRecentStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("engine"+"."+"movement"+"."+"most_recent_start_time", "body", "date-time", m.MostRecentStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume rebalancing inline engine inline movement based on the context it is used
func (m *VolumeRebalancingInlineEngineInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFileMovesStarted(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMostRecentStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovement) contextValidateFileMovesStarted(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"movement"+"."+"file_moves_started", "body", m.FileMovesStarted); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovement) contextValidateLastError(ctx context.Context, formats strfmt.Registry) error {

	if m.LastError != nil {
		if err := m.LastError.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "movement" + "." + "last_error")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovement) contextValidateMostRecentStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"movement"+"."+"most_recent_start_time", "body", m.MostRecentStartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineMovement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineMovement) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineEngineInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineEngineInlineMovementInlineLastError Error information for the last failed file move on the constituent.
//
// swagger:model volume_rebalancing_inline_engine_inline_movement_inline_last_error
type VolumeRebalancingInlineEngineInlineMovementInlineLastError struct {

	// Error code of the last file move error on the constituent.
	// Read Only: true
	Code *int64 `json:"code,omitempty"`

	// DSID of the destination constituent of the last file move error on the constituent.
	// Read Only: true
	Destination *int64 `json:"destination,omitempty"`

	// File ID of the last file move error on the constituent.
	// Read Only: true
	FileID *int64 `json:"file_id,omitempty"`

	// Time of the last file move error on the constituent.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this volume rebalancing inline engine inline movement inline last error
func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("engine"+"."+"movement"+"."+"last_error"+"."+"time", "body", "date-time", m.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume rebalancing inline engine inline movement inline last error based on the context it is used
func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"movement"+"."+"last_error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"movement"+"."+"last_error"+"."+"destination", "body", m.Destination); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) contextValidateFileID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"movement"+"."+"last_error"+"."+"file_id", "body", m.FileID); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"movement"+"."+"last_error"+"."+"time", "body", m.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineMovementInlineLastError) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineEngineInlineMovementInlineLastError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineEngineInlineScanner Properties related to determining which files to move and where to move them to.
//
// swagger:model volume_rebalancing_inline_engine_inline_scanner
type VolumeRebalancingInlineEngineInlineScanner struct {

	// Number of blocks scanned on this constituent.
	// Read Only: true
	BlocksScanned *int64 `json:"blocks_scanned,omitempty"`

	// blocks skipped
	BlocksSkipped *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped `json:"blocks_skipped,omitempty"`

	// Number of files scanned on this constituent.
	// Read Only: true
	FilesScanned *int64 `json:"files_scanned,omitempty"`

	// files skipped
	FilesSkipped *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped `json:"files_skipped,omitempty"`
}

// Validate validates this volume rebalancing inline engine inline scanner
func (m *VolumeRebalancingInlineEngineInlineScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlocksSkipped(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilesSkipped(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScanner) validateBlocksSkipped(formats strfmt.Registry) error {
	if swag.IsZero(m.BlocksSkipped) { // not required
		return nil
	}

	if m.BlocksSkipped != nil {
		if err := m.BlocksSkipped.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "scanner" + "." + "blocks_skipped")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScanner) validateFilesSkipped(formats strfmt.Registry) error {
	if swag.IsZero(m.FilesSkipped) { // not required
		return nil
	}

	if m.FilesSkipped != nil {
		if err := m.FilesSkipped.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "scanner" + "." + "files_skipped")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume rebalancing inline engine inline scanner based on the context it is used
func (m *VolumeRebalancingInlineEngineInlineScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlocksScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlocksSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesScanned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScanner) contextValidateBlocksScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_scanned", "body", m.BlocksScanned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScanner) contextValidateBlocksSkipped(ctx context.Context, formats strfmt.Registry) error {

	if m.BlocksSkipped != nil {
		if err := m.BlocksSkipped.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "scanner" + "." + "blocks_skipped")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScanner) contextValidateFilesScanned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_scanned", "body", m.FilesScanned); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScanner) contextValidateFilesSkipped(ctx context.Context, formats strfmt.Registry) error {

	if m.FilesSkipped != nil {
		if err := m.FilesSkipped.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("engine" + "." + "scanner" + "." + "files_skipped")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineScanner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineScanner) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineEngineInlineScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped Number of blocks skipped by the scanner on this constituent due to various reasons.
//
// swagger:model volume_rebalancing_inline_engine_inline_scanner_inline_blocks_skipped
type VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped struct {

	// Number of blocks skipped by the scanner on this constituent because storage efficiency lost, in blocks, would be too high.
	// Read Only: true
	EfficiencyBlocks *int64 `json:"efficiency_blocks,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because storage efficiency lost, in percent, would be too high.
	// Read Only: true
	EfficiencyPercent *int64 `json:"efficiency_percent,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because fast truncate is currently running on files.
	// Read Only: true
	FastTruncate *int64 `json:"fast_truncate,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files with invalid space footprints.
	// Read Only: true
	FootprintInvalid *int64 `json:"footprint_invalid,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files in snapshots.
	// Read Only: true
	InSnapshot *int64 `json:"in_snapshot,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of incompatible files.
	// Read Only: true
	Incompatible *int64 `json:"incompatible,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of metadata files.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of on demand destination files.
	// Read Only: true
	OnDemandDestination *int64 `json:"on_demand_destination,omitempty"`

	// Number of blocks skipped by the scanner on this constituent for all other reasons.
	// Read Only: true
	Other *int64 `json:"other,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of remote caches.
	// Read Only: true
	RemoteCache *int64 `json:"remote_cache,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files that are larger than rebalancing.max_file_size.
	// Read Only: true
	TooLarge *int64 `json:"too_large,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files that are smaller than rebalancing.min_file_size.
	// Read Only: true
	TooSmall *int64 `json:"too_small,omitempty"`

	// Number of blocks skipped by the scanner on this constituent because of files fenced for write operations.
	// Read Only: true
	WriteFenced *int64 `json:"write_fenced,omitempty"`
}

// Validate validates this volume rebalancing inline engine inline scanner inline blocks skipped
func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume rebalancing inline engine inline scanner inline blocks skipped based on the context it is used
func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFastTruncate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprintInvalid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIncompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnDemandDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooLarge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooSmall(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateEfficiencyBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"efficiency_blocks", "body", m.EfficiencyBlocks); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateEfficiencyPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"efficiency_percent", "body", m.EfficiencyPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateFastTruncate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"fast_truncate", "body", m.FastTruncate); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateFootprintInvalid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"footprint_invalid", "body", m.FootprintInvalid); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateInSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"in_snapshot", "body", m.InSnapshot); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateIncompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"incompatible", "body", m.Incompatible); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"metadata", "body", m.Metadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateOnDemandDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"on_demand_destination", "body", m.OnDemandDestination); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"other", "body", m.Other); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateRemoteCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"remote_cache", "body", m.RemoteCache); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateTooLarge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"too_large", "body", m.TooLarge); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateTooSmall(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"too_small", "body", m.TooSmall); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) contextValidateWriteFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"blocks_skipped"+"."+"write_fenced", "body", m.WriteFenced); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineEngineInlineScannerInlineBlocksSkipped
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped Number of files skipped by the scanner on this constituent due to various reasons.
//
// swagger:model volume_rebalancing_inline_engine_inline_scanner_inline_files_skipped
type VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped struct {

	// Number of files skipped by the scanner on this constituent because storage efficiency lost, in blocks, would be too high.
	// Read Only: true
	EfficiencyBlocks *int64 `json:"efficiency_blocks,omitempty"`

	// Number of files skipped by the scanner on this constituent because storage efficiency lost, in percent, would be too high.
	// Read Only: true
	EfficiencyPercent *int64 `json:"efficiency_percent,omitempty"`

	// Number of files skipped by the scanner on this constituent because fast truncate is currently running on the file.
	// Read Only: true
	FastTruncate *int64 `json:"fast_truncate,omitempty"`

	// Number of files skipped by the scanner on this constituent because their space footprints are invalid.
	// Read Only: true
	FootprintInvalid *int64 `json:"footprint_invalid,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are trapped in snapshots.
	// Read Only: true
	InSnapshot *int64 `json:"in_snapshot,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are incompatible.
	// Read Only: true
	Incompatible *int64 `json:"incompatible,omitempty"`

	// Number of files skipped by the scanner on this constituent because they metadata files.
	// Read Only: true
	Metadata *int64 `json:"metadata,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are on demand destinations.
	// Read Only: true
	OnDemandDestination *int64 `json:"on_demand_destination,omitempty"`

	// Number of files skipped by the scanner on this constituent for all other reasons.
	// Read Only: true
	Other *int64 `json:"other,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are remote caches.
	// Read Only: true
	RemoteCache *int64 `json:"remote_cache,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are larger than rebalancing.max_file_size.
	// Read Only: true
	TooLarge *int64 `json:"too_large,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are smaller than rebalancing.min_file_size.
	// Read Only: true
	TooSmall *int64 `json:"too_small,omitempty"`

	// Number of files skipped by the scanner on this constituent because they are fenced for write operations.
	// Read Only: true
	WriteFenced *int64 `json:"write_fenced,omitempty"`
}

// Validate validates this volume rebalancing inline engine inline scanner inline files skipped
func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume rebalancing inline engine inline scanner inline files skipped based on the context it is used
func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyBlocks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFastTruncate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprintInvalid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIncompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnDemandDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooLarge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTooSmall(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateEfficiencyBlocks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"efficiency_blocks", "body", m.EfficiencyBlocks); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateEfficiencyPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"efficiency_percent", "body", m.EfficiencyPercent); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateFastTruncate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"fast_truncate", "body", m.FastTruncate); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateFootprintInvalid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"footprint_invalid", "body", m.FootprintInvalid); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateInSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"in_snapshot", "body", m.InSnapshot); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateIncompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"incompatible", "body", m.Incompatible); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"metadata", "body", m.Metadata); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateOnDemandDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"on_demand_destination", "body", m.OnDemandDestination); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"other", "body", m.Other); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateRemoteCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"remote_cache", "body", m.RemoteCache); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateTooLarge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"too_large", "body", m.TooLarge); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateTooSmall(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"too_small", "body", m.TooSmall); err != nil {
		return err
	}

	return nil
}

func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) contextValidateWriteFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "engine"+"."+"scanner"+"."+"files_skipped"+"."+"write_fenced", "body", m.WriteFenced); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineEngineInlineScannerInlineFilesSkipped
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeRebalancingInlineLinks volume rebalancing inline links
//
// swagger:model volume_rebalancing_inline__links
type VolumeRebalancingInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this volume rebalancing inline links
func (m *VolumeRebalancingInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume rebalancing inline links based on the context it is used
func (m *VolumeRebalancingInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeRebalancingInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeRebalancingInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeRebalancingInlineLinks) UnmarshalBinary(b []byte) error {
	var res VolumeRebalancingInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
