// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumeSnaplock volume snaplock
//
// swagger:model volume_snaplock
type VolumeSnaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Example: false
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string "none".
	// Example: P30M
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// This is the volume compliance clock time which is used to manage the SnapLock objects in the volume.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`

	// Expiry time of the volume. For volumes with an infinite, indefinite or unspecified SnapLock expiry time, "9999-12-31T23:59:59" is used to denote the time.
	// Example: Wed Sep  5 11:02:42 GMT 2018
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates if this volume has been configured as SnapLock audit log volume for the SVM .
	// Example: true
	// Read Only: true
	IsAuditLog *bool `json:"is_audit_log,omitempty"`

	// Litigation count indicates the number of active legal-holds on the volume.
	// Example: 10
	// Read Only: true
	LitigationCount *int64 `json:"litigation_count,omitempty"`

	// Specifies the privileged-delete attribute of a SnapLock volume. On a SnapLock Enterprise (SLE) volume, a designated privileged user can selectively delete files irrespective of the retention time of the file. SLE volumes can have privileged delete as disabled, enabled or permanently_disabled and for SnapLock Compliance (SLC) volumes it is always permanently_disabled.
	// Example: enabled
	// Enum: ["disabled","enabled","permanently_disabled"]
	PrivilegedDelete *string `json:"privileged_delete,omitempty"`

	// retention
	Retention *VolumeSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the volume. <br>compliance &dash; A SnapLock Compliance(SLC) volume provides the highest level of WORM protection and an administrator cannot destroy a SLC volume if it contains unexpired WORM files. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise(SLE) volume.<br> non_snaplock &dash; Indicates the volume is non-snaplock.
	// Example: enterprise
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`

	// Indicates the number of files with an unspecified retention time in the volume.
	// Example: 10
	// Read Only: true
	UnspecifiedRetentionFileCount *int64 `json:"unspecified_retention_file_count,omitempty"`
}

// Validate validates this volume snaplock
func (m *VolumeSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrivilegedDelete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("compliance_clock_time", "body", "date-time", m.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumeSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var volumeSnaplockTypePrivilegedDeletePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","permanently_disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeSnaplockTypePrivilegedDeletePropEnum = append(volumeSnaplockTypePrivilegedDeletePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_snaplock
	// VolumeSnaplock
	// privileged_delete
	// PrivilegedDelete
	// disabled
	// END DEBUGGING
	// VolumeSnaplockPrivilegedDeleteDisabled captures enum value "disabled"
	VolumeSnaplockPrivilegedDeleteDisabled string = "disabled"

	// BEGIN DEBUGGING
	// volume_snaplock
	// VolumeSnaplock
	// privileged_delete
	// PrivilegedDelete
	// enabled
	// END DEBUGGING
	// VolumeSnaplockPrivilegedDeleteEnabled captures enum value "enabled"
	VolumeSnaplockPrivilegedDeleteEnabled string = "enabled"

	// BEGIN DEBUGGING
	// volume_snaplock
	// VolumeSnaplock
	// privileged_delete
	// PrivilegedDelete
	// permanently_disabled
	// END DEBUGGING
	// VolumeSnaplockPrivilegedDeletePermanentlyDisabled captures enum value "permanently_disabled"
	VolumeSnaplockPrivilegedDeletePermanentlyDisabled string = "permanently_disabled"
)

// prop value enum
func (m *VolumeSnaplock) validatePrivilegedDeleteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeSnaplockTypePrivilegedDeletePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeSnaplock) validatePrivilegedDelete(formats strfmt.Registry) error {
	if swag.IsZero(m.PrivilegedDelete) { // not required
		return nil
	}

	// value enum
	if err := m.validatePrivilegedDeleteEnum("privileged_delete", "body", *m.PrivilegedDelete); err != nil {
		return err
	}

	return nil
}

func (m *VolumeSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

var volumeSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeSnaplockTypeTypePropEnum = append(volumeSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_snaplock
	// VolumeSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// VolumeSnaplockTypeCompliance captures enum value "compliance"
	VolumeSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// volume_snaplock
	// VolumeSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// VolumeSnaplockTypeEnterprise captures enum value "enterprise"
	VolumeSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// volume_snaplock
	// VolumeSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// VolumeSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	VolumeSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *VolumeSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume snaplock based on the context it is used
func (m *VolumeSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComplianceClockTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsAuditLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLitigationCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnspecifiedRetentionFileCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeSnaplock) contextValidateComplianceClockTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compliance_clock_time", "body", m.ComplianceClockTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeSnaplock) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "expiry_time", "body", m.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeSnaplock) contextValidateIsAuditLog(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_audit_log", "body", m.IsAuditLog); err != nil {
		return err
	}

	return nil
}

func (m *VolumeSnaplock) contextValidateLitigationCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "litigation_count", "body", m.LitigationCount); err != nil {
		return err
	}

	return nil
}

func (m *VolumeSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeSnaplock) contextValidateUnspecifiedRetentionFileCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "unspecified_retention_file_count", "body", m.UnspecifiedRetentionFileCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeSnaplock) UnmarshalBinary(b []byte) error {
	var res VolumeSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeSnaplockInlineRetention volume snaplock inline retention
//
// swagger:model volume_snaplock_inline_retention
type VolumeSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
	// Example: P30Y
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this volume snaplock inline retention
func (m *VolumeSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume snaplock inline retention based on context it is used
func (m *VolumeSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res VolumeSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
