// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumeStatisticsReference These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model volume_statistics_reference
type VolumeStatisticsReference struct {

	// cifs ops raw
	CifsOpsRaw *VolumeStatisticsReferenceInlineCifsOpsRaw `json:"cifs_ops_raw,omitempty"`

	// cloud
	Cloud *VolumeStatisticsReferenceInlineCloud `json:"cloud,omitempty"`

	// flexcache raw
	FlexcacheRaw *VolumeStatisticsReferenceInlineFlexcacheRaw `json:"flexcache_raw,omitempty"`

	// iops raw
	IopsRaw *VolumeStatisticsReferenceInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *VolumeStatisticsReferenceInlineLatencyRaw `json:"latency_raw,omitempty"`

	// nfs ops raw
	NfsOpsRaw *VolumeStatisticsReferenceInlineNfsOpsRaw `json:"nfs_ops_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *VolumeStatisticsReferenceInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume statistics reference
func (m *VolumeStatisticsReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifsOpsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloud(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcacheRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNfsOpsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReference) validateCifsOpsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsOpsRaw) { // not required
		return nil
	}

	if m.CifsOpsRaw != nil {
		if err := m.CifsOpsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) validateCloud(formats strfmt.Registry) error {
	if swag.IsZero(m.Cloud) { // not required
		return nil
	}

	if m.Cloud != nil {
		if err := m.Cloud.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) validateFlexcacheRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexcacheRaw) { // not required
		return nil
	}

	if m.FlexcacheRaw != nil {
		if err := m.FlexcacheRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) validateNfsOpsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.NfsOpsRaw) { // not required
		return nil
	}

	if m.NfsOpsRaw != nil {
		if err := m.NfsOpsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw")
			}
			return err
		}
	}

	return nil
}

var volumeStatisticsReferenceTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeStatisticsReferenceTypeStatusPropEnum = append(volumeStatisticsReferenceTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusOk captures enum value "ok"
	VolumeStatisticsReferenceStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusError captures enum value "error"
	VolumeStatisticsReferenceStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusPartialNoData captures enum value "partial_no_data"
	VolumeStatisticsReferenceStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeStatisticsReferenceStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeStatisticsReferenceStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusPartialOtherError captures enum value "partial_other_error"
	VolumeStatisticsReferenceStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusNegativeDelta captures enum value "negative_delta"
	VolumeStatisticsReferenceStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusBackfilledData captures enum value "backfilled_data"
	VolumeStatisticsReferenceStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeStatisticsReferenceStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_statistics_reference
	// VolumeStatisticsReference
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeStatisticsReferenceStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeStatisticsReferenceStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeStatisticsReference) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeStatisticsReferenceTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeStatisticsReference) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReference) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume statistics reference based on the context it is used
func (m *VolumeStatisticsReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifsOpsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcacheRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNfsOpsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReference) contextValidateCifsOpsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.CifsOpsRaw != nil {
		if err := m.CifsOpsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateCloud(ctx context.Context, formats strfmt.Registry) error {

	if m.Cloud != nil {
		if err := m.Cloud.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateFlexcacheRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.FlexcacheRaw != nil {
		if err := m.FlexcacheRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateNfsOpsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.NfsOpsRaw != nil {
		if err := m.NfsOpsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReference) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReference) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRaw Raw data component performance values for CIFS operations on this volume, including number of operations and raw latency, in microseconds for each operation. The values are cumulative and increase while the volume is online.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw
type VolumeStatisticsReferenceInlineCifsOpsRaw struct {

	// access
	Access *VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess `json:"access,omitempty"`

	// audit
	Audit *VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit `json:"audit,omitempty"`

	// create
	Create *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *VolumeStatisticsReferenceInlineCifsOpsRawInlineLink `json:"link,omitempty"`

	// lock
	Lock *VolumeStatisticsReferenceInlineCifsOpsRawInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup `json:"lookup,omitempty"`

	// open
	Open *VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen `json:"open,omitempty"`

	// read
	Read *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *VolumeStatisticsReferenceInlineCifsOpsRawInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch `json:"watch,omitempty"`

	// write
	Write *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw
func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(m.Audit) { // not required
		return nil
	}

	if m.Audit != nil {
		if err := m.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(m.Create) { // not required
		return nil
	}

	if m.Create != nil {
		if err := m.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Getattr) { // not required
		return nil
	}

	if m.Getattr != nil {
		if err := m.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(m.Link) { // not required
		return nil
	}

	if m.Link != nil {
		if err := m.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(m.Lock) { // not required
		return nil
	}

	if m.Lock != nil {
		if err := m.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(m.Lookup) { // not required
		return nil
	}

	if m.Lookup != nil {
		if err := m.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(m.Open) { // not required
		return nil
	}

	if m.Open != nil {
		if err := m.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(m.Read) { // not required
		return nil
	}

	if m.Read != nil {
		if err := m.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(m.Readdir) { // not required
		return nil
	}

	if m.Readdir != nil {
		if err := m.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Readlink) { // not required
		return nil
	}

	if m.Readlink != nil {
		if err := m.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(m.Rename) { // not required
		return nil
	}

	if m.Rename != nil {
		if err := m.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Setattr) { // not required
		return nil
	}

	if m.Setattr != nil {
		if err := m.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Unlink) { // not required
		return nil
	}

	if m.Unlink != nil {
		if err := m.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Watch) { // not required
		return nil
	}

	if m.Watch != nil {
		if err := m.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(m.Write) { // not required
		return nil
	}

	if m.Write != nil {
		if err := m.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume statistics reference inline cifs ops raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {
		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if m.Audit != nil {
		if err := m.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if m.Create != nil {
		if err := m.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Getattr != nil {
		if err := m.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if m.Link != nil {
		if err := m.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if m.Lock != nil {
		if err := m.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if m.Lookup != nil {
		if err := m.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if m.Open != nil {
		if err := m.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if m.Read != nil {
		if err := m.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if m.Readdir != nil {
		if err := m.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Readlink != nil {
		if err := m.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if m.Rename != nil {
		if err := m.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Setattr != nil {
		if err := m.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Unlink != nil {
		if err := m.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Watch != nil {
		if err := m.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if m.Write != nil {
		if err := m.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess Raw count and latency data for access operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_access
type VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline access
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline access based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_audit
type VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline audit
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline audit based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate Raw count and latency data for create operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_create
type VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate struct {

	// dir
	Dir *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline create
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(m.Dir) { // not required
		return nil
	}

	if m.Dir != nil {
		if err := m.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(m.Other) { // not required
		return nil
	}

	if m.Other != nil {
		if err := m.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Symlink) { // not required
		return nil
	}

	if m.Symlink != nil {
		if err := m.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume statistics reference inline cifs ops raw inline create based on the context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if m.Dir != nil {
		if err := m.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if m.Other != nil {
		if err := m.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Symlink != nil {
		if err := m.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir Raw count and latency data for directory-create operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_create_inline_dir
type VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline create inline dir
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline create inline dir based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile Raw count and latency data for file-create operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_create_inline_file
type VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline create inline file
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline create inline file based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_create_inline_other
type VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline create inline other
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline create inline other based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_create_inline_symlink
type VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline create inline symlink
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline create inline symlink based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr Raw count and latency data for getattr operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_getattr
type VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline getattr
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline getattr based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineLink Raw count and latency data for link operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_link
type VolumeStatisticsReferenceInlineCifsOpsRawInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline link
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline link based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineLock Raw count and latency data for lock operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_lock
type VolumeStatisticsReferenceInlineCifsOpsRawInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline lock
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline lock based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup Raw count and latency data for lookup operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_lookup
type VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline lookup
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline lookup based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen Raw count and latency data for open operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_open
type VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline open
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline open based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_read
type VolumeStatisticsReferenceInlineCifsOpsRawInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline read
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline cifs ops raw inline read based on the context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"read"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"read"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir Raw count and latency data for readdir operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_readdir
type VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline readdir
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline readdir based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink Raw count and latency data for readlink operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_readlink
type VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline readlink
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline readlink based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineRename Raw count and latency data for rename operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_rename
type VolumeStatisticsReferenceInlineCifsOpsRawInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline rename
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline rename based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRename) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr Raw count and latency data for setattr operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_setattr
type VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline setattr
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline setattr based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink Raw count and latency data for unlink operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_unlink
type VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline unlink
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline unlink based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_watch
type VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline watch
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline cifs ops raw inline watch based on context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_statistics_reference_inline_cifs_ops_raw_inline_write
type VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume statistics reference inline cifs ops raw inline write
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline cifs ops raw inline write based on the context it is used
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"write"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"write"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "cifs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCifsOpsRawInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCloud These are raw performance numbers (IOPS and latency) for the cloud store. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster. These numbers are relevant only for volumes hosted on FabricPools.
//
// swagger:model volume_statistics_reference_inline_cloud
type VolumeStatisticsReferenceInlineCloud struct {

	// iops raw
	IopsRaw *VolumeStatisticsReferenceInlineCloudInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *VolumeStatisticsReferenceInlineCloudInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume statistics reference inline cloud
func (m *VolumeStatisticsReferenceInlineCloud) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var volumeStatisticsReferenceInlineCloudTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeStatisticsReferenceInlineCloudTypeStatusPropEnum = append(volumeStatisticsReferenceInlineCloudTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusOk captures enum value "ok"
	VolumeStatisticsReferenceInlineCloudStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusError captures enum value "error"
	VolumeStatisticsReferenceInlineCloudStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusPartialNoData captures enum value "partial_no_data"
	VolumeStatisticsReferenceInlineCloudStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeStatisticsReferenceInlineCloudStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeStatisticsReferenceInlineCloudStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusPartialOtherError captures enum value "partial_other_error"
	VolumeStatisticsReferenceInlineCloudStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusNegativeDelta captures enum value "negative_delta"
	VolumeStatisticsReferenceInlineCloudStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusBackfilledData captures enum value "backfilled_data"
	VolumeStatisticsReferenceInlineCloudStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeStatisticsReferenceInlineCloudStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_cloud
	// VolumeStatisticsReferenceInlineCloud
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineCloudStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeStatisticsReferenceInlineCloudStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeStatisticsReferenceInlineCloud) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeStatisticsReferenceInlineCloudTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("cloud"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("cloud"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume statistics reference inline cloud based on the context it is used
func (m *VolumeStatisticsReferenceInlineCloud) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineCloud) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCloud) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCloud) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCloud
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCloudInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model volume_statistics_reference_inline_cloud_inline_iops_raw
type VolumeStatisticsReferenceInlineCloudInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline cloud inline iops raw
func (m *VolumeStatisticsReferenceInlineCloudInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline cloud inline iops raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineCloudInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCloudInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCloudInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCloudInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineCloudInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model volume_statistics_reference_inline_cloud_inline_latency_raw
type VolumeStatisticsReferenceInlineCloudInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline cloud inline latency raw
func (m *VolumeStatisticsReferenceInlineCloudInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline cloud inline latency raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineCloudInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCloudInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineCloudInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineCloudInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineFlexcacheRaw Performance numbers for FlexCache used to measure cache effectiveness.
//
// swagger:model volume_statistics_reference_inline_flexcache_raw
type VolumeStatisticsReferenceInlineFlexcacheRaw struct {

	// Blocks retrieved from origin in case of a cache miss. This can be divided by the raw client_requested_blocks and multiplied by 100 to calculate the cache miss percentage.
	// Example: 10
	CacheMissBlocks *int64 `json:"cache_miss_blocks,omitempty"`

	// Total blocks requested by the client.
	// Example: 500
	ClientRequestedBlocks *int64 `json:"client_requested_blocks,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this volume statistics reference inline flexcache raw
func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var volumeStatisticsReferenceInlineFlexcacheRawTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		volumeStatisticsReferenceInlineFlexcacheRawTypeStatusPropEnum = append(volumeStatisticsReferenceInlineFlexcacheRawTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// ok
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusOk captures enum value "ok"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusOk string = "ok"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// error
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusError captures enum value "error"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusError string = "error"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialNoData captures enum value "partial_no_data"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialNoUUID captures enum value "partial_no_uuid"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialNoResponse captures enum value "partial_no_response"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialOtherError captures enum value "partial_other_error"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusNegativeDelta captures enum value "negative_delta"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusBackfilledData captures enum value "backfilled_data"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// volume_statistics_reference_inline_flexcache_raw
	// VolumeStatisticsReferenceInlineFlexcacheRaw
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// VolumeStatisticsReferenceInlineFlexcacheRawStatusInconsistentOldData captures enum value "inconsistent_old_data"
	VolumeStatisticsReferenceInlineFlexcacheRawStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, volumeStatisticsReferenceInlineFlexcacheRawTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("flexcache_raw"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("flexcache_raw"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this volume statistics reference inline flexcache raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexcache_raw"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "flexcache_raw"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineFlexcacheRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineFlexcacheRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model volume_statistics_reference_inline_iops_raw
type VolumeStatisticsReferenceInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline iops raw
func (m *VolumeStatisticsReferenceInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline iops raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model volume_statistics_reference_inline_latency_raw
type VolumeStatisticsReferenceInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline latency raw
func (m *VolumeStatisticsReferenceInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline latency raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRaw Raw data component performance values for NFS operations on this volume, including number of operations and raw latency, in microseconds for each operation. The values are cumulative and increase while the volume is online.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw
type VolumeStatisticsReferenceInlineNfsOpsRaw struct {

	// access
	Access *VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess `json:"access,omitempty"`

	// audit
	Audit *VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit `json:"audit,omitempty"`

	// create
	Create *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate `json:"create,omitempty"`

	// getattr
	Getattr *VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr `json:"getattr,omitempty"`

	// link
	Link *VolumeStatisticsReferenceInlineNfsOpsRawInlineLink `json:"link,omitempty"`

	// lock
	Lock *VolumeStatisticsReferenceInlineNfsOpsRawInlineLock `json:"lock,omitempty"`

	// lookup
	Lookup *VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup `json:"lookup,omitempty"`

	// open
	Open *VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen `json:"open,omitempty"`

	// read
	Read *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead `json:"read,omitempty"`

	// readdir
	Readdir *VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir `json:"readdir,omitempty"`

	// readlink
	Readlink *VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink `json:"readlink,omitempty"`

	// rename
	Rename *VolumeStatisticsReferenceInlineNfsOpsRawInlineRename `json:"rename,omitempty"`

	// setattr
	Setattr *VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr `json:"setattr,omitempty"`

	// unlink
	Unlink *VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink `json:"unlink,omitempty"`

	// watch
	Watch *VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch `json:"watch,omitempty"`

	// write
	Write *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw
func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAudit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLookup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpen(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRead(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReaddir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReadlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRename(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetattr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWrite(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateAudit(formats strfmt.Registry) error {
	if swag.IsZero(m.Audit) { // not required
		return nil
	}

	if m.Audit != nil {
		if err := m.Audit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateCreate(formats strfmt.Registry) error {
	if swag.IsZero(m.Create) { // not required
		return nil
	}

	if m.Create != nil {
		if err := m.Create.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateGetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Getattr) { // not required
		return nil
	}

	if m.Getattr != nil {
		if err := m.Getattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(m.Link) { // not required
		return nil
	}

	if m.Link != nil {
		if err := m.Link.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateLock(formats strfmt.Registry) error {
	if swag.IsZero(m.Lock) { // not required
		return nil
	}

	if m.Lock != nil {
		if err := m.Lock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateLookup(formats strfmt.Registry) error {
	if swag.IsZero(m.Lookup) { // not required
		return nil
	}

	if m.Lookup != nil {
		if err := m.Lookup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateOpen(formats strfmt.Registry) error {
	if swag.IsZero(m.Open) { // not required
		return nil
	}

	if m.Open != nil {
		if err := m.Open.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateRead(formats strfmt.Registry) error {
	if swag.IsZero(m.Read) { // not required
		return nil
	}

	if m.Read != nil {
		if err := m.Read.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateReaddir(formats strfmt.Registry) error {
	if swag.IsZero(m.Readdir) { // not required
		return nil
	}

	if m.Readdir != nil {
		if err := m.Readdir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateReadlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Readlink) { // not required
		return nil
	}

	if m.Readlink != nil {
		if err := m.Readlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateRename(formats strfmt.Registry) error {
	if swag.IsZero(m.Rename) { // not required
		return nil
	}

	if m.Rename != nil {
		if err := m.Rename.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateSetattr(formats strfmt.Registry) error {
	if swag.IsZero(m.Setattr) { // not required
		return nil
	}

	if m.Setattr != nil {
		if err := m.Setattr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateUnlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Unlink) { // not required
		return nil
	}

	if m.Unlink != nil {
		if err := m.Unlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateWatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Watch) { // not required
		return nil
	}

	if m.Watch != nil {
		if err := m.Watch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) validateWrite(formats strfmt.Registry) error {
	if swag.IsZero(m.Write) { // not required
		return nil
	}

	if m.Write != nil {
		if err := m.Write.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume statistics reference inline nfs ops raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAudit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLookup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpen(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRead(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReaddir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRename(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetattr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWrite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {
		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateAudit(ctx context.Context, formats strfmt.Registry) error {

	if m.Audit != nil {
		if err := m.Audit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "audit")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateCreate(ctx context.Context, formats strfmt.Registry) error {

	if m.Create != nil {
		if err := m.Create.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateGetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Getattr != nil {
		if err := m.Getattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "getattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateLink(ctx context.Context, formats strfmt.Registry) error {

	if m.Link != nil {
		if err := m.Link.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "link")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateLock(ctx context.Context, formats strfmt.Registry) error {

	if m.Lock != nil {
		if err := m.Lock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "lock")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateLookup(ctx context.Context, formats strfmt.Registry) error {

	if m.Lookup != nil {
		if err := m.Lookup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "lookup")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateOpen(ctx context.Context, formats strfmt.Registry) error {

	if m.Open != nil {
		if err := m.Open.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "open")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateRead(ctx context.Context, formats strfmt.Registry) error {

	if m.Read != nil {
		if err := m.Read.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "read")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateReaddir(ctx context.Context, formats strfmt.Registry) error {

	if m.Readdir != nil {
		if err := m.Readdir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "readdir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateReadlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Readlink != nil {
		if err := m.Readlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "readlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateRename(ctx context.Context, formats strfmt.Registry) error {

	if m.Rename != nil {
		if err := m.Rename.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "rename")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateSetattr(ctx context.Context, formats strfmt.Registry) error {

	if m.Setattr != nil {
		if err := m.Setattr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "setattr")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateUnlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Unlink != nil {
		if err := m.Unlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "unlink")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateWatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Watch != nil {
		if err := m.Watch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "watch")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) contextValidateWrite(ctx context.Context, formats strfmt.Registry) error {

	if m.Write != nil {
		if err := m.Write.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "write")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess Raw count and latency data for access operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_access
type VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline access
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline access based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit Raw count and latency data for audit operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_audit
type VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline audit
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline audit based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineAudit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate Raw count and latency data for create operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_create
type VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate struct {

	// dir
	Dir *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir `json:"dir,omitempty"`

	// file
	File *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile `json:"file,omitempty"`

	// other
	Other *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther `json:"other,omitempty"`

	// symlink
	Symlink *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink `json:"symlink,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline create
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDir(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOther(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSymlink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) validateDir(formats strfmt.Registry) error {
	if swag.IsZero(m.Dir) { // not required
		return nil
	}

	if m.Dir != nil {
		if err := m.Dir.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) validateOther(formats strfmt.Registry) error {
	if swag.IsZero(m.Other) { // not required
		return nil
	}

	if m.Other != nil {
		if err := m.Other.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) validateSymlink(formats strfmt.Registry) error {
	if swag.IsZero(m.Symlink) { // not required
		return nil
	}

	if m.Symlink != nil {
		if err := m.Symlink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this volume statistics reference inline nfs ops raw inline create based on the context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDir(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOther(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSymlink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) contextValidateDir(ctx context.Context, formats strfmt.Registry) error {

	if m.Dir != nil {
		if err := m.Dir.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "dir")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "file")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) contextValidateOther(ctx context.Context, formats strfmt.Registry) error {

	if m.Other != nil {
		if err := m.Other.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "other")
			}
			return err
		}
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) contextValidateSymlink(ctx context.Context, formats strfmt.Registry) error {

	if m.Symlink != nil {
		if err := m.Symlink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs_ops_raw" + "." + "create" + "." + "symlink")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir Raw count and latency data for directory-create operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_create_inline_dir
type VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline create inline dir
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline create inline dir based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineDir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile Raw count and latency data for file-create operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_create_inline_file
type VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline create inline file
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline create inline file based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther Raw count and latency data for create operations on objects other than files, directories and symlinks.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_create_inline_other
type VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline create inline other
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline create inline other based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineOther
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink Raw count and latency data for symlink-create operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_create_inline_symlink
type VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline create inline symlink
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline create inline symlink based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineCreateInlineSymlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr Raw count and latency data for getattr operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_getattr
type VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline getattr
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline getattr based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineGetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineLink Raw count and latency data for link operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_link
type VolumeStatisticsReferenceInlineNfsOpsRawInlineLink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline link
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline link based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineLock Raw count and latency data for lock operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_lock
type VolumeStatisticsReferenceInlineNfsOpsRawInlineLock struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline lock
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline lock based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLock) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup Raw count and latency data for lookup operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_lookup
type VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline lookup
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline lookup based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineLookup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen Raw count and latency data for open operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_open
type VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline open
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline open based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineOpen
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineRead Raw count and latency data for read operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_read
type VolumeStatisticsReferenceInlineNfsOpsRawInlineRead struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline read
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline nfs ops raw inline read based on the context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"read"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"read"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"read"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"read"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRead) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineRead
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir Raw count and latency data for readdir operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_readdir
type VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline readdir
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline readdir based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineReaddir
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink Raw count and latency data for readlink operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_readlink
type VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline readlink
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline readlink based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineReadlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineRename Raw count and latency data for rename operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_rename
type VolumeStatisticsReferenceInlineNfsOpsRawInlineRename struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline rename
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRename) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline rename based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRename) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRename) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineRename) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineRename
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr Raw count and latency data for setattr operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_setattr
type VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline setattr
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline setattr based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineSetattr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink Raw count and latency data for unlink operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_unlink
type VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline unlink
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline unlink based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineUnlink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch Raw count and latency data for watch operations. These statistics are only applicable for CIFS protocol operations.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_watch
type VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	TotalTime *int64 `json:"total_time,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline watch
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume statistics reference inline nfs ops raw inline watch based on context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineWatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite Raw count and latency data for write operations, including histograms categorizing operations by size and latency.
//
// swagger:model volume_statistics_reference_inline_nfs_ops_raw_inline_write
type VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite struct {

	// Number of operations of the given type performed on this volume.
	// Example: 1000
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The raw data component latency in microseconds measured within ONTAP for all operations of the given type.
	// Example: 200
	// Read Only: true
	TotalTime *int64 `json:"total_time,omitempty"`

	// volume protocol latency histogram counts
	// Example: [0,0,0,0,0,15,35,100,200,200,300,500,500,500,1000,1000,800,500,500,300,200,50,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
	VolumeProtocolLatencyHistogramCounts []*int64 `json:"volume_protocol_latency_histogram_counts,omitempty"`

	// Labels for the latency histogram, ranging from <2us to >20s.
	// Example: ["\u003c2us","\u003c6us","\u003c10us","\u003c14us","\u003c20us","\u003c40us","\u003c60us","\u003c80us","\u003c100us","\u003c200us","\u003c400us","\u003c600us","\u003c800us","\u003c1ms","\u003c2ms","\u003c4ms","\u003c6ms","\u003c8ms","\u003c10ms","\u003c12ms","\u003c14ms","\u003c16ms","\u003c18ms","\u003c20ms","\u003c40ms","\u003c60ms","\u003c80ms","\u003c100ms","\u003c200ms","\u003c400ms","\u003c600ms","\u003c800ms","\u003c1s","\u003c2s","\u003c4s","\u003c6s","\u003c8s","\u003c10s","\u003c20s","\u003e20s"]
	VolumeProtocolLatencyHistogramLabels []*string `json:"volume_protocol_latency_histogram_labels,omitempty"`

	// volume protocol size histogram counts
	// Example: [2400,1055,1100,700,500,300,200,100,100,50,50,75,25,0,0]
	VolumeProtocolSizeHistogramCounts []*int64 `json:"volume_protocol_size_histogram_counts,omitempty"`

	// Labels for the size histogram, ranging from <4KB to >1024KB.
	// Example: ["\u003c    4KB","=    4KB","\u003c    8KB","=    8KB","\u003c   16KB","=   16KB","\u003c   32KB","=   32KB","\u003c   64KB","=   64KB","\u003c  256KB","=  256KB","\u003c 1024KB","= 1024KB","\u003e 1024KB"]
	VolumeProtocolSizeHistogramLabels []*string `json:"volume_protocol_size_histogram_labels,omitempty"`
}

// Validate validates this volume statistics reference inline nfs ops raw inline write
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline nfs ops raw inline write based on the context it is used
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolLatencyHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeProtocolSizeHistogramLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"write"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) contextValidateTotalTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"write"+"."+"total_time", "body", m.TotalTime); err != nil {
		return err
	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolLatencyHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolLatencyHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"write"+"."+"volume_protocol_latency_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolLatencyHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramCounts); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_counts"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramCounts[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) contextValidateVolumeProtocolSizeHistogramLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeProtocolSizeHistogramLabels); i++ {

		if err := validate.ReadOnly(ctx, "nfs_ops_raw"+"."+"write"+"."+"volume_protocol_size_histogram_labels"+"."+strconv.Itoa(i), "body", m.VolumeProtocolSizeHistogramLabels[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineNfsOpsRawInlineWrite
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VolumeStatisticsReferenceInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model volume_statistics_reference_inline_throughput_raw
type VolumeStatisticsReferenceInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this volume statistics reference inline throughput raw
func (m *VolumeStatisticsReferenceInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this volume statistics reference inline throughput raw based on the context it is used
func (m *VolumeStatisticsReferenceInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumeStatisticsReferenceInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res VolumeStatisticsReferenceInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
