// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VscanScannerPool Scanner pool is a set of attributes which are used to validate and manage connections between clustered ONTAP and external virus-scanning server, or "Vscan server".
//
// swagger:model vscan_scanner_pool
type VscanScannerPool struct {

	// cluster
	Cluster *ClusterReference `json:"cluster,omitempty"`

	// Specifies the name of the scanner pool. Scanner pool name can be up to 256 characters long and is a string that can only contain any combination of ASCII-range alphanumeric characters a-z, A-Z, 0-9), "_", "-" and ".".
	// Example: scanner-1
	// Max Length: 256
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies the role of the scanner pool. The possible values are:
	//   * primary   - Always active.
	//   * secondary - Active only when none of the primary external virus-scanning servers are connected.
	//   * idle      - Always inactive.
	//
	// Enum: ["primary","secondary","idle"]
	Role *string `json:"role,omitempty"`

	// svm
	Svm *VscanScannerPoolInlineSvm `json:"svm,omitempty"`

	// Specifies a list of privileged users. A valid form of privileged user-name is "domain-name\user-name". Privileged user-names are stored and treated as case-insensitive strings. Virus scanners must use one of the registered privileged users for connecting to clustered Data ONTAP for exchanging virus-scanning protocol messages and to access file for scanning, remedying and quarantining operations.
	// Example: ["cifs\\u1","cifs\\u2"]
	VscanScannerPoolInlinePrivilegedUsers []*string `json:"privileged_users,omitempty"`

	// Specifies a list of IP addresses or FQDN for each Vscan server host names which are allowed to connect to clustered ONTAP.
	// Example: ["1.1.1.1","10.72.204.27","vmwin204-27.fsct.nb"]
	VscanScannerPoolInlineServers []*string `json:"servers,omitempty"`
}

// Validate validates this vscan scanner pool
func (m *VscanScannerPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VscanScannerPool) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *VscanScannerPool) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 256); err != nil {
		return err
	}

	return nil
}

var vscanScannerPoolTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["primary","secondary","idle"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vscanScannerPoolTypeRolePropEnum = append(vscanScannerPoolTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vscan_scanner_pool
	// VscanScannerPool
	// role
	// Role
	// primary
	// END DEBUGGING
	// VscanScannerPoolRolePrimary captures enum value "primary"
	VscanScannerPoolRolePrimary string = "primary"

	// BEGIN DEBUGGING
	// vscan_scanner_pool
	// VscanScannerPool
	// role
	// Role
	// secondary
	// END DEBUGGING
	// VscanScannerPoolRoleSecondary captures enum value "secondary"
	VscanScannerPoolRoleSecondary string = "secondary"

	// BEGIN DEBUGGING
	// vscan_scanner_pool
	// VscanScannerPool
	// role
	// Role
	// idle
	// END DEBUGGING
	// VscanScannerPoolRoleIdle captures enum value "idle"
	VscanScannerPoolRoleIdle string = "idle"
)

// prop value enum
func (m *VscanScannerPool) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vscanScannerPoolTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VscanScannerPool) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", *m.Role); err != nil {
		return err
	}

	return nil
}

func (m *VscanScannerPool) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan scanner pool based on the context it is used
func (m *VscanScannerPool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VscanScannerPool) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *VscanScannerPool) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VscanScannerPool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VscanScannerPool) UnmarshalBinary(b []byte) error {
	var res VscanScannerPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VscanScannerPoolInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model vscan_scanner_pool_inline_svm
type VscanScannerPoolInlineSvm struct {

	// links
	Links *VscanScannerPoolInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this vscan scanner pool inline svm
func (m *VscanScannerPoolInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VscanScannerPoolInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan scanner pool inline svm based on the context it is used
func (m *VscanScannerPoolInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VscanScannerPoolInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VscanScannerPoolInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VscanScannerPoolInlineSvm) UnmarshalBinary(b []byte) error {
	var res VscanScannerPoolInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VscanScannerPoolInlineSvmInlineLinks vscan scanner pool inline svm inline links
//
// swagger:model vscan_scanner_pool_inline_svm_inline__links
type VscanScannerPoolInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this vscan scanner pool inline svm inline links
func (m *VscanScannerPoolInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VscanScannerPoolInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan scanner pool inline svm inline links based on the context it is used
func (m *VscanScannerPoolInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VscanScannerPoolInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VscanScannerPoolInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VscanScannerPoolInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VscanScannerPoolInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
