// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VsiOnSanNewIgroups The list of initiator groups to create.
//
// swagger:model vsi_on_san_new_igroups
type VsiOnSanNewIgroups struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The name of the new initiator group.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name"`

	// The protocol of the new initiator group.
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// vsi on san new igroups inline igroups
	VsiOnSanNewIgroupsInlineIgroups []*VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// vsi on san new igroups inline initiator objects
	VsiOnSanNewIgroupsInlineInitiatorObjects []*VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem `json:"initiator_objects,omitempty"`

	// vsi on san new igroups inline initiators
	VsiOnSanNewIgroupsInlineInitiators []*string `json:"initiators,omitempty"`
}

// Validate validates this vsi on san new igroups
func (m *VsiOnSanNewIgroups) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVsiOnSanNewIgroupsInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVsiOnSanNewIgroupsInlineInitiatorObjects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VsiOnSanNewIgroups) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var vsiOnSanNewIgroupsTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vsiOnSanNewIgroupsTypeProtocolPropEnum = append(vsiOnSanNewIgroupsTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// vsi_on_san_new_igroups
	// VsiOnSanNewIgroups
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// VsiOnSanNewIgroupsProtocolFcp captures enum value "fcp"
	VsiOnSanNewIgroupsProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// vsi_on_san_new_igroups
	// VsiOnSanNewIgroups
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// VsiOnSanNewIgroupsProtocolIscsi captures enum value "iscsi"
	VsiOnSanNewIgroupsProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// vsi_on_san_new_igroups
	// VsiOnSanNewIgroups
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// VsiOnSanNewIgroupsProtocolMixed captures enum value "mixed"
	VsiOnSanNewIgroupsProtocolMixed string = "mixed"
)

// prop value enum
func (m *VsiOnSanNewIgroups) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vsiOnSanNewIgroupsTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *VsiOnSanNewIgroups) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *VsiOnSanNewIgroups) validateVsiOnSanNewIgroupsInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.VsiOnSanNewIgroupsInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.VsiOnSanNewIgroupsInlineIgroups); i++ {
		if swag.IsZero(m.VsiOnSanNewIgroupsInlineIgroups[i]) { // not required
			continue
		}

		if m.VsiOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.VsiOnSanNewIgroupsInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VsiOnSanNewIgroups) validateVsiOnSanNewIgroupsInlineInitiatorObjects(formats strfmt.Registry) error {
	if swag.IsZero(m.VsiOnSanNewIgroupsInlineInitiatorObjects) { // not required
		return nil
	}

	for i := 0; i < len(m.VsiOnSanNewIgroupsInlineInitiatorObjects); i++ {
		if swag.IsZero(m.VsiOnSanNewIgroupsInlineInitiatorObjects[i]) { // not required
			continue
		}

		if m.VsiOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.VsiOnSanNewIgroupsInlineInitiatorObjects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vsi on san new igroups based on the context it is used
func (m *VsiOnSanNewIgroups) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateVsiOnSanNewIgroupsInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVsiOnSanNewIgroupsInlineInitiatorObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VsiOnSanNewIgroups) contextValidateVsiOnSanNewIgroupsInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VsiOnSanNewIgroupsInlineIgroups); i++ {

		if m.VsiOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.VsiOnSanNewIgroupsInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VsiOnSanNewIgroups) contextValidateVsiOnSanNewIgroupsInlineInitiatorObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VsiOnSanNewIgroupsInlineInitiatorObjects); i++ {

		if m.VsiOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.VsiOnSanNewIgroupsInlineInitiatorObjects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *VsiOnSanNewIgroups) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VsiOnSanNewIgroups) UnmarshalBinary(b []byte) error {
	var res VsiOnSanNewIgroups
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem vsi on san new igroups inline igroups inline array item
//
// swagger:model vsi_on_san_new_igroups_inline_igroups_inline_array_item
type VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem struct {

	// The name of an igroup to nest within a parent igroup. Mutually exclusive with initiators and initiator_objects.
	Name *string `json:"name,omitempty"`

	// The UUID of an igroup to nest within a parent igroup Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this vsi on san new igroups inline igroups inline array item
func (m *VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this vsi on san new igroups inline igroups inline array item based on context it is used
func (m *VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VsiOnSanNewIgroupsInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem vsi on san new igroups inline initiator objects inline array item
//
// swagger:model vsi_on_san_new_igroups_inline_initiator_objects_inline_array_item
type VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The WWPN, IQN, or Alias of the initiator. Mutually exclusive with nested igroups and the initiators array.
	Name *string `json:"name,omitempty"`
}

// Validate validates this vsi on san new igroups inline initiator objects inline array item
func (m *VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this vsi on san new igroups inline initiator objects inline array item based on context it is used
func (m *VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res VsiOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
