// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WebauthnCredentials webauthn credentials
//
// swagger:model webauthn_credentials
type WebauthnCredentials struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Date and time indicating when this entry was created.
	// Example: 2024-08-05 22:38:55-04:00
	// Read Only: true
	// Format: date-time
	CreationTime *strfmt.DateTime `json:"creation_time,omitempty"`

	// credential
	Credential *WebauthnCredentialsInlineCredential `json:"credential,omitempty"`

	// Display name.
	// Example: admin
	// Read Only: true
	DisplayName *string `json:"display_name,omitempty"`

	// Index.
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// Date and time indicating when this entry was last used.
	// Example: 2024-08-05 22:48:55-04:00
	// Read Only: true
	// Format: date-time
	LastUsedTime *strfmt.DateTime `json:"last_used_time,omitempty"`

	// WebAuthn credential owner. Used to identify a cluster or an SVM.
	// Read Only: true
	Owner *SvmReference `json:"owner,omitempty"`

	// public key
	PublicKey *WebauthnCredentialsInlinePublicKey `json:"public_key,omitempty"`

	// relying party
	RelyingParty *WebauthnCredentialsInlineRelyingParty `json:"relying_party,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// Username.
	// Example: admin
	// Read Only: true
	Username *string `json:"username,omitempty"`
}

// Validate validates this webauthn credentials
func (m *WebauthnCredentials) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreationTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCredential(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUsedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePublicKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelyingParty(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentials) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) validateCreationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("creation_time", "body", "date-time", m.CreationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) validateCredential(formats strfmt.Registry) error {
	if swag.IsZero(m.Credential) { // not required
		return nil
	}

	if m.Credential != nil {
		if err := m.Credential.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("credential")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) validateLastUsedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUsedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_used_time", "body", "date-time", m.LastUsedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) validatePublicKey(formats strfmt.Registry) error {
	if swag.IsZero(m.PublicKey) { // not required
		return nil
	}

	if m.PublicKey != nil {
		if err := m.PublicKey.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("public_key")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) validateRelyingParty(formats strfmt.Registry) error {
	if swag.IsZero(m.RelyingParty) { // not required
		return nil
	}

	if m.RelyingParty != nil {
		if err := m.RelyingParty.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relying_party")
			}
			return err
		}
	}

	return nil
}

var webauthnCredentialsTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		webauthnCredentialsTypeScopePropEnum = append(webauthnCredentialsTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// webauthn_credentials
	// WebauthnCredentials
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// WebauthnCredentialsScopeCluster captures enum value "cluster"
	WebauthnCredentialsScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// webauthn_credentials
	// WebauthnCredentials
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// WebauthnCredentialsScopeSvm captures enum value "svm"
	WebauthnCredentialsScopeSvm string = "svm"
)

// prop value enum
func (m *WebauthnCredentials) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, webauthnCredentialsTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WebauthnCredentials) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this webauthn credentials based on the context it is used
func (m *WebauthnCredentials) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreationTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCredential(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDisplayName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUsedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePublicKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelyingParty(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsername(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentials) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateCreationTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "creation_time", "body", m.CreationTime); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateCredential(ctx context.Context, formats strfmt.Registry) error {

	if m.Credential != nil {
		if err := m.Credential.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("credential")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateDisplayName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "display_name", "body", m.DisplayName); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "index", "body", m.Index); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateLastUsedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_used_time", "body", m.LastUsedTime); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) contextValidatePublicKey(ctx context.Context, formats strfmt.Registry) error {

	if m.PublicKey != nil {
		if err := m.PublicKey.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("public_key")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateRelyingParty(ctx context.Context, formats strfmt.Registry) error {

	if m.RelyingParty != nil {
		if err := m.RelyingParty.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relying_party")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentials) contextValidateUsername(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "username", "body", m.Username); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnCredentials) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnCredentials) UnmarshalBinary(b []byte) error {
	var res WebauthnCredentials
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WebauthnCredentialsInlineCredential webauthn credentials inline credential
//
// swagger:model webauthn_credentials_inline_credential
type WebauthnCredentialsInlineCredential struct {

	// SHA-256 Hashed representation of Credential ID.
	// Example: xxxxxxxxxxxxxxxxxxxxxxebfb30f20bf6db74xxxxxxxxxxxxxxxxxxxxxxxxxx
	// Read Only: true
	IDSha *string `json:"id_sha,omitempty"`

	// Credential type.
	// Read Only: true
	// Enum: ["public_key"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this webauthn credentials inline credential
func (m *WebauthnCredentialsInlineCredential) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var webauthnCredentialsInlineCredentialTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["public_key"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		webauthnCredentialsInlineCredentialTypeTypePropEnum = append(webauthnCredentialsInlineCredentialTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// webauthn_credentials_inline_credential
	// WebauthnCredentialsInlineCredential
	// type
	// Type
	// public_key
	// END DEBUGGING
	// WebauthnCredentialsInlineCredentialTypePublicKey captures enum value "public_key"
	WebauthnCredentialsInlineCredentialTypePublicKey string = "public_key"
)

// prop value enum
func (m *WebauthnCredentialsInlineCredential) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, webauthnCredentialsInlineCredentialTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WebauthnCredentialsInlineCredential) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("credential"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this webauthn credentials inline credential based on the context it is used
func (m *WebauthnCredentialsInlineCredential) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIDSha(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentialsInlineCredential) contextValidateIDSha(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "credential"+"."+"id_sha", "body", m.IDSha); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentialsInlineCredential) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "credential"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnCredentialsInlineCredential) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnCredentialsInlineCredential) UnmarshalBinary(b []byte) error {
	var res WebauthnCredentialsInlineCredential
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WebauthnCredentialsInlinePublicKey webauthn credentials inline public key
//
// swagger:model webauthn_credentials_inline_public_key
type WebauthnCredentialsInlinePublicKey struct {

	// Public key algorithm.
	// Example: ES-256
	// Read Only: true
	Algorithm *string `json:"algorithm,omitempty"`

	// Public key value.
	// Example: xxxxxxxxxxxxxxxxxxxxxe5sZohRRv2B10JjjALXmGRmEfFIxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxYr2+w==
	// Read Only: true
	Value *string `json:"value,omitempty"`
}

// Validate validates this webauthn credentials inline public key
func (m *WebauthnCredentialsInlinePublicKey) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this webauthn credentials inline public key based on the context it is used
func (m *WebauthnCredentialsInlinePublicKey) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAlgorithm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateValue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentialsInlinePublicKey) contextValidateAlgorithm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "public_key"+"."+"algorithm", "body", m.Algorithm); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentialsInlinePublicKey) contextValidateValue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "public_key"+"."+"value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnCredentialsInlinePublicKey) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnCredentialsInlinePublicKey) UnmarshalBinary(b []byte) error {
	var res WebauthnCredentialsInlinePublicKey
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WebauthnCredentialsInlineRelyingParty webauthn credentials inline relying party
//
// swagger:model webauthn_credentials_inline_relying_party
type WebauthnCredentialsInlineRelyingParty struct {

	// Relying Party ID.
	// Example: example.com
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// Relying Party Name.
	// Example: example.com
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this webauthn credentials inline relying party
func (m *WebauthnCredentialsInlineRelyingParty) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this webauthn credentials inline relying party based on the context it is used
func (m *WebauthnCredentialsInlineRelyingParty) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentialsInlineRelyingParty) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "relying_party"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnCredentialsInlineRelyingParty) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "relying_party"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnCredentialsInlineRelyingParty) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnCredentialsInlineRelyingParty) UnmarshalBinary(b []byte) error {
	var res WebauthnCredentialsInlineRelyingParty
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
