// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// WebauthnCredentialsResponse webauthn credentials response
//
// swagger:model webauthn_credentials_response
type WebauthnCredentialsResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// Number of records.
	NumRecords *int64 `json:"num_records,omitempty"`

	// webauthn credentials response inline records
	WebauthnCredentialsResponseInlineRecords []*WebauthnCredentials `json:"records,omitempty"`
}

// Validate validates this webauthn credentials response
func (m *WebauthnCredentialsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebauthnCredentialsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentialsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentialsResponse) validateWebauthnCredentialsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.WebauthnCredentialsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.WebauthnCredentialsResponseInlineRecords); i++ {
		if swag.IsZero(m.WebauthnCredentialsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.WebauthnCredentialsResponseInlineRecords[i] != nil {
			if err := m.WebauthnCredentialsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this webauthn credentials response based on the context it is used
func (m *WebauthnCredentialsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebauthnCredentialsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnCredentialsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnCredentialsResponse) contextValidateWebauthnCredentialsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WebauthnCredentialsResponseInlineRecords); i++ {

		if m.WebauthnCredentialsResponseInlineRecords[i] != nil {
			if err := m.WebauthnCredentialsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnCredentialsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnCredentialsResponse) UnmarshalBinary(b []byte) error {
	var res WebauthnCredentialsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
