// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WebauthnGlobal WebAuthn global settings.
//
// swagger:model webauthn_global
type WebauthnGlobal struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Attestation conveyance type.
	// Example: none
	// Read Only: true
	// Enum: ["none","indirect","direct","enterprise"]
	Attestation *string `json:"attestation,omitempty"`

	// WebAuthn settings owner. Used to identify a cluster or an SVM.
	// Read Only: true
	Owner *SvmReference `json:"owner,omitempty"`

	// Specifies whether the resident key is required.
	// Example: false
	// Read Only: true
	RequireRk *bool `json:"require_rk,omitempty"`

	// Resident key.
	// Example: discouraged
	// Read Only: true
	// Enum: ["required","preferred","discouraged"]
	ResidentKey *string `json:"resident_key,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// The timeout interval for the WebAuthn request, in milliseconds.
	// Example: 600000
	// Read Only: true
	Timeout *int64 `json:"timeout,omitempty"`

	// User verification.
	// Example: discouraged
	// Read Only: true
	// Enum: ["required","preferred","discouraged"]
	UserVerification *string `json:"user_verification,omitempty"`
}

// Validate validates this webauthn global
func (m *WebauthnGlobal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttestation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResidentKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserVerification(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnGlobal) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var webauthnGlobalTypeAttestationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","indirect","direct","enterprise"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		webauthnGlobalTypeAttestationPropEnum = append(webauthnGlobalTypeAttestationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// attestation
	// Attestation
	// none
	// END DEBUGGING
	// WebauthnGlobalAttestationNone captures enum value "none"
	WebauthnGlobalAttestationNone string = "none"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// attestation
	// Attestation
	// indirect
	// END DEBUGGING
	// WebauthnGlobalAttestationIndirect captures enum value "indirect"
	WebauthnGlobalAttestationIndirect string = "indirect"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// attestation
	// Attestation
	// direct
	// END DEBUGGING
	// WebauthnGlobalAttestationDirect captures enum value "direct"
	WebauthnGlobalAttestationDirect string = "direct"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// attestation
	// Attestation
	// enterprise
	// END DEBUGGING
	// WebauthnGlobalAttestationEnterprise captures enum value "enterprise"
	WebauthnGlobalAttestationEnterprise string = "enterprise"
)

// prop value enum
func (m *WebauthnGlobal) validateAttestationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, webauthnGlobalTypeAttestationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WebauthnGlobal) validateAttestation(formats strfmt.Registry) error {
	if swag.IsZero(m.Attestation) { // not required
		return nil
	}

	// value enum
	if err := m.validateAttestationEnum("attestation", "body", *m.Attestation); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnGlobal) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

var webauthnGlobalTypeResidentKeyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["required","preferred","discouraged"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		webauthnGlobalTypeResidentKeyPropEnum = append(webauthnGlobalTypeResidentKeyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// resident_key
	// ResidentKey
	// required
	// END DEBUGGING
	// WebauthnGlobalResidentKeyRequired captures enum value "required"
	WebauthnGlobalResidentKeyRequired string = "required"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// resident_key
	// ResidentKey
	// preferred
	// END DEBUGGING
	// WebauthnGlobalResidentKeyPreferred captures enum value "preferred"
	WebauthnGlobalResidentKeyPreferred string = "preferred"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// resident_key
	// ResidentKey
	// discouraged
	// END DEBUGGING
	// WebauthnGlobalResidentKeyDiscouraged captures enum value "discouraged"
	WebauthnGlobalResidentKeyDiscouraged string = "discouraged"
)

// prop value enum
func (m *WebauthnGlobal) validateResidentKeyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, webauthnGlobalTypeResidentKeyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WebauthnGlobal) validateResidentKey(formats strfmt.Registry) error {
	if swag.IsZero(m.ResidentKey) { // not required
		return nil
	}

	// value enum
	if err := m.validateResidentKeyEnum("resident_key", "body", *m.ResidentKey); err != nil {
		return err
	}

	return nil
}

var webauthnGlobalTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		webauthnGlobalTypeScopePropEnum = append(webauthnGlobalTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// WebauthnGlobalScopeCluster captures enum value "cluster"
	WebauthnGlobalScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// WebauthnGlobalScopeSvm captures enum value "svm"
	WebauthnGlobalScopeSvm string = "svm"
)

// prop value enum
func (m *WebauthnGlobal) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, webauthnGlobalTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WebauthnGlobal) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

var webauthnGlobalTypeUserVerificationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["required","preferred","discouraged"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		webauthnGlobalTypeUserVerificationPropEnum = append(webauthnGlobalTypeUserVerificationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// user_verification
	// UserVerification
	// required
	// END DEBUGGING
	// WebauthnGlobalUserVerificationRequired captures enum value "required"
	WebauthnGlobalUserVerificationRequired string = "required"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// user_verification
	// UserVerification
	// preferred
	// END DEBUGGING
	// WebauthnGlobalUserVerificationPreferred captures enum value "preferred"
	WebauthnGlobalUserVerificationPreferred string = "preferred"

	// BEGIN DEBUGGING
	// webauthn_global
	// WebauthnGlobal
	// user_verification
	// UserVerification
	// discouraged
	// END DEBUGGING
	// WebauthnGlobalUserVerificationDiscouraged captures enum value "discouraged"
	WebauthnGlobalUserVerificationDiscouraged string = "discouraged"
)

// prop value enum
func (m *WebauthnGlobal) validateUserVerificationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, webauthnGlobalTypeUserVerificationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WebauthnGlobal) validateUserVerification(formats strfmt.Registry) error {
	if swag.IsZero(m.UserVerification) { // not required
		return nil
	}

	// value enum
	if err := m.validateUserVerificationEnum("user_verification", "body", *m.UserVerification); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this webauthn global based on the context it is used
func (m *WebauthnGlobal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttestation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRequireRk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResidentKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserVerification(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnGlobal) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateAttestation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "attestation", "body", m.Attestation); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateRequireRk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "require_rk", "body", m.RequireRk); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateResidentKey(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resident_key", "body", m.ResidentKey); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateTimeout(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timeout", "body", m.Timeout); err != nil {
		return err
	}

	return nil
}

func (m *WebauthnGlobal) contextValidateUserVerification(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "user_verification", "body", m.UserVerification); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnGlobal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnGlobal) UnmarshalBinary(b []byte) error {
	var res WebauthnGlobal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
