// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// WebauthnGlobalResponse webauthn global response
//
// swagger:model webauthn_global_response
type WebauthnGlobalResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// Number of records.
	NumRecords *int64 `json:"num_records,omitempty"`

	// webauthn global response inline records
	WebauthnGlobalResponseInlineRecords []*WebauthnGlobal `json:"records,omitempty"`
}

// Validate validates this webauthn global response
func (m *WebauthnGlobalResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebauthnGlobalResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnGlobalResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnGlobalResponse) validateWebauthnGlobalResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.WebauthnGlobalResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.WebauthnGlobalResponseInlineRecords); i++ {
		if swag.IsZero(m.WebauthnGlobalResponseInlineRecords[i]) { // not required
			continue
		}

		if m.WebauthnGlobalResponseInlineRecords[i] != nil {
			if err := m.WebauthnGlobalResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this webauthn global response based on the context it is used
func (m *WebauthnGlobalResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebauthnGlobalResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WebauthnGlobalResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WebauthnGlobalResponse) contextValidateWebauthnGlobalResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WebauthnGlobalResponseInlineRecords); i++ {

		if m.WebauthnGlobalResponseInlineRecords[i] != nil {
			if err := m.WebauthnGlobalResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WebauthnGlobalResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WebauthnGlobalResponse) UnmarshalBinary(b []byte) error {
	var res WebauthnGlobalResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
