// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Whoami whoami
//
// swagger:model whoami
type Whoami struct {

	// links
	Links *WhoamiInlineLinks `json:"_links,omitempty"`

	// User name
	// Example: tom
	Username *string `json:"username,omitempty"`

	// List of privileges
	WhoamiInlinePrivileges []*WhoamiPrivileges `json:"privileges,omitempty"`

	// Role name or names
	WhoamiInlineRoles []*string `json:"roles,omitempty"`
}

// Validate validates this whoami
func (m *Whoami) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWhoamiInlinePrivileges(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Whoami) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Whoami) validateWhoamiInlinePrivileges(formats strfmt.Registry) error {
	if swag.IsZero(m.WhoamiInlinePrivileges) { // not required
		return nil
	}

	for i := 0; i < len(m.WhoamiInlinePrivileges); i++ {
		if swag.IsZero(m.WhoamiInlinePrivileges[i]) { // not required
			continue
		}

		if m.WhoamiInlinePrivileges[i] != nil {
			if err := m.WhoamiInlinePrivileges[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("privileges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this whoami based on the context it is used
func (m *Whoami) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWhoamiInlinePrivileges(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Whoami) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Whoami) contextValidateWhoamiInlinePrivileges(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WhoamiInlinePrivileges); i++ {

		if m.WhoamiInlinePrivileges[i] != nil {
			if err := m.WhoamiInlinePrivileges[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("privileges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Whoami) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Whoami) UnmarshalBinary(b []byte) error {
	var res Whoami
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WhoamiInlineLinks whoami inline links
//
// swagger:model whoami_inline__links
type WhoamiInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this whoami inline links
func (m *WhoamiInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WhoamiInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this whoami inline links based on the context it is used
func (m *WhoamiInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WhoamiInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WhoamiInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WhoamiInlineLinks) UnmarshalBinary(b []byte) error {
	var res WhoamiInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
