// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Workspace Workspace information
//
// swagger:model workspace
type Workspace struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The creation time of the workspace. This field is generated when the workspace is created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The count of data collection in a workspace.
	// Example: 20
	// Read Only: true
	DataCollectionCount *int64 `json:"data_collection_count,omitempty"`

	// Description of the workspace.
	// Example: Example workspace
	Description *string `json:"description,omitempty"`

	// The count of entities in a workspace.
	// Example: 1000
	// Read Only: true
	EntityCount *int64 `json:"entity_count,omitempty"`

	// The last refresh time of the workspace. This field is generated when the workspace is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The message associated with the current state of the workspace.
	// Example: creating workspace
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Name for the workspace. Required for POST requests.
	// Example: Doc workspace
	Name *string `json:"name,omitempty"`

	// The owner of the workspace.
	// Example: SAL
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// The workspace refresh time interval in ISO-8601 format. Optional in POST requests. If not supplied, this value defaults to PT1H.
	// Example: PT1H
	RefreshInterval *string `json:"refresh_interval,omitempty"`

	// space
	Space *WorkspaceInlineSpace `json:"space,omitempty"`

	// State of the workspace:
	// * <i>processing</i> - The workspace is being processed after creation.
	// * <i>ready</i> - The workspace is ready for use.
	// * <i>failed</i> - The workspace has a failure.
	// * <i>outdated</i> - The workspace is outdated.
	// * Valid in GET.
	//
	// Example: ready
	// Read Only: true
	// Enum: ["processing","ready","failed","outdated"]
	State *string `json:"state,omitempty"`

	// The time of update of the workspace. This field is generated when the workspace is updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier for the workspace.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *WorkspaceInlineVersion `json:"version,omitempty"`

	// List of users or groups associated with the ACL.
	WorkspaceInlineAcls []*DataEngineACL `json:"acls,omitempty"`

	// The data sources to be added to the workspace. Required in a POST request.
	WorkspaceInlineDataSources []*WorkspaceInlineDataSourcesInlineArrayItem `json:"data_sources,omitempty"`

	// workspace inline errors
	// Read Only: true
	WorkspaceInlineErrors []*WorkspaceInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// workspace inline policies
	WorkspaceInlinePolicies []*WorkspaceInlinePoliciesInlineArrayItem `json:"policies,omitempty"`
}

// Validate validates this workspace
func (m *Workspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceInlineAcls(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceInlineDataSources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceInlinePolicies(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Workspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Workspace) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_refresh_time", "body", "date-time", m.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var workspaceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["processing","ready","failed","outdated"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceTypeStatePropEnum = append(workspaceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace
	// Workspace
	// state
	// State
	// processing
	// END DEBUGGING
	// WorkspaceStateProcessing captures enum value "processing"
	WorkspaceStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// workspace
	// Workspace
	// state
	// State
	// ready
	// END DEBUGGING
	// WorkspaceStateReady captures enum value "ready"
	WorkspaceStateReady string = "ready"

	// BEGIN DEBUGGING
	// workspace
	// Workspace
	// state
	// State
	// failed
	// END DEBUGGING
	// WorkspaceStateFailed captures enum value "failed"
	WorkspaceStateFailed string = "failed"

	// BEGIN DEBUGGING
	// workspace
	// Workspace
	// state
	// State
	// outdated
	// END DEBUGGING
	// WorkspaceStateOutdated captures enum value "outdated"
	WorkspaceStateOutdated string = "outdated"
)

// prop value enum
func (m *Workspace) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Workspace) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *Workspace) validateWorkspaceInlineAcls(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceInlineAcls) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceInlineAcls); i++ {
		if swag.IsZero(m.WorkspaceInlineAcls[i]) { // not required
			continue
		}

		if m.WorkspaceInlineAcls[i] != nil {
			if err := m.WorkspaceInlineAcls[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Workspace) validateWorkspaceInlineDataSources(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceInlineDataSources) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceInlineDataSources); i++ {
		if swag.IsZero(m.WorkspaceInlineDataSources[i]) { // not required
			continue
		}

		if m.WorkspaceInlineDataSources[i] != nil {
			if err := m.WorkspaceInlineDataSources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Workspace) validateWorkspaceInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceInlineErrors); i++ {
		if swag.IsZero(m.WorkspaceInlineErrors[i]) { // not required
			continue
		}

		if m.WorkspaceInlineErrors[i] != nil {
			if err := m.WorkspaceInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Workspace) validateWorkspaceInlinePolicies(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceInlinePolicies) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceInlinePolicies); i++ {
		if swag.IsZero(m.WorkspaceInlinePolicies[i]) { // not required
			continue
		}

		if m.WorkspaceInlinePolicies[i] != nil {
			if err := m.WorkspaceInlinePolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace based on the context it is used
func (m *Workspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCollectionCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntityCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceInlineAcls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceInlineDataSources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceInlinePolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Workspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Workspace) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateDataCollectionCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection_count", "body", m.DataCollectionCount); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateEntityCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entity_count", "body", m.EntityCount); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_refresh_time", "body", m.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner", "body", m.Owner); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *Workspace) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Workspace) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *Workspace) contextValidateWorkspaceInlineAcls(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WorkspaceInlineAcls); i++ {

		if m.WorkspaceInlineAcls[i] != nil {
			if err := m.WorkspaceInlineAcls[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Workspace) contextValidateWorkspaceInlineDataSources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WorkspaceInlineDataSources); i++ {

		if m.WorkspaceInlineDataSources[i] != nil {
			if err := m.WorkspaceInlineDataSources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Workspace) contextValidateWorkspaceInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*WorkspaceInlineErrorsInlineArrayItem(m.WorkspaceInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.WorkspaceInlineErrors); i++ {

		if m.WorkspaceInlineErrors[i] != nil {
			if err := m.WorkspaceInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Workspace) contextValidateWorkspaceInlinePolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WorkspaceInlinePolicies); i++ {

		if m.WorkspaceInlinePolicies[i] != nil {
			if err := m.WorkspaceInlinePolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Workspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Workspace) UnmarshalBinary(b []byte) error {
	var res Workspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlineDataSourcesInlineArrayItem workspace inline data sources inline array item
//
// swagger:model workspace_inline_data_sources_inline_array_item
type WorkspaceInlineDataSourcesInlineArrayItem struct {

	// data source
	DataSource *CommonDataSource `json:"data_source,omitempty"`
}

// Validate validates this workspace inline data sources inline array item
func (m *WorkspaceInlineDataSourcesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineDataSourcesInlineArrayItem) validateDataSource(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSource) { // not required
		return nil
	}

	if m.DataSource != nil {
		if err := m.DataSource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace inline data sources inline array item based on the context it is used
func (m *WorkspaceInlineDataSourcesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDataSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineDataSourcesInlineArrayItem) contextValidateDataSource(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSource != nil {
		if err := m.DataSource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlineDataSourcesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlineDataSourcesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineDataSourcesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlineErrorsInlineArrayItem workspace inline errors inline array item
//
// swagger:model workspace_inline_errors_inline_array_item
type WorkspaceInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this workspace inline errors inline array item
func (m *WorkspaceInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace inline errors inline array item based on the context it is used
func (m *WorkspaceInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlinePoliciesInlineArrayItem workspace inline policies inline array item
//
// swagger:model workspace_inline_policies_inline_array_item
type WorkspaceInlinePoliciesInlineArrayItem struct {

	// description
	// Example: Description of Policy
	Description *string `json:"description,omitempty"`

	// name
	// Example: Example Policy
	Name *string `json:"name,omitempty"`

	// The unique identifier of the policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline policies inline array item
func (m *WorkspaceInlinePoliciesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlinePoliciesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this workspace inline policies inline array item based on context it is used
func (m *WorkspaceInlinePoliciesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlinePoliciesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlinePoliciesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlinePoliciesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlineSpace workspace inline space
//
// swagger:model workspace_inline_space
type WorkspaceInlineSpace struct {

	// The available space of a workspace, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The total space of a workspace, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// The used space of a workspace, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this workspace inline space
func (m *WorkspaceInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this workspace inline space based on the context it is used
func (m *WorkspaceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceInlineSpace) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlineSpace) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlineVersion The version information of a workspace.
//
// swagger:model workspace_inline_version
type WorkspaceInlineVersion struct {

	// current
	Current *WorkspaceInlineVersionInlineCurrent `json:"current,omitempty"`

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// next
	Next *WorkspaceInlineVersionInlineNext `json:"next,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline version
func (m *WorkspaceInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCurrent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineVersion) validateCurrent(formats strfmt.Registry) error {
	if swag.IsZero(m.Current) { // not required
		return nil
	}

	if m.Current != nil {
		if err := m.Current.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersion) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersion) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace inline version based on the context it is used
func (m *WorkspaceInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineVersion) contextValidateCurrent(ctx context.Context, formats strfmt.Registry) error {

	if m.Current != nil {
		if err := m.Current.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersion) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersion) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlineVersion) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlineVersionInlineCurrent Current version information.
//
// swagger:model workspace_inline_version_inline_current
type WorkspaceInlineVersionInlineCurrent struct {

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the current version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline version inline current
func (m *WorkspaceInlineVersionInlineCurrent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineVersionInlineCurrent) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersionInlineCurrent) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"current"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace inline version inline current based on the context it is used
func (m *WorkspaceInlineVersionInlineCurrent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineVersionInlineCurrent) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlineVersionInlineCurrent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlineVersionInlineCurrent) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineVersionInlineCurrent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceInlineVersionInlineNext Next version information.
//
// swagger:model workspace_inline_version_inline_next
type WorkspaceInlineVersionInlineNext struct {

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the next version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline version inline next
func (m *WorkspaceInlineVersionInlineNext) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineVersionInlineNext) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceInlineVersionInlineNext) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"next"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace inline version inline next based on the context it is used
func (m *WorkspaceInlineVersionInlineNext) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceInlineVersionInlineNext) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceInlineVersionInlineNext) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceInlineVersionInlineNext) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineVersionInlineNext
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
