// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceDataSource Data source present within a workspace.
//
// swagger:model workspace_data_source
type WorkspaceDataSource struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The last refresh time of the data source. This field is generated when the data source is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The local storage used for a data source. Required on POST requests.
	LocalStorage *LocalStorage `json:"local_storage,omitempty"`

	// The message associated with the current state of the data source.
	// Example: refreshing data source
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// The remote storage used for a data source. Required on POST requests.
	RemoteStorage *RemoteStorage `json:"remote_storage,omitempty"`

	// space
	Space *WorkspaceDataSourceInlineSpace `json:"space,omitempty"`

	// State of the data source:
	// * <i>processing</i> - The data source is being processed after creation.
	// * <i>ready</i> - The data source is ready for use.
	// * <i>failed</i> - The data source has a failure.
	// * <i>outdated</i> - The data source is outdated.
	// * <i>deleted</i> - The data source has been marked for deletion.
	// * Valid in GET requests.
	//
	// Example: ready
	// Read Only: true
	// Enum: ["processing","ready","failed","outdated","deleted"]
	State *string `json:"state,omitempty"`

	// The type of the data source.
	Type *DataSourceType `json:"type,omitempty"`

	// Unique identifier for the data source.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace data source inline errors
	// Read Only: true
	WorkspaceDataSourceInlineErrors []*WorkspaceDataSourceInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// The list of workspaces that are associated with the data source.
	// Read Only: true
	WorkspaceDataSourceInlineWorkspaces []*WorkspaceReference `json:"workspaces,omitempty"`
}

// Validate validates this workspace data source
func (m *WorkspaceDataSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceDataSourceInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceDataSourceInlineWorkspaces(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceDataSource) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_refresh_time", "body", "date-time", m.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) validateLocalStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalStorage) { // not required
		return nil
	}

	if m.LocalStorage != nil {
		if err := m.LocalStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_storage")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) validateRemoteStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteStorage) { // not required
		return nil
	}

	if m.RemoteStorage != nil {
		if err := m.RemoteStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_storage")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var workspaceDataSourceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["processing","ready","failed","outdated","deleted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceDataSourceTypeStatePropEnum = append(workspaceDataSourceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_data_source
	// WorkspaceDataSource
	// state
	// State
	// processing
	// END DEBUGGING
	// WorkspaceDataSourceStateProcessing captures enum value "processing"
	WorkspaceDataSourceStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// workspace_data_source
	// WorkspaceDataSource
	// state
	// State
	// ready
	// END DEBUGGING
	// WorkspaceDataSourceStateReady captures enum value "ready"
	WorkspaceDataSourceStateReady string = "ready"

	// BEGIN DEBUGGING
	// workspace_data_source
	// WorkspaceDataSource
	// state
	// State
	// failed
	// END DEBUGGING
	// WorkspaceDataSourceStateFailed captures enum value "failed"
	WorkspaceDataSourceStateFailed string = "failed"

	// BEGIN DEBUGGING
	// workspace_data_source
	// WorkspaceDataSource
	// state
	// State
	// outdated
	// END DEBUGGING
	// WorkspaceDataSourceStateOutdated captures enum value "outdated"
	WorkspaceDataSourceStateOutdated string = "outdated"

	// BEGIN DEBUGGING
	// workspace_data_source
	// WorkspaceDataSource
	// state
	// State
	// deleted
	// END DEBUGGING
	// WorkspaceDataSourceStateDeleted captures enum value "deleted"
	WorkspaceDataSourceStateDeleted string = "deleted"
)

// prop value enum
func (m *WorkspaceDataSource) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceDataSourceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceDataSource) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	if m.Type != nil {
		if err := m.Type.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) validateWorkspaceDataSourceInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceDataSourceInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceDataSourceInlineErrors); i++ {
		if swag.IsZero(m.WorkspaceDataSourceInlineErrors[i]) { // not required
			continue
		}

		if m.WorkspaceDataSourceInlineErrors[i] != nil {
			if err := m.WorkspaceDataSourceInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceDataSource) validateWorkspaceDataSourceInlineWorkspaces(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceDataSourceInlineWorkspaces) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceDataSourceInlineWorkspaces); i++ {
		if swag.IsZero(m.WorkspaceDataSourceInlineWorkspaces[i]) { // not required
			continue
		}

		if m.WorkspaceDataSourceInlineWorkspaces[i] != nil {
			if err := m.WorkspaceDataSourceInlineWorkspaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace data source based on the context it is used
func (m *WorkspaceDataSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceDataSourceInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceDataSourceInlineWorkspaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceDataSource) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_refresh_time", "body", m.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateLocalStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.LocalStorage != nil {
		if err := m.LocalStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_storage")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateRemoteStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.RemoteStorage != nil {
		if err := m.RemoteStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_storage")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if m.Type != nil {
		if err := m.Type.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateWorkspaceDataSourceInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*WorkspaceDataSourceInlineErrorsInlineArrayItem(m.WorkspaceDataSourceInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.WorkspaceDataSourceInlineErrors); i++ {

		if m.WorkspaceDataSourceInlineErrors[i] != nil {
			if err := m.WorkspaceDataSourceInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceDataSource) contextValidateWorkspaceDataSourceInlineWorkspaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspaces", "body", []*WorkspaceReference(m.WorkspaceDataSourceInlineWorkspaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.WorkspaceDataSourceInlineWorkspaces); i++ {

		if m.WorkspaceDataSourceInlineWorkspaces[i] != nil {
			if err := m.WorkspaceDataSourceInlineWorkspaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceDataSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceDataSource) UnmarshalBinary(b []byte) error {
	var res WorkspaceDataSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceDataSourceInlineErrorsInlineArrayItem workspace data source inline errors inline array item
//
// swagger:model workspace_data_source_inline_errors_inline_array_item
type WorkspaceDataSourceInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this workspace data source inline errors inline array item
func (m *WorkspaceDataSourceInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceDataSourceInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace data source inline errors inline array item based on the context it is used
func (m *WorkspaceDataSourceInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceDataSourceInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceDataSourceInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceDataSourceInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceDataSourceInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceDataSourceInlineSpace workspace data source inline space
//
// swagger:model workspace_data_source_inline_space
type WorkspaceDataSourceInlineSpace struct {

	// The available space of a data source, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The total space of a data source, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// The used space of a data source, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this workspace data source inline space
func (m *WorkspaceDataSourceInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this workspace data source inline space based on the context it is used
func (m *WorkspaceDataSourceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceDataSourceInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSourceInlineSpace) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceDataSourceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceDataSourceInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceDataSourceInlineSpace) UnmarshalBinary(b []byte) error {
	var res WorkspaceDataSourceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
