// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceMetrics The aggregated metrics of all workspaces.
//
// swagger:model workspace_metrics
type WorkspaceMetrics struct {

	// The total size of all metadata, in bytes.
	// Example: 121314
	MetadataSize *int64 `json:"metadata_size,omitempty"`

	// The percentage of the total cluster size occupied by the workspaces.
	// Example: 25
	// Maximum: 100
	// Minimum: 0
	SpacePercent *int64 `json:"space_percent,omitempty"`

	// The total number of workspaces.
	// Example: 100
	TotalCount *int64 `json:"total_count,omitempty"`

	// The total size of all workspaces, in bytes.
	// Example: 121314
	TotalSize *int64 `json:"total_size,omitempty"`

	// The total size of all vector database, in bytes.
	// Example: 121314
	VectorSize *int64 `json:"vector_size,omitempty"`

	// The number of workspaces per state.
	WorkspaceMetricsInlineCountsByState []*WorkspaceMetricsInlineCountsByStateInlineArrayItem `json:"counts_by_state,omitempty"`
}

// Validate validates this workspace metrics
func (m *WorkspaceMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSpacePercent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceMetricsInlineCountsByState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceMetrics) validateSpacePercent(formats strfmt.Registry) error {
	if swag.IsZero(m.SpacePercent) { // not required
		return nil
	}

	if err := validate.MinimumInt("space_percent", "body", *m.SpacePercent, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space_percent", "body", *m.SpacePercent, 100, false); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceMetrics) validateWorkspaceMetricsInlineCountsByState(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceMetricsInlineCountsByState) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceMetricsInlineCountsByState); i++ {
		if swag.IsZero(m.WorkspaceMetricsInlineCountsByState[i]) { // not required
			continue
		}

		if m.WorkspaceMetricsInlineCountsByState[i] != nil {
			if err := m.WorkspaceMetricsInlineCountsByState[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("counts_by_state" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace metrics based on the context it is used
func (m *WorkspaceMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateWorkspaceMetricsInlineCountsByState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceMetrics) contextValidateWorkspaceMetricsInlineCountsByState(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WorkspaceMetricsInlineCountsByState); i++ {

		if m.WorkspaceMetricsInlineCountsByState[i] != nil {
			if err := m.WorkspaceMetricsInlineCountsByState[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("counts_by_state" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceMetrics) UnmarshalBinary(b []byte) error {
	var res WorkspaceMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceMetricsInlineCountsByStateInlineArrayItem workspace metrics inline counts by state inline array item
//
// swagger:model workspace_metrics_inline_counts_by_state_inline_array_item
type WorkspaceMetricsInlineCountsByStateInlineArrayItem struct {

	// The number of workspaces in this state.
	// Example: 50
	Count *int64 `json:"count,omitempty"`

	// State of the workspace:
	// * <i>processing</i> - The workspace is being processed after creation.
	// * <i>ready</i> - The workspace is ready for use.
	// * <i>failed</i> - The workspace has a failure.
	// * <i>outdated</i> - The workspace is outdated.
	// * <i>deleted</i> - The workspace has been marked for deletion.
	//
	// Example: ready
	// Enum: ["processing","ready","failed","outdated","deleted"]
	State *string `json:"state,omitempty"`
}

// Validate validates this workspace metrics inline counts by state inline array item
func (m *WorkspaceMetricsInlineCountsByStateInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var workspaceMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["processing","ready","failed","outdated","deleted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum = append(workspaceMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_metrics_inline_counts_by_state_inline_array_item
	// WorkspaceMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// processing
	// END DEBUGGING
	// WorkspaceMetricsInlineCountsByStateInlineArrayItemStateProcessing captures enum value "processing"
	WorkspaceMetricsInlineCountsByStateInlineArrayItemStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// workspace_metrics_inline_counts_by_state_inline_array_item
	// WorkspaceMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// ready
	// END DEBUGGING
	// WorkspaceMetricsInlineCountsByStateInlineArrayItemStateReady captures enum value "ready"
	WorkspaceMetricsInlineCountsByStateInlineArrayItemStateReady string = "ready"

	// BEGIN DEBUGGING
	// workspace_metrics_inline_counts_by_state_inline_array_item
	// WorkspaceMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// failed
	// END DEBUGGING
	// WorkspaceMetricsInlineCountsByStateInlineArrayItemStateFailed captures enum value "failed"
	WorkspaceMetricsInlineCountsByStateInlineArrayItemStateFailed string = "failed"

	// BEGIN DEBUGGING
	// workspace_metrics_inline_counts_by_state_inline_array_item
	// WorkspaceMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// outdated
	// END DEBUGGING
	// WorkspaceMetricsInlineCountsByStateInlineArrayItemStateOutdated captures enum value "outdated"
	WorkspaceMetricsInlineCountsByStateInlineArrayItemStateOutdated string = "outdated"

	// BEGIN DEBUGGING
	// workspace_metrics_inline_counts_by_state_inline_array_item
	// WorkspaceMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// deleted
	// END DEBUGGING
	// WorkspaceMetricsInlineCountsByStateInlineArrayItemStateDeleted captures enum value "deleted"
	WorkspaceMetricsInlineCountsByStateInlineArrayItemStateDeleted string = "deleted"
)

// prop value enum
func (m *WorkspaceMetricsInlineCountsByStateInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceMetricsInlineCountsByStateInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this workspace metrics inline counts by state inline array item based on context it is used
func (m *WorkspaceMetricsInlineCountsByStateInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceMetricsInlineCountsByStateInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceMetricsInlineCountsByStateInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceMetricsInlineCountsByStateInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
