// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceQueryEntity The entity that matches workspace query criteria.
//
// swagger:model workspace_query_entity
type WorkspaceQueryEntity struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The last access time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	AccessTime *strfmt.DateTime `json:"access_time,omitempty"`

	// attributes
	Attributes *WorkspaceQueryEntityInlineAttributes `json:"attributes,omitempty"`

	// Indicates if the entity can be previewed.
	// Example: true
	// Read Only: true
	CanPreview *bool `json:"can_preview,omitempty"`

	// The hash of the entity content.
	// Read Only: true
	ContentHash *string `json:"content_hash,omitempty"`

	// The create time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// datasource
	// Read Only: true
	Datasource *DataSourceVersion `json:"datasource,omitempty"`

	// The extension of the entity.
	// Read Only: true
	Extension *string `json:"extension,omitempty"`

	// The format of the entity (e.g. pdf document, jpeg image, mp4 video, zip).
	// Example: pdf
	// Read Only: true
	Format *string `json:"format,omitempty"`

	// Indicates if the entity has PII.
	// Example: false
	// Read Only: true
	HasPii *bool `json:"has_pii,omitempty"`

	// The name of the entity.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// permissions
	Permissions *WorkspaceQueryEntityInlinePermissions `json:"permissions,omitempty"`

	// The size of the entity in bytes.
	// Example: 100
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Type of the entity:
	// * <i>file</i> - The entity is a file.
	// * <i>object</i> - The entity is an object.
	//
	// Read Only: true
	// Enum: ["file","object"]
	Type *string `json:"type,omitempty"`

	// The last update time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// The URI of the entity.
	// Read Only: true
	URI *string `json:"uri,omitempty"`

	// Unique identifier for the entity.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	// Read Only: true
	Workspace *EntityWorkspaceVersion `json:"workspace,omitempty"`

	// workspace query entity inline errors
	// Read Only: true
	WorkspaceQueryEntityInlineErrors []*WorkspaceQueryEntityInlineErrorsInlineArrayItem `json:"errors,omitempty"`
}

// Validate validates this workspace query entity
func (m *WorkspaceQueryEntity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatasource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceQueryEntityInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntity) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateAccessTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessTime) { // not required
		return nil
	}

	if err := validate.FormatOf("access_time", "body", "date-time", m.AccessTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.Attributes) { // not required
		return nil
	}

	if m.Attributes != nil {
		if err := m.Attributes.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("attributes")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateDatasource(formats strfmt.Registry) error {
	if swag.IsZero(m.Datasource) { // not required
		return nil
	}

	if m.Datasource != nil {
		if err := m.Datasource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datasource")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) validatePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.Permissions) { // not required
		return nil
	}

	if m.Permissions != nil {
		if err := m.Permissions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("permissions")
			}
			return err
		}
	}

	return nil
}

var workspaceQueryEntityTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file","object"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceQueryEntityTypeTypePropEnum = append(workspaceQueryEntityTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_query_entity
	// WorkspaceQueryEntity
	// type
	// Type
	// file
	// END DEBUGGING
	// WorkspaceQueryEntityTypeFile captures enum value "file"
	WorkspaceQueryEntityTypeFile string = "file"

	// BEGIN DEBUGGING
	// workspace_query_entity
	// WorkspaceQueryEntity
	// type
	// Type
	// object
	// END DEBUGGING
	// WorkspaceQueryEntityTypeObject captures enum value "object"
	WorkspaceQueryEntityTypeObject string = "object"
)

// prop value enum
func (m *WorkspaceQueryEntity) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceQueryEntityTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceQueryEntity) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) validateWorkspaceQueryEntityInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceQueryEntityInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceQueryEntityInlineErrors); i++ {
		if swag.IsZero(m.WorkspaceQueryEntityInlineErrors[i]) { // not required
			continue
		}

		if m.WorkspaceQueryEntityInlineErrors[i] != nil {
			if err := m.WorkspaceQueryEntityInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace query entity based on the context it is used
func (m *WorkspaceQueryEntity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCanPreview(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContentHash(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatasource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtension(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasPii(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceQueryEntityInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntity) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateAccessTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "access_time", "body", m.AccessTime); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateAttributes(ctx context.Context, formats strfmt.Registry) error {

	if m.Attributes != nil {
		if err := m.Attributes.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("attributes")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateCanPreview(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "can_preview", "body", m.CanPreview); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateContentHash(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "content_hash", "body", m.ContentHash); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateDatasource(ctx context.Context, formats strfmt.Registry) error {

	if m.Datasource != nil {
		if err := m.Datasource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datasource")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateExtension(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "extension", "body", m.Extension); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateHasPii(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "has_pii", "body", m.HasPii); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidatePermissions(ctx context.Context, formats strfmt.Registry) error {

	if m.Permissions != nil {
		if err := m.Permissions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("permissions")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateURI(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uri", "body", m.URI); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntity) contextValidateWorkspaceQueryEntityInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*WorkspaceQueryEntityInlineErrorsInlineArrayItem(m.WorkspaceQueryEntityInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.WorkspaceQueryEntityInlineErrors); i++ {

		if m.WorkspaceQueryEntityInlineErrors[i] != nil {
			if err := m.WorkspaceQueryEntityInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntity) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityInlineAttributes workspace query entity inline attributes
//
// swagger:model workspace_query_entity_inline_attributes
type WorkspaceQueryEntityInlineAttributes struct {

	// content
	Content []*WorkspaceQueryEntityAttributesContentItems0 `json:"content,omitempty"`

	// custom
	Custom []*WorkspaceQueryEntityAttributesCustomItems0 `json:"custom,omitempty"`

	// extended
	Extended []*WorkspaceQueryEntityAttributesExtendedItems0 `json:"extended,omitempty"`

	// system
	System []*WorkspaceQueryEntityAttributesSystemItems0 `json:"system,omitempty"`
}

// Validate validates this workspace query entity inline attributes
func (m *WorkspaceQueryEntityInlineAttributes) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCustom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExtended(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) validateContent(formats strfmt.Registry) error {
	if swag.IsZero(m.Content) { // not required
		return nil
	}

	for i := 0; i < len(m.Content); i++ {
		if swag.IsZero(m.Content[i]) { // not required
			continue
		}

		if m.Content[i] != nil {
			if err := m.Content[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "content" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) validateCustom(formats strfmt.Registry) error {
	if swag.IsZero(m.Custom) { // not required
		return nil
	}

	for i := 0; i < len(m.Custom); i++ {
		if swag.IsZero(m.Custom[i]) { // not required
			continue
		}

		if m.Custom[i] != nil {
			if err := m.Custom[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "custom" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) validateExtended(formats strfmt.Registry) error {
	if swag.IsZero(m.Extended) { // not required
		return nil
	}

	for i := 0; i < len(m.Extended); i++ {
		if swag.IsZero(m.Extended[i]) { // not required
			continue
		}

		if m.Extended[i] != nil {
			if err := m.Extended[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "extended" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) validateSystem(formats strfmt.Registry) error {
	if swag.IsZero(m.System) { // not required
		return nil
	}

	for i := 0; i < len(m.System); i++ {
		if swag.IsZero(m.System[i]) { // not required
			continue
		}

		if m.System[i] != nil {
			if err := m.System[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "system" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace query entity inline attributes based on the context it is used
func (m *WorkspaceQueryEntityInlineAttributes) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCustom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtended(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) contextValidateContent(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Content); i++ {

		if m.Content[i] != nil {
			if err := m.Content[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "content" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) contextValidateCustom(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Custom); i++ {

		if m.Custom[i] != nil {
			if err := m.Custom[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "custom" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) contextValidateExtended(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Extended); i++ {

		if m.Extended[i] != nil {
			if err := m.Extended[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "extended" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceQueryEntityInlineAttributes) contextValidateSystem(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.System); i++ {

		if m.System[i] != nil {
			if err := m.System[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "system" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityInlineAttributes) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityInlineAttributes) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityInlineAttributes
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityAttributesContentItems0 workspace query entity attributes content items0
//
// swagger:model WorkspaceQueryEntityAttributesContentItems0
type WorkspaceQueryEntityAttributesContentItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this workspace query entity attributes content items0
func (m *WorkspaceQueryEntityAttributesContentItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this workspace query entity attributes content items0 based on context it is used
func (m *WorkspaceQueryEntityAttributesContentItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesContentItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesContentItems0) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityAttributesContentItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityAttributesCustomItems0 workspace query entity attributes custom items0
//
// swagger:model WorkspaceQueryEntityAttributesCustomItems0
type WorkspaceQueryEntityAttributesCustomItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this workspace query entity attributes custom items0
func (m *WorkspaceQueryEntityAttributesCustomItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this workspace query entity attributes custom items0 based on context it is used
func (m *WorkspaceQueryEntityAttributesCustomItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesCustomItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesCustomItems0) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityAttributesCustomItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityAttributesExtendedItems0 workspace query entity attributes extended items0
//
// swagger:model WorkspaceQueryEntityAttributesExtendedItems0
type WorkspaceQueryEntityAttributesExtendedItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this workspace query entity attributes extended items0
func (m *WorkspaceQueryEntityAttributesExtendedItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this workspace query entity attributes extended items0 based on context it is used
func (m *WorkspaceQueryEntityAttributesExtendedItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesExtendedItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesExtendedItems0) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityAttributesExtendedItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityAttributesSystemItems0 workspace query entity attributes system items0
//
// swagger:model WorkspaceQueryEntityAttributesSystemItems0
type WorkspaceQueryEntityAttributesSystemItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this workspace query entity attributes system items0
func (m *WorkspaceQueryEntityAttributesSystemItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this workspace query entity attributes system items0 based on context it is used
func (m *WorkspaceQueryEntityAttributesSystemItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesSystemItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityAttributesSystemItems0) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityAttributesSystemItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityInlineErrorsInlineArrayItem workspace query entity inline errors inline array item
//
// swagger:model workspace_query_entity_inline_errors_inline_array_item
type WorkspaceQueryEntityInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this workspace query entity inline errors inline array item
func (m *WorkspaceQueryEntityInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntityInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace query entity inline errors inline array item based on the context it is used
func (m *WorkspaceQueryEntityInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntityInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceQueryEntityInlinePermissions The permissions of the entity.
//
// swagger:model workspace_query_entity_inline_permissions
type WorkspaceQueryEntityInlinePermissions struct {

	// key
	// Example: owner
	Key *string `json:"key,omitempty"`

	// value
	// Example: rwx
	Value *string `json:"value,omitempty"`
}

// Validate validates this workspace query entity inline permissions
func (m *WorkspaceQueryEntityInlinePermissions) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this workspace query entity inline permissions based on the context it is used
func (m *WorkspaceQueryEntityInlinePermissions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityInlinePermissions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityInlinePermissions) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityInlinePermissions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
