// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceQueryEntityResponse workspace query entity response
//
// swagger:model workspace_query_entity_response
type WorkspaceQueryEntityResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// The number of records returned.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of entities matching the workspace query criteria.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// workspace query entity response inline records
	WorkspaceQueryEntityResponseInlineRecords []*WorkspaceQueryEntity `json:"records,omitempty"`
}

// Validate validates this workspace query entity response
func (m *WorkspaceQueryEntityResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceQueryEntityResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntityResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntityResponse) validateWorkspaceQueryEntityResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceQueryEntityResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceQueryEntityResponseInlineRecords); i++ {
		if swag.IsZero(m.WorkspaceQueryEntityResponseInlineRecords[i]) { // not required
			continue
		}

		if m.WorkspaceQueryEntityResponseInlineRecords[i] != nil {
			if err := m.WorkspaceQueryEntityResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace query entity response based on the context it is used
func (m *WorkspaceQueryEntityResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceQueryEntityResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryEntityResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryEntityResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntityResponse) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_records", "body", m.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryEntityResponse) contextValidateWorkspaceQueryEntityResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WorkspaceQueryEntityResponseInlineRecords); i++ {

		if m.WorkspaceQueryEntityResponseInlineRecords[i] != nil {
			if err := m.WorkspaceQueryEntityResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryEntityResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryEntityResponse) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryEntityResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
