// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceQueryResponse workspace query response
//
// swagger:model workspace_query_response
type WorkspaceQueryResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// The number of records returned.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of queries in the workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// workspace query response inline records
	WorkspaceQueryResponseInlineRecords []*WorkspaceQuery `json:"records,omitempty"`
}

// Validate validates this workspace query response
func (m *WorkspaceQueryResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceQueryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryResponse) validateWorkspaceQueryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceQueryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceQueryResponseInlineRecords); i++ {
		if swag.IsZero(m.WorkspaceQueryResponseInlineRecords[i]) { // not required
			continue
		}

		if m.WorkspaceQueryResponseInlineRecords[i] != nil {
			if err := m.WorkspaceQueryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace query response based on the context it is used
func (m *WorkspaceQueryResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceQueryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceQueryResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceQueryResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryResponse) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_records", "body", m.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceQueryResponse) contextValidateWorkspaceQueryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.WorkspaceQueryResponseInlineRecords); i++ {

		if m.WorkspaceQueryResponseInlineRecords[i] != nil {
			if err := m.WorkspaceQueryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceQueryResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceQueryResponse) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
