// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceVersion Workspace version.
//
// swagger:model workspace_version
type WorkspaceVersion struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The unique identifier representing the version of the workspace.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	Workspace *WorkspaceVersionInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this workspace version
func (m *WorkspaceVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersion) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersion) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace version based on the context it is used
func (m *WorkspaceVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersion) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersion) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersion) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersion) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionInlineWorkspace The workspace details associated with the version.
//
// swagger:model workspace_version_inline_workspace
type WorkspaceVersionInlineWorkspace struct {

	// The creation time of the workspace version.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The count of data collection in a workspace.
	// Example: 20
	// Read Only: true
	DataCollectionCount *int64 `json:"data_collection_count,omitempty"`

	// The description of the workspace.
	// Example: Example workspace
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The count of entities in a workspace.
	// Example: 1000
	// Read Only: true
	EntityCount *int64 `json:"entity_count,omitempty"`

	// errors
	// Read Only: true
	Errors []*WorkspaceVersionWorkspaceErrorsItems0 `json:"errors,omitempty"`

	// The message associated with the current state of the workspace.
	// Example: creating workspace
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// The name of the workspace.
	// Example: Doc workspace
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The owner of the workspace.
	// Example: SAL
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// policies
	// Read Only: true
	Policies []*WorkspaceVersionWorkspacePoliciesItems0 `json:"policies,omitempty"`

	// The workspace refresh time interval in ISO-8601 format.
	// Example: PT1H
	// Read Only: true
	RefreshInterval *string `json:"refresh_interval,omitempty"`

	// space
	Space *WorkspaceVersionInlineWorkspaceInlineSpace `json:"space,omitempty"`

	// State of the workspace version:
	// * <i>processing</i> - The workspace is being processed after creation.
	// * <i>ready</i> - The workspace is ready for use.
	// * <i>failed</i> - The workspace has a failure.
	// * <i>outdated</i> - The workspace is outdated.
	// * Valid in GET.
	//
	// Example: ready
	// Read Only: true
	// Enum: ["processing","ready","failed","outdated"]
	State *string `json:"state,omitempty"`

	// The unique identifier of the workspace.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *WorkspaceVersionInlineWorkspaceInlineVersion `json:"version,omitempty"`
}

// Validate validates this workspace version inline workspace
func (m *WorkspaceVersionInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validateErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.Errors) { // not required
		return nil
	}

	for i := 0; i < len(m.Errors); i++ {
		if swag.IsZero(m.Errors[i]) { // not required
			continue
		}

		if m.Errors[i] != nil {
			if err := m.Errors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspace" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validatePolicies(formats strfmt.Registry) error {
	if swag.IsZero(m.Policies) { // not required
		return nil
	}

	for i := 0; i < len(m.Policies); i++ {
		if swag.IsZero(m.Policies[i]) { // not required
			continue
		}

		if m.Policies[i] != nil {
			if err := m.Policies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspace" + "." + "policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace" + "." + "space")
			}
			return err
		}
	}

	return nil
}

var workspaceVersionInlineWorkspaceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["processing","ready","failed","outdated"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceVersionInlineWorkspaceTypeStatePropEnum = append(workspaceVersionInlineWorkspaceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_version_inline_workspace
	// WorkspaceVersionInlineWorkspace
	// state
	// State
	// processing
	// END DEBUGGING
	// WorkspaceVersionInlineWorkspaceStateProcessing captures enum value "processing"
	WorkspaceVersionInlineWorkspaceStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// workspace_version_inline_workspace
	// WorkspaceVersionInlineWorkspace
	// state
	// State
	// ready
	// END DEBUGGING
	// WorkspaceVersionInlineWorkspaceStateReady captures enum value "ready"
	WorkspaceVersionInlineWorkspaceStateReady string = "ready"

	// BEGIN DEBUGGING
	// workspace_version_inline_workspace
	// WorkspaceVersionInlineWorkspace
	// state
	// State
	// failed
	// END DEBUGGING
	// WorkspaceVersionInlineWorkspaceStateFailed captures enum value "failed"
	WorkspaceVersionInlineWorkspaceStateFailed string = "failed"

	// BEGIN DEBUGGING
	// workspace_version_inline_workspace
	// WorkspaceVersionInlineWorkspace
	// state
	// State
	// outdated
	// END DEBUGGING
	// WorkspaceVersionInlineWorkspaceStateOutdated captures enum value "outdated"
	WorkspaceVersionInlineWorkspaceStateOutdated string = "outdated"
)

// prop value enum
func (m *WorkspaceVersionInlineWorkspace) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceVersionInlineWorkspaceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("workspace"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace version inline workspace based on the context it is used
func (m *WorkspaceVersionInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCollectionCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntityCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRefreshInterval(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateDataCollectionCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"data_collection_count", "body", m.DataCollectionCount); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateEntityCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"entity_count", "body", m.EntityCount); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"errors", "body", []*WorkspaceVersionWorkspaceErrorsItems0(m.Errors)); err != nil {
		return err
	}

	for i := 0; i < len(m.Errors); i++ {

		if m.Errors[i] != nil {
			if err := m.Errors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspace" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"owner", "body", m.Owner); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidatePolicies(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"policies", "body", []*WorkspaceVersionWorkspacePoliciesItems0(m.Policies)); err != nil {
		return err
	}

	for i := 0; i < len(m.Policies); i++ {

		if m.Policies[i] != nil {
			if err := m.Policies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspace" + "." + "policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateRefreshInterval(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"refresh_interval", "body", m.RefreshInterval); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspace) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionWorkspaceErrorsItems0 workspace version workspace errors items0
//
// swagger:model WorkspaceVersionWorkspaceErrorsItems0
type WorkspaceVersionWorkspaceErrorsItems0 struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this workspace version workspace errors items0
func (m *WorkspaceVersionWorkspaceErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionWorkspaceErrorsItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace version workspace errors items0 based on the context it is used
func (m *WorkspaceVersionWorkspaceErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionWorkspaceErrorsItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionWorkspaceErrorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionWorkspaceErrorsItems0) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionWorkspaceErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionWorkspacePoliciesItems0 workspace version workspace policies items0
//
// swagger:model WorkspaceVersionWorkspacePoliciesItems0
type WorkspaceVersionWorkspacePoliciesItems0 struct {

	// name
	// Example: Example Policy
	Name *string `json:"name,omitempty"`

	// The unique identifier of the policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *WorkspaceVersionWorkspacePoliciesItems0Version `json:"version,omitempty"`
}

// Validate validates this workspace version workspace policies items0
func (m *WorkspaceVersionWorkspacePoliciesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionWorkspacePoliciesItems0) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionWorkspacePoliciesItems0) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace version workspace policies items0 based on the context it is used
func (m *WorkspaceVersionWorkspacePoliciesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionWorkspacePoliciesItems0) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionWorkspacePoliciesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionWorkspacePoliciesItems0) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionWorkspacePoliciesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionWorkspacePoliciesItems0Version The version information of a policy.
//
// swagger:model WorkspaceVersionWorkspacePoliciesItems0Version
type WorkspaceVersionWorkspacePoliciesItems0Version struct {

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace version workspace policies items0 version
func (m *WorkspaceVersionWorkspacePoliciesItems0Version) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionWorkspacePoliciesItems0Version) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this workspace version workspace policies items0 version based on context it is used
func (m *WorkspaceVersionWorkspacePoliciesItems0Version) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionWorkspacePoliciesItems0Version) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionWorkspacePoliciesItems0Version) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionWorkspacePoliciesItems0Version
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionInlineWorkspaceInlineSpace The space detail of a workspace.
//
// swagger:model workspace_version_inline_workspace_inline_space
type WorkspaceVersionInlineWorkspaceInlineSpace struct {

	// The available space of a workspace, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The total space of a workspace, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// The used space of a workspace, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this workspace version inline workspace inline space
func (m *WorkspaceVersionInlineWorkspaceInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this workspace version inline workspace inline space based on the context it is used
func (m *WorkspaceVersionInlineWorkspaceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionInlineWorkspaceInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspaceInlineSpace) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"space"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspaceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionInlineWorkspaceInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionInlineWorkspaceInlineSpace) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionInlineWorkspaceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionInlineWorkspaceInlineVersion The version information of a workspace.
//
// swagger:model workspace_version_inline_workspace_inline_version
type WorkspaceVersionInlineWorkspaceInlineVersion struct {

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace version inline workspace inline version
func (m *WorkspaceVersionInlineWorkspaceInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionInlineWorkspaceInlineVersion) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionInlineWorkspaceInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace version inline workspace inline version based on the context it is used
func (m *WorkspaceVersionInlineWorkspaceInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionInlineWorkspaceInlineVersion) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionInlineWorkspaceInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionInlineWorkspaceInlineVersion) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionInlineWorkspaceInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
