// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WorkspaceVersionDiff Workspace version diff.
//
// swagger:model workspace_version_diff
type WorkspaceVersionDiff struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The type of change for the entities.
	// Read Only: true
	// Enum: ["added","modified","deleted","renamed"]
	ChangeType *string `json:"change_type,omitempty"`

	// data source
	DataSource *WorkspaceVersionDiffInlineDataSource `json:"data_source,omitempty"`

	// version
	Version *WorkspaceVersionDiffInlineVersion `json:"version,omitempty"`

	// Workspace containing the query.
	// Read Only: true
	Workspace *WorkspaceReference `json:"workspace,omitempty"`

	// workspace version diff inline entities
	// Read Only: true
	WorkspaceVersionDiffInlineEntities []*WorkspaceVersionDiffInlineEntitiesInlineArrayItem `json:"entities,omitempty"`
}

// Validate validates this workspace version diff
func (m *WorkspaceVersionDiff) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateChangeType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceVersionDiffInlineEntities(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionDiff) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var workspaceVersionDiffTypeChangeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["added","modified","deleted","renamed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceVersionDiffTypeChangeTypePropEnum = append(workspaceVersionDiffTypeChangeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_version_diff
	// WorkspaceVersionDiff
	// change_type
	// ChangeType
	// added
	// END DEBUGGING
	// WorkspaceVersionDiffChangeTypeAdded captures enum value "added"
	WorkspaceVersionDiffChangeTypeAdded string = "added"

	// BEGIN DEBUGGING
	// workspace_version_diff
	// WorkspaceVersionDiff
	// change_type
	// ChangeType
	// modified
	// END DEBUGGING
	// WorkspaceVersionDiffChangeTypeModified captures enum value "modified"
	WorkspaceVersionDiffChangeTypeModified string = "modified"

	// BEGIN DEBUGGING
	// workspace_version_diff
	// WorkspaceVersionDiff
	// change_type
	// ChangeType
	// deleted
	// END DEBUGGING
	// WorkspaceVersionDiffChangeTypeDeleted captures enum value "deleted"
	WorkspaceVersionDiffChangeTypeDeleted string = "deleted"

	// BEGIN DEBUGGING
	// workspace_version_diff
	// WorkspaceVersionDiff
	// change_type
	// ChangeType
	// renamed
	// END DEBUGGING
	// WorkspaceVersionDiffChangeTypeRenamed captures enum value "renamed"
	WorkspaceVersionDiffChangeTypeRenamed string = "renamed"
)

// prop value enum
func (m *WorkspaceVersionDiff) validateChangeTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceVersionDiffTypeChangeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceVersionDiff) validateChangeType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChangeType) { // not required
		return nil
	}

	// value enum
	if err := m.validateChangeTypeEnum("change_type", "body", *m.ChangeType); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiff) validateDataSource(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSource) { // not required
		return nil
	}

	if m.DataSource != nil {
		if err := m.DataSource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) validateWorkspaceVersionDiffInlineEntities(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceVersionDiffInlineEntities) { // not required
		return nil
	}

	for i := 0; i < len(m.WorkspaceVersionDiffInlineEntities); i++ {
		if swag.IsZero(m.WorkspaceVersionDiffInlineEntities[i]) { // not required
			continue
		}

		if m.WorkspaceVersionDiffInlineEntities[i] != nil {
			if err := m.WorkspaceVersionDiffInlineEntities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace version diff based on the context it is used
func (m *WorkspaceVersionDiff) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateChangeType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceVersionDiffInlineEntities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionDiff) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) contextValidateChangeType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "change_type", "body", m.ChangeType); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiff) contextValidateDataSource(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSource != nil {
		if err := m.DataSource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

func (m *WorkspaceVersionDiff) contextValidateWorkspaceVersionDiffInlineEntities(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entities", "body", []*WorkspaceVersionDiffInlineEntitiesInlineArrayItem(m.WorkspaceVersionDiffInlineEntities)); err != nil {
		return err
	}

	for i := 0; i < len(m.WorkspaceVersionDiffInlineEntities); i++ {

		if m.WorkspaceVersionDiffInlineEntities[i] != nil {
			if err := m.WorkspaceVersionDiffInlineEntities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionDiff) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionDiff) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionDiff
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionDiffInlineDataSource workspace version diff inline data source
//
// swagger:model workspace_version_diff_inline_data_source
type WorkspaceVersionDiffInlineDataSource struct {

	// The name of the data source.
	// Example: volume1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The type of the data source.
	// Read Only: true
	// Enum: ["volume","bucket"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the data source.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace version diff inline data source
func (m *WorkspaceVersionDiffInlineDataSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var workspaceVersionDiffInlineDataSourceTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","bucket"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceVersionDiffInlineDataSourceTypeTypePropEnum = append(workspaceVersionDiffInlineDataSourceTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_version_diff_inline_data_source
	// WorkspaceVersionDiffInlineDataSource
	// type
	// Type
	// volume
	// END DEBUGGING
	// WorkspaceVersionDiffInlineDataSourceTypeVolume captures enum value "volume"
	WorkspaceVersionDiffInlineDataSourceTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// workspace_version_diff_inline_data_source
	// WorkspaceVersionDiffInlineDataSource
	// type
	// Type
	// bucket
	// END DEBUGGING
	// WorkspaceVersionDiffInlineDataSourceTypeBucket captures enum value "bucket"
	WorkspaceVersionDiffInlineDataSourceTypeBucket string = "bucket"
)

// prop value enum
func (m *WorkspaceVersionDiffInlineDataSource) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceVersionDiffInlineDataSourceTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceVersionDiffInlineDataSource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("data_source"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiffInlineDataSource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_source"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace version diff inline data source based on the context it is used
func (m *WorkspaceVersionDiffInlineDataSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionDiffInlineDataSource) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_source"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiffInlineDataSource) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_source"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiffInlineDataSource) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_source"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionDiffInlineDataSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionDiffInlineDataSource) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionDiffInlineDataSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionDiffInlineEntitiesInlineArrayItem workspace version diff inline entities inline array item
//
// swagger:model workspace_version_diff_inline_entities_inline_array_item
type WorkspaceVersionDiffInlineEntitiesInlineArrayItem struct {

	// The type of the entity.
	// Enum: ["file","object"]
	EntityType *string `json:"entity_type,omitempty"`

	// The name of the entity.
	Name *string `json:"name,omitempty"`

	// The unique identifier of the entity.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace version diff inline entities inline array item
func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEntityType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var workspaceVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file","object"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum = append(workspaceVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// workspace_version_diff_inline_entities_inline_array_item
	// WorkspaceVersionDiffInlineEntitiesInlineArrayItem
	// entity_type
	// EntityType
	// file
	// END DEBUGGING
	// WorkspaceVersionDiffInlineEntitiesInlineArrayItemEntityTypeFile captures enum value "file"
	WorkspaceVersionDiffInlineEntitiesInlineArrayItemEntityTypeFile string = "file"

	// BEGIN DEBUGGING
	// workspace_version_diff_inline_entities_inline_array_item
	// WorkspaceVersionDiffInlineEntitiesInlineArrayItem
	// entity_type
	// EntityType
	// object
	// END DEBUGGING
	// WorkspaceVersionDiffInlineEntitiesInlineArrayItemEntityTypeObject captures enum value "object"
	WorkspaceVersionDiffInlineEntitiesInlineArrayItemEntityTypeObject string = "object"
)

// prop value enum
func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) validateEntityTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) validateEntityType(formats strfmt.Registry) error {
	if swag.IsZero(m.EntityType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEntityTypeEnum("entity_type", "body", *m.EntityType); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this workspace version diff inline entities inline array item based on context it is used
func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionDiffInlineEntitiesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionDiffInlineEntitiesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// WorkspaceVersionDiffInlineVersion workspace version diff inline version
//
// swagger:model workspace_version_diff_inline_version
type WorkspaceVersionDiffInlineVersion struct {

	// The unique identifier of the base version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	Base *strfmt.UUID `json:"base,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace version diff inline version
func (m *WorkspaceVersionDiffInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBase(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionDiffInlineVersion) validateBase(formats strfmt.Registry) error {
	if swag.IsZero(m.Base) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"base", "body", "uuid", m.Base.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *WorkspaceVersionDiffInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace version diff inline version based on the context it is used
func (m *WorkspaceVersionDiffInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WorkspaceVersionDiffInlineVersion) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WorkspaceVersionDiffInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WorkspaceVersionDiffInlineVersion) UnmarshalBinary(b []byte) error {
	var res WorkspaceVersionDiffInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
