// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ZappS3Bucket A generic S3 bucket application.
//
// swagger:model zapp_s3_bucket
type ZappS3Bucket struct {

	// protection type
	ProtectionType *ZappS3BucketInlineProtectionType `json:"protection_type,omitempty"`

	// The list of application components to be created.
	// Required: true
	// Max Items: 10
	// Min Items: 1
	ZappS3BucketInlineApplicationComponents []*ZappS3BucketApplicationComponents `json:"application_components"`
}

// Validate validates this zapp s3 bucket
func (m *ZappS3Bucket) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateZappS3BucketInlineApplicationComponents(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ZappS3Bucket) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *ZappS3Bucket) validateZappS3BucketInlineApplicationComponents(formats strfmt.Registry) error {

	if err := validate.Required("application_components", "body", m.ZappS3BucketInlineApplicationComponents); err != nil {
		return err
	}

	iZappS3BucketInlineApplicationComponentsSize := int64(len(m.ZappS3BucketInlineApplicationComponents))

	if err := validate.MinItems("application_components", "body", iZappS3BucketInlineApplicationComponentsSize, 1); err != nil {
		return err
	}

	if err := validate.MaxItems("application_components", "body", iZappS3BucketInlineApplicationComponentsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.ZappS3BucketInlineApplicationComponents); i++ {
		if swag.IsZero(m.ZappS3BucketInlineApplicationComponents[i]) { // not required
			continue
		}

		if m.ZappS3BucketInlineApplicationComponents[i] != nil {
			if err := m.ZappS3BucketInlineApplicationComponents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("application_components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this zapp s3 bucket based on the context it is used
func (m *ZappS3Bucket) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateZappS3BucketInlineApplicationComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ZappS3Bucket) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *ZappS3Bucket) contextValidateZappS3BucketInlineApplicationComponents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ZappS3BucketInlineApplicationComponents); i++ {

		if m.ZappS3BucketInlineApplicationComponents[i] != nil {
			if err := m.ZappS3BucketInlineApplicationComponents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("application_components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3Bucket) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3Bucket) UnmarshalBinary(b []byte) error {
	var res ZappS3Bucket
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ZappS3BucketInlineProtectionType zapp s3 bucket inline protection type
//
// swagger:model zapp_s3_bucket_inline_protection_type
type ZappS3BucketInlineProtectionType struct {

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this zapp s3 bucket inline protection type
func (m *ZappS3BucketInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var zappS3BucketInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		zappS3BucketInlineProtectionTypeTypeRemoteRpoPropEnum = append(zappS3BucketInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// zapp_s3_bucket_inline_protection_type
	// ZappS3BucketInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// ZappS3BucketInlineProtectionTypeRemoteRpoNone captures enum value "none"
	ZappS3BucketInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_inline_protection_type
	// ZappS3BucketInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// ZappS3BucketInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	ZappS3BucketInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *ZappS3BucketInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, zappS3BucketInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ZappS3BucketInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this zapp s3 bucket inline protection type based on context it is used
func (m *ZappS3BucketInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
