// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ZappS3BucketApplicationComponents The list of application components to be created.
//
// swagger:model zapp_s3_bucket_application_components
type ZappS3BucketApplicationComponents struct {

	// The type of bucket.
	// Enum: ["nas","s3"]
	BucketEndpointType *string `json:"bucket_endpoint_type,omitempty"`

	// Prefer lower latency storage under similar media costs.
	// Enum: [false,true]
	CapacityTier *bool `json:"capacity_tier,omitempty"`

	// Object Store Server Bucket Description Usage: &lt;(size 1..256)&gt;
	// Max Length: 256
	// Min Length: 1
	Comment *string `json:"comment,omitempty"`

	// Specifies the default retention period that is applied to objects while committing them to the WORM state without an associated retention period. The retention period can be in years, or days. The retention period value represents a duration and must be specified in the ISO-8601 duration format. A period specified for years and days is represented in the ISO-8601 format as quot;Plt;num&gt;Y&quot; and quot;Plt;num&gt;D&quot; respectively, for example &quot;P10Y&quot; represents a duration of 10 years. The period string must contain only a single time element that is, either years, or days. A duration which combines different periods is not supported, for example &quot;P1Y10D&quot; is not supported. Usage: {{&lt;integer&gt; days|years} | none}
	DefaultRetentionPeriod *string `json:"default_retention_period,omitempty"`

	// The name of the application component.
	// Required: true
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name"`

	// The path to which the bucket corresponds to.
	NasPath *string `json:"nas_path,omitempty"`

	// qos
	Qos *ZappS3BucketApplicationComponentsInlineQos `json:"qos,omitempty"`

	// The lock mode of the bucket. &lt;br&gt;compliance &dash; A SnapLock Compliance (SLC) bucket provides the highest level of WORM protection and an administrator cannot destroy a compliance bucket if it contains unexpired WORM objects. &lt;br&gt; governance &dash; An administrator can delete a Governance bucket.&lt;br&gt; no_lock &dash; Indicates the bucket does not support object locking. For s3 type buckets, the default value is no_lock.
	// Enum: ["compliance","governance","no_lock"]
	RetentionMode *string `json:"retention_mode,omitempty"`

	// The total size of the S3 Bucket, split across the member components. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// snapshot policy
	SnapshotPolicy *ZappS3BucketApplicationComponentsInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// storage service
	StorageService *ZappS3BucketApplicationComponentsInlineStorageService `json:"storage_service,omitempty"`

	// Object Store Server Bucket UUID Usage: &lt;UUID&gt;
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Bucket Versioning State. For nas type buckets, this field is not set. For s3 type buckets, the default value is disabled.
	// Enum: ["disabled","enabled","suspended"]
	VersioningState *string `json:"versioning_state,omitempty"`

	// The list of S3 objectstore policies to be created.
	// Max Items: 10
	// Min Items: 0
	ZappS3BucketApplicationComponentsInlineAccessPolicies []*ZappS3BucketApplicationComponentsAccessPolicies `json:"access_policies,omitempty"`

	// zapp s3 bucket application components inline exclude aggregates
	ZappS3BucketApplicationComponentsInlineExcludeAggregates []*ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem `json:"exclude_aggregates,omitempty"`
}

// Validate validates this zapp s3 bucket application components
func (m *ZappS3BucketApplicationComponents) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBucketEndpointType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapacityTier(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetentionMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersioningState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateZappS3BucketApplicationComponentsInlineAccessPolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateZappS3BucketApplicationComponentsInlineExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var zappS3BucketApplicationComponentsTypeBucketEndpointTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nas","s3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		zappS3BucketApplicationComponentsTypeBucketEndpointTypePropEnum = append(zappS3BucketApplicationComponentsTypeBucketEndpointTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// bucket_endpoint_type
	// BucketEndpointType
	// nas
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsBucketEndpointTypeNas captures enum value "nas"
	ZappS3BucketApplicationComponentsBucketEndpointTypeNas string = "nas"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// bucket_endpoint_type
	// BucketEndpointType
	// s3
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsBucketEndpointTypeS3 captures enum value "s3"
	ZappS3BucketApplicationComponentsBucketEndpointTypeS3 string = "s3"
)

// prop value enum
func (m *ZappS3BucketApplicationComponents) validateBucketEndpointTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, zappS3BucketApplicationComponentsTypeBucketEndpointTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ZappS3BucketApplicationComponents) validateBucketEndpointType(formats strfmt.Registry) error {
	if swag.IsZero(m.BucketEndpointType) { // not required
		return nil
	}

	// value enum
	if err := m.validateBucketEndpointTypeEnum("bucket_endpoint_type", "body", *m.BucketEndpointType); err != nil {
		return err
	}

	return nil
}

var zappS3BucketApplicationComponentsTypeCapacityTierPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		zappS3BucketApplicationComponentsTypeCapacityTierPropEnum = append(zappS3BucketApplicationComponentsTypeCapacityTierPropEnum, v)
	}
}

// prop value enum
func (m *ZappS3BucketApplicationComponents) validateCapacityTierEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, zappS3BucketApplicationComponentsTypeCapacityTierPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ZappS3BucketApplicationComponents) validateCapacityTier(formats strfmt.Registry) error {
	if swag.IsZero(m.CapacityTier) { // not required
		return nil
	}

	// value enum
	if err := m.validateCapacityTierEnum("capacity_tier", "body", *m.CapacityTier); err != nil {
		return err
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 63); err != nil {
		return err
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

var zappS3BucketApplicationComponentsTypeRetentionModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","governance","no_lock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		zappS3BucketApplicationComponentsTypeRetentionModePropEnum = append(zappS3BucketApplicationComponentsTypeRetentionModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// retention_mode
	// RetentionMode
	// compliance
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsRetentionModeCompliance captures enum value "compliance"
	ZappS3BucketApplicationComponentsRetentionModeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// retention_mode
	// RetentionMode
	// governance
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsRetentionModeGovernance captures enum value "governance"
	ZappS3BucketApplicationComponentsRetentionModeGovernance string = "governance"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// retention_mode
	// RetentionMode
	// no_lock
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsRetentionModeNoLock captures enum value "no_lock"
	ZappS3BucketApplicationComponentsRetentionModeNoLock string = "no_lock"
)

// prop value enum
func (m *ZappS3BucketApplicationComponents) validateRetentionModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, zappS3BucketApplicationComponentsTypeRetentionModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ZappS3BucketApplicationComponents) validateRetentionMode(formats strfmt.Registry) error {
	if swag.IsZero(m.RetentionMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateRetentionModeEnum("retention_mode", "body", *m.RetentionMode); err != nil {
		return err
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

var zappS3BucketApplicationComponentsTypeVersioningStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","suspended"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		zappS3BucketApplicationComponentsTypeVersioningStatePropEnum = append(zappS3BucketApplicationComponentsTypeVersioningStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// versioning_state
	// VersioningState
	// disabled
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsVersioningStateDisabled captures enum value "disabled"
	ZappS3BucketApplicationComponentsVersioningStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// versioning_state
	// VersioningState
	// enabled
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsVersioningStateEnabled captures enum value "enabled"
	ZappS3BucketApplicationComponentsVersioningStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components
	// ZappS3BucketApplicationComponents
	// versioning_state
	// VersioningState
	// suspended
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsVersioningStateSuspended captures enum value "suspended"
	ZappS3BucketApplicationComponentsVersioningStateSuspended string = "suspended"
)

// prop value enum
func (m *ZappS3BucketApplicationComponents) validateVersioningStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, zappS3BucketApplicationComponentsTypeVersioningStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ZappS3BucketApplicationComponents) validateVersioningState(formats strfmt.Registry) error {
	if swag.IsZero(m.VersioningState) { // not required
		return nil
	}

	// value enum
	if err := m.validateVersioningStateEnum("versioning_state", "body", *m.VersioningState); err != nil {
		return err
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateZappS3BucketApplicationComponentsInlineAccessPolicies(formats strfmt.Registry) error {
	if swag.IsZero(m.ZappS3BucketApplicationComponentsInlineAccessPolicies) { // not required
		return nil
	}

	iZappS3BucketApplicationComponentsInlineAccessPoliciesSize := int64(len(m.ZappS3BucketApplicationComponentsInlineAccessPolicies))

	if err := validate.MinItems("access_policies", "body", iZappS3BucketApplicationComponentsInlineAccessPoliciesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("access_policies", "body", iZappS3BucketApplicationComponentsInlineAccessPoliciesSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.ZappS3BucketApplicationComponentsInlineAccessPolicies); i++ {
		if swag.IsZero(m.ZappS3BucketApplicationComponentsInlineAccessPolicies[i]) { // not required
			continue
		}

		if m.ZappS3BucketApplicationComponentsInlineAccessPolicies[i] != nil {
			if err := m.ZappS3BucketApplicationComponentsInlineAccessPolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("access_policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) validateZappS3BucketApplicationComponentsInlineExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ZappS3BucketApplicationComponentsInlineExcludeAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.ZappS3BucketApplicationComponentsInlineExcludeAggregates); i++ {
		if swag.IsZero(m.ZappS3BucketApplicationComponentsInlineExcludeAggregates[i]) { // not required
			continue
		}

		if m.ZappS3BucketApplicationComponentsInlineExcludeAggregates[i] != nil {
			if err := m.ZappS3BucketApplicationComponentsInlineExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this zapp s3 bucket application components based on the context it is used
func (m *ZappS3BucketApplicationComponents) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateZappS3BucketApplicationComponentsInlineAccessPolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateZappS3BucketApplicationComponentsInlineExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ZappS3BucketApplicationComponents) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) contextValidateZappS3BucketApplicationComponentsInlineAccessPolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ZappS3BucketApplicationComponentsInlineAccessPolicies); i++ {

		if m.ZappS3BucketApplicationComponentsInlineAccessPolicies[i] != nil {
			if err := m.ZappS3BucketApplicationComponentsInlineAccessPolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("access_policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ZappS3BucketApplicationComponents) contextValidateZappS3BucketApplicationComponentsInlineExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ZappS3BucketApplicationComponentsInlineExcludeAggregates); i++ {

		if m.ZappS3BucketApplicationComponentsInlineExcludeAggregates[i] != nil {
			if err := m.ZappS3BucketApplicationComponentsInlineExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponents) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponents) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketApplicationComponents
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem zapp s3 bucket application components inline exclude aggregates inline array item
//
// swagger:model zapp_s3_bucket_application_components_inline_exclude_aggregates_inline_array_item
type ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem struct {

	// The name of the aggregate to exclude. Usage: &lt;aggregate name&gt;
	Name *string `json:"name,omitempty"`

	// The ID of the aggregate to exclude. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this zapp s3 bucket application components inline exclude aggregates inline array item
func (m *ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this zapp s3 bucket application components inline exclude aggregates inline array item based on context it is used
func (m *ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketApplicationComponentsInlineExcludeAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ZappS3BucketApplicationComponentsInlineQos zapp s3 bucket application components inline qos
//
// swagger:model zapp_s3_bucket_application_components_inline_qos
type ZappS3BucketApplicationComponentsInlineQos struct {

	// policy
	Policy *ZappS3BucketApplicationComponentsInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this zapp s3 bucket application components inline qos
func (m *ZappS3BucketApplicationComponentsInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ZappS3BucketApplicationComponentsInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this zapp s3 bucket application components inline qos based on the context it is used
func (m *ZappS3BucketApplicationComponentsInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ZappS3BucketApplicationComponentsInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineQos) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketApplicationComponentsInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ZappS3BucketApplicationComponentsInlineQosInlinePolicy zapp s3 bucket application components inline qos inline policy
//
// swagger:model zapp_s3_bucket_application_components_inline_qos_inline_policy
type ZappS3BucketApplicationComponentsInlineQosInlinePolicy struct {

	// The name of an existing QoS policy.
	Name *string `json:"name,omitempty"`

	// The UUID of an existing QoS policy. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this zapp s3 bucket application components inline qos inline policy
func (m *ZappS3BucketApplicationComponentsInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this zapp s3 bucket application components inline qos inline policy based on context it is used
func (m *ZappS3BucketApplicationComponentsInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketApplicationComponentsInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ZappS3BucketApplicationComponentsInlineSnapshotPolicy zapp s3 bucket application components inline snapshot policy
//
// swagger:model zapp_s3_bucket_application_components_inline_snapshot_policy
type ZappS3BucketApplicationComponentsInlineSnapshotPolicy struct {

	// The name of the snapshot policy that is used for the S3 bucket.
	Name *string `json:"name,omitempty"`

	// The UUID of the snapshot policy that is used for the S3 bucket. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this zapp s3 bucket application components inline snapshot policy
func (m *ZappS3BucketApplicationComponentsInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this zapp s3 bucket application components inline snapshot policy based on context it is used
func (m *ZappS3BucketApplicationComponentsInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketApplicationComponentsInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ZappS3BucketApplicationComponentsInlineStorageService zapp s3 bucket application components inline storage service
//
// swagger:model zapp_s3_bucket_application_components_inline_storage_service
type ZappS3BucketApplicationComponentsInlineStorageService struct {

	// The storage service of the application component.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this zapp s3 bucket application components inline storage service
func (m *ZappS3BucketApplicationComponentsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var zappS3BucketApplicationComponentsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		zappS3BucketApplicationComponentsInlineStorageServiceTypeNamePropEnum = append(zappS3BucketApplicationComponentsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components_inline_storage_service
	// ZappS3BucketApplicationComponentsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsInlineStorageServiceNameExtreme captures enum value "extreme"
	ZappS3BucketApplicationComponentsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components_inline_storage_service
	// ZappS3BucketApplicationComponentsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsInlineStorageServiceNamePerformance captures enum value "performance"
	ZappS3BucketApplicationComponentsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// zapp_s3_bucket_application_components_inline_storage_service
	// ZappS3BucketApplicationComponentsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ZappS3BucketApplicationComponentsInlineStorageServiceNameValue captures enum value "value"
	ZappS3BucketApplicationComponentsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ZappS3BucketApplicationComponentsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, zappS3BucketApplicationComponentsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ZappS3BucketApplicationComponentsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this zapp s3 bucket application components inline storage service based on context it is used
func (m *ZappS3BucketApplicationComponentsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ZappS3BucketApplicationComponentsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ZappS3BucketApplicationComponentsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
