/*
 * Autogenerated file
 * Generated on July 15, 2024 at 10:38:33 PM UTC
 */

/**
 * SYMbol API values.
 * The API values are defined in the following sub-objects:
 *   constant - String and numeric constant values
 *   returnCode - Return code values
 *   enum - Enumeration definitions
 *   procedure - Procedure names
 *   procTimeout - Procedure timeouts, in seconds
 */
var symbolAPI = {};

/**
 * SYMbol Constants
 */
symbolAPI.constant = {
   /**
    * null
    * @const
    * @type {string}
    */
   MANAGEMENT_CLASS: 'devmgr.v1190api6.Manager',

   /**
    * This constant specifies no timeout on the ARVM connectivity test.
    * @const
    * @type {number}
    */
   ARVM_CONNECTIVITY_TEST_NO_TIMEOUT: -1,

   /**
    * This constant is used to specify that synchronization intervals for an asynchronous remote mirror group will be manually started by the user.
    * @const
    * @type {number}
    */
   ARVM_MANUAL_SYNC_INTERVAL: 0,

   /**
    * This constant represents the recovery point timestamp that indicates a recovery point does not exist.
    * @const
    * @type {number}
    */
   ARVM_NO_RECOVERY_POINT_TIMESTAMP: 0,

   /**
    * This constant is used to specify that a recovery point age threshold has not been set. No warning will be given due to recovery point age.
    * @const
    * @type {number}
    */
   ARVM_RECOVERY_POINT_AGE_THRESHOLD_NONE: 0,

   /**
    * This constant specifies no client-imposed/requested limit on the size of the sample list returned by getAsyncMirrorSyncStatistics. It is used with the AsyncMirrorSyncStatisticsRequestDescriptor::sampleLimit field.
    * @const
    * @type {number}
    */
   ARVM_STATISTICS_SAMPLE_LIST_NO_LIMIT: 0,

   /**
    * This constant is used to specify that a sync completion time threshold has not been set. No warning will be given for lengthy sync intervals.
    * @const
    * @type {number}
    */
   ARVM_SYNC_COMPLETION_TIME_THRESHOLD_NONE: 0,

   /**
    * This constant specifies the RPC authentication type identifier.
    * @const
    * @type {number}
    */
   AUTH_SYMBOL: 0xAABBCC01,

   /**
    * This constant specifies that SYMbolAuthenticationHMAC256 will be used for the RPC message authentication field.
    * @const
    * @type {number}
    */
   AUTH_SYMBOL_HMAC256: 0xAABBCC02,

   /**
    * This constant specifies that the SYMbol authentication process is being handled internally to the controller. This authentication type is only allowed from processes internal to a single controller. Procedures with this authentication type will be rejected from any external source (out-of-band through the management ports or in-band through the UTM).
    * @const
    * @type {number}
    */
   AUTH_SYMBOL_INTERNAL: 0xAABBCC03,

   /**
    * This constant is used where the interface requires a channel port number, but the number is unknown.
    * @const
    * @type {number}
    */
   CHANNEL_PORT_UNKNOWN: -1,

   /**
    * This constant is used to initialize the maximum IOPs and maximum MB/s values for the performance limits for a host cluster. A value of zero means that no performance limitations have been set.
    * @const
    * @type {number}
    */
   CLUSTER_PERFORMANCE_LIMIT_DEFAULT_VALUE: 0,

   /**
    * This constant specifies the number of bytes in a controller reference.
    * @const
    * @type {number}
    */
   CONTROLLER_REF_BYTES: 12,

   /**
    * This constant specifies the value of a null DDC (diagnostic data capture) tag. It is used to indicate that there is no diagnostic data available.
    * @const
    * @type {number}
    */
   DDC_NULL_TAG: 0x00,

   /**
    * This constant specifies that all channels will be used for the loopback data test.
    * @const
    * @type {number}
    */
   DIAG_ALL_CHANNELS: -1,

   /**
    * This constant specifies the size of the loopback data pattern.
    * @const
    * @type {number}
    */
   DIAG_PATTERN_SIZE: 64,

   /**
    * This value indicates the default (or recommended value) should be used for the disk pool attribute. Each volume candidate will decide on the optimal reserved space (in drives) to use for reconstructionReservedDriveCount.
    * @const
    * @type {number}
    */
   DISK_POOL_USE_DEFAULTS: 0xFFFF,

   /**
    * This constant is used in the dplCoreDumpTag field in DPLCoreDumpData to indicate there is no DPL core dump to retrieve.
    * @const
    * @type {number}
    */
   DPL_CORE_DUMP_NULL_TAG: 0,

   /**
    * This constant specifies a "wildcard" value that can appear in any byte of a firmware version specifier that is part of the CompatibleFirmware object. When checking to see if it is legal to downgrade from the array's current firmware level to an earlier level, a host application should obtain the array of CompatibleFirmware objects from the controller and see if any element of the array "matches" the firmware level that is to be installed for the downgrade. When checking for a match, the wildcard value is to be interpreted as a "match anything" indicator.
    * @const
    * @type {number}
    */
   FW_VERSION_WILDCARD: 0xFF,

   /**
    * This constant specifies the number of bytes that are present in the opaque data associated with a HostPort object's name
    * @const
    * @type {number}
    */
   HOST_PORT_NAME_BYTES: 8,

   /**
    * Indicate that a Host in the storage partitions topology database has an invalid type index. Firmware downgraded with fewer supported host types.
    * @const
    * @type {number}
    */
   HOST_TYPE_INDEX_INVALID: -1,

   /**
    * This constant represents the number of bytes in an Infiniband host port name.
    * @const
    * @type {number}
    */
   IB_HOST_PORT_NAME_BYTES: 16,

   /**
    * This constant is used in the iocDumpTag field in iocDumpData to indicate there is no IOC Dump to retrieve.
    * @const
    * @type {number}
    */
   IOC_DUMP_NULL_TAG: 0,

   /**
    * This constant specifies the number of bytes that are present in an IP address that conforms to version 4 of the Internet protocol.
    * @const
    * @type {number}
    */
   IPV4_ADDRESS_BYTES: 4,

   /**
    * This constant specifies the number of bytes that are present in an IP address that conforms to version 6 of the Internet protocol.
    * @const
    * @type {number}
    */
   IPV6_ADDRESS_BYTES: 16,

   /**
    * This constant specifies the number of bytes that are present in data type IscsiAlias.
    * @const
    * @type {number}
    */
   ISCSI_ALIAS_BYTES: 255,

   /**
    * The number of the default TCP port where the storage array listens for new iSCSI connections.
    * @const
    * @type {number}
    */
   ISCSI_DEFAULT_TCP_LISTEN_PORT: 3260,

   /**
    * This constant specifies the number of bytes that are present in data type IscsiSessionId.
    * @const
    * @type {number}
    */
   ISCSI_ISID_BYTES: 6,

   /**
    * This constant specifies the number of bytes that are present in data type IscsiName.
    * @const
    * @type {number}
    */
   ISCSI_NAME_BYTES: 223,

   /**
    * The number of the default TCP port where the iSNS server listens for new connections.
    * @const
    * @type {number}
    */
   ISNS_SERVER_DEFAULT_TCP_LISTEN_PORT: 3205,

   /**
    * This constant specifies the maximum length of an IP or domain address to a key management server.
    * @const
    * @type {number}
    */
   KEY_MGMT_SERVER_MAX_URL: 253,

   /**
    * This constant specifies the length of the key for a Key-Value tag.
    * @const
    * @type {number}
    */
   KEY_VALUE_TAG_KEY_LENGTH: 16,

   /**
    * This constant specifies the length of the value in a Key-Value tag.
    * @const
    * @type {number}
    */
   KEY_VALUE_TAG_VALUE_LENGTH: 60,

   /**
    * This constant specifies the maximum length for a Common Name used to generate a KMS CSR.
    * @const
    * @type {number}
    */
   KMS_CSR_MAX_COMMON_NAME_LENGTH: 128,

   /**
    * This constant specifies the maximum length for a Country Name used to generate a KMS CSR.
    * @const
    * @type {number}
    */
   KMS_CSR_MAX_COUNTRY_NAME_LENGTH: 2,

   /**
    * This constant specifies the maximum length for a Locality Name used to generate a KMS CSR.
    * @const
    * @type {number}
    */
   KMS_CSR_MAX_LOCALITY_NAME_LENGTH: 256,

   /**
    * This constant specifies the maximum length for an Organizational Unit Name used to generate a KMS CSR.
    * @const
    * @type {number}
    */
   KMS_CSR_MAX_ORGANIZATIONAL_UNIT_NAME_LENGTH: 64,

   /**
    * This constant specifies the maximum length for an Organization Name used to generate a KMS CSR.
    * @const
    * @type {number}
    */
   KMS_CSR_MAX_ORGANIZATION_NAME_LENGTH: 128,

   /**
    * This constant specifies the maximum length for a State/Province Name used to generate a KMS CSR.
    * @const
    * @type {number}
    */
   KMS_CSR_MAX_STATE_PROVINCE_NAME_LENGTH: 256,

   /**
    * This constant specifies the number of bytes that are present in data type MacAddress.
    * @const
    * @type {number}
    */
   MAC_ADDRESS_BYTES: 6,

   /**
    * This constant specifies the maximum tray ID number that may be set for the controller tray using the updateTray procedure. This element is now deprecated: It is still supported but will become obsolete at some point in the future. The constant MAX_CONFIGURABLE_TRAY_ID should be used instead.
    * @const
    * @type {number}
    */
   MAX_ALLOWED_CTRL_TRAY_ID_NUMBER: 99,

   /**
    * This constant specifies the maximum number of channels (source and destination).
    * @const
    * @type {number}
    */
   MAX_CHANNELS: 6,

   /**
    * This is the maximum length of the label of a component referred to in the ComponentLocationRelative struct. The ComponentLocationRelative struct is part of the ComponentLocation union which appears in the MelEntry struct.
    * @const
    * @type {number}
    */
   MAX_COMPONENT_LABEL_LENGTH: 8,

   /**
    * This constant specifies the maximum tray ID number that may be set for a tray (of any type) using the updateTray procedure.
    * @const
    * @type {number}
    */
   MAX_CONFIGURABLE_TRAY_ID: 99,

   /**
    * This constant specifies the maximum "chunk size" in bytes that can be used when transferring segments of a diagnostic data capture image to the management client. If necessary, a DDC image may be segmented into blocks that are no larger than this value, and transferred iteratively from controller to client.
    * @const
    * @type {number}
    */
   MAX_DDC_CHUNK: 131072,

   /**
    * This constant specifies the maximum size in bytes of a debug info "chunk" that can be transferred to a management client using the getControllerDebugInformation procedure.
    * @const
    * @type {number}
    */
   MAX_DEBUG_INFO_CHUNK_SIZE: 0x00580000,

   /**
    * This constant specifies the maximum number of DNS servers that may be configured.
    * @const
    * @type {number}
    */
   MAX_DNS_SERVER_COUNT: 2,

   /**
    * The maximum size of the payload portion of a jumbo ethernet frame.
    * @const
    * @type {number}
    */
   MAX_ETHERNET_JUMBO_PAYLOAD_SIZE: 9000,

   /**
    * The maximum size of the payload portion of a standard ethernet frame.
    * @const
    * @type {number}
    */
   MAX_ETHERNET_STANDARD_PAYLOAD_SIZE: 1500,

   /**
    * Maximum length of the Label field in the ExtendedComponentLocation structure
    * @const
    * @type {number}
    */
   MAX_EXT_COMP_LOCATION_LABEL_LENGTH: 16,

   /**
    * This constant specifies the maximum number of Fibre Channel interfaces per physical drive.
    * @const
    * @type {number}
    */
   MAX_FIBRE_INTERFACES: 2,

   /**
    * This constant specifies the maximum "chunk size" that can be used when downloading segments of a new firmware image to the array. If necessary, a firmware image must be segmented into blocks that are no larger than this value, and transferred iteratively to the controller.
    * @const
    * @type {number}
    */
   MAX_FW_CHUNK: 32768,

   /**
    * This constant specifies the maximum string length for the firmware prefix.
    * @const
    * @type {number}
    */
   MAX_FW_PREFIX_LENGTH: 15,

   /**
    * This constant specifies the maximum user-selectable value for an iSCSI TCP listening port number. This value applies for both the storage array and the iSNS server.
    * @const
    * @type {number}
    */
   MAX_ISCSI_SELECTABLE_TCP_PORT: 65535,

   /**
    * This constant specifies the maximum number of NTP servers that may be configured.
    * @const
    * @type {number}
    */
   MAX_NTP_SERVER_COUNT: 2,

   /**
    * This is the max number of parent-child MEL relative component location relationships.
    * @const
    * @type {number}
    */
   MAX_NUMBER_OF_PARENTS: 4,

   /**
    * This constant specifies the maximum value for the outbound packet priority setting of an iSCSI interface.
    * @const
    * @type {number}
    */
   MAX_OUTBOUND_PACKET_PRIORITY: 7,

   /**
    * Maximum number of entries in the parent array in the ComponentRelativeLocation structure. (MEL_MAX_COMP_LOCATION_SIDE - (4*4BYTES)) / (2*4 BYTES) = 5 parents.
    * @const
    * @type {number}
    */
   MAX_PARENT_DEPTH: 5,

   /**
    * This constant specifies the maximum number of trays supported in SYMbol configurations.
    * @const
    * @type {number}
    */
   MAX_SA_TRAYS: 64,

   /**
    * This constant specifies the maximum size for a collection of snapshots submitted to the disableSnapshotCollection and recreateSnapshotCollection procedures.
    * @const
    * @type {number}
    */
   MAX_SNAPSHOT_COLLECTION_SIZE: 64,

   /**
    * This constant specifies the maximum number of test IDs.
    * @const
    * @type {number}
    */
   MAX_TEST_ID: 3,

   /**
    * This constant specifies the maximum number of test results which is MAX_TEST_ID * MAX_CHANNELS.
    * @const
    * @type {number}
    */
   MAX_TEST_RESULTS: 18,

   /**
    * This constant specifies the maximum value for the VLAN (Virtual LAN) identifier setting of an iSCSI interface.
    * @const
    * @type {number}
    */
   MAX_VLAN_ID: 4094,

   /**
    * This constant specifies the maximum number of management client records that can be used.
    * @const
    * @type {number}
    */
   MCR_MAX_RECORD_NUM: 1023,

   /**
    * This constant specifies the maximum number of management client records to transfer at one time.
    * @const
    * @type {number}
    */
   MCR_MAX_XFER_COUNT: 128,

   /**
    * This constant specifies the number of "user groups" defined for the management client record feature.
    * @const
    * @type {number}
    */
   MCR_TOTAL_GROUP_COUNT: 6,

   /**
    * A constant specifying the maximum size (in bytes) allowed for the componentLocation field in a MelEntry
    * @const
    * @type {number}
    */
   MEL_MAX_COMP_LOCATION_SIZE: 60,

   /**
    * This constant specifies the maximum number of Major Event Log entries that can be obtained in one transfer operation. If more entries than this need to be obtained, the user must iterate, performing multiple fetches.
    * @const
    * @type {number}
    */
   MEL_MAX_XFER_COUNT: 64,

   /**
    * This constant specifies the minimum tray ID number that may be set for the controller tray using the updateTray procedure. This element is now deprecated: It is still supported but will become obsolete at some point in the future. The constant MIN_CONFIGURABLE_TRAY_ID should be used instead.
    * @const
    * @type {number}
    */
   MIN_ALLOWED_CTRL_TRAY_ID_NUMBER: 0,

   /**
    * This constant specifies the minimum tray ID number that may be set for a tray (of any type) using the updateTray procedure.
    * @const
    * @type {number}
    */
   MIN_CONFIGURABLE_TRAY_ID: 0,

   /**
    * This constant specifies the minimum user-selectable value for an iSCSI TCP port number. This value applies for both the storage array and the iSNS server.
    * @const
    * @type {number}
    */
   MIN_ISCSI_SELECTABLE_TCP_PORT: 49152,

   /**
    * This constant specifies the minimum value for the outbound packet priority setting of an iSCSI interface.
    * @const
    * @type {number}
    */
   MIN_OUTBOUND_PACKET_PRIORITY: 1,

   /**
    * This constant specifies the minimum value for the VLAN (Virtual LAN) identifier setting of an iSCSI interface.
    * @const
    * @type {number}
    */
   MIN_VLAN_ID: 1,

   /**
    * Smallest volume that can be created: 0 MB in bytes. This functionality is now handled within the firmware and not in SYMbol.
    * @const
    * @type {number}
    */
   MIN_VOLUME_SIZE: 0x000000,

   /**
    * The number of RAID implementation algorithms supported by the firmware. The algorithms are numbered 0,,(NUMBER_OF_ALGORITHMS - 1), and the actual algorithm for a given algorithm number depends on the RAID level.
    * @const
    * @type {number}
    */
   NUMBER_OF_ALGORITHMS: 6,

   /**
    * This constant specifies the number of bytes in the SFP's Vendor OUI field.
    * @const
    * @type {number}
    */
   NUMBER_OUI_BYTES: 3,

   /**
    * Number of bytes in an NVMe 128-bit (Extended) Host Identifier.
    * @const
    * @type {number}
    */
   NVMEOF_HOST_ID_BYTES: 16,

   /**
    * Maximum length of a NVMe Qualified Name (NQN) string.
    * @const
    * @type {number}
    */
   NVMEOF_NAME_BYTES: 223,

   /**
    * This constant specifies the nvsramVersion field in the StagedFirmware structure.
    * @const
    * @type {number}
    */
   NVSRAM_VERSION_LENGTH: 17,

   /**
    * An explicit volume parity check operation was pre-empted. This constant is deprecated (because the function that reports it, getParityCheckProgress, is deprecated.)
    * @const
    * @type {number}
    */
   PARITY_CHK_INTERRUPTED: -5,

   /**
    * An explicit volume parity check operation failed due to an I/O error. This constant is deprecated (because the function that reports it, getParityCheckProgress, is deprecated.)
    * @const
    * @type {number}
    */
   PARITY_CHK_IOERROR: -3,

   /**
    * An explicit volume parity check operation detected the present of a data/parity mismatch. This constant is deprecated (because the function that reports it, getParityCheckProgress, is deprecated.)
    * @const
    * @type {number}
    */
   PARITY_CHK_MISMATCH: -2,

   /**
    * A request for progress information for an explicit volume parity check operation failed because there is no such operation in progress for the specified volume. This constant is deprecated (because the function that reports it, getParityCheckProgress, is deprecated.)
    * @const
    * @type {number}
    */
   PARITY_CHK_NOTRUNNING: -4,

   /**
    * An explicit volume parity check operation completed successfully, and detected no data/parity mismatches. This constant is deprecated (because the function that reports it, getParityCheckProgress, is deprecated.)
    * @const
    * @type {number}
    */
   PARITY_CHK_SUCCESSFUL: -1,

   /**
    * This constant specifies the maximum number of bytes allowed for passwords. It is defined to be twice the size of PASSWD_MAX_CHARS, since SYMbol will always use double-byte characters for label strings.
    * @const
    * @type {number}
    */
   PASSWD_MAX_BYTES: 60,

   /**
    * This constant specifies the maximum number of characters allowed for passwords.
    * @const
    * @type {number}
    */
   PASSWD_MAX_CHARS: 30,

   /**
    * This constant indicates that the percentage endurance used is either inaccessible or not populated in this release.
    * @const
    * @type {number}
    */
   PERCENTAGE_ENDURANCE_USED_UNKNOWN: -1,

   /**
    * This constant is used where a long-running operation would normally report a percentage complete value, but the operation is not actually running.
    * @const
    * @type {number}
    */
   PERCENT_COMPLETE_OP_NOT_RUNNING: -1,

   /**
    * This constant is used where a long-running operation would normally report a percentage complete value, but the current value is unknown at the time of the request.
    * @const
    * @type {number}
    */
   PERCENT_COMPLETE_UNKNOWN: -3,

   /**
    * This is the size of the PSID string.
    * @const
    * @type {number}
    */
   PHYSICAL_SECURITY_ID_SIZE: 32,

   /**
    * This constant is used to specify an auto-delete limit on PITGroups and PITConsistencyGroup if auto-delete is disabled.
    * @const
    * @type {number}
    */
   PIT_AUTO_DELETE_DISABLED: 0,

   /**
    * This constant specifies the TCP and UDP port number that is used for SYMbol protocol interactions. The specified port has been assigned through the IETF/IANA organization to avoid conflicts with other compliant applications.
    * @const
    * @type {number}
    */
   PORT: 2463,

   /**
    * This constant specifies the number of bytes that are used in the opaque data of a SYMbolRef.
    * @const
    * @type {number}
    */
   REF_BYTES: 20,

   /**
    * This constant is used where repository utilization would normally report a byte count but the value is not known at the time of the request.
    * @const
    * @type {number}
    */
   REPOSITORY_UTILIZATION_UNKNOWN: -1,

   /**
    * This constant specifies the maximum number of samples allowed for remote volume mirror communication check.
    * @const
    * @type {number}
    */
   RVM_MAX_SAMPLE_TIMES: 256,

   /**
    * This constant specifies the number of byte used to store a SAS address.
    * @const
    * @type {number}
    */
   SAS_ADDRESS_BYTES: 8,

   /**
    * Max length of the name associated with an SNMP Community.
    * @const
    * @type {number}
    */
   SNMP_COMMUNITY_NAME_MAX_LENGTH: 31,

   /**
    * This constant specifies the maximum length of a SNMP USM (User-based Security Model) engine ID.
    * @const
    * @type {number}
    */
   SNMP_USM_ENGINE_ID_MAX_LENGTH: 32,

   /**
    * This constant specifies the maximum length for a SNMP USM password.
    * @const
    * @type {number}
    */
   SNMP_USM_PASSWORD_MAX_LENGTH: 128,

   /**
    * This constant specifies the maximum length of a SNMP USM user name.
    * @const
    * @type {number}
    */
   SNMP_USM_USERNAME_MAX_LENGTH: 31,

   /**
    * This constant specifies an unknown/invalid drive speed.
    * @const
    * @type {number}
    */
   SPINDLE_SPEED_UNKNOWN: -1,

   /**
    * The number of the default UDP port used by the array for delivering MEL events to a syslog server.
    * @const
    * @type {number}
    */
   SYSLOG_DEFAULT_UDP_PORT: 514,

   /**
    * This constant is used where a long-running operation would normally report a time-to-complete value, but the value is not known.
    * @const
    * @type {number}
    */
   TIME_TO_COMPLETION_UNKNOWN: -1,

   /**
    * This constant is the maximum number of entries possible in any of the port's Operational, Local, and Remote Priority-base Flow Control Summary tables. An entry will be provided for each application protocol exchanged via Data Center Bridging Capability Exchange (DCBX).
    * @const
    * @type {number}
    */
   TLV_MAX_PROTOCOL_ENTRIES: 8,

   /**
    * This constant is used for several fields identification purposes.
    * @const
    * @type {number}
    */
   TLV_OCTETS: 255,

   /**
    * The maximum length of the "asset tag" tray attribute.
    * @const
    * @type {number}
    */
   TRAY_ATTR_ASSET_TAG_MAX_LENGTH: 10,

   /**
    * The maximum length of the "chassis name" tray attribute.
    * @const
    * @type {number}
    */
   TRAY_ATTR_CHASSIS_NAME_MAX_LENGTH: 32,

   /**
    * The maximum length of the "service tag" tray attribute.
    * @const
    * @type {number}
    */
   TRAY_ATTR_SERVICE_TAG_MAX_LENGTH: 10,

   /**
    * Used when the tray position is unknown.
    * @const
    * @type {number}
    */
   TRAY_POSITION_UNKNOWN: -1,

   /**
    * Length of a time zone identifier.
    * @const
    * @type {number}
    */
   TZ_ID_LENGTH: 40,

   /**
    * This constant specifies the maximum number of bytes allowed in a user-assigned label. It is defined to be twice the size of UAL_MAX_CHARS, since SYMbol will always use double-byte characters for label strings.
    * @const
    * @type {number}
    */
   UAL_MAX_BYTES: 60,

   /**
    * This constant specifies the maximum number of characters allowed in a user-assigned label. Such labels are currently supported for volume names and storage array names.
    * @const
    * @type {number}
    */
   UAL_MAX_CHARS: 30,

   /**
    * This constant specifies the number of bytes that are used for firmware version identifiers.
    * @const
    * @type {number}
    */
   VERSION_BYTES: 4,

   /**
    * This constant specifies the current version of the controller structure and substructures.
    * @const
    * @type {number}
    */
   VERSION_CONTROLLER_STRUCT: 68,

   /**
    * This constant specifies the current version of the tray position structure.
    * @const
    * @type {number}
    */
   VERSION_TRAY_POSITION_STRUCT: 2
};

/**
 * SYMbol Return Codes
 * @enum {string}
 */
symbolAPI.returnCode = {
   /**
    * Value when an object has not been initialized
    * @const
    * @type {string}
    */
   uninitialized: 'uninitialized',

   /**
    * The operation completed successfully.
    * @const
    * @type {string}
    */
   ok: 'ok',

   /**
    * The operation cannot complete because either (1) the current state of a component does not allow the operation to be completed, (2) the operation has been disabled in NVSRAM (example, you are modifying media scan parameters when that option (offset 0x31, bit 5) is disabled), or (3) there is a problem with the storage array. Please check your storage array and its various components for possible problems and then retry the operation.
    * @const
    * @type {string}
    */
   error: 'error',

   /**
    * The operation cannot complete because a controller resource is being used by another process. If there are other array management operations in progress, wait for them to complete, and then retry the operation. If this message persists after all operations have completed, contact technical support.
    * @const
    * @type {string}
    */
   busy: 'busy',

   /**
    * The operation cannot complete because of an incorrect parameter in the command sent to the controller. Please retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   illegalParam: 'illegalParam',

   /**
    * An out of memory error occurred on one of the controllers in the storage array. Contact your Technical Support Representative about the memory requirements for this storage array.
    * @const
    * @type {string}
    */
   noHeap: 'noHeap',

   /**
    * The operation cannot complete because one or more specified drives do not exist. Please specify only drives currently installed in the storage array and then retry the operation.
    * @const
    * @type {string}
    */
   driveNotExist: 'driveNotExist',

   /**
    * The operation cannot complete because one or more specified drives do not have an unassigned status. Please specify only drives with an unassigned status and then retry the operation.
    * @const
    * @type {string}
    */
   driveNotUnassigned: 'driveNotUnassigned',

   /**
    * No hot spare drives were assigned. Possible causes include (1) the maximum number of hot spare drives that can be assigned automatically have already been assigned or (2) the maximum number of hot spares for the entire storage array have been assigned, (3) there are no more unassigned drives available, or (4) any remaining unassigned drives have capacities that are smaller than all other drives in the storage array. If you suspect the first cause, manually assign more hot spare drives. If you suspect the fourth cause, obtain the selected drives' capacity.
    * @const
    * @type {string}
    */
   noSparesAssigned: 'noSparesAssigned',

   /**
    * Not all of the requested unassigned drives were assigned as hot spares. Determine which drives were assigned. Possible causes include (1) the maximum number of hot spares have been assigned or (2) some of the unassigned drives have capacities that are smaller than all other drives in the storage array. If you suspect the second cause, obtain the unassigned drives' capacity.
    * @const
    * @type {string}
    */
   someSparesAssigned: 'someSparesAssigned',

   /**
    * The specified volume does not exist. The volume may have been deleted by a user on another management station accessing this storage array.
    * @const
    * @type {string}
    */
   volumeNotExist: 'volumeNotExist',

   /**
    * The operation cannot complete because a volume is performing a modification operation. Please wait until the modification completes and then retry the operation.
    * @const
    * @type {string}
    */
   volumeReconfiguring: 'volumeReconfiguring',

   /**
    * The operation cannot complete because the controllers in the storage array must be online.
    * @const
    * @type {string}
    */
   notDualActive: 'notDualActive',

   /**
    * This operation must be performed by the alternate controller.
    * @const
    * @type {string}
    */
   tryAlternate: 'tryAlternate',

   /**
    * An operation is running in the background.
    * @const
    * @type {string}
    */
   background: 'background',

   /**
    * This option is currently not implemented.
    * @const
    * @type {string}
    */
   notImplemented: 'notImplemented',

   /**
    * The operation cannot complete because an application has reserved the selected volume. Please wait until the volume has been released and then retry the operation.
    * @const
    * @type {string}
    */
   reservationConflict: 'reservationConflict',

   /**
    * The operation cannot complete because either the volume remains failed or has transitioned to failed. Please use the Recovery Guru to resolve the problem.
    * @const
    * @type {string}
    */
   volumeDead: 'volumeDead',

   /**
    * The operation cannot complete because of an internal target error. Please retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   internalError: 'internalError',

   /**
    * The operation cannot complete because of a general configuration request error. Please retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   invalidRequest: 'invalidRequest',

   /**
    * The operation cannot complete because there is a communications failure between the controllers. Please turn the power to the controller tray off and then on and then retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   iconFailure: 'iconFailure',

   /**
    * The operation cannot complete because a volume initialization is in progress. Please wait until the initialization completes and then retry the operation.
    * @const
    * @type {string}
    */
   volumeFormatting: 'volumeFormatting',

   /**
    * The operation cannot complete because the other controller is not present. Please insert the other controller and retry the operation.
    * @const
    * @type {string}
    */
   altRemoved: 'altRemoved',

   /**
    * The operation cannot complete because the cache between the controllers could not be synchronized. This normally occurs if the controller's alternate pair has not completed its start-of-day routine. Please wait at least two minutes and then retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   cacheSyncFailure: 'cacheSyncFailure',

   /**
    * The download cannot complete because a file is not valid. Replace the file and retry the operation.
    * @const
    * @type {string}
    */
   invalidFile: 'invalidFile',

   /**
    * The modification operation cannot complete because the controller configuration area (DACStore) is too small. Contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   reconfigSmallDacstore: 'reconfigSmallDacstore',

   /**
    * The modification operation cannot complete because of the number of drives in the volume group and the segment size of the associated volumes. Reduce the segment size of all volumes in the volume group and retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   reconfigFailure: 'reconfigFailure',

   /**
    * Unable to read or write NVSRAM.
    * @const
    * @type {string}
    */
   nvramError: 'nvramError',

   /**
    * There was a failure in transferring the firmware to flash memory during a download operation. Please retry the operation.
    * @const
    * @type {string}
    */
   flashError: 'flashError',

   /**
    * This operation cannot complete because there was a security authentication failure on a parameter in the command sent to the controller. Please retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   authFailParam: 'authFailParam',

   /**
    * The operation cannot complete because you did not provide a valid administrator password.
    * @const
    * @type {string}
    */
   authFailPassword: 'authFailPassword',

   /**
    * There is a memory parity error on the controller.
    * @const
    * @type {string}
    */
   memParityError: 'memParityError',

   /**
    * The operation cannot complete because the controller specified in the request is not valid.
    * @const
    * @type {string}
    */
   invalidControllerref: 'invalidControllerref',

   /**
    * The operation cannot complete because the volume group specified in the request is not valid. The volume group may have been deleted or modified by a user on another management station accessing this storage array, or one or more of the following conditions are present: 1) one or more of the drives in the volume group is not security capable, 2) the volume group contains one or more snapshot copy base or repository volumes, or 3) the volume group is not in an optimal state.
    * @const
    * @type {string}
    */
   invalidVolumegroupref: 'invalidVolumegroupref',

   /**
    * The operation cannot complete because the volume specified in the request is not valid. The volume may have been deleted or modified by a user on another management station accessing this storage array.
    * @const
    * @type {string}
    */
   invalidVolumeref: 'invalidVolumeref',

   /**
    * The operation cannot complete because the drive specified in the request is not valid. The drive may have been used or modified by a user on another management station accessing this storage array.
    * @const
    * @type {string}
    */
   invalidDriveref: 'invalidDriveref',

   /**
    * The operation cannot complete because the free capacity specified in the request is not valid. The free capacity may have been used or modified by a user on another management station accessing this storage array.
    * @const
    * @type {string}
    */
   invalidFreeextentref: 'invalidFreeextentref',

   /**
    * The operation cannot complete because the volume group is offline. Please place the volume group online.
    * @const
    * @type {string}
    */
   volumeOffline: 'volumeOffline',

   /**
    * The operation cannot complete because some volumes are not optimal. Please correct the problem causing the non-optimal volumes using the Recovery Guru and then retry the operation.
    * @const
    * @type {string}
    */
   volumeNotOptimal: 'volumeNotOptimal',

   /**
    * The operation cannot complete because state information could not be retrieved from one or more controllers in the storage array.
    * @const
    * @type {string}
    */
   modesenseError: 'modesenseError',

   /**
    * The operation cannot complete for one of the following reasons: (1) The requested segment size is not valid, (2) The requested segment size is not allowed because it is more than twice or less than half the current segment size, (3) The requested segment size is not allowed because this volume has an odd number of segments, or (4) The segment size specified is not valid for the current cache block size. If case (3) applies, you may only decrease the segment size for this volume to a smaller number.
    * @const
    * @type {string}
    */
   invalidSegmentsize: 'invalidSegmentsize',

   /**
    * The operation cannot complete because the cache block size requested is not valid.
    * @const
    * @type {string}
    */
   invalidCacheblksize: 'invalidCacheblksize',

   /**
    * The operation cannot complete because the start cache flush value requested is not valid.
    * @const
    * @type {string}
    */
   invalidFlushThreshold: 'invalidFlushThreshold',

   /**
    * The operation cannot complete because the stop cache flush value requested is not valid.
    * @const
    * @type {string}
    */
   invalidFlushAmount: 'invalidFlushAmount',

   /**
    * The name you have provided cannot be used. The most likely cause is that the name is already used by another volume. Please provide another name.
    * @const
    * @type {string}
    */
   invalidLabel: 'invalidLabel',

   /**
    * The operation cannot complete because the cache flush modifier requested is not valid.
    * @const
    * @type {string}
    */
   invalidCacheModifier: 'invalidCacheModifier',

   /**
    * The operation cannot complete because the cache read ahead requested is not valid.
    * @const
    * @type {string}
    */
   invalidReadahead: 'invalidReadahead',

   /**
    * The operation cannot complete because the modification priority requested is not valid.
    * @const
    * @type {string}
    */
   invalidReconpriority: 'invalidReconpriority',

   /**
    * The operation cannot complete because the media scan duration requested is not valid.
    * @const
    * @type {string}
    */
   invalidScanperiod: 'invalidScanperiod',

   /**
    * The operation cannot complete because the number of trays requested has exceeded the maximum value.
    * @const
    * @type {string}
    */
   invalidTrayposLength: 'invalidTrayposLength',

   /**
    * The operation cannot complete because the requested NVSRAM region is not valid.
    * @const
    * @type {string}
    */
   invalidRegionid: 'invalidRegionid',

   /**
    * The operation cannot complete because the preferred loop ID requested is not valid. Please specify an ID between 0 and 127.
    * @const
    * @type {string}
    */
   invalidFibreid: 'invalidFibreid',

   /**
    * The operation cannot complete because the encryption routine requested is not valid.
    * @const
    * @type {string}
    */
   invalidEncryption: 'invalidEncryption',

   /**
    * The operation cannot complete because it is not supported on SSD cache or because of the current RAID level of the volume group. Remember that some operations cannot be performed on certain RAID levels because of redundancy or drive requirements.
    * @const
    * @type {string}
    */
   invalidRaidlevel: 'invalidRaidlevel',

   /**
    * The operation cannot complete because the number of drives selected is not valid.
    * @const
    * @type {string}
    */
   invalidExpansionList: 'invalidExpansionList',

   /**
    * No hot spare drives were unassigned. Possible causes include (1) the drives are not hot spares, (2) the hot spares are removed, (3) the hot spares are failed, or (4) the hot spares are In Use (integrated into a volume group). Check these possible causes and then retry the operation.
    * @const
    * @type {string}
    */
   noSparesDeassigned: 'noSparesDeassigned',

   /**
    * Not all of the requested hot spare drives were unassigned. Possible causes include (1) the drives are not hot spares, (2) the hot spares are removed, (3) the hot spares are failed, or (4) the hot spares are In Use (integrated into a volume group). Check these possible causes and then retry the operation.
    * @const
    * @type {string}
    */
   someSparesDeassigned: 'someSparesDeassigned',

   /**
    * The operation cannot complete because the identifier or name you provided already exists. Please provide another identifier or name and then retry the operation.
    * @const
    * @type {string}
    */
   partDupId: 'partDupId',

   /**
    * The operation cannot complete because the name you provided is not valid. Please provide a non-blank name and then retry the operation.
    * @const
    * @type {string}
    */
   partLabelInvalid: 'partLabelInvalid',

   /**
    * The operation cannot complete because the host group, host, or host port you have selected no longer exists. The object may have been deleted or modified by a user on another management station accessing this storage array. Please close and re-open the dialog box to refresh the information.
    * @const
    * @type {string}
    */
   partNodeNonexistent: 'partNodeNonexistent',

   /**
    * The creation of the host port cannot complete because the host port identifier is not valid. Either the identifier is empty or has characters other than 0-9 and A-F. Please enter a valid host port identifier and then retry the operation.
    * @const
    * @type {string}
    */
   partPortIdInvalid: 'partPortIdInvalid',

   /**
    * The creation of a new volume-to-LUN mapping cannot complete because the volume you have selected no longer exists. The volume may have been deleted or modified by a user on another management station accessing this storage array. Please close and open the dialog box to refresh the information.
    * @const
    * @type {string}
    */
   partVolumeNonexistent: 'partVolumeNonexistent',

   /**
    * The operation cannot complete because the logical unit number (LUN) is already in use. Please enter another LUN.
    * @const
    * @type {string}
    */
   partLunCollision: 'partLunCollision',

   /**
    * The operation cannot complete because the maximum number of mappings has already been defined for this volume. The mapping may have defined by a user on another management station accessing this storage array.
    * @const
    * @type {string}
    */
   maxVolMappingExceeded: 'maxVolMappingExceeded',

   /**
    * The operation cannot complete because the volume-to-LUN mapping you have selected no longer exists. The mapping may have been deleted by a user on another management station accessing this storage array. Please close and re-open the dialog box to refresh the information.
    * @const
    * @type {string}
    */
   partMappingNonexistent: 'partMappingNonexistent',

   /**
    * The operation cannot complete because the host group or host has no host ports. Please define a host port for the host group or host and then retry the operation.
    * @const
    * @type {string}
    */
   partNoHostports: 'partNoHostports',

   /**
    * The image was successfully transferred.
    * @const
    * @type {string}
    */
   imageTransferred: 'imageTransferred',

   /**
    * The download cannot complete because a file is not valid. Replace the file and retry the operation.
    * @const
    * @type {string}
    */
   fileTooLarge: 'fileTooLarge',

   /**
    * A problem has occurred during the download. Please retry the operation.
    * @const
    * @type {string}
    */
   invalidOffset: 'invalidOffset',

   /**
    * The download cannot complete because a file is not valid. Replace the file and retry the operation.
    * @const
    * @type {string}
    */
   overrun: 'overrun',

   /**
    * A problem has occurred during the download. Please retry the operation.
    * @const
    * @type {string}
    */
   invalidChunksize: 'invalidChunksize',

   /**
    * The download cannot complete because a file is not valid. Replace the file and retry the operation.
    * @const
    * @type {string}
    */
   invalidTotalsize: 'invalidTotalsize',

   /**
    * The requested download cannot complete because the NVSRAM option to support this download type is disabled. Contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   downloadNotPermitted: 'downloadNotPermitted',

   /**
    * A resource allocation error (unable to spawn a task) occurred on one of the controllers in the storage array.
    * @const
    * @type {string}
    */
   spawnError: 'spawnError',

   /**
    * The operation cannot complete because the controller was unable to transfer the volumes to its alternate controller. Please check the alternate controller for problems and then retry the operation.
    * @const
    * @type {string}
    */
   voltransferError: 'voltransferError',

   /**
    * The operation cannot complete because the controller pair is in Service mode. Please set the status of the controller in Service mode to Online and then retry the operation.
    * @const
    * @type {string}
    */
   invalidDlstate: 'invalidDlstate',

   /**
    * The operation cannot complete because of an incorrect controller configuration. Possible causes include (1) the controller pair is in an Active/Passive mode, or (2) controller cache synchronization failed. Please change the passive controller to active and then retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   cacheconfigError: 'cacheconfigError',

   /**
    * The operation cannot complete because a download is already in progress. Please wait for the download to complete and, if necessary, retry the operation.
    * @const
    * @type {string}
    */
   downloadInProgress: 'downloadInProgress',

   /**
    * The operation cannot complete because a drive in the volume group or disk pool is not optimal. Please correct the problem using the Recovery Guru and then retry the operation.
    * @const
    * @type {string}
    */
   driveNotOptimal: 'driveNotOptimal',

   /**
    * The operation cannot complete because a drive in the volume group is removed. Please insert a drive and then retry the operation.
    * @const
    * @type {string}
    */
   driveRemoved: 'driveRemoved',

   /**
    * The operation cannot complete because the selected drive is already part of the volume group. Please select another drive and retry the operation.
    * @const
    * @type {string}
    */
   duplicateDrives: 'duplicateDrives',

   /**
    * The operation cannot complete because the number of drives selected exceeds the maximum additional drives allowed. Please select a smaller number of drives and then retry the operation.
    * @const
    * @type {string}
    */
   numdrivesAdditional: 'numdrivesAdditional',

   /**
    * The operation cannot complete because either (1) the number of drives selected is not valid for the RAID level of the volume group or (2) the number of drives in the volume group is not valid for the proposed RAID level.
    * @const
    * @type {string}
    */
   numdrivesGroup: 'numdrivesGroup',

   /**
    * The operation cannot complete because at least one of the drives selected has a capacity that is not large enough to hold the existing data of the volume group. Please select another drive and retry the operation.
    * @const
    * @type {string}
    */
   driveTooSmall: 'driveTooSmall',

   /**
    * The operation cannot complete because there is no free capacity or not enough free capacity on the volume group to accommodate the new RAID level.
    * @const
    * @type {string}
    */
   capacityConstrained: 'capacityConstrained',

   /**
    * The operation cannot complete because the maximum number of volumes for this storage array has been reached.
    * @const
    * @type {string}
    */
   maxVolumesExceeded: 'maxVolumesExceeded',

   /**
    * The operation cannot complete because the logical unit number (LUN) is already in use by the Access Volume. Please select another LUN.
    * @const
    * @type {string}
    */
   partIsUtmLun: 'partIsUtmLun',

   /**
    * One or more drives were assigned as hot spares. However, some of the drives do not have a capacity large enough to cover all of the drives in the storage array. If a drive fails that has a capacity larger than these hot spares drives, it will not be covered by these drives.
    * @const
    * @type {string}
    */
   someSparesTooSmall: 'someSparesTooSmall',

   /**
    * Not all of the requested drives were assigned as hot spares. In addition, one or more drives that were assigned as hot spares do not have a capacity large enough to cover all of the drives in the storage array. If a drive fails that has a capacity larger than these hot spares drives, it will not be covered by these drives. Check the hot spare coverage. You may want to unassign the smaller-capacity hot spare drives.
    * @const
    * @type {string}
    */
   sparesSmallUnassigned: 'sparesSmallUnassigned',

   /**
    * The volume assignment you are attempting on the host cluster (group) or host cannot occur because either (1) the maximum number of host clusters or hosts that have at least one volume assignment has been reached or (2) the feature that allows you to assign a volume to a specific host cluster or host is not enabled.
    * @const
    * @type {string}
    */
   tooManyPartitions: 'tooManyPartitions',

   /**
    * A redundancy check is already in progress. Either a redundancy check is currently being performed or it was canceled but the time-out period (1 to 2 minutes) has not been reached. Please wait until the check has completed or timed out and then retry the operation.
    * @const
    * @type {string}
    */
   parityScanInProgress: 'parityScanInProgress',

   /**
    * The feature enable identifier contained in the feature key file you have selected does not match the identifier for this storage array. Please select another feature key file or obtain a feature key file using the correct identifier. Determine the feature enable identifier for this storage array.
    * @const
    * @type {string}
    */
   invalidSafeId: 'invalidSafeId',

   /**
    * The feature key file you have selected is not valid. The security (digest) information contained in the file does not match what was expected from the controller. Please contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   invalidSafeKey: 'invalidSafeKey',

   /**
    * The premium feature you are attempting to enable with this feature key file is not supported on the current configuration of this storage array. Please determine the configuration (such as appropriate level of firmware and hardware) necessary to support this feature. Contact your Technical Support Representative if necessary.
    * @const
    * @type {string}
    */
   invalidSafeCapability: 'invalidSafeCapability',

   /**
    * The feature key file you have selected is not valid. The version information contained in the file does not match what was expected from the controller. Please contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   invalidSafeVersion: 'invalidSafeVersion',

   /**
    * The operation cannot complete because the Mapping equals None parameter is not allowed on this storage array. Use the Mapping equals Default parameter instead.
    * @const
    * @type {string}
    */
   partitionsDisabled: 'partitionsDisabled',

   /**
    * A firmware download to a drive failed.
    * @const
    * @type {string}
    */
   driveDownloadFailed: 'driveDownloadFailed',

   /**
    * A firmware download to an IOM (ESM) cannot complete. If your storage array is not optimal, please correct any problems using the Recovery Guru and then retry the download operation.
    * @const
    * @type {string}
    */
   esmDownloadFailed: 'esmDownloadFailed',

   /**
    * The firmware versions on the IOM (ESM) cards do not match. Please retry the download operation.
    * @const
    * @type {string}
    */
   esmPartialUpdate: 'esmPartialUpdate',

   /**
    * The operation could not complete because the NVSRAM offset 0x32 is attempting to enable a logical unit number (LUN) for an access volume that conflicts with a LUN for a volume that already exists on the storage array. If you are downloading a new NVSRAM file, you will need to obtain a new file with the offset set to a LUN that does not conflict. If you are using the script editor or CLI to set this NVSRAM offset, you must choose a different LUN that does not conflict.
    * @const
    * @type {string}
    */
   utmConflict: 'utmConflict',

   /**
    * The operation cannot complete because a volume must exist on the storage array.
    * @const
    * @type {string}
    */
   noVolumes: 'noVolumes',

   /**
    * The operation cannot complete because either there is a problem communicating with any of the drives in the storage array or there are currently no drives connected. Please correct the problem and then retry the operation.
    * @const
    * @type {string}
    */
   authFailReadpassword: 'authFailReadpassword',

   /**
    * The operation cannot complete because the maximum number of host-groups, hosts, and host-ports have been created for this storage array.
    * @const
    * @type {string}
    */
   partCrteFailTblFull: 'partCrteFailTblFull',

   /**
    * The operation cannot complete because you are attempting to modify host-dependent values for region ID 0xF1. You must change host-dependent values in one of the host index areas.
    * @const
    * @type {string}
    */
   attemptToSetLocal: 'attemptToSetLocal',

   /**
    * The operation cannot complete because the host index must be between 0 and 15.
    * @const
    * @type {string}
    */
   invalidHostTypeIndex: 'invalidHostTypeIndex',

   /**
    * The operation cannot complete because the volume you are trying to assign is already assigned to a host cluster (group) or host.
    * @const
    * @type {string}
    */
   failVolumeVisible: 'failVolumeVisible',

   /**
    * The operation cannot complete because you are attempting to delete the access volume-to-LUN mapping that you are currently using to communicate with this storage array.
    * @const
    * @type {string}
    */
   noDeleteUtmInUse: 'noDeleteUtmInUse',

   /**
    * The operation cannot complete because the logical unit number (LUN) is not valid.
    * @const
    * @type {string}
    */
   invalidLun: 'invalidLun',

   /**
    * The operation cannot complete because the logical unit number you are attempting to map to this access volume is outside the allowable range. Please select one of the logical unit numbers (LUN) that have already been mapped to one of the other access volumes.
    * @const
    * @type {string}
    */
   utmTooManyMaps: 'utmTooManyMaps',

   /**
    * The controller diagnostics read test has failed and the controller has been placed offline. Use the Recovery Guru to replace the failed controller. For more information on the read test, refer to the online help.
    * @const
    * @type {string}
    */
   diagReadFailure: 'diagReadFailure',

   /**
    * The diagnostics passed, but I/Os were performed internally because the test was unable to communicate on the host/source links.
    * @const
    * @type {string}
    */
   diagSrcLinkDown: 'diagSrcLinkDown',

   /**
    * Diagnostics Write test failed. The controller has been placed offline. Use the Recovery Guru to replace the faulty controller. For information on write test failures, refer to online Help.
    * @const
    * @type {string}
    */
   diagWriteFailure: 'diagWriteFailure',

   /**
    * The controller diagnostics passed. However, the test identified an error on one or more of the loops. For more information on the loopback test, refer to the online help.
    * @const
    * @type {string}
    */
   diagLoopbackError: 'diagLoopbackError',

   /**
    * The diagnostics operation cannot complete because the controller did not respond within the allotted time. The controller has been placed offline. Use the Recovery Guru to recover from the offline controller.
    * @const
    * @type {string}
    */
   diagTimeout: 'diagTimeout',

   /**
    * The diagnostics operation cannot complete because a diagnostics operation is already in progress.
    * @const
    * @type {string}
    */
   diagInProgress: 'diagInProgress',

   /**
    * The diagnostics operation cannot complete because the operation requires two online controllers.
    * @const
    * @type {string}
    */
   diagNoAlt: 'diagNoAlt',

   /**
    * The diagnostics operation cannot complete because of a communication error between controllers.
    * @const
    * @type {string}
    */
   diagIconSendErr: 'diagIconSendErr',

   /**
    * The diagnostics operation cannot complete because of an internal initialization error.
    * @const
    * @type {string}
    */
   diagInitErr: 'diagInitErr',

   /**
    * The diagnostics operation cannot complete because both controllers are not in the online mode.
    * @const
    * @type {string}
    */
   diagModeErr: 'diagModeErr',

   /**
    * The diagnostics operation cannot complete because the controller does not support one or more selected diagnostic tests.
    * @const
    * @type {string}
    */
   diagInvalidTestId: 'diagInvalidTestId',

   /**
    * The diagnostics operation cannot complete because the controller was unable to obtain the location of the diagnostics data repository.
    * @const
    * @type {string}
    */
   diagDriveErr: 'diagDriveErr',

   /**
    * The diagnostics operation cannot complete because the controller was unable to obtain a mode select lock.
    * @const
    * @type {string}
    */
   diagLockErr: 'diagLockErr',

   /**
    * The diagnostics operation cannot complete because a diagnostic volume cannot be created.
    * @const
    * @type {string}
    */
   diagConfigErr: 'diagConfigErr',

   /**
    * The diagnostics operation cannot complete because there was not enough memory available.
    * @const
    * @type {string}
    */
   diagNoCacheMem: 'diagNoCacheMem',

   /**
    * The diagnostics operation cannot complete because the operation cannot disable data transfer.
    * @const
    * @type {string}
    */
   diagNotQuiesced: 'diagNotQuiesced',

   /**
    * The diagnostics operation cannot complete because an access volume is not defined.
    * @const
    * @type {string}
    */
   diagUtmNotEnabled: 'diagUtmNotEnabled',

   /**
    * The controller mode switch to passive failed because the controller has Auto-Volume Transfer mode enabled. For more information about AVT, see "Learn about Auto-Volume Transfer and Multi-Path Drivers" in the Learn More section of the online help.
    * @const
    * @type {string}
    */
   invalidModeSwitch: 'invalidModeSwitch',

   /**
    * The operation cannot complete because the I/O interface specified in the request is not valid (unknown port name).
    * @const
    * @type {string}
    */
   invalidPortname: 'invalidPortname',

   /**
    * The operation cannot complete because the volume has already been assigned to this host cluster (group) or host. A host cluster or host cannot have a duplicate assignment to the same volume.
    * @const
    * @type {string}
    */
   duplicateVolMapping: 'duplicateVolMapping',

   /**
    * The operation cannot complete because the maximum number of snapshot volumes have been created for this base volume.
    * @const
    * @type {string}
    */
   maxSnapsPerBaseExceeded: 'maxSnapsPerBaseExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot volumes have been created for this storage array.
    * @const
    * @type {string}
    */
   maxSnapsExceeded: 'maxSnapsExceeded',

   /**
    * The operation cannot complete because: (1) you attempted to create a snapshot volume on: a snapshot repository volume, another snapshot volume, a mirror repository volume, or a target volume in a Volume Copy pair. (2) you attempted to create a snapshot (legacy) volume on a thin volume, (3) you cannot mix a snapshot (legacy) volume and a new snapshot volume on the same base volume, (4) the base volume is undergoing rollback, or (5) the base volume contains unreadable sectors. Check the Recovery Guru for an unreadable sectors problem and follow the recommended procedure.
    * @const
    * @type {string}
    */
   invalidBasevol: 'invalidBasevol',

   /**
    * The operation cannot complete because the snapshot volume's associated base volume or repository volume is missing.
    * @const
    * @type {string}
    */
   snapNotAvailable: 'snapNotAvailable',

   /**
    * One or more of the snaps on the base being converted are not in the 'stopped' state.
    * @const
    * @type {string}
    */
   notDisabled: 'notDisabled',

   /**
    * The operation cannot complete because the Snapshot Volume Premium Feature is disabled or unauthorized.
    * @const
    * @type {string}
    */
   snapshotFeatureDisabled: 'snapshotFeatureDisabled',

   /**
    * The operation cannot complete because the volume's associated repository volume is in an offline state.
    * @const
    * @type {string}
    */
   repositoryOffline: 'repositoryOffline',

   /**
    * The delete operation cannot complete because the snapshot volume's associated repository volume is currently performing a modification operation. Please wait until the modification completes and then retry the operation.
    * @const
    * @type {string}
    */
   repositoryReconfiguring: 'repositoryReconfiguring',

   /**
    * The operation cannot complete because there is a rollback operation in progress.
    * @const
    * @type {string}
    */
   rollbackInProgress: 'rollbackInProgress',

   /**
    * The operation cannot complete because the maximum number of volumes has been created on this volume group.
    * @const
    * @type {string}
    */
   numVolumesGroup: 'numVolumesGroup',

   /**
    * The operation cannot complete because the volume on which you are attempting to perform the operation is missing. The only action that can be performed on a missing volume is deletion.
    * @const
    * @type {string}
    */
   ghostVolume: 'ghostVolume',

   /**
    * The delete operation cannot complete because the snapshot volume's associated repository volume is missing.
    * @const
    * @type {string}
    */
   repositoryMissing: 'repositoryMissing',

   /**
    * The operation cannot complete because the name you provided for the snapshot repository volume already exists. Please provide another name and then retry the operation.
    * @const
    * @type {string}
    */
   invalidRepositoryLabel: 'invalidRepositoryLabel',

   /**
    * The operation cannot complete because the name you provided for the snapshot volume already exists. Please provide another name and then retry the operation.
    * @const
    * @type {string}
    */
   invalidSnapLabel: 'invalidSnapLabel',

   /**
    * The operation cannot complete because the rollback priority you specified is not between 0 and 4. Please specify a value in this range and then retry the operation.
    * @const
    * @type {string}
    */
   invalidRollbackPriority: 'invalidRollbackPriority',

   /**
    * The operation cannot complete because the warning threshold you specified is not between 0 and 100 or is higher than critical threshold. Please specify a value in this range and then retry the operation.
    * @const
    * @type {string}
    */
   invalidWarnThreshold: 'invalidWarnThreshold',

   /**
    * The operation cannot complete because the volume you specified is a snapshot repository volume. You cannot map a logical unit number (LUN) or host to a snapshot repository volume.
    * @const
    * @type {string}
    */
   cannotMapVolume: 'cannotMapVolume',

   /**
    * The format volume operation cannot complete because the specified volume is used in a configuration that does not support format.
    * @const
    * @type {string}
    */
   cannotFormatVolume: 'cannotFormatVolume',

   /**
    * The operation cannot complete because the drive-side interface is SCSI not Fibre Channel.
    * @const
    * @type {string}
    */
   dstNotFibre: 'dstNotFibre',

   /**
    * The operation cannot complete because the capacity you specified for the repository volume is less than the minimum size required.
    * @const
    * @type {string}
    */
   repositoryTooSmall: 'repositoryTooSmall',

   /**
    * The operation cannot complete because the snapshot repository volume is failed. Please use the Recovery Guru to resolve the problem.
    * @const
    * @type {string}
    */
   repositoryFailed: 'repositoryFailed',

   /**
    * The operation cannot complete because the base volume associated with this snapshot failed. Please use the Recovery Guru to resolve the problem.
    * @const
    * @type {string}
    */
   baseVolumeFailed: 'baseVolumeFailed',

   /**
    * The operation cannot complete because the base volume associated with this snapshot is offline. Please use the Recovery Guru to resolve the problem.
    * @const
    * @type {string}
    */
   baseVolumeOffline: 'baseVolumeOffline',

   /**
    * The create snapshot operation cannot complete because a base volume initialization is in progress. Please wait until the initialization completes and then retry the operation.
    * @const
    * @type {string}
    */
   baseVolumeFormatting: 'baseVolumeFormatting',

   /**
    * The operation cannot complete because the command to create the mirror repository volumes was unsuccessful. Please retry the operation.
    * @const
    * @type {string}
    */
   metadataVolNonexistent: 'metadataVolNonexistent',

   /**
    * The operation cannot complete because the remote volume mirroring feature is disabled.
    * @const
    * @type {string}
    */
   rvmFeatureDisabled: 'rvmFeatureDisabled',

   /**
    * The operation cannot complete because there are mirrors (primary or secondary) present on the array.
    * @const
    * @type {string}
    */
   mirrorsPresent: 'mirrorsPresent',

   /**
    * The operation cannot complete because the remote volume mirroring feature has not been activated.
    * @const
    * @type {string}
    */
   rvmFeatureDeactivated: 'rvmFeatureDeactivated',

   /**
    * The operation cannot complete because the maximum number of mirror volumes have been created on the local storage array.
    * @const
    * @type {string}
    */
   maxMirrorsExceeded: 'maxMirrorsExceeded',

   /**
    * The operation cannot complete because the base volume for a potential mirror was invalid.
    * @const
    * @type {string}
    */
   invalidMirrorCandidateVol: 'invalidMirrorCandidateVol',

   /**
    * The operation cannot complete because the selected volume is not a mirror volume.
    * @const
    * @type {string}
    */
   invalidMirrorvol: 'invalidMirrorvol',

   /**
    * The operation cannot complete because mirror repository volumes already exist. Please deactivate the Remote Volume Mirroring premium feature.
    * @const
    * @type {string}
    */
   metadataAlreadyExists: 'metadataAlreadyExists',

   /**
    * The operation cannot complete because there are missing children for the mirror repository volume.
    * @const
    * @type {string}
    */
   metadataMissing: 'metadataMissing',

   /**
    * The operation cannot complete because there are offline children for the mirror repository volume.
    * @const
    * @type {string}
    */
   metadataOffline: 'metadataOffline',

   /**
    * The operation cannot complete because there are reconfiguring children for the mirror repository volume.
    * @const
    * @type {string}
    */
   metadataReconfiguring: 'metadataReconfiguring',

   /**
    * The operation cannot complete because the role of the local volume was unable to be changed. Please retry the operation. If the operation still cannot complete, please use the Recovery Guru to correct this condition or contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   localRoleChangeFailed: 'localRoleChangeFailed',

   /**
    * Not Used
    * @const
    * @type {string}
    */
   remoteRoleChangeFailed: 'remoteRoleChangeFailed',

   /**
    * Not Used
    * @const
    * @type {string}
    */
   localRoleChangeSuccessful: 'localRoleChangeSuccessful',

   /**
    * The mirror relationship was successfully removed from the local volume. However, a communication error prevented the mirror relationship from being removed from the associated remote volume in the mirrored pair. Go to the remote storage array and remove the mirror relationship.
    * @const
    * @type {string}
    */
   onlyLocalMirrorDeleted: 'onlyLocalMirrorDeleted',

   /**
    * The operation cannot complete because there are no mirror candidates on the remote storage array.
    * @const
    * @type {string}
    */
   noValidMirrorCandidate: 'noValidMirrorCandidate',

   /**
    * The operation cannot complete because the maximum number of mirror volumes has been created on the remote storage array.
    * @const
    * @type {string}
    */
   remoteMaxMirrorsExceeded: 'remoteMaxMirrorsExceeded',

   /**
    * The operation cannot complete because the remote volume mirroring feature is disabled on the remote storage array.
    * @const
    * @type {string}
    */
   remoteRvmFeatureDisabled: 'remoteRvmFeatureDisabled',

   /**
    * The operation cannot complete because the metadata volume is not present on the remote storage array.
    * @const
    * @type {string}
    */
   remoteMetadataVolNonexistent: 'remoteMetadataVolNonexistent',

   /**
    * The operation cannot complete because of an internal error. Please contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   notRegistered: 'notRegistered',

   /**
    * The operation cannot complete because the configuration number on the remote storage array is invalid.
    * @const
    * @type {string}
    */
   remoteInvalidCfgGen: 'remoteInvalidCfgGen',

   /**
    * The local primary volume was successfully demoted to a secondary role, but the command to promote the remote secondary volume to a primary role did not complete successfully. Please use the Recovery Guru to correct this condition.
    * @const
    * @type {string}
    */
   localRoleChangedNotForced: 'localRoleChangedNotForced',

   /**
    * The remote primary volume was successfully demoted to a secondary role, but the command to promote the local secondary volume to a primary role did not complete successfully. Please use the Recovery Guru to correct this condition.
    * @const
    * @type {string}
    */
   remoteRoleChangedLocalFailed: 'remoteRoleChangedLocalFailed',

   /**
    * The operation cannot complete because the local storage array was unable to create/delete a host cluster (group) or host assignment for the remote volume or the remote storage array was unable to create/delete a host cluster (group) or host assignment for the local volume. Please retry the operation.
    * @const
    * @type {string}
    */
   rvmSpmError: 'rvmSpmError',

   /**
    * The operation cannot complete because the authentication failed on the remote storage array.
    * @const
    * @type {string}
    */
   remoteAuthFailPassword: 'remoteAuthFailPassword',

   /**
    * The operation cannot complete because the selected remote storage array does not support the version of Remote Volume Mirroring currently running on this storage array. Please upgrade the remote storage array's management software or select another storage array.
    * @const
    * @type {string}
    */
   rvmVersionMismatch: 'rvmVersionMismatch',

   /**
    * The operation cannot complete due to an unknown failure at the remote storage array. Please retry the operation at a later time.
    * @const
    * @type {string}
    */
   rvmRemoteArrayError: 'rvmRemoteArrayError',

   /**
    * The operation cannot complete because the storage array cannot communicate with the remote storage array to complete this request. Possible causes include network or connection problems, or no power to the storage array. Check these possible causes and then retry the operation.
    * @const
    * @type {string}
    */
   rvmCommunicationError: 'rvmCommunicationError',

   /**
    * The operation cannot be completed because fibre channel mirroring may not be activated, or the mirror channel is being used exclusively by a host.
    * @const
    * @type {string}
    */
   rvmFibreError: 'rvmFibreError',

   /**
    * The operation cannot complete because the local volume is not a primary volume.
    * @const
    * @type {string}
    */
   mirrorVolNotPrimary: 'mirrorVolNotPrimary',

   /**
    * The operation cannot complete because the selected volume is not in a synchronized mirror state. Please wait until the mirrored pair is synchronized and then retry the operation.
    * @const
    * @type {string}
    */
   secNotPromoteable: 'secNotPromoteable',

   /**
    * The operation cannot complete because the selected volume is not in a synchronized mirror state. Please wait until the mirrored pair is synchronized and then retry the operation.
    * @const
    * @type {string}
    */
   priNotDemoteable: 'priNotDemoteable',

   /**
    * The operation cannot complete because the selected volume is a mirror repository volume. To delete a mirror repository volume, deactivate the Remote Volume Mirroring premium feature.
    * @const
    * @type {string}
    */
   metadataChildDeletion: 'metadataChildDeletion',

   /**
    * The operation cannot complete because the selected volume is in a mirror relationship. Please remove the mirror relationship and then retry the operation.
    * @const
    * @type {string}
    */
   rmtvolOrphanDeletion: 'rmtvolOrphanDeletion',

   /**
    * The operation cannot complete because the Remote Volume Mirroring premium feature is not supported on this controller platform.
    * @const
    * @type {string}
    */
   rvmActivateDisallowed: 'rvmActivateDisallowed',

   /**
    * The operation cannot complete because the Tray ID number entered is invalid. Please enter a valid Tray ID number and retry the operation. If you are unsure of the Tray ID number, locate the enclosure.
    * @const
    * @type {string}
    */
   invalidTrayref: 'invalidTrayref',

   /**
    * The operation cannot complete because a selected volume is the last one belonging to its controller owner and could not be successfully deleted. Please manually delete the volume.
    * @const
    * @type {string}
    */
   partialDeletion: 'partialDeletion',

   /**
    * The operation cannot complete because the logical unit number (LUN) is already in use by the Access Volume.
    * @const
    * @type {string}
    */
   defaultUtmCollision: 'defaultUtmCollision',

   /**
    * The operation cannot complete because the copy priority entered was not valid. Please enter a valid priority and retry the operation. Valid copy priorities include Lowest, Low, Medium, High and Highest.
    * @const
    * @type {string}
    */
   invalidCopyPriority: 'invalidCopyPriority',

   /**
    * The operation cannot complete because the volumes entered are not a valid copy pair. Please enter a valid copy pair and retry the operation.
    * @const
    * @type {string}
    */
   invalidVolumecopyref: 'invalidVolumecopyref',

   /**
    * The attempt to change the parameters of the selected copy pair cannot complete because of an internal controller error. Please retry the operation.
    * @const
    * @type {string}
    */
   copyChangeFailed: 'copyChangeFailed',

   /**
    * The operation cannot complete because the selected copy pair is currently in a Pending, In Progress, or Failed state. Please (1) wait for the copy operation to complete if it is Pending or In Progress, or (2) clear the Failed state using the storage management software. Then, retry the operation.
    * @const
    * @type {string}
    */
   copyActive: 'copyActive',

   /**
    * The operation cannot complete because the selected copy pair is currently in a Stopped or Completed State.
    * @const
    * @type {string}
    */
   copyInactive: 'copyInactive',

   /**
    * The operation cannot complete because the volume entered is not a valid source volume candidate. Possible causes include: the volume is a secondary volume in a mirrored pair, a mirror repository volume, a snapshot repository volume, or is a target volume in a copy pair that is currently Pending, In Progress, or Failed. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyIncompatibleSource: 'copyIncompatibleSource',

   /**
    * The operation cannot complete because the volume entered is not a valid target volume candidate. Possible causes include: the volume is a secondary volume in a mirrored pair, a mirror repository volume, a snapshot repository volume, a snapshot volume, a base volume of an active snapshot volume, a source volume in a copy pair that is currently Pending, In Progress, or Failed, or is the same volume that you entered as the source volume for this copy pair. Please select a different target volume and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyIncompatibleTarget: 'copyIncompatibleTarget',

   /**
    * The operation cannot complete because the source volume entered is missing. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyGhostSource: 'copyGhostSource',

   /**
    * The operation cannot complete because the target volume entered is missing. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyGhostTarget: 'copyGhostTarget',

   /**
    * The operation cannot complete because the source volume entered does not exist. The source volume may have been deleted by a user on another storage management station accessing this storage array.
    * @const
    * @type {string}
    */
   copyInvalidSourceRef: 'copyInvalidSourceRef',

   /**
    * The operation cannot complete because the target volume entered does not exist. The target volume may have been deleted by a user on another storage management station accessing this storage array.
    * @const
    * @type {string}
    */
   copyInvalidTargetRef: 'copyInvalidTargetRef',

   /**
    * The operation cannot complete because the source volume entered is not in an Optimal or Degraded state. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyInvalidSourceState: 'copyInvalidSourceState',

   /**
    * The operation cannot complete because the target volume entered is not in an Optimal state. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyInvalidTargetState: 'copyInvalidTargetState',

   /**
    * The operation cannot complete because the source volume entered is currently undergoing a reconfiguration operation. Please wait until the reconfiguration operation completes and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copySourceReconfig: 'copySourceReconfig',

   /**
    * The operation cannot complete because the target volume entered is currently undergoing a reconfiguration operation. Please wait until the reconfiguration operation completes and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyTargetReconfig: 'copyTargetReconfig',

   /**
    * The operation cannot complete because the target volume must be of equal or larger capacity than the source volume. Please select a different target volume or increase the capacity of the target volume entered and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyTargetTooSmall: 'copyTargetTooSmall',

   /**
    * The operation cannot complete because the target volume entered is already a target volume for another source volume. Please select a different target volume or remove the copy pair where this target volume currently resides. Then retry the operation.
    * @const
    * @type {string}
    */
   copyTargetLimit: 'copyTargetLimit',

   /**
    * The operation cannot complete because the maximum number of copy pairs have been created for this storage array.
    * @const
    * @type {string}
    */
   maxVolumeCopysExceeded: 'maxVolumeCopysExceeded',

   /**
    * The operation cannot complete because the source volume entered has a SCSI-2 or persistent reservation placed on it. Please release the reservation at the host and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copySourceReservation: 'copySourceReservation',

   /**
    * The operation cannot complete because the target volume entered has a SCSI-2 or persistent reservation placed on it. Please release the reservation at the host and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyTargetReservation: 'copyTargetReservation',

   /**
    * The operation cannot complete because the source volume entered is currently initializing. Please wait for the initialization to complete and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copySourceFormat: 'copySourceFormat',

   /**
    * The operation cannot complete because the target volume entered is currently initializing. Please wait for the initialization to complete and then retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyTargetFormat: 'copyTargetFormat',

   /**
    * The attempt to start the copy operation failed because of an internal controller error. Please retry the operation. NOTE: If you received this error after attempting a Re-Copy operation, even though the Re-Copy command failed, any changes you made to the Copy Priority as a result of that command were successfully completed.
    * @const
    * @type {string}
    */
   copyStartFailed: 'copyStartFailed',

   /**
    * The attempt to stop the copy operation failed because of an internal controller error. Please retry the operation.
    * @const
    * @type {string}
    */
   copyStopFailed: 'copyStopFailed',

   /**
    * The operation cannot complete because the Volume Copy premium feature is disabled.
    * @const
    * @type {string}
    */
   volcopyFeatureDisabled: 'volcopyFeatureDisabled',

   /**
    * The operation cannot complete because either the volume entered is a read-only target volume or it is a mirror secondary volume. Please either disable read-only or remove the mirror relationship. Then retry the operation.
    * @const
    * @type {string}
    */
   writeLock: 'writeLock',

   /**
    * The reconfiguration operation cannot complete because of one of the following reasons: (1) the volume contains unreadable sectors. Check the Recovery Guru for an unreadable sectors problem and follow the recommended procedure. (2) the volume, or another volume that resides in the same volume group, is a source or target volume in a copy pair that is currently in a Pending, In Progress or Failed state, or the mirror volume is not optimal. Please either wait for the copy operation to complete if it is Pending or In Progress, or clear the Failed state, or restore the mirror volume back to an optimal state. Then, retry the reconfiguration operation.
    * @const
    * @type {string}
    */
   cannotReconfigure: 'cannotReconfigure',

   /**
    * The operation cannot complete because the storage array is in a locked out mode. This mode occurs when too many incorrect passwords have been attempted over a 10-minute interval. The storage array will remain in the locked out mode for 10 minutes, during which, any operations that require an Administrator password will fail. Please wait and then retry the operation.
    * @const
    * @type {string}
    */
   authFailContLockout: 'authFailContLockout',

   /**
    * The operation cannot complete because the volume has a persistent reservation placed on it. Please release the reservation at the host and then retry the operation. If you still have problems, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   prReservationConflict: 'prReservationConflict',

   /**
    * The operation cannot complete because a volume registration could not be cleared. Please retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   regDeleteFailed: 'regDeleteFailed',

   /**
    * The operation cannot complete because an NVSRAM configuration setting indicates that batteries should not be part of this storage array. However, if you have batteries in this storage array, contact your Technical Support Representative to fix the NVSRAM setting to match your configuration. If you were attempting to reset the battery age, wait until the battery becomes fully charged and then try the operation again.
    * @const
    * @type {string}
    */
   batteryNotInConfig: 'batteryNotInConfig',

   /**
    * The operation cannot complete because the battery was removed.
    * @const
    * @type {string}
    */
   batteryMissing: 'batteryMissing',

   /**
    * The operation cannot complete because there may be a problem with the drive channel itself, its associated cable may not be properly connected, or there are no expansion drive trays in this storage array.
    * @const
    * @type {string}
    */
   noChannel: 'noChannel',

   /**
    * The operation cannot complete because the selected volume is a secondary volume. Please select a primary volume and then retry the operation.
    * @const
    * @type {string}
    */
   rvmOperNotAllowedOnSec: 'rvmOperNotAllowedOnSec',

   /**
    * The change volume group to RAID 0 operation cannot complete because the volume group contains mirror repository volumes. Mirror repository volumes must be either RAID 1,3,5, or 6 to ensure data redundancy.
    * @const
    * @type {string}
    */
   dataRedundancyRequired: 'dataRedundancyRequired',

   /**
    * The operation cannot complete because the source volume entered is also a primary volume in a mirrored pair, and there is currently an error preventing mirror communication with the remote storage array. This error may be intermittent. Please retry the operation. If the operation still cannot complete, please use the Recovery Guru to correct the mirror communication error and then retry the operation.
    * @const
    * @type {string}
    */
   copySourceZeroCapacity: 'copySourceZeroCapacity',

   /**
    * The operation cannot complete because you attempted a volume-to-LUN mapping with a LUN greater than 31 and at least one host type defined for the selected host/host ports is limited to accessing volumes with LUNs 0 to 31. Please retry the operation using LUN 0 to 31.
    * @const
    * @type {string}
    */
   invHostlunDefineMapping: 'invHostlunDefineMapping',

   /**
    * The operation cannot complete because you attempted to do one of the following operations. (1) change a volume-to-LUN mapping with a LUN greater than 31 and at least one host type defined for the selected host/host ports is limited to accessing volumes with LUNs 0 to 31. (2) move a volume-to-LUN mapping to a host that contains at least one defined host type that is limited to accessing volumes with LUNs 0 to 31. Please retry the operation and use LUN 0 to 31 or select a different host.
    * @const
    * @type {string}
    */
   invHostlunMoveMapping: 'invHostlunMoveMapping',

   /**
    * The operation cannot complete because you attempted to define or change a host type to one that can only access volumes with LUNs 0 to 31 and there is already at least one volume mapped to the selected host or host port using a LUN greater than 31. Please either select a host type that can access LUNs greater than 31 or change the existing volume mappings to LUNs 0 to 31, and then retry the operation.
    * @const
    * @type {string}
    */
   invHostlunDefineHosttype: 'invHostlunDefineHosttype',

   /**
    * The operation cannot complete because you attempted to move a host to a host cluster (group) or host port to an existing host that has at least one volume already assigned with a LUN greater than 31 and the defined host type for the host/host port is limited to accessing volumes with LUNs 0 to 31. Change either the host type to one that can access LUNs greater than 31 or change the existing volume assignment(s) to LUNs 0 to 31, and then retry the operation. IMPORTANT: If you want to change the host type of the host port, you must first change it on the existing host and then move it.
    * @const
    * @type {string}
    */
   invHostlunMoveHostport: 'invHostlunMoveHostport',

   /**
    * The operation cannot complete because you attempted to download incompatible firmware. Contact your Technical Support Representative for downgrade and compatible firmware support information.
    * @const
    * @type {string}
    */
   fwIncompatible: 'fwIncompatible',

   /**
    * The operation cannot complete because you attempted to suspend an already suspended mirror.
    * @const
    * @type {string}
    */
   mirrorAlreadySuspended: 'mirrorAlreadySuspended',

   /**
    * The operation cannot complete because the existing mirror repositories are not large enough to accommodate more mirrors. Please upgrade the mirror repositories and retry the operation.
    * @const
    * @type {string}
    */
   insuffLocalMirRepResources: 'insuffLocalMirRepResources',

   /**
    * The operation cannot complete because the remote array's mirror repositories are not large enough to accommodate more mirrors. Please upgrade the remote array's mirror repositories and retry the operation.
    * @const
    * @type {string}
    */
   insuffRemtMirRepResources: 'insuffRemtMirRepResources',

   /**
    * Unable to delete the following missing volumes because they currently have unreadable sectors. You must clear the unreadable sectors on these volumes before deleting them. Contact your technical support representative for assistance.
    * @const
    * @type {string}
    */
   ghostHasUnreadableSectors: 'ghostHasUnreadableSectors',

   /**
    * The communication test passed. Some pings timed out, but their retries succeeded.
    * @const
    * @type {string}
    */
   rvmCommStatRecoveredTimeout: 'rvmCommStatRecoveredTimeout',

   /**
    * The communication test passed, although some pings had delayed response.
    * @const
    * @type {string}
    */
   rvmCommStatRecoveredDelay: 'rvmCommStatRecoveredDelay',

   /**
    * The operation cannot complete because the communication test could not start.
    * @const
    * @type {string}
    */
   rvmCommStatNotReady: 'rvmCommStatNotReady',

   /**
    * The operation cannot complete because a command to the remote volume timed out.
    * @const
    * @type {string}
    */
   rvmCommStatTimeout: 'rvmCommStatTimeout',

   /**
    * The operation cannot complete because the channel to the remote array or volume is failed.
    * @const
    * @type {string}
    */
   rvmCommStatChannelFailure: 'rvmCommStatChannelFailure',

   /**
    * The operation cannot complete because the remote volume mirror network could not be accessed.
    * @const
    * @type {string}
    */
   rvmCommStatNetworkFailure: 'rvmCommStatNetworkFailure',

   /**
    * The operation cannot complete because the remote volume was not found.
    * @const
    * @type {string}
    */
   rvmCommStatDeviceMissing: 'rvmCommStatDeviceMissing',

   /**
    * The operation cannot complete because the remote volume did not permit a login.
    * @const
    * @type {string}
    */
   rvmCommStatLoginRejected: 'rvmCommStatLoginRejected',

   /**
    * The operation cannot complete because the remote volume login failed.
    * @const
    * @type {string}
    */
   rvmCommStatLoginFailure: 'rvmCommStatLoginFailure',

   /**
    * The operation cannot complete because the number of sample times exceeds the maximum.
    * @const
    * @type {string}
    */
   rvmCommStatInvNumSamplesReqd: 'rvmCommStatInvNumSamplesReqd',

   /**
    * The operation failed because a quiescence or suspension is in progress.
    * @const
    * @type {string}
    */
   rvmQuiescenceInProgress: 'rvmQuiescenceInProgress',

   /**
    * The operation cannot complete because the volume reference is not a Remote Volume.
    * @const
    * @type {string}
    */
   rvmInvalidRemotevol: 'rvmInvalidRemotevol',

   /**
    * The firmware download operation cannot complete because one or both of the controllers are currently performing a start-of-day operation. Please wait until the start-of-day operation completes, and then retry the firmware download operation.
    * @const
    * @type {string}
    */
   sodInProgress: 'sodInProgress',

   /**
    * The drive firmware download operation cannot complete because one or more of the drives you selected has a Bypassed or Offline status and is inaccessible.
    * @const
    * @type {string}
    */
   invalidDrives: 'invalidDrives',

   /**
    * The operation cannot complete because a download set identifier was incorrect.
    * @const
    * @type {string}
    */
   invalidSetid: 'invalidSetid',

   /**
    * The operation cannot complete because the number of download sets exceeds the maximum allowed.
    * @const
    * @type {string}
    */
   invalidSetsize: 'invalidSetsize',

   /**
    * The operation cannot complete because not all the data for all download sets was received.
    * @const
    * @type {string}
    */
   missingData: 'missingData',

   /**
    * The operation cannot complete because request to quiesce the system failed.
    * @const
    * @type {string}
    */
   quiescenceFailed: 'quiescenceFailed',

   /**
    * The operation cannot complete because file validation failed.
    * @const
    * @type {string}
    */
   validationError: 'validationError',

   /**
    * The operation cannot complete because the drive firmware download was halted by the user.
    * @const
    * @type {string}
    */
   downloadHalted: 'downloadHalted',

   /**
    * The drive firmware download operation failed for all drives.
    * @const
    * @type {string}
    */
   allFailed: 'allFailed',

   /**
    * The drive firmware download operation completed. The operation failed for some drives.
    * @const
    * @type {string}
    */
   partialOk: 'partialOk',

   /**
    * The operation is no longer supported.
    * @const
    * @type {string}
    */
   obsolete: 'obsolete',

   /**
    * Unable to clear the unreadable sectors on the drives associated with the selected volumes. There was a problem writing a known data pattern to these drives. Please retry the operation. If this message persists, contact your Technical Support Representative.
    * @const
    * @type {string}
    */
   usmClearFailed: 'usmClearFailed',

   /**
    * The operation cannot complete because the controller was placed in Service Mode at the request of a Technical Support Representative. A possible reason for this is that a problem with the storage array required diagnostic tests on this controller. Check to make sure the problem has been resolved. Place the controller Online.
    * @const
    * @type {string}
    */
   controllerInServiceMode: 'controllerInServiceMode',

   /**
    * Invalid drive.
    * @const
    * @type {string}
    */
   invalidDrive: 'invalidDrive',

   /**
    * Dbm database error
    * @const
    * @type {string}
    */
   databaseError: 'databaseError',

   /**
    * The automatic configuration has started as a background operation.
    * @const
    * @type {string}
    */
   backgroundAutocfg: 'backgroundAutocfg',

   /**
    * The automatic configuration cannot complete because another automatic configuration is in progress.
    * @const
    * @type {string}
    */
   autocfgInprogress: 'autocfgInprogress',

   /**
    * The IOM (ESM) firmware download cannot complete because the IOM (ESM) firmware specified is not compatible with the storage array's controller firmware version. Please contact your Technical Support Representative to resolve this problem.
    * @const
    * @type {string}
    */
   unsupportedLhaSataEsm: 'unsupportedLhaSataEsm',

   /**
    * Parity scan failed.
    * @const
    * @type {string}
    */
   parityScanFailed: 'parityScanFailed',

   /**
    * Parity error repair failed.
    * @const
    * @type {string}
    */
   parityRepairFailed: 'parityRepairFailed',

   /**
    * Media error repair failed.
    * @const
    * @type {string}
    */
   mediaRepairFailed: 'mediaRepairFailed',

   /**
    * The change role operation cannot complete because the data between the mirrored pair is unsynchronized. Please stop all I/O activity and then retry the operation.
    * @const
    * @type {string}
    */
   mirrorDegraded: 'mirrorDegraded',

   /**
    * The operation cannot complete because your storage array contains mixed drive types and the Mixed Drive Types premium feature is disabled or out of compliance. Refer to the Recovery Guru for procedures on how to correct this condition.
    * @const
    * @type {string}
    */
   prohibitedByMdtRestrictions: 'prohibitedByMdtRestrictions',

   /**
    * You have selected a key to enable a Gold Key dependent premium feature. You must enable the Gold Key premium feature on this storage array before you can enable a Gold Key-dependent premium feature.
    * @const
    * @type {string}
    */
   prohibitedByGoldKeyRestrictions: 'prohibitedByGoldKeyRestrictions',

   /**
    * You have selected a key to enable the following premium feature: Gold Key. A feature key is not required to use this feature on this storage array.
    * @const
    * @type {string}
    */
   safeControllerNotSubjectToGoldKey: 'safeControllerNotSubjectToGoldKey',

   /**
    * You have selected a key to enable the following premium feature: Mixed Drive Types. A feature key is not required to use this feature on this storage array.
    * @const
    * @type {string}
    */
   safeMdtNotPremiumFeature: 'safeMdtNotPremiumFeature',

   /**
    * The operation cannot complete because the alarm module is not present.
    * @const
    * @type {string}
    */
   alarmNotPresent: 'alarmNotPresent',

   /**
    * The Discrete Line Test did not execute to completion.
    * @const
    * @type {string}
    */
   dltNotCompleted: 'dltNotCompleted',

   /**
    * Cannot turn on Ready to Remove LED due to dependency.
    * @const
    * @type {string}
    */
   dependancyError: 'dependancyError',

   /**
    * The CDM database is full. Free up space in the database and retry the operation.
    * @const
    * @type {string}
    */
   cdmDatabaseFull: 'cdmDatabaseFull',

   /**
    * An operation could not be carried out because necessary pre-conditions were not true.
    * @const
    * @type {string}
    */
   requiredConditionNotPresent: 'requiredConditionNotPresent',

   /**
    * The diagnostic data capture request cannot complete because no diagnostic data is available.
    * @const
    * @type {string}
    */
   ddcUnavail: 'ddcUnavail',

   /**
    * The operation cannot complete because one or more parameters associated with the diagnostic data capture request is invalid.
    * @const
    * @type {string}
    */
   ddcIllegalParam: 'ddcIllegalParam',

   /**
    * The tag associated with a request for DDC data is invalid.
    * @const
    * @type {string}
    */
   invalidDdcTag: 'invalidDdcTag',

   /**
    * A host type conflict was detected while trying to configure a pending host.
    * @const
    * @type {string}
    */
   hosttypeConflict: 'hosttypeConflict',

   /**
    * A port conflict was detected while trying to configure a pending host.
    * @const
    * @type {string}
    */
   portConflict: 'portConflict',

   /**
    * An invalid host type string for a pending host was detected.
    * @const
    * @type {string}
    */
   invalidHosttypeString: 'invalidHosttypeString',

   /**
    * An invalid port protocol for a pending host was detected.
    * @const
    * @type {string}
    */
   invalidProtocol: 'invalidProtocol',

   /**
    * The supplied pending host definition is missing ports compared to its matching discovered host.
    * @const
    * @type {string}
    */
   portRemoved: 'portRemoved',

   /**
    * A disable operation cannot be performed. An example is trying to disable a shipped-enabled feature.
    * @const
    * @type {string}
    */
   disableNotPermitted: 'disableNotPermitted',

   /**
    * The operation cannot complete because the storage array has more than the allowed number of expansion enclosures.
    * @const
    * @type {string}
    */
   prohibitedByDriveTrayLimit: 'prohibitedByDriveTrayLimit',

   /**
    * The supplied component reference does not refer to an IOM (ESM)
    * @const
    * @type {string}
    */
   invalidEsmref: 'invalidEsmref',

   /**
    * A bundle migration is invalid and cannot be performed.
    * @const
    * @type {string}
    */
   invalidBundleMigration: 'invalidBundleMigration',

   /**
    * A bundle key cannot be validated as coming from an authorized source.
    * @const
    * @type {string}
    */
   invalidBundleKey: 'invalidBundleKey',

   /**
    * The hot spare coverage is already adequate for the storage, therefore no additional hot spare drives were automatically assigned.
    * @const
    * @type {string}
    */
   noSparesNeeded: 'noSparesNeeded',

   /**
    * The operation cannot complete because it is not allowed under the current feature bundle.
    * @const
    * @type {string}
    */
   prohibitedByFeatureBundleViolation: 'prohibitedByFeatureBundleViolation',

   /**
    * An operation requested the controller to assign an unknown authentication method for a target.
    * @const
    * @type {string}
    */
   invalidAuthMethod: 'invalidAuthMethod',

   /**
    * The supplied secret does not conform to the formatting rules for the selected authentication method.
    * @const
    * @type {string}
    */
   invalidSecret: 'invalidSecret',

   /**
    * An attempt was made to set an initiator secret to one that was already set for a target, or vice-versa.
    * @const
    * @type {string}
    */
   secretAlreadyInUse: 'secretAlreadyInUse',

   /**
    * An attempt was made to automatically refresh network parameter information, but the configuration method was set for manual update.
    * @const
    * @type {string}
    */
   manualConfigModeSet: 'manualConfigModeSet',

   /**
    * The operation cannot complete because there are no active iSCSI sessions.
    * @const
    * @type {string}
    */
   noIscsiSessions: 'noIscsiSessions',

   /**
    * The supplied interface reference is invalid.
    * @const
    * @type {string}
    */
   invalidInterfaceref: 'invalidInterfaceref',

   /**
    * The operation cannot complete because of iSCSI initiator topology conflicts.
    * @const
    * @type {string}
    */
   initiatorConflict: 'initiatorConflict',

   /**
    * The pending host could not be configured because the pending host definition is missing the iSCSI initiators discovered on the corresponding physical host.
    * @const
    * @type {string}
    */
   initiatorRemoved: 'initiatorRemoved',

   /**
    * The snapshot cannot be recreated because the base volume has been resized. Instead of recreating the snapshot, delete the snapshot and create another one.
    * @const
    * @type {string}
    */
   basevolSizeChanged: 'basevolSizeChanged',

   /**
    * The operation cannot complete because a referenced volume group doesn't exist.
    * @const
    * @type {string}
    */
   volumeGroupNotExist: 'volumeGroupNotExist',

   /**
    * The operation cannot complete because a volume group is not online
    * @const
    * @type {string}
    */
   volumeGroupNotOnline: 'volumeGroupNotOnline',

   /**
    * A volume group state transition could not be performed because the group is using a hot spare drive in place of a failed drive.
    * @const
    * @type {string}
    */
   volumeGroupHasHotspare: 'volumeGroupHasHotspare',

   /**
    * The volume group state transition cannot be performed because the group is reconfiguring.
    * @const
    * @type {string}
    */
   volumeGroupReconfiguring: 'volumeGroupReconfiguring',

   /**
    * The operation cannot complete because the volume group or disk pool is not in a valid state.
    * @const
    * @type {string}
    */
   volumeGroupStateNotValid: 'volumeGroupStateNotValid',

   /**
    * An attempt was made to quiesce a controller that was not in the optimal state.
    * @const
    * @type {string}
    */
   controllerNotOptimal: 'controllerNotOptimal',

   /**
    * The operation cannot complete because it requires volume, volume group, or free extent capacity in excess of what is available.
    * @const
    * @type {string}
    */
   insufficientCapacity: 'insufficientCapacity',

   /**
    * The operation cannot complete because a volume group is in the exported state.
    * @const
    * @type {string}
    */
   volumeGroupExported: 'volumeGroupExported',

   /**
    * The Volume cannot be configured because it is not in a configurable state.
    * @const
    * @type {string}
    */
   volumeNotConfigurable: 'volumeNotConfigurable',

   /**
    * The Volume Group cannot be configured because it is not in a configurable state.
    * @const
    * @type {string}
    */
   volumeGroupNotConfigurable: 'volumeGroupNotConfigurable',

   /**
    * A drive operation cannot be performed because the drive is not in the correct state for the operation.
    * @const
    * @type {string}
    */
   invalidDriveState: 'invalidDriveState',

   /**
    * An operation on a volume group is requested, but cannot be carried out because the volume group is undergoing reconstruction.
    * @const
    * @type {string}
    */
   volumeGroupReconstructing: 'volumeGroupReconstructing',

   /**
    * An operation on a volume group is requested, but cannot be carried out because the volume group is undergoing copyback.
    * @const
    * @type {string}
    */
   volumeGroupUndergoingCopyback: 'volumeGroupUndergoingCopyback',

   /**
    * A volume group state transition could not be performed because the group is not in the COMPLETE state, i.e, at least one drive is absent, unassigned, or offline.
    * @const
    * @type {string}
    */
   volumeGroupNotComplete: 'volumeGroupNotComplete',

   /**
    * A volume group state transition could not be performed because the group has failed drives.
    * @const
    * @type {string}
    */
   volumeGroupHasFailedDrives: 'volumeGroupHasFailedDrives',

   /**
    * A volume group state transition could not be performed because the group has non-optimal volumes.
    * @const
    * @type {string}
    */
   volumeGroupHasNonOptimalVols: 'volumeGroupHasNonOptimalVols',

   /**
    * A volume group state transition could not be performed because the group is part of a remote mirror relationship.
    * @const
    * @type {string}
    */
   volumeGroupHasMirrorRelationship: 'volumeGroupHasMirrorRelationship',

   /**
    * A volume group state transition could not be performed because the group is part of a volume copy relationship.
    * @const
    * @type {string}
    */
   volumeGroupHasVolcopyRelationship: 'volumeGroupHasVolcopyRelationship',

   /**
    * A volume group state transition could not be performed because the group contains metadata volumes for support of the remote mirroring feature.
    * @const
    * @type {string}
    */
   volumeGroupHasMirroringMetadata: 'volumeGroupHasMirroringMetadata',

   /**
    * A volume group state transition could not be performed because the group has volumes that are assigned to a host cluster (group) or host.
    * @const
    * @type {string}
    */
   volumeGroupHasMappedVols: 'volumeGroupHasMappedVols',

   /**
    * A volume group state transition could not be performed because the group has volumes that have persistent reservations.
    * @const
    * @type {string}
    */
   volumeGroupHasReservations: 'volumeGroupHasReservations',

   /**
    * A volume group state transition could not be performed because one or more of the group's drives contain storage array metadata that is incompatible with this storage array.
    * @const
    * @type {string}
    */
   volumeGroupHasIncompatibleDacstores: 'volumeGroupHasIncompatibleDacstores',

   /**
    * A volume group state transition could not be performed because it would cause the array volume limit to be exceeded.
    * @const
    * @type {string}
    */
   volumeLimitExceeded: 'volumeLimitExceeded',

   /**
    * A volume group state transition could not be performed because the group has a RAID level that is unknown to the firmware.
    * @const
    * @type {string}
    */
   volumeGroupHasUnknownRaidLevel: 'volumeGroupHasUnknownRaidLevel',

   /**
    * A volume group state transition could not be performed because the group has a RAID level that is known to the firmware, but is not supported.
    * @const
    * @type {string}
    */
   volumeGroupHasUnsupportedRaidLevel: 'volumeGroupHasUnsupportedRaidLevel',

   /**
    * A volume group state transition could not be performed because the group has a clone opportunity.
    * @const
    * @type {string}
    */
   volumeGroupHasCloneOpportunity: 'volumeGroupHasCloneOpportunity',

   /**
    * A volume group state transition could not be performed because the group is missing some drives.
    * @const
    * @type {string}
    */
   volumeGroupHasInsufficientDrives: 'volumeGroupHasInsufficientDrives',

   /**
    * A volume group state transition could not be performed because there are failed volumes in the group.
    * @const
    * @type {string}
    */
   volumeGroupHasFailedVols: 'volumeGroupHasFailedVols',

   /**
    * The performance tiering feature could not be enabled because the array feature bundle settings do not allow performance level upgrade via feature key.
    * @const
    * @type {string}
    */
   perfTierSafeUpgradeDisabled: 'perfTierSafeUpgradeDisabled',

   /**
    * A RAID-6-related operation was performed against firmware that does not support RAID 6.
    * @const
    * @type {string}
    */
   raid6FeatureUnsupported: 'raid6FeatureUnsupported',

   /**
    * A RAID-6-related operation was performed against an array that can support RAID 6, but which does not have that feature enabled.
    * @const
    * @type {string}
    */
   raid6FeatureDisabled: 'raid6FeatureDisabled',

   /**
    * An attempt was made to install the RAID 6 feature on a controller where RAID 6 SAFE KEY upgrades are not enabled.
    * @const
    * @type {string}
    */
   safeControllerNotSubjectToRaid6: 'safeControllerNotSubjectToRaid6',

   /**
    * An attempt was made to place a volume group in a forced state, but the volume group was not in the contingent state, as required.
    * @const
    * @type {string}
    */
   volumeGroupNotContingent: 'volumeGroupNotContingent',

   /**
    * An attempt was made to retrieve the results of a drive channel fault isolation diagnostic test before the test completed.
    * @const
    * @type {string}
    */
   channelDiagsRunning: 'channelDiagsRunning',

   /**
    * The diagnostics returned are incomplete because the operation was canceled or did not complete within its allocated time.
    * @const
    * @type {string}
    */
   channelDiagsResultsPartial: 'channelDiagsResultsPartial',

   /**
    * A volume group state transition could not be performed because the group has a non-portable snapshot relationship.
    * @const
    * @type {string}
    */
   volumeGroupHasSnapshotRelationship: 'volumeGroupHasSnapshotRelationship',

   /**
    * The operation cannot complete because the storage array's current configuration violates Premium Feature limitations/compliance.
    * @const
    * @type {string}
    */
   prohibitedBySafeViolation: 'prohibitedBySafeViolation',

   /**
    * A volume group could not be transitioned to forced state because it is a legacy volume group.
    * @const
    * @type {string}
    */
   legacyVg: 'legacyVg',

   /**
    * A volume group could not be transitioned to forced state because it has failed pieces, or does not have enough drives, or has an opportunity for cloning.
    * @const
    * @type {string}
    */
   vgNotForceable: 'vgNotForceable',

   /**
    * The drive channel fault isolation diagnostics function could not continue because of inability to acquire a lock.
    * @const
    * @type {string}
    */
   channelDiagsLockErr: 'channelDiagsLockErr',

   /**
    * The drive channel fault isolation diagnostics function could not continue because of inability to quiesce I/Os.
    * @const
    * @type {string}
    */
   channelDiagsNotQuiesced: 'channelDiagsNotQuiesced',

   /**
    * The drive channel fault isolation diagnostics function could not continue because of inability to communicate with the alternate controller.
    * @const
    * @type {string}
    */
   channelDiagsAltCommFailed: 'channelDiagsAltCommFailed',

   /**
    * The drive channel fault isolation diagnostics function could not continue because of inability to prepare the channel for testing.
    * @const
    * @type {string}
    */
   channelDiagsChanSetupFailed: 'channelDiagsChanSetupFailed',

   /**
    * The drive channel fault isolation diagnostics function could not continue because of inability to bypass a device.
    * @const
    * @type {string}
    */
   channelDiagsDeviceBypassFailed: 'channelDiagsDeviceBypassFailed',

   /**
    * There are no diagnostics results to report - most likely because diagnostics were not started.
    * @const
    * @type {string}
    */
   channelDiagsResultsNotAvailable: 'channelDiagsResultsNotAvailable',

   /**
    * A drive in the storage array could not be spun up.
    * @const
    * @type {string}
    */
   driveSpinUpError: 'driveSpinUpError',

   /**
    * A new drive does not match the type of the drive it is replacing.
    * @const
    * @type {string}
    */
   driveTypeMismatch: 'driveTypeMismatch',

   /**
    * The remote array node WWN and the local array node WWN are the same.
    * @const
    * @type {string}
    */
   localRemoteArrayHasSameWwn: 'localRemoteArrayHasSameWwn',

   /**
    * A volume group being imported has incompatible drives.
    * @const
    * @type {string}
    */
   volumeGroupHasIncompatibleDrive: 'volumeGroupHasIncompatibleDrive',

   /**
    * An attempt was made to import a volume group where the volumes in the volume group are overlapped with the dacstore area of the drives.
    * @const
    * @type {string}
    */
   volumeGroupVolumeEncroachesOnDacstore: 'volumeGroupVolumeEncroachesOnDacstore',

   /**
    * The operation cannot complete because a previous import is still in-progress.
    * @const
    * @type {string}
    */
   volumeGroupImportInProgress: 'volumeGroupImportInProgress',

   /**
    * An attempt was made to import a volume group where the corresponding drives aren't spun up. To spin up the drives, it is necessary to get the import dependency information before importing the volume group..
    * @const
    * @type {string}
    */
   drivesNeedToBeSpunUp: 'drivesNeedToBeSpunUp',

   /**
    * An attempt was made to import or export a volume group when there are no native stable storage drives on the system.
    * @const
    * @type {string}
    */
   noNativeSstor: 'noNativeSstor',

   /**
    * The operation cannot complete because the increment (chunk) number supplied is outside the range of available increments.
    * @const
    * @type {string}
    */
   noSuchDebugChunk: 'noSuchDebugChunk',

   /**
    * The state capture operation has been stopped because the storage array configuration has changed. Make sure there are no configuration changes occurring and then start the operation again.
    * @const
    * @type {string}
    */
   debugInfoConfigChanged: 'debugInfoConfigChanged',

   /**
    * The operation cannot complete because the controller is in a locked down state.
    * @const
    * @type {string}
    */
   lockdown: 'lockdown',

   /**
    * A volume/volume group reconfiguration operation cannot be performed because it involves drives having overlapping DACSTORE regions.
    * @const
    * @type {string}
    */
   drivesDacstoresOverlap: 'drivesDacstoresOverlap',

   /**
    * A volume expansion operation cannot complete because a volume is part of an asynchronous mirror relationship.
    * @const
    * @type {string}
    */
   volumeHasAsyncMirror: 'volumeHasAsyncMirror',

   /**
    * A volume/volume group reconfiguration operation cannot be performed because there is insufficient space in the reconfiguration log.
    * @const
    * @type {string}
    */
   reconfigLogSpaceError: 'reconfigLogSpaceError',

   /**
    * The operation cannot complete because a volume group is inaccessible.
    * @const
    * @type {string}
    */
   volumeGroupInaccessible: 'volumeGroupInaccessible',

   /**
    * The operation cannot complete because a volume in the volume group is being initialized.
    * @const
    * @type {string}
    */
   volumeInitializing: 'volumeInitializing',

   /**
    * The operation cannot complete because the firmware could not allocate sufficient cache memory.
    * @const
    * @type {string}
    */
   insufficientCache: 'insufficientCache',

   /**
    * The operation cannot complete because a volume is inaccessible.
    * @const
    * @type {string}
    */
   volumeInaccessible: 'volumeInaccessible',

   /**
    * The operation cannot complete because no drives could be adopted as part of an import operation.
    * @const
    * @type {string}
    */
   noDrivesAdopted: 'noDrivesAdopted',

   /**
    * Some drives could be adopted, but not all eligible drives.
    * @const
    * @type {string}
    */
   someDrivesAdopted: 'someDrivesAdopted',

   /**
    * The export operation cannot complete for this volume group because one or more of its drive's configuration database region is undergoing a mirror synchronization process. The resynchronization process is a background operation and normally completes within 20 minutes.
    * @const
    * @type {string}
    */
   exportingDrivesDatabaseResynchronizing: 'exportingDrivesDatabaseResynchronizing',

   /**
    * The export operation cannot complete for this volume group because one or more of its drive's configuration database region is not valid and is unusable. It is best to contact a Technical Support Representative for guidance but one possible remedy is to remove the drives associated with this volume group one at a time and then re-insert them to trigger a database resynchronization. However, this is not guaranteed to work.
    * @const
    * @type {string}
    */
   exportingDrivesDatabaseFailed: 'exportingDrivesDatabaseFailed',

   /**
    * The export operation cannot complete because one or more of the volume group's drives are quiesced. This generally occurs when firmware is being downloaded to the drive. Retry the operation at a later time.
    * @const
    * @type {string}
    */
   exportingDrivesQuiesced: 'exportingDrivesQuiesced',

   /**
    * The battery service operation cannot be performed because a learn cycle is active. Retry the operation when the learn cycle has completed.
    * @const
    * @type {string}
    */
   learnActiveTryLater: 'learnActiveTryLater',

   /**
    * All of the storage array's drives are unlocked.
    * @const
    * @type {string}
    */
   noLockedDrives: 'noLockedDrives',

   /**
    * The operation cannot complete because the controller cannot enable the security capabilities of the drive.
    * @const
    * @type {string}
    */
   driveSecurityEnabledFailed: 'driveSecurityEnabledFailed',

   /**
    * The operation to set a new lock key failed for some drive
    * @const
    * @type {string}
    */
   lockkeyFailed: 'lockkeyFailed',

   /**
    * The operation cannot complete because the drives are not secure-enabled.
    * @const
    * @type {string}
    */
   invalidSecurity: 'invalidSecurity',

   /**
    * The operation cannot complete because the drives are not secure-capable.
    * @const
    * @type {string}
    */
   noFdeDrives: 'noFdeDrives',

   /**
    * The operation cannot complete because either (1) the volume was specified to be non-secure but it is being created from a secure volume group or disk pool or (2) a secure request was made and the volume group or disk pool was already secure.
    * @const
    * @type {string}
    */
   volumeGroupSecure: 'volumeGroupSecure',

   /**
    * The provided security key pass phrase is incorrect.
    * @const
    * @type {string}
    */
   invalidBlob: 'invalidBlob',

   /**
    * None of the storage array's drives can be unlocked with the provided security key.
    * @const
    * @type {string}
    */
   unlockFailed: 'unlockFailed',

   /**
    * The import operation cannot complete because a valid key has not been set on the target storage array.
    * @const
    * @type {string}
    */
   noKeySet: 'noKeySet',

   /**
    * The operation cannot complete because the generation of a new security key is currently in progress.
    * @const
    * @type {string}
    */
   rekeyInProgress: 'rekeyInProgress',

   /**
    * Assigning a volume to the default host cluster (group) is not allowed.
    * @const
    * @type {string}
    */
   defaultHostGroupMappingNotAllowed: 'defaultHostGroupMappingNotAllowed',

   /**
    * A media scan is not allowed on the volume because it is part of a volume group or disk pool that consists of solid state drives.
    * @const
    * @type {string}
    */
   ssdMediaScanNotAllowed: 'ssdMediaScanNotAllowed',

   /**
    * The operation cannot complete because the requested feature limit specified exceeds the maximum supported limit for this feature.
    * @const
    * @type {string}
    */
   premiumFeatureLimitExceedsMaximum: 'premiumFeatureLimitExceedsMaximum',

   /**
    * The operation cannot complete because an evaluation key cannot be disabled.
    * @const
    * @type {string}
    */
   disableEvaluationFeatureNotPermitted: 'disableEvaluationFeatureNotPermitted',

   /**
    * The operation cannot complete because either: (1) one or more hosts involved has restricted visibility to LUN 0, or (2) hosts with differing LUN 0 visibility restrictions cannot be part of the same host cluster (group).
    * @const
    * @type {string}
    */
   requestFailedDueToLun0Restrictions: 'requestFailedDueToLun0Restrictions',

   /**
    * The operation cannot complete because external security key management is already enabled.
    * @const
    * @type {string}
    */
   externalKmsEnabled: 'externalKmsEnabled',

   /**
    * The operation cannot complete because a new key cannot be obtained from the key server.
    * @const
    * @type {string}
    */
   externalKmsFailed: 'externalKmsFailed',

   /**
    * The operation cannot complete because the external security key management is not enabled.
    * @const
    * @type {string}
    */
   externalKmsNotEnabled: 'externalKmsNotEnabled',

   /**
    * The operation cannot complete because no security key is needed.
    * @const
    * @type {string}
    */
   keyNotNeeded: 'keyNotNeeded',

   /**
    * The operation cannot complete because the sequence number of the security key did not match the controller sequence number.
    * @const
    * @type {string}
    */
   keyInvalidSequence: 'keyInvalidSequence',

   /**
    * The operation cannot complete because the requested diagnostic is not running.
    * @const
    * @type {string}
    */
   diagNotRunning: 'diagNotRunning',

   /**
    * The operation cannot complete because the controller is not in service mode.
    * @const
    * @type {string}
    */
   ctrlNotInServiceMode: 'ctrlNotInServiceMode',

   /**
    * The operation cannot complete because the specified premium feature was not found on this storage array.
    * @const
    * @type {string}
    */
   invalidFeatureref: 'invalidFeatureref',

   /**
    * The operation cannot complete because the cache backup device does not exist.
    * @const
    * @type {string}
    */
   cacheBackupDevNotExist: 'cacheBackupDevNotExist',

   /**
    * The operation cannot complete because the supplied security key does not match any on the controller.
    * @const
    * @type {string}
    */
   noMatchingLockKeyIdFound: 'noMatchingLockKeyIdFound',

   /**
    * The operation cannot complete because the supplied security key failed validation. The security bundle (key and pass phrase) decrypted correctly, but the key did not match.
    * @const
    * @type {string}
    */
   lockKeyValidationFailed: 'lockKeyValidationFailed',

   /**
    * The operation cannot complete because there were too many unsuccessful security key validation attempts.
    * @const
    * @type {string}
    */
   lockKeyValidationDisabled: 'lockKeyValidationDisabled',

   /**
    * The operation cannot complete because the external security key management feature is out of compliance.
    * @const
    * @type {string}
    */
   externalKmsNotCompliant: 'externalKmsNotCompliant',

   /**
    * The operation cannot complete because the request to the external security key manager timed out.
    * @const
    * @type {string}
    */
   externalKmsTimeout: 'externalKmsTimeout',

   /**
    * The external security key management feature cannot be disabled because the storage array does not have the key from the external server in memory.
    * @const
    * @type {string}
    */
   cannotDisableNoKey: 'cannotDisableNoKey',

   /**
    * The feature cannot be enabled for an evaluation (trial) period because it has already been previously enabled. Only one evaluation period is allowed.
    * @const
    * @type {string}
    */
   previouslyEnabledForEval: 'previouslyEnabledForEval',

   /**
    * The feature cannot be enabled using a feature key file because it is not keyable.
    * @const
    * @type {string}
    */
   featureNotKeyable: 'featureNotKeyable',

   /**
    * The operation cannot complete because an evaluation (trial) period is not supported for this feature.
    * @const
    * @type {string}
    */
   evalNotSupported: 'evalNotSupported',

   /**
    * The operation cannot complete because the raw data transfer type is unknown.
    * @const
    * @type {string}
    */
   rawdataTransferBadType: 'rawdataTransferBadType',

   /**
    * The operation cannot complete because the raw data transfer has not been started.
    * @const
    * @type {string}
    */
   rawdataTransferNotStarted: 'rawdataTransferNotStarted',

   /**
    * The operation cannot complete because another raw data transfer is already started. Another data transfer (retrieval or restore) cannot be started until the current transfer completes.
    * @const
    * @type {string}
    */
   rawdataTransferAlreadyStarted: 'rawdataTransferAlreadyStarted',

   /**
    * The operation cannot complete because the controller received a raw data transfer request from the host but it is still preparing for the transfer.
    * @const
    * @type {string}
    */
   rawdataTransferPreparing: 'rawdataTransferPreparing',

   /**
    * The operation cannot complete because a read error occurred when accessing a drive at the start of or during a data transfer.
    * @const
    * @type {string}
    */
   rawdataTransferReadError: 'rawdataTransferReadError',

   /**
    * The operation cannot complete because the data transfer requires drives and no drives were available.
    * @const
    * @type {string}
    */
   rawdataTransferNoDrives: 'rawdataTransferNoDrives',

   /**
    * The downloaded image did not pass a validity check; one possibility is that it does not contain the correct controller serial numbers for the two controllers in the array.
    * @const
    * @type {string}
    */
   rawdataTransferInvalidImage: 'rawdataTransferInvalidImage',

   /**
    * The operation cannot complete because the CRC value calculated by the controller for the data segment being transferred does not match the CRC value passed to the controller.
    * @const
    * @type {string}
    */
   rawdataTransferCrcError: 'rawdataTransferCrcError',

   /**
    * The operation cannot complete because during a raw data restoration, a write error occurred to a drive.
    * @const
    * @type {string}
    */
   dbmRestoreWriteError: 'dbmRestoreWriteError',

   /**
    * The operation cannot complete because there are not enough drives available upon which to restore the data.
    * @const
    * @type {string}
    */
   dbmRestoreNoDrives: 'dbmRestoreNoDrives',

   /**
    * The operation cannot complete because a sequence number does not match the expected (incremented) value as part of the raw data transfer.
    * @const
    * @type {string}
    */
   rawdataBadSeqNum: 'rawdataBadSeqNum',

   /**
    * The operation cannot complete because this capability is not supported on this storage array.
    * @const
    * @type {string}
    */
   invalidCapability: 'invalidCapability',

   /**
    * The operation cannot complete because the external security key to be validated is not in memory.
    * @const
    * @type {string}
    */
   externalKeyNotInMemory: 'externalKeyNotInMemory',

   /**
    * The operation cannot complete because the supplied security key ID is not valid.
    * @const
    * @type {string}
    */
   invalidLockKeyId: 'invalidLockKeyId',

   /**
    * The operation cannot complete because the volume protection (data assurance) is not valid.
    * @const
    * @type {string}
    */
   invalidProtection: 'invalidProtection',

   /**
    * The operation cannot complete because the volume has a snapshot relationship.
    * @const
    * @type {string}
    */
   volumeHasSnapshotRelationship: 'volumeHasSnapshotRelationship',

   /**
    * The operation cannot complete because the volume has a mirror relationship.
    * @const
    * @type {string}
    */
   volumeHasMirrorRelationship: 'volumeHasMirrorRelationship',

   /**
    * The operation cannot complete because the external security key manager has been disabled but there is no key.
    * @const
    * @type {string}
    */
   externalKmsDisabledNoKey: 'externalKmsDisabledNoKey',

   /**
    * The operation cannot complete because one controller must be placed offline before the database can be restored.
    * @const
    * @type {string}
    */
   dbmRestoreAltCtlNotOffline: 'dbmRestoreAltCtlNotOffline',

   /**
    * The operation cannot complete because the source and target volumes involved are not compatible (application tag owners do not match).
    * @const
    * @type {string}
    */
   copyApptagMismatch: 'copyApptagMismatch',

   /**
    * The operation cannot complete because the request is not valid for the given tray type.
    * @const
    * @type {string}
    */
   invalidRequestForEnclosure: 'invalidRequestForEnclosure',

   /**
    * The operation cannot complete because a set of arguments was specified for a Debug Queue Trace Retrieval that do not match any existing trace files. There is nothing to return.
    * @const
    * @type {string}
    */
   dqRetrieveNothingToTransfer: 'dqRetrieveNothingToTransfer',

   /**
    * When configuring an iSCSI port, if a port's IPv4 Ethernet priority and IPv6 Ethernet priority are not the same value when the IPv4 VLAN ID and IPv6 VLAN ID are both the same value, the configuration request will be rejected with this return code.
    * @const
    * @type {string}
    */
   invalidIscsiConfiguration: 'invalidIscsiConfiguration',

   /**
    * The operation cannot complete because the volume is part of a volume copy relationship.
    * @const
    * @type {string}
    */
   volumeHasVolcopyRelationship: 'volumeHasVolcopyRelationship',

   /**
    * The volume cannot be assigned because it is data assurance (DA) protected and the host or host cluster (group) is not DA capable.
    * @const
    * @type {string}
    */
   partPiIncapable: 'partPiIncapable',

   /**
    * A host port or initiator cannot be added because it is not data assurance (DA) capable and the host or host cluster (group) contains a DA-capable volume.
    * @const
    * @type {string}
    */
   requestFailedDueToPiRestrictions: 'requestFailedDueToPiRestrictions',

   /**
    * The operation cannot complete because the raw data transfer has been canceled.
    * @const
    * @type {string}
    */
   rawdataTransferUserCancelled: 'rawdataTransferUserCancelled',

   /**
    * The operation cannot complete because the IP address being configured would be a duplicate of an existing address.
    * @const
    * @type {string}
    */
   duplicateIscsiIpAddress: 'duplicateIscsiIpAddress',

   /**
    * A port speed conflict was detected while attempting to configure a HIC port. The ports on the HIC must be configured to the same speed.
    * @const
    * @type {string}
    */
   portSpeedConflict: 'portSpeedConflict',

   /**
    * The operation cannot complete because the vendor or product ID is not valid, there is bad IOM (ESM) status, or not all assigned drives are redundant.
    * @const
    * @type {string}
    */
   factoryDefaultDownloadFailed: 'factoryDefaultDownloadFailed',

   /**
    * The operation cannot complete because the controller is unable to write the factory default information into the midplane EEPROM.
    * @const
    * @type {string}
    */
   errorWritingToEeprom: 'errorWritingToEeprom',

   /**
    * Only a partial download occurred. The download was successful to one or more drawers but was unsuccessful to other drawers. Retry the operation.
    * @const
    * @type {string}
    */
   factoryDefaultPartialUpdate: 'factoryDefaultPartialUpdate',

   /**
    * The operation cannot complete because the snapshot volume is in a disabled (stopped) state.
    * @const
    * @type {string}
    */
   snapshotNotActive: 'snapshotNotActive',

   /**
    * The rollback operation cannot start because (1) the snapshot base or repository volumes associated with the reserved capacity are undergoing a reconfiguration operation, (2) another rollback is already in progress to the same base volume, (3) the base volume is either a source or target volume in a volume copy relationship or (4) a repository volume associated with the reserved capacity has unreadable sectors.
    * @const
    * @type {string}
    */
   cannotRollback: 'cannotRollback',

   /**
    * A mirror synchronization is not possible (a new mirror cannot be created and the existing mirror synchronization cannot be resumed) due to a conflicting operation. Wait for the conflicting operation to complete and then retry the operation.
    * @const
    * @type {string}
    */
   mirrorSyncNotPossible: 'mirrorSyncNotPossible',

   /**
    * The firmware download operation on the power supply failed. Retry the operation.
    * @const
    * @type {string}
    */
   psuFirmwareDownloadFailed: 'psuFirmwareDownloadFailed',

   /**
    * The firmware download operation on the power supply cannot complete because of a manufacturing device code mismatch.
    * @const
    * @type {string}
    */
   psuFirmwareUpdateMfgDeviceCodeMismatch: 'psuFirmwareUpdateMfgDeviceCodeMismatch',

   /**
    * The firmware download operation on the power supply cannot complete because at least one of the requested power supplies does not have a redundant power supply.
    * @const
    * @type {string}
    */
   psuFirmwareUpdateNotAllRedundant: 'psuFirmwareUpdateNotAllRedundant',

   /**
    * The firmware download operation on the power supply cannot complete because at least one of the requested power supplies or its redundant power supply is not optimal.
    * @const
    * @type {string}
    */
   psuFirmwareUpdateNotAllOptimal: 'psuFirmwareUpdateNotAllOptimal',

   /**
    * The operation cannot complete because there is insufficient reserved capacity (repository). If possible, increase the reserved capacity and then retry the operation.
    * @const
    * @type {string}
    */
   insufficientRepositoryCapacity: 'insufficientRepositoryCapacity',

   /**
    * The snapshot volume rollback operation (start or resume) cannot complete because of errors accessing the repository volume associated with the reserved capacity. Check your storage management application for any errors noted on the reserved capacity (repository) and follow the recommended recovery procedures before retrying the operation.
    * @const
    * @type {string}
    */
   rollbackStartFailure: 'rollbackStartFailure',

   /**
    * The operation cannot complete because there is already another support bundle collection started (that is, there is an existing active lock). Wait until the current collection has completed and then retry the operation.
    * @const
    * @type {string}
    */
   csbReserveFailed: 'csbReserveFailed',

   /**
    * The release operation on a support bundle reservation lock cannot complete because there is no active lock.
    * @const
    * @type {string}
    */
   csbReleaseFailedNoLock: 'csbReleaseFailedNoLock',

   /**
    * The release operation on a support bundle reservation lock cannot complete because a valid internal lock key was not specified.
    * @const
    * @type {string}
    */
   csbReleaseFailedInvalidKey: 'csbReleaseFailedInvalidKey',

   /**
    * The creation operation cannot complete because an SSD cache already exists.
    * @const
    * @type {string}
    */
   flashcacheAlreadyExists: 'flashcacheAlreadyExists',

   /**
    * The operation cannot complete because the SSD cache premium feature is not enabled.
    * @const
    * @type {string}
    */
   flashcacheFeatureDisabled: 'flashcacheFeatureDisabled',

   /**
    * The suspend operation on the SSD cache cannot complete because it is already suspended.
    * @const
    * @type {string}
    */
   flashcacheAlreadySuspended: 'flashcacheAlreadySuspended',

   /**
    * The resume operation on the SSD cache cannot complete because it is not suspended.
    * @const
    * @type {string}
    */
   flashcacheNotSuspended: 'flashcacheNotSuspended',

   /**
    * The operation cannot complete because the SSD cache I/O (configuration) type specified is not valid.
    * @const
    * @type {string}
    */
   flashcacheInvalidConfigType: 'flashcacheInvalidConfigType',

   /**
    * The operation cannot complete because the snapshot group name is not valid or it already exists.
    * @const
    * @type {string}
    */
   invalidPitGroupLabel: 'invalidPitGroupLabel',

   /**
    * The operation cannot complete because the snapshot consistency group name is not valid or it already exists.
    * @const
    * @type {string}
    */
   invalidPitConsistencyGroupLabel: 'invalidPitConsistencyGroupLabel',

   /**
    * The operation cannot complete because the snapshot group or snapshot consistency group automatic deletion limit specified is not valid.
    * @const
    * @type {string}
    */
   invalidPitAutoDeleteLimit: 'invalidPitAutoDeleteLimit',

   /**
    * The operation cannot complete because the snapshot group or snapshot consistency group full policy specified for the reserved capacity (repository) is not valid.
    * @const
    * @type {string}
    */
   invalidPitRepositoryFullPolicy: 'invalidPitRepositoryFullPolicy',

   /**
    * The operation cannot complete because the name specified for the repository volume associated with the reserved capacity is not valid.
    * @const
    * @type {string}
    */
   invalidConcatVolMemberLabel: 'invalidConcatVolMemberLabel',

   /**
    * The operation cannot complete because the capacity specified for the repository volume associated with the reserved capacity is less than the minimum allowed.
    * @const
    * @type {string}
    */
   concatVolMemberTooSmall: 'concatVolMemberTooSmall',

   /**
    * The operation cannot complete because the snapshot group specified is not valid.
    * @const
    * @type {string}
    */
   invalidPitGroupRef: 'invalidPitGroupRef',

   /**
    * The operation cannot complete because the snapshot image specified is not valid.
    * @const
    * @type {string}
    */
   invalidPitRef: 'invalidPitRef',

   /**
    * The operation cannot complete because a capacity expansion on this volume cannot occur due to feature restrictions.
    * @const
    * @type {string}
    */
   dveNotAllowed: 'dveNotAllowed',

   /**
    * The operation cannot complete because the segment size specified for the volume cannot be changed due to feature restrictions. Please specify a different segment size.
    * @const
    * @type {string}
    */
   dssNotAllowed: 'dssNotAllowed',

   /**
    * The supplied DPL Controller Health Image Tag is invalid.
    * @const
    * @type {string}
    */
   dplCoreDumpInvalidTag: 'dplCoreDumpInvalidTag',

   /**
    * The operation cannot complete because the name specified for the snapshot volume is not valid.
    * @const
    * @type {string}
    */
   invalidPitViewLabel: 'invalidPitViewLabel',

   /**
    * The operation cannot complete because the snapshot volume is not valid.
    * @const
    * @type {string}
    */
   invalidPitViewRef: 'invalidPitViewRef',

   /**
    * The operation cannot complete because the repository volume associated with the reserved capacity is not valid.
    * @const
    * @type {string}
    */
   invalidConcatVolRef: 'invalidConcatVolRef',

   /**
    * The operation cannot complete because the volume is not associated with SSD cache.
    * @const
    * @type {string}
    */
   notFlashcacheVol: 'notFlashcacheVol',

   /**
    * The operation cannot complete because the SSD cache is being deleted.
    * @const
    * @type {string}
    */
   flashcacheDeleted: 'flashcacheDeleted',

   /**
    * The operation cannot complete because an attempt was made to enable SSD cache on a volume that already has it enabled.
    * @const
    * @type {string}
    */
   flashcacheEnabled: 'flashcacheEnabled',

   /**
    * The operation cannot complete because an attempt was made to enable SSD cache on a volume and the SSD cache does not exist.
    * @const
    * @type {string}
    */
   flashcacheNotEnabled: 'flashcacheNotEnabled',

   /**
    * The delete operation cannot complete because the volume is associated with SSD cache.
    * @const
    * @type {string}
    */
   noRepDeletion: 'noRepDeletion',

   /**
    * The operation cannot complete because the maximum number of snapshot images per snapshot group or snapshot consistency group has been reached.
    * @const
    * @type {string}
    */
   maxPitsPerGroupExceeded: 'maxPitsPerGroupExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot images has been reached.
    * @const
    * @type {string}
    */
   maxPitsExceeded: 'maxPitsExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot groups and snapshot consistency groups per base volume has been reached.
    * @const
    * @type {string}
    */
   maxPitGroupsPerBaseExceeded: 'maxPitGroupsPerBaseExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot groups has been reached.
    * @const
    * @type {string}
    */
   maxPitGroupsExceeded: 'maxPitGroupsExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot volumes per snapshot image has been reached.
    * @const
    * @type {string}
    */
   maxViewsPerPitExceeded: 'maxViewsPerPitExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot volumes has been reached.
    * @const
    * @type {string}
    */
   maxViewsExceeded: 'maxViewsExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot consistency groups has been reached.
    * @const
    * @type {string}
    */
   maxConsistencyGroupsExceeded: 'maxConsistencyGroupsExceeded',

   /**
    * The operation cannot complete because the maximum number of snapshot consistency group members has been reached.
    * @const
    * @type {string}
    */
   maxConsistencyGroupMembersExceeded: 'maxConsistencyGroupMembersExceeded',

   /**
    * The operation cannot complete because the maximum number of volumes that can be assigned to hosts has been reached.
    * @const
    * @type {string}
    */
   maxMappableVolumesExceeded: 'maxMappableVolumesExceeded',

   /**
    * The operation cannot complete because the specified snapshot image is not the oldest. You must delete snapshot images from oldest to newest.
    * @const
    * @type {string}
    */
   notOldestPit: 'notOldestPit',

   /**
    * The operation cannot complete because the snapshot volume is disabled (stopped) or failed.
    * @const
    * @type {string}
    */
   viewStopped: 'viewStopped',

   /**
    * The operation cannot complete because the maximum number of repository volumes associated with the reserved capacity has been reached.
    * @const
    * @type {string}
    */
   concatMemberLimitExceeded: 'concatMemberLimitExceeded',

   /**
    * The operation cannot complete because another operation is in progress on the volume or the volume is already a member.
    * @const
    * @type {string}
    */
   invalidMemberVol: 'invalidMemberVol',

   /**
    * The operation cannot complete because the volume is assigned to a host.
    * @const
    * @type {string}
    */
   memberVolMapped: 'memberVolMapped',

   /**
    * The operation cannot complete because the member volume is failed or missing.
    * @const
    * @type {string}
    */
   invalidMemberVolState: 'invalidMemberVolState',

   /**
    * The operation cannot complete because the number of repository volumes (associated with the reserved capacity) specified for removal is not valid. You cannot remove the last repository volume.
    * @const
    * @type {string}
    */
   invalidTrimCount: 'invalidTrimCount',

   /**
    * The operation cannot complete because this change is not allowed on an individual volume member that is part of a snapshot consistency group.
    * @const
    * @type {string}
    */
   pitGroupInConsistencyGroup: 'pitGroupInConsistencyGroup',

   /**
    * The operation cannot complete because this change is not allowed on an individual snapshot image that is part of a snapshot consistency group.
    * @const
    * @type {string}
    */
   pitInConsistencyGroup: 'pitInConsistencyGroup',

   /**
    * The operation cannot complete because this change is not allowed on an individual snapshot volume that is part of a snapshot consistency group.
    * @const
    * @type {string}
    */
   pitViewInConsistencyGroup: 'pitViewInConsistencyGroup',

   /**
    * The operation cannot complete because the member volume does not match the data assurance (DA) and/or security attributes of the existing members, or the member block size is incompatible with existing members or other associated volumes.
    * @const
    * @type {string}
    */
   incompatibleMemberVol: 'incompatibleMemberVol',

   /**
    * The operation cannot complete because one of the repository members specified for removal is in use (has valid repository data) or a request has been made to delete a repository member but the associated base element (snapshot group, snapshot volume, etc.) is not being deleted.
    * @const
    * @type {string}
    */
   volumeInUse: 'volumeInUse',

   /**
    * The operation cannot complete because synchronous mirroring over iSCSI is not supported.
    * @const
    * @type {string}
    */
   rvmOverIscsiNotSupported: 'rvmOverIscsiNotSupported',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group name already exists.
    * @const
    * @type {string}
    */
   arvmGroupUserLabelExists: 'arvmGroupUserLabelExists',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group specified is not valid.
    * @const
    * @type {string}
    */
   arvmGroupDoesNotExist: 'arvmGroupDoesNotExist',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group must be empty.
    * @const
    * @type {string}
    */
   arvmGroupNotEmpty: 'arvmGroupNotEmpty',

   /**
    * The operation cannot complete because the repository volume associated with the reserved capacity is in a failed state.
    * @const
    * @type {string}
    */
   concatVolumeFailed: 'concatVolumeFailed',

   /**
    * The operation cannot complete because the snapshot consistency group specified is not valid.
    * @const
    * @type {string}
    */
   invalidPitConsistencyGroupRef: 'invalidPitConsistencyGroupRef',

   /**
    * The operation cannot complete because the snapshot volume specified for the snapshot consistency group is not valid.
    * @const
    * @type {string}
    */
   invalidPitConsistencyGroupViewRef: 'invalidPitConsistencyGroupViewRef',

   /**
    * The operation cannot complete because the snapshot volume name for the snapshot consistency group is not valid.
    * @const
    * @type {string}
    */
   invalidPitConsistencyGroupViewLabel: 'invalidPitConsistencyGroupViewLabel',

   /**
    * The operation cannot complete because the alternate controller is not in a state that allows the operation.
    * @const
    * @type {string}
    */
   alternateRequiredForOperation: 'alternateRequiredForOperation',

   /**
    * The snapshot image indicated for the specified snapshot volume is not valid. Possible causes are (1) the snapshot image and snapshot volume specified are from different base volumes (they must be the same base volume) or (2) the snapshot image currently has a non-optimal status.
    * @const
    * @type {string}
    */
   invalidPitForView: 'invalidPitForView',

   /**
    * The volume cannot be added to the snapshot consistency group because it would cause the snapshot consistency group to become bound to more than one asynchronous mirror group.
    * @const
    * @type {string}
    */
   consistencyGroupArvmBindingConflict: 'consistencyGroupArvmBindingConflict',

   /**
    * The operation cannot complete because the desired change is disallowed when the snapshot group or snapshot consistency group is associated with one or more volumes in an asynchronous mirroring relationship.
    * @const
    * @type {string}
    */
   attributeFixedByArvm: 'attributeFixedByArvm',

   /**
    * The operation cannot complete because the associated object is in use for a Volume Copy operation. The object could be a snapshot group, source snapshot volume, or the target volume.
    * @const
    * @type {string}
    */
   operationFailedVolumeCopyClone: 'operationFailedVolumeCopyClone',

   /**
    * The creation of a snapshot image was put in the pending state because one or more volumes associated with the operation are part of a mirroring relationship that is currently resynchronizing. Once the resynchronization has completed, the creation will automatically complete and the pending state will be cleared.
    * @const
    * @type {string}
    */
   pitCreatePending: 'pitCreatePending',

   /**
    * The operation cannot complete because the source database image specified for a retrieval or restoration does not exist or cannot be read.
    * @const
    * @type {string}
    */
   dbmDbSourceUnavailable: 'dbmDbSourceUnavailable',

   /**
    * The operation cannot complete because the source database image specified for the restoration does not match what is known about the previous configuration database. It could be a foreign or stale image. Either specify a different database image or contact your Technical Support Engineer for assistance.
    * @const
    * @type {string}
    */
   dbmRestoreSourceMismatch: 'dbmRestoreSourceMismatch',

   /**
    * The operation cannot complete because the critical threshold you specified is not between 0 and 100 or is lower than the warning threshold. Please specify a correct value and then retry the operation.
    * @const
    * @type {string}
    */
   invalidCriticalThreshold: 'invalidCriticalThreshold',

   /**
    * The volume group cannot be exported because it has one or more volumes that are part of an asynchronous mirror relationship. These mirror relationships must be deleted before the volume group can be exported.
    * @const
    * @type {string}
    */
   volumeGroupHasArvmRelationship: 'volumeGroupHasArvmRelationship',

   /**
    * The operation cannot complete because either a secondary volume recovery point needs to be deleted or the reserved capacity (repository) of a secondary volume needs to be increased.
    * @const
    * @type {string}
    */
   arvmRecoveryPointDeletionRequired: 'arvmRecoveryPointDeletionRequired',

   /**
    * The operation cannot complete because there is at least one snapshot group associated with the volume group.
    * @const
    * @type {string}
    */
   volumeGroupHasPitgroupRelationship: 'volumeGroupHasPitgroupRelationship',

   /**
    * The volume group cannot be exported because it has one or more snapshot images associated with it. These snapshot images must be deleted before the volume group can be exported.
    * @const
    * @type {string}
    */
   volumeGroupHasPitviewRelationship: 'volumeGroupHasPitviewRelationship',

   /**
    * The volume group cannot be exported because it has reserved capacity (repository) configured on it. This reserved capacity must be deleted before the volume group can be exported.
    * @const
    * @type {string}
    */
   volumeGroupHasConcatRelationship: 'volumeGroupHasConcatRelationship',

   /**
    * The operation cannot complete because the SSD cache is suspended.
    * @const
    * @type {string}
    */
   flashcacheSuspended: 'flashcacheSuspended',

   /**
    * The operation cannot complete because the volume already has SSD cache enabled on it.
    * @const
    * @type {string}
    */
   flashcacheAlreadyEnabled: 'flashcacheAlreadyEnabled',

   /**
    * The operation cannot complete because the database image being read is corrupted. Retry the operation.
    * @const
    * @type {string}
    */
   dbmDbImageCorrupt: 'dbmDbImageCorrupt',

   /**
    * The operation cannot complete because a volume configured from a volume group cannot be used for the reserved capacity (repository) for an object derived from a disk pool.
    * @const
    * @type {string}
    */
   illegalVolume: 'illegalVolume',

   /**
    * The operation cannot complete because the thin volume's reserved capacity (repository) specified is either greater than 256 GB or is not a multiple of the disk pool's allocation granularity.
    * @const
    * @type {string}
    */
   invalidRepositoryCapacity: 'invalidRepositoryCapacity',

   /**
    * The operation cannot complete because the maximum expansion capacity specified is not valid.
    * @const
    * @type {string}
    */
   invalidProvisionedCapacityQuota: 'invalidProvisionedCapacityQuota',

   /**
    * The operation cannot complete because you are trying to manually expand a thin volume's reserved capacity (repository) and the expansion policy specified is not valid.
    * @const
    * @type {string}
    */
   invalidExpansionPolicy: 'invalidExpansionPolicy',

   /**
    * The operation cannot complete because the thin volume's capacity specified is not valid (either less than 32 MB or greater than 63 TB or the capacity is smaller or equal to the existing capacity). Retry the operation with a valid value.
    * @const
    * @type {string}
    */
   invalidVirtualCapacity: 'invalidVirtualCapacity',

   /**
    * The operation cannot complete because the capacity of an individual repository associated with the reserved capacity cannot be increased.
    * @const
    * @type {string}
    */
   cannotExpandConcatMember: 'cannotExpandConcatMember',

   /**
    * The operation cannot complete because the new threshold is below the capacity that is currently being used.
    * @const
    * @type {string}
    */
   thresholdBelowUsedCapacity: 'thresholdBelowUsedCapacity',

   /**
    * The operation cannot complete because a maximum expansion capacity value cannot be specified when the thin volume has an expansion policy set to manual.
    * @const
    * @type {string}
    */
   invalidExpansionOperation: 'invalidExpansionOperation',

   /**
    * The operation cannot complete because an attempt was made to expand a thin volume's reserved capacity (repository) capacity beyond the thin volume's reported capacity limits.
    * @const
    * @type {string}
    */
   repositoryFull: 'repositoryFull',

   /**
    * The reserved capacity (repository) could not be increased because there is not sufficient disk pool free capacity remaining.
    * @const
    * @type {string}
    */
   insufficientExpansionSpace: 'insufficientExpansionSpace',

   /**
    * The operation cannot complete because the reserved capacity (repository) specified is either greater than 256 GB or is not a multiple of 4 GB.
    * @const
    * @type {string}
    */
   invalidExpansionSize: 'invalidExpansionSize',

   /**
    * The operation cannot complete because the initialization action specified is not valid.
    * @const
    * @type {string}
    */
   invalidReinitAction: 'invalidReinitAction',

   /**
    * The operation cannot complete because the reserved capacity (repository) specified for the initialization is either greater than 256 GB or is not a multiple of 4 GB.
    * @const
    * @type {string}
    */
   invalidReinitCapacity: 'invalidReinitCapacity',

   /**
    * The secondary volume member referenced in the asynchronous mirror consistency group is not valid.
    * @const
    * @type {string}
    */
   invalidIncompleteMemberRef: 'invalidIncompleteMemberRef',

   /**
    * The operation cannot complete because it must be performed by the storage array that is acting in the primary role for this asynchronous mirror consistency group.
    * @const
    * @type {string}
    */
   arvmGroupNotPrimary: 'arvmGroupNotPrimary',

   /**
    * The operation cannot complete because it must be performed by the storage array that is acting in the secondary role for this asynchronous mirror consistency group.
    * @const
    * @type {string}
    */
   arvmGroupNotSecondary: 'arvmGroupNotSecondary',

   /**
    * The operation cannot complete because a volume member of the asynchronous mirror consistency group is in a failed state.
    * @const
    * @type {string}
    */
   arvmMemberFailed: 'arvmMemberFailed',

   /**
    * The operation cannot complete because it can only be performed on an asynchronous mirror consistency group that is suspended.
    * @const
    * @type {string}
    */
   arvmGroupNotSuspended: 'arvmGroupNotSuspended',

   /**
    * The operation cannot complete because of the current state of the asynchronous mirror consistency group or one of its volume members.
    * @const
    * @type {string}
    */
   arvmInvalidMirrorState: 'arvmInvalidMirrorState',

   /**
    * The operation cannot complete because the volume specified is already part of a mirror relationship.
    * @const
    * @type {string}
    */
   arvmVolumeAlreadyInMirrorRelationship: 'arvmVolumeAlreadyInMirrorRelationship',

   /**
    * The operation cannot complete because the maximum number of volume members per asynchronous mirror consistency group has been reached.
    * @const
    * @type {string}
    */
   arvmMemberLimitExceeded: 'arvmMemberLimitExceeded',

   /**
    * The suspend operation cannot complete because of an internal error. Please retry the operation. If this message persists, contact your Technical Support Engineer.
    * @const
    * @type {string}
    */
   arvmSuspendFailure: 'arvmSuspendFailure',

   /**
    * The resume operation cannot complete because of an internal error. Please retry the operation. If this message persists, contact your Technical Support Engineer.
    * @const
    * @type {string}
    */
   arvmResumeFailure: 'arvmResumeFailure',

   /**
    * The manual synchronization operation cannot complete because of an internal error. Please retry the operation. If this message persists, contact your Technical Support Engineer.
    * @const
    * @type {string}
    */
   arvmSynchronizeFailure: 'arvmSynchronizeFailure',

   /**
    * The operation cannot complete because the remote storage array specified was not found.
    * @const
    * @type {string}
    */
   remoteTargetNotFound: 'remoteTargetNotFound',

   /**
    * The operation cannot complete because the volume member specified for the asynchronous mirror consistency group is not valid.
    * @const
    * @type {string}
    */
   arvmMirrorMemberDoesNotExist: 'arvmMirrorMemberDoesNotExist',

   /**
    * The operation cannot complete because the conversion of snapshot volumes (legacy) to snapshot groups would result in exceeding the maximum number of snapshot groups per base volume.
    * @const
    * @type {string}
    */
   snapConversionTooManySnaps: 'snapConversionTooManySnaps',

   /**
    * The base volume has one or more snapshot repositories that are not specified as part of the conversion (i.e. no new repository labels specified for those volume(s)).
    * @const
    * @type {string}
    */
   snapConversionMissingLabel: 'snapConversionMissingLabel',

   /**
    * The operation cannot complete because the asynchronous mirroring feature is not activated.
    * @const
    * @type {string}
    */
   arvmFeatureDeactivated: 'arvmFeatureDeactivated',

   /**
    * The operation cannot complete because the repository volume associated with the reserved capacity has security settings that are not compatible with the related base volume, or a mirror primary/secondary volume.
    * @const
    * @type {string}
    */
   incompatibleRepositorySecurity: 'incompatibleRepositorySecurity',

   /**
    * The operation cannot complete because the secondary volume's security settings are not compatible with that of the primary volume.
    * @const
    * @type {string}
    */
   incompatibleSecondarySecurity: 'incompatibleSecondarySecurity',

   /**
    * The mirror channel protocol between a local and remote storage array do not match.
    * @const
    * @type {string}
    */
   mirrorProtocolMismatch: 'mirrorProtocolMismatch',

   /**
    * The operation cannot complete because there are asynchronous mirrored pairs present on the storage array.
    * @const
    * @type {string}
    */
   arvmAsyncMirrorGroupPresent: 'arvmAsyncMirrorGroupPresent',

   /**
    * The operation cannot complete because the cache parameters cannot be changed on this volume.
    * @const
    * @type {string}
    */
   cacheParametersNotChangeable: 'cacheParametersNotChangeable',

   /**
    * The operation cannot complete because the capacity specified exceeds the maximum capacity for the SSD cache.
    * @const
    * @type {string}
    */
   flashcacheMaxCapacityExceeded: 'flashcacheMaxCapacityExceeded',

   /**
    * The operation cannot complete because the SSD cache is failed.
    * @const
    * @type {string}
    */
   flashcacheFailed: 'flashcacheFailed',

   /**
    * The operation cannot complete because a Controller Health Image restoration is in progress.
    * @const
    * @type {string}
    */
   dplCoreDumpRestoreInProgress: 'dplCoreDumpRestoreInProgress',

   /**
    * The operation cannot complete because the referenced asynchronous mirror consistency group has a volume that is no longer associated with it (orphaned) or the mirrored pair has an incomplete status. If the mirrored pair is incomplete, go to the appropriate storage array to complete the creation process.
    * @const
    * @type {string}
    */
   arvmGroupHasIncompleteMember: 'arvmGroupHasIncompleteMember',

   /**
    * The operation cannot complete because the mirroring connectivity test is already in progress.
    * @const
    * @type {string}
    */
   arvmConnectivityTestAlreadyInProgress: 'arvmConnectivityTestAlreadyInProgress',

   /**
    * The mirroring connectivity test failed because of a network error.
    * @const
    * @type {string}
    */
   arvmConnectivityTestNetworkError: 'arvmConnectivityTestNetworkError',

   /**
    * The mirroring connectivity test failed because it received a timeout error waiting for a response from the remote storage array.
    * @const
    * @type {string}
    */
   arvmConnectivityTestRemoteTimeout: 'arvmConnectivityTestRemoteTimeout',

   /**
    * The mirroring connectivity test failed because it was not able to establish a connection with the remote storage array (internal login error).
    * @const
    * @type {string}
    */
   arvmConnectivityTestLoginFailure: 'arvmConnectivityTestLoginFailure',

   /**
    * The mirroring connectivity test failed because it could not find the remote storage array (name service lookup error).
    * @const
    * @type {string}
    */
   arvmConnectivityTestNameServiceError: 'arvmConnectivityTestNameServiceError',

   /**
    * The mirroring connectivity test failed because of a communication (test-unit ready) failure with the remote volume.
    * @const
    * @type {string}
    */
   arvmConnectivityTestTurError: 'arvmConnectivityTestTurError',

   /**
    * The mirroring connectivity test failed because the remote asynchronous mirror consistency group is missing.
    * @const
    * @type {string}
    */
   arvmConnectivityTestMissingRemoteAmg: 'arvmConnectivityTestMissingRemoteAmg',

   /**
    * The mirroring connectivity test failed because the member volumes between the asynchronous mirror groups do not match.
    * @const
    * @type {string}
    */
   arvmConnectivityTestAmgMemberMismatch: 'arvmConnectivityTestAmgMemberMismatch',

   /**
    * The specified mirror synchronization priority is not valid. Applicable values are 0 (lowest), 1 (low), (2) medium, (3) high, or 4 (highest).
    * @const
    * @type {string}
    */
   invalidSyncPriority: 'invalidSyncPriority',

   /**
    * The operation cannot complete because the specified recovery point age alert threshold is not valid.
    * @const
    * @type {string}
    */
   invalidRecoveryPointAlertThreshold: 'invalidRecoveryPointAlertThreshold',

   /**
    * The specified synchronization threshold is not valid because it cannot be used if the manual resynchronization method has been chosen.
    * @const
    * @type {string}
    */
   invalidSyncAlertThreshold: 'invalidSyncAlertThreshold',

   /**
    * The operation cannot complete because existing volumes must be specified when creating multiple objects.
    * @const
    * @type {string}
    */
   mustSpecifyExistingVolumes: 'mustSpecifyExistingVolumes',

   /**
    * The mirroring connectivity test did not complete within the timeout specified.
    * @const
    * @type {string}
    */
   arvmConnectivityTestTimeoutExceeded: 'arvmConnectivityTestTimeoutExceeded',

   /**
    * The operation cannot complete because the maximum number of SSD cache objects has been reached.
    * @const
    * @type {string}
    */
   flashcacheMaxLimitExceeded: 'flashcacheMaxLimitExceeded',

   /**
    * The operation cannot complete because one or more volumes are using a non-secure capable SSD cache.
    * @const
    * @type {string}
    */
   volsInVgUsingNonSecureCapableFlashcache: 'volsInVgUsingNonSecureCapableFlashcache',

   /**
    * The operation cannot complete because security is disabled for the SSD cache.
    * @const
    * @type {string}
    */
   volsInVgUsingSecureDisabledFlashcache: 'volsInVgUsingSecureDisabledFlashcache',

   /**
    * The operation cannot complete because the key file applied to the storage array to enable a premium feature contains a submodel ID that is not valid. The submodel ID in the key file should either be zero or should match the submodel ID of the storage array. Please contact your Technical Support Engineer for assistance.
    * @const
    * @type {string}
    */
   invalidSubmodelId: 'invalidSubmodelId',

   /**
    * The operation cannot complete because there is a mismatch between the limit value in the premium feature key and what the storage array was expecting. For example, the premium feature key may have been associated with a feature that has limit values. Therefore, the storage array was expecting the key to contain a limit value but the limit in the key is zero. This is not valid and therefore the key is rejected.
    * @const
    * @type {string}
    */
   premiumFeatureLimitMismatch: 'premiumFeatureLimitMismatch',

   /**
    * The operation cannot be completed because the volume group is not importable.
    * @const
    * @type {string}
    */
   volumeGroupNotImportable: 'volumeGroupNotImportable',

   /**
    * The operation cannot be completed because of a primary cache size mismatch.
    * @const
    * @type {string}
    */
   primaryCacheSizeMismatch: 'primaryCacheSizeMismatch',

   /**
    * The operation cannot complete because the SSD cache name is already in use.
    * @const
    * @type {string}
    */
   flashcacheUserLabelExists: 'flashcacheUserLabelExists',

   /**
    * The operation cannot complete because the maximum number of thin volumes allowed would be exceeded.
    * @const
    * @type {string}
    */
   maxThinVolumesExceeded: 'maxThinVolumesExceeded',

   /**
    * The secondary volume does not have sufficient capacity for mirroring with the primary volume. It must have a capacity equal to or greater than the primary volume.
    * @const
    * @type {string}
    */
   arvmInvalidSecondaryCapacity: 'arvmInvalidSecondaryCapacity',

   /**
    * A volume in an asynchronous mirror pair has been removed from the storage array that has the primary role but removal has failed on the secondary storage array. Go to the secondary storage array and remove the remaining volume in the mirrored pair.
    * @const
    * @type {string}
    */
   arvmOnlyPrimaryMemberRemoved: 'arvmOnlyPrimaryMemberRemoved',

   /**
    * A volume in an asynchronous mirror pair has been removed from the storage array that has the secondary role but removal has failed on the primary storage array. Go to the primary storage array and remove the remaining volume in the mirrored pair.
    * @const
    * @type {string}
    */
   arvmOnlySecondaryMemberRemoved: 'arvmOnlySecondaryMemberRemoved',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group is currently suspended.
    * @const
    * @type {string}
    */
   arvmInvalidAmgRequestWhileSuspended: 'arvmInvalidAmgRequestWhileSuspended',

   /**
    * The requested manual synchronization cannot be started because a synchronization is already in progress.
    * @const
    * @type {string}
    */
   arvmManualSyncAlreadyInProgress: 'arvmManualSyncAlreadyInProgress',

   /**
    * The requested manual synchronization cannot be started because the minimum wait time between synchronizations has not been met.
    * @const
    * @type {string}
    */
   arvmManualSyncRetryTooSoon: 'arvmManualSyncRetryTooSoon',

   /**
    * The operation cannot complete because an attempt had been made to delete a disk pool that still has volumes configured on it. The volumes must be deleted before deleting the disk pool.
    * @const
    * @type {string}
    */
   diskPoolNotEmpty: 'diskPoolNotEmpty',

   /**
    * SSD cache cannot be enabled on this volume because either (1) the volume is comprised of SSD drives, (2) the volume and the SSD cache do not have compatible attributes or (3) the volume state is not valid for enabling SSD cache.
    * @const
    * @type {string}
    */
   flashCacheInvalidBaseVol: 'flashCacheInvalidBaseVol',

   /**
    * The operation cannot complete because FDE is not allowed for SSD cache.
    * @const
    * @type {string}
    */
   flashCacheFdeEnablementDisallowed: 'flashCacheFdeEnablementDisallowed',

   /**
    * The operation cannot complete because the asynchronous mirroring feature has not been activated on the remote storage array.
    * @const
    * @type {string}
    */
   remoteArvmFeatureDeactivated: 'remoteArvmFeatureDeactivated',

   /**
    * The operation cannot complete because the asynchronous mirroring feature is disabled on the remote storage array.
    * @const
    * @type {string}
    */
   remoteArvmFeatureDisabled: 'remoteArvmFeatureDisabled',

   /**
    * The operation cannot complete because the associated asynchronous mirror group is missing on the remote storage array.
    * @const
    * @type {string}
    */
   arvmOrphanGroup: 'arvmOrphanGroup',

   /**
    * The operation cannot complete because the associated asynchronous mirror consistency group member is missing on the remote storage array.
    * @const
    * @type {string}
    */
   arvmOrphanMember: 'arvmOrphanMember',

   /**
    * The asynchronous mirror consistency group member cannot be recovered because an associated volume (base, repository associated with reserved capacity, or remote volume) is not currently available.
    * @const
    * @type {string}
    */
   volumeNotAvailable: 'volumeNotAvailable',

   /**
    * The asynchronous mirror consistency group member cannot be recovered because the associated base volume has unreadable sectors.
    * @const
    * @type {string}
    */
   volumeHasUnreadableSectors: 'volumeHasUnreadableSectors',

   /**
    * The operation cannot complete because the thin provisioning premium feature is not enabled.
    * @const
    * @type {string}
    */
   thinProvisioningFeatureDisabled: 'thinProvisioningFeatureDisabled',

   /**
    * The operation cannot complete because the snapshot premium feature is not enabled.
    * @const
    * @type {string}
    */
   pitGroupsFeatureDisabled: 'pitGroupsFeatureDisabled',

   /**
    * The operation cannot complete because the disk pool limit would be exceeded.
    * @const
    * @type {string}
    */
   exceedDiskPoolLimit: 'exceedDiskPoolLimit',

   /**
    * The operation cannot complete because the SSD cache is in a degraded state.
    * @const
    * @type {string}
    */
   flashcacheDegradedState: 'flashcacheDegradedState',

   /**
    * The operation cannot complete because the SSD cache is data assurance (DA) protected and an attempt was made to add a drive that is not DA capable.
    * @const
    * @type {string}
    */
   flashcacheNonDaCapableDriveDisallowed: 'flashcacheNonDaCapableDriveDisallowed',

   /**
    * The operation cannot complete because the maximum number of asynchronous mirror consistency groups allowed would be exceeded.
    * @const
    * @type {string}
    */
   arvmMaxAsyncMirrorGroupsExceeded: 'arvmMaxAsyncMirrorGroupsExceeded',

   /**
    * The operation cannot complete because the maximum number of asynchronous mirror relationships allowed per storage array would be exceeded.
    * @const
    * @type {string}
    */
   arvmMaxMirrorsPerArrayExceeded: 'arvmMaxMirrorsPerArrayExceeded',

   /**
    * The operation cannot complete because the maximum number of all mirror relationships (asynchronous and synchronous) per storage array would be exceeded.
    * @const
    * @type {string}
    */
   maxTotalMirrorsPerArrayExceeded: 'maxTotalMirrorsPerArrayExceeded',

   /**
    * The operation cannot complete because the disk pool capacity would be exceeded.
    * @const
    * @type {string}
    */
   exceedDiskPoolCapacity: 'exceedDiskPoolCapacity',

   /**
    * The operation cannot complete because the maximum volume capacity would be exceeded.
    * @const
    * @type {string}
    */
   exceedMaxVolumeCapacity: 'exceedMaxVolumeCapacity',

   /**
    * The operation cannot complete because the maximum number of asynchronous mirror consistency groups allowed would be exceeded on the remote storage array.
    * @const
    * @type {string}
    */
   arvmRemoteMaxAsyncMirrorGroupsExceeded: 'arvmRemoteMaxAsyncMirrorGroupsExceeded',

   /**
    * The operation cannot complete because the maximum number of asynchronous mirror relationships allowed per storage array would be exceeded on the remote storage array.
    * @const
    * @type {string}
    */
   arvmRemoteMaxMirrorsPerArrayExceeded: 'arvmRemoteMaxMirrorsPerArrayExceeded',

   /**
    * The operation cannot complete because the maximum number of all mirror relationships (asynchronous and synchronous) per storage array would be exceeded on the remote storage array.
    * @const
    * @type {string}
    */
   remoteMaxTotalMirrorsPerArrayExceeded: 'remoteMaxTotalMirrorsPerArrayExceeded',

   /**
    * The operation cannot complete because the synchronization interval specified is not valid.
    * @const
    * @type {string}
    */
   arvmInvalidSyncInterval: 'arvmInvalidSyncInterval',

   /**
    * The operation cannot complete because there is insufficient controller memory on the remote array.
    * @const
    * @type {string}
    */
   remoteNoHeap: 'remoteNoHeap',

   /**
    * The operation cannot complete because there was an internal target error on the remote array.
    * @const
    * @type {string}
    */
   remoteInternalError: 'remoteInternalError',

   /**
    * The operation cannot complete because there was a host mapping error on the remote array.
    * @const
    * @type {string}
    */
   remoteRvmSpmError: 'remoteRvmSpmError',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group member does not exist on the remote storage array.
    * @const
    * @type {string}
    */
   arvmRemoteMirrorMemberDoesNotExist: 'arvmRemoteMirrorMemberDoesNotExist',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group name is already in use on the remote storage array.
    * @const
    * @type {string}
    */
   arvmRemoteGroupUserLabelExists: 'arvmRemoteGroupUserLabelExists',

   /**
    * The operation cannot complete because it must be performed while the remote storage array is acting in the secondary role for this asynchronous mirror consistency group.
    * @const
    * @type {string}
    */
   arvmRemoteGroupNotSecondary: 'arvmRemoteGroupNotSecondary',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group does not exist on the remote storage array.
    * @const
    * @type {string}
    */
   arvmRemoteGroupDoesNotExist: 'arvmRemoteGroupDoesNotExist',

   /**
    * The operation cannot complete because the volumes in the storage arrays have incompatible volume data protection attributes.
    * @const
    * @type {string}
    */
   remoteInvalidProtection: 'remoteInvalidProtection',

   /**
    * The operation cannot complete because of a database error on the remote storage array.
    * @const
    * @type {string}
    */
   remoteDatabaseError: 'remoteDatabaseError',

   /**
    * The operation cannot complete because the asynchronous mirror consistency group must be empty (not have any mirrored pairs) on the remote storage array.
    * @const
    * @type {string}
    */
   arvmRemoteGroupNotEmpty: 'arvmRemoteGroupNotEmpty',

   /**
    * The suspend operation cannot complete on the remote storage array because of an internal error. Please retry the operation. If this message persists, contact your Technical Support Engineer.
    * @const
    * @type {string}
    */
   arvmRemoteSuspendFailure: 'arvmRemoteSuspendFailure',

   /**
    * The resume operation cannot complete on the remote storage array because of an internal error. Please retry the operation. If this message persists, contact your Technical Support Engineer.
    * @const
    * @type {string}
    */
   arvmRemoteResumeFailure: 'arvmRemoteResumeFailure',

   /**
    * The manual synchronization operation cannot complete on the remote storage array because of an internal error. Please retry the operation. If this message persists, contact your Technical Support Engineer.
    * @const
    * @type {string}
    */
   arvmRemoteSynchronizeFailure: 'arvmRemoteSynchronizeFailure',

   /**
    * The operation cannot complete because SSD cache performance modeling is in a state that is not valid for the attempted operation
    * @const
    * @type {string}
    */
   flashcacheInvalidAnalyticsState: 'flashcacheInvalidAnalyticsState',

   /**
    * The operation cannot complete because synchronization is still in progress on the local storage array because of a capacity expansion on a volume.
    * @const
    * @type {string}
    */
   arvmExpansionSynchronizationInProgress: 'arvmExpansionSynchronizationInProgress',

   /**
    * The operation cannot complete because synchronization is still in progress on the remote storage array because of a capacity expansion on a volume.
    * @const
    * @type {string}
    */
   arvmRemoteExpansionSynchronizationInProgress: 'arvmRemoteExpansionSynchronizationInProgress',

   /**
    * The fault indication cannot be cleared because the underlying condition causing the fault still exists.
    * @const
    * @type {string}
    */
   faultConditionStillExists: 'faultConditionStillExists',

   /**
    * The operation must be performed on the alternate controller because there are communication issues from this controller to the remote storage array.
    * @const
    * @type {string}
    */
   remoteTryAlternate: 'remoteTryAlternate',

   /**
    * The asynchronous mirror consistency group has been removed from the local storage array but it was not removed on the remote storage array. Use the management software on the remote storage array to remove the mirror group.
    * @const
    * @type {string}
    */
   arvmOnlyLocalAmgDeleted: 'arvmOnlyLocalAmgDeleted',

   /**
    * The operation cannot complete because a role change is pending for the asynchronous mirror consistency group.
    * @const
    * @type {string}
    */
   arvmRoleChangePending: 'arvmRoleChangePending',

   /**
    * The operation cannot complete because a role change is in progress for the asynchronous mirror consistency group.
    * @const
    * @type {string}
    */
   arvmRoleChangeInProgress: 'arvmRoleChangeInProgress',

   /**
    * The operation cannot complete because a member of the asynchronous mirror consistency group is in a stopped state.
    * @const
    * @type {string}
    */
   arvmMemberStopped: 'arvmMemberStopped',

   /**
    * The operation cannot complete because a reconstruction is already in progress.
    * @const
    * @type {string}
    */
   reconstructionInProgress: 'reconstructionInProgress',

   /**
    * The operation cannot complete because a copyback is in progress.
    * @const
    * @type {string}
    */
   copybackInProgress: 'copybackInProgress',

   /**
    * The Admin password is not set.
    * @const
    * @type {string}
    */
   adminPasswordNotSet: 'adminPasswordNotSet',

   /**
    * The operation cannot complete because there are secure-capable drives in the storage array that are not locked and no key exists.
    * @const
    * @type {string}
    */
   keyDoesNotExist: 'keyDoesNotExist',

   /**
    * The operation cannot complete until recovery actions have been resolved.
    * @const
    * @type {string}
    */
   takeRecoveryActionsFirst: 'takeRecoveryActionsFirst',

   /**
    * The operation cannot complete because the controller health image has not completed backup to the pCache device
    * @const
    * @type {string}
    */
   coredumpBackupInProgress: 'coredumpBackupInProgress',

   /**
    * The operation cannot complete because synchronous mirroring (legacy RVM) does not support an asynchronous mode.
    * @const
    * @type {string}
    */
   legacyRvmAsyncModeUnsupported: 'legacyRvmAsyncModeUnsupported',

   /**
    * The operation cannot complete because an attempt was made to add a volume to a secondary asynchronous mirror consistency group and this volume does not match the primary volume (for example, the primary volume is thin and the new volume is not).
    * @const
    * @type {string}
    */
   arvmIncorrectVolumeType: 'arvmIncorrectVolumeType',

   /**
    * The operation cannot complete because the various settings and thresholds on a thin volume cannot be changed if the thin volume is a member of a secondary asynchronous mirror consistency group.
    * @const
    * @type {string}
    */
   thinVolumeParametersCannotBeModified: 'thinVolumeParametersCannotBeModified',

   /**
    * The operation cannot complete because an attempt was made to add a thin volume to a primary asynchronous mirror consistency group but the remote storage array does not support mirroring thin volumes.
    * @const
    * @type {string}
    */
   arvmRemoteThinNotSupported: 'arvmRemoteThinNotSupported',

   /**
    * The operation cannot complete because the provided SNMP community name is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidCommunityName: 'snmpInvalidCommunityName',

   /**
    * The operation cannot complete because the provided SNMP community permissions are not valid.
    * @const
    * @type {string}
    */
   snmpInvalidCommunityPermission: 'snmpInvalidCommunityPermission',

   /**
    * The operation cannot complete on the designated SNMP community because it is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidCommunityRef: 'snmpInvalidCommunityRef',

   /**
    * The operation cannot complete on the designated SNMP trap destination because it is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidTrapDestinationRef: 'snmpInvalidTrapDestinationRef',

   /**
    * The operation cannot complete because the provided IP address is not valid.
    * @const
    * @type {string}
    */
   invalidIpAddress: 'invalidIpAddress',

   /**
    * The operation cannot complete because the maximum number of communities already exist.
    * @const
    * @type {string}
    */
   snmpMaxCommunitiesExceeded: 'snmpMaxCommunitiesExceeded',

   /**
    * The operation cannot complete because the maximum number of trap destinations already exist.
    * @const
    * @type {string}
    */
   snmpMaxTrapDestinationsExceeded: 'snmpMaxTrapDestinationsExceeded',

   /**
    * The operation cannot complete because a community already exists with the given name.
    * @const
    * @type {string}
    */
   snmpCommunityNameInUse: 'snmpCommunityNameInUse',

   /**
    * The operation cannot complete because a trap destination already exists with the given destination address.
    * @const
    * @type {string}
    */
   snmpTrapDestinationAddressInUse: 'snmpTrapDestinationAddressInUse',

   /**
    * The operation cannot complete because a valid SNMP system variable was not specified.
    * @const
    * @type {string}
    */
   snmpUnknownSystemVariable: 'snmpUnknownSystemVariable',

   /**
    * The operation cannot complete because a valid value for the specified SNMP system variable was not provided.
    * @const
    * @type {string}
    */
   snmpInvalidSystemVariableValue: 'snmpInvalidSystemVariableValue',

   /**
    * The operation cannot complete because the SNMP agent instances on the two controllers are currently incompatible. This would most like occur during a firmware upgrade.
    * @const
    * @type {string}
    */
   snmpIncompatibleFirmware: 'snmpIncompatibleFirmware',

   /**
    * The operation cannot complete because the SNMP agent is disabled on this array.
    * @const
    * @type {string}
    */
   snmpAgentDisabled: 'snmpAgentDisabled',

   /**
    * The operation cannot complete because the SNMP agent failed to initialize.
    * @const
    * @type {string}
    */
   snmpAgentInitFailed: 'snmpAgentInitFailed',

   /**
    * The operation cannot complete because a thin provisioned volume that is part of a secondary asynchronous mirror group failed its initialization request.
    * @const
    * @type {string}
    */
   arvmThinVolInitError: 'arvmThinVolInitError',

   /**
    * The operation cannot complete because a thin volume that is part of a secondary asynchronous mirror consistency group failed its initialization request.
    * @const
    * @type {string}
    */
   arvmRemoteThinVolInitError: 'arvmRemoteThinVolInitError',

   /**
    * The operation cannot be completed because the specified SNMP trap destination is not reachable with the current controller IPV4 network configuration. This could be because: (1) IPV4 is not enabled on at least one port with an active connection on each controller OR (2) the following conditions exist on one or both controllers: (a) the controller is configured with a static IP address (i.e. does not obtain it's IP configuration via DHCP) AND (b) an IPV4 gateway is not assigned on that controller AND (c) the IP address of the controller and the specified trap destination address are not part of the same subnet
    * @const
    * @type {string}
    */
   snmpIncompatibleIpv4Address: 'snmpIncompatibleIpv4Address',

   /**
    * The operation cannot complete because the SNMP trap destination is not reachable with the current controller IPv6 network configuration. This is likely because IPv6 is not enabled on at least one port with an active connection on each controller.
    * @const
    * @type {string}
    */
   snmpIncompatibleIpv6Address: 'snmpIncompatibleIpv6Address',

   /**
    * The operation cannot complete because the number of drives selected is greater than the maximum limit, or at least one of the selected drives cannot be removed from the pool.
    * @const
    * @type {string}
    */
   drivesNotAvailableForRemoval: 'drivesNotAvailableForRemoval',

   /**
    * IPv4 support cannot be disabled because there are existing SNMP trap destinations configured with IPv4 addresses.
    * @const
    * @type {string}
    */
   snmpCannotDisableIpv4: 'snmpCannotDisableIpv4',

   /**
    * IPv6 support cannot be disabled because there are existing SNMP trap destinations configured with IPv6 addresses.
    * @const
    * @type {string}
    */
   snmpCannotDisableIpv6: 'snmpCannotDisableIpv6',

   /**
    * The operation cannot be completed because the resulting IPV4 network configuration would result in existing SNMP trap destinations becoming unreachable. On each controller, either (1) the controller IP address must be obtained via DHCP, (2) an IPV4 gateway must be assigned or (3) the controller IP address must be part of the same subnet as all IPV4 trap destination addresses.
    * @const
    * @type {string}
    */
   snmpIpv4ConfigError: 'snmpIpv4ConfigError',

   /**
    * The operation cannot complete because an IOC Dump is currently in progress.
    * @const
    * @type {string}
    */
   iocDumpInProgress: 'iocDumpInProgress',

   /**
    * The operation cannot complete because an IOC Restore is currently in progress.
    * @const
    * @type {string}
    */
   iocRestoreInProgress: 'iocRestoreInProgress',

   /**
    * The operation cannot complete because the supplied IOC Dump Tag is not valid.
    * @const
    * @type {string}
    */
   iocDumpInvalidTag: 'iocDumpInvalidTag',

   /**
    * The operation cannot complete because it is not supported on the IOM (ESM).
    * @const
    * @type {string}
    */
   unsupportedEsmRequest: 'unsupportedEsmRequest',

   /**
    * The operation cannot complete because it is invalid to have the I/O ports set for Static addressing and have the iSNS set for DHCP.
    * @const
    * @type {string}
    */
   isnsDhcpNotSupported: 'isnsDhcpNotSupported',

   /**
    * The power cycle sequence cannot be performed on this drive because the volume group containing the drive is not redundant.
    * @const
    * @type {string}
    */
   dpcVolumeGroupNotRedundant: 'dpcVolumeGroupNotRedundant',

   /**
    * The power cycle sequence cannot be performed on this drive because a volume containing the drive has not been initialized.
    * @const
    * @type {string}
    */
   dpcVolumeNotInitialized: 'dpcVolumeNotInitialized',

   /**
    * The power cycle sequence cannot be performed on this drive because an exclusive operation is active.
    * @const
    * @type {string}
    */
   dpcExclusiveOperationActive: 'dpcExclusiveOperationActive',

   /**
    * The power sequence failed because the controller firmware was unable to power up the drive.
    * @const
    * @type {string}
    */
   dpcUnableToPowerUpDrive: 'dpcUnableToPowerUpDrive',

   /**
    * The power cycle sequence cannot be performed on this drive because a format operation is active.
    * @const
    * @type {string}
    */
   dpcFormatActive: 'dpcFormatActive',

   /**
    * The power cycle sequence cannot be performed on this drive because there are unreadable sectors present.
    * @const
    * @type {string}
    */
   dpcUnreadableSectorsPresent: 'dpcUnreadableSectorsPresent',

   /**
    * The power cycle sequence cannot be performed on this drive because a power cycle sequence is already in progress.
    * @const
    * @type {string}
    */
   dpcPowerCycleAlreadyInProgress: 'dpcPowerCycleAlreadyInProgress',

   /**
    * The power cycle sequence cannot be performed on this drive because the enclosure containing the drive does not support power cycling a drive slot.
    * @const
    * @type {string}
    */
   dpcEnclosureHardwareUnsupported: 'dpcEnclosureHardwareUnsupported',

   /**
    * The power cycle sequence cannot be performed on this drive because the firmware on the enclosure containing the drive does not support power cycling a drive slot.
    * @const
    * @type {string}
    */
   dpcEnclosureFwDownlevel: 'dpcEnclosureFwDownlevel',

   /**
    * The drive copy operation cannot complete because another drive copy operation is already in progress on this volume group.
    * @const
    * @type {string}
    */
   evacInProgress: 'evacInProgress',

   /**
    * The drive copy operation cannot be cancelled because the system detected that there is no operation currently in progress.
    * @const
    * @type {string}
    */
   noEvacFound: 'noEvacFound',

   /**
    * The drive copy operation cannot complete because no hot spare exists that is appropriate for this volume group.
    * @const
    * @type {string}
    */
   noHotspareAvailable: 'noHotspareAvailable',

   /**
    * The operation could not be performed because a drive is undergoing a service operation.
    * @const
    * @type {string}
    */
   driveServiceInProgress: 'driveServiceInProgress',

   /**
    * The operation cannot complete because a segment size of 4096 is only allowed on volumes in volume groups that contain SSD drives.
    * @const
    * @type {string}
    */
   hdd4kbSegmentsizeNotAllowed: 'hdd4kbSegmentsizeNotAllowed',

   /**
    * The disk pool has no spare drive capacity to support the 'copy drive then fail' operation.
    * @const
    * @type {string}
    */
   diskPoolNoSpareDrives: 'diskPoolNoSpareDrives',

   /**
    * The disk pool has exceeded its spare capacity and can't support the 'copy drive then fail' operation.
    * @const
    * @type {string}
    */
   diskPoolExceedSpareCapacity: 'diskPoolExceedSpareCapacity',

   /**
    * Cannot perform the request because Auto Load Balancing has been disabled by user request.
    * @const
    * @type {string}
    */
   autoLoadBalanceUserDisabled: 'autoLoadBalanceUserDisabled',

   /**
    * Cannot perform the load balance request because of insufficient load history data.
    * @const
    * @type {string}
    */
   autoLoadBalanceInsufficientStatistics: 'autoLoadBalanceInsufficientStatistics',

   /**
    * The load balance operation cannot be performed because the specified LoadBalanceAction is invalid.
    * @const
    * @type {string}
    */
   invalidLoadBalanceAction: 'invalidLoadBalanceAction',

   /**
    * The load balance operation cannot be performed because the specified delay time is invalid.
    * @const
    * @type {string}
    */
   invalidLoadBalanceDelay: 'invalidLoadBalanceDelay',

   /**
    * The IP address specified conflicts with an address reserved for internal controller use.
    * @const
    * @type {string}
    */
   reservedAddress: 'reservedAddress',

   /**
    * The operation cannot complete because the volume is still being created. Check the Operations in Progress indication and try again once the volume has finished its creation process.
    * @const
    * @type {string}
    */
   volumeCreationInProgress: 'volumeCreationInProgress',

   /**
    * The operation cannot complete because the object associated with the specified ref cannot be found.
    * @const
    * @type {string}
    */
   keyValueTagInvalidRef: 'keyValueTagInvalidRef',

   /**
    * The operation cannot complete because the input descriptor contains duplicate entries.
    * @const
    * @type {string}
    */
   keyValueTagInvalidDuplicate: 'keyValueTagInvalidDuplicate',

   /**
    * The Key Value pair cannot be deleted because it is currently in use.
    * @const
    * @type {string}
    */
   keyValueTagInUse: 'keyValueTagInUse',

   /**
    * The workload operation cannot complete because the object associated with the operation cannot be found.
    * @const
    * @type {string}
    */
   workloadInvalidRef: 'workloadInvalidRef',

   /**
    * The operation cannot complete because the object on which you are attempting to perform the operation cannot be found.
    * @const
    * @type {string}
    */
   invalidKeyValueTagObjectReference: 'invalidKeyValueTagObjectReference',

   /**
    * The operation cannot complete because of duplicate items in mapping request.
    * @const
    * @type {string}
    */
   mappingInvalidDuplicate: 'mappingInvalidDuplicate',

   /**
    * This is returned if a download occurs and no reboot whatsoever is expected.
    * @const
    * @type {string}
    */
   downloadCompleteNoReboot: 'downloadCompleteNoReboot',

   /**
    * This is returned at the completion of download, and only MSW is expected to reboot.
    * @const
    * @type {string}
    */
   downloadCompleteMswOnlyReboot: 'downloadCompleteMswOnlyReboot',

   /**
    * The operation cannot complete because the workload name already exists.
    * @const
    * @type {string}
    */
   workloadInvalidDuplicate: 'workloadInvalidDuplicate',

   /**
    * The volume-to-host assignment operation cannot complete because one of the objects associated with the operation cannot be found.
    * @const
    * @type {string}
    */
   mappingInvalidRef: 'mappingInvalidRef',

   /**
    * The deletion operation cannot complete because the workload is currently in use.
    * @const
    * @type {string}
    */
   workloadInUse: 'workloadInUse',

   /**
    * The specified action cannot be performed because embedded external key management is currently enabled.
    * @const
    * @type {string}
    */
   embeddedExternalKeyManagementEnabled: 'embeddedExternalKeyManagementEnabled',

   /**
    * The specified action cannot be performed because the necessary certificate files necessary to authenticate with the external key management server have not been installed.
    * @const
    * @type {string}
    */
   embeddedExternalKeyManagementCertificatesNotInstalled: 'embeddedExternalKeyManagementCertificatesNotInstalled',

   /**
    * The requested operation cannot be completed as it contains all of the drives in the system and can lead to a loss of the overall system configuration. Please retry the operation with a smaller subset of the requested set of drives.
    * @const
    * @type {string}
    */
   illegalOperationOnAllConfigDrives: 'illegalOperationOnAllConfigDrives',

   /**
    * The requested operation cannot be completed as resynchronization of the configuration database is currently in progress. Please wait at least a minute or two to allow the resynchronization to complete then retry the operation again.
    * @const
    * @type {string}
    */
   databaseResyncInProgress: 'databaseResyncInProgress',

   /**
    * The operation cannot complete because necessary key server information (i.e., address or port) is missing.
    * @const
    * @type {string}
    */
   embeddedEkmsKeyserverInfoMissing: 'embeddedEkmsKeyserverInfoMissing',

   /**
    * The operation cannot complete because the client key is missing.
    * @const
    * @type {string}
    */
   embeddedEkmsClientKeyMissing: 'embeddedEkmsClientKeyMissing',

   /**
    * The operation cannot complete because the client certificate is missing.
    * @const
    * @type {string}
    */
   embeddedEkmsClientCertMissing: 'embeddedEkmsClientCertMissing',

   /**
    * The operation cannot complete because the installed client certificate is not the expected certificate.
    * @const
    * @type {string}
    */
   embeddedEkmsClientCertMismatch: 'embeddedEkmsClientCertMismatch',

   /**
    * The operation cannot complete because one of the installed key management server certificates has expired.
    * @const
    * @type {string}
    */
   embeddedEkmsCertExpired: 'embeddedEkmsCertExpired',

   /**
    * The operation cannot complete because the embedded key management proxy is not responding.
    * @const
    * @type {string}
    */
   embeddedEkmsProxyNotResponding: 'embeddedEkmsProxyNotResponding',

   /**
    * The operation cannot complete because a server SSL error was encountered.
    * @const
    * @type {string}
    */
   embeddedEkmsAuthenticationFailure: 'embeddedEkmsAuthenticationFailure',

   /**
    * The operation cannot complete because key ownership was not properly established on the key server.
    * @const
    * @type {string}
    */
   embeddedEkmsKeyOwnerRequired: 'embeddedEkmsKeyOwnerRequired',

   /**
    * The operation cannot complete because the key server is not reachable or encountered general communication errors.
    * @const
    * @type {string}
    */
   embeddedEkmsServerError: 'embeddedEkmsServerError',

   /**
    * The operation cannot complete because the server certificate file is missing.
    * @const
    * @type {string}
    */
   embeddedEkmsServerCertMissing: 'embeddedEkmsServerCertMissing',

   /**
    * The operation cannot complete because the supplied certificate file matches an existing installed certificate.
    * @const
    * @type {string}
    */
   embeddedEkmsCertDuplicate: 'embeddedEkmsCertDuplicate',

   /**
    * The operation cannot complete because the supplied certificate file is invalid.
    * @const
    * @type {string}
    */
   embeddedEkmsCertInvalid: 'embeddedEkmsCertInvalid',

   /**
    * The operation cannot complete because a connection could not be established with the key management server.
    * @const
    * @type {string}
    */
   embeddedEkmsConnectionFailure: 'embeddedEkmsConnectionFailure',

   /**
    * This operation cannot complete because the new password is too long or does not meet the minimum length requirement for this storage array.
    * @const
    * @type {string}
    */
   invalidPasswordLength: 'invalidPasswordLength',

   /**
    * The certificate has been revoked.
    * @const
    * @type {string}
    */
   certRevoked: 'certRevoked',

   /**
    * A controller firmware package was received without digital signatures.
    * @const
    * @type {string}
    */
   missingSignature: 'missingSignature',

   /**
    * The controller firmware failed to validate using the supplied public key and digital signatures.
    * @const
    * @type {string}
    */
   sigValidationFailed: 'sigValidationFailed',

   /**
    * Unable to connect the OCSP (On-line Certificate Status Protocol) responder address.
    * @const
    * @type {string}
    */
   unableToConnectToOcspResponder: 'unableToConnectToOcspResponder',

   /**
    * Can not disable host connectivity reporting when ALB is enabled.
    * @const
    * @type {string}
    */
   requestFailedDueToAlbEnabled: 'requestFailedDueToAlbEnabled',

   /**
    * The requested operation has failed because at least one drive in use lacks path redundancy.
    * @const
    * @type {string}
    */
   driveLacksPathRedundancy: 'driveLacksPathRedundancy',

   /**
    * The operation cannot complete because the controller cannot secure erase the drive with the supplied physical security identifier (PSID).
    * @const
    * @type {string}
    */
   driveSecurityErasePsidFailed: 'driveSecurityErasePsidFailed',

   /**
    * The operation cannot complete because the supplied physical security identifier (PSID) is invalid for the drive. The operation should be retried with the correct PSID.
    * @const
    * @type {string}
    */
   driveSecurityEraseInvalidPsid: 'driveSecurityEraseInvalidPsid',

   /**
    * The drive has an incompatible dulbe setting for the requested operation.
    * @const
    * @type {string}
    */
   driveDulbeIncompatible: 'driveDulbeIncompatible',

   /**
    * The controller time cannot be set as specified because Network Time Protocol (NTP) is enabled and is managing the controller time.
    * @const
    * @type {string}
    */
   setControllerTimeInvalidNtpEnabled: 'setControllerTimeInvalidNtpEnabled',

   /**
    * The remote storage volume feature is not supported
    * @const
    * @type {string}
    */
   remoteTargetVolumeFeatureDisabled: 'remoteTargetVolumeFeatureDisabled',

   /**
    * The maximum number of remote storage volumes has been reached
    * @const
    * @type {string}
    */
   remoteTargetVolumesOverallMaxExceeded: 'remoteTargetVolumesOverallMaxExceeded',

   /**
    * The remote storage group/connection does not exist
    * @const
    * @type {string}
    */
   remoteTargetGroupDoesNotExist: 'remoteTargetGroupDoesNotExist',

   /**
    * The maximum number of remote storage groups/connections has been reached
    * @const
    * @type {string}
    */
   remoteTargetGroupsOverallMaxExceeded: 'remoteTargetGroupsOverallMaxExceeded',

   /**
    * One or more volumes exist for the remote storage group/connection
    * @const
    * @type {string}
    */
   remoteTargetGroupNotEmpty: 'remoteTargetGroupNotEmpty',

   /**
    * The remote storage group/connection could not be found
    * @const
    * @type {string}
    */
   remoteTargetGroupNotFound: 'remoteTargetGroupNotFound',

   /**
    * The remote storage volume could not be found
    * @const
    * @type {string}
    */
   remoteTargetVolumeNotFound: 'remoteTargetVolumeNotFound',

   /**
    * Failure to connect to the remote storage volume
    * @const
    * @type {string}
    */
   remoteTargetVolumeConnectionFailure: 'remoteTargetVolumeConnectionFailure',

   /**
    * A collision was detected for the secret key/owner (already exists)
    * @const
    * @type {string}
    */
   essErrSecretKeyCollision: 'essErrSecretKeyCollision',

   /**
    * Unknown secret key
    * @const
    * @type {string}
    */
   essErrSecretKeyUnknown: 'essErrSecretKeyUnknown',

   /**
    * The secret key is invalid
    * @const
    * @type {string}
    */
   essErrSecretKeyInvalid: 'essErrSecretKeyInvalid',

   /**
    * The requested operation involves volumes with different block sizes which are not compatible.
    * @const
    * @type {string}
    */
   incompatibleBlockSizes: 'incompatibleBlockSizes',

   /**
    * The specified block size is not supported.
    * @const
    * @type {string}
    */
   invalidBlockSize: 'invalidBlockSize',

   /**
    * The data size for the secret is invalid
    * @const
    * @type {string}
    */
   essErrSecretDataSizeInvalid: 'essErrSecretDataSizeInvalid',

   /**
    * The group size for the secret is invalid
    * @const
    * @type {string}
    */
   essErrSecretGroupSizeInvalid: 'essErrSecretGroupSizeInvalid',

   /**
    * The operation cannot complete because the secret is being used
    * @const
    * @type {string}
    */
   essErrSecretInUse: 'essErrSecretInUse',

   /**
    * The secret group could not be found
    * @const
    * @type {string}
    */
   essErrSecretGroupNotFound: 'essErrSecretGroupNotFound',

   /**
    * This ReturnCode is returned when the validateIOTransportAuthenticationSecret RPC has failed due to incorrect guesses on 20 consecutive attempts. Any attempt to use that RPC will return this enum until validation is re-enabled
    * @const
    * @type {string}
    */
   ioTransportSecretValidationDisabled: 'ioTransportSecretValidationDisabled',

   /**
    * The operation could not complete because the alternate controller is in lockdown.
    * @const
    * @type {string}
    */
   alternateLockdown: 'alternateLockdown',

   /**
    * The operation cannot complete because the combination of the selected speed setting and the Forward Error Correction (FEC) mode for this port is invalid. Please check the configured settings and ensure that the combination of settings is supported before retrying the operation.
    * @const
    * @type {string}
    */
   speedFecModeConflict: 'speedFecModeConflict',

   /**
    * Indicates that the Remote Target Group is in a non-optimal state on at least one of the controllers.
    * @const
    * @type {string}
    */
   remoteTargetGroupNotOptimal: 'remoteTargetGroupNotOptimal',

   /**
    * The operation cannot complete because the provided SNMP USM user engine ID type is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserEngineIdType: 'snmpInvalidUsmUserEngineIdType',

   /**
    * The operation cannot complete because the provided SNMP USM user engine ID is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserEngineId: 'snmpInvalidUsmUserEngineId',

   /**
    * The operation cannot complete because the provided SNMP USM user name is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserName: 'snmpInvalidUsmUserName',

   /**
    * The operation cannot complete because the provided SNMP USM user permissions are not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserPermission: 'snmpInvalidUsmUserPermission',

   /**
    * The operation cannot complete because the provided SNMP USM user security level is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserSecurityLevel: 'snmpInvalidUsmUserSecurityLevel',

   /**
    * The operation cannot complete because the provided SNMP USM user authorization protocol is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserAuthProtocol: 'snmpInvalidUsmUserAuthProtocol',

   /**
    * The operation cannot complete because the provided SNMP USM user authorization password is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserAuthPassword: 'snmpInvalidUsmUserAuthPassword',

   /**
    * The operation cannot complete because the provided SNMP USM user privacy protocol is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserPrivProtocol: 'snmpInvalidUsmUserPrivProtocol',

   /**
    * The operation cannot complete because the provided SNMP USM user privacy password is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserPrivPassword: 'snmpInvalidUsmUserPrivPassword',

   /**
    * The operation cannot complete on the designated SNMP USM user because it is not valid.
    * @const
    * @type {string}
    */
   snmpInvalidUsmUserRef: 'snmpInvalidUsmUserRef',

   /**
    * The operation cannot complete because a community exists.
    * @const
    * @type {string}
    */
   snmpCommunityExists: 'snmpCommunityExists',

   /**
    * The operation cannot complete because an USM user exists.
    * @const
    * @type {string}
    */
   snmpUsmUserExists: 'snmpUsmUserExists',

   /**
    * The operation cannot complete because maximum number of USM users will be exceeded.
    * @const
    * @type {string}
    */
   snmpMaxUsmUsersExceeded: 'snmpMaxUsmUsersExceeded',

   /**
    * The operation cannot complete because the engine ID is not present.
    * @const
    * @type {string}
    */
   snmpMissingUsmUserEngineId: 'snmpMissingUsmUserEngineId',

   /**
    * The operation cannot complete because the privacy password is not present.
    * @const
    * @type {string}
    */
   snmpMissingUsmUserPrivPassword: 'snmpMissingUsmUserPrivPassword',

   /**
    * The operation cannot complete because the authorization password is not present.
    * @const
    * @type {string}
    */
   snmpMissingUsmUserAuthPassword: 'snmpMissingUsmUserAuthPassword',

   /**
    * A USM User with the same name and engine ID already exists
    * @const
    * @type {string}
    */
   snmpUsmUserEngineIdExists: 'snmpUsmUserEngineIdExists',

   /**
    * The rekey operation completed successfully but there was an error in deleting the OLD KEY from the External Key Management Server
    * @const
    * @type {string}
    */
   externalKmsOldKeyNotDeleted: 'externalKmsOldKeyNotDeleted',

   /**
    * The target port to LUN mapping feature is not supported by the current submodel.
    * @const
    * @type {string}
    */
   targetPortLunMappingUnsupported: 'targetPortLunMappingUnsupported',

   /**
    * Returned when an operation like trying to create a VG or add a hot spare on a system that only supports disk pools.
    * @const
    * @type {string}
    */
   diskPoolUseOnly: 'diskPoolUseOnly'
};

/**
 * SYMbol Enumerations
 */
symbolAPI.enum = {
   /**
    * The ASUP collection type
    * @enum {string}
    */
   ASUPCollectionType: {
      /**
       * Unknown or unspecified
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Basic collection type
       * @const
       * @type {string}
       */
      basic: 'basic',

      /**
       * Weekly collection
       * @const
       * @type {string}
       */
      weekly: 'weekly',

      /**
       * Event-based collection
       * @const
       * @type {string}
       */
      event: 'event',

      /**
       * Daily collection
       * @const
       * @type {string}
       */
      daily: 'daily',

      /**
       * The complete collection
       * @const
       * @type {string}
       */
      complete: 'complete',

      /**
       * Collect on-demand
       * @const
       * @type {string}
       */
      ondemand: 'ondemand',

      /**
       * Collect all
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * Core dump collection
       * @const
       * @type {string}
       */
      coredump: 'coredump',

      /**
       * Collect the DBM file
       * @const
       * @type {string}
       */
      dbmfile: 'dbmfile',

      /**
       * Collect MEL entries in JSON format
       * @const
       * @type {string}
       */
      fullMel: 'fullMel'
   },

   /**
    * This defines the file type being retrieved in the ASUP bundle.
    * @enum {string}
    */
   ASUPFileType: {
      /**
       * The file type is not specified or unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * JSON file type
       * @const
       * @type {string}
       */
      json: 'json',

      /**
       * Test file type
       * @const
       * @type {string}
       */
      text: 'text',

      /**
       * Binary file type
       * @const
       * @type {string}
       */
      binary: 'binary'
   },

   /**
    * This enumeration is used to control the alarm.
    * @enum {string}
    */
   AlarmControl: {
      /**
       * Enable the alarm.
       * @const
       * @type {string}
       */
      enable: 'enable',

      /**
       * Disable the alarm.
       * @const
       * @type {string}
       */
      disable: 'disable',

      /**
       * Mute the alarm.
       * @const
       * @type {string}
       */
      mute: 'mute',

      /**
       * Refresh the alarm settings from NVSRAM.
       * @const
       * @type {string}
       */
      refresh: 'refresh'
   },

   /**
    * This enumeration is used to determine the alarm status.
    * @enum {string}
    */
   AlarmStatus: {
      /**
       * The alarm status is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The alarm is enabled.
       * @const
       * @type {string}
       */
      enabled: 'enabled',

      /**
       * The alarm is disabled.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The alarm is enabled and sounding.
       * @const
       * @type {string}
       */
      sounding: 'sounding',

      /**
       * The alarm is enabled and muted.
       * @const
       * @type {string}
       */
      muted: 'muted',

      /**
       * The alarm is missing.
       * @const
       * @type {string}
       */
      removed: 'removed'
   },

   /**
    * Describes a change in the ASUP maintenance mode status.
    * @enum {string}
    */
   AsupMaintenanceModeEvent: {
      /**
       * ASUP maintenance mode event unknown
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * ASUP maintenance mode has been enabled
       * @const
       * @type {string}
       */
      enabled: 'enabled',

      /**
       * ASUP maintenance mode has been disabled
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * ASUP maintenance mode configuration request failed
       * @const
       * @type {string}
       */
      configurationRequestFailed: 'configurationRequestFailed'
   },

   /**
    * This enumeration is used to identify the AutoSupport sanitization setting.
    * @enum {string}
    */
   AsupSanitizeSetting: {
      /**
       * The AutoSupport sanitization setting is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The AutoSupport sanitize setting is disabled.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The AutoSupport sanitize settings is all. All content in the AutoSupport bundle will be sanitized.
       * @const
       * @type {string}
       */
      all: 'all'
   },

   /**
    * This enumeration lists the Async Mirror Group connection candidate types.
    * @enum {string}
    */
   AsyncMirrorGroupConnectionCandidateType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The remote target connection already exists.
       * @const
       * @type {string}
       */
      existingRemoteTarget: 'existingRemoteTarget',

      /**
       * The remote target connection is new.
       * @const
       * @type {string}
       */
      newRemoteTarget: 'newRemoteTarget'
   },

   /**
    * Types of AMG connectivity tests.
    * @enum {string}
    */
   AsyncMirrorGroupConnectivityTestType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      connectivityTestUnknown: 'connectivityTestUnknown',

      /**
       * Basic connectivity test.
       * @const
       * @type {string}
       */
      basicConnectivityTest: 'basicConnectivityTest',

      /**
       * Link latency test.
       * @const
       * @type {string}
       */
      linkLatencyTest: 'linkLatencyTest',

      /**
       * Link bandwidth test.
       * @const
       * @type {string}
       */
      linkBandwidthTest: 'linkBandwidthTest'
   },

   /**
    * This enumeration is used to indicate the state of an Async Mirror Group member.
    * @enum {string}
    */
   AsyncMirrorGroupMemberState: {
      /**
       * Invalid/unknown state. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Initial synchronization in progress.
       * @const
       * @type {string}
       */
      initialSync: 'initialSync',

      /**
       * Optimal state.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * Failed member state. This may indicate problems on either the primary or secondary.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * Incomplete Setup. Step 1 of the add member process has completed on the primary array but step 2 on the secondary is yet to be completed.
       * @const
       * @type {string}
       */
      incomplete: 'incomplete',

      /**
       * Mirror member is an orphan (defined as part of the AMG locally but not on the remote).
       * @const
       * @type {string}
       */
      orphan: 'orphan',

      /**
       * Mirror member synchronization has been stopped due to potentially recoverable error condition.
       * @const
       * @type {string}
       */
      stopped: 'stopped'
   },

   /**
    * This enumeration is used to indicate mirror group roles.
    * @enum {string}
    */
   AsyncMirrorGroupRole: {
      /**
       * This state is used if the role is not known.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Primary Role. Data is being sent from this array to remote array.
       * @const
       * @type {string}
       */
      primary: 'primary',

      /**
       * Secondary Role. This array is receiving data for the mirror group from the primary.
       * @const
       * @type {string}
       */
      secondary: 'secondary'
   },

   /**
    * This enumeration describes the current step/progress in an AsyncMirrorGroup role change operation.
    * @enum {string}
    */
   AsyncMirrorGroupRoleChangeProgress: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * No role change in progress.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Role change is pending. Roles will change once sync is complete. Write restrictions currently apply on both primary and secondary volumes.
       * @const
       * @type {string}
       */
      pending: 'pending',

      /**
       * A role change is in progress. Async Mirror Group roles have changed and writes are allowed to the new primary, however background processing continues to achieve creation of a recovery point on new secondary.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress'
   },

   /**
    * The Async Mirror Group state. This is primarily intended to reflect the state/presence of a recovery point on the secondary.
    * @enum {string}
    */
   AsyncMirrorGroupState: {
      /**
       * Invalid/unknown state. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * No complete Recovery Point exists, initial sync in progress.
       * @const
       * @type {string}
       */
      initialSync: 'initialSync',

      /**
       * Recovery Point exists and age is within time objective.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * Recovery Point exists but age is not within time objective.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * No Valid Recovery Point (on one or more members) due to failure condition.
       * @const
       * @type {string}
       */
      rpFailed: 'rpFailed'
   },

   /**
    * This enumeration is used to indicate Async Mirror Sync activity.
    * @enum {string}
    */
   AsyncMirrorSyncActivity: {
      /**
       * Invalid/unknown state. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Sync is currently idle.
       * @const
       * @type {string}
       */
      idle: 'idle',

      /**
       * Sync is currently active.
       * @const
       * @type {string}
       */
      active: 'active',

      /**
       * Sync is currently paused due to link issue (will be idle if user suspended group).
       * @const
       * @type {string}
       */
      paused: 'paused',

      /**
       * Sync has been suspended by a user request.
       * @const
       * @type {string}
       */
      userSuspended: 'userSuspended',

      /**
       * Sync has been suspended by the controller due to an error condition.
       * @const
       * @type {string}
       */
      internallySuspended: 'internallySuspended'
   },

   /**
    * This enumeration is used to describe whether synchronization completed or failed during a specific synchronization sample period.
    * @enum {string}
    */
   AsyncMirrorSyncCompletionType: {
      /**
       * The mirror synchronization completion state is not known.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The synchronization terminated abnormally or was otherwise halted.
       * @const
       * @type {string}
       */
      terminated: 'terminated',

      /**
       * The synchronization completed without error.
       * @const
       * @type {string}
       */
      ok: 'ok'
   },

   /**
    * This enumeration is passed to the getAsyncMirrorSyncStatistics procedure to specify the set of statistics to be returned.
    * @enum {string}
    */
   AsyncMirrorSyncStatisticsRequestType: {
      /**
       * Return only the most recent samples.
       * @const
       * @type {string}
       */
      requestRecentSamples: 'requestRecentSamples',

      /**
       * Return only the samples representing the longest sync times.
       * @const
       * @type {string}
       */
      requestLongestSamples: 'requestLongestSamples',

      /**
       * Return only the samples containing an error.
       * @const
       * @type {string}
       */
      errorSamples: 'errorSamples'
   },

   /**
    * This enumeration identifies the reasons for halt/suspension of an asynchronous mirror group member synchronization.
    * @enum {string}
    */
   AsyncMirrorSyncTerminationReason: {
      /**
       * The reason is unknown.
       * @const
       * @type {string}
       */
      reasonUnknown: 'reasonUnknown',

      /**
       * Synchronization terminated/suspended due to primary mirror repository utilization reaching 100%.
       * @const
       * @type {string}
       */
      primaryRepositoryFull: 'primaryRepositoryFull',

      /**
       * Synchronization terminated/suspended due to secondary mirror repository utilization reaching 100%.
       * @const
       * @type {string}
       */
      secondaryRepositoryFull: 'secondaryRepositoryFull',

      /**
       * Synchronization terminated/suspended due to an error on the primary array.
       * @const
       * @type {string}
       */
      primaryError: 'primaryError',

      /**
       * Synchronization terminated/suspended due to an error on the secondary array.
       * @const
       * @type {string}
       */
      secondaryError: 'secondaryError',

      /**
       * Synchronization interruption due to an immediate role change or manual sync.
       * @const
       * @type {string}
       */
      interruption: 'interruption',

      /**
       * Synchronization terminated/suspended due to a configuration error (error writing configuration database, etc.).
       * @const
       * @type {string}
       */
      configError: 'configError',

      /**
       * Synchronization terminated/suspended due to a user request to suspend.
       * @const
       * @type {string}
       */
      userSuspend: 'userSuspend'
   },

   /**
    * This enumeration describes the type of asynchronous mirror synchronization interval.
    * @enum {string}
    */
   AsyncMirrorSyncType: {
      /**
       * The synchronization type is unknown. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The synchronization was scheduled/periodic.
       * @const
       * @type {string}
       */
      periodic: 'periodic',

      /**
       * The synchronization was manually requested by the storage administrator.
       * @const
       * @type {string}
       */
      manual: 'manual',

      /**
       * The synchronization occurred as part of an initialization when the mirror was first created.
       * @const
       * @type {string}
       */
      initialSync: 'initialSync',

      /**
       * The synchronization occurred as part of an orderly role change.
       * @const
       * @type {string}
       */
      roleChange: 'roleChange'
   },

   /**
    * This enumeration type identifies the available iSCSIauthentication methods. The supportedAuthMethods array in the FeatureParams structure will contain values from this enumeration identifying which iSCSI authentication methods are supported on the storage array.
    * @enum {string}
    */
   AuthenticationMethod: {
      /**
       * There is no authentication method.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The authentication method is Challenge Handshake Authentication Protocol (CHAP).
       * @const
       * @type {string}
       */
      chap: 'chap'
   },

   /**
    * Type of AutoLoadBalance Statistics Log Data to Retrieve from the controller.
    * @enum {string}
    */
   AutoLoadBalanceStatsLogDataType: {
      /**
       * Unknown or invalid statistics log type.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Auto Load Balance summary statistics.
       * @const
       * @type {string}
       */
      summary: 'summary',

      /**
       * Auto Load Balance detailed statistics.
       * @const
       * @type {string}
       */
      details: 'details'
   },

   /**
    * This enumeration object is used to determine the status of a battery component.
    * @enum {string}
    */
   BatteryStatus: {
      /**
       * The battery is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The battery is performing a full charge cycle.
       * @const
       * @type {string}
       */
      fullCharging: 'fullCharging',

      /**
       * The battery is near expiration
       * @const
       * @type {string}
       */
      nearExpiration: 'nearExpiration',

      /**
       * The battery is not working.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The battery is not present.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the battery is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The battery is not part of the configuration.
       * @const
       * @type {string}
       */
      notInConfig: 'notInConfig',

      /**
       * The battery is present, which should not be part of the configuration.
       * @const
       * @type {string}
       */
      configMismatch: 'configMismatch',

      /**
       * A smart battery is undergoing a learn cycle.
       * @const
       * @type {string}
       */
      learning: 'learning',

      /**
       * The battery is over temperature.
       * @const
       * @type {string}
       */
      overtemp: 'overtemp',

      /**
       * The battery has expired.
       * @const
       * @type {string}
       */
      expired: 'expired',

      /**
       * The battery is performing a maintenance charge cycle.
       * @const
       * @type {string}
       */
      maintenanceCharging: 'maintenanceCharging',

      /**
       * Battery is usable but must be replaced
       * @const
       * @type {string}
       */
      replacementRequired: 'replacementRequired'
   },

   /**
    * This enumeration object is used to specify the battery configurations present on a controller.
    * @enum {string}
    */
   BatteryType: {
      /**
       * The batteries for the two controllers are packaged in the same customer-replaceable unit. This type is numerically equivalent to BATTERY_TYPE_CONTROLLER_TRAY.
       * @const
       * @type {string}
       */
      singleSharedCru: 'singleSharedCru',

      /**
       * The batteries for the two controllers are packaged in two individual field-replaceable units. This type is numerically equivalent to BATTERY_TYPE_CONTROLLER.
       * @const
       * @type {string}
       */
      dualIndividualFrus: 'dualIndividualFrus',

      /**
       * The batteries for the two controllers are packaged in two shared customer-replaceable units. This type is numerically equivalent to BATTERY_TYPE_PACK_ICC.
       * @const
       * @type {string}
       */
      dualSharedCrus: 'dualSharedCrus',

      /**
       * The batteries for the two controllers are packaged in two individual customer-replaceable units.
       * @const
       * @type {string}
       */
      dualIndividualCrus: 'dualIndividualCrus'
   },

   /**
    * This enumeration expresses the different operational statuses of the cache backup devices.
    * @enum {string}
    */
   CacheBackupDeviceStatus: {
      /**
       * The status of the backup device is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The backup device is operating correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The backup device is not working.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The backup device is not present.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The backup device is write-protected.
       * @const
       * @type {string}
       */
      writeProtected: 'writeProtected',

      /**
       * The backup device does not respond to the expected command set. Replace the backup device.
       * @const
       * @type {string}
       */
      incompatible: 'incompatible'
   },

   /**
    * This enumeration expresses the different types of the cache backup devices.
    * @enum {string}
    */
   CacheBackupDeviceType: {
      /**
       * The type of the device is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The device is a USB flash drive.
       * @const
       * @type {string}
       */
      usbFlash: 'usbFlash',

      /**
       * The device is an SD flash drive.
       * @const
       * @type {string}
       */
      sdFlash: 'sdFlash',

      /**
       * The device is a SATA flash drive.
       * @const
       * @type {string}
       */
      sataFlash: 'sataFlash'
   },

   /**
    * This enumeration defines the different levels of wear life information that can be reported for the cache backup device.
    * @enum {string}
    */
   CacheBackupDeviceWearLifeReportingLevel: {
      /**
       * Wear life information is not available.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Wear life data reporting is not supported.
       * @const
       * @type {string}
       */
      notReported: 'notReported',

      /**
       * Wear life information cannot be reported for this cache backup device because the device model is not recognized.
       * @const
       * @type {string}
       */
      modelNotRecognized: 'modelNotRecognized',

      /**
       * Only percent life used is reported for this cache backup device.
       * @const
       * @type {string}
       */
      enduranceUsed: 'enduranceUsed',

      /**
       * Percent life used, percent life remaining and average erase count are reported for this cache backup device.
       * @const
       * @type {string}
       */
      stats: 'stats'
   },

   /**
    * This enumeration object is used to specify the value of the cache flush modifier attribute that is maintained on a per-volume basis. This attribute determines the maximum amount of time that "dirty" (i.e. cached, but not yet written to physical storage) data for the volume can be maintained in cache before being flushed to physical storage.
    * @enum {string}
    */
   CacheFlushModifier: {
      /**
       * Cached data will be flushed immediately after it is placed in the cache.
       * @const
       * @type {string}
       */
      flushImmediate: 'flushImmediate',

      /**
       * Cached data will be flushed after 250 milliseconds.
       * @const
       * @type {string}
       */
      flush250Msec: 'flush250Msec',

      /**
       * Cached data will be flushed after 500 milliseconds.
       * @const
       * @type {string}
       */
      flush500Msec: 'flush500Msec',

      /**
       * Cached data will be flushed after 750 milliseconds.
       * @const
       * @type {string}
       */
      flush750Msec: 'flush750Msec',

      /**
       * Cached data will be flushed after 1 second.
       * @const
       * @type {string}
       */
      flush1Sec: 'flush1Sec',

      /**
       * Cached data will be flushed after 1.5 seconds.
       * @const
       * @type {string}
       */
      flush1500Msec: 'flush1500Msec',

      /**
       * Cached data will be flushed after 2 seconds.
       * @const
       * @type {string}
       */
      flush2Sec: 'flush2Sec',

      /**
       * Cached data will be flushed after 5 seconds.
       * @const
       * @type {string}
       */
      flush5Sec: 'flush5Sec',

      /**
       * Cached data will be flushed after 10 seconds.
       * @const
       * @type {string}
       */
      flush10Sec: 'flush10Sec',

      /**
       * Cached data will be flushed after 20 seconds.
       * @const
       * @type {string}
       */
      flush20Sec: 'flush20Sec',

      /**
       * Cached data will be flushed after 60 seconds.
       * @const
       * @type {string}
       */
      flush60Sec: 'flush60Sec',

      /**
       * Cached data will be flushed after 120 seconds.
       * @const
       * @type {string}
       */
      flush120Sec: 'flush120Sec',

      /**
       * Cached data will be flushed after 300 seconds.
       * @const
       * @type {string}
       */
      flush300Sec: 'flush300Sec',

      /**
       * Cached data will be flushed after 1.2 seconds.
       * @const
       * @type {string}
       */
      flush1200Sec: 'flush1200Sec',

      /**
       * Cached data will be flushed after 3600 seconds.
       * @const
       * @type {string}
       */
      flush3600Sec: 'flush3600Sec',

      /**
       * There is no time limit set on dirty cache data.
       * @const
       * @type {string}
       */
      flushInfinite: 'flushInfinite'
   },

   /**
    * This enumeration object is used to specify the type of volume candidate that the client wishes to obtain in a getVolumeCandidates procedure call.
    * @enum {string}
    */
   CandidateSelectionType: {
      /**
       * The caller wishes to obtain volume candidates for creating volumes on existing free extent areas within the storage array.
       * @const
       * @type {string}
       */
      freeExtent: 'freeExtent',

      /**
       * The caller wishes to obtain volume candidates for creating volumes on a new volume group constructed from a set of manually-selected drives.
       * @const
       * @type {string}
       */
      manual: 'manual',

      /**
       * The caller wishes to obtain volume candidates for creating volumes on a new volume group constructed from drives that are automatically selected by the controller. Each volume candidate object will indicate the count, or number, of drives. The controller will not actually select specific drives until the volume creation operation is performed, though.
       * @const
       * @type {string}
       */
      count: 'count'
   },

   /**
    * This enumeration object is used to represent one of a set of possible functional capabilities supported by the RAID controller firmware.
    * @enum {string}
    */
   Capability: {
      /**
       * This capability is intended to be used in cases where a feature identified by a feature ID has no corresponding capability code.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The shared volume capability is supported. When this capability is present, all controllers within the storage array have equal, concurrent access to any given volume. Otherwise, each defined volume is owned by exactly one controller at a time.
       * @const
       * @type {string}
       */
      sharedVolume: 'sharedVolume',

      /**
       * The storage pool capability is supported for up to 4 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo4: 'storagePoolsTo4',

      /**
       * Mixed raid level support within groups
       * @const
       * @type {string}
       */
      mixedRaidlevel: 'mixedRaidlevel',

      /**
       * The automatic code synchronization capability is supported and active. This causes controllers to automatically synchronize their firmware levels to ensure that a multi-controller configuration always uses compatible firmware on all controllers.
       * @const
       * @type {string}
       */
      autoCodeSync: 'autoCodeSync',

      /**
       * The automatic LUN transfer capability is supported and active. This causes a controller to automatically assume ownership (from the alternate controller) of an unowned volume group if the host system attempts to access any volume within the volume group.
       * @const
       * @type {string}
       */
      autoLunTransfer: 'autoLunTransfer',

      /**
       * The sub-LUNs allowed capability is supported and active. When this capability is present, the controller allows volume creation on free extents within an existing volume group. Consequently, multiple volumes can be created per volume group. If this capability is not present, then volume groups are limited to one volume each.
       * @const
       * @type {string}
       */
      subLunsAllowed: 'subLunsAllowed',

      /**
       * The storage pool capability is supported for up to 8 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo8: 'storagePoolsTo8',

      /**
       * The storage pool capability is supported for up to 2 storage partition definitions. When this capability is present, a more generalized I/O path mapping is supported for accessing individual volumes within the array. Without it, a given volume must be addressed using a single, unique logical unit number, regardless of the I/O host that initiates the operation or the I/O channel that is used to perform the volume access. If this capability is not supported, a volume's logical unit number (for I/O access) is determined by the volumeHandle field of the associated Volume object.
       * @const
       * @type {string}
       */
      storagePoolsTo2: 'storagePoolsTo2',

      /**
       * The storage pool capability is supported for up to the maximum storage partition definitions supported by the controller firmware.
       * @const
       * @type {string}
       */
      storagePoolsToMax: 'storagePoolsToMax',

      /**
       * The storage pool capability is supported for up to 64 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo64: 'storagePoolsTo64',

      /**
       * The storage pool capability is supported for up to 16 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo16: 'storagePoolsTo16',

      /**
       * The snapshot copy feature is supported. The Snapshot Copy feature allows the end-user to quickly create a single point-in time image or "snapshot" of a volume.
       * @const
       * @type {string}
       */
      snapshots: 'snapshots',

      /**
       * The remote mirroring feature copy is supported. The Remote Mirroring feature allows the end-user to mirror data from one site to remote site some distance away.
       * @const
       * @type {string}
       */
      remoteMirroring: 'remoteMirroring',

      /**
       * The volume copy feature is supported. Volume copy allows for replicating volume data within a storage array.
       * @const
       * @type {string}
       */
      volumeCopy: 'volumeCopy',

      /**
       * The staged online firmware download feature is supported.
       * @const
       * @type {string}
       */
      stagedDownload: 'stagedDownload',

      /**
       * The controller supports the mixing of drive types within the array. Depending on the NVSRAM configuration of the controller, Mixed Drive Types may be either a premium feature or a capability that is always available.
       * @const
       * @type {string}
       */
      mixedDriveTypes: 'mixedDriveTypes',

      /**
       * The controller is configured (via NVSRAM) as being subject to the Gold Key feature. When the controller is subject to the Gold Key feature and when the Gold Key is enabled, other premium features such as Remote Volume Mirroring, Volume Copy, and Mixed Drive Types (MDT) may also be enabled on the storage array.
       * @const
       * @type {string}
       */
      goldKey: 'goldKey',

      /**
       * The ability to add more drive trays is supported up to a specific limit.
       * @const
       * @type {string}
       */
      driveTrayExpansion: 'driveTrayExpansion',

      /**
       * The ability to migrate a storage array from one feature bundle to another.
       * @const
       * @type {string}
       */
      bundleMigration: 'bundleMigration',

      /**
       * The storage pool capability is supported for up to 128 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo128: 'storagePoolsTo128',

      /**
       * The storage pool capability is supported for up to 256 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo256: 'storagePoolsTo256',

      /**
       * The ability to create and manage RAID 6 volumes.
       * @const
       * @type {string}
       */
      raid6: 'raid6',

      /**
       * The ability to modify the array performance level via a feature key.
       * @const
       * @type {string}
       */
      performanceTier: 'performanceTier',

      /**
       * The storage pool capability is supported for up to 32 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo32: 'storagePoolsTo32',

      /**
       * The storage pool capability is supported for up to 96 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo96: 'storagePoolsTo96',

      /**
       * The storage pool capability is supported for up to 192 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo192: 'storagePoolsTo192',

      /**
       * The storage pool capability is supported for up to 512 storage partition definitions.
       * @const
       * @type {string}
       */
      storagePoolsTo512: 'storagePoolsTo512',

      /**
       * The remote mirroring capability is supported for up to 16 remote mirrors.
       * @const
       * @type {string}
       */
      remoteMirrorsTo16: 'remoteMirrorsTo16',

      /**
       * The remote mirroring capability is supported for up to 32 remote mirrors.
       * @const
       * @type {string}
       */
      remoteMirrorsTo32: 'remoteMirrorsTo32',

      /**
       * The remote mirroring capability is supported for up to 64 remote mirrors.
       * @const
       * @type {string}
       */
      remoteMirrorsTo64: 'remoteMirrorsTo64',

      /**
       * The remote mirroring capability is supported for up to 128 remote mirrors.
       * @const
       * @type {string}
       */
      remoteMirrorsTo128: 'remoteMirrorsTo128',

      /**
       * The snapshots-per-volume capability is supported for up to 4 snapshots per volume.
       * @const
       * @type {string}
       */
      snapshotsPerVolTo4: 'snapshotsPerVolTo4',

      /**
       * The snapshots-per-volume capability is supported for up to 8 snapshots per volume.
       * @const
       * @type {string}
       */
      snapshotsPerVolTo8: 'snapshotsPerVolTo8',

      /**
       * The snapshots-per-volume capability is supported for up to 16 snapshots per volume.
       * @const
       * @type {string}
       */
      snapshotsPerVolTo16: 'snapshotsPerVolTo16',

      /**
       * The snapshots-per-volume capability is supported for up to 2 snapshots per volume.
       * @const
       * @type {string}
       */
      snapshotsPerVolTo2: 'snapshotsPerVolTo2',

      /**
       * The Secure Volume capability is supported. Volumes can reside within secure volume groups.
       * @const
       * @type {string}
       */
      secureVolume: 'secureVolume',

      /**
       * This capability is indicated if the storage array is protection information capable, even if the protection information feature is currently disabled.
       * @const
       * @type {string}
       */
      protectionInformation: 'protectionInformation',

      /**
       * Solid State Disks are supported.
       * @const
       * @type {string}
       */
      ssdSupport: 'ssdSupport',

      /**
       * The storage array is capable of supporting up to 112 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo112: 'driveSlotLimitTo112',

      /**
       * The storage array is capable of supporting up to 120 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo120: 'driveSlotLimitTo120',

      /**
       * The storage array is capable of supporting up to 256 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo256: 'driveSlotLimitTo256',

      /**
       * The storage array is capable of supporting up to 448 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo448: 'driveSlotLimitTo448',

      /**
       * The storage array is capable of supporting up to 480 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo480: 'driveSlotLimitTo480',

      /**
       * This enumeration value is not used.
       * @const
       * @type {string}
       */
      driveSlotLimitToMax: 'driveSlotLimitToMax',

      /**
       * The storage array is capable of supporting up to the specified number of drive slots. This feature is controlled by Type 2 Licensing.
       * @const
       * @type {string}
       */
      driveSlotLimit: 'driveSlotLimit',

      /**
       * The storage array is capable of supporting up to 12 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo12: 'driveSlotLimitTo12',

      /**
       * The storage array is capable of supporting up to 16 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo16: 'driveSlotLimitTo16',

      /**
       * The storage array is capable of supporting up to 24 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo24: 'driveSlotLimitTo24',

      /**
       * The storage array is capable of supporting up to 32 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo32: 'driveSlotLimitTo32',

      /**
       * The storage array is capable of supporting up to 48 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo48: 'driveSlotLimitTo48',

      /**
       * The storage array is capable of supporting up to 60 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo60: 'driveSlotLimitTo60',

      /**
       * The storage array is capable of supporting up to 64 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo64: 'driveSlotLimitTo64',

      /**
       * The storage array is capable of supporting up to 72 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo72: 'driveSlotLimitTo72',

      /**
       * The storage array is capable of supporting up to 96 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo96: 'driveSlotLimitTo96',

      /**
       * The storage array is capable of supporting up to 128 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo128: 'driveSlotLimitTo128',

      /**
       * The storage array is capable of supporting up to 136 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo136: 'driveSlotLimitTo136',

      /**
       * The storage array is capable of supporting up to 144 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo144: 'driveSlotLimitTo144',

      /**
       * The storage array is capable of supporting up to 180 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo180: 'driveSlotLimitTo180',

      /**
       * The storage array is capable of supporting up to 192 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo192: 'driveSlotLimitTo192',

      /**
       * The storage array is capable of supporting up to 272 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo272: 'driveSlotLimitTo272',

      /**
       * The storage array is capable of supporting FDE proxy key management.
       * @const
       * @type {string}
       */
      fdeProxyKeyManagement: 'fdeProxyKeyManagement',

      /**
       * The remote mirroring capability is supported for up to 8 remote mirrors.
       * @const
       * @type {string}
       */
      remoteMirrorsTo8: 'remoteMirrorsTo8',

      /**
       * The storage array is capable of supporting up to 384 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo384: 'driveSlotLimitTo384',

      /**
       * The storage array is capable of supporting up to 300 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo300: 'driveSlotLimitTo300',

      /**
       * The storage array is capable of supporting up to 360 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo360: 'driveSlotLimitTo360',

      /**
       * The storage array is capable of supporting the Flash Read Cache feature. This feature is controlled by Type 2 Licensing.
       * @const
       * @type {string}
       */
      flashReadCache: 'flashReadCache',

      /**
       * Storage Pools are supported. This feature is controlled by Type 2 Licensing.
       * @const
       * @type {string}
       */
      storagePoolsType2: 'storagePoolsType2',

      /**
       * Remote Volume Mirroring is supported. This feature is controlled by Type 2 Licensing.
       * @const
       * @type {string}
       */
      remoteMirroringType2: 'remoteMirroringType2',

      /**
       * Checkpoint-based Async Remote Volume Mirroring is supported. This feature is controlled by Type 2 Licensing. The limit controlled by this key is the total number of Async Mirrors allowed per array.
       * @const
       * @type {string}
       */
      totalNumberOfArvmMirrorsPerArray: 'totalNumberOfArvmMirrorsPerArray',

      /**
       * PiT Groups are supported. This feature is controlled by Type 2 Licensing. The limit controlled by this key is the total number of PiTs per Array.
       * @const
       * @type {string}
       */
      totalNumberOfPitsPerArray: 'totalNumberOfPitsPerArray',

      /**
       * Thin Volume Provisioning is supported. This feature is controlled by Type 2 Licensing. The limit controlled by this key is the total number of Thin Volumes per Array.
       * @const
       * @type {string}
       */
      totalNumberOfThinVolumesPerArray: 'totalNumberOfThinVolumesPerArray',

      /**
       * The storage array is capable of supporting up to 240 drive slots.
       * @const
       * @type {string}
       */
      driveSlotLimitTo240: 'driveSlotLimitTo240',

      /**
       * Snapshots are supported. This feature is controlled by Type 2 Licensing.
       * @const
       * @type {string}
       */
      snapshotsType2: 'snapshotsType2',

      /**
       * Capability code for a premium feature key to enable the feature id FEATURE_ID_TARGET_PORT_LUN_MAPPING.
       * @const
       * @type {string}
       */
      targetPortLunMapping: 'targetPortLunMapping',

      /**
       * The storage array is capable of supporting container based applications.
       * @const
       * @type {string}
       */
      containerBasedApplication: 'containerBasedApplication'
   },

   /**
    * This enumeration data type identifies the types of data patterns that may be used in running the drive channel fault isolation diagnostics.
    * @enum {string}
    */
   ChannelDiagDataPatternType: {
      /**
       * The data pattern is a fixed 32-bit value that is repeated in the data block that is written to the device during the Write phase of the test.
       * @const
       * @type {string}
       */
      fixed: 'fixed',

      /**
       * The data pattern is pseudo-random. The value supplied by the client is used as the seed for a pseudo-random sequence that is used to establish the data pattern in the block that is written to the device during the Write phase of the test.
       * @const
       * @type {string}
       */
      random: 'random'
   },

   /**
    * This enumeration type identifies the types of channel devices on which drive channel fault isolation diagnostics can be run.
    * @enum {string}
    */
   ChannelDiagDeviceType: {
      /**
       * An indication that all channel devices are to be included in the test.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * The device to be tested is a controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The device to be tested is a drive.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * The device to be tested is an ESM.
       * @const
       * @type {string}
       */
      esm: 'esm'
   },

   /**
    * This enumeration type identifies the different status codes that can be reported for a channel diagnostic test.
    * @enum {string}
    */
   ChannelDiagStatus: {
      /**
       * The test completed the requested number of iterations.
       * @const
       * @type {string}
       */
      complete: 'complete',

      /**
       * The test did not complete due to unspecified errors.
       * @const
       * @type {string}
       */
      incomplete: 'incomplete',

      /**
       * The test did not complete due to user cancellation.
       * @const
       * @type {string}
       */
      cancelled: 'cancelled',

      /**
       * The test did not complete due to expiration of the maximum test time.
       * @const
       * @type {string}
       */
      timeExpired: 'timeExpired',

      /**
       * The test did not start due to errors during test preparation.
       * @const
       * @type {string}
       */
      notStarted: 'notStarted'
   },

   /**
    * This enumeration identifies the different types of drive channel fault isolation diagnostic tests.
    * @enum {string}
    */
   ChannelDiagType: {
      /**
       * This value represents the write-read-verify diagnostic test, in which data is first written to a device, then read back and verified.
       * @const
       * @type {string}
       */
      verify: 'verify'
   },

   /**
    * This enumeration object is used to specify the type of channel port parent.
    * @enum {string}
    */
   ChannelPortParentType: {
      /**
       * The channel port parent is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The channel port parent is an ESM
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The channel port parent is a minihub.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The channel port parent is a controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The channel port parent is a host interface card.
       * @const
       * @type {string}
       */
      hic: 'hic'
   },

   /**
    * This enumeration object is used to determine the channel type.
    * @enum {string}
    */
   ChannelType: {
      /**
       * The channel is a host channel.
       * @const
       * @type {string}
       */
      hostside: 'hostside',

      /**
       * The channel is a drive channel.
       * @const
       * @type {string}
       */
      driveside: 'driveside',

      /**
       * The channel is a network management channel.
       * @const
       * @type {string}
       */
      management: 'management'
   },

   /**
    * This enumeration data type indicates whether a CheckedPendingHost matches or does not match a host in the configured topology.
    * @enum {string}
    */
   CheckedPendingHostType: {
      /**
       * The pending host looks like it matches a host in the configured topology.
       * @const
       * @type {string}
       */
      matched: 'matched',

      /**
       * The pending host does not match any host in the configured topology.
       * @const
       * @type {string}
       */
      unmatched: 'unmatched'
   },

   /**
    * This enumeration is used to specify the clock reference when describing the time of the day at which daylight saving time starts or ends. The time of day is specified in seconds since midnight. For example, if daylight saving time ends at 2:00 am in wall clock time, it can be specified by 7200 seconds in the CLOCK_MODE_WALL_CLOCK_TIME mode. In this case, the wall clock time for an end-rule means the same thing as the daylight time.
    * @enum {string}
    */
   ClockMode: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The local wall clock time.
       * @const
       * @type {string}
       */
      wallClockTime: 'wallClockTime',

      /**
       * Local standard time.
       * @const
       * @type {string}
       */
      standardTime: 'standardTime',

      /**
       * Universal Coordinated Time.
       * @const
       * @type {string}
       */
      utcTime: 'utcTime'
   },

   /**
    * This enumeration defines the different action types to be used when requesting a CoW repository analysis.
    * @enum {string}
    */
   CoWRepositoryAnalysisAction: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The analysis will be performed on all failed repositories.
       * @const
       * @type {string}
       */
      failedRepositories: 'failedRepositories',

      /**
       * The analysis will be performed on a specific repository.
       * @const
       * @type {string}
       */
      specificRepository: 'specificRepository'
   },

   /**
    * Identifies a specific code module within the loaded firmware
    * @enum {string}
    */
   CodeModule: {
      /**
       * Invalid or unknown code module
       * @const
       * @type {string}
       */
      unspecified: 'unspecified',

      /**
       * The RAID controller firmware code module
       * @const
       * @type {string}
       */
      raid: 'raid',

      /**
       * Hypervisor and hypervisor control code module
       * @const
       * @type {string}
       */
      hypervisor: 'hypervisor',

      /**
       * Embedded management code module
       * @const
       * @type {string}
       */
      management: 'management',

      /**
       * IOM firmware code module
       * @const
       * @type {string}
       */
      iom: 'iom',

      /**
       * Loadable NVSRAM code module
       * @const
       * @type {string}
       */
      nvsram: 'nvsram',

      /**
       * Downloadable comprehensive bundle of code modules
       * @const
       * @type {string}
       */
      bundle: 'bundle',

      /**
       * User-visible display for the comprehensive bundle of code modules
       * @const
       * @type {string}
       */
      bundleDisplay: 'bundleDisplay',

      /**
       * Represents the version of the backup NVSRAM file contained in the filesystem of the baseOS, or an indicator that there is not a back up NVSRAM file. If there is no back up NVSRAM file, the version will be replaced with "None".
       * @const
       * @type {string}
       */
      backupNvsram: 'backupNvsram'
   },

   /**
    * This enumeration describes the command protocol (e.g. SCSI vs. NVMe).
    * @enum {string}
    */
   CommandProtocol: {
      /**
       * The command protocol is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The command protocol is SCSI.
       * @const
       * @type {string}
       */
      scsi: 'scsi',

      /**
       * The command protocol is NVMe.
       * @const
       * @type {string}
       */
      nvme: 'nvme'
   },

   /**
    * This enumeration describes the command set type (e.g. to descriminate between the NVMe and NVMe over Fabrics command sets).
    * @enum {string}
    */
   CommandSetType: {
      /**
       * The command set is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The command set is NVMe.
       * @const
       * @type {string}
       */
      nvme: 'nvme',

      /**
       * The command set is NVMe over Fabrics.
       * @const
       * @type {string}
       */
      nvmeof: 'nvmeof'
   },

   /**
    * This enumeration defines the removal methods that apply to any component.
    * @enum {string}
    */
   ComponentRemovalMethod: {
      /**
       * This removal method indicates that the component is housed in a parent container, and is not independently removable.
       * @const
       * @type {string}
       */
      parent: 'parent',

      /**
       * This removal method indicates that the component is an independently removable item.
       * @const
       * @type {string}
       */
      self: 'self'
   },

   /**
    * Replacement methods that apply to any component.
    * @enum {string}
    */
   ComponentReplacementMethod: {
      /**
       * This replacement method indicates that the component is housed in a parent container, and cannot be removed from the parent for replacement. In order to repair the component, the entire parent container must be replaced.
       * @const
       * @type {string}
       */
      parent: 'parent',

      /**
       * This replacement method indicates that the component is an independently replaceable item, regardless of whether or not it is housed in a parent container.
       * @const
       * @type {string}
       */
      self: 'self'
   },

   /**
    * This enumeration defines the different types of components that may be reported within a storage array.
    * @enum {string}
    */
   ComponentType: {
      /**
       * The component type is not known.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The component is a cooling fan.
       * @const
       * @type {string}
       */
      fan: 'fan',

      /**
       * The component is a cache hold-up battery.
       * @const
       * @type {string}
       */
      battery: 'battery',

      /**
       * The component is a power supply.
       * @const
       * @type {string}
       */
      powerSupply: 'powerSupply',

      /**
       * The component is a thermal sensor module.
       * @const
       * @type {string}
       */
      thermalSensor: 'thermalSensor',

      /**
       * The component is an enclosure services module.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The component is an uninterruptible power supply.
       * @const
       * @type {string}
       */
      ups: 'ups',

      /**
       * The component is a Fibre Channel mini-hub module.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The component is a Fibre Channel GBIC module.
       * @const
       * @type {string}
       */
      gbic: 'gbic',

      /**
       * The component is an SFP.
       * @const
       * @type {string}
       */
      sfp: 'sfp',

      /**
       * The component is an Interconnect CRU.
       * @const
       * @type {string}
       */
      interconnectCru: 'interconnectCru',

      /**
       * The component is a Support CRU.
       * @const
       * @type {string}
       */
      supportCru: 'supportCru',

      /**
       * The component is an alarm.
       * @const
       * @type {string}
       */
      alarm: 'alarm',

      /**
       * The component is a host board.
       * @const
       * @type {string}
       */
      hostboard: 'hostboard',

      /**
       * The component is a SAS expander integrated circuit.
       * @const
       * @type {string}
       */
      icSasExpander: 'icSasExpander',

      /**
       * This component type is numerically equivalent to COMP_TYPE_HOSTBOARD. It has been added so that the component type terminology for host cards lines up with the major event log location terminology. Either one of the two enumeration values may be used.
       * @const
       * @type {string}
       */
      hostIoCard: 'hostIoCard',

      /**
       * The component is a non-volatile storage device for preserving the contents of the controller cache memory in the event of a power loss.
       * @const
       * @type {string}
       */
      cacheBackupDevice: 'cacheBackupDevice',

      /**
       * The component is a cache memory DIMM.
       * @const
       * @type {string}
       */
      cacheMemDimm: 'cacheMemDimm',

      /**
       * The component is a processor memory DIMM.
       * @const
       * @type {string}
       */
      procMemDimm: 'procMemDimm',

      /**
       * The component is a channel port. Note that ChannelPorts are not included in the component bundle.
       * @const
       * @type {string}
       */
      channelPort: 'channelPort',

      /**
       * The component is a disk drive. Note that Drives are not included in the component bundle.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * The component is a controller. Note that Controllers are not included in the component bundle.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The component is an Ethernet interface. Note that interfaces are not included in the component bundle.
       * @const
       * @type {string}
       */
      ethernetInterface: 'ethernetInterface',

      /**
       * The component is a Fibre Channel interface. Note that interfaces are not included in the component bundle.
       * @const
       * @type {string}
       */
      fibreInterface: 'fibreInterface',

      /**
       * The component is an Infiniband interface. Note that interfaces are not included in the component bundle.
       * @const
       * @type {string}
       */
      ibInterface: 'ibInterface',

      /**
       * The component is an iSCSI interface. Note that interfaces are not included in the component bundle.
       * @const
       * @type {string}
       */
      iscsiInterface: 'iscsiInterface',

      /**
       * The component is a SAS interface. Note that interfaces are not included in the component bundle.
       * @const
       * @type {string}
       */
      sasInterface: 'sasInterface',

      /**
       * The component is a Tray. Note that Trays are not included in the component bundle.
       * @const
       * @type {string}
       */
      tray: 'tray',

      /**
       * The component is a StorageArray. Note that Storage Arrays are not included in the component bundle.
       * @const
       * @type {string}
       */
      storageArray: 'storageArray',

      /**
       * The component is a drive drawer.
       * @const
       * @type {string}
       */
      drawer: 'drawer'
   },

   /**
    * This enumeration is used to specify the Concatenated Volume candidate type.
    * @enum {string}
    */
   ConcatVolumeCandidateType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The Concatenated Volume candidate is a new volume.
       * @const
       * @type {string}
       */
      newVol: 'newVol',

      /**
       * The Concatenated Volume candidate is made from existing volumes.
       * @const
       * @type {string}
       */
      existingVols: 'existingVols',

      /**
       * Used for expanding the last member of an existing Concatenated Volume. Only valid on Disk Pools.
       * @const
       * @type {string}
       */
      expansion: 'expansion'
   },

   /**
    * This enumeration is used to specify the Concatenated Volume Member reference type.
    * @enum {string}
    */
   ConcatVolumeMemberRefType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The type is a volume reference.
       * @const
       * @type {string}
       */
      volref: 'volref',

      /**
       * The type is a label.
       * @const
       * @type {string}
       */
      label: 'label'
   },

   /**
    * This enumeration is used to convey the status of a concatenated volume.
    * @enum {string}
    */
   ConcatVolumeStatus: {
      /**
       * The concatenated volume status is unknown. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The concatenated volume is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The concatenated volume is degraded.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The concatenated volume has failed.
       * @const
       * @type {string}
       */
      failed: 'failed'
   },

   /**
    * This enumeration lists the different error modes for which a controller may be operating. The controller's functionality may be diminished if it is operating in one of the these modes.
    * @enum {string}
    */
   ControllerErrorModeType: {
      /**
       * The controller is not operating in an error mode.
       * @const
       * @type {string}
       */
      notInErrorMode: 'notInErrorMode',

      /**
       * The controller is operating in an error mode but the specific mode is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The controller is operating in T10 PI Service Mode.
       * @const
       * @type {string}
       */
      t10PiServiceMode: 't10PiServiceMode',

      /**
       * The controller is operating in T10 PI lockdown error mode.
       * @const
       * @type {string}
       */
      t10PiLockdown: 't10PiLockdown'
   },

   /**
    * This enumeration object is used to describe the type of channel to which a controller GBIC belongs.
    * @enum {string}
    */
   ControllerGBICType: {
      /**
       * The GBIC resides on a host-side interface.
       * @const
       * @type {string}
       */
      hostside: 'hostside',

      /**
       * The GBIC resides on a drive-side interface.
       * @const
       * @type {string}
       */
      driveside: 'driveside'
   },

   /**
    * This enumeration object is used to describe the controller's redundancy expectations. The redundancyMode field in the FeatureParams structure will contain a value from this enumeration identifying whether the system is Simplex or Duplex. If the value is set to CTRL_REDUNDANCY_MODE_SIMPLEX, the controller firmware doesn't allow Controller B of the pair to boot and ignores redundancy errors. If the value is set to CTLR_REDUNDANCY_MODE_DUPLEX, it will behave like a duplex controller, allowing controller B to boot and reporting redundancy errors.
    * @enum {string}
    */
   ControllerRedundancyMode: {
      /**
       * The controller redundancy mode is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The controller is in Duplex redundancy mode, so the controller firmware allows Controller B of the pair to boot and reports redundancy errors.
       * @const
       * @type {string}
       */
      duplex: 'duplex',

      /**
       * The controller is in Simplex redundancy mode, so the controller firmware doesn't allow Controller B of the pair to boot and ignores redundancy errors.
       * @const
       * @type {string}
       */
      simplex: 'simplex'
   },

   /**
    * This enumeration object is used to describe the type of channel to which a controller SFP belongs.
    * @enum {string}
    */
   ControllerSFPType: {
      /**
       * The SFP resides on a host-side interface.
       * @const
       * @type {string}
       */
      hostside: 'hostside',

      /**
       * The SFP resides on a drive-side interface.
       * @const
       * @type {string}
       */
      driveside: 'driveside'
   },

   /**
    * This enumeration identifies the possible controller status values that can be returned in a Controller object.
    * @enum {string}
    */
   ControllerStatus: {
      /**
       * The controller status is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The controller status is currently optimal, or fully functional.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The controller is in the failed state.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The controller has been removed from the system.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The controller detected a RPA memory parity error.
       * @const
       * @type {string}
       */
      rpaParErr: 'rpaParErr',

      /**
       * The controller is in service mode.
       * @const
       * @type {string}
       */
      serviceMode: 'serviceMode',

      /**
       * The controller is suspended.
       * @const
       * @type {string}
       */
      suspended: 'suspended',

      /**
       * The controller has experienced certain errors or component failures, such that it is still functional, but in need of service or replacement.
       * @const
       * @type {string}
       */
      degraded: 'degraded'
   },

   /**
    * This identifies which data sets are to be returned.
    * @enum {string}
    */
   CounterGroupDataLocation: {
      /**
       * The counter data type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Return saved counter data.
       * @const
       * @type {string}
       */
      saved: 'saved',

      /**
       * Return active counter data.
       * @const
       * @type {string}
       */
      active: 'active',

      /**
       * Return saved and active counter data.
       * @const
       * @type {string}
       */
      all: 'all'
   },

   /**
    * This enumeration type identifies the different types of counter group statistics that are provided by the controller firmware.
    * @enum {string}
    */
   CounterGroupType: {
      /**
       * This enumeration value is associated with a group of drive-related counters.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * This enumeration value is associated with a group of RAID-implementation-related counters.
       * @const
       * @type {string}
       */
      implementation: 'implementation',

      /**
       * This enumeration value is associated with a group of channel-I/O-related counters.
       * @const
       * @type {string}
       */
      io: 'io',

      /**
       * This enumeration value is associated with a group of volume-related counters.
       * @const
       * @type {string}
       */
      volume: 'volume',

      /**
       * This enumeration value is associated with a group of controller related counters.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * This enumeration value is associated with a group of interface related stats counters.
       * @const
       * @type {string}
       */
      iointerface: 'iointerface'
   },

   /**
    * This enumeration identifies the type of CRU a component has.
    * @enum {string}
    */
   CruType: {
      /**
       * The type of CRU is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The component has its own dedicated CRU.
       * @const
       * @type {string}
       */
      dedicated: 'dedicated',

      /**
       * The component shares the CRU with other components.
       * @const
       * @type {string}
       */
      shared: 'shared',

      /**
       * This value is identical in meaning to CRU_TYPE_SHARED, i.e., it means the component shares the CRU with other components. The difference is that, in the RTRAttributes structure, this value is associated with a reference to the parent CRU in which the shared components reside.
       * @const
       * @type {string}
       */
      aggregate: 'aggregate'
   },

   /**
    * This enumeration object is used to specify the desired RAID level for a DDP volume in the VolumeCandidateRequest
    * @enum {string}
    */
   DDPVolRAIDLevel: {
      /**
       * This value is used to request volume candidates of all supported RAID levels in the DDP
       * @const
       * @type {string}
       */
      raidAll: 'raidAll',

      /**
       * This value is used to request volume candidates of RAID6 in the DDP. It must be 0 to maintain backward compatibility such that legacy clients, which do not set the ddpVolumeRAIDLevel field in the VolumeCandidateRequest when requesting RAID_DISK_POOL volume candidates, will continue to get RAID6 free extent volume candidates returned from getVolumeCandidates.
       * @const
       * @type {string}
       */
      raid6: 'raid6',

      /**
       * This value is used to request volume candidates of RAID1 in the DDP
       * @const
       * @type {string}
       */
      raid1: 'raid1'
   },

   /**
    * This enumeration identifies the reason for a DPL core dump.
    * @enum {string}
    */
   DPLCoreDumpReason: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      reasonUnknown: 'reasonUnknown',

      /**
       * The DPL core dump happened because of an assertion.
       * @const
       * @type {string}
       */
      reasonAssert: 'reasonAssert',

      /**
       * The DPL core dump happened because of a panic.
       * @const
       * @type {string}
       */
      reasonPanic: 'reasonPanic',

      /**
       * The DPL core dump happened for a reason other than a panic or an assertion.
       * @const
       * @type {string}
       */
      reasonOther: 'reasonOther'
   },

   /**
    * This enumeration lists the data check statuses.
    * @enum {string}
    */
   DataCheck: {
      /**
       * The data check has been skipped.
       * @const
       * @type {string}
       */
      skipped: 'skipped',

      /**
       * The data check passed.
       * @const
       * @type {string}
       */
      passed: 'passed',

      /**
       * The data check failed.
       * @const
       * @type {string}
       */
      failed: 'failed'
   },

   /**
    * This enumeration defines the possible database accessibility modes.
    * @enum {string}
    */
   DatabaseAccessibility: {
      /**
       * The database accessibility is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The database is offline.
       * @const
       * @type {string}
       */
      offline: 'offline',

      /**
       * The database is in read only mode.
       * @const
       * @type {string}
       */
      readOnly: 'readOnly',

      /**
       * The database is in read/write mode.
       * @const
       * @type {string}
       */
      readWrite: 'readWrite',

      /**
       * The database is in recovery mode.
       * @const
       * @type {string}
       */
      recoveryMode: 'recoveryMode'
   },

   /**
    * This enumeration defines the possible database states.
    * @enum {string}
    */
   DatabaseStatus: {
      /**
       * The database status is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The database is optimal.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The database is stale.
       * @const
       * @type {string}
       */
      stale: 'stale',

      /**
       * The database is mismatched.
       * @const
       * @type {string}
       */
      mismatch: 'mismatch',

      /**
       * The database is invalid.
       * @const
       * @type {string}
       */
      invalid: 'invalid',

      /**
       * The database is frozen.
       * @const
       * @type {string}
       */
      frozen: 'frozen',

      /**
       * The database is empty.
       * @const
       * @type {string}
       */
      empty: 'empty'
   },

   /**
    * This enumeration associates days of the month to bit masks.
    * @enum {string}
    */
   DayOfMonth: {
      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonthNotSpecified: 'dayOfMonthNotSpecified',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth01: 'dayOfMonth01',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth02: 'dayOfMonth02',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth03: 'dayOfMonth03',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth04: 'dayOfMonth04',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth05: 'dayOfMonth05',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth06: 'dayOfMonth06',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth07: 'dayOfMonth07',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth08: 'dayOfMonth08',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth09: 'dayOfMonth09',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth10: 'dayOfMonth10',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth11: 'dayOfMonth11',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth12: 'dayOfMonth12',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth13: 'dayOfMonth13',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth14: 'dayOfMonth14',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth15: 'dayOfMonth15',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth16: 'dayOfMonth16',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth17: 'dayOfMonth17',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth18: 'dayOfMonth18',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth19: 'dayOfMonth19',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth20: 'dayOfMonth20',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth21: 'dayOfMonth21',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth22: 'dayOfMonth22',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth23: 'dayOfMonth23',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth24: 'dayOfMonth24',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth25: 'dayOfMonth25',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth26: 'dayOfMonth26',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth27: 'dayOfMonth27',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth28: 'dayOfMonth28',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth29: 'dayOfMonth29',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth30: 'dayOfMonth30',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonth31: 'dayOfMonth31',

      /**
       * Obsolete.
       * @const
       * @type {string}
       */
      dayOfMonthLast: 'dayOfMonthLast'
   },

   /**
    * This enumeration associates days of the week to bit masks.
    * @enum {string}
    */
   DayOfWeek: {
      /**
       * No day is specified.
       * @const
       * @type {string}
       */
      notSpecified: 'notSpecified',

      /**
       * The day of the week is Sunday.
       * @const
       * @type {string}
       */
      sunday: 'sunday',

      /**
       * The day of the week is Monday.
       * @const
       * @type {string}
       */
      monday: 'monday',

      /**
       * The day of the week is Tuesday.
       * @const
       * @type {string}
       */
      tuesday: 'tuesday',

      /**
       * The day of the week is Wednesday.
       * @const
       * @type {string}
       */
      wednesday: 'wednesday',

      /**
       * The day of the week is Thursday.
       * @const
       * @type {string}
       */
      thursday: 'thursday',

      /**
       * The day of the week is Friday.
       * @const
       * @type {string}
       */
      friday: 'friday',

      /**
       * The day of the week is Saturday.
       * @const
       * @type {string}
       */
      saturday: 'saturday'
   },

   /**
    * This enumeration specifies the Dbm database location.
    * @enum {string}
    */
   DbmDatabaseLocation: {
      /**
       * The database location is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The database location is DACStore.
       * @const
       * @type {string}
       */
      dacstoreDisks: 'dacstoreDisks',

      /**
       * The database location is onboard cache (controller relative).
       * @const
       * @type {string}
       */
      onboardRpa: 'onboardRpa',

      /**
       * The database location is a host image.
       * @const
       * @type {string}
       */
      hostImage: 'hostImage'
   },

   /**
    * The set of record types in the configuration; defines the data set.
    * @enum {string}
    */
   DbmRecConfigType: {
      /**
       * Empty set
       * @const
       * @type {string}
       */
      configNone: 'configNone',

      /**
       * Most record types from Erie and earlier, includes the traditional volume groups (non-Disk Pool)
       * @const
       * @type {string}
       */
      traditionalConfig: 'traditionalConfig',

      /**
       * Includes the traditional record types, the disk pool record types, and other record types added later.
       * @const
       * @type {string}
       */
      configAll: 'configAll',

      /**
       * Defines the minimum safe record set for restoration purposes.
       * @const
       * @type {string}
       */
      partialConfig: 'partialConfig'
   },

   /**
    * This enumeration defines the different failure types that can be returned from a logical or block level consistency check on the Database Manager (DBM) file system.
    * @enum {string}
    */
   DbmValidationStatus: {
      /**
       * Validation finished without any detected problems.
       * @const
       * @type {string}
       */
      ok: 'ok',

      /**
       * Memory allocation failed.
       * @const
       * @type {string}
       */
      noHeap: 'noHeap',

      /**
       * I/O error occurred to all native drives.
       * @const
       * @type {string}
       */
      ioError: 'ioError',

      /**
       * Dependent singleton instance not available (most likely too early in Start of Day).
       * @const
       * @type {string}
       */
      earlyExecution: 'earlyExecution',

      /**
       * Fatal error, file system detected to be invalid.
       * @const
       * @type {string}
       */
      fatalFsInvalid: 'fatalFsInvalid',

      /**
       * Fatal error, block number in root directory found to be unrealistic.
       * @const
       * @type {string}
       */
      fatalRootOutOfBounds: 'fatalRootOutOfBounds',

      /**
       * Fatal error, block number found to be referenced multiple times.
       * @const
       * @type {string}
       */
      fatalDupBlockPointers: 'fatalDupBlockPointers',

      /**
       * Fatal error, block number in file system directory found to be unrealistic.
       * @const
       * @type {string}
       */
      fatalDirOutOfBounds: 'fatalDirOutOfBounds',

      /**
       * Fatal error, metadata structure with invalid field.
       * @const
       * @type {string}
       */
      fatalCorruptMetadata: 'fatalCorruptMetadata',

      /**
       * Fatal error, expected metadata structure missing.
       * @const
       * @type {string}
       */
      fatalMissingMetadata: 'fatalMissingMetadata',

      /**
       * Fatal error, record number found to be unrealistic.
       * @const
       * @type {string}
       */
      fatalRecOutOfBounds: 'fatalRecOutOfBounds',

      /**
       * Fatal error, record number found to be referenced multiple times.
       * @const
       * @type {string}
       */
      fatalDupRecPointers: 'fatalDupRecPointers',

      /**
       * Fatal error, record number refers to no allocated block.
       * @const
       * @type {string}
       */
      fatalRecordUnallocated: 'fatalRecordUnallocated',

      /**
       * Fatal error, allocated file system block not referenced by database.
       * @const
       * @type {string}
       */
      fatalOrphanBlock: 'fatalOrphanBlock',

      /**
       * Fatal error, file system offline (no corruptions found but the file system is offline).
       * @const
       * @type {string}
       */
      fatalFsOffline: 'fatalFsOffline',

      /**
       * Stable storage capacity is zero (no drives), could be discovered at the beginning or during a block read (special I/O error).
       * @const
       * @type {string}
       */
      noDrives: 'noDrives',

      /**
       * A lock (mutex resource) could not be obtained.
       * @const
       * @type {string}
       */
      lockError: 'lockError',

      /**
       * The primary and backup databases do not match.
       * @const
       * @type {string}
       */
      fatalMirrorMismatch: 'fatalMirrorMismatch',

      /**
       * The backup database is not supported on this platform, the backup database is not instantiated, the backup database is not yet synchronized with the primary database, or the backup database is locked (in database recovery mode).
       * @const
       * @type {string}
       */
      mirrorNotReady: 'mirrorNotReady'
   },

   /**
    * These types indicate the type of data of the diagnostic output for the Integrated Health Check
    * @enum {string}
    */
   DiagnosticDataType: {
      /**
       * Unknown data type
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Data type is ASCII
       * @const
       * @type {string}
       */
      ascii: 'ascii',

      /**
       * Data type is JSON
       * @const
       * @type {string}
       */
      json: 'json'
   },

   /**
    * This enumeration type identifies the available methods of computing the iSCSI header and data digests.
    * @enum {string}
    */
   DigestMethod: {
      /**
       * There is no digest method.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The digest method is CRC32C.
       * @const
       * @type {string}
       */
      crc32c: 'crc32c'
   },

   /**
    * This enumeration identifies the different operational states of a DIMM component.
    * @enum {string}
    */
   DimmStatus: {
      /**
       * The DIMM status is unknown; because of communication problems with the alternate controller.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The DIMM is working properly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The DIMM slot is intentionally not populated.
       * @const
       * @type {string}
       */
      empty: 'empty',

      /**
       * The DIMM has failed.
       * @const
       * @type {string}
       */
      failed: 'failed'
   },

   /**
    * Current Status of the given Directory Services Domain
    * @enum {string}
    */
   DirectoryServicesStatus: {
      /**
       * An error with the Directory Service Configuration has been resolved and the service is working normally
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The configuration for this domain has been changed
       * @const
       * @type {string}
       */
      configChange: 'configChange',

      /**
       * There is a problem communicating with the given domain
       * @const
       * @type {string}
       */
      error: 'error'
   },

   /**
    * This enumeration is used for Disk Pool related priority attributes.
    * @enum {string}
    */
   DiskPoolOperationPriority: {
      /**
       * The priority is not valid.
       * @const
       * @type {string}
       */
      invalid: 'invalid',

      /**
       * The lowest priority.
       * @const
       * @type {string}
       */
      lowest: 'lowest',

      /**
       * Low priority.
       * @const
       * @type {string}
       */
      low: 'low',

      /**
       * Medium priority.
       * @const
       * @type {string}
       */
      medium: 'medium',

      /**
       * High priority.
       * @const
       * @type {string}
       */
      high: 'high',

      /**
       * The highest priority.
       * @const
       * @type {string}
       */
      highest: 'highest',

      /**
       * The firmware will use the default priority.
       * @const
       * @type {string}
       */
      useDefault: 'useDefault'
   },

   /**
    * This enumeration is used to specify the type of priority.
    * @enum {string}
    */
   DiskPoolPriorityType: {
      /**
       * The disk pool priority type is not valid.
       * @const
       * @type {string}
       */
      invalid: 'invalid',

      /**
       * The disk pool priority type is degraded.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The disk pool priority type is critical.
       * @const
       * @type {string}
       */
      critical: 'critical',

      /**
       * The disk pool priority type is background.
       * @const
       * @type {string}
       */
      background: 'background'
   },

   /**
    * This enumeration is used to specify the type of the disk pool utilization threshold.
    * @enum {string}
    */
   DiskPoolThresholdType: {
      /**
       * The disk pool priority type is not valid.
       * @const
       * @type {string}
       */
      invalid: 'invalid',

      /**
       * The disk pool utilization threshold type is warning.
       * @const
       * @type {string}
       */
      warning: 'warning',

      /**
       * The disk pool utilization threshold type is critical.
       * @const
       * @type {string}
       */
      critical: 'critical'
   },

   /**
    * This enumeration is used to describe the Disk Pool state.
    * @enum {string}
    */
   DiskPoolUtilizationState: {
      /**
       * The Disk Pool's utilization state is not valid.
       * @const
       * @type {string}
       */
      utilizationInvalid: 'utilizationInvalid',

      /**
       * The Disk Pool's consumed capacity is below the value established by either pool utilization threshold. No alert condition exists.
       * @const
       * @type {string}
       */
      utilizationOptimal: 'utilizationOptimal',

      /**
       * The Disk Pool's consumed capacity has reached or exceeded the value established by the Warning threshold, but has not yet reached the value established by the Critical threshold. This state drives a Needs Attention condition for the storage array, unless overridden by OEM customers. The Warning state is superseded by the Critical state threshold.
       * @const
       * @type {string}
       */
      utilizationWarning: 'utilizationWarning',

      /**
       * The Disk Pool's consumed capacity has reached or exceeded the value established by the Critical threshold. This state drives a Needs Attention condition for the array, unless overridden by OEM customers.
       * @const
       * @type {string}
       */
      utilizationCritical: 'utilizationCritical',

      /**
       * The Disk Pool's capacity is depleted.
       * @const
       * @type {string}
       */
      capacityDepleted: 'capacityDepleted'
   },

   /**
    * How the DNS addresses were acquired.
    * @enum {string}
    */
   DnsAcquisitionMethod: {
      /**
       * DNS resolution is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Using provided IPv4 or IPv6 addresses
       * @const
       * @type {string}
       */
      stat: 'stat',

      /**
       * Dynamically provided by a DHCP Server
       * @const
       * @type {string}
       */
      dhcp: 'dhcp'
   },

   /**
    * Enumerates the types of support data that can be retrieved from Dom0
    * @enum {string}
    */
   Dom0SupportDataType: {
      /**
       * Represents no type has been chosen.
       * @const
       * @type {string}
       */
      unknownType: 'unknownType',

      /**
       * Specifies that we want to retrieve the Dom0 Journal.
       * @const
       * @type {string}
       */
      journalLogs: 'journalLogs',

      /**
       * Specifies that we want to retrieve the Dom0 misc logs.
       * @const
       * @type {string}
       */
      miscLogs: 'miscLogs',

      /**
       * Specifies that we want to retrieve the output of the commands for daily support.
       * @const
       * @type {string}
       */
      dailyDiagnostics: 'dailyDiagnostics',

      /**
       * Specifies that we want to retrieve the output of the commands for weekly support.
       * @const
       * @type {string}
       */
      weeklyDiagnostics: 'weeklyDiagnostics',

      /**
       * Specifies retrieval of core files created by daemons that are running in Dom0 if they are terminated.
       * @const
       * @type {string}
       */
      dataCoreFiles: 'dataCoreFiles',

      /**
       * Used to retrieve CBA weekly support data.
       * @const
       * @type {string}
       */
      containerAppWeekly: 'containerAppWeekly',

      /**
       * Used to retrieve complete CBA support data.
       * @const
       * @type {string}
       */
      containerAppComplete: 'containerAppComplete',

      /**
       * Used to retrieve BMC logs.
       * @const
       * @type {string}
       */
      bmcLogs: 'bmcLogs',

      /**
       * Used to retrieve system availability files.
       * @const
       * @type {string}
       */
      systemAvailabilityFiles: 'systemAvailabilityFiles'
   },

   /**
    * This enumeration identifies the different types of traces.
    * @enum {string}
    */
   DqTraceID: {
      /**
       * The current DQ trace should be retrieved.
       * @const
       * @type {string}
       */
      dqtraceCurrent: 'dqtraceCurrent',

      /**
       * All flushed traces should be retrieved.
       * @const
       * @type {string}
       */
      rawdataFlushed: 'rawdataFlushed',

      /**
       * Both current and flushed trace buffers should be retrieved.
       * @const
       * @type {string}
       */
      rawdataAll: 'rawdataAll',

      /**
       * retrieve all trace and platform buffers
       * @const
       * @type {string}
       */
      rawdataAllIncludePlatform: 'rawdataAllIncludePlatform'
   },

   /**
    * This enumeration object is used to specify the status of the drawer.
    * @enum {string}
    */
   DrawerStatus: {
      /**
       * The drawer status is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The drawer status is optimal.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The drawer has failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The drawer has been opened.
       * @const
       * @type {string}
       */
      opened: 'opened',

      /**
       * The drawer has been removed.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The drawer is degraded.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The drawer status is invalid. The drawer is not supported.
       * @const
       * @type {string}
       */
      invalid: 'invalid'
   },

   /**
    * This enumeration is used to specify one of a set of drive actions that may be active for a drive. These drive actions represent "long-running" operations on a drive. Any time such an operation is active, the current progress can be determined using the getLongLivedOpsProgress procedure.
    * @enum {string}
    */
   DriveAction: {
      /**
       * No long-running operations are currently in progress.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * A drive sanitization operation is currently in progress.
       * @const
       * @type {string}
       */
      sanitize: 'sanitize'
   },

   /**
    * This enumeration describes the drive block format for a group of drives.
    * @enum {string}
    */
   DriveBlockFormat: {
      /**
       * The drive block format is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Indicates that all of the drives are native drives; i.e, the logical block size is native and equal to the physical block size.
       * @const
       * @type {string}
       */
      allNative: 'allNative',

      /**
       * Indicates that all of the drives are emulation drives; i.e., the logical block size is emulated and different from the physical block size.
       * @const
       * @type {string}
       */
      allEmulated: 'allEmulated',

      /**
       * Indicates that the drives are a mix of emulation and native drives. For emulation drives, the logical block size is emulated and different from the physical block size. For native drives, the logical block size is native and equal to the physical block size.
       * @const
       * @type {string}
       */
      mixed: 'mixed'
   },

   /**
    * This enumeration object is used to specify the reason the drive channel was degraded.
    * @enum {string}
    */
   DriveChannelDegradeReason: {
      /**
       * No degrade reason is given.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The threshold was exceeded.
       * @const
       * @type {string}
       */
      thresholdExceeded: 'thresholdExceeded',

      /**
       * The admin requested to degrade the channel.
       * @const
       * @type {string}
       */
      adminRequest: 'adminRequest',

      /**
       * Hardware failure.
       * @const
       * @type {string}
       */
      socNotOperational: 'socNotOperational',

      /**
       * Hardware failure.
       * @const
       * @type {string}
       */
      socEepromFailure: 'socEepromFailure',

      /**
       * Clear hardware failure.
       * @const
       * @type {string}
       */
      clearHwFailure: 'clearHwFailure',

      /**
       * The drive channel was degraded due to an internal controller firmware decision.
       * @const
       * @type {string}
       */
      controllerAction: 'controllerAction'
   },

   /**
    * This enumeration object is used to specify the Drive Channel parent.
    * @enum {string}
    */
   DriveChannelParentType: {
      /**
       * The drive channel parent is unknown.
       * @const
       * @type {string}
       */
      parentUnknown: 'parentUnknown',

      /**
       * The drive channel parent is a minihub.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The drive channel parent is a controller.
       * @const
       * @type {string}
       */
      controller: 'controller'
   },

   /**
    * used to specify the type of Drive Channel port.
    * @enum {string}
    */
   DriveChannelPortType: {
      /**
       * Port is unknown and cannot be determined.
       * @const
       * @type {string}
       */
      portUnknown: 'portUnknown',

      /**
       * XBB Port 1 (SOC mode).
       * @const
       * @type {string}
       */
      port1: 'port1',

      /**
       * XBB Port 2 (SOC mode).
       * @const
       * @type {string}
       */
      port2: 'port2',

      /**
       * XBB Port 3 (SOC mode).
       * @const
       * @type {string}
       */
      port3: 'port3',

      /**
       * XBB Port 4 (SOC mode).
       * @const
       * @type {string}
       */
      port4: 'port4',

      /**
       * XBB Port 1 or 2 (Hub mode).
       * @const
       * @type {string}
       */
      port12: 'port12',

      /**
       * XBB Port 3 or 4 (Hub mode).
       * @const
       * @type {string}
       */
      port34: 'port34',

      /**
       * XBB Port 7
       * @const
       * @type {string}
       */
      port7: 'port7',

      /**
       * 588X Bridge controller in/out port.
       * @const
       * @type {string}
       */
      minihubInout: 'minihubInout',

      /**
       * Vail expansion port. This value of the enumeration is no longer used and is considered deprecated.
       * @const
       * @type {string}
       */
      expansionOnly: 'expansionOnly',

      /**
       * 288X expansion and internal.
       * @const
       * @type {string}
       */
      expansionAndInternal: 'expansionAndInternal'
   },

   /**
    * This enumeration object is used to specify the state of the drive channel.
    * @enum {string}
    */
   DriveChannelState: {
      /**
       * The drive channel state is optimal.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The drive channel state is degraded.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * An internal fault has occurred on shared drive channel circuitry. The failed circuit resides on the controller reporting the problem. This failure is automatically cleared when the faulty controller is replaced.
       * @const
       * @type {string}
       */
      hwFailed: 'hwFailed'
   },

   /**
    * This enumeration object specifies the drive download status.
    * @enum {string}
    */
   DriveDownloadStatus: {
      /**
       * The drive download status is ok.
       * @const
       * @type {string}
       */
      okay: 'okay',

      /**
       * Invalid drive reference.
       * @const
       * @type {string}
       */
      invalidDriveref: 'invalidDriveref',

      /**
       * Duplicate drive.
       * @const
       * @type {string}
       */
      duplicateDrive: 'duplicateDrive',

      /**
       * The drive download was not attempted.
       * @const
       * @type {string}
       */
      notAttempted: 'notAttempted',

      /**
       * Invalid state.
       * @const
       * @type {string}
       */
      invalidState: 'invalidState',

      /**
       * The drive download is in progress.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * A partial update was performed.
       * @const
       * @type {string}
       */
      partialUpdate: 'partialUpdate',

      /**
       * The drive download failed to update.
       * @const
       * @type {string}
       */
      failedUpdate: 'failedUpdate',

      /**
       * The drive has a reconstruction in progress.
       * @const
       * @type {string}
       */
      inProgressRecon: 'inProgressRecon',

      /**
       * Drive firmware download has been scheduled.
       * @const
       * @type {string}
       */
      pending: 'pending'
   },

   /**
    * Selects whether a drive is verified or unverified.
    * @enum {string}
    */
   DriveFwVerifiedStateType: {
      /**
       * Selects a drive as verified.
       * @const
       * @type {string}
       */
      verified: 'verified',

      /**
       * Selects a drive as unverified.
       * @const
       * @type {string}
       */
      unverified: 'unverified'
   },

   /**
    * This enumeration object specifies the drive media types that could be present in a storage array.
    * @enum {string}
    */
   DriveMediaType: {
      /**
       * There is no preference for a drive media type for volume candidates..
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * The drive media type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The drive is a Hard Disk Drive (HDD).
       * @const
       * @type {string}
       */
      hdd: 'hdd',

      /**
       * The drive is a Solid State Disk (SSD) drive.
       * @const
       * @type {string}
       */
      ssd: 'ssd'
   },

   /**
    * This enumeration is used to indicate the drive orientation (horizontal, vertical, or none) of the drives in the enclosure.
    * @enum {string}
    */
   DriveOrientation: {
      /**
       * The enclosure does not contain any drives.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The drives in the enclosure lay flat.
       * @const
       * @type {string}
       */
      horizontal: 'horizontal',

      /**
       * The drives in the enclosure stand on side (vertically).
       * @const
       * @type {string}
       */
      vertical: 'vertical'
   },

   /**
    * This enumeration is used to indicate the reason a drive has a PFA condition.
    * @enum {string}
    */
   DrivePfaReason: {
      /**
       * The drive has a PFA condition, but the reason for it is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The drive does not have a PFA condition.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The drive itself reported the PFA condition.
       * @const
       * @type {string}
       */
      driveReported: 'driveReported',

      /**
       * The RAID controller firmware has synthesized a PFA condition for the drive.
       * @const
       * @type {string}
       */
      synthesized: 'synthesized',

      /**
       * The SSD drive has reached the end of its life threshold.
       * @const
       * @type {string}
       */
      ssdEndOfLife: 'ssdEndOfLife',

      /**
       * Used when a data loss event has occurred on an SSD that is recoverable at the volume level.
       * @const
       * @type {string}
       */
      dataLoss: 'dataLoss'
   },

   /**
    * This field distinguishes between the different security capabilities of a drive. This field does not indicate whether security is enabled or not.
    * @enum {string}
    */
   DriveSecurityType: {
      /**
       * Non-secure drives will report as SECURE_NOT_CAPABLE.
       * @const
       * @type {string}
       */
      notCapable: 'notCapable',

      /**
       * Self-encrypting drives that are not FIPS certified will report SECURE_CAPABLE_NON_FIPS
       * @const
       * @type {string}
       */
      capableNonFips: 'capableNonFips',

      /**
       * Self-encrypting drives that are FIPS certified can be of type 140-2. They will report SECURE_CAPABLE_FIPS_140_2.
       * @const
       * @type {string}
       */
      capableFips1402: 'capableFips1402',

      /**
       * Self-encrypting drives that are FIPS certified can be of type 140-3. They will report SECURE_CAPABLE_FIPS_140_3.
       * @const
       * @type {string}
       */
      capableFips1403: 'capableFips1403',

      /**
       * Self-encrypting drives that are FIPS certified may not report their type. These drives will report SECURE_CAPABLE_FIPS_UNKNOWN.
       * @const
       * @type {string}
       */
      capableFipsUnknown: 'capableFipsUnknown'
   },

   /**
    * This enumeration identifies the possible drive status values that can be returned in a Drive object.
    * @enum {string}
    */
   DriveStatus: {
      /**
       * The drive status is currently optimal, or fully functional.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The drive is in the failed state.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The drive has been newly inserted into the storage array, and is currently being prepared for use.
       * @const
       * @type {string}
       */
      replaced: 'replaced',

      /**
       * The drive is being bypassed.
       * @const
       * @type {string}
       */
      bypassed: 'bypassed',

      /**
       * The drive is present but unresponsive.
       * @const
       * @type {string}
       */
      unresponsive: 'unresponsive',

      /**
       * The drive is physically not present.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The drive is considered to be incompatible for various reasons, as defined by DriveStatusCause.
       * @const
       * @type {string}
       */
      incompatible: 'incompatible',

      /**
       * The drive is undergoing a data relocation operation.
       * @const
       * @type {string}
       */
      dataRelocation: 'dataRelocation',

      /**
       * The drive data is being evacuated before drive failure.
       * @const
       * @type {string}
       */
      preFailCopy: 'preFailCopy',

      /**
       * This is the state of drive that has been identified to become a source drive in a Copy Then Fail evacuation operation.
       * @const
       * @type {string}
       */
      preFailCopyPending: 'preFailCopyPending',

      /**
       * The drive is being sanitized.
       * @const
       * @type {string}
       */
      sanitizing: 'sanitizing'
   },

   /**
    * This enumeration is used to identify the reason for the current status of the drive.
    * @enum {string}
    */
   DriveStatusCause: {
      /**
       * There is no relevant cause value to report. This value will be reported, for example, if the drive's status is optimal.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The drive is in its current state because of a user-initiated action.
       * @const
       * @type {string}
       */
      userOp: 'userOp',

      /**
       * The drive is in its current state because a write operation failed.
       * @const
       * @type {string}
       */
      writeOp: 'writeOp',

      /**
       * The drive is in its current state because it is not a properly certified drive for use in the storage array.
       * @const
       * @type {string}
       */
      uncertified: 'uncertified',

      /**
       * The drive is in its current state because it was bypassed due to a mismatch between the drive's speed and the ESM's speed.
       * @const
       * @type {string}
       */
      speedMismatch: 'speedMismatch',

      /**
       * The drive is in its current state because it was bypassed and the cause is unknown.
       * @const
       * @type {string}
       */
      bypassUnknown: 'bypassUnknown',

      /**
       * A failed drive has been replaced by the wrong type of drive.
       * @const
       * @type {string}
       */
      wrongDriveType: 'wrongDriveType',

      /**
       * The DACStore on the drive is unrecognizable because it was written by up-rev firmware.
       * @const
       * @type {string}
       */
      incompatibleUprevDacstore: 'incompatibleUprevDacstore',

      /**
       * The DACStore on the drive is unrecognizable because it was written by down-rev firmware.
       * @const
       * @type {string}
       */
      incompatibleDownrevDacstore: 'incompatibleDownrevDacstore',

      /**
       * The drive is considered incompatible because the firmware encountered an internal error while trying to use it.
       * @const
       * @type {string}
       */
      incompatibleInternalError: 'incompatibleInternalError',

      /**
       * The drive is considered incompatible because its formatted sector size differs from the other drives in the array.
       * @const
       * @type {string}
       */
      incompatibleSectorSizeMismatch: 'incompatibleSectorSizeMismatch',

      /**
       * Either (1) A foreign, unassigned drive is present, but a partial volume group in the storage array refers to the drive as assigned to that volume group, or (2) a partial volume group in the storage array refers to the foreign drive as missing from that volume group and the foreign drive is referring to itself as assigned to a different volume group.
       * @const
       * @type {string}
       */
      incompatibleNativeVgRefersToForeignDrive: 'incompatibleNativeVgRefersToForeignDrive',

      /**
       * Incompatible native drive
       * @const
       * @type {string}
       */
      incompatibleForeignVgRefersToNativeDrive: 'incompatibleForeignVgRefersToNativeDrive',

      /**
       * A partial volume group in the storage array refers to a foreign drive as missing from that volume group and the foreign drive is referring to itself as assigned to that volume group. The problem is that the drive is foreign so it cannot be treated as missing from the volume group (in which case it would be native).
       * @const
       * @type {string}
       */
      incompatibleNativeVgForeignDriveMutualRef: 'incompatibleNativeVgForeignDriveMutualRef',

      /**
       * The drives of a missing volume group in the storage array are inserted but their configuration is now changed, i.e., the volume group was (1) removed without exporting it first, (2) imported into another array, (3) subjected to a configuration change, and (4) moved back to the original array. Each drive will have this drive status cause.
       * @const
       * @type {string}
       */
      incompatibleVgCloned: 'incompatibleVgCloned',

      /**
       * A foreign drive refers to itself as assigned to a complete volume group in the storage array (but obviously the complete volume group is not referring to the foreign drive).
       * @const
       * @type {string}
       */
      incompatibleForeignDriveInconsistent: 'incompatibleForeignDriveInconsistent',

      /**
       * A partial volume group in the storage array is referring to a drive in another, exported, volume group as missing, i.e., both the volume group in the storage array and the volume group in the exported state are referring to the same drive as being assigned to them. All the drives of the exported volume group have this drive status cause including the drive causing the conflict.
       * @const
       * @type {string}
       */
      incompatibleVgHasDrivePartOfMultipleVgs: 'incompatibleVgHasDrivePartOfMultipleVgs',

      /**
       * An unassigned foreign drive reports its state as unassigned, but a contingent volume group in the storage array refers to the drive as a member of that volume group
       * @const
       * @type {string}
       */
      incompatibleForeignDriveHasInconsistentRole: 'incompatibleForeignDriveHasInconsistentRole',

      /**
       * A drive is assigned to two different volume groups, one that is contingent and another which was just inserted. The drives of the second volume group are also in an incompatible state, but with the cause of DRIVE_CAUSE_INCOMPATIBLE_VG_HAS_DRIVE_PART_OF_MULTIPLE_VGS. The second volume group is not created.
       * @const
       * @type {string}
       */
      incompatibleVgDrivePartOfMultipleVgs: 'incompatibleVgDrivePartOfMultipleVgs',

      /**
       * A drive is part of a legacy volume group that contains a failed drive and/or an in-use hot-spare.
       * @const
       * @type {string}
       */
      incompatibleFailedLegacyDrive: 'incompatibleFailedLegacyDrive',

      /**
       * The SNIA Disk Data Format (DDF) anchor header on the drive has a T10 vendor other than LSI-Engenio.
       * @const
       * @type {string}
       */
      incompatibleDdfOtherVendor: 'incompatibleDdfOtherVendor',

      /**
       * The drive was found to be incompatible during a database adoption process, causing the adoption to fail..
       * @const
       * @type {string}
       */
      incompatibleDbAdoptionFailure: 'incompatibleDbAdoptionFailure',

      /**
       * The Full-Disk-Encryption drive could not be security unlocked.
       * @const
       * @type {string}
       */
      locked: 'locked',

      /**
       * The inserted drive does not have sufficient capacity for the user data of the failed drive.
       * @const
       * @type {string}
       */
      insufficientDriveCapacity: 'insufficientDriveCapacity',

      /**
       * The drive failed because of a super-capacitor failure.
       * @const
       * @type {string}
       */
      supercapacitorFailure: 'supercapacitorFailure',

      /**
       * The drive has an unsupported protocol connection.
       * @const
       * @type {string}
       */
      unsupportedProtocolConnection: 'unsupportedProtocolConnection',

      /**
       * The drive capacity is not supported.
       * @const
       * @type {string}
       */
      unsupportedCapacity: 'unsupportedCapacity',

      /**
       * An invalid lock key was presented to unlock the FDE drive.
       * @const
       * @type {string}
       */
      invalidLockKeyPresented: 'invalidLockKeyPresented',

      /**
       * The drive has in incompatible Protection Information type .
       * @const
       * @type {string}
       */
      incompatiblePiType: 'incompatiblePiType',

      /**
       * Drives are locked out due to a failed database validation during SOD, after a change in the HIC configuration has been detected.
       * @const
       * @type {string}
       */
      incompatibleDatabaseValidationFailure: 'incompatibleDatabaseValidationFailure',

      /**
       * A drive interposer has an unsupported firmware version.
       * @const
       * @type {string}
       */
      incompatibleUnsupportedInterposerFwVersion: 'incompatibleUnsupportedInterposerFwVersion',

      /**
       * The SATA drive is not supported because it does not support SMART Command Transfer (SCT) commands.
       * @const
       * @type {string}
       */
      incompatibleSataDriveSctUnsupported: 'incompatibleSataDriveSctUnsupported',

      /**
       * The drive is not supported based on the model number.
       * @const
       * @type {string}
       */
      incompatibleModelNumberUnsupported: 'incompatibleModelNumberUnsupported',

      /**
       * The lowest aligned LBA for the physical sector of an emulation was found to be non-zero and is therefore not supported.
       * @const
       * @type {string}
       */
      incompatibleAlignmentForEmulationDrive: 'incompatibleAlignmentForEmulationDrive',

      /**
       * The drive is a source of a data relocation operation.
       * @const
       * @type {string}
       */
      srcRelocation: 'srcRelocation',

      /**
       * The drive is a destination of a data relocation operation.
       * @const
       * @type {string}
       */
      dstRelocation: 'dstRelocation',

      /**
       * The drive is incompatible because the configuration metadata on the drive is either corrupt or otherwise unusable by the controller. The drive will need to be initialized before it can be integrated into the array.
       * @const
       * @type {string}
       */
      incompatibleDriveMetadataUnusable: 'incompatibleDriveMetadataUnusable',

      /**
       * The drive failed due to PFA condition.
       * @const
       * @type {string}
       */
      pfa: 'pfa',

      /**
       * The drive failed due to SPFA condition.
       * @const
       * @type {string}
       */
      spfa: 'spfa',

      /**
       * Drive LBA format is incompatible pending fast format.
       * @const
       * @type {string}
       */
      incompatibleFastFormatNeeded: 'incompatibleFastFormatNeeded',

      /**
       * Drive LBA format is incompatible due to fast format failure.
       * @const
       * @type {string}
       */
      incompatibleFastFormatFailed: 'incompatibleFastFormatFailed',

      /**
       * Unable to enable drive security, establish user assignments, or lock the LBA ranges required to set up the drive for security capabilities.
       * @const
       * @type {string}
       */
      incompatibleUserAssignmentFailed: 'incompatibleUserAssignmentFailed',

      /**
       * The drive is in its current state because a sanitize operation failed.
       * @const
       * @type {string}
       */
      sanitizeFailed: 'sanitizeFailed',

      /**
       * The drive has been sanitized and cannot be used until it has been initialized.
       * @const
       * @type {string}
       */
      incompatibleSanitized: 'incompatibleSanitized',

      /**
       * The drive is being sanitized.
       * @const
       * @type {string}
       */
      incompatibleSanitizing: 'incompatibleSanitizing',

      /**
       * A drive added to the system has an unverified firmware version.
       * @const
       * @type {string}
       */
      pendingFwVerification: 'pendingFwVerification'
   },

   /**
    * This enumeration type is used to distinguish between the different I/O protocols used by the controller to communicate with drives. This is not necessarily the same as the physical drive interface type (PhysicalDriveType).
    * @enum {string}
    */
   DriveType: {
      /**
       * The drive uses a SCSI I/O interface.
       * @const
       * @type {string}
       */
      scsi: 'scsi',

      /**
       * The drive uses a Fibre Channel I/O interface.
       * @const
       * @type {string}
       */
      fibre: 'fibre',

      /**
       * The drive interface is unknown or unavailable.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The drive uses a serial-attached SCSI I/O interface.
       * @const
       * @type {string}
       */
      sas: 'sas',

      /**
       * The drive uses a SATA I/O interface.
       * @const
       * @type {string}
       */
      sata: 'sata',

      /**
       * The drive is an NVMe drive using a Direct PCI Express interface
       * @const
       * @type {string}
       */
      nvmeDirectPcie: 'nvmeDirectPcie'
   },

   /**
    * Indicates the cause of the user assignment failure, which includes any reason we could not set up the drive for security capabilities, such as inability to enable security, assign users, or assign locking LBA ranges to users.
    * @enum {string}
    */
   DriveUserAssignmentFailureCause: {
      /**
       * No user assignment cause is available.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Unable to enable drive security as part of setting the drive up for encryption capability.
       * @const
       * @type {string}
       */
      enablingSecurity: 'enablingSecurity',

      /**
       * Unable to assign security users (see TCG) to the drive.
       * @const
       * @type {string}
       */
      assignment: 'assignment',

      /**
       * Unable to assign locking LBA ranges to security users.
       * @const
       * @type {string}
       */
      lockingRange: 'lockingRange',

      /**
       * The cause of the security user assignment is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * This enumeration object is used to determine the status of an ESM component.
    * @enum {string}
    */
   ESMStatus: {
      /**
       * The ESM is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The ESM is not working or not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The ESM has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the ESM is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The ESM is not supported.
       * @const
       * @type {string}
       */
      unsupported: 'unsupported',

      /**
       * The ESM is not certified.
       * @const
       * @type {string}
       */
      uncertified: 'uncertified'
   },

   /**
    * List of the supported ESM and IOM types.
    * @enum {string}
    */
   ESMType: {
      /**
       * Unknown or unidentified ESM type.
       * @const
       * @type {string}
       */
      unidentified: 'unidentified',

      /**
       * Badger ESM used in Camden, Ebbets, and SAS Wembley enclosures.
       * @const
       * @type {string}
       */
      badger: 'badger',

      /**
       * Mercury Devil ESM used in Red Devila nd Blue Devil enclosures.
       * @const
       * @type {string}
       */
      devil: 'devil',

      /**
       * Cyclone ESM used in Trafford enclosure
       * @const
       * @type {string}
       */
      cyclone: 'cyclone',

      /**
       * Polecat IOM used in Joshua and Alder enclosures (superseded by Otter). Also known as IOM12.
       * @const
       * @type {string}
       */
      polecat: 'polecat',

      /**
       * Otter IOM used in Joshua, Alder, and redesigned Trafford enclosures. Also known as IOM12A.
       * @const
       * @type {string}
       */
      otter: 'otter',

      /**
       * Ermine IOM used in Joshua, Alder, and redesigned Trafford enclosures. Also known as IOM12B. The product identification field in the Inquiry data will change to identify Ermine vs Otter by having the suffix IOM12.
       * @const
       * @type {string}
       */
      ermine: 'ermine',

      /**
       * ESM Type for the Dagger2 local IOM
       * @const
       * @type {string}
       */
      localDagger2: 'localDagger2',

      /**
       * Mink ESM/IOM type
       * @const
       * @type {string}
       */
      mink: 'mink'
   },

   /**
    * This enumeration object is used to identify the type of encryption used for a particular operation or object.
    * @enum {string}
    */
   EncryptionType: {
      /**
       * Indicates that the encryption conforms to the PKCS #5 standard defined by RSA Laboratories for passphrase-based encryption. The SHA-1 message digest algorithm is used to generate the encryption key and initialization vector. The encryption algorithm is DES with 56-bit keys and Cipher Block Chaining (CBC).
       * @const
       * @type {string}
       */
      pkcs5Sha1Des: 'pkcs5Sha1Des',

      /**
       * Indicates, in certain contexts, that the encryption type is not specified.
       * @const
       * @type {string}
       */
      unspecified: 'unspecified',

      /**
       * Use AES encryption.
       * @const
       * @type {string}
       */
      pkcs5Sha2Aes: 'pkcs5Sha2Aes'
   },

   /**
    * An enumeration that includes the possible Chassis ID TLV sub-types as specified in IEEE specification 802.1ab.
    * @enum {string}
    */
   EnhEthChassisIDSubtype: {
      /**
       * The Chassis ID TLV sub-type is unknown.
       * @const
       * @type {string}
       */
      unk: 'unk',

      /**
       * (IETF RFC 2737).
       * @const
       * @type {string}
       */
      component: 'component',

      /**
       * The Chassis ID TLV sub-type is the Interface Alias - If Alias (IETF RFC 2863).
       * @const
       * @type {string}
       */
      intfAlias: 'intfAlias',

      /**
       * The Chassis ID TLV sub-type is the Port Component - EntPhysicalAlias when entPhysicalClass has a value 'port(10)' or 'backplane(4)' (IETF RFC 2737).
       * @const
       * @type {string}
       */
      portComp: 'portComp',

      /**
       * The Chassis ID TLV sub-type is the MAC Address - IEEE Std 802-2001.
       * @const
       * @type {string}
       */
      macAddr: 'macAddr',

      /**
       * The Chassis ID TLV sub-type is the Network Address - an octet string that identifies a particular network address family and an associated network address that are encoded in network octet order. An IP address, for example, would be encoded with the first octet containing the IANA Address Family Numbers enumeration value for the specific address type and octets 2 through n containing the address value (for example, the encoding for C0-A8-FE-0A would indicate the IP version 4 address 192.168.254.10)..
       * @const
       * @type {string}
       */
      ntwkAddr: 'ntwkAddr',

      /**
       * The Chassis ID TLV sub-type is the Interface Name - if Name (IETF RFC 2863).
       * @const
       * @type {string}
       */
      intfName: 'intfName',

      /**
       * The Chassis ID TLV sub-type is Locally Assigned - an alpha-numeric string and is locally assigned.
       * @const
       * @type {string}
       */
      local: 'local'
   },

   /**
    * An enumeration that includes the known Ethernet Flow control states for a given iSCSI Port.
    * @enum {string}
    */
   EnhEthFlowControlStatus: {
      /**
       * The port's flow control is in an indeterminate state.
       * @const
       * @type {string}
       */
      unk: 'unk',

      /**
       * The port's Ethernet link is down (disconnected ethernet cable) .
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The flow control status is standard for the Enhanced Ethernet.
       * @const
       * @type {string}
       */
      standard: 'standard',

      /**
       * The DCBX exchange error indicates the Ethernet switch connected to the given port is not configured correctly for priority-based Flow Control.
       * @const
       * @type {string}
       */
      perPriority: 'perPriority'
   },

   /**
    * An enumeration that includes the possible Port ID TLV sub-types as specified in IEEE specification 802.1ab.
    * @enum {string}
    */
   EnhEthPortIDSubtype: {
      /**
       * The Port ID TLV subtype is unknown.
       * @const
       * @type {string}
       */
      unk: 'unk',

      /**
       * The Port ID TLV subtype is the Interface Alias - If Alias (IETF RFC 2863).
       * @const
       * @type {string}
       */
      intfAlias: 'intfAlias',

      /**
       * The Port ID TLV subtype is the Port Component - EntPhysicalAlias when entPhysicalClass has a value 'port(10)' or 'backplane(4)' (IETF RFC 2737).
       * @const
       * @type {string}
       */
      portComp: 'portComp',

      /**
       * The Port ID TLV subtype is the MAC Address - IEEE Std 802-2001.
       * @const
       * @type {string}
       */
      macAddr: 'macAddr',

      /**
       * The Port ID TLV subtype is the Network Address - an octet string that identifies a particular network address family and an associated network address that are encoded in network octet order. An IP address, for example, would be encoded with the first octet containing the IANA Address Family Numbers enumeration value for the specific address type and octets 2 through n containing the address value (for example, the encoding for C0-A8-FE-0A would indicate the IP version 4 address 192.168.254.10).
       * @const
       * @type {string}
       */
      ntwkAddr: 'ntwkAddr',

      /**
       * The Port ID TLV subtype is the Interface Name - if Name (IETF RFC 2863).
       * @const
       * @type {string}
       */
      intfName: 'intfName',

      /**
       * The Port ID TLV subtype is the Agent circuit ID - (IETF RFC 3046)
       * @const
       * @type {string}
       */
      agentCircuit: 'agentCircuit',

      /**
       * The Port ID TLV subtype is Locally Assigned - an alpha-numeric string and is locally assigned.
       * @const
       * @type {string}
       */
      local: 'local'
   },

   /**
    * An enumeration that includes the known Ethernet Protocol types currently negotiated via DCBX.
    * @enum {string}
    */
   EnhEthProtocolType: {
      /**
       * The Ethernet Protocol type is unknown.
       * @const
       * @type {string}
       */
      unk: 'unk',

      /**
       * The Ethernet Protocol type is the Fibre Channel Over Ethernet.
       * @const
       * @type {string}
       */
      fcoe: 'fcoe',

      /**
       * The Ethernet Protocol type is the Fibre Channel Over Ethernet Initiation Protocol.
       * @const
       * @type {string}
       */
      fip: 'fip',

      /**
       * The Ethernet Protocol type is the ISCSI.
       * @const
       * @type {string}
       */
      iscsi: 'iscsi'
   },

   /**
    * An enumeration that includes Time Length Value (TLV)Types for Enhanced Ethernet. Refer to the IEEE Std 802.1AB-2005
    * @enum {string}
    */
   EnhEthTLVType: {
      /**
       * The TLV type is unknown for the Enhanced Ethernet. This TLV type should not be used.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The TLV type is Chassis ID for Enhanced Ethernet (mandatory).
       * @const
       * @type {string}
       */
      chassisid: 'chassisid',

      /**
       * The TLV type is Port ID for Enhanced Ethernet (mandatory).
       * @const
       * @type {string}
       */
      portid: 'portid',

      /**
       * The TLV type is Time To Live for Enhanced Ethernet (mandatory).
       * @const
       * @type {string}
       */
      timetolive: 'timetolive'
   },

   /**
    * This enumeration data type lists the possible Ethernet Forward Error Correction (FEC) Modes
    * @enum {string}
    */
   EthernetFECMode: {
      /**
       * The FEC Mode cannot be determined
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * No FEC Mode
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Fire Code FEC Mode
       * @const
       * @type {string}
       */
      fireCode: 'fireCode',

      /**
       * Reed Solomon FEC Mode
       * @const
       * @type {string}
       */
      reedSolomon: 'reedSolomon',

      /**
       * FEC Mode is auto negotiated
       * @const
       * @type {string}
       */
      auto: 'auto'
   },

   /**
    * Identifies the possible speed settings that can be configured for an Ethernet management port.
    * @enum {string}
    */
   EthernetSpeedSetting: {
      /**
       * There is no speed setting for the port.
       * @const
       * @type {string}
       */
      speedNone: 'speedNone',

      /**
       * port should auto-negotiate the speed and duplex mode
       * @const
       * @type {string}
       */
      speedAutoNegotiated: 'speedAutoNegotiated',

      /**
       * Setting is 10 Mbps, half-duplex.
       * @const
       * @type {string}
       */
      speed10MbitHalfDuplex: 'speed10MbitHalfDuplex',

      /**
       * Setting is 10 Mbps, full-duplex.
       * @const
       * @type {string}
       */
      speed10MbitFullDuplex: 'speed10MbitFullDuplex',

      /**
       * Setting is 100 Mbps, half-duplex.
       * @const
       * @type {string}
       */
      speed100MbitHalfDuplex: 'speed100MbitHalfDuplex',

      /**
       * Setting is 100 Mbps, full duplex.
       * @const
       * @type {string}
       */
      speed100MbitFullDuplex: 'speed100MbitFullDuplex',

      /**
       * Setting is 1000 Mbps half-duplex
       * @const
       * @type {string}
       */
      speed1000MbitHalfDuplex: 'speed1000MbitHalfDuplex',

      /**
       * Setting is 1000 Mbps full duplex
       * @const
       * @type {string}
       */
      speed1000MbitFullDuplex: 'speed1000MbitFullDuplex'
   },

   /**
    * This enumeration object is used to specify the different categories of events that are tracked in the MEL.
    * @enum {string}
    */
   EventCategory: {
      /**
       * The MEL entry is associated with an error, either in internal logic or in a request from a client system.
       * @const
       * @type {string}
       */
      error: 'error',

      /**
       * The MEL entry is associated with a physical component failure.
       * @const
       * @type {string}
       */
      failure: 'failure',

      /**
       * The MEL entry is associated with a command that was received from a host system, typically one issued to cause a configuration change.
       * @const
       * @type {string}
       */
      command: 'command',

      /**
       * The MEL entry is associated with a standard mechanism for notifying external agents of a configuration change.
       * @const
       * @type {string}
       */
      notification: 'notification',

      /**
       * The MEL entry is associated with a change in the state of an internal component or element.
       * @const
       * @type {string}
       */
      stateChange: 'stateChange',

      /**
       * The MEL entry was generated by a host system and stored by the controller.
       * @const
       * @type {string}
       */
      hostEntry: 'hostEntry',

      /**
       * The MEL entry does not fall into any of the previous categories.
       * @const
       * @type {string}
       */
      general: 'general'
   },

   /**
    * This enumeration object is used to specify the different component types that can be associated with entries in the Major Event Log.
    * @enum {string}
    */
   EventComponentType: {
      /**
       * The component type is not known.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The component is a physical drive.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * The component is a power supply.
       * @const
       * @type {string}
       */
      powerSply: 'powerSply',

      /**
       * The component is a cooling fan.
       * @const
       * @type {string}
       */
      fan: 'fan',

      /**
       * The component is a Minihub.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The component is a temperature sensor.
       * @const
       * @type {string}
       */
      tempSensor: 'tempSensor',

      /**
       * The component is a channel.
       * @const
       * @type {string}
       */
      channel: 'channel',

      /**
       * The component is an ESM (Environment Services Module) card.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The component is a physical controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The component is a cache-holdup battery.
       * @const
       * @type {string}
       */
      battery: 'battery',

      /**
       * The component is an enclosure (or tray).
       * @const
       * @type {string}
       */
      enclosure: 'enclosure',

      /**
       * The component is a UPS (Uninterruptible Power Supply).
       * @const
       * @type {string}
       */
      ups: 'ups',

      /**
       * The component is a chip on a controller board.
       * @const
       * @type {string}
       */
      chip: 'chip',

      /**
       * The component is volume.
       * @const
       * @type {string}
       */
      volume: 'volume',

      /**
       * The component is a volume group.
       * @const
       * @type {string}
       */
      volumeGrp: 'volumeGrp',

      /**
       * The component is a Fibre Channel port CRU. This value is deprecated.
       * @const
       * @type {string}
       */
      portCru: 'portCru',

      /**
       * The component is an interconnect CRU.
       * @const
       * @type {string}
       */
      interconnectCru: 'interconnectCru',

      /**
       * The component is a support CRU.
       * @const
       * @type {string}
       */
      supportCru: 'supportCru',

      /**
       * The component is an alarm.
       * @const
       * @type {string}
       */
      alarm: 'alarm',

      /**
       * The component is a channel port.
       * @const
       * @type {string}
       */
      channelPort: 'channelPort',

      /**
       * The component is an SFP port.
       * @const
       * @type {string}
       */
      sfpPort: 'sfpPort',

      /**
       * The component is a host board (XBB architecture only).
       * @const
       * @type {string}
       */
      hostBoard: 'hostBoard',

      /**
       * The component is a new "type."
       * @const
       * @type {string}
       */
      newFormat: 'newFormat',

      /**
       * The component is a controller SFP (XBB architecture only).
       * @const
       * @type {string}
       */
      ctlrSfp: 'ctlrSfp',

      /**
       * The component is a SOC Fibre Channel Switch chip on the controller (XBB architecture only).
       * @const
       * @type {string}
       */
      ctlrSoc: 'ctlrSoc',

      /**
       * The component is an iSCSI initiator.
       * @const
       * @type {string}
       */
      initiator: 'initiator',

      /**
       * The component is an iSCSI target.
       * @const
       * @type {string}
       */
      target: 'target',

      /**
       * The component is a controller host I/O card. A "host I/O card" is the same thing as a "host board," the difference being that this particular event component type provides explicit location information for the card to which the event applies.
       * @const
       * @type {string}
       */
      isnsServer: 'isnsServer',

      /**
       * The component is a controller host I/O card. A "host I/O card" is the same thing as a "host board," the difference being that this particular event component type provides explicit location information for the card to which the event applies.
       * @const
       * @type {string}
       */
      hostIoCard: 'hostIoCard',

      /**
       * The component is a cache backup device.
       * @const
       * @type {string}
       */
      cacheBackupDevice: 'cacheBackupDevice',

      /**
       * The component is a cache memory DIMM.
       * @const
       * @type {string}
       */
      cacheMemDimm: 'cacheMemDimm',

      /**
       * The component is a host defined in the storage partitions topology database.
       * @const
       * @type {string}
       */
      host: 'host',

      /**
       * The component is a host port.
       * @const
       * @type {string}
       */
      hostPort: 'hostPort',

      /**
       * The component is a drawer.
       * @const
       * @type {string}
       */
      drawer: 'drawer',

      /**
       * The component is either a drive or a temperature sensor in a drawer within a Wembley enclosure.
       * @const
       * @type {string}
       */
      relative: 'relative',

      /**
       * The component is a schedule.
       * @const
       * @type {string}
       */
      schedule: 'schedule',

      /**
       * The component is an Async Mirror Group.
       * @const
       * @type {string}
       */
      asyncMirrorGroup: 'asyncMirrorGroup',

      /**
       * The component is a disk pool.
       * @const
       * @type {string}
       */
      diskPool: 'diskPool',

      /**
       * The component is a PiT.
       * @const
       * @type {string}
       */
      pit: 'pit',

      /**
       * The component is a PiT Consistency Group.
       * @const
       * @type {string}
       */
      pitConsistencyGroup: 'pitConsistencyGroup',

      /**
       * The component is a Consistency Group PIT.
       * @const
       * @type {string}
       */
      cgpit: 'cgpit',

      /**
       * The component is a Consistency Group View.
       * @const
       * @type {string}
       */
      cgview: 'cgview',

      /**
       * The component is a flash cache.
       * @const
       * @type {string}
       */
      flashCache: 'flashCache',

      /**
       * The component is an SNMP community.
       * @const
       * @type {string}
       */
      snmpCommunity: 'snmpCommunity',

      /**
       * The component is an SNMP trap destination.
       * @const
       * @type {string}
       */
      snmpTrapDestination: 'snmpTrapDestination',

      /**
       * The component is a Fibre Channel target.
       * @const
       * @type {string}
       */
      fcTarget: 'fcTarget',

      /**
       * Blank event component type to maintain backward compatibility within the enumeration.
       * @const
       * @type {string}
       */
      blankOne: 'blankOne',

      /**
       * Blank event component type to maintain backward compatibility within the enumeration.
       * @const
       * @type {string}
       */
      blankTwo: 'blankTwo',

      /**
       * Event component type for a fan only CRU.
       * @const
       * @type {string}
       */
      fanOnlyCru: 'fanOnlyCru',

      /**
       * MEL component type for power supply CRU.
       * @const
       * @type {string}
       */
      psuCru: 'psuCru',

      /**
       * MEL component type for NVMe initiator.
       * @const
       * @type {string}
       */
      nvmeInitiator: 'nvmeInitiator',

      /**
       * The component is a remote target group.
       * @const
       * @type {string}
       */
      remoteTargetGrp: 'remoteTargetGrp',

      /**
       * Event component type for an SNMP USM user.
       * @const
       * @type {string}
       */
      snmpUsmUser: 'snmpUsmUser'
   },

   /**
    * This enumeration is used to specify whether default actions will be taken for events or whether the defaults will be overridden.
    * @enum {string}
    */
   EventControlOverride: {
      /**
       * The default action for the event will be used.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The default action for the event will be used.
       * @const
       * @type {string}
       */
      acceptDefault: 'acceptDefault',

      /**
       * The default action for the event will be overridden with a value of True.
       * @const
       * @type {string}
       */
      overrideToTrue: 'overrideToTrue',

      /**
       * The default action for the event will be overridden with a value of False.
       * @const
       * @type {string}
       */
      overrideToFalse: 'overrideToFalse'
   },

   /**
    * This enumeration object is used to specify the different priority values that can be associated with entries in the Major Event Log. In addition, the supportedEventPriorities array in the FeatureParams structure will contain values from this enumeration identifying which MEL event priorities are supported on the storage array.
    * @enum {string}
    */
   EventPriority: {
      /**
       * The event priority is default.
       * @const
       * @type {string}
       */
      priorityDefault: 'priorityDefault',

      /**
       * The priority is critical.
       * @const
       * @type {string}
       */
      priorityCritical: 'priorityCritical',

      /**
       * The priority is informational.
       * @const
       * @type {string}
       */
      priorityInfo: 'priorityInfo',

      /**
       * The event priority is emergency; the array is unusable. This value is unsupported by management software at present, and disallowed by the event data schema.
       * @const
       * @type {string}
       */
      priorityEmergency: 'priorityEmergency',

      /**
       * The event priority is alert; action must be taken immediately. This value is unsupported by management software at present, and disallowed by the event data schema.
       * @const
       * @type {string}
       */
      priorityAlert: 'priorityAlert',

      /**
       * The event priority is error. This value is unsupported by management software at present, and disallowed by the event data schema.
       * @const
       * @type {string}
       */
      priorityError: 'priorityError',

      /**
       * The event priority is warning.
       * @const
       * @type {string}
       */
      priorityWarning: 'priorityWarning',

      /**
       * The event priority is notice; normal but significant. This value is unsupported by management software at present, and disallowed by the event data schema.
       * @const
       * @type {string}
       */
      priorityNotice: 'priorityNotice',

      /**
       * The event priority is debug.
       * @const
       * @type {string}
       */
      priorityDebug: 'priorityDebug'
   },

   /**
    * This enumeration specifies the types of dependencies that may be identified for a volume belonging to a group that is a candidate to be exported.
    * @enum {string}
    */
   ExportDependencyType: {
      /**
       * The dependent volume and the referenced volume participate in the same snapshot.
       * @const
       * @type {string}
       */
      snapshot: 'snapshot',

      /**
       * The dependent volume and the referenced volume comprise a volume copy pair.
       * @const
       * @type {string}
       */
      volumeCopy: 'volumeCopy',

      /**
       * The dependent volume provides metadata for the referenced higher-level volume.
       * @const
       * @type {string}
       */
      metadata: 'metadata',

      /**
       * The dependent volume is one of the volumes in a remote mirror pair.
       * @const
       * @type {string}
       */
      mirrorPair: 'mirrorPair',

      /**
       * The dependent volume has a mapping to a host system
       * @const
       * @type {string}
       */
      hostMapping: 'hostMapping',

      /**
       * The dependent volume has a persistent reservation.
       * @const
       * @type {string}
       */
      persistentReservation: 'persistentReservation',

      /**
       * The dependent volume depends on RAID 6 hardware support.
       * @const
       * @type {string}
       */
      raid6Support: 'raid6Support',

      /**
       * The dependent volume is one of the members in an Async Mirror Group (could be either primary or secondary).
       * @const
       * @type {string}
       */
      asyncMirrorGroupMember: 'asyncMirrorGroupMember',

      /**
       * The dependent volume is an ERV/ConcatVolume member.
       * @const
       * @type {string}
       */
      concatMember: 'concatMember',

      /**
       * The dependent volume is a PiT Group base.
       * @const
       * @type {string}
       */
      pitGroup: 'pitGroup',

      /**
       * The dependent volume is a PiT View base.
       * @const
       * @type {string}
       */
      pitView: 'pitView'
   },

   /**
    * This enumeration object contains a list of all possible extended component location types that can be returned in a MEL entry.
    * @enum {string}
    */
   ExtendedComponentLocationType: {
      /**
       * The extended component location type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The extended component location type is a tray.
       * @const
       * @type {string}
       */
      tray: 'tray',

      /**
       * The extended component location type is a tray slot.
       * @const
       * @type {string}
       */
      trayslot: 'trayslot',

      /**
       * The extended component location type is a minihub. This value is deprecated.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The extended component location type is a channel. This value is deprecated.
       * @const
       * @type {string}
       */
      channel: 'channel',

      /**
       * The extended component location type is a volume. This value is deprecated.
       * @const
       * @type {string}
       */
      volume: 'volume',

      /**
       * The extended component location type is a PiT.
       * @const
       * @type {string}
       */
      pit: 'pit',

      /**
       * Controller Reference
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * SYMbolRef
       * @const
       * @type {string}
       */
      ref: 'ref',

      /**
       * Label associated with the physical location of the component or port.
       * @const
       * @type {string}
       */
      label: 'label',

      /**
       * User assigned label associated with the Volume Group.
       * @const
       * @type {string}
       */
      volumeGrp: 'volumeGrp',

      /**
       * User assigned label associated with the Dynamic Disk Pool.
       * @const
       * @type {string}
       */
      diskPool: 'diskPool'
   },

   /**
    * This enumeration data type identifies the T11-defined FC-4 types supported by the Fibre Interface.
    * @enum {string}
    */
   FC4Type: {
      /**
       * The T11-defined FC-4 type is common.
       * @const
       * @type {string}
       */
      common: 'common',

      /**
       * The T11-defined FC-4 type is Fibre Channel Protocol for SCSI.
       * @const
       * @type {string}
       */
      fcScsi: 'fcScsi',

      /**
       * The T11-defined FC-4 type is NVMe over Fibre Channel.
       * @const
       * @type {string}
       */
      fcNvme: 'fcNvme'
   },

   /**
    * An enumeration used to determine the status of a fan component.
    * @enum {string}
    */
   FanStatus: {
      /**
       * The fan is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The fan is not working or not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The fan has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the fan is unknown
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * This enumeration identifies the defined feature attributes.
    * @enum {string}
    */
   FeatureAttrId: {
      /**
       * The feature attribute is "SHIPPED ENABLED," a boolean value which, when true, means the feature is available at the time the product is shipped.
       * @const
       * @type {string}
       */
      shippedEnabled: 'shippedEnabled',

      /**
       * The feature attribute is "SHIPPED LIMIT," an integer value which represents a numeric upper bound that is in force at the time the product is shipped.
       * @const
       * @type {string}
       */
      shippedLimit: 'shippedLimit',

      /**
       * The feature attribute is "KEY_ENABLED," a boolean value which, when true, means that the feature is capable of being enabled or extended through application of a SAFE (Storage Array Feature Enablement) key.
       * @const
       * @type {string}
       */
      keyEnabled: 'keyEnabled',

      /**
       * The feature attribute is "KEY LIMIT," an integer value which represents a numeric upper bound associated with a key-enabled feature.
       * @const
       * @type {string}
       */
      keyLimit: 'keyLimit',

      /**
       * The feature attribute is "SUPPORTED VALUES," a set of strings representing particular capabilities of the feature.
       * @const
       * @type {string}
       */
      supportedValues: 'supportedValues',

      /**
       * The feature attribute is "SUBJECT_TO_GOLD_KEY," a boolean value which, when true, means the "gold key" must be applied before the feature key can be used.
       * @const
       * @type {string}
       */
      subjectToGoldKey: 'subjectToGoldKey',

      /**
       * The feature attribute is "EVALUATION DURATION," an unsigned integer representing the evaluation period duration (in days).
       * @const
       * @type {string}
       */
      evalDuration: 'evalDuration'
   },

   /**
    * This enumeration identifies the features that can be part of a feature bundle. A FeatureId is different from a Capability in that a FeatureId represents something that may or may not be presently enabled, while a Capability represents something that the array is capable of, i.e., something that is by definition enabled,
    * @enum {string}
    */
   FeatureId: {
      /**
       * The feature is "VOLUMES PER_PARTITION".
       * @const
       * @type {string}
       */
      volumesPerPartition: 'volumesPerPartition',

      /**
       * The feature is "TOTAL NUMBER OF VOLUMES"
       * @const
       * @type {string}
       */
      totalNumberOfVolumes: 'totalNumberOfVolumes',

      /**
       * The feature is "STORAGE PARTITIONS".
       * @const
       * @type {string}
       */
      storagePartitions: 'storagePartitions',

      /**
       * The feature is "SNAPSHOT".
       * @const
       * @type {string}
       */
      snapshot: 'snapshot',

      /**
       * The feature is "VOLUME COPY".
       * @const
       * @type {string}
       */
      volumeCopy: 'volumeCopy',

      /**
       * The feature is "REMOTE MIRRORING".
       * @const
       * @type {string}
       */
      remoteMirroring: 'remoteMirroring',

      /**
       * The feature is "DRIVE TRAY EXPANSION".
       * @const
       * @type {string}
       */
      driveTrayExpansion: 'driveTrayExpansion',

      /**
       * The feature is "MIXED DRIVE TYPES".
       * @const
       * @type {string}
       */
      mixedDriveTypes: 'mixedDriveTypes',

      /**
       * The feature is "MANAGEMENT APPLICATION". Supported values for this feature conform to the MgmtApplicationType enumeration values, represented as character strings.
       * @const
       * @type {string}
       */
      mgmtApplication: 'mgmtApplication',

      /**
       * The feature is "SUPPORTED DRIVES".
       * @const
       * @type {string}
       */
      supportedDrives: 'supportedDrives',

      /**
       * The feature is "SUPPORTED DRIVE TRAYS".
       * @const
       * @type {string}
       */
      supportedDriveTrays: 'supportedDriveTrays',

      /**
       * The feature is "PERFORMANCE TIER".
       * @const
       * @type {string}
       */
      performanceTier: 'performanceTier',

      /**
       * The feature is "TOTAL NUMBER OF SNAPSHOTS".
       * @const
       * @type {string}
       */
      totalNumberOfSnapshots: 'totalNumberOfSnapshots',

      /**
       * The feature is "TOTAL NUMBER OF VOLUME COPY RELATIONSHIPS".
       * @const
       * @type {string}
       */
      totalNumberOfVolCopies: 'totalNumberOfVolCopies',

      /**
       * The feature is "GOLD KEY".
       * @const
       * @type {string}
       */
      goldKey: 'goldKey',

      /**
       * The feature is "SNAPSHOTS PER VOLUME".
       * @const
       * @type {string}
       */
      snapshotsPerVolume: 'snapshotsPerVolume',

      /**
       * deprecated.
       * @const
       * @type {string}
       */
      totalNumberOfMirrors: 'totalNumberOfMirrors',

      /**
       * The feature is "RAID 6 VOLUME GROUPS".
       * @const
       * @type {string}
       */
      raid6: 'raid6',

      /**
       * The feature is "CONTROLLER STATE CAPTURE".
       * @const
       * @type {string}
       */
      stateCapture: 'stateCapture',

      /**
       * Deprecated.
       * @const
       * @type {string}
       */
      sataStrLen: 'sataStrLen',

      /**
       * Secure Volume feature to support FDE drives.
       * @const
       * @type {string}
       */
      secureVolume: 'secureVolume',

      /**
       * T10 End to End Data Protection Information (PI) feature support.
       * @const
       * @type {string}
       */
      protectionInformation: 'protectionInformation',

      /**
       * The Solid State Disk feature support.
       * @const
       * @type {string}
       */
      solidStateDisk: 'solidStateDisk',

      /**
       * The drive limit feature is supported.
       * @const
       * @type {string}
       */
      driveSlotLimit: 'driveSlotLimit',

      /**
       * The FDE proxy key management feature is supported.
       * @const
       * @type {string}
       */
      fdeProxyKeyManagement: 'fdeProxyKeyManagement',

      /**
       * The "Supported Interposer" feature is supported.
       * @const
       * @type {string}
       */
      supportedInterposer: 'supportedInterposer',

      /**
       * The Vendor Drive Slot feature is supported.
       * @const
       * @type {string}
       */
      vendorSupportedDrives: 'vendorSupportedDrives',

      /**
       * The Flash Read Cache feature is supported.
       * @const
       * @type {string}
       */
      flashReadCache: 'flashReadCache',

      /**
       * The feature id is Total Number of Async Mirror Groups.
       * @const
       * @type {string}
       */
      totalNumberOfAsyncMirrorGroups: 'totalNumberOfAsyncMirrorGroups',

      /**
       * The Feature ID is Total Number of Async Mirrors Per Group
       * @const
       * @type {string}
       */
      totalNumberOfAsyncMirrorsPerGroup: 'totalNumberOfAsyncMirrorsPerGroup',

      /**
       * The Feature ID is Total Number of ARVM Mirrors Per Array.
       * @const
       * @type {string}
       */
      totalNumberOfArvmMirrorsPerArray: 'totalNumberOfArvmMirrorsPerArray',

      /**
       * The PiT Groups feature is supported.
       * @const
       * @type {string}
       */
      totalNumberOfPitsPerArray: 'totalNumberOfPitsPerArray',

      /**
       * The Feature ID is PiT Groups Per Volume.
       * @const
       * @type {string}
       */
      pitGroupsPerVolume: 'pitGroupsPerVolume',

      /**
       * The Feature ID is Total Number of PiT Groups.
       * @const
       * @type {string}
       */
      totalNumberOfPitGroups: 'totalNumberOfPitGroups',

      /**
       * The Feature ID is PiTs per PiT Group.
       * @const
       * @type {string}
       */
      pitsPerPitGroup: 'pitsPerPitGroup',

      /**
       * The Feature ID is Member Vols Per PiT Consistency Group
       * @const
       * @type {string}
       */
      memberVolsPerPitConsistencyGroup: 'memberVolsPerPitConsistencyGroup',

      /**
       * The Feature ID is Total Number of PiT Consistency Groups
       * @const
       * @type {string}
       */
      totalNumberOfPitConsistencyGroups: 'totalNumberOfPitConsistencyGroups',

      /**
       * The Feature ID is Total Number of PiT Views.
       * @const
       * @type {string}
       */
      totalNumberOfPitViews: 'totalNumberOfPitViews',

      /**
       * The Feature ID is Total Number of Thin Volumes Per Array.
       * @const
       * @type {string}
       */
      totalNumberOfThinVolumesPerArray: 'totalNumberOfThinVolumesPerArray',

      /**
       * Native SATA drives are supported.
       * @const
       * @type {string}
       */
      nativeSataDriveSupport: 'nativeSataDriveSupport',

      /**
       * This id references the number of solid state disks allowed by the feature bundle data table (FBDT).
       * @const
       * @type {string}
       */
      solidStateDiskLimit: 'solidStateDiskLimit',

      /**
       * Total number of mirrors (both sync and async/ARVM) allowed per array.
       * @const
       * @type {string}
       */
      totalNumberOfRemoteMirrorsPerArray: 'totalNumberOfRemoteMirrorsPerArray',

      /**
       * The Autosupport feature is supported.
       * @const
       * @type {string}
       */
      asup: 'asup',

      /**
       * This selects a field from the Feature Bundle Table that contains the filename of the MEL Event Configuration Table to load from flash.
       * @const
       * @type {string}
       */
      ectSelector: 'ectSelector',

      /**
       * The SNMP Object Identifier (OID) that forms the basis of the MIB sub-tree for the embedded SNMP agent is configurable on a per-sub-model basis. This SNMP OID is reported via GET requests for the sysObjectId variable in the MIB-II System Group.
       * @const
       * @type {string}
       */
      embeddedSnmpOid: 'embeddedSnmpOid',

      /**
       * The Autosupport On Demand feature is supported.
       * @const
       * @type {string}
       */
      asupOnDemand: 'asupOnDemand',

      /**
       * DACStore Compatibility IDs are supported.
       * @const
       * @type {string}
       */
      dacstoreCompatId: 'dacstoreCompatId',

      /**
       * The Samoa host interface card is supported.
       * @const
       * @type {string}
       */
      samoaHicProtocol: 'samoaHicProtocol',

      /**
       * This is the feature that allows special Target Port LUN mapping to limit exposure of LUN to only one target port.
       * @const
       * @type {string}
       */
      targetPortLunMapping: 'targetPortLunMapping',

      /**
       * This feature ID sets the personality of any Hilda chips on a controller baseboard
       * @const
       * @type {string}
       */
      hildaBaseboardProtocol: 'hildaBaseboardProtocol',

      /**
       * This feature ID sets the protocol of the Denali2 HIC card -- iSER or SRP.
       * @const
       * @type {string}
       */
      denali2Protocol: 'denali2Protocol',

      /**
       * Container based application feature support.
       * @const
       * @type {string}
       */
      containerBasedApplication: 'containerBasedApplication',

      /**
       * This feature ID sets the protocol of the fibre channel HIC - NVMeoF or SCSI FCP.
       * @const
       * @type {string}
       */
      fibreChannelHicProtocol: 'fibreChannelHicProtocol',

      /**
       * This feature ID configures the capability to set certain tray VPD fields.
       * @const
       * @type {string}
       */
      trayVpdSettable: 'trayVpdSettable',

      /**
       * This feature ID configures the capability to enable or disable ephemeral iSCSI login handling.
       * @const
       * @type {string}
       */
      ephemeralIscsiLoginSupport: 'ephemeralIscsiLoginSupport',

      /**
       * This feature id controls whether foreign volume copy in (volume import) is supported or not.
       * @const
       * @type {string}
       */
      foreignVolumeCopyIn: 'foreignVolumeCopyIn'
   },

   /**
    * This enumeration defines the values in the feature bundle for FEATURE_ID_FIBRE_CHANNEL_HIC_PROTOCOL. This feature indicates which FC protocol should be applied to the Yellowstone HIC.
    * @enum {string}
    */
   FibreChannelHICProtocol: {
      /**
       * Fibre Channel protocol not supported.
       * @const
       * @type {string}
       */
      notSupported: 'notSupported',

      /**
       * The feature bundle indicates the FC HIC protccol should be set to SCSI-FCP.
       * @const
       * @type {string}
       */
      scsiFcp: 'scsiFcp',

      /**
       * The feature bundle indicates the FC HIC protocol should be set to NVMe over fabrics.
       * @const
       * @type {string}
       */
      nvmeof: 'nvmeof'
   },

   /**
    * This enumeration describes the various Fibre Channel remote mirror states.
    * @enum {string}
    */
   FibreChannelRemoteMirroringState: {
      /**
       * The Fibre Channel mirror state is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Fibre Channel remote mirroring is not enabled.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * Fibre Channel remote mirroring enabled for legacy synchronous or legacy asynchronous RVM.
       * @const
       * @type {string}
       */
      enabledLegacyRvm: 'enabledLegacyRvm',

      /**
       * Fibre Channel remote mirroring enabled for ARVM.
       * @const
       * @type {string}
       */
      enabledArvm: 'enabledArvm',

      /**
       * Fibre Channel remote mirroring enabled for both ARVM and legacy RVM.
       * @const
       * @type {string}
       */
      enabledAll: 'enabledAll'
   },

   /**
    * This enumeration defines the different Fibre Channel topology types that may be reported as part of the I/O interface information associated with a controller.
    * @enum {string}
    */
   FibreTopologyType: {
      /**
       * The topology is not known. This generally indicates that the controller has not yet initialized the associated interface.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * A point-to-point topology is being used.
       * @const
       * @type {string}
       */
      ptp: 'ptp',

      /**
       * A fabric-based topology is being used.
       * @const
       * @type {string}
       */
      fabric: 'fabric',

      /**
       * An arbitrated loop topology is being used.
       * @const
       * @type {string}
       */
      arbLoop: 'arbLoop',

      /**
       * A fabric loop topology is being used.
       * @const
       * @type {string}
       */
      fabLoop: 'fabLoop'
   },

   /**
    * This enumeration is used to indicate the status of flash cache analytics.
    * @enum {string}
    */
   FlashCacheAnalyticsStatus: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Flash cache analytics is stopped.
       * @const
       * @type {string}
       */
      stopped: 'stopped',

      /**
       * Flash cache analytics is in progress.
       * @const
       * @type {string}
       */
      started: 'started'
   },

   /**
    * This enumeration defines the possible flash cache analytics stop reasons.
    * @enum {string}
    */
   FlashCacheAnalyticsStatusCause: {
      /**
       * Flash cache analytics has not stopped so there is no cause.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Flash cache analytics is stopped since user requested it.
       * @const
       * @type {string}
       */
      userStopped: 'userStopped',

      /**
       * Flash cache analytics is stopped since user enabled/disabled FC during analytics.
       * @const
       * @type {string}
       */
      userFcChanges: 'userFcChanges',

      /**
       * Flash cache analytics is stopped since controller rebooted during analytics.
       * @const
       * @type {string}
       */
      internalCtlrRebooted: 'internalCtlrRebooted',

      /**
       * Flash cache analytics is stopped due to configuration changes such as creation of certain volume types, ownership transfer, etc.
       * @const
       * @type {string}
       */
      internalCfgChanges: 'internalCfgChanges'
   },

   /**
    * This enumeration is used to identify how the flash cache is used. Supported configuration types will be reported using a FeatureParamsModificationEvent with an event attribute called SUPPORTEDFLASHCACHECONFIGS.
    * @enum {string}
    */
   FlashCacheConfigType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The flash cache is configured as a file system.
       * @const
       * @type {string}
       */
      filesystem: 'filesystem',

      /**
       * The flash cache is configured as a database.
       * @const
       * @type {string}
       */
      database: 'database',

      /**
       * This enumeration value actually refers to a WEBSERVER configuration type instead of a MULTIMEDIA configuration type.
       * @const
       * @type {string}
       */
      multimedia: 'multimedia'
   },

   /**
    * This enumeration is used to identify the current status of the flash cache.
    * @enum {string}
    */
   FlashCacheStatus: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The flash cache status is optimal.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The flash cache status is degraded.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The flash cache status is failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The flash cache status is suspended.
       * @const
       * @type {string}
       */
      suspended: 'suspended'
   },

   /**
    * This enumeration is used to identify the current status of the flash cache.
    * @enum {string}
    */
   FlashCacheStatusCause: {
      /**
       * The flash cache status is not set.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The flash cache is in an optimal state with a hot spare in use.
       * @const
       * @type {string}
       */
      hotspareInuse: 'hotspareInuse',

      /**
       * The flash cache state is due to inaccessible drives. This is possible when the flash cache is in a degraded or failed state.
       * @const
       * @type {string}
       */
      drivesInaccessible: 'drivesInaccessible',

      /**
       * The flash cache state is due to a cache size mismatch. This is possible when the flash cache is in a failed state.
       * @const
       * @type {string}
       */
      cacheSizeMismatch: 'cacheSizeMismatch',

      /**
       * The flash cache is due to missing drives. This is possible when the flash cache is in a degraded state.
       * @const
       * @type {string}
       */
      missingDrives: 'missingDrives'
   },

   /**
    * This enumeration identifies the type of flash cache.
    * @enum {string}
    */
   FlashCacheType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The flash cache is a read only cache.
       * @const
       * @type {string}
       */
      readOnlyCache: 'readOnlyCache',

      /**
       * The flash cache is a write cache.
       * @const
       * @type {string}
       */
      writeCache: 'writeCache',

      /**
       * The flash cache is virtual.
       * @const
       * @type {string}
       */
      virtual: 'virtual'
   },

   /**
    * This enumeration describes the FRU diagnostic test status.
    * @enum {string}
    */
   FruDiagStatus: {
      /**
       * No diagnostic status is available.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Diagnostic in progress.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * Diagnostic completed successfully.
       * @const
       * @type {string}
       */
      successful: 'successful',

      /**
       * Diagnostic failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * Diagnostic stopped by initiator.
       * @const
       * @type {string}
       */
      stopByInitiator: 'stopByInitiator',

      /**
       * Diagnostic stopped by controller reset.
       * @const
       * @type {string}
       */
      stopByReset: 'stopByReset',

      /**
       * Diagnostics were initiated on a HIC that does not support them.
       * @const
       * @type {string}
       */
      notSupported: 'notSupported',

      /**
       * The diagnostic was skipped.
       * @const
       * @type {string}
       */
      skipped: 'skipped'
   },

   /**
    * This enumeration identifies the FRU diagnostic test.
    * @enum {string}
    */
   FruDiagTestIdentifier: {
      /**
       * No diagnostic status is available.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * This test will include writing patterns for a single 8-byte word. A single byte of the pattern will be cleared and compared to a mask to ensure that the correct byte was successfully cleared. This will be repeated for all bytes in the 8-byte word.
       * @const
       * @type {string}
       */
      dimmByteEnable: 'dimmByteEnable',

      /**
       * This test will verify single bit and multi-bit ECC errors on specified regions within the cache memory. It will also attempt to correct the ECC errors. If the ECC errors are not correctable, it will perform a self-lockdown indicating an ECC error.
       * @const
       * @type {string}
       */
      dimmEcc: 'dimmEcc',

      /**
       * This will perform a March C- test on specified regions within the RPA memory. It will test for only one set of inverse patterns.
       * @const
       * @type {string}
       */
      dimmMarchC: 'dimmMarchC',

      /**
       * This is a typical DRAM word pattern test where the test sequence proceeds with a series of read/write operations for all locations within the specified memory region using a set of special patterns. The test writes and verifies several patterns at 32 bit widths.
       * @const
       * @type {string}
       */
      dimmPatterns: 'dimmPatterns',

      /**
       * This test will generate a non-repetitive pattern for the double word length and write to the entire region specified. The pattern will be read back and verified.
       * @const
       * @type {string}
       */
      dimmPseudorandom: 'dimmPseudorandom',

      /**
       * This test will checked the capability of DMA copy operations across various regions within the cache memory. This will use the RPA hardware capabilities to move the data from one region to another.
       * @const
       * @type {string}
       */
      dimmDmaCopy: 'dimmDmaCopy',

      /**
       * This diagnostic tests if the USB flash device is write protected.
       * @const
       * @type {string}
       */
      usbflashWriteProtect: 'usbflashWriteProtect',

      /**
       * This diagnostic indicates whether a USB flash drive is approaching its write cycle limit.
       * @const
       * @type {string}
       */
      usbflashWriteCycle: 'usbflashWriteCycle',

      /**
       * This diagnostic will write a pattern to the entire USB flash drive in quantum of blocks. Each block written will be read back and the data verified.
       * @const
       * @type {string}
       */
      usbflashWritePatterns: 'usbflashWritePatterns',

      /**
       * This diagnostic will write a random pattern to each flash block. The written pattern will be read back and the data verified.
       * @const
       * @type {string}
       */
      usbflashRandom: 'usbflashRandom',

      /**
       * HIC Read Write.
       * @const
       * @type {string}
       */
      hicReadWrite: 'hicReadWrite',

      /**
       * HIC Data Lines.
       * @const
       * @type {string}
       */
      hicDataLines: 'hicDataLines',

      /**
       * HIC Interrupt.
       * @const
       * @type {string}
       */
      hicInterrupt: 'hicInterrupt',

      /**
       * HIC Loopback.
       * @const
       * @type {string}
       */
      hicLoopback: 'hicLoopback',

      /**
       * HIC T10 Protection Information.
       * @const
       * @type {string}
       */
      hicT10pi: 'hicT10pi',

      /**
       * HIC DMA.
       * @const
       * @type {string}
       */
      hicDma: 'hicDma',

      /**
       * HIC Context Memory.
       * @const
       * @type {string}
       */
      hicContextMemory: 'hicContextMemory',

      /**
       * HIC Extended Memory.
       * @const
       * @type {string}
       */
      hicExtMemory: 'hicExtMemory',

      /**
       * Controller Register Address.
       * @const
       * @type {string}
       */
      ctlrRegisterAddress: 'ctlrRegisterAddress',

      /**
       * Controller Data Lines.
       * @const
       * @type {string}
       */
      ctlrDataLines: 'ctlrDataLines',

      /**
       * Controller APC SRAM.
       * @const
       * @type {string}
       */
      ctlrApcSram: 'ctlrApcSram',

      /**
       * Controller APC FIFO.
       * @const
       * @type {string}
       */
      ctlrApcFifo: 'ctlrApcFifo',

      /**
       * Controller Data Copy.
       * @const
       * @type {string}
       */
      ctlrDataCopy: 'ctlrDataCopy',

      /**
       * Controller RAID 5.
       * @const
       * @type {string}
       */
      ctlrRaid5: 'ctlrRaid5',

      /**
       * Controller RAID 6.
       * @const
       * @type {string}
       */
      ctlrRaid6: 'ctlrRaid6',

      /**
       * Used for HIC RAM read/write tests.
       * @const
       * @type {string}
       */
      hicRamReadWrite: 'hicRamReadWrite'
   },

   /**
    * This enumeration describes the FRU diagnostic test type.
    * @enum {string}
    */
   FruDiagTestType: {
      /**
       * No diagnostic status is available.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Basic diagnostic.
       * @const
       * @type {string}
       */
      serviceModeBasic: 'serviceModeBasic',

      /**
       * Extended diagnostic.
       * @const
       * @type {string}
       */
      serviceModeExtended: 'serviceModeExtended'
   },

   /**
    * This enumeration identifies the various actions that can be performed using the setFunctionState procedure.
    * @enum {string}
    */
   FunctionAction: {
      /**
       * No action specified.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Return the value, don't make any changes to the state of the function.
       * @const
       * @type {string}
       */
      getValue: 'getValue',

      /**
       * Enable the specified function.
       * @const
       * @type {string}
       */
      enableFunction: 'enableFunction',

      /**
       * Disable the specified function.
       * @const
       * @type {string}
       */
      disableFunction: 'disableFunction',

      /**
       * Revert back to the default value.
       * @const
       * @type {string}
       */
      setDefault: 'setDefault'
   },

   /**
    * This enumeration identifies the functions that can be turned off and on via the setFunctionState procedure.
    * @enum {string}
    */
   FunctionID: {
      /**
       * No function is specified.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Turn VAAI on/off.
       * @const
       * @type {string}
       */
      vaai: 'vaai',

      /**
       * Turn ODX on/off.
       * @const
       * @type {string}
       */
      odx: 'odx'
   },

   /**
    * This enumeration identifies the state of a specified function.
    * @enum {string}
    */
   FunctionState: {
      /**
       * The function state is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The function state is inconsistent between the two controllers.
       * @const
       * @type {string}
       */
      inconsistent: 'inconsistent',

      /**
       * The function is enabled.
       * @const
       * @type {string}
       */
      enabled: 'enabled',

      /**
       * The function is disabled.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The function state could not be determined.
       * @const
       * @type {string}
       */
      unavailable: 'unavailable'
   },

   /**
    * This enumeration is used to identify the parent type of a GBIC component.
    * @enum {string}
    */
   GBICParentType: {
      /**
       * The GBIC belongs to an ESM.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The GBIC belongs to a minihub.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The GBIC belongs to a controller channel.
       * @const
       * @type {string}
       */
      controller: 'controller'
   },

   /**
    * This enumeration object is used to describe the port type associated with a given GBIC.
    * @enum {string}
    */
   GBICPort: {
      /**
       * The GBIC is associated with an In port.
       * @const
       * @type {string}
       */
      port1: 'port1',

      /**
       * The GBIC is associated with an Out port.
       * @const
       * @type {string}
       */
      port2: 'port2'
   },

   /**
    * This enumeration is used to determine the status of a GBIC component.
    * @enum {string}
    */
   GBICStatus: {
      /**
       * The GBIC is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The GBIC is not working or not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The GBIC has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the GBIC is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * This enumeration is used to identify the type of a GBIC.
    * @enum {string}
    */
   GBICType: {
      /**
       * GBIC is not present.
       * @const
       * @type {string}
       */
      notPresent: 'notPresent',

      /**
       * Copper Style 1 or Style 2 connector, 1.0625 Gbd, 100-TW-EL-S or 100-TP-EL-S, active intercabinet connection.
       * @const
       * @type {string}
       */
      cs12Active: 'cs12Active',

      /**
       * Copper Style 1 or Style 2 connector, 1.0625 Gbd, 100-TW-EL-S or 100-TP-EL-S, active or passive intercabinet connection.
       * @const
       * @type {string}
       */
      cs12Passive: 'cs12Passive',

      /**
       * Optical Longwave, 1.0625 Gbd 100-SM-LL-X.
       * @const
       * @type {string}
       */
      opticalLw: 'opticalLw',

      /**
       * Serial module definition protocol.
       * @const
       * @type {string}
       */
      serialModule: 'serialModule',

      /**
       * Optical Shortwave, 1.0625 Gbd 100-M5-SN-I or 100-M6-SN-I.
       * @const
       * @type {string}
       */
      opticalSw: 'opticalSw',

      /**
       * Optical Longwave, 1.0625 Gbd 100-SM-LL-X and similar to 1.25 Gbd IEEE 802.3z 1000BASE-LX, single mode.
       * @const
       * @type {string}
       */
      opticalLwLxSingleMode: 'opticalLwLxSingleMode',

      /**
       * Optical Shortwave, 1.0625 Gbd 100-M5-SN-I or 100-M6-SN-I and 1.25 Gbd, IEEE 803.3z, 1000BASE-SX.
       * @const
       * @type {string}
       */
      opticalSwSx: 'opticalSwSx'
   },

   /**
    * This enumeration type identifies the different filter options for the getIscsiSessions procedure.
    * @enum {string}
    */
   GetIscsiSessionsType: {
      /**
       * Report all iSCSI sessions known to the storage array.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * Report all iSCSI sessions for a given target.
       * @const
       * @type {string}
       */
      byTarget: 'byTarget',

      /**
       * Report all iSCSI sessions for a given initiator.
       * @const
       * @type {string}
       */
      byInitiator: 'byInitiator'
   },

   /**
    * This enumeration identifies the protocol selection used by a host interface card with a selectable protocol type.
    * @enum {string}
    */
   HICProtocolType: {
      /**
       * A firmware-configurable host interface card is not on this controller.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The HIC to to be configured for Ethernet protocol.
       * @const
       * @type {string}
       */
      ethernet: 'ethernet',

      /**
       * The HIC to to be configured for Fibre Channel protocol.
       * @const
       * @type {string}
       */
      fc: 'fc',

      /**
       * The HIC is to be configured for Ethernet protocol on ports 1 and 2 and for Fibre Channel on ports 3 and 4 (if ports 3 and 4 are present).
       * @const
       * @type {string}
       */
      ethernetAndFcSplit: 'ethernetAndFcSplit'
   },

   /**
    * This indicates the recovery action to be taken for a given health check test suite
    * @enum {string}
    */
   HealthCheckRecoveryAction: {
      /**
       * Recovery action unknown
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * No action
       * @const
       * @type {string}
       */
      noAction: 'noAction',

      /**
       * Call support
       * @const
       * @type {string}
       */
      callSupport: 'callSupport',

      /**
       * Correct existing failures
       * @const
       * @type {string}
       */
      correctRecoveryFailures: 'correctRecoveryFailures',

      /**
       * Wait for long lived operations
       * @const
       * @type {string}
       */
      waitLonglivedOps: 'waitLonglivedOps'
   },

   /**
    * These are the possible Health Check Test Suites that may be run.
    * @enum {string}
    */
   HealthCheckTestSuite: {
      /**
       * Unknown Test Suite
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Preupgrade Health Check Suite
       * @const
       * @type {string}
       */
      preUpgradeTest: 'preUpgradeTest'
   },

   /**
    * This enumeration identifies the different scale types that can be applied to a histogram.
    * @enum {string}
    */
   HistogramScaleType: {
      /**
       * Indicates linear scaling of the histogram.
       * @const
       * @type {string}
       */
      linear: 'linear',

      /**
       * Indicates base 2 logarithmic scaling of the histogram.
       * @const
       * @type {string}
       */
      logBase2: 'logBase2',

      /**
       * Indicates base 10 logarithmic scaling of the histogram.
       * @const
       * @type {string}
       */
      logBase10: 'logBase10'
   },

   /**
    * This enumeration object is used to determine the status of a controller's host board.
    * @enum {string}
    */
   HostBoardStatus: {
      /**
       * The status of the host board is unknown (generally due to conditions within the array that cause normal communication pathways to be unavailable).
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The host board is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The host board needs attention.
       * @const
       * @type {string}
       */
      needsAttention: 'needsAttention',

      /**
       * The host board is not present. This status is used to represent an empty host card slot, i.e., the controller model is defined such that it may receive a host card field upgrade, but currently has an unpopulated host card slot.
       * @const
       * @type {string}
       */
      notPresent: 'notPresent',

      /**
       * The host board is in a degraded condition. This means that some, but not all, ports of the host board are unable to transport I/O.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The host board has failed and is unable to transport I/O.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * A diagnostic operation is currently running on the host board.
       * @const
       * @type {string}
       */
      diagInProgress: 'diagInProgress'
   },

   /**
    * This enumeration object is used to indicate the type of a controller's host board.
    * @enum {string}
    */
   HostBoardType: {
      /**
       * The host board type is unknown.
       * @const
       * @type {string}
       */
      typeUnknown: 'typeUnknown',

      /**
       * The host board is a standard XBB 4-port, 4GB Fibre Channel host board.
       * @const
       * @type {string}
       */
      type4portFc: 'type4portFc',

      /**
       * The host board is a Qlogic 4GB Fibre Channel switch having 20 ports, 16 of which are available externally.
       * @const
       * @type {string}
       */
      type20portSwitchedFc: 'type20portSwitchedFc',

      /**
       * The host board is a single-port, serial-attached SCSI host board.
       * @const
       * @type {string}
       */
      type1portSas: 'type1portSas',

      /**
       * The host board is a 2-port, 4GB Fibre Channel host board.
       * @const
       * @type {string}
       */
      type2portFc: 'type2portFc',

      /**
       * The host board is a 2-port iSCSI host board.
       * @const
       * @type {string}
       */
      type2portIscsi: 'type2portIscsi',

      /**
       * The host board is a dual-port, serial-attached SCSI host board.
       * @const
       * @type {string}
       */
      type2portSas: 'type2portSas',

      /**
       * The host board is a 2-port InfiniBand host board.
       * @const
       * @type {string}
       */
      type2portIb: 'type2portIb',

      /**
       * The host board is a standard XBB 8-port, 4GB Fibre Channel host board.
       * @const
       * @type {string}
       */
      type8portFc: 'type8portFc',

      /**
       * The host board is a 4-port iSCSI host board.
       * @const
       * @type {string}
       */
      type4portIscsi: 'type4portIscsi',

      /**
       * The host board is a 4-port SAS host board.
       * @const
       * @type {string}
       */
      type4portSas: 'type4portSas',

      /**
       * The host board is a quad-port serial-attached SCSI Glacier host board.
       * @const
       * @type {string}
       */
      type4portSasGlacier: 'type4portSasGlacier',

      /**
       * The host board is a two-port FC-ISCSI Samoa board.
       * @const
       * @type {string}
       */
      type2portFcIscsiSamoa: 'type2portFcIscsiSamoa',

      /**
       * The host board is a quad-port Samoa board with two ports operating in iSCSI mode and two ports operating in FC mode.
       * @const
       * @type {string}
       */
      type4portFcIscsiSamoa: 'type4portFcIscsiSamoa',

      /**
       * The host board is a two-port iSCSI Zion host board.
       * @const
       * @type {string}
       */
      type2portIscsiZion: 'type2portIscsiZion',

      /**
       * The host board is a dual-port, serial-attached SCSI host board.
       * @const
       * @type {string}
       */
      type2portSasAcadia: 'type2portSasAcadia',

      /**
       * The host board is a 4-port, serial-attached SCSI host board.
       * @const
       * @type {string}
       */
      type4portSasAcadia: 'type4portSasAcadia',

      /**
       * The host board is a 2-port InfiniBand Denali host board.
       * @const
       * @type {string}
       */
      type2portIbDenali: 'type2portIbDenali',

      /**
       * The host board is a 2-port FC Samoa board.
       * @const
       * @type {string}
       */
      type2portFcSamoa: 'type2portFcSamoa',

      /**
       * The host board is a 4-port FC Samoa board.
       * @const
       * @type {string}
       */
      type4portFcSamoa: 'type4portFcSamoa',

      /**
       * The host board is a 2-port iSCSI Samoa board.
       * @const
       * @type {string}
       */
      type2portIscsiSamoa: 'type2portIscsiSamoa',

      /**
       * The host board is a 4-port iSCSI Samoa board.
       * @const
       * @type {string}
       */
      type4portIscsiSamoa: 'type4portIscsiSamoa',

      /**
       * The host board is a 4-port 12Gb SAS (SAS3) board.
       * @const
       * @type {string}
       */
      type4portSas3: 'type4portSas3',

      /**
       * The host board is a 2-port 100Gb Infiniband board.
       * @const
       * @type {string}
       */
      type2portIb100gb: 'type2portIb100gb',

      /**
       * The host board is a 4-port 25Gb Ethernet board.
       * @const
       * @type {string}
       */
      type4portEthernet25gb: 'type4portEthernet25gb',

      /**
       * The host board is a 4-port 32Gb Fibre Channel board.
       * @const
       * @type {string}
       */
      type4portFc32gb: 'type4portFc32gb',

      /**
       * The host board is a 2-port 100Gb Ethernet board.
       * @const
       * @type {string}
       */
      type2portEth100gb: 'type2portEth100gb',

      /**
       * The host board is a 2-port 200Gb InfiniBand board.
       * @const
       * @type {string}
       */
      type2portIb200gb: 'type2portIb200gb',

      /**
       * The host board is a 2-port 200Gb Ethernet board.
       * @const
       * @type {string}
       */
      type2portEth200gb: 'type2portEth200gb',

      /**
       * The host board is a 0-port auxiliary Infiniband board.
       * @const
       * @type {string}
       */
      typeIbAux: 'typeIbAux',

      /**
       * The host board is a 0-port auxiliary Ethernet board.
       * @const
       * @type {string}
       */
      typeEthAux: 'typeEthAux',

      /**
       * The host board is a 4-port 64Gb Fibre Channel board.
       * @const
       * @type {string}
       */
      type4portFc64gb: 'type4portFc64gb'
   },

   /**
    * Used to order the different host types available for selection when creating hosts.
    * @enum {string}
    */
   HostTypeCategory: {
      /**
       * The host type category is uninitialized (i.e., has not been set).
       * @const
       * @type {string}
       */
      uninitialized: 'uninitialized',

      /**
       * This category indicates the host type is certified in the Interoperability Matrix Tool (IMT) and is commonly used.
       * @const
       * @type {string}
       */
      imtCertifiedCommon: 'imtCertifiedCommon',

      /**
       * This category indicates the host type is certified in the Interoperability Matrix Tool (IMT) and is uncommon or rarely used.
       * @const
       * @type {string}
       */
      imtCertifiedUncommon: 'imtCertifiedUncommon',

      /**
       * This category indicates the host type is certified via the Product Variance Request (PVR) process.
       * @const
       * @type {string}
       */
      pvrCertified: 'pvrCertified'
   },

   /**
    * This enumeration identifies the reasons for an IOC Dump.
    * @enum {string}
    */
   IOCDumpReason: {
      /**
       * The reason is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The IOC Dump was initiated by a user.
       * @const
       * @type {string}
       */
      userInitiated: 'userInitiated',

      /**
       * The reason was an IOC reboot.
       * @const
       * @type {string}
       */
      reboot: 'reboot',

      /**
       * The reason is other.
       * @const
       * @type {string}
       */
      other: 'other'
   },

   /**
    * This enumeration defines the different I/O interface types that may be reported as part of the configuration information associated with a controller.
    * @enum {string}
    */
   IOInterfaceType: {
      /**
       * No interface type has been implemented.
       * @const
       * @type {string}
       */
      notImplemented: 'notImplemented',

      /**
       * The interface type is SCSI. This field is obsolete.
       * @const
       * @type {string}
       */
      scsi: 'scsi',

      /**
       * The interface type is Fibre Channel (FC).
       * @const
       * @type {string}
       */
      fc: 'fc',

      /**
       * The interface type is serial ATA.
       * @const
       * @type {string}
       */
      sata: 'sata',

      /**
       * Serial-Attached SCSI
       * @const
       * @type {string}
       */
      sas: 'sas',

      /**
       * Internet SCSI
       * @const
       * @type {string}
       */
      iscsi: 'iscsi',

      /**
       * Infiniband
       * @const
       * @type {string}
       */
      ib: 'ib',

      /**
       * The interface type is FCOE.
       * @const
       * @type {string}
       */
      fcoe: 'fcoe',

      /**
       * The interface type is NVMeoF over Infiniband.
       * @const
       * @type {string}
       */
      nvmeof: 'nvmeof',

      /**
       * The interface type is Ethernet
       * @const
       * @type {string}
       */
      ethernet: 'ethernet',

      /**
       * Add the IOInterfaceType enum for the containerized coupling driver. The coupling driver(CD) is an interface between the linux OS running on a controller and the RAIDStack.
       * @const
       * @type {string}
       */
      nvmeCouplingDriver: 'nvmeCouplingDriver',

      /**
       * The interface type is PCI Express
       * @const
       * @type {string}
       */
      pcie: 'pcie'
   },

   /**
    * This enumeration data type enumerates the possible states of an InfiniBand link.
    * @enum {string}
    */
   IbLinkState: {
      /**
       * The physical link is up. The link layer can only transmit and receive subnet management and flow control packets.
       * @const
       * @type {string}
       */
      initialize: 'initialize',

      /**
       * The physical link is up. The link layer can transmit and receive subnet management and flow control packets. It can also receive all other types of packets, however it discards all non-subnet-management packets presented to it for transmission.
       * @const
       * @type {string}
       */
      linkArm: 'linkArm',

      /**
       * The physical link is up. The link layer can transmit and receive all types of packets.
       * @const
       * @type {string}
       */
      active: 'active',

      /**
       * The physical link is temporarily down.
       * @const
       * @type {string}
       */
      defer: 'defer',

      /**
       * The physical link is down and the link layer is idle.
       * @const
       * @type {string}
       */
      down: 'down'
   },

   /**
    * This enumeration data type identifies the various Infiniband link width values.
    * @enum {string}
    */
   IbLinkWidth: {
      /**
       * This value represents an Infiniband link width of 1X
       * @const
       * @type {string}
       */
      width1x: 'width1x',

      /**
       * This value represents an Infiniband link width of 4X
       * @const
       * @type {string}
       */
      width4x: 'width4x',

      /**
       * This value represents an Infiniband link width of 8X
       * @const
       * @type {string}
       */
      width8x: 'width8x',

      /**
       * This value represents an Infiniband link width of 12X
       * @const
       * @type {string}
       */
      width12x: 'width12x'
   },

   /**
    * This enumeration contains the legal values of the Infiniband port state.
    * @enum {string}
    */
   IbPhysPortState: {
      /**
       * The state of the Infiniband port is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * In this super state, the port drives its outputs to quiescent levels and responds to received training sequences.
       * @const
       * @type {string}
       */
      sleep: 'sleep',

      /**
       * In this super state, the port transmits training sequences and responds to received training sequences. This is the default state following power on.
       * @const
       * @type {string}
       */
      polling: 'polling',

      /**
       * Port drives its outputs to quiescent levels and does not respond to received data.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * A transient super state with both the transmitter and receiver active. The port is attempting to configure and transition to the LinkUp state.
       * @const
       * @type {string}
       */
      cfgTrain: 'cfgTrain',

      /**
       * This is the normal link operation state. The port is available to transfer packets.
       * @const
       * @type {string}
       */
      linkUp: 'linkUp',

      /**
       * The recovery super state attempts to re-synchronize the link and return it to normal operation. This state is entered when a port experiences loss of link synchronization, a major error, or when a link layer error triggers error recovery.
       * @const
       * @type {string}
       */
      linkErrRec: 'linkErrRec',

      /**
       * The Physical Layer test state allows simplified testing to determine compliance of physical layer transmitter driver and receiver circuitry with specified requirements. This state is defined for Enhanced Signaling, and is not implemented in products not supporting Enhanced Signaling.
       * @const
       * @type {string}
       */
      phyTest: 'phyTest'
   },

   /**
    * This enumeration data type enumerates the possible states of an InfiniBand port.
    * @enum {string}
    */
   IbPortState: {
      /**
       * The port is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The port is initializing.
       * @const
       * @type {string}
       */
      initialize: 'initialize',

      /**
       * The port is in the "arm" state.
       * @const
       * @type {string}
       */
      arm: 'arm',

      /**
       * The port is fully operational.
       * @const
       * @type {string}
       */
      active: 'active',

      /**
       * The port is temporarily down.
       * @const
       * @type {string}
       */
      defer: 'defer',

      /**
       * The port is down.
       * @const
       * @type {string}
       */
      down: 'down'
   },

   /**
    * This enumeration data type identifies the possible states of an InfiniBand RDMA channel.
    * @enum {string}
    */
   IbRdmaChannelState: {
      /**
       * The RDMA channel is not initialized.
       * @const
       * @type {string}
       */
      uninitialized: 'uninitialized',

      /**
       * The RDMA channel is in the process of establishing the connection.
       * @const
       * @type {string}
       */
      connecting: 'connecting',

      /**
       * The RDMA channel has an active connection.
       * @const
       * @type {string}
       */
      connected: 'connected',

      /**
       * The RDMA channel is in the process of disconnecting.
       * @const
       * @type {string}
       */
      disconnecting: 'disconnecting',

      /**
       * The connection on the RDMA channel has been terminated.
       * @const
       * @type {string}
       */
      disconnected: 'disconnected'
   },

   /**
    * This enumeration specifies the types of dependencies that may be identified for a volume belonging to a group that is a candidate to be imported.
    * @enum {string}
    */
   ImportDependencyType: {
      /**
       * The dependent volume and the referenced volume participate in the same snapshot.
       * @const
       * @type {string}
       */
      snapshot: 'snapshot',

      /**
       * The dependent volume and the referenced volume comprise a volume copy pair.
       * @const
       * @type {string}
       */
      volumeCopy: 'volumeCopy',

      /**
       * The dependent volume provides metadata for the referenced higher-level volume.
       * @const
       * @type {string}
       */
      metadata: 'metadata',

      /**
       * The dependent volume is one of the volumes in a remote mirror pair.
       * @const
       * @type {string}
       */
      mirrorPair: 'mirrorPair',

      /**
       * The dependent volume has a mapping to a host system
       * @const
       * @type {string}
       */
      hostMapping: 'hostMapping',

      /**
       * The dependent volume has a persistent reservation.
       * @const
       * @type {string}
       */
      persistentReservation: 'persistentReservation',

      /**
       * The dependent volume depends on RAID 6 hardware support.
       * @const
       * @type {string}
       */
      raid6Support: 'raid6Support',

      /**
       * The dependent volume is an Async Mirror Group Member (could be either primary or secondary).
       * @const
       * @type {string}
       */
      asyncMirrorGroupMember: 'asyncMirrorGroupMember',

      /**
       * The dependent volume is an ERV/ConcatVolume member.
       * @const
       * @type {string}
       */
      concatMember: 'concatMember',

      /**
       * The dependent volume is a PiT Group base.
       * @const
       * @type {string}
       */
      pitGroup: 'pitGroup',

      /**
       * The dependent volume is a PiT View base.
       * @const
       * @type {string}
       */
      pitView: 'pitView'
   },

   /**
    * This enumeration defines the values for the Feature ID FEATURE_ID_DENALI2_PROTOCOL in the feature bundle. The feature indicates which IB protocol should be applied to the Denali 2 HIC IB interface. The value of the feature can be 1 (iSER) or 2 (SRP).
    * @enum {string}
    */
   InfinibandHICProtocol: {
      /**
       * The IB protocol is not supported.
       * @const
       * @type {string}
       */
      notSupported: 'notSupported',

      /**
       * The feature bundle indicates the IB protocol should be iSER (iSCSI Extensions for RDMA).
       * @const
       * @type {string}
       */
      iser: 'iser',

      /**
       * The feature bundle indicates that the IB protocol should be set to SRP (SCSI RDMA Protocol).
       * @const
       * @type {string}
       */
      srp: 'srp',

      /**
       * The feature bundle indicates that the Infiniband HIC should use NVMe-oF in IB Mode
       * @const
       * @type {string}
       */
      nvme: 'nvme',

      /**
       * The feature bundle indicates that the Infiniband HIC should use NVMe-oF in Ethernet Mode
       * @const
       * @type {string}
       */
      roce: 'roce'
   },

   /**
    * This enumeration object is used to determine the status of the Interconnect CRU.
    * @enum {string}
    */
   InterconnectCRUStatus: {
      /**
       * The interconnect CRU is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The interconnect CRU is not working or is not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The interconnect CRU has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed'
   },

   /**
    * This enumeration object is used to specify the maximum speed for the interface.
    * @enum {string}
    */
   InterfaceSpeed: {
      /**
       * The speed cannot be determined.
       * @const
       * @type {string}
       */
      speedUnknown: 'speedUnknown',

      /**
       * 1 Gbit per second
       * @const
       * @type {string}
       */
      speed1gig: 'speed1gig',

      /**
       * 2Gbit per second
       * @const
       * @type {string}
       */
      speed2gig: 'speed2gig',

      /**
       * 4Gbit per second
       * @const
       * @type {string}
       */
      speed4gig: 'speed4gig',

      /**
       * 10Gbit per second
       * @const
       * @type {string}
       */
      speed10gig: 'speed10gig',

      /**
       * 1.5 Gb per second
       * @const
       * @type {string}
       */
      speed15gig: 'speed15gig',

      /**
       * 3 Gbits per second
       * @const
       * @type {string}
       */
      speed3gig: 'speed3gig',

      /**
       * 10 Mbits per second
       * @const
       * @type {string}
       */
      speed10meg: 'speed10meg',

      /**
       * 100 Mbits per second
       * @const
       * @type {string}
       */
      speed100meg: 'speed100meg',

      /**
       * 2.5 Gbits per second
       * @const
       * @type {string}
       */
      speed2pt5Gig: 'speed2pt5Gig',

      /**
       * 5 Gbits per second
       * @const
       * @type {string}
       */
      speed5gig: 'speed5gig',

      /**
       * 20 Gbits per second
       * @const
       * @type {string}
       */
      speed20gig: 'speed20gig',

      /**
       * 30 Gbits per second
       * @const
       * @type {string}
       */
      speed30gig: 'speed30gig',

      /**
       * 60 Gbits per second
       * @const
       * @type {string}
       */
      speed60gig: 'speed60gig',

      /**
       * The speed using the high performance PCI-Express quad-function FC IOC controller which can operate at 2, 4 or 8 Gbs speed.
       * @const
       * @type {string}
       */
      speed8gig: 'speed8gig',

      /**
       * 6 Gbits per second
       * @const
       * @type {string}
       */
      speed6gig: 'speed6gig',

      /**
       * 40 Gbits per second
       * @const
       * @type {string}
       */
      speed40gig: 'speed40gig',

      /**
       * 16 Gbits per second
       * @const
       * @type {string}
       */
      speed16gig: 'speed16gig',

      /**
       * 56 Gbits per second
       * @const
       * @type {string}
       */
      speed56gig: 'speed56gig',

      /**
       * 12 Gbits per second
       * @const
       * @type {string}
       */
      speed12gig: 'speed12gig',

      /**
       * 25 Gbits per second
       * @const
       * @type {string}
       */
      speed25gig: 'speed25gig',

      /**
       * 32 Gbits per second.
       * @const
       * @type {string}
       */
      speed32gig: 'speed32gig',

      /**
       * 100 Gbits per second.
       * @const
       * @type {string}
       */
      speed100gig: 'speed100gig',

      /**
       * 50 Gbits per second.
       * @const
       * @type {string}
       */
      speed50gig: 'speed50gig',

      /**
       * Auto Negotiated
       * @const
       * @type {string}
       */
      speedAuto: 'speedAuto',

      /**
       * 200 Gbits per second.
       * @const
       * @type {string}
       */
      speed200gig: 'speed200gig',

      /**
       * 64 Gbits per second.
       * @const
       * @type {string}
       */
      speed64gig: 'speed64gig',

      /**
       * 22.5 Gbits per second.
       * @const
       * @type {string}
       */
      speed22pt5Gig: 'speed22pt5Gig',

      /**
       * 24 Gbits per second
       * @const
       * @type {string}
       */
      speed24gig: 'speed24gig'
   },

   /**
    * Discriminator for the InternalMessage union. Describes what type of message is being sent
    * @enum {string}
    */
   InternalMessageType: {
      /**
       * Invalid message
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * An event related to the Security Audit Log
       * @const
       * @type {string}
       */
      auditLog: 'auditLog',

      /**
       * An internal message related to the SYMbol server access
       * @const
       * @type {string}
       */
      symAccess: 'symAccess',

      /**
       * An internal message related to the Directory Service Server
       * @const
       * @type {string}
       */
      dirServer: 'dirServer',

      /**
       * An internal message related to the local user authentication lockout
       * @const
       * @type {string}
       */
      localAuthLockout: 'localAuthLockout',

      /**
       * An internal message related to the OCSP (On-line Certificate Status Protocol) responder server address.
       * @const
       * @type {string}
       */
      ocspResponderUnreachable: 'ocspResponderUnreachable',

      /**
       * An internal message related to a certificate being revoked.
       * @const
       * @type {string}
       */
      certificateRevoked: 'certificateRevoked',

      /**
       * An internal message related to the SAML service
       * @const
       * @type {string}
       */
      samlService: 'samlService',

      /**
       * An internal message related to an ASUP maintenance mode state change.
       * @const
       * @type {string}
       */
      asupMaintenanceMode: 'asupMaintenanceMode'
   },

   /**
    * This enumeration defines the different interposer types.
    * @enum {string}
    */
   InterposerType: {
      /**
       * No interposer type is specified.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The interposer type is Fibre Channel to SAS.
       * @const
       * @type {string}
       */
      fcToSas: 'fcToSas'
   },

   /**
    * This enumeration defines the different types of IP addresses, corresponding to different versions of the Internet protocol.
    * @enum {string}
    */
   IpAddressType: {
      /**
       * The IP address format defined in version 4 of the Internet protocol.
       * @const
       * @type {string}
       */
      ipv4: 'ipv4',

      /**
       * The IP address format defined in version 6 of the Internet protocol.
       * @const
       * @type {string}
       */
      ipv6: 'ipv6'
   },

   /**
    * This enumeration data type identifies the possible states of Internet Protocol address configuration.
    * @enum {string}
    */
   IpConfigState: {
      /**
       * The address parameters have not been configured.
       * @const
       * @type {string}
       */
      unconfigured: 'unconfigured',

      /**
       * The interface is in the process of acquiring certain address-related parameters, including IP address.
       * @const
       * @type {string}
       */
      acquiring: 'acquiring',

      /**
       * The address parameters are configured for operation.
       * @const
       * @type {string}
       */
      configured: 'configured',

      /**
       * The address configuration is invalid, most likely due to improper manual configuration.
       * @const
       * @type {string}
       */
      invalid: 'invalid'
   },

   /**
    * This enumeration defines the different methods available for assigning an IPV4 address to a network interface.
    * @enum {string}
    */
   IpV4ConfigMethod: {
      /**
       * The IPV4 configuration method using Dynamic Host Configuration Protocol (DHCP) version 4.
       * @const
       * @type {string}
       */
      configDhcp: 'configDhcp',

      /**
       * The IPV4 configuration method of explicit, static IP address assignment.
       * @const
       * @type {string}
       */
      configStatic: 'configStatic'
   },

   /**
    * This enumeration defines the two different types of IPV6 addresses - interface or router.
    * @enum {string}
    */
   IpV6AddressType: {
      /**
       * The address is for an interface.
       * @const
       * @type {string}
       */
      typeInterface: 'typeInterface',

      /**
       * The address is for a router.
       * @const
       * @type {string}
       */
      typeRouter: 'typeRouter'
   },

   /**
    * This enumeration defines the different methods available for assigning an IV6P address to a network interface.
    * @enum {string}
    */
   IpV6ConfigMethod: {
      /**
       * The IPV6 configuration method of explicit, static IP address assignment.
       * @const
       * @type {string}
       */
      configStatic: 'configStatic',

      /**
       * The IPV6 configuration method of stateless autoconfiguration.
       * @const
       * @type {string}
       */
      configStateless: 'configStateless'
   },

   /**
    * This enumeration type defines values for indicating the state of an IPV6 router address.
    * @enum {string}
    */
   IpV6RouterAddressState: {
      /**
       * There is no known default router.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The default router has been configured.
       * @const
       * @type {string}
       */
      configured: 'configured',

      /**
       * The default router was discovered from a router advertisement.
       * @const
       * @type {string}
       */
      advertised: 'advertised',

      /**
       * The default router is no longer valid.
       * @const
       * @type {string}
       */
      stale: 'stale'
   },

   /**
    * This enumeration identifies the possible values for iSCSI Copper Cable Diagnostics Completion Status.
    * @enum {string}
    */
   IscsiCableDiagCompletionStatus: {
      /**
       * Diagnostics status unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Diagnostics completed.
       * @const
       * @type {string}
       */
      complete: 'complete',

      /**
       * Could not start diagnostics because another operation is already in progress on the port.
       * @const
       * @type {string}
       */
      startFailed: 'startFailed',

      /**
       * Copper cable diagnostics are not supported on this HIC.
       * @const
       * @type {string}
       */
      unsupported: 'unsupported',

      /**
       * The diagnostic operations timed out.
       * @const
       * @type {string}
       */
      timeout: 'timeout'
   },

   /**
    * This enumeration defines the different types of iSCSI sessions.
    * @enum {string}
    */
   IscsiSessionType: {
      /**
       * The iSCSI session is limited to discovery.
       * @const
       * @type {string}
       */
      discovery: 'discovery',

      /**
       * The iSCSI session is a normal, unrestricted session.
       * @const
       * @type {string}
       */
      normal: 'normal'
   },

   /**
    * This enumeration type identifies the different ways that the getIscsiStatistics procedure call has for reporting the statistics - either absolute or relative.
    * @enum {string}
    */
   IscsiStatisticsReportType: {
      /**
       * The reported statistics are the raw, start-of-day-relative counter values maintained by the firmware.
       * @const
       * @type {string}
       */
      raw: 'raw',

      /**
       * The reported statistics are relative to the client-set baseline (see setIscsiStatisticsBaseline procedure).
       * @const
       * @type {string}
       */
      rel: 'rel'
   },

   /**
    * This enumeration data type identifies the various states of the array (i.e., the iSCSI entity) with respect to iSNS registration activity.
    * @enum {string}
    */
   IsnsRegistrationState: {
      /**
       * No target is enabled for iSNS registration.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The array is in the process of discovering the IP address of the iSNS server, via DHCP.
       * @const
       * @type {string}
       */
      locatingServer: 'locatingServer',

      /**
       * The array has the IP address of the iSNS server and is in the process of connecting to it.
       * @const
       * @type {string}
       */
      connectingToServer: 'connectingToServer',

      /**
       * The array has completed the registration of the targets enabled for iSNS discovery.
       * @const
       * @type {string}
       */
      completed: 'completed'
   },

   /**
    * Identifies the type of Key Management Server (KMS) certificate file to be retrieved from or installed on the storage array.
    * @enum {string}
    */
   KMSCertificateFileType: {
      /**
       * Should not happen.
       * @const
       * @type {string}
       */
      certificateFileTypeUnknown: 'certificateFileTypeUnknown',

      /**
       * Indicates a signed client certificate. A CSR is signed by a CA to create the signed certificate.
       * @const
       * @type {string}
       */
      clientCertificate: 'clientCertificate',

      /**
       * Indicates a signed server certificate from the KMIP server.
       * @const
       * @type {string}
       */
      serverCertificate: 'serverCertificate'
   },

   /**
    * Enumeration used to define the different type of object that can be associated with a key value tag.
    * @enum {string}
    */
   KeyValueTagObjectReferenceType: {
      /**
       * The reference type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The reference corresponds to a Volume.
       * @const
       * @type {string}
       */
      volume: 'volume',

      /**
       * The reference corresponds to a Workload.
       * @const
       * @type {string}
       */
      workload: 'workload'
   },

   /**
    * This enumeration defines the different LUN mapping types that may be configured as part of the Storage Partitions feature.
    * @enum {string}
    */
   LUNMappingType: {
      /**
       * This value is reserved.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * This value indicates that a LUN mapping is based on the host port from which the I/O request is generated. Such mappings are not supported in the current version of the controller firmware.
       * @const
       * @type {string}
       */
      hostport: 'hostport',

      /**
       * This value indicates that a LUN mapping is based on the host from which the I/O request is generated.
       * @const
       * @type {string}
       */
      host: 'host',

      /**
       * This value indicates that a LUN mapping is based on the cluster from which the I/O request is generated.
       * @const
       * @type {string}
       */
      cluster: 'cluster',

      /**
       * This value indicates that a LUN mapping is based on the storage array port at which the I/O request is received by the array controller. Such mappings are not supported in the current version of the controller firmware.
       * @const
       * @type {string}
       */
      saport: 'saport',

      /**
       * This value indicates that a LUN mapping is based on the storage array port group at which the I/O request is received by the array controller. Such mappings are not supported in the current version of the controller firmware
       * @const
       * @type {string}
       */
      saportgroup: 'saportgroup',

      /**
       * This value indicates that a LUN mapping is based on the host-to-storage-array connection used to convey the I/O request to the array controller. Such mappings are not supported in the current version of the controller firmware.
       * @const
       * @type {string}
       */
      hostsaconnection: 'hostsaconnection',

      /**
       * This value indicates that a LUN mapping is part of the default mapping definition.
       * @const
       * @type {string}
       */
      all: 'all'
   },

   /**
    * This enumeration is used to identify the status of a network link.
    * @enum {string}
    */
   LinkStatus: {
      /**
       * Link status status does not apply for a certain I/O interface technology (e.g., Serial-Attached SCSI).
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The link is operational.
       * @const
       * @type {string}
       */
      up: 'up',

      /**
       * The link is not operational.
       * @const
       * @type {string}
       */
      down: 'down',

      /**
       * The link is failed.
       * @const
       * @type {string}
       */
      failed: 'failed'
   },

   /**
    * This enumeration identifies an auto load balance action being requested by the client.
    * @enum {string}
    */
   LoadBalanceAction: {
      /**
       * The action is unknown / invalid.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Request to reset load balance statistics baseline. This is used when the client believes load characteristics are dramatically changing such that the historical data is no longer valid.
       * @const
       * @type {string}
       */
      resetStatisticsBaseline: 'resetStatisticsBaseline',

      /**
       * Request to perform a load balance operation.
       * @const
       * @type {string}
       */
      rebalanceLoad: 'rebalanceLoad'
   },

   /**
    * This enumeration object is used to indicate the cause of lockdown in the event of a controller lockdown.
    * @enum {string}
    */
   LockdownCause: {
      /**
       * The cause of the lockdown is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The stable storage firmware revision is not compatible with the replacement controller(s).
       * @const
       * @type {string}
       */
      dacstoreMismatch: 'dacstoreMismatch',

      /**
       * The stable storage has a higher firmware revision than the replacement controller(s).
       * @const
       * @type {string}
       */
      dacstoreUprev: 'dacstoreUprev',

      /**
       * The stable storage backup database is in recovery mode and the primary database is corrupted.
       * @const
       * @type {string}
       */
      databaseRecovery: 'databaseRecovery',

      /**
       * The controller is locked down due to detecting enough missing drives that would otherwise result in failed volumes. This may be the result of an enclosure power loss or cable connection problem.
       * @const
       * @type {string}
       */
      missingDrives: 'missingDrives',

      /**
       * The controller is in backup cache image recovery mode.
       * @const
       * @type {string}
       */
      cacheRestoreRecovery: 'cacheRestoreRecovery',

      /**
       * The controller has detected an invalid memory configuration for the supported feature set.
       * @const
       * @type {string}
       */
      invalidMemoryConfig: 'invalidMemoryConfig',

      /**
       * The controller is operating in T10 PI lockdown error mode.
       * @const
       * @type {string}
       */
      t10PiLockdown: 't10PiLockdown',

      /**
       * The controller in slot A does not match the controller in slot B
       * @const
       * @type {string}
       */
      ctrlTypeMismatch: 'ctrlTypeMismatch',

      /**
       * The controller does not support the HIC that is present
       * @const
       * @type {string}
       */
      hicUnsupp: 'hicUnsupp',

      /**
       * The controller is locked down due to SAS discovery errors.
       * @const
       * @type {string}
       */
      sasPersistentDe: 'sasPersistentDe',

      /**
       * The controller is locked down due to processor memory mutli-bit ECC error
       * @const
       * @type {string}
       */
      procMultiEccErr: 'procMultiEccErr',

      /**
       * The controller is locked down due to processor memory single-bit ECC error
       * @const
       * @type {string}
       */
      procSingleEccErr: 'procSingleEccErr',

      /**
       * The controller is locked down due to cache memory multi-bit ECC error
       * @const
       * @type {string}
       */
      cacheMultiEccErr: 'cacheMultiEccErr',

      /**
       * The controller is locked down due to IOC diagnostic failure
       * @const
       * @type {string}
       */
      iocDiagFailed: 'iocDiagFailed',

      /**
       * The controller is locked down due to a general hardware error
       * @const
       * @type {string}
       */
      genHwErr: 'genHwErr',

      /**
       * The controller is locked down due to Soft PI error threshold being exceeded
       * @const
       * @type {string}
       */
      softPiThreshExceed: 'softPiThreshExceed',

      /**
       * The controller is locked down due to hard PI error threshold being exceeded
       * @const
       * @type {string}
       */
      hardPiThreshExceed: 'hardPiThreshExceed',

      /**
       * The controller is locked down due to an ACS failure
       * @const
       * @type {string}
       */
      acsFailure: 'acsFailure',

      /**
       * The controller is locked down due to an unsupported host card mix
       * @const
       * @type {string}
       */
      unsuppHostCardMix: 'unsuppHostCardMix',

      /**
       * The controller is locked down due to a SMID mismatch
       * @const
       * @type {string}
       */
      smidMismatch: 'smidMismatch',

      /**
       * The controller is locked down due to an invalid DIMM layout
       * @const
       * @type {string}
       */
      dimmLayoutInvalid: 'dimmLayoutInvalid',

      /**
       * The controller is locked down due to insufficient memory for backup device metadata
       * @const
       * @type {string}
       */
      insuffMemBackupDevMetadata: 'insuffMemBackupDevMetadata',

      /**
       * The controller is locked down due to a failure to create the backup volume
       * @const
       * @type {string}
       */
      cantCreateBackupVol: 'cantCreateBackupVol',

      /**
       * The controller is locked down for being unable to create the backup volume group
       * @const
       * @type {string}
       */
      cantCreateBackupVolGroup: 'cantCreateBackupVolGroup',

      /**
       * The controller is locked down due to mixed memory DIMMs
       * @const
       * @type {string}
       */
      mixedMemDimms: 'mixedMemDimms',

      /**
       * The controller is locked down due to having uncertified DIMM sizes
       * @const
       * @type {string}
       */
      uncertDimmSizes: 'uncertDimmSizes',

      /**
       * The controller is locked down due to having an invalid DIMM configuration (more memory than controller supports)
       * @const
       * @type {string}
       */
      invalidMemSize: 'invalidMemSize',

      /**
       * The controller is locked down due to a CFW mismatch after ACS
       * @const
       * @type {string}
       */
      cfwMismatchAfterAcs: 'cfwMismatchAfterAcs',

      /**
       * The controller is locked down due to simplex controller in the wrong enclosure slot
       * @const
       * @type {string}
       */
      simplexWrongSlot: 'simplexWrongSlot',

      /**
       * The controller is locked down for being unable to allocate memory for DDP metadata
       * @const
       * @type {string}
       */
      crushInvalidMemCfg: 'crushInvalidMemCfg',

      /**
       * The controller is locked down because of SBB validation failure (unable to read midplane VPD)
       * @const
       * @type {string}
       */
      eepromAccessErr: 'eepromAccessErr',

      /**
       * The controller is locked down due to an unexpected or invalid midplace VPD
       * @const
       * @type {string}
       */
      sbbFailValidation: 'sbbFailValidation',

      /**
       * The controller is locked down due to an unexpected enclosure VPD
       * @const
       * @type {string}
       */
      unexpectedEnclosureVpd: 'unexpectedEnclosureVpd',

      /**
       * The controller is locked down for being unable to read alt controller board ID
       * @const
       * @type {string}
       */
      cantReadAltCtlBoardId: 'cantReadAltCtlBoardId',

      /**
       * The controller is locked down for being unable to read alternate host board ID
       * @const
       * @type {string}
       */
      cantReadAltHostBoardId: 'cantReadAltHostBoardId',

      /**
       * The controller is locked down for an unsupported base enclosure for controller model
       * @const
       * @type {string}
       */
      unsuppEnclosure: 'unsuppEnclosure',

      /**
       * The controller is locked down for missing drive port table mappings
       * @const
       * @type {string}
       */
      drvportMapTablesMissing: 'drvportMapTablesMissing',

      /**
       * The controller is locked down for exceeding the controller reboot limit
       * @const
       * @type {string}
       */
      rebootLimitExceeded: 'rebootLimitExceeded',

      /**
       * The controller is locked down because a non-field-replaceable unit has been replaced
       * @const
       * @type {string}
       */
      nonFruComponentReplaced: 'nonFruComponentReplaced',

      /**
       * The controller is locked down because the alternate controller detected database inconsistency and has the latest backup image
       * @const
       * @type {string}
       */
      preserveAltBackupImage: 'preserveAltBackupImage',

      /**
       * THe controller is locked down because it cannot restore primary backup image but a valid mirror image exists
       * @const
       * @type {string}
       */
      dontPullCtrl: 'dontPullCtrl',

      /**
       * The controller is locked down because a container-based application configuration is being synced from the alt
       * @const
       * @type {string}
       */
      cbaCfgSyncAlt: 'cbaCfgSyncAlt',

      /**
       * The controller is locked down because a container-based application is being removed
       * @const
       * @type {string}
       */
      cbaCfgRemoved: 'cbaCfgRemoved',

      /**
       * The controller's BMC is unresponsive and failed all recovery attempts.
       * @const
       * @type {string}
       */
      bmcUnrecoverable: 'bmcUnrecoverable',

      /**
       * The controller is locked down because a removable ICC error was detected
       * @const
       * @type {string}
       */
      removableIccErr: 'removableIccErr',

      /**
       * The controller is locked down because a controller ID mismatch was detected
       * @const
       * @type {string}
       */
      ctrlBoardIdMismatch: 'ctrlBoardIdMismatch',

      /**
       * The controller is locked down because a cache mismatch was detected
       * @const
       * @type {string}
       */
      cacheMismatch: 'cacheMismatch',

      /**
       * The controller is locked down because a low power supply input voltage was detected
       * @const
       * @type {string}
       */
      lowPowerSupplyInputVoltage: 'lowPowerSupplyInputVoltage',

      /**
       * Locked down due to detecting a communication error with the SAS expander. For Dagger2 this may occur when attempting to retrieve information from the alternate controller for controller mismatch detection
       * @const
       * @type {string}
       */
      sasExpanderError: 'sasExpanderError',

      /**
       * The controller is locked down because the poolVersion in the CrushVolumeGroup is not supported in the current release.
       * @const
       * @type {string}
       */
      invalidPoolVersion: 'invalidPoolVersion'
   },

   /**
    * This enumeration type identifies the various types of objects that can be reported in the LockdownFaultLocator structure, which is itself used in getRecoveryFailureType procedure for reporting controller lockdown faults.
    * @enum {string}
    */
   LockdownFaultObjectType: {
      /**
       * The fault object type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The object is a controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The object is a host board.
       * @const
       * @type {string}
       */
      hostboard: 'hostboard',

      /**
       * The object is a controller cache DIMM.
       * @const
       * @type {string}
       */
      cacheDimm: 'cacheDimm',

      /**
       * The object is a controller tray.
       * @const
       * @type {string}
       */
      controllerTray: 'controllerTray'
   },

   /**
    * This enumeration identifies the different user groups defined for the management client record facility. Group IDs are a way of allowing multiple clients to use the management client record facility without having to worry about intermingling of their records. Essentially each group has its own data set. It is assumed that clients will be well-behaved and not masquerade as another group; there is no provision in SYMbol to explicitly prevent this, however. Engenio is the only organization that can assign new group IDs; any client wanting to use the management client record facility must obtain a group ID from Engenio.
    * @enum {string}
    */
   MCR_GROUP_ID: {
      /**
       * First user group.
       * @const
       * @type {string}
       */
      apollo: 'apollo',

      /**
       * Second user group.
       * @const
       * @type {string}
       */
      aggregation: 'aggregation',

      /**
       * Third user group.
       * @const
       * @type {string}
       */
      smis: 'smis',

      /**
       * For internal use only.
       * @const
       * @type {string}
       */
      groupIdInternal: 'groupIdInternal',

      /**
       * For App Aware.
       * @const
       * @type {string}
       */
      appAware: 'appAware',

      /**
       * Autosupport user group.
       * @const
       * @type {string}
       */
      asup: 'asup',

      /**
       * ASUP configuration key.
       * @const
       * @type {string}
       */
      asupConfiguration: 'asupConfiguration',

      /**
       * Global preference store key.
       * @const
       * @type {string}
       */
      prefStoreGlobal: 'prefStoreGlobal',

      /**
       * Array data preference store key.
       * @const
       * @type {string}
       */
      prefStoreArray: 'prefStoreArray',

      /**
       * Persistent monitor configuration key.
       * @const
       * @type {string}
       */
      persistentMonitor: 'persistentMonitor',

      /**
       * SSD wear level data key.
       * @const
       * @type {string}
       */
      ssdWearLevelData: 'ssdWearLevelData',

      /**
       * Special internal use only. Key used to house LDAP configuration.
       * @const
       * @type {string}
       */
      ldapConfiguration: 'ldapConfiguration'
   },

   /**
    * This enumeration object is used to specify different metadata volume types.
    * @enum {string}
    */
   MetadataVolType: {
      /**
       * This value is used to specify all metadata volume type.
       * @const
       * @type {string}
       */
      allMdatTypes: 'allMdatTypes',

      /**
       * This value is used to specify a remote volume mirror metadata volume type.
       * @const
       * @type {string}
       */
      remoteMirror: 'remoteMirror'
   },

   /**
    * This enumeration object is used to indicate the NetApp management applications that are allowed to manage a particular storage array.
    * @enum {string}
    */
   MgmtApplicationType: {
      /**
       * No Engenio management application is allowed to manage the array.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Only a SANtricity AMW is allowed to manage the array.
       * @const
       * @type {string}
       */
      santricity: 'santricity',

      /**
       * Only freestanding Simplicity is allowed to manage the array.
       * @const
       * @type {string}
       */
      simplicity: 'simplicity',

      /**
       * Either SANtricity-invoked Simplicity or freestanding Simplicity is allowed to manage the array.
       * @const
       * @type {string}
       */
      santricityOrSimplicity: 'santricityOrSimplicity',

      /**
       * SANtricity UMW is allowed to manage the array.
       * @const
       * @type {string}
       */
      umw: 'umw'
   },

   /**
    * This enumeration is used to determine the status of a minihub component.
    * @enum {string}
    */
   MinihubStatus: {
      /**
       * The minihub is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The minihub is not working or not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The minihub is not supported in this system.
       * @const
       * @type {string}
       */
      unsupported: 'unsupported',

      /**
       * The status of the minihub is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * This enumeration is used to identify the type of a minihub.
    * @enum {string}
    */
   MinihubType: {
      /**
       * The minihub is on a host side channel.
       * @const
       * @type {string}
       */
      hostside: 'hostside',

      /**
       * The minihub is on a drive side channel.
       * @const
       * @type {string}
       */
      driveside: 'driveside'
   },

   /**
    * This enumeration object is used to indicate the role of the Mirror Proxy Volume on the current array.
    * @enum {string}
    */
   MirrorProxyRole: {
      /**
       * The mirror volume on the current array is being mirrored to the remote volume.
       * @const
       * @type {string}
       */
      primary: 'primary',

      /**
       * The mirror volume on the current array is being mirrored from the remote volume.
       * @const
       * @type {string}
       */
      secondary: 'secondary',

      /**
       * The role of the remote mirror is unknown.
       * @const
       * @type {string}
       */
      invalid: 'invalid'
   },

   /**
    * This enumeration object is used to tell the current state of the mirror relationship.
    * @enum {string}
    */
   MirrorProxyStatus: {
      /**
       * The primary and secondary mirror volumes are synchronized.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The primary and secondary mirror volumes are unsynchronized.
       * @const
       * @type {string}
       */
      unsynchronized: 'unsynchronized',

      /**
       * The primary and secondary mirror volumes are in the process of synchronizing.
       * @const
       * @type {string}
       */
      synchronizing: 'synchronizing',

      /**
       * The primary mirror volume is in a not ready state.
       * @const
       * @type {string}
       */
      notready: 'notready',

      /**
       * The primary and secondary mirror volumes are suspended.
       * @const
       * @type {string}
       */
      suspended: 'suspended',

      /**
       * Primary and secondary mirror volumes are failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * Primary and secondary mirror volumes are failed and suspended.
       * @const
       * @type {string}
       */
      failedsuspended: 'failedsuspended',

      /**
       * Primary and secondary mirror volumes are degraded and synchronizing.
       * @const
       * @type {string}
       */
      degradedSynchronizing: 'degradedSynchronizing',

      /**
       * Primary and secondary mirror volumes are degraded and unsynchronized.
       * @const
       * @type {string}
       */
      degradedUnsynchronized: 'degradedUnsynchronized'
   },

   /**
    * Mirror Proxy Write Mode The write mode of the Mirror Proxy Volume on the current array.
    * @enum {string}
    */
   MirrorProxyWriteMode: {
      /**
       * Standard synchronous RVM write mode.
       * @const
       * @type {string}
       */
      synchronousMode: 'synchronousMode',

      /**
       * Asynchronous, write order not preserved.
       * @const
       * @type {string}
       */
      asynchronousMode: 'asynchronousMode',

      /**
       * Asynchronous, write order preserved.
       * @const
       * @type {string}
       */
      consistentAsyncMode: 'consistentAsyncMode'
   },

   /**
    * This enumeration object is used to set the background I/O activity for synchronizing the Secondary Volume from the Primary Volume. This value is on a per-volume basis and is independent of the remote mirror volume.
    * @enum {string}
    */
   MirrorSyncPriority: {
      /**
       * Low level of I/O activity to the Secondary volume during synchronization.
       * @const
       * @type {string}
       */
      priority0: 'priority0',

      /**
       * Increasing level of I/O activity as compared to Priority 0.
       * @const
       * @type {string}
       */
      priority1: 'priority1',

      /**
       * Increasing level of I/O activity as compared to Priority 1. Default setting for GUI.
       * @const
       * @type {string}
       */
      priority2: 'priority2',

      /**
       * Increasing level of I/O activity as compared to Priority 2.
       * @const
       * @type {string}
       */
      priority3: 'priority3',

      /**
       * High level of I/O activity to the Secondary volume during synchronization.
       * @const
       * @type {string}
       */
      priority4: 'priority4',

      /**
       * The synchronization priority of the remote mirror is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * This enumeration associates months of the year to bit masks.
    * @enum {string}
    */
   MonthOfYear: {
      /**
       * The month is not specified.
       * @const
       * @type {string}
       */
      notSpecified: 'notSpecified',

      /**
       * January
       * @const
       * @type {string}
       */
      january: 'january',

      /**
       * February
       * @const
       * @type {string}
       */
      february: 'february',

      /**
       * March
       * @const
       * @type {string}
       */
      march: 'march',

      /**
       * April
       * @const
       * @type {string}
       */
      april: 'april',

      /**
       * May
       * @const
       * @type {string}
       */
      may: 'may',

      /**
       * June
       * @const
       * @type {string}
       */
      june: 'june',

      /**
       * July
       * @const
       * @type {string}
       */
      july: 'july',

      /**
       * August
       * @const
       * @type {string}
       */
      august: 'august',

      /**
       * September
       * @const
       * @type {string}
       */
      september: 'september',

      /**
       * October
       * @const
       * @type {string}
       */
      october: 'october',

      /**
       * November
       * @const
       * @type {string}
       */
      november: 'november',

      /**
       * December
       * @const
       * @type {string}
       */
      december: 'december'
   },

   /**
    * This enumeration is used to identify the transport for NVMe traffic.
    * @enum {string}
    */
   NVMeTransportType: {
      /**
       * The Transport is unknown or undefined.
       * @const
       * @type {string}
       */
      undefined: 'undefined',

      /**
       * The NVMe transport is InfiniBand Remote Direct Memory Access.
       * @const
       * @type {string}
       */
      ibRdma: 'ibRdma'
   },

   /**
    * This enumeration is used to identify the provider (i.e. intermediate transport protocol) of the RDMA transport.
    * @enum {string}
    */
   NVMeoFRDMAProvider: {
      /**
       * The RDMA provider is unknown.
       * @const
       * @type {string}
       */
      providerUnknown: 'providerUnknown',

      /**
       * The RDMA provider is unspecified.
       * @const
       * @type {string}
       */
      providerUnspecified: 'providerUnspecified',

      /**
       * The RDMA provider is Infiniband.
       * @const
       * @type {string}
       */
      providerInfiniband: 'providerInfiniband',

      /**
       * The RDMA provider is ROCE (RDMA over Converged Ethernet) v1.
       * @const
       * @type {string}
       */
      providerRoce: 'providerRoce',

      /**
       * The RDMA provider is ROCE (RDMA over Converged Ethernet) v2.
       * @const
       * @type {string}
       */
      providerRocev2: 'providerRocev2',

      /**
       * The RDMA provider is iWARP.
       * @const
       * @type {string}
       */
      providerIwarp: 'providerIwarp',

      /**
       * There is no RDMA provider as Fibre Channel is the transport.
       * @const
       * @type {string}
       */
      noneFc: 'noneFc',

      /**
       * Provider added for Coupling Driver (CD). This is the interface between Linux OS devices and RAIDVols for the containerization project.
       * @const
       * @type {string}
       */
      providerCouplingDriver: 'providerCouplingDriver'
   },

   /**
    * This enumeration object is used to differentiate between various defined regions of a controller's NVSRAM.
    * @enum {string}
    */
   NVSRAMRegionId: {
      /**
       * Indicates that all regions are to be selected. This value is only used as part of a request to read NVSRAM via the getControllerNVSRAM procedure.
       * @const
       * @type {string}
       */
      allRegions: 'allRegions',

      /**
       * This value is used to specify the region of controller NVSRAM that is not user-configurable.
       * @const
       * @type {string}
       */
      nonUserConfigData: 'nonUserConfigData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds subsystem identification information.
       * @const
       * @type {string}
       */
      subsystemId: 'subsystemId',

      /**
       * This value is used to specify the region of controller NVSRAM that holds subsystem fault information.
       * @const
       * @type {string}
       */
      subsystemFaultData: 'subsystemFaultData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds drive fault information.
       * @const
       * @type {string}
       */
      driveFaultData: 'driveFaultData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds host-managed information.
       * @const
       * @type {string}
       */
      hostManagedData: 'hostManagedData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds host I/O interface information.
       * @const
       * @type {string}
       */
      hostInterfaceData: 'hostInterfaceData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds user-configurable information.
       * @const
       * @type {string}
       */
      userConfigData: 'userConfigData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds BOOTP information.
       * @const
       * @type {string}
       */
      bootpData: 'bootpData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds the extended user-configurable information.
       * @const
       * @type {string}
       */
      extUserConfigData: 'extUserConfigData',

      /**
       * This value is used to specify the region of controller NVSRAM that holds the host type dependent region.
       * @const
       * @type {string}
       */
      hostTypeDependentData: 'hostTypeDependentData',

      /**
       * This value is used to specify the second region of controller NVSRAM that holds user-configurable data.
       * @const
       * @type {string}
       */
      userConfig2Data: 'userConfig2Data'
   },

   /**
    * This enumeration defines the different network interface types that may be reported as part of the interface information associated with a controller.
    * @enum {string}
    */
   NetInterfaceType: {
      /**
       * The interface type is Ethernet.
       * @const
       * @type {string}
       */
      ethernet: 'ethernet'
   },

   /**
    * This enum defines the possible network address types.
    * @enum {string}
    */
   NetworkAddressType: {
      /**
       * Unknown - delete existing IP address or domain name.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Fully qualified domain name ex: 0.pool.ntp.org
       * @const
       * @type {string}
       */
      domainName: 'domainName',

      /**
       * IPv4 or IPv6 address
       * @const
       * @type {string}
       */
      ipvx: 'ipvx'
   },

   /**
    * How the NTP server addresses are acquired.
    * @enum {string}
    */
   NtpAcquisitionMethod: {
      /**
       * NTP service is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Using provided domain name, IPv4, or IPv6 addresses.
       * @const
       * @type {string}
       */
      stat: 'stat',

      /**
       * NTP Servers will be obtained via DHCP
       * @const
       * @type {string}
       */
      dhcp: 'dhcp',

      /**
       * NTP service is disabled.
       * @const
       * @type {string}
       */
      disabled: 'disabled'
   },

   /**
    * This enumeration identifies the different types of object references.
    * @enum {string}
    */
   ObjectReferenceType: {
      /**
       * The object reference is a generic SYMbol reference.
       * @const
       * @type {string}
       */
      generic: 'generic',

      /**
       * The object reference is a controller reference.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The reference is a a generic reference that includes type information.
       * @const
       * @type {string}
       */
      genericTyped: 'genericTyped'
   },

   /**
    * This enumeration is used to indicate whether a parameter is present or absent.
    * @enum {string}
    */
   OptionalParameter: {
      /**
       * The parameter is absent.
       * @const
       * @type {string}
       */
      absent: 'absent',

      /**
       * The parameter is present.
       * @const
       * @type {string}
       */
      present: 'present'
   },

   /**
    * This enumeration is used to specify the method by which the PiT was created.
    * @enum {string}
    */
   PITCreationMethod: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The PiT was created by user action.
       * @const
       * @type {string}
       */
      user: 'user',

      /**
       * The PiT was created by scheduled PiT creation, either on an individual PiT group or on a PITConsistencyGroup.
       * @const
       * @type {string}
       */
      schedule: 'schedule'
   },

   /**
    * This enumeration is used to determine the status of a Pending PiT Creation.
    * @enum {string}
    */
   PITCreationPendingStatus: {
      /**
       * Status unknown. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * No PiT creation is pending.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * A PiT creation is pending.
       * @const
       * @type {string}
       */
      waiting: 'waiting',

      /**
       * The last pending PiT creation failed.
       * @const
       * @type {string}
       */
      failed: 'failed'
   },

   /**
    * This enumeration is used to determine the status of a PiT Group.
    * @enum {string}
    */
   PITGroupStatus: {
      /**
       * The PiT Group status is unknown. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The PiT Group is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The PiT Group repository is full and the "fail base writes policy" is set
       * @const
       * @type {string}
       */
      full: 'full',

      /**
       * The PiT Group has failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The repository is over the warning threshold.
       * @const
       * @type {string}
       */
      overThreshold: 'overThreshold'
   },

   /**
    * This enumeration is used to specify the policy to apply when a PiT repository is full and cluster allocation fails.
    * @enum {string}
    */
   PITRepositoryFullPolicy: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Fail writes to the base on cluster allocation fail.
       * @const
       * @type {string}
       */
      failbasewrites: 'failbasewrites',

      /**
       * Purge PiT(s) to free space.
       * @const
       * @type {string}
       */
      purgepit: 'purgepit'
   },

   /**
    * This enumeration is used to identify the status of a PiT Group rollback.
    * @enum {string}
    */
   PITRollbackStatus: {
      /**
       * The rollback status is unknown. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * No rollback is taking place.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The rollback is actively copying data.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * The rollback is waiting on resources to start background copy.
       * @const
       * @type {string}
       */
      pending: 'pending',

      /**
       * Active data copy paused due to error
       * @const
       * @type {string}
       */
      paused: 'paused'
   },

   /**
    * This enumeration is used to specify the status of a PiT.
    * @enum {string}
    */
   PITStatus: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The PiT state is valid/active.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The PiT has failed (repository failed).
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The PiT has been purged by PITRepositoryFullPolicy to free space.
       * @const
       * @type {string}
       */
      purged: 'purged'
   },

   /**
    * This enumeration is used to describe the allowed access mode(s) for a PiT View.
    * @enum {string}
    */
   PITViewAccessMode: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      modeUnknown: 'modeUnknown',

      /**
       * The View access mode is read/write.
       * @const
       * @type {string}
       */
      readWrite: 'readWrite',

      /**
       * The View access mode is read only.
       * @const
       * @type {string}
       */
      readOnly: 'readOnly'
   },

   /**
    * This enumeration is used to specify the status of a PiT View.
    * @enum {string}
    */
   PITViewStatus: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The PiT View state is valid/active.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The PiT View is user-stopped (no copy-on-write (CoW), no IO access).
       * @const
       * @type {string}
       */
      stopped: 'stopped',

      /**
       * The PiT View has failed (repository failed).
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The PiT View Repository utilization is over the warning threshold.
       * @const
       * @type {string}
       */
      overThreshold: 'overThreshold',

      /**
       * The PiT View Repository is full.
       * @const
       * @type {string}
       */
      full: 'full'
   },

   /**
    * This enumeration identifies the possible types for a PITView.
    * @enum {string}
    */
   PITViewType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The PiT View is an individual type.
       * @const
       * @type {string}
       */
      individual: 'individual',

      /**
       * The PiT View is a member type.
       * @const
       * @type {string}
       */
      member: 'member'
   },

   /**
    * This enumeration object is used to specify the type of reference that is contained in a ParentCru union.
    * @enum {string}
    */
   ParentCruType: {
      /**
       * The ParentCru is a reference to a Controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The ParentCru is a reference to an Esm.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The ParentCru is a reference to a Fan.
       * @const
       * @type {string}
       */
      fan: 'fan',

      /**
       * The ParentCru is a reference to a InterconnectCRU.
       * @const
       * @type {string}
       */
      iccCru: 'iccCru',

      /**
       * The ParentCru is a reference to a SupportCRU.
       * @const
       * @type {string}
       */
      supportCru: 'supportCru',

      /**
       * The ParentCru is a reference to a drawer.
       * @const
       * @type {string}
       */
      drawer: 'drawer'
   },

   /**
    * This enumeration object is a member of the ParityScanResponse object. It is used to communicate the results of a volume scan. This value is only significant when the returnCode is set to RETCODE_OK.
    * @enum {string}
    */
   ParityStatus: {
      /**
       * Scan completed successfully
       * @const
       * @type {string}
       */
      ok: 'ok',

      /**
       * Scan timeout occurred
       * @const
       * @type {string}
       */
      timeout: 'timeout',

      /**
       * The volume scan detected a parity mismatch at the LBA identified in the endingLBA object.
       * @const
       * @type {string}
       */
      parityError: 'parityError',

      /**
       * Media Error Detected
       * @const
       * @type {string}
       */
      mediaError: 'mediaError',

      /**
       * EDC Error Detected
       * @const
       * @type {string}
       */
      edcError: 'edcError',

      /**
       * A single parity mismatch has been detected at LBA {0}
       * @const
       * @type {string}
       */
      raid6QError: 'raid6QError',

      /**
       * A dual parity error has been detected at LBA {0}
       * @const
       * @type {string}
       */
      raid6PqError: 'raid6PqError',

      /**
       * Parity status is ok following retry
       * @const
       * @type {string}
       */
      okFollowingRetry: 'okFollowingRetry',

      /**
       * This error is returned when there is a successful isolation and correction of a parity mismatch.
       * @const
       * @type {string}
       */
      okFollowingRaid6Correction: 'okFollowingRaid6Correction',

      /**
       * This error is returned when there is an unsuccessful isolation of a parity mismatch.
       * @const
       * @type {string}
       */
      raid6DataError: 'raid6DataError'
   },

   /**
    * This enumeration indicates what the match is based on for a pending host that matches a configured host.
    * @enum {string}
    */
   PendingHostMatchType: {
      /**
       * The match is based on matching names only. This matching criteria is applied after the ports match criteria.
       * @const
       * @type {string}
       */
      nameOnly: 'nameOnly',

      /**
       * The match is based on matching ports only. A match on ports happens when all of the configured ports for a pending host are found under exactly one configured host. Any unconfigured ports for a pending host are not considered in the test for a match. This matching criteria takes precedence over the PENDING_HOST_MATCH_NAME_ONLY criteria.
       * @const
       * @type {string}
       */
      portsOnly: 'portsOnly',

      /**
       * The match is based on both matching names and matching ports.
       * @const
       * @type {string}
       */
      nameAndPorts: 'nameAndPorts'
   },

   /**
    * This enumeration identifies the Performance Ring Buffer Types.
    * @enum {string}
    */
   PerformanceRingType: {
      /**
       * The performance ring type is a controller level summary.
       * @const
       * @type {string}
       */
      summary: 'summary',

      /**
       * The performance ring type is a channel related performance.
       * @const
       * @type {string}
       */
      channel: 'channel',

      /**
       * The performance ring type is controller latency on a per channel basis.
       * @const
       * @type {string}
       */
      latency: 'latency',

      /**
       * The performance ring type is currently not supported.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * The performance ring type is controller all, which returns all of the gathered information.
       * @const
       * @type {string}
       */
      all: 'all'
   },

   /**
    * This enumeration object is used to describe the physical interface of the drive. This is not necessarily the same as the I/O protocol interface used by the controller to communicate with the drive (DriveType). In addition, the supportedDriveTypes array in the FeatureParams structure will contain values from this enumeration identifying which drive types are supported on the storage array.
    * @enum {string}
    */
   PhysicalDriveType: {
      /**
       * All drive types, for volume candidates.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * SCSI drive type.
       * @const
       * @type {string}
       */
      scsi: 'scsi',

      /**
       * Fibre Channel drive type.
       * @const
       * @type {string}
       */
      fibre: 'fibre',

      /**
       * Serial ATA drive type.
       * @const
       * @type {string}
       */
      sata: 'sata',

      /**
       * Parallel ATA drive type.
       * @const
       * @type {string}
       */
      pata: 'pata',

      /**
       * Fibre Channel drive type with 520-byte sectors for data availability protection
       * @const
       * @type {string}
       */
      fibre520b: 'fibre520b',

      /**
       * Serial-attached SCSI drive type.
       * @const
       * @type {string}
       */
      sas: 'sas',

      /**
       * The physical drive type is unknown (e.g., as in the case where the drive is dual-bypassed).
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The physical drive type is a serial-attached SCSI drive where the drive has a logical sector size of 4KB.
       * @const
       * @type {string}
       */
      sas4k: 'sas4k',

      /**
       * The physical drive type is an NVMe drive with a logical block size of 4KB
       * @const
       * @type {string}
       */
      nvme4k: 'nvme4k'
   },

   /**
    * This enumeration object is used to indicate the physical type of an I/O interface, in contrast to the logical protocol used by the interface (iSCSI is a logical protocol; Ethernet is a physical interface).
    * @enum {string}
    */
   PhysicalInterfaceType: {
      /**
       * The type of the physical interface is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The type of the physical interface is Ethernet.
       * @const
       * @type {string}
       */
      ethernet: 'ethernet',

      /**
       * The type of the physical interface is Infiniband.
       * @const
       * @type {string}
       */
      infiniband: 'infiniband'
   },

   /**
    * This enumeration defines the status of the fibre channel port.
    * @enum {string}
    */
   PortStatus: {
      /**
       * The fibre channel port is currently bypassed.
       * @const
       * @type {string}
       */
      bypassed: 'bypassed',

      /**
       * The fibre channel port is currently not bypassed.
       * @const
       * @type {string}
       */
      notBypassed: 'notBypassed'
   },

   /**
    * These types indicate the mapping action when assigning target port to LUN mappings to controller(s).
    * @enum {string}
    */
   PortToLunMappingAction: {
      /**
       * Unknown action.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Assign all mappings to a controller.
       * @const
       * @type {string}
       */
      assignAll: 'assignAll',

      /**
       * Redistribute mappings to both controllers.
       * @const
       * @type {string}
       */
      redistribute: 'redistribute'
   },

   /**
    * This enumeration defines the different types of fibre channel ports.
    * @enum {string}
    */
   PortType: {
      /**
       * The fibre channel port is of the GBIC type.
       * @const
       * @type {string}
       */
      gbic: 'gbic',

      /**
       * The fibre channel port is of the DB9 type.
       * @const
       * @type {string}
       */
      db9: 'db9',

      /**
       * The fibre channel port is of the SFP type.
       * @const
       * @type {string}
       */
      sfp: 'sfp'
   },

   /**
    * This enumeration is used to specify whether the actions will be taken on ports residing on a host interface card or a base board.
    * @enum {string}
    */
   PortsRefType: {
      /**
       * portsRefType not specified
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Action taken on host interface card ports
       * @const
       * @type {string}
       */
      hic: 'hic',

      /**
       * Action taken on base board ports
       * @const
       * @type {string}
       */
      baseBoard: 'baseBoard'
   },

   /**
    * This enumeration is used to determine the status of a power supply component.
    * @enum {string}
    */
   PowerSupplyStatus: {
      /**
       * The power supply is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The power supply is not working or not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The power supply has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the power supply is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The power supply has no input voltage.
       * @const
       * @type {string}
       */
      noinput: 'noinput'
   },

   /**
    * This enumeration identifies the possible status values for a power supply firmware update.
    * @enum {string}
    */
   PowerSupplyUpdateStatus: {
      /**
       * The power supply update completed successfully.
       * @const
       * @type {string}
       */
      complete: 'complete',

      /**
       * The power supply update was bypassed because it's FW revision was the same as the updated FW.
       * @const
       * @type {string}
       */
      byPassed: 'byPassed',

      /**
       * The power supply update is pending.
       * @const
       * @type {string}
       */
      pending: 'pending',

      /**
       * The power supply update is in progress.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * The power supply update failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The firmware update for this power supply has been aborted because the firmware update for another power supply failed.
       * @const
       * @type {string}
       */
      aborted: 'aborted'
   },

   /**
    * This enumeration object is used to represent the product capabilities supported by the RAID controller firmware.
    * @enum {string}
    */
   ProductCapability: {
      /**
       * The array has no capabilities.
       * @const
       * @type {string}
       */
      capabilityNone: 'capabilityNone',

      /**
       * Cache backup is supported.
       * @const
       * @type {string}
       */
      capabilityCacheBackup: 'capabilityCacheBackup',

      /**
       * Core iSCSI is supported.
       * @const
       * @type {string}
       */
      capabilityCoreIscsi: 'capabilityCoreIscsi',

      /**
       * DAP 520B is supported.
       * @const
       * @type {string}
       */
      capabilityDap520b: 'capabilityDap520b',

      /**
       * Dual-ported SATA is supported.
       * @const
       * @type {string}
       */
      capabilityDualPortedSata: 'capabilityDualPortedSata',

      /**
       * FDE is supported.
       * @const
       * @type {string}
       */
      capabilityFdeDriveSupport: 'capabilityFdeDriveSupport',

      /**
       * Field replaceable cache memory is supported
       * @const
       * @type {string}
       */
      capabilityFieldRepCacheMem: 'capabilityFieldRepCacheMem',

      /**
       * Gb Ethernet management port is supported.
       * @const
       * @type {string}
       */
      capabilityGbEthMgmtPort: 'capabilityGbEthMgmtPort',

      /**
       * Infiniband is supported.
       * @const
       * @type {string}
       */
      capabilityInfinibandSupport: 'capabilityInfinibandSupport',

      /**
       * IPV6 management port is supported.
       * @const
       * @type {string}
       */
      capabilityIpv6MgmtPortIpv6: 'capabilityIpv6MgmtPortIpv6',

      /**
       * iSCSI IPV6 is supported.
       * @const
       * @type {string}
       */
      capabilityIscsiIpv6: 'capabilityIscsiIpv6',

      /**
       * SAS is supported.
       * @const
       * @type {string}
       */
      capabilitySasSupport: 'capabilitySasSupport',

      /**
       * Simplex controller.
       * @const
       * @type {string}
       */
      capabilitySimplex: 'capabilitySimplex',

      /**
       * Smart battery management is supported.
       * @const
       * @type {string}
       */
      capabilitySmartBatteryMgmt: 'capabilitySmartBatteryMgmt',

      /**
       * Caliber 6141 is supported.
       * @const
       * @type {string}
       */
      capabilityCal6141: 'capabilityCal6141',

      /**
       * Caliber 6334 is supported.
       * @const
       * @type {string}
       */
      capabilityCal6334: 'capabilityCal6334',

      /**
       * Configure database adoption is supported.
       * @const
       * @type {string}
       */
      capabilityCfgDbAdoption: 'capabilityCfgDbAdoption',

      /**
       * Controller lockdown is supported.
       * @const
       * @type {string}
       */
      capabilityCtrlLockdown: 'capabilityCtrlLockdown',

      /**
       * Controller state capture is supported.
       * @const
       * @type {string}
       */
      capabilityCtrlStateCapture: 'capabilityCtrlStateCapture',

      /**
       * Diagnostic data capture is supported.
       * @const
       * @type {string}
       */
      capabilityDiagDataCapture: 'capabilityDiagDataCapture',

      /**
       * Drive data relocation is supported.
       * @const
       * @type {string}
       */
      capabilityDriveDataRelocation: 'capabilityDriveDataRelocation',

      /**
       * Drive enclosure miswires is supported.
       * @const
       * @type {string}
       */
      capabilityDriveEnclosureMiswires: 'capabilityDriveEnclosureMiswires',

      /**
       * Drive management is supported.
       * @const
       * @type {string}
       */
      capabilityDriveMgmt: 'capabilityDriveMgmt',

      /**
       * Mixed drives within a tray are supported.
       * @const
       * @type {string}
       */
      capabilityDriveMixWithinTray: 'capabilityDriveMixWithinTray',

      /**
       * Drive channel diagnostics are supported.
       * @const
       * @type {string}
       */
      capabilityDrvChannelDiags: 'capabilityDrvChannelDiags',

      /**
       * Feature bundles are supported.
       * @const
       * @type {string}
       */
      capabilityFeatureBundles: 'capabilityFeatureBundles',

      /**
       * Host context agent is supported.
       * @const
       * @type {string}
       */
      capabilityHostContextAgent: 'capabilityHostContextAgent',

      /**
       * Immediate host topology is supported.
       * @const
       * @type {string}
       */
      capabilityImmediateHostTopology: 'capabilityImmediateHostTopology',

      /**
       * Online drive firmware download is supported.
       * @const
       * @type {string}
       */
      capabilityOnlineDrvFwDwnld: 'capabilityOnlineDrvFwDwnld',

      /**
       * Parent relative location is supported.
       * @const
       * @type {string}
       */
      capabilityParentRelativeLocation: 'capabilityParentRelativeLocation',

      /**
       * Parent relative status is supported.
       * @const
       * @type {string}
       */
      capabilityParentRelativeStatus: 'capabilityParentRelativeStatus',

      /**
       * Pompano is supported.
       * @const
       * @type {string}
       */
      capabilityPompanoSupport: 'capabilityPompanoSupport',

      /**
       * RAID 6 is supported.
       * @const
       * @type {string}
       */
      capabilityRaid6: 'capabilityRaid6',

      /**
       * SOC statistics are supported.
       * @const
       * @type {string}
       */
      capabilitySocStatistics: 'capabilitySocStatistics',

      /**
       * Virtualization is supported.
       * @const
       * @type {string}
       */
      capabilitySupportsVirtualization: 'capabilitySupportsVirtualization',

      /**
       * T10 Protection Information is supported.
       * @const
       * @type {string}
       */
      capabilityT10: 'capabilityT10',

      /**
       * Infusion is supported.
       * @const
       * @type {string}
       */
      capabilityInfusion: 'capabilityInfusion',

      /**
       * Drive limit management is supported.
       * @const
       * @type {string}
       */
      capabilityDriveLimitManagement: 'capabilityDriveLimitManagement',

      /**
       * SFP Plus is supported.
       * @const
       * @type {string}
       */
      capabilitySfpPlus: 'capabilitySfpPlus',

      /**
       * iSCSI 10 Gb host card is supported.
       * @const
       * @type {string}
       */
      capabilityIscsi10gbHostCard: 'capabilityIscsi10gbHostCard',

      /**
       * Enhanced LUN 0 is supported.
       * @const
       * @type {string}
       */
      capabilityEnhancedLun0Support: 'capabilityEnhancedLun0Support',

      /**
       * Enhanced format unit is supported.
       * @const
       * @type {string}
       */
      capabilityEnhancedFormatUnitSupport: 'capabilityEnhancedFormatUnitSupport',

      /**
       * Drive side trunking is supported.
       * @const
       * @type {string}
       */
      capabilityDriveSideTrunkSupport: 'capabilityDriveSideTrunkSupport',

      /**
       * Solid state disks are supported.
       * @const
       * @type {string}
       */
      capabilitySsdSupport: 'capabilitySsdSupport',

      /**
       * The base controller diagnostics feature is supported.
       * @const
       * @type {string}
       */
      capabilityBaseControllerDiags: 'capabilityBaseControllerDiags',

      /**
       * The cache memory diagnostics feature is supported.
       * @const
       * @type {string}
       */
      capabilityCacheMemoryDiags: 'capabilityCacheMemoryDiags',

      /**
       * The drive slot limit feature is supported.
       * @const
       * @type {string}
       */
      capabilityDriveSlotLimit: 'capabilityDriveSlotLimit',

      /**
       * The FDE proxy key management feature is supported.
       * @const
       * @type {string}
       */
      capabilityFdeProxyKeyMgmt: 'capabilityFdeProxyKeyMgmt',

      /**
       * The iOS feature is supported.
       * @const
       * @type {string}
       */
      capabilityIosSupport: 'capabilityIosSupport',

      /**
       * The Lockout 2TB Drives feature is supported.
       * @const
       * @type {string}
       */
      capabilityLockout2tbDrives: 'capabilityLockout2tbDrives',

      /**
       * The parent relative MEL component location reporting feature is supported.
       * @const
       * @type {string}
       */
      capabilityParentRelativeMel: 'capabilityParentRelativeMel',

      /**
       * The RAID 6 pre-read redundancy check feature is supported.
       * @const
       * @type {string}
       */
      capabilityRaid6PrereadRedCheck: 'capabilityRaid6PrereadRedCheck',

      /**
       * The SATA drive lockout feature is supported.
       * @const
       * @type {string}
       */
      capabilitySataDriveLockout: 'capabilitySataDriveLockout',

      /**
       * The Sys Log Messages feature is supported.
       * @const
       * @type {string}
       */
      capabilitySyslogMsgs: 'capabilitySyslogMsgs',

      /**
       * The Wembley enclosure is supported.
       * @const
       * @type {string}
       */
      capabilityWembleyEnclosure: 'capabilityWembleyEnclosure',

      /**
       * The Cache Backup Device Diagnostics feature is supported.
       * @const
       * @type {string}
       */
      capabilityCacheBackupDeviceDiags: 'capabilityCacheBackupDeviceDiags',

      /**
       * The HIC Diagnostics feature is supported.
       * @const
       * @type {string}
       */
      capabilityHicDiags: 'capabilityHicDiags',

      /**
       * The enclosure is a Camden/Ebbets or a Mercury Devil enclosure.
       * @const
       * @type {string}
       */
      capabilitySetTrayAttributes: 'capabilitySetTrayAttributes',

      /**
       * The array supports iSCSI Target Mode.
       * @const
       * @type {string}
       */
      capabilityIscsiTarget: 'capabilityIscsiTarget',

      /**
       * The array supports iSCSI MultiMirror.
       * @const
       * @type {string}
       */
      capabilityIscsiInitiator: 'capabilityIscsiInitiator',

      /**
       * The Power Supply Firmware Update capability is supported.
       * @const
       * @type {string}
       */
      capabilityPsuFirmwareUpdate: 'capabilityPsuFirmwareUpdate',

      /**
       * DPL Core Dump capability is supported.
       * @const
       * @type {string}
       */
      capabilityDplCoreDump: 'capabilityDplCoreDump',

      /**
       * Disk Pools are supported.
       * @const
       * @type {string}
       */
      capabilityDiskPools: 'capabilityDiskPools',

      /**
       * The Autosupport feature is supported.
       * @const
       * @type {string}
       */
      capabilityAsupSupport: 'capabilityAsupSupport',

      /**
       * The Embedded SNMP Agent is supported.
       * @const
       * @type {string}
       */
      capabilityEmbeddedSnmpAgent: 'capabilityEmbeddedSnmpAgent',

      /**
       * The FTDC trace history feature is supported.
       * @const
       * @type {string}
       */
      capabilityFtdcTraceHistory: 'capabilityFtdcTraceHistory',

      /**
       * Generic advanced format drive support is provided including support for 512e drives.
       * @const
       * @type {string}
       */
      capabilityAdvancedFormatSupport: 'capabilityAdvancedFormatSupport',

      /**
       * Support for 4Kn drives is provided in addition to generic support.
       * @const
       * @type {string}
       */
      capability4knativeAdvancedFormatSupport: 'capability4knativeAdvancedFormatSupport',

      /**
       * The Autosupport On Demand feature is supported.
       * @const
       * @type {string}
       */
      capabilityAsupOnDemandSupport: 'capabilityAsupOnDemandSupport',

      /**
       * IOC Dump capability is supported.
       * @const
       * @type {string}
       */
      capabilityIocDump: 'capabilityIocDump',

      /**
       * The drive power cycle feature is supported.
       * @const
       * @type {string}
       */
      capabilityDrivePowerCycle: 'capabilityDrivePowerCycle',

      /**
       * The low and high resolution statistical sampling is supported.
       * @const
       * @type {string}
       */
      capabilityLowAndHighSampling: 'capabilityLowAndHighSampling',

      /**
       * This array supports the auto load balancing capability.
       * @const
       * @type {string}
       */
      capabilityAutoLoadBalancing: 'capabilityAutoLoadBalancing',

      /**
       * This enumeration value is present if the array supports the WLC Improvements feature.
       * @const
       * @type {string}
       */
      capabilityWlcLogging: 'capabilityWlcLogging',

      /**
       * This product capability is in the Product Capabilities list if the CFW supports FIPS drives
       * @const
       * @type {string}
       */
      capabilityFipsDriveSupport: 'capabilityFipsDriveSupport',

      /**
       * When set, this indicates the CFW supports persisting application awareness data.
       * @const
       * @type {string}
       */
      capabilityApplicationAwareness: 'capabilityApplicationAwareness',

      /**
       * This array supports the embedded external key management feature.
       * @const
       * @type {string}
       */
      capabilityEmbeddedEkms: 'capabilityEmbeddedEkms',

      /**
       * Checking protection information during cache mirroring is supported.
       * @const
       * @type {string}
       */
      capabilityCacheMirroringProtectionInformation: 'capabilityCacheMirroringProtectionInformation',

      /**
       * Integrated Health Check is supported
       * @const
       * @type {string}
       */
      capabilityIntegratedHealthCheck: 'capabilityIntegratedHealthCheck',

      /**
       * The array supports digital signatures for firmware and NVSRAM.
       * @const
       * @type {string}
       */
      capabilitySignedFirmware: 'capabilitySignedFirmware',

      /**
       * The array supports container based applications.
       * @const
       * @type {string}
       */
      capabilityContainerBasedApplication: 'capabilityContainerBasedApplication',

      /**
       * This product capability is in the Product Capabilities list if the CFW supports fast initialization of volumes.
       * @const
       * @type {string}
       */
      capabilityFastInitialization: 'capabilityFastInitialization',

      /**
       * The Embedded SNMPv3 Agent is supported.
       * @const
       * @type {string}
       */
      capabilityEmbeddedSnmpv3Agent: 'capabilityEmbeddedSnmpv3Agent',

      /**
       * Designates an array that contains only QLC SSD drives.
       * @const
       * @type {string}
       */
      capabilityQlcArray: 'capabilityQlcArray'
   },

   /**
    * This enumeration is used when identifying a Protection Information type. In addition, the supportedProtectionTypes array in the FeatureParams structure will contain values from this enumeration identifying which Protection Types are supported on the storage array.
    * @enum {string}
    */
   ProtectionType: {
      /**
       * The volume does not support protection information (the PROTECT bit is set to zero in the standard INQUIRY data) or the volume has been formatted with protection information disabled.
       * @const
       * @type {string}
       */
      type0Protection: 'type0Protection',

      /**
       * The LOGICAL BLOCK GUARD contains a valid CRC. The LOGICAL BLOCK APPLICATION TAG is defined by the owner of the tag as determined by the ATO bit in the Control Mode page. The LOGICAL BLOCK REFERENCE TAG contains the least significant four bytes of the associated LOGICAL BLOCK ADDRESS (LBA).
       * @const
       * @type {string}
       */
      type1Protection: 'type1Protection',

      /**
       * The LOGICAL BLOCK GUARD contains a valid CRC. The LOGICAL BLOCK APPLICATION TAG is defined by the owner of the tag as determined by the ATO bit in the Control Mode page. If the Application Tag is owned by the application client, the expected value may be specified in the Command Description Block (CDB). The LOGICAL BLOCK REFERENCE TAG in the first block of the I/O operation contains a value specified in the CDB. For each subsequent block, the Reference Tag for each block within the I/O operation is equal to the Reference Tag of the previous block plus one.
       * @const
       * @type {string}
       */
      type2Protection: 'type2Protection',

      /**
       * The LOGICAL BLOCK GUARD contains a valid CRC. The LOGICAL BLOCK APPLICATION TAG is defined by the owner of the tag as determined by the ATO bit in the Control Mode page. The LOGICAL BLOCK REFERENCE TAG is present but not defined.
       * @const
       * @type {string}
       */
      type3Protection: 'type3Protection'
   },

   /**
    * This enumeration object is used to specify a supported RAID level. It is used for reported volume attributes, volume creation options, and in many other areas as well.
    * @enum {string}
    */
   RAIDLevel: {
      /**
       * This value indicates that the volume or volume group has a RAID level that is not supported by the array.
       * @const
       * @type {string}
       */
      raidUnsupported: 'raidUnsupported',

      /**
       * This constant is used to specify "all RAID levels" in situations where a RAIDLevel object is used to pass information from the management application to the controller. It is generally not used when reporting the RAID level associated with a particular object, though.
       * @const
       * @type {string}
       */
      raidAll: 'raidAll',

      /**
       * RAID level 0, or data striping with no parity protection.
       * @const
       * @type {string}
       */
      raid0: 'raid0',

      /**
       * RAID level 1, or data mirroring.
       * @const
       * @type {string}
       */
      raid1: 'raid1',

      /**
       * RAID level 3.
       * @const
       * @type {string}
       */
      raid3: 'raid3',

      /**
       * RAID level 5.
       * @const
       * @type {string}
       */
      raid5: 'raid5',

      /**
       * Raid level 6.
       * @const
       * @type {string}
       */
      raid6: 'raid6',

      /**
       * The RAID level is disk pool.
       * @const
       * @type {string}
       */
      raidDiskPool: 'raidDiskPool',

      /**
       * RAID level 1P, Three-way mirror
       * @const
       * @type {string}
       */
      raid1p: 'raid1p'
   },

   /**
    * This enumeration defines the commands for Read Link Status.
    * @enum {string}
    */
   RLSCommand: {
      /**
       * This command is used to get the error counts on a per-port basis for a fibre-channel drive side.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * This command is used to get the error counts on a per-port basis for a given back-end channel.
       * @const
       * @type {string}
       */
      channels: 'channels',

      /**
       * This command is used to get the error counts on a per-port basis for a given back-end device.
       * @const
       * @type {string}
       */
      devices: 'devices'
   },

   /**
    * This enumeration object is used to specify the type of RLS device.
    * @enum {string}
    */
   RLSDeviceType: {
      /**
       * Controller type.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * Drive type.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * ESM type.
       * @const
       * @type {string}
       */
      esm: 'esm'
   },

   /**
    * This enumeration is used to control the Ready to Remove indicators (LEDs).
    * @enum {string}
    */
   RTRControl: {
      /**
       * Turn on the component's Ready to Remove indicator, if no dependency exists.
       * @const
       * @type {string}
       */
      enable: 'enable',

      /**
       * Turn off the component's Ready to Remove indicator.
       * @const
       * @type {string}
       */
      disable: 'disable',

      /**
       * Put the component's Ready to Remove indicator in automatic mode.
       * @const
       * @type {string}
       */
      refresh: 'refresh'
   },

   /**
    * This enumeration is used to determine the type of a given component.
    * @enum {string}
    */
   RTRType: {
      /**
       * This component is an invalid candidate type for removal.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * This component is an Interconnect CRU.
       * @const
       * @type {string}
       */
      interconnect: 'interconnect',

      /**
       * This component is Support CRU A or B.
       * @const
       * @type {string}
       */
      supportCru: 'supportCru',

      /**
       * This component is Controller A or B.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * This component is a battery.
       * @const
       * @type {string}
       */
      battery: 'battery',

      /**
       * This component is a drive.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * This component is an ESM.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * This component is a fan.
       * @const
       * @type {string}
       */
      fan: 'fan',

      /**
       * This component is a power supply.
       * @const
       * @type {string}
       */
      powerSupply: 'powerSupply',

      /**
       * This component is a minihub.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * This component is an alarm.
       * @const
       * @type {string}
       */
      alarm: 'alarm',

      /**
       * This component is a thermal sensor.
       * @const
       * @type {string}
       */
      thermalSensor: 'thermalSensor',

      /**
       * This component is a drawer.
       * @const
       * @type {string}
       */
      drawer: 'drawer'
   },

   /**
    * This enumeration lists the raw data transfer types.
    * @enum {string}
    */
   RawDataTransferType: {
      /**
       * The raw data transfer type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The raw data transfer type is Debug Queue Trace Retrieval.
       * @const
       * @type {string}
       */
      dq: 'dq',

      /**
       * The raw data transfer type is DbmBlk. Whole physical blocks of data are transferred. In addition to transferring valid used data, unrelated data and/or data that has been initialized but is not yet used will also be transferred.
       * @const
       * @type {string}
       */
      dbmblk: 'dbmblk',

      /**
       * The raw data transfer type is DbmRec. Logical records are transferred rather than whole data blocks.
       * @const
       * @type {string}
       */
      dbmrec: 'dbmrec',

      /**
       * The raw data transfer type is Configure Database Validation.
       * @const
       * @type {string}
       */
      dbmCheck: 'dbmCheck',

      /**
       * The raw data transfer type is for state capture from ESMs or DCMs.
       * @const
       * @type {string}
       */
      enclosureStateCapture: 'enclosureStateCapture',

      /**
       * The raw data transfer type is for a complete DPL Core Dump bundle.. This is used to request that both the full or alternate DPL core dump and DQ trace buffer should be retrieved.
       * @const
       * @type {string}
       */
      dplCoreDumpBundle: 'dplCoreDumpBundle',

      /**
       * The raw data transfer type is for I/O Statistics Retrieval.
       * @const
       * @type {string}
       */
      ioStatistics: 'ioStatistics',

      /**
       * The raw data transfer type is FDI/DEMS.
       * @const
       * @type {string}
       */
      fdiDemsLogs: 'fdiDemsLogs',

      /**
       * The raw data transfer type is drive performance history retrieval.
       * @const
       * @type {string}
       */
      drivePerformanceHistory: 'drivePerformanceHistory',

      /**
       * The raw data transfer type is for an IOC Dump.
       * @const
       * @type {string}
       */
      iocDump: 'iocDump',

      /**
       * The raw data operation is for drive health logs.
       * @const
       * @type {string}
       */
      driveHealthLogs: 'driveHealthLogs',

      /**
       * The raw data operation is to retrieve the controller performance logs.
       * @const
       * @type {string}
       */
      ctrlPerfLogs: 'ctrlPerfLogs',

      /**
       * Used to retrieve Dom0 support data.
       * @const
       * @type {string}
       */
      dom0SupportData: 'dom0SupportData',

      /**
       * Enum value for workload capture as a raw data retrieve client.
       * @const
       * @type {string}
       */
      retrieveWlcAnalytics: 'retrieveWlcAnalytics',

      /**
       * Request for AutoLoadBalancing statistics log data.
       * @const
       * @type {string}
       */
      autoLoadBalanceStatisticsLog: 'autoLoadBalanceStatisticsLog',

      /**
       * Add Raw Data Retrieval definition for drive log data in JSON format.
       * @const
       * @type {string}
       */
      jsonDriveLogData: 'jsonDriveLogData',

      /**
       * Collect ASUP data.
       * @const
       * @type {string}
       */
      asupCollection: 'asupCollection'
   },

   /**
    * This enumeration defines the different recovery failure types that may be reported by a controller as part of the getRecoveryFailureList procedure.
    * @enum {string}
    */
   RecoveryFailureType: {
      /**
       * The failure type is Unknown.
       * @const
       * @type {string}
       */
      unknownFailure: 'unknownFailure',

      /**
       * A fan component has failed.
       * @const
       * @type {string}
       */
      failedFan: 'failedFan',

      /**
       * A power supply component has failed.
       * @const
       * @type {string}
       */
      failedPowerSupply: 'failedPowerSupply',

      /**
       * A Fibre Channel minihub component has failed.
       * @const
       * @type {string}
       */
      failedMinihub: 'failedMinihub',

      /**
       * An enclosure services module (ESM) component has failed.
       * @const
       * @type {string}
       */
      failedEsm: 'failedEsm',

      /**
       * A cache holdup battery is nearing its expiration date and needs to be replaced.
       * @const
       * @type {string}
       */
      batteryNearExpiration: 'batteryNearExpiration',

      /**
       * A battery has failed.
       * @const
       * @type {string}
       */
      failedBattery: 'failedBattery',

      /**
       * This recovery failure type indicates that the controller has detected that a temperature sensor has transitioned to a warning status.
       * @const
       * @type {string}
       */
      nominalTempExceeded: 'nominalTempExceeded',

      /**
       * The failure type is Max Temperature Exceeded.
       * @const
       * @type {string}
       */
      maxTempExceeded: 'maxTempExceeded',

      /**
       * The failure type is UPS On Battery
       * @const
       * @type {string}
       */
      upsOnBattery: 'upsOnBattery',

      /**
       * The failure type is Non Preferred Path.
       * @const
       * @type {string}
       */
      nonPreferredPath: 'nonPreferredPath',

      /**
       * The failure type is Memory Parity Error.
       * @const
       * @type {string}
       */
      memParityError: 'memParityError',

      /**
       * A controller has experienced a drive-side I/O channel failure.
       * @const
       * @type {string}
       */
      failedDriveScsiChannel: 'failedDriveScsiChannel',

      /**
       * A volume group has transitioned to the degraded state due to one or more drive failures.
       * @const
       * @type {string}
       */
      degradedVolume: 'degradedVolume',

      /**
       * A volume group has been marked failed due to an interrupted write condition.
       * @const
       * @type {string}
       */
      failedVolumeInterruptedWrite: 'failedVolumeInterruptedWrite',

      /**
       * A volume group has failed during a modification operation, such as dynamic capacity expansion, RAID level migration, etc.
       * @const
       * @type {string}
       */
      failedModifyingVolume: 'failedModifyingVolume',

      /**
       * A volume group has failed during a modification operation, such as dynamic capacity expansion, RAID level migration, etc. This failure code is used for volume groups containing volumes with different RAID levels. It is not supported in the current release of the firmware.
       * @const
       * @type {string}
       */
      failedModifyingMultiRaid: 'failedModifyingMultiRaid',

      /**
       * A volume group has been marked failed due to excessive drive failures.
       * @const
       * @type {string}
       */
      failedVolume: 'failedVolume',

      /**
       * A volume group has been marked failed due to excessive drive failures. This failure code is used for volume groups containing volumes with different RAID levels. It is not supported in the current release of the firmware.
       * @const
       * @type {string}
       */
      failedVolumeMultiRaid: 'failedVolumeMultiRaid',

      /**
       * The failure type is Impaired Volume.
       * @const
       * @type {string}
       */
      impairedVolume: 'impairedVolume',

      /**
       * A volume group was failed due to excessive drive failures, but has since had all failed drives replaced. Since the volumes within the volume group are no longer usable, they must all be formatted/initialized to make them usable again.
       * @const
       * @type {string}
       */
      failedVolumeAwaitingInit: 'failedVolumeAwaitingInit',

      /**
       * The failure type is Volume Hot Spare In Use
       * @const
       * @type {string}
       */
      volumeHotSpareInUse: 'volumeHotSpareInUse',

      /**
       * The failure type is Offline Volume Group.
       * @const
       * @type {string}
       */
      offlineVolumeGroup: 'offlineVolumeGroup',

      /**
       * A drive has failed.
       * @const
       * @type {string}
       */
      failedDrive: 'failedDrive',

      /**
       * The failure type is Impending Drive Failure Risk - High.
       * @const
       * @type {string}
       */
      impendingDriveFailureRiskHigh: 'impendingDriveFailureRiskHigh',

      /**
       * The failure type is Impending Drive Failure Risk - Medium.
       * @const
       * @type {string}
       */
      impendingDriveFailureRiskMed: 'impendingDriveFailureRiskMed',

      /**
       * The failure type is Impending Drive Failure Risk - Low.
       * @const
       * @type {string}
       */
      impendingDriveFailureRiskLow: 'impendingDriveFailureRiskLow',

      /**
       * The failure type is Uncertified Drive
       * @const
       * @type {string}
       */
      uncertifiedDrive: 'uncertifiedDrive',

      /**
       * The failure type is Offline Controller.
       * @const
       * @type {string}
       */
      offlineCtl: 'offlineCtl',

      /**
       * This Recovery Failure Type is logged when the controller is placed into Service Mode.
       * @const
       * @type {string}
       */
      passiveCtl: 'passiveCtl',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      partitionsNotCompliant: 'partitionsNotCompliant',

      /**
       * The firmware versions for the ESM cards in a tray do not match.
       * @const
       * @type {string}
       */
      esmCodeVersionMismatch: 'esmCodeVersionMismatch',

      /**
       * The failure type is Lost Redundancy Drive.
       * @const
       * @type {string}
       */
      lostRedundancyDrive: 'lostRedundancyDrive',

      /**
       * The failure type is Lost Redundancy Tray.
       * @const
       * @type {string}
       */
      lostRedundancyTray: 'lostRedundancyTray',

      /**
       * The failure type is Lost Redundancy ESM.
       * @const
       * @type {string}
       */
      lostRedundancyEsm: 'lostRedundancyEsm',

      /**
       * The failure type is Tray ID Mismatch
       * @const
       * @type {string}
       */
      trayidMismatch: 'trayidMismatch',

      /**
       * The failure type is Tray ID Conflict
       * @const
       * @type {string}
       */
      trayidConflict: 'trayidConflict',

      /**
       * A transceiver module (GBIC or SFP) has failed.
       * @const
       * @type {string}
       */
      failedTransceiverModule: 'failedTransceiverModule',

      /**
       * The drive side fibre channel ports have been incorrectly connected.
       * @const
       * @type {string}
       */
      channelMiswire: 'channelMiswire',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      nonFruBatteryNearExpiration: 'nonFruBatteryNearExpiration',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      nonFruFailedBattery: 'nonFruFailedBattery',

      /**
       * The failure type is RPA_ERR_CTL.
       * @const
       * @type {string}
       */
      rpaErrCtl: 'rpaErrCtl',

      /**
       * The failure type is Repository Over Threshold.
       * @const
       * @type {string}
       */
      repositoryOverThreshold: 'repositoryOverThreshold',

      /**
       * The failure type is Repository Full.
       * @const
       * @type {string}
       */
      repositoryFull: 'repositoryFull',

      /**
       * The failure type is Snapshot Failed.
       * @const
       * @type {string}
       */
      snapshotFailed: 'snapshotFailed',

      /**
       * The failure type is Unsupported Minihub.
       * @const
       * @type {string}
       */
      unsupportedMinihub: 'unsupportedMinihub',

      /**
       * An ESM miswire has occurred.
       * @const
       * @type {string}
       */
      esmMiswire: 'esmMiswire',

      /**
       * A volume is missing.
       * @const
       * @type {string}
       */
      ghostVolume: 'ghostVolume',

      /**
       * The failure type is Snapshot Not Compliant
       * @const
       * @type {string}
       */
      snapshotNotCompliant: 'snapshotNotCompliant',

      /**
       * The failure type is RVM Not Compliant.
       * @const
       * @type {string}
       */
      rvmNotCompliant: 'rvmNotCompliant',

      /**
       * The failure type is Metadata Offline.
       * @const
       * @type {string}
       */
      metadataOffline: 'metadataOffline',

      /**
       * The failure type is Mirror Dual Primary.
       * @const
       * @type {string}
       */
      mirrorDualPrimary: 'mirrorDualPrimary',

      /**
       * The failure type is Mirror Dual Secondary.
       * @const
       * @type {string}
       */
      mirrorDualSecondary: 'mirrorDualSecondary',

      /**
       * The failure type is Mirror Unsynchronized.
       * @const
       * @type {string}
       */
      mirrorUnsynchronized: 'mirrorUnsynchronized',

      /**
       * The failure type is Remote No LUN.
       * @const
       * @type {string}
       */
      remoteNoLun: 'remoteNoLun',

      /**
       * The failure type is Remote No Array.
       * @const
       * @type {string}
       */
      remoteNoArray: 'remoteNoArray',

      /**
       * The failure type is Remote No Fabric.
       * @const
       * @type {string}
       */
      remoteNoFabric: 'remoteNoFabric',

      /**
       * The failure type is Remote WWN Change Failed.
       * @const
       * @type {string}
       */
      remoteWwnChangeFailed: 'remoteWwnChangeFailed',

      /**
       * One or both of the controllers in this storage array cannot communicate with the fan. This problem typically occurs when a component is removed that the controllers need to gain information about other components.
       * @const
       * @type {string}
       */
      fanUnknownStat: 'fanUnknownStat',

      /**
       * The failure type is Power Supply Unknown Status.
       * @const
       * @type {string}
       */
      powerSupplyUnknownStat: 'powerSupplyUnknownStat',

      /**
       * One or both of the controllers in this storage array cannot communicate with the ESM. This problem typically occurs when a component is removed that the controllers need to gain information about other components.
       * @const
       * @type {string}
       */
      esmUnknownStat: 'esmUnknownStat',

      /**
       * The failure type is Temp Sensor Unknown Stat
       * @const
       * @type {string}
       */
      tempSensorUnknownStat: 'tempSensorUnknownStat',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      transModUnknownStat: 'transModUnknownStat',

      /**
       * A drive has been bypassed due to a speed mismatch.
       * @const
       * @type {string}
       */
      driveBypassedSpeedMismatch: 'driveBypassedSpeedMismatch',

      /**
       * A drive has been bypassed and the cause is unknown.
       * @const
       * @type {string}
       */
      driveBypassedCauseUnknown: 'driveBypassedCauseUnknown',

      /**
       * The failure type is Minihub Speed Mismatch.
       * @const
       * @type {string}
       */
      minihubSpeedMismatch: 'minihubSpeedMismatch',

      /**
       * The failure type is Removed ESM.
       * @const
       * @type {string}
       */
      removedEsm: 'removedEsm',

      /**
       * The failure type is Removed Battery.
       * @const
       * @type {string}
       */
      removedBattery: 'removedBattery',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      nonFruRemovedBattery: 'nonFruRemovedBattery',

      /**
       * The failure type is Volume Copy Failed.
       * @const
       * @type {string}
       */
      volcopyFailed: 'volcopyFailed',

      /**
       * The failure type is Volume Copy Not Compliant.
       * @const
       * @type {string}
       */
      volcopyNotCompliant: 'volcopyNotCompliant',

      /**
       * A degraded drive channel condition has occurred.
       * @const
       * @type {string}
       */
      channelDegraded: 'channelDegraded',

      /**
       * The failure type is Unsupported Tray.
       * @const
       * @type {string}
       */
      unsupportedTray: 'unsupportedTray',

      /**
       * The failure type is Speed Neg Error
       * @const
       * @type {string}
       */
      speedNegError: 'speedNegError',

      /**
       * The failure type is USM Database Full
       * @const
       * @type {string}
       */
      usmDatabaseFull: 'usmDatabaseFull',

      /**
       * The failure type is USM Unreadable Sectors Exist
       * @const
       * @type {string}
       */
      usmUnreadableSectorsExist: 'usmUnreadableSectorsExist',

      /**
       * The failure type is Path Degraded.
       * @const
       * @type {string}
       */
      pathDegraded: 'pathDegraded',

      /**
       * Yuma 1.4
       * @const
       * @type {string}
       */
      netSetupError: 'netSetupError',

      /**
       * The failure type is Mismatched Drive Type.
       * @const
       * @type {string}
       */
      mismatchedDriveType: 'mismatchedDriveType',

      /**
       * One of the controllers in this storage array is incompatible with the other controller. The alternate controller is locked down.
       * @const
       * @type {string}
       */
      ctlMismatch: 'ctlMismatch',

      /**
       * A failure of a discrete line has been detected.
       * @const
       * @type {string}
       */
      failedDiscreteLine: 'failedDiscreteLine',

      /**
       * A failed drive channel condition has occurred.
       * @const
       * @type {string}
       */
      channelFailed: 'channelFailed',

      /**
       * The failure type is Link Speed Detection Mismatch.
       * @const
       * @type {string}
       */
      linkSpeedDetectionMismatch: 'linkSpeedDetectionMismatch',

      /**
       * The failure type is Uncertified ESM
       * @const
       * @type {string}
       */
      uncertifiedEsm: 'uncertifiedEsm',

      /**
       * The failure type is Removed Fan.
       * @const
       * @type {string}
       */
      removedFan: 'removedFan',

      /**
       * The failure type is Removed Power Supply.
       * @const
       * @type {string}
       */
      removedPowerSupply: 'removedPowerSupply',

      /**
       * The failure type is Removed Temp Sensor.
       * @const
       * @type {string}
       */
      removedTempSensor: 'removedTempSensor',

      /**
       * The failure type is Removed Interconnect CRU.
       * @const
       * @type {string}
       */
      removedIccCru: 'removedIccCru',

      /**
       * The failure type is Removed Support CRU.
       * @const
       * @type {string}
       */
      removedSupportCru: 'removedSupportCru',

      /**
       * The Interconnect CRU (also known as an Interconnect-battery canister) for this storage array has failed
       * @const
       * @type {string}
       */
      failedIccCru: 'failedIccCru',

      /**
       * A support CRU (also called a Power-Fan canister) has failed and must be replaced.
       * @const
       * @type {string}
       */
      failedSupportCru: 'failedSupportCru',

      /**
       * One or both of the controllers in this storage array cannot communicate with the storage array component listed in the Details area. This problem typically occurs when a component is removed that the controllers need to gain information about other components.
       * @const
       * @type {string}
       */
      batteryUnknownStat: 'batteryUnknownStat',

      /**
       * There are drive trays in the storage array that are not cabled correctly because they have ESM canisters that must be cabled sequentially together.
       * @const
       * @type {string}
       */
      driveTraysNotGroupedTogether: 'driveTraysNotGroupedTogether',

      /**
       * This failure type is obsolete.
       * @const
       * @type {string}
       */
      goldKeyNotCompliant: 'goldKeyNotCompliant',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      mismatchedMdtSettings: 'mismatchedMdtSettings',

      /**
       * This is obsolete.
       * @const
       * @type {string}
       */
      mismatchedGoldKeySettings: 'mismatchedGoldKeySettings',

      /**
       * A controller has multiple connections from its drive ports to ESM canisters in the same drive tray.
       * @const
       * @type {string}
       */
      ctlMiswire: 'ctlMiswire',

      /**
       * The failure type is Support CRU No Input
       * @const
       * @type {string}
       */
      supportCruNoinput: 'supportCruNoinput',

      /**
       * The failure type is Submodel Not Supported
       * @const
       * @type {string}
       */
      submodelNotSupported: 'submodelNotSupported',

      /**
       * The failure type is Submodel Not Set
       * @const
       * @type {string}
       */
      submodelNotSet: 'submodelNotSet',

      /**
       * The failure type is Submodel Mismatch
       * @const
       * @type {string}
       */
      submodelMismatch: 'submodelMismatch',

      /**
       * A battery pack in the Interconnect CRU has failed. In rare cases, this problem could also result from a failure in the battery system, which includes charging units and voltage regulators.
       * @const
       * @type {string}
       */
      failedBatterySystem: 'failedBatterySystem',

      /**
       * The failure type is Removed Battery Pack.
       * @const
       * @type {string}
       */
      removedBatteryPack: 'removedBatteryPack',

      /**
       * A battery is physically present when the storage array is configured to operate without batteries.
       * @const
       * @type {string}
       */
      batteryConfigMismatch: 'batteryConfigMismatch',

      /**
       * The ESM cards in a tray do not match.
       * @const
       * @type {string}
       */
      esmHardwareMismatch: 'esmHardwareMismatch',

      /**
       * The failure type is host-board related.
       * @const
       * @type {string}
       */
      hostBoardFault: 'hostBoardFault',

      /**
       * The array has captured diagnostic data for an abnormal event.
       * @const
       * @type {string}
       */
      ddcAvailable: 'ddcAvailable',

      /**
       * The failure type is Replace Drive Wrong Type.
       * @const
       * @type {string}
       */
      replacedDriveWrongType: 'replacedDriveWrongType',

      /**
       * A support CRU is configured incorrectly - it is missing a power supply that is needed in order to meet the system's redundancy requirements
       * @const
       * @type {string}
       */
      redundantPsRequired: 'redundantPsRequired',

      /**
       * The number of drive trays in the storage array exceeds the limit for the particular product.
       * @const
       * @type {string}
       */
      driveTraysNotCompliant: 'driveTraysNotCompliant',

      /**
       * More SAS devices have been discovered than can be successfully addressed by the RAIDcontroller.
       * @const
       * @type {string}
       */
      sasDeviceLimitExceeded: 'sasDeviceLimitExceeded',

      /**
       * This value of the enumeration represents a SAS miswire condition where a controller host port is connected to an expansion drive tray, instead of a host.
       * @const
       * @type {string}
       */
      sasPortMiswired: 'sasPortMiswired',

      /**
       * This value of the enumeration means that a degraded SAS port exists in the array.
       * @const
       * @type {string}
       */
      sasPortDegraded: 'sasPortDegraded',

      /**
       * This value of the enumeration means that a failed SAS port exists in the array.
       * @const
       * @type {string}
       */
      sasPortFailed: 'sasPortFailed',

      /**
       * The contents of a Storage Bridge Bay (SBB) EEPROM, used for vital product data storage, has become corrupted.
       * @const
       * @type {string}
       */
      corruptVpdEeprom: 'corruptVpdEeprom',

      /**
       * An I2C bus connected to one of the Storage Bridge Bay (SBB) EEPROMs has failed.
       * @const
       * @type {string}
       */
      failedI2cBus: 'failedI2cBus',

      /**
       * The enclosure has invalid configuration settings.
       * @const
       * @type {string}
       */
      enclosureMisconfigured: 'enclosureMisconfigured',

      /**
       * The storage array has been found to have attributes that violate the current sub-model definition.
       * @const
       * @type {string}
       */
      featureBundleNotCompliant: 'featureBundleNotCompliant',

      /**
       * A drive has been bypassed on only one of its ports.
       * @const
       * @type {string}
       */
      driveBypassedSinglePort: 'driveBypassedSinglePort',

      /**
       * The two ESMs in a tray are reporting different version information for the ESM factory default settings.
       * @const
       * @type {string}
       */
      esmFactoryDefaultsMismatch: 'esmFactoryDefaultsMismatch',

      /**
       * The status of a host board cannot be determined because communication pathways on which the controller(s) depend to get that information are not available. The alternate controller is locked down.
       * @const
       * @type {string}
       */
      hostBoardUnknownStat: 'hostBoardUnknownStat',

      /**
       * A host I/O card has failed and the alternate controller is locked down. This enumeration value is numerically equivalent to REC_HOST_BOARD_FAULT. It has been added so as to make the failure recovery terminology line up with the major event log terminology. The two enumeration values may be used interchangeably.
       * @const
       * @type {string}
       */
      failedHostIoCard: 'failedHostIoCard',

      /**
       * The capacity of a smart battery unit is insufficient to hold up the cache for a set period of time, depending on the type of battery.
       * @const
       * @type {string}
       */
      batteryWarn: 'batteryWarn',

      /**
       * A volume group has transitioned from the online to the partial state because of a drive removal.The partial state means that, while some drives are missing, there is a sufficient number left to make volume data accessible.
       * @const
       * @type {string}
       */
      volumeGroupPartiallyComplete: 'volumeGroupPartiallyComplete',

      /**
       * A volume group has transitioned from the online state to the incomplete state because of a drive removal. The incomplete state means that the group does not have enough drives to make volume data accessible.
       * @const
       * @type {string}
       */
      volumeGroupIncomplete: 'volumeGroupIncomplete',

      /**
       * A volume group has transitioned from the online or incomplete state to the missing state because of drive removal. The missing state means that all drives of the group are missing.
       * @const
       * @type {string}
       */
      volumeGroupMissing: 'volumeGroupMissing',

      /**
       * A drive designated as a standby hot spare is missing from the configuration.
       * @const
       * @type {string}
       */
      hotspareDriveMissing: 'hotspareDriveMissing',

      /**
       * A drive has a DACStore that is unrecognizable because it was written by a later version of the firmware.
       * @const
       * @type {string}
       */
      driveIncompatibleUprevDacstore: 'driveIncompatibleUprevDacstore',

      /**
       * A drive has a DACStore that is unrecognizable because it was written by an earlier version of the firmware.
       * @const
       * @type {string}
       */
      driveIncompatibleDownrevDacstore: 'driveIncompatibleDownrevDacstore',

      /**
       * A controllers in this storage array cannot communicate with the interconnect CRU. This problem typically occurs when a component is removed that the controllers need to gain information about other components. The alternate controller is locked down.
       * @const
       * @type {string}
       */
      iccCruUnknownStat: 'iccCruUnknownStat',

      /**
       * The alarm was removed.
       * @const
       * @type {string}
       */
      removedAlarm: 'removedAlarm',

      /**
       * One or both of the controllers in this storage array cannot communicate with a support CRU. This problem typically occurs when a component is removed that the controllers need to gain information about other components.
       * @const
       * @type {string}
       */
      supportCruUnknownStat: 'supportCruUnknownStat',

      /**
       * The performance tiering feature is out-of-compliance.
       * @const
       * @type {string}
       */
      performanceTierNotCompliant: 'performanceTierNotCompliant',

      /**
       * A RAID 6 SAFE key has been imported to the storage array on a set of foreign drives, and the storage array is now out of compliance; or the RAID 6 SAFE key has been removed, and there are still RAID 6 volume groups present in the storage array (i.e., "not within limits").
       * @const
       * @type {string}
       */
      raid6NotCompliant: 'raid6NotCompliant',

      /**
       * A drive has a formatted sector size that is different from the other drives in the storage array.
       * @const
       * @type {string}
       */
      driveIncompatibleSectorSize: 'driveIncompatibleSectorSize',

      /**
       * The configuration data stored on a foreign drive indicates that it is part of a volume group in the same storage array; however, the drive's configuration data is inconsistent with that of the volume group in one of the following ways: (1) the volume group is in the complete state and has no indication of drives missing, or (2) the volume group is in the exported state, but the drive's configuration data is older than that of the volume group's drives.
       * @const
       * @type {string}
       */
      foreignDriveInconsistent: 'foreignDriveInconsistent',

      /**
       * The volume group information on an incoming foreign drive refers to a native drive in the storage array as being a member of the group.
       * @const
       * @type {string}
       */
      foreignDriveRefersToNativeDrive: 'foreignDriveRefersToNativeDrive',

      /**
       * A volume group in the partial state along with its missing drive are present in the same storage array, however their respective metadata are in conflict, making it impossible to complete the volume group.
       * @const
       * @type {string}
       */
      nativeVgRefersToForeignDrive: 'nativeVgRefersToForeignDrive',

      /**
       * A volume group in the partial state along with its missing drive are present in the same storage array. Their respective metadata are in agreement with respect to volume group membership; however, the storage array considers the volume group as native and the drive as foreign.
       * @const
       * @type {string}
       */
      nativeVgForeignDriveMutualRef: 'nativeVgForeignDriveMutualRef',

      /**
       * The drives for a volume group that were removed from an array with no export performed, have been re-inserted back into that array, after having been imported into another array where the volume group's configuration was changed in various ways.
       * @const
       * @type {string}
       */
      vgCloned: 'vgCloned',

      /**
       * A contingent volume group refers to a foreign drive in the storage array which has an inconsistent configuration database.
       * @const
       * @type {string}
       */
      foreignDriveHasInconsistentRole: 'foreignDriveHasInconsistentRole',

      /**
       * A partial volume group refers to a foreign drive in the storage array; a foreign volume group refers to the same drive; and the foreign drive considers itself assigned to the foreign volume group.
       * @const
       * @type {string}
       */
      vgDrivePartOfMultipleVgs: 'vgDrivePartOfMultipleVgs',

      /**
       * A legacy (REV3) volume group which contains an in-use hot spare and/or a failed drive is inserted.
       * @const
       * @type {string}
       */
      incompatibleFailedLegacyDrive: 'incompatibleFailedLegacyDrive',

      /**
       * The controller is configured with an unsupported cache memory size.
       * @const
       * @type {string}
       */
      unsupportedCacheMemorySize: 'unsupportedCacheMemorySize',

      /**
       * A channel (or channels) dedicated to cache mirroring has (have) failed. The root cause is a degraded controller.
       * @const
       * @type {string}
       */
      dedicatedMirrorChannelFailed: 'dedicatedMirrorChannelFailed',

      /**
       * A partial volume group refers to a foreign drive in the storage array; a foreign volume group refers to the same drive; and the foreign drive considers itself assigned to the foreign volume group.
       * @const
       * @type {string}
       */
      vgHasDrivePartOfMultipleVgs: 'vgHasDrivePartOfMultipleVgs',

      /**
       * A drive in the array has a SNIA Disk Data Format (DDF) anchor header with a T10 vendor ID other than LSI-Engenio
       * @const
       * @type {string}
       */
      ddfDriveOtherVendor: 'ddfDriveOtherVendor',

      /**
       * The storage array has detected the presence of multiple configuration databases among the drives it is trying to adopt. Since the array can't determine which drive to adopt, all drives of the array are locked out.
       * @const
       * @type {string}
       */
      multipleConfigDatabasesDetected: 'multipleConfigDatabasesDetected',

      /**
       * A configuration database adoption process failed due to incoming drives having an unsupported RAID level. All drives of the array locked out when this happens.
       * @const
       * @type {string}
       */
      adoptionFailedRaidLevelUnsupported: 'adoptionFailedRaidLevelUnsupported',

      /**
       * A database adoption failed because a hard limit was exceeded. All drives of the array are locked out when this happens.
       * @const
       * @type {string}
       */
      dbAdoptionHardLimitExceeded: 'dbAdoptionHardLimitExceeded',

      /**
       * A legacy volume group has been inserted into a storage array which has failed drives and/or in usehot-spares.
       * @const
       * @type {string}
       */
      legacyVgNotOptimal: 'legacyVgNotOptimal',

      /**
       * The two controllers in the storage array have different cache memory capacities.
       * @const
       * @type {string}
       */
      cacheMemSizeMismatch: 'cacheMemSizeMismatch',

      /**
       * Emerald
       * @const
       * @type {string}
       */
      altCtlrBoardIdUnreadable: 'altCtlrBoardIdUnreadable',

      /**
       * A cache backup device has failed.
       * @const
       * @type {string}
       */
      cacheBackupDeviceFailed: 'cacheBackupDeviceFailed',

      /**
       * A cache backup device has its write-protect setting enabled.
       * @const
       * @type {string}
       */
      cacheBackupDeviceWriteProtected: 'cacheBackupDeviceWriteProtected',

      /**
       * A cache backup device is missing, leaving insufficient space to perform a full backup.
       * @const
       * @type {string}
       */
      cacheBackupDeviceInsufficientCapacity: 'cacheBackupDeviceInsufficientCapacity',

      /**
       * A cache holdup battery has expired.
       * @const
       * @type {string}
       */
      expiredBattery: 'expiredBattery',

      /**
       * A cache holdup battery inside the controller canister has expired.
       * @const
       * @type {string}
       */
      expiredIntegratedBattery: 'expiredIntegratedBattery',

      /**
       * The failure type is Proc Memory Too Small for Cache. This will only occur in rare cases where not enough procedure memory was allocated to support the size of the rpa region.
       * @const
       * @type {string}
       */
      procMemTooSmallForCache: 'procMemTooSmallForCache',

      /**
       * The failure type is Battery Overtemp.
       * @const
       * @type {string}
       */
      batteryOvertemp: 'batteryOvertemp',

      /**
       * A host type index is invalid with respect to the currently-running version of controller firmware. This problem may apply to either the default host type or to a particular host in the defined topology.
       * @const
       * @type {string}
       */
      invalidHostTypeIndex: 'invalidHostTypeIndex',

      /**
       * Insufficient processor memory
       * @const
       * @type {string}
       */
      insufficientProcMemory: 'insufficientProcMemory',

      /**
       * Cache backup device diagnostic test failed.
       * @const
       * @type {string}
       */
      ctlFailedCacheBackupDev: 'ctlFailedCacheBackupDev',

      /**
       * Controller removed from array configured to use dual controllers.
       * @const
       * @type {string}
       */
      removedController: 'removedController',

      /**
       * A host board (a.k.a. host I/O card) has become degraded. A host board is considered degraded when some, but not all, of its ports are operational.
       * @const
       * @type {string}
       */
      degradedHostIoCard: 'degradedHostIoCard',

      /**
       * The failure type is LD FW Version Mismatch.
       * @const
       * @type {string}
       */
      ldFwVersionMismatch: 'ldFwVersionMismatch',

      /**
       * The failure type is LD Incompatible Database.
       * @const
       * @type {string}
       */
      ldIncompatibleDatabase: 'ldIncompatibleDatabase',

      /**
       * The failure type is a host board ID mismatch.
       * @const
       * @type {string}
       */
      hostBoardIdMismatch: 'hostBoardIdMismatch',

      /**
       * The failure type is Interconnect CRU Missing.
       * @const
       * @type {string}
       */
      iccMissing: 'iccMissing',

      /**
       * The failure type is Link Speed Mismatch.
       * @const
       * @type {string}
       */
      linkSpeedMismatch: 'linkSpeedMismatch',

      /**
       * The failure type is Unsupported Host Board.
       * @const
       * @type {string}
       */
      unsupportedHostBoard: 'unsupportedHostBoard',

      /**
       * Write-back caching for one or more volumes has been forcibly disabled by the storage array.
       * @const
       * @type {string}
       */
      writebackCachingDisabled: 'writebackCachingDisabled',

      /**
       * The array needs a lock key.
       * @const
       * @type {string}
       */
      securityGetKey: 'securityGetKey',

      /**
       * The array lock keys for the controllers are different.
       * @const
       * @type {string}
       */
      securityKeyInconsistent: 'securityKeyInconsistent',

      /**
       * The Secure Volume SAFE key has been removed and there are still Secure Volume groups present in the storage array.
       * @const
       * @type {string}
       */
      securityNotCompliant: 'securityNotCompliant',

      /**
       * One or more drive channels have an unsupported combination of drive enclosures.
       * @const
       * @type {string}
       */
      mixedDriveEnclosureMiswire: 'mixedDriveEnclosureMiswire',

      /**
       * Obsolete. Unsuccessful isolation of redundancy mismatch.
       * @const
       * @type {string}
       */
      unsuccessIsolationRedunMismatch: 'unsuccessIsolationRedunMismatch',

      /**
       * Obsolete. Drive PFA threshold exceeded but redundancy mismatch successfully isolated and corrected.
       * @const
       * @type {string}
       */
      thresExcdedMismatchCorrected: 'thresExcdedMismatchCorrected',

      /**
       * The Host Context Agent (HCA) attempted to register a host port associated with a host that already has storage partition mappings. The host port was consequently marked inactive and can be activated through the storage management software or CLI.
       * @const
       * @type {string}
       */
      inactiveHostPort: 'inactiveHostPort',

      /**
       * The Host Context Agent (HCA) attempted to register an iSCSI initiator associated with a host that already has storage partition mappings. The iSCSI initiator was consequently marked inactive and can be activated through the storage management software or CLI.
       * @const
       * @type {string}
       */
      inactiveInitiator: 'inactiveInitiator',

      /**
       * The T10 Protection Information feature is out of compliance.
       * @const
       * @type {string}
       */
      protectionInformationNotCompliant: 'protectionInformationNotCompliant',

      /**
       * The volume group has one or more protected volumes that cannot be supported by this storage array.
       * @const
       * @type {string}
       */
      protectionInformationNotSupported: 'protectionInformationNotSupported',

      /**
       * The inserted drive does not have sufficient capacity for the user data of the failed drive.
       * @const
       * @type {string}
       */
      replacedInsufficientDriveCapacity: 'replacedInsufficientDriveCapacity',

      /**
       * Drawer DCM or interposer failed.
       * @const
       * @type {string}
       */
      drawerFailed: 'drawerFailed',

      /**
       * Drawer open or removed - could lead to enclosure overtemp condition.
       * @const
       * @type {string}
       */
      drawerOpened: 'drawerOpened',

      /**
       * SSD feature out of compliance.
       * @const
       * @type {string}
       */
      ssdNotCompliant: 'ssdNotCompliant',

      /**
       * SSD at end of wear life.
       * @const
       * @type {string}
       */
      ssdAtEndOfLife: 'ssdAtEndOfLife',

      /**
       * Two ESMs or a controller and ESM are not cabled together properly.
       * @const
       * @type {string}
       */
      fibreTrunkMiswire: 'fibreTrunkMiswire',

      /**
       * The ESM does not support trunking.
       * @const
       * @type {string}
       */
      fibreTrunkIncompatibleEsm: 'fibreTrunkIncompatibleEsm',

      /**
       * Number of discovered drive slots exceeds maximum for SubModel/Key.
       * @const
       * @type {string}
       */
      driveSlotLimitNotCompliant: 'driveSlotLimitNotCompliant',

      /**
       * Using a Key Management Server and array needs a new key.
       * @const
       * @type {string}
       */
      securityGetNewKey: 'securityGetNewKey',

      /**
       * Array in Key Needed state, no external KM SAFE key, and key request satisfied through installLockKey. Needs Attention condition cleared by applying appropriate SAFE key or through feature bundle migration.
       * @const
       * @type {string}
       */
      externalKmsNotCompliant: 'externalKmsNotCompliant',

      /**
       * Enclosure SIM failed validation.
       * @const
       * @type {string}
       */
      sbbValidationFailure: 'sbbValidationFailure',

      /**
       * The controller has detected an invalid power supply for the enclosure on start up or hot swap.
       * @const
       * @type {string}
       */
      invalidPowerSupply: 'invalidPowerSupply',

      /**
       * Enclosure power-down in progress due to an over-temperature or under-temperature threshold condition.
       * @const
       * @type {string}
       */
      enclosureThermalShutdown: 'enclosureThermalShutdown',

      /**
       * Write-Back Caching forcibly disabled.
       * @const
       * @type {string}
       */
      wbCachingForciblyDisabled: 'wbCachingForciblyDisabled',

      /**
       * A drive has an unsupported protocol connection.
       * @const
       * @type {string}
       */
      driveUnsupportedProtocolConnection: 'driveUnsupportedProtocolConnection',

      /**
       * TWI bus has failed.
       * @const
       * @type {string}
       */
      failedTwiBus: 'failedTwiBus',

      /**
       * Mismatched midplane EEPROM contents.
       * @const
       * @type {string}
       */
      mismatchedMidplaneEeproms: 'mismatchedMidplaneEeproms',

      /**
       * The drive capacity is not supported.
       * @const
       * @type {string}
       */
      driveUnsupportedCapacity: 'driveUnsupportedCapacity',

      /**
       * The evaluation license is about to expire.
       * @const
       * @type {string}
       */
      evaluationLicenseExpirationImminent: 'evaluationLicenseExpirationImminent',

      /**
       * Obsolete. Key ID is correct but the lock key is invalid.
       * @const
       * @type {string}
       */
      externalKmsKeyInvalid: 'externalKmsKeyInvalid',

      /**
       * Multiple drive Lock Key IDs do not match the array Lock Key ID.
       * @const
       * @type {string}
       */
      multipleMismatchedKeyIdsFound: 'multipleMismatchedKeyIdsFound',

      /**
       * Too many key validation attempts have failed. Clear by restarting array.
       * @const
       * @type {string}
       */
      securityKeyValidationLock: 'securityKeyValidationLock',

      /**
       * Data in cache lost after power cycle or reset. Controller was unable to recover cache data.
       * @const
       * @type {string}
       */
      cacheDataLoss: 'cacheDataLoss',

      /**
       * One of the base controller diagnostic tests has failed due to one or more of the components within the base controller not functioning as desired.
       * @const
       * @type {string}
       */
      baseControllerDiagFailed: 'baseControllerDiagFailed',

      /**
       * The premium feature is out of compliance.
       * @const
       * @type {string}
       */
      featureNotCompliant: 'featureNotCompliant',

      /**
       * The drive has an incompatible Protection Information type.
       * @const
       * @type {string}
       */
      driveIncompatiblePiType: 'driveIncompatiblePiType',

      /**
       * A DCM has failed and the drawer is degraded. I/Os for the drawer may still be serviced through the alternate DCM.
       * @const
       * @type {string}
       */
      drawerDegraded: 'drawerDegraded',

      /**
       * The alternate controller is in a lockdown state as a result of an IOC diagnostic failure.
       * @const
       * @type {string}
       */
      offlineCtlIocFail: 'offlineCtlIocFail',

      /**
       * The SATA flash drive configuration is invalid.
       * @const
       * @type {string}
       */
      invalidSataFlashConfiguration: 'invalidSataFlashConfiguration',

      /**
       * The controller has failed IOC diagnostic testing.
       * @const
       * @type {string}
       */
      iocDiagFail: 'iocDiagFail',

      /**
       * The wide port between the IOC and the local expander has had a phy disabled resulting in a degraded channel.
       * @const
       * @type {string}
       */
      sasPhyDisabledLocalWidePortDegraded: 'sasPhyDisabledLocalWidePortDegraded',

      /**
       * The wide port between the IOC and the alternate's expander has had a phy disabled resulting in a degraded channel.
       * @const
       * @type {string}
       */
      sasPhyDisabledSharedWidePortDegraded: 'sasPhyDisabledSharedWidePortDegraded',

      /**
       * A drawer is invalid and cannot be supported.
       * @const
       * @type {string}
       */
      drawerInvalid: 'drawerInvalid',

      /**
       * A drawer has been removed. This could lead to an overtemp condition in the enclosure.
       * @const
       * @type {string}
       */
      drawerRemoved: 'drawerRemoved',

      /**
       * A drive has an unsupported interposer firmware version.
       * @const
       * @type {string}
       */
      driveUnsupportedInterposerFwVersion: 'driveUnsupportedInterposerFwVersion',

      /**
       * A redundancy group has been determined to be inconsistent during a reconfiguration operation. After the reconfiguration completes the data will be consistent, but may be corrupt.
       * @const
       * @type {string}
       */
      redundancyGroupNotConsistentDuringReconfig: 'redundancyGroupNotConsistentDuringReconfig',

      /**
       * A snapshot rollback operation has paused active data copy.
       * @const
       * @type {string}
       */
      snapshotRollbackPaused: 'snapshotRollbackPaused',

      /**
       * A PiT rollback operation has paused active data copy.
       * @const
       * @type {string}
       */
      pitRollbackPaused: 'pitRollbackPaused',

      /**
       * PiT Group repository capacity utilized exceeded warning threshold.
       * @const
       * @type {string}
       */
      pitGroupRepositoryOverThreshold: 'pitGroupRepositoryOverThreshold',

      /**
       * PiT view repository capacity utilized exceeded warning threshold.
       * @const
       * @type {string}
       */
      pitViewRepositoryOverThreshold: 'pitViewRepositoryOverThreshold',

      /**
       * PiT Group repository full.
       * @const
       * @type {string}
       */
      pitGroupRepositoryFull: 'pitGroupRepositoryFull',

      /**
       * PiT view repository full.
       * @const
       * @type {string}
       */
      pitViewRepositoryFull: 'pitViewRepositoryFull',

      /**
       * PiT group in failed state.
       * @const
       * @type {string}
       */
      pitGroupFailed: 'pitGroupFailed',

      /**
       * PiT view in failed state.
       * @const
       * @type {string}
       */
      pitViewFailed: 'pitViewFailed',

      /**
       * PiT purged to free PiT group repository capacity.
       * @const
       * @type {string}
       */
      pitPurged: 'pitPurged',

      /**
       * An Async Mirror Group has been or still is in a degraded state. Note this is a "sticky" condition until the user acknowledges it via clearAsyncMirrorGroupFaultIndication.
       * @const
       * @type {string}
       */
      arvmDegradedMirrorGroup: 'arvmDegradedMirrorGroup',

      /**
       * An Async Mirror is in failed state.
       * @const
       * @type {string}
       */
      arvmFailedMirror: 'arvmFailedMirror',

      /**
       * One or more Async Mirror Group members sync interval time exceeded the warning threshold. Note this is a "sticky" condition until the user acknowledges it via clearAsyncMirrorGroupFaultIndication.
       * @const
       * @type {string}
       */
      arvmSyncIntervalTimeOverThreshold: 'arvmSyncIntervalTimeOverThreshold',

      /**
       * Repository utilization for a specific Async Mirror Group member has exceeded the warning threshold. Note this is a "sticky" condition until the user acknowledges it via clearAsyncMirrorGroupMemberFaultIndication
       * @const
       * @type {string}
       */
      arvmRepositoryOverWarnThreshold: 'arvmRepositoryOverWarnThreshold',

      /**
       * Two arrays have conflicting Async Mirror Group roles.
       * @const
       * @type {string}
       */
      arvmMirrorGroupRoleConflict: 'arvmMirrorGroupRoleConflict',

      /**
       * An unsecure data replica exists in the Volume Group (PiT View Repository, PiT Group Repository, Async Mirror Repository, or Async Mirror Secondary Volume).
       * @const
       * @type {string}
       */
      incompatibleVolumeGroupSecurity: 'incompatibleVolumeGroupSecurity',

      /**
       * An Async Mirror Group deletion has partially failed, resulting in an orphaned mirror member.
       * @const
       * @type {string}
       */
      arvmOrphanGroup: 'arvmOrphanGroup',

      /**
       * An Async Mirror Group member deletion has partially failed, resulting in an orphaned mirror member.
       * @const
       * @type {string}
       */
      arvmOrphanMember: 'arvmOrphanMember',

      /**
       * A recovery point is no longer available for a given Async Mirror Group.
       * @const
       * @type {string}
       */
      arvmMirrorGroupRecoveryPointLost: 'arvmMirrorGroupRecoveryPointLost',

      /**
       * A disk pool transitioned from the Complete state to the Partial state because of a drive removal.
       * @const
       * @type {string}
       */
      diskPoolPartiallyPresent: 'diskPoolPartiallyPresent',

      /**
       * A disk pool transitioned from the Complete state or the Partial state to the Incomplete state because of a drive removal. The pool is no longer accessible.
       * @const
       * @type {string}
       */
      diskPoolIncomplete: 'diskPoolIncomplete',

      /**
       * A disk pool transitioned to the Missing state because of drive removal.
       * @const
       * @type {string}
       */
      diskPoolMissing: 'diskPoolMissing',

      /**
       * The space reserved for reconstructions within a disk pool fell below the reconstruction reserved disk count value. This occurs when failed drives are rebuilt and use up reserved space.
       * @const
       * @type {string}
       */
      diskPoolReconstructionDriveCountBelowThreshold: 'diskPoolReconstructionDriveCountBelowThreshold',

      /**
       * A disk pool utilization exceeds the Utilization Threshold Warning attribute.
       * @const
       * @type {string}
       */
      diskPoolUtilizationWarning: 'diskPoolUtilizationWarning',

      /**
       * A disk pool utilization exceeds the Utilization Threshold Critical attribute.
       * @const
       * @type {string}
       */
      diskPoolUtilizationCritical: 'diskPoolUtilizationCritical',

      /**
       * A Pending PiT Creation for a PiT Group failed.
       * @const
       * @type {string}
       */
      pendingPitCreationFailed: 'pendingPitCreationFailed',

      /**
       * A Pending PiT Creation for a Consistency Group failed.
       * @const
       * @type {string}
       */
      pendingCgpitCreationFailed: 'pendingCgpitCreationFailed',

      /**
       * The thin volume's repository is over the threshold value.
       * @const
       * @type {string}
       */
      tpvRepositoryOverThreshold: 'tpvRepositoryOverThreshold',

      /**
       * The thin volume's repository is full.
       * @const
       * @type {string}
       */
      tpvRepositoryFull: 'tpvRepositoryFull',

      /**
       * The thin volume is in a failed state.
       * @const
       * @type {string}
       */
      tpvFailed: 'tpvFailed',

      /**
       * Repository utilization for a specific Async Mirror Group member has reached the full point (secondary repository).
       * @const
       * @type {string}
       */
      arvmSecondaryRepositoryFull: 'arvmSecondaryRepositoryFull',

      /**
       * Synchronization has been suspended by the controller due to an error condition (not due to a user request to suspend).
       * @const
       * @type {string}
       */
      arvmSyncInternallySuspended: 'arvmSyncInternallySuspended',

      /**
       * The Stable Store Backup database is in recovery mode.
       * @const
       * @type {string}
       */
      databaseRecoveryMode: 'databaseRecoveryMode',

      /**
       * Repository utilization for a specific Async Mirror Group Member (primary) has reached the full point. Note this is a "sticky" recovery action.
       * @const
       * @type {string}
       */
      arvmPrimaryRepositoryFull: 'arvmPrimaryRepositoryFull',

      /**
       * A SATA drive is incompatible because it does not support SMART Command Transfer (SCT) commands.
       * @const
       * @type {string}
       */
      incompatibleSataDrive: 'incompatibleSataDrive',

      /**
       * A Disk Pool's capacity is depleted..
       * @const
       * @type {string}
       */
      diskPoolCapacityDepleted: 'diskPoolCapacityDepleted',

      /**
       * The drive is unsupported based on the model number.
       * @const
       * @type {string}
       */
      driveIncompatibleModelNumberUnsupported: 'driveIncompatibleModelNumberUnsupported',

      /**
       * Flash Cache is in non-optimal state due to missing or inaccessible drives.
       * @const
       * @type {string}
       */
      flashCacheNonOptimalDrives: 'flashCacheNonOptimalDrives',

      /**
       * Flash Cache is in non-optimal condition due to hot spare in use.
       * @const
       * @type {string}
       */
      flashCacheHotSpareInUse: 'flashCacheHotSpareInUse',

      /**
       * In a Native SATA array this indicates the controller has a duplex NVSRAM setting and all drives appear as bypassed.
       * @const
       * @type {string}
       */
      allDrivesBypassedIncompatibleNvsram: 'allDrivesBypassedIncompatibleNvsram',

      /**
       * A drive in a Disk Pool has failed.
       * @const
       * @type {string}
       */
      diskPoolDriveFailure: 'diskPoolDriveFailure',

      /**
       * Access to disk pool volumes is prohibited because of insufficient memory.
       * @const
       * @type {string}
       */
      diskPoolInsufficientMemory: 'diskPoolInsufficientMemory',

      /**
       * An orphan Async Mirror Group Incomplete Member exists.
       * @const
       * @type {string}
       */
      arvmOrphanIncompleteMember: 'arvmOrphanIncompleteMember',

      /**
       * Synchronization has been paused by the controller due to the state of the alternate controller.
       * @const
       * @type {string}
       */
      arvmSyncPausedAltState: 'arvmSyncPausedAltState',

      /**
       * Role change has paused due to issues with required data synchronization.
       * @const
       * @type {string}
       */
      arvmRoleChangePaused: 'arvmRoleChangePaused',

      /**
       * The lowest aligned LBA for the physical sector of an emulation was found to be non-zero and is therefore not supported.
       * @const
       * @type {string}
       */
      driveIncompatibleAlignmentForEmulationDrive: 'driveIncompatibleAlignmentForEmulationDrive',

      /**
       * One or more Soyuz expansion channels are not externally connected to the alternate controller due to cabling or expansion tray power issues. One or both of the controllers may have completely lost access to one or more expansion trays.
       * @const
       * @type {string}
       */
      lossOfExternalRedundancy: 'lossOfExternalRedundancy',

      /**
       * The primary array is functioning in an asynchronous write mode but the secondary is set to synchronous write mode.
       * @const
       * @type {string}
       */
      rvmWriteModeInconsistent: 'rvmWriteModeInconsistent',

      /**
       * The controller detected an HBA cabled to a drive channel. To protect the array, the controller will attempt to disable the SAS port within the array that is attached to the HBA.
       * @const
       * @type {string}
       */
      sasHostMiswire: 'sasHostMiswire',

      /**
       * The controller detected that the two drive channels have been wired together. To protect the array, the controller will attempt to disable the expansion ports for one of the drive channels.
       * @const
       * @type {string}
       */
      sasCrossMiswire: 'sasCrossMiswire',

      /**
       * The controller detected a loop in the SAS domain that constitutes a drive channel. To protect the array, the controller will attempt to break the loop by disabling the expansion-out ports on the affected channel.
       * @const
       * @type {string}
       */
      sasLoopMiswire: 'sasLoopMiswire',

      /**
       * A copy then fail operation is waiting on the user to identify a suitable hot spare drive.
       * @const
       * @type {string}
       */
      copyThenFailWaitingOnHotSpare: 'copyThenFailWaitingOnHotSpare',

      /**
       * This is present if a controller is locked down due to detecting enough missing drives that if left alone would result in failed volumes. This may be the result of an enclosure power loss or cable connection problem.
       * @const
       * @type {string}
       */
      missingDriveLockdown: 'missingDriveLockdown',

      /**
       * This recovery failure type is logged when the HICs on a controller collectively support more than two interface protocols.
       * @const
       * @type {string}
       */
      hicConfigurationOoc: 'hicConfigurationOoc',

      /**
       * The copy then fail operation is waiting for additional capacity in the disk pool.
       * @const
       * @type {string}
       */
      copyThenFailWaitingOnDdpCapacity: 'copyThenFailWaitingOnDdpCapacity',

      /**
       * The controller has automatically gone into service mode due to the detection of a PI error.
       * @const
       * @type {string}
       */
      piErrorServiceMode: 'piErrorServiceMode',

      /**
       * The controller has gone into lockdown mode due to the detection of PI errors on all controllers in the array.
       * @const
       * @type {string}
       */
      piErrorLockdown: 'piErrorLockdown',

      /**
       * The controller has detected an error on the backend SAS channel during the SAS discovery phase.
       * @const
       * @type {string}
       */
      sasPortDiscoveryError: 'sasPortDiscoveryError',

      /**
       * Unable to resolve the domain name given for the Primary or Secondary NTP Server
       * @const
       * @type {string}
       */
      netNtpResolutionFail: 'netNtpResolutionFail',

      /**
       * NTP Server unavailable or SNTP query failed
       * @const
       * @type {string}
       */
      netNtpQueryFail: 'netNtpQueryFail',

      /**
       * The Primary and Secondary configured NTP server names cannot be resolved, or cannot be reached, or the queries fail.
       * @const
       * @type {string}
       */
      netNtpServiceUnavailable: 'netNtpServiceUnavailable',

      /**
       * The multipath driver for the specified host is not behaving as expected, indicating either the host type is incorrect or there is a configuration issue on the host.
       * @const
       * @type {string}
       */
      multipathConfigurationError: 'multipathConfigurationError',

      /**
       * The specified host has lost connectivity with one controller in the array.
       * @const
       * @type {string}
       */
      hostRedundancyLost: 'hostRedundancyLost',

      /**
       * This Recovery Guru is raised when excessive controller reboots have been detected.
       * @const
       * @type {string}
       */
      excessiveRebootsDetected: 'excessiveRebootsDetected',

      /**
       * The specified controller fails to flush dirty cache data on failed volume(s) possibly due to offlined drives. Replacing the controller may result in loss of data.
       * @const
       * @type {string}
       */
      cacheNotFlushedOnOnlyCtlr: 'cacheNotFlushedOnOnlyCtlr',

      /**
       * The Security Audit Log has reached its maximum capacity and the Full Policy is set to 'Manually Clear'. No new Security Audit Log entries can be stored until the log is cleared.
       * @const
       * @type {string}
       */
      securityAuditLogFull: 'securityAuditLogFull',

      /**
       * The Security Audit Log size has reached its warning threshold and the Full Policy is set to 'Manually Clear'. The log should be cleared now to avoid losing log entries.
       * @const
       * @type {string}
       */
      securityAuditLogWarnThresh: 'securityAuditLogWarnThresh',

      /**
       * The Directory Services Server is misconfigured or unreachable.
       * @const
       * @type {string}
       */
      directoryServicesConfigError: 'directoryServicesConfigError',

      /**
       * The storage administrator should update the certificate in question prior to expiration to prevent a potential loss of data access.
       * @const
       * @type {string}
       */
      kmipServerCertificateNearingExpiration: 'kmipServerCertificateNearingExpiration',

      /**
       * The storage administrator should update the certificate in question.
       * @const
       * @type {string}
       */
      kmipServerCertificateExpired: 'kmipServerCertificateExpired',

      /**
       * The storage administrator should check that the DNS server is reachable and that the provided KMIP server name is valid.
       * @const
       * @type {string}
       */
      kmipServerDnsError: 'kmipServerDnsError',

      /**
       * The storage administrator should check the certificates installed on the storage array as well as the KMIP server itself to ensure that the certificates are valid.
       * @const
       * @type {string}
       */
      kmipServerCertificateError: 'kmipServerCertificateError',

      /**
       * The storage administrator should check to make sure that both the storage array and KMIP server have the correct certificates for authentication. The KMIP server address and port number being used by the storage array should also be checked.
       * @const
       * @type {string}
       */
      kmipServerAuthenticationFailure: 'kmipServerAuthenticationFailure',

      /**
       * The storage administrator should check the connectivity between the storage array and the KMIP server.
       * @const
       * @type {string}
       */
      kmipServerConnectionFailure: 'kmipServerConnectionFailure',

      /**
       * The storage administrator should check the KMIP server to ensure that it is functioning correctly.
       * @const
       * @type {string}
       */
      kmipServerError: 'kmipServerError',

      /**
       * A key requirement has not been satisfied on the KMIP server.
       * @const
       * @type {string}
       */
      kmipServerKeyRequirementNotMet: 'kmipServerKeyRequirementNotMet',

      /**
       * The storage administrator needs to ensure the certificate authorities OCSP (On-line Certificate Status Protocol) responder address is reachable from within their network.
       * @const
       * @type {string}
       */
      ocspResponderUnreachable: 'ocspResponderUnreachable',

      /**
       * The storage administrator should update the certificate in question.
       * @const
       * @type {string}
       */
      certificateRevoked: 'certificateRevoked',

      /**
       * An event has occurred on an SSD causing it to lose data; the error is recoverable at the volume level.
       * @const
       * @type {string}
       */
      ssdDataLoss: 'ssdDataLoss',

      /**
       * Automatic fast format of replacement drive failed.
       * @const
       * @type {string}
       */
      driveFastFormatFailed: 'driveFastFormatFailed',

      /**
       * Drive fast format suspended due to lack of valid configuration database.
       * @const
       * @type {string}
       */
      driveFastFormatSuspendNoDatabase: 'driveFastFormatSuspendNoDatabase',

      /**
       * Write through interrupted write logging is slowed due to hardware failures (e.g. failed battery, failed drives).
       * @const
       * @type {string}
       */
      slowInterruptedWriteLogging: 'slowInterruptedWriteLogging',

      /**
       * The specified drive is physically inaccessible by one controller in the array.
       * @const
       * @type {string}
       */
      driveLostPrimaryPath: 'driveLostPrimaryPath',

      /**
       * The controller detected that an NVMe drive is operating at less than its optimal PCIe link speed on one or more drive ports.
       * @const
       * @type {string}
       */
      nvmeDriveSpeedError: 'nvmeDriveSpeedError',

      /**
       * Drive user assignment has failed to prepare the drive for security capabilities.
       * @const
       * @type {string}
       */
      driveUserAssignmentFailed: 'driveUserAssignmentFailed',

      /**
       * The cache backup device has reached the end of its useful life.
       * @const
       * @type {string}
       */
      cacheBackupDeviceAtEndOfLife: 'cacheBackupDeviceAtEndOfLife',

      /**
       * The Container Microservices signature check has failed.
       * @const
       * @type {string}
       */
      cbaSignatureFailed: 'cbaSignatureFailed',

      /**
       * This controller has detected an NVSRAM version mismatch with the alternate controller.
       * @const
       * @type {string}
       */
      nvsramMismatch: 'nvsramMismatch',

      /**
       * Failure indicates that even though wide ports may be optimal there is a non optimal cabling configuration that has occured in the topology. This can indicate that there are less physical connections than expected between two devices which could decrease bandwidth during IO.
       * @const
       * @type {string}
       */
      sasPathNonOptimal: 'sasPathNonOptimal',

      /**
       * Link issues have been observed on the intercontroller communications channel used for operations considered of secondary importance to the ongoing operations of the primary storage capabilities of the array.
       * @const
       * @type {string}
       */
      auxAltCommLinkError: 'auxAltCommLinkError',

      /**
       * Link issues have been observed on the intercontroller communications channel used for operations considered of primary importance to the ongoing operations of the primary storage capabilities of the array.
       * @const
       * @type {string}
       */
      altCommLinkError: 'altCommLinkError',

      /**
       * Triggered when a Remote Target Group is down.
       * @const
       * @type {string}
       */
      rtgLinkDown: 'rtgLinkDown',

      /**
       * Triggered when a Remote Target Volume's link is down.
       * @const
       * @type {string}
       */
      rtvLinkDown: 'rtvLinkDown',

      /**
       * The Disk Pool's poolVersion is not supported by this release.
       * @const
       * @type {string}
       */
      diskPoolInvalidVersion: 'diskPoolInvalidVersion',

      /**
       * A newly inserted drive is in an unverified state.
       * @const
       * @type {string}
       */
      driveFwUnverified: 'driveFwUnverified'
   },

   /**
    * This enumeration is used to specify the type of schedule recurrence.
    * @enum {string}
    */
   RecurrenceType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The schedule will repeat without stopping.
       * @const
       * @type {string}
       */
      unlimited: 'unlimited',

      /**
       * The schedule will stop after N days, weeks, or months.
       * @const
       * @type {string}
       */
      count: 'count',

      /**
       * The schedule will stop after a specified date.
       * @const
       * @type {string}
       */
      endDate: 'endDate'
   },

   /**
    * These types indicate the Remote Target Group's status.
    * @enum {string}
    */
   RemoteTargetGroupStatus: {
      /**
       * A Remote Target Group is in an unknown state.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * A Remote Target Group is in an online state.
       * @const
       * @type {string}
       */
      online: 'online',

      /**
       * A Remote Target Group failed to initially connect to the target.
       * @const
       * @type {string}
       */
      failedToConnect: 'failedToConnect',

      /**
       * A Remote Target Group initially connected, but lost the connection.
       * @const
       * @type {string}
       */
      lostConnection: 'lostConnection'
   },

   /**
    * This enumeration specifies the remote target group type
    * @enum {string}
    */
   RemoteTargetGroupType: {
      /**
       * Unknown type
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * AWS Gateway type
       * @const
       * @type {string}
       */
      awsGateway: 'awsGateway',

      /**
       * ESeries type
       * @const
       * @type {string}
       */
      eseries: 'eseries',

      /**
       * Generic (unmanaged) remote target
       * @const
       * @type {string}
       */
      genericTarget: 'genericTarget'
   },

   /**
    * The status associated with a RemoteTargetVolume
    * @enum {string}
    */
   RemoteTargetVolumeStatus: {
      /**
       * Unknown status
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Online status
       * @const
       * @type {string}
       */
      online: 'online',

      /**
       * Offline status
       * @const
       * @type {string}
       */
      offline: 'offline'
   },

   /**
    * These types indicate a Remote Target Volume's reason for its current status.
    * @enum {string}
    */
   RemoteTargetVolumeStatusReason: {
      /**
       * A Remote Target Volume is in an unknown state.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * A Remote Target Volume is in an online state.
       * @const
       * @type {string}
       */
      online: 'online',

      /**
       * Inquiry data does not match what is expected. This indicates that the remote target volume's WWN does not match its initial value.
       * @const
       * @type {string}
       */
      incorrectInquiryData: 'incorrectInquiryData',

      /**
       * The Remote Target Volume's block size is invalid.
       * @const
       * @type {string}
       */
      invalidBlockSize: 'invalidBlockSize',

      /**
       * A Remote Target Volume failed to initially connect.
       * @const
       * @type {string}
       */
      failedToConnect: 'failedToConnect',

      /**
       * A Remote Target Volume connected, but then lost the connection.
       * @const
       * @type {string}
       */
      lostConnection: 'lostConnection',

      /**
       * The capacity of the Remote Target Volume was modified after creation.
       * @const
       * @type {string}
       */
      invalidCapacity: 'invalidCapacity'
   },

   /**
    * This enumeration object is used to specify the state of the remote volume.
    * @enum {string}
    */
   RemoteVolumeState: {
      /**
       * The volume on the remote array is accessible.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * Cannot access LUN on remote array.
       * @const
       * @type {string}
       */
      noLun: 'noLun',

      /**
       * Cannot access remote array.
       * @const
       * @type {string}
       */
      noArray: 'noArray',

      /**
       * Cannot connect to fabric.
       * @const
       * @type {string}
       */
      noFabric: 'noFabric',

      /**
       * In the process of connecting to a remote array.
       * @const
       * @type {string}
       */
      initializing: 'initializing',

      /**
       * The WWN change failed.
       * @const
       * @type {string}
       */
      wwnChangeFailed: 'wwnChangeFailed'
   },

   /**
    * This enumeration object is used to specify the policy to apply when the repository is full and cluster allocation fails.
    * @enum {string}
    */
   RepositoryFullPolicy: {
      /**
       * The policy is to fail writes to the base or snapshot when repository space allocation fails.
       * @const
       * @type {string}
       */
      failwrites: 'failwrites',

      /**
       * The policy is to fail snapshots when REPOSITORY space allocation fails.
       * @const
       * @type {string}
       */
      failsnap: 'failsnap'
   },

   /**
    * This enumeration object is used to specify the reservation types.
    * @enum {string}
    */
   ReservationTypeID: {
      /**
       * No reservation.
       * @const
       * @type {string}
       */
      noReservation: 'noReservation',

      /**
       * Write exclusive.
       * @const
       * @type {string}
       */
      writeExcl: 'writeExcl',

      /**
       * Exclusive access.
       * @const
       * @type {string}
       */
      exclAccess: 'exclAccess',

      /**
       * Write exclusive registrants only.
       * @const
       * @type {string}
       */
      writeExclRegOnly: 'writeExclRegOnly',

      /**
       * Exclusive access registrants only.
       * @const
       * @type {string}
       */
      exclAccessRegOnly: 'exclAccessRegOnly',

      /**
       * Write exclusive all registrants.
       * @const
       * @type {string}
       */
      writeExclAllReg: 'writeExclAllReg',

      /**
       * Exclusive access all registrants.
       * @const
       * @type {string}
       */
      exclAccessAllReg: 'exclAccessAllReg'
   },

   /**
    * This enumeration object is used to specify the reservation types.
    * @enum {string}
    */
   ReservedPortID: {
      /**
       * No ports.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * All ports.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * Port A0.
       * @const
       * @type {string}
       */
      a0: 'a0',

      /**
       * Port A1.
       * @const
       * @type {string}
       */
      a1: 'a1',

      /**
       * Port B0.
       * @const
       * @type {string}
       */
      b0: 'b0',

      /**
       * Port B1.
       * @const
       * @type {string}
       */
      b1: 'b1'
   },

   /**
    * This enumeration specifies the different options for the resetSAConfiguration procedure call.
    * @enum {string}
    */
   ResetConfigType: {
      /**
       * This option removes the entire configuration of the storage array, including the storage array world-wide unique identifier. This operation causes any SYMbol client connections to be dropped, making it necessary for clients to delete their connections, re-discover the array and reinstate the connections. NOTE: This option preserves both manufacturing and user applied feature bundle keys so the feature bundle behavior will be retained after the reset.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * This option removes all aspects of the storage array configuration, except for those related to identification and security. Enters on board backup freeze.
       * @const
       * @type {string}
       */
      storageArray: 'storageArray',

      /**
       * This option only removes the volume and volume group configuration, while leaving the rest of the configuration intact. Enters on board backup freeze.
       * @const
       * @type {string}
       */
      volumeGroups: 'volumeGroups',

      /**
       * This option performs all the actions of a CLEAR_ALL plus clears additional parameters necessary to return the array to factory configuration. This includes but is not limited to management network configuration parameters.
       * @const
       * @type {string}
       */
      allFactoryReset: 'allFactoryReset',

      /**
       * This option performs all the actions of a CLEAR_ALL_FACTORY_RESET plus clears additional parameters including but not limited to applied feature bundle keys. This option is intended to be used a part of a support-assisted reset of the configuration when the array becomes inoperable due to unrecoverable corruption of one or more persistent configuration parameters.
       * @const
       * @type {string}
       */
      allSupportReset: 'allSupportReset'
   },

   /**
    * This enumeration is used to specify the priority of the rollback data copy process.
    * @enum {string}
    */
   RollbackPriority: {
      /**
       * The highest level of I/O activity.
       * @const
       * @type {string}
       */
      highest: 'highest',

      /**
       * The next to highest level of I/O activity.
       * @const
       * @type {string}
       */
      high: 'high',

      /**
       * The medium level of I/O activity.
       * @const
       * @type {string}
       */
      medium: 'medium',

      /**
       * The next to lowest level of I/O activity.
       * @const
       * @type {string}
       */
      low: 'low',

      /**
       * The lowest level of I/O activity.
       * @const
       * @type {string}
       */
      lowest: 'lowest'
   },

   /**
    * This enumeration defines the runtime diagnostic tests.
    * @enum {string}
    */
   RuntimeDiagTestID: {
      /**
       * Run all the diagnostic tests.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * Run the diagnostics read test
       * @const
       * @type {string}
       */
      read: 'read',

      /**
       * Loopback Test Data
       * @const
       * @type {string}
       */
      loopbackData: 'loopbackData',

      /**
       * Write test
       * @const
       * @type {string}
       */
      write: 'write'
   },

   /**
    * This enumeration defines the runtime diagnostics test levels.
    * @enum {string}
    */
   RuntimeDiagTestLevel: {
      /**
       * A modified internal test was run.
       * @const
       * @type {string}
       */
      internal: 'internal',

      /**
       * A full test was run.
       * @const
       * @type {string}
       */
      external: 'external'
   },

   /**
    * This enumeration defines the potential test statuses returned.
    * @enum {string}
    */
   RuntimeDiagTestStatus: {
      /**
       * The test was not performed.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The test succeeded.
       * @const
       * @type {string}
       */
      success: 'success',

      /**
       * The test failed.
       * @const
       * @type {string}
       */
      failure: 'failure'
   },

   /**
    * This enumeration defines the Storage Array attributes. It is used to fill in the "attribute" part of the attribute-value pairs in the arrayAttributes field of the SAData structure.
    * @enum {string}
    */
   SAAttributeID: {
      /**
       * Unused.
       * @const
       * @type {string}
       */
      unused: 'unused',

      /**
       * The following values should be used to specify the OEM in the SAData arrayAttributes key/value pair: 0 = Generic/Catera OEM 1 = Apollo OEM 2 = Accent OEM 3 = Mercury OEM 4 = NetApp OEM This must only be visible in the Internal Master spec..
       * @const
       * @type {string}
       */
      oemSpecificArrayType: 'oemSpecificArrayType',

      /**
       * The attribute indicates the type of management applications allowed for this array. Values for the attribute are specified by the MgmtApplicationType enumeration.
       * @const
       * @type {string}
       */
      mgmtApplicationType: 'mgmtApplicationType',

      /**
       * The attribute indicates whether or not the array is locked down. The value of the attribute is set to 1 if a controller in the array is locked down, otherwise the value is set to 0.
       * @const
       * @type {string}
       */
      controllerLockedDown: 'controllerLockedDown',

      /**
       * The attribute indicates whether or not the database is recovery mode. The value of the attribute is set to 1 if the database is in recovery mode, otherwise the value is set to 0.
       * @const
       * @type {string}
       */
      databaseRecoveryMode: 'databaseRecoveryMode',

      /**
       * This attribute key is added to the attribute list and the value is set to 1 (TRUE) if the controller is currently operating in T10 PI Analysis Lockdown mode.
       * @const
       * @type {string}
       */
      t10PiAnalysisLockdown: 't10PiAnalysisLockdown',

      /**
       * Designates an array running vEOS.
       * @const
       * @type {string}
       */
      veosArray: 'veosArray',

      /**
       * This indicates that the controller is able to accept message authentication using SHA256 message authentication code in messages with the auth flavor set to SYMBOL_AUTH_HMAC256.
       * @const
       * @type {string}
       */
      symbolAuthHmac256Support: 'symbolAuthHmac256Support',

      /**
       * When CONTROLLER_LOCKED_DOWN attribute is set to 1, this attribute indicates which type of lockdown has occurred (i.e., the cause of the lockdown). Values for the attribute are specified by the LockdownCause enumeration.
       * @const
       * @type {string}
       */
      controllerLockdownCause: 'controllerLockdownCause',

      /**
       * The presence of this attribute indicates the alt controller is in lockdown and the value is the lockdown cause.
       * @const
       * @type {string}
       */
      altControllerLockdownCause: 'altControllerLockdownCause',

      /**
       * CONTROLLER_UNAVAILABLE being set indicates that the controller is in a state that prevents normal symbol support likely due to no drives available or no database.
       * @const
       * @type {string}
       */
      controllerUnavailable: 'controllerUnavailable',

      /**
       * ALT_CONTROLLER_UNAVAILABLE being set indicates that the alt controller is in a state that prevents normal symbol support likely due to no drives available or no database.
       * @const
       * @type {string}
       */
      altControllerUnavailable: 'altControllerUnavailable'
   },

   /**
    * This enumeration is used to identify SAS port connection modes.
    * @enum {string}
    */
   SASPortMode: {
      /**
       * The SAS port mode is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The SAS port is internally connected.
       * @const
       * @type {string}
       */
      internal: 'internal',

      /**
       * The SAS port is connected from an external expander.
       * @const
       * @type {string}
       */
      externalIn: 'externalIn',

      /**
       * The SAS port is connected to an external expander.
       * @const
       * @type {string}
       */
      externalOut: 'externalOut',

      /**
       * The SAS port is connected to an end device.
       * @const
       * @type {string}
       */
      endDevice: 'endDevice',

      /**
       * The SAS port is not used.
       * @const
       * @type {string}
       */
      open: 'open'
   },

   /**
    * This enumeration defines the different SCSI driver types that may be reported as part of the I/O interface information associated with a controller.
    * @enum {string}
    */
   SCSIDriverType: {
      /**
       * Single-ended SCSI driver type.
       * @const
       * @type {string}
       */
      se: 'se',

      /**
       * High-voltage differential SCSI driver type.
       * @const
       * @type {string}
       */
      hvd: 'hvd',

      /**
       * Low-voltage differential SCSI driver type.
       * @const
       * @type {string}
       */
      lvd: 'lvd'
   },

   /**
    * This enumeration type identifies the various supported transport-specific SCSI Command Protocols.
    * @enum {string}
    */
   SCSIProtocolType: {
      /**
       * The SCSI protocol is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The SCSI protocol is Serial-attached SCSI (SAS).
       * @const
       * @type {string}
       */
      sas: 'sas',

      /**
       * The SCSI protocol is Fibre Channel Protocol (FCP).
       * @const
       * @type {string}
       */
      fcp: 'fcp',

      /**
       * The SCSI protocol is iSCSI.
       * @const
       * @type {string}
       */
      iscsi: 'iscsi',

      /**
       * The SCSI protocol is SCSI RDMA Protocol (SRP).
       * @const
       * @type {string}
       */
      srp: 'srp',

      /**
       * The SCSI protocol is iSCSI Extensions for RDMA (iSER).
       * @const
       * @type {string}
       */
      iser: 'iser'
   },

   /**
    * This enumeration object is used to describe the parent type of a SFP.
    * @enum {string}
    */
   SFPParentType: {
      /**
       * The SFP parent type is not known.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The SFP parent type is a component.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The SFP parent type is a minihub.
       * @const
       * @type {string}
       */
      minihub: 'minihub',

      /**
       * The SFP parent type is a controller.
       * @const
       * @type {string}
       */
      controller: 'controller'
   },

   /**
    * This enumeration object is used to describe the port number a given SFP is associated with.
    * @enum {string}
    */
   SFPPort: {
      /**
       * The firmware cannot determine the SFP port association.
       * @const
       * @type {string}
       */
      portUnknown: 'portUnknown',

      /**
       * The SFP is associated with the first port.
       * @const
       * @type {string}
       */
      port1: 'port1',

      /**
       * The SFP is associated with the second port.
       * @const
       * @type {string}
       */
      port2: 'port2',

      /**
       * The SFP is associated with the third port.
       * @const
       * @type {string}
       */
      port3: 'port3',

      /**
       * The SFP is associated with the fourth port.
       * @const
       * @type {string}
       */
      port4: 'port4'
   },

   /**
    * This enumeration object is used to determine the status of the SFP component.
    * @enum {string}
    */
   SFPStatus: {
      /**
       * The SFP is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The SFP is not working or not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The SFP has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the SFP is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * This enumeration object is used to determine the connector type of SFP component as per SFF-8436 Specification for QSFP+ 10 Gbs 4X PLUGGABLE TRANSCEIVER Rev 4.3 July 7, 2012, Table "Connector Values".
    * @enum {string}
    */
   SFP_CONNECT_TYPE: {
      /**
       * SFP connector type unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * SFP connector type SC.
       * @const
       * @type {string}
       */
      sc: 'sc',

      /**
       * The SFP connect type is FCS1CC
       * @const
       * @type {string}
       */
      fcs1cc: 'fcs1cc',

      /**
       * The SFP connect type is FCS2CC
       * @const
       * @type {string}
       */
      fcs2cc: 'fcs2cc',

      /**
       * The SFP connect type is BNC or TNC.
       * @const
       * @type {string}
       */
      bncortnc: 'bncortnc',

      /**
       * The SFP connect type is FC COAX.
       * @const
       * @type {string}
       */
      fcCoax: 'fcCoax',

      /**
       * The SFT connect type is F JACK.
       * @const
       * @type {string}
       */
      fJack: 'fJack',

      /**
       * The SFP connect type is LC
       * @const
       * @type {string}
       */
      lc: 'lc',

      /**
       * The SFP connect type is MT RJ.
       * @const
       * @type {string}
       */
      mtRj: 'mtRj',

      /**
       * The SFP connect type is MU.
       * @const
       * @type {string}
       */
      mu: 'mu',

      /**
       * The SFP connect type is SG.
       * @const
       * @type {string}
       */
      sg: 'sg',

      /**
       * The SFP connect type is OPT PIGTAIL.
       * @const
       * @type {string}
       */
      optPigtail: 'optPigtail',

      /**
       * The SFP connect type is HSSDCII
       * @const
       * @type {string}
       */
      hssdcii: 'hssdcii',

      /**
       * The SFP connect type is COP PIGTAIL.
       * @const
       * @type {string}
       */
      copPigtail: 'copPigtail',

      /**
       * The SFP connect type is RJ45.
       * @const
       * @type {string}
       */
      rj45: 'rj45',

      /**
       * The current SFP type does not have a separable connector.
       * @const
       * @type {string}
       */
      noSeparableConnector: 'noSeparableConnector'
   },

   /**
    * This enumeration is used to determine the Identifier type of SFP. The following enumeration values are defined:
    * @enum {string}
    */
   SFP_IDENT_TYPE: {
      /**
       * SFP type unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * SFP type GBIC.
       * @const
       * @type {string}
       */
      gbic: 'gbic',

      /**
       * SFP type Soldered.
       * @const
       * @type {string}
       */
      soldered: 'soldered',

      /**
       * SFP type SFP.
       * @const
       * @type {string}
       */
      sfp: 'sfp'
   },

   /**
    * This enumeration object is used to determine the Fibre Channel Link Length. See SFF-8436 Specification for QSFP+ 10 Gbs 4X PLUGGABLE TRANCEIVER Rev 4.3 July 7, 2012 Table "Table 33 - Specification compliance (Address 131-138) (Page 00), "Fibre Channel Link Length/Transmitter Technology".
    * @enum {string}
    */
   SFP_LINKL_TYPE: {
      /**
       * Link Length unknown.
       * @const
       * @type {string}
       */
      typeUnknown: 'typeUnknown',

      /**
       * Link Length Very Long.
       * @const
       * @type {string}
       */
      typeVlong: 'typeVlong',

      /**
       * Link Length Short.
       * @const
       * @type {string}
       */
      typeShort: 'typeShort',

      /**
       * Link Length Intermediate.
       * @const
       * @type {string}
       */
      typeIntermediate: 'typeIntermediate',

      /**
       * Link Length Long.
       * @const
       * @type {string}
       */
      typeLong: 'typeLong',

      /**
       * Link length medium.
       * @const
       * @type {string}
       */
      typeMedium: 'typeMedium',

      /**
       * For the current SFP Type, the concept of a Link Length is not applicable. MSW will not show a link length.
       * @const
       * @type {string}
       */
      typeNa: 'typeNa'
   },

   /**
    * This enumeration object is used to determine the speed capability of SFP. Note: This is a bit field as more than one can be true simultaneously. See "SFF-8636 Specification for Common Management Interface Rev 4.3", Table "Specification Compliance" and "SFF-8636 Specification for Common Management Interface" Rev 1.7 Table: "EXTENDED MODULE CODE VALUES"
    * @enum {string}
    */
   SFP_SPEED: {
      /**
       * Unknown
       * @const
       * @type {string}
       */
      typeUnknown: 'typeUnknown',

      /**
       * 0x00000001
       * @const
       * @type {string}
       */
      type1gig: 'type1gig',

      /**
       * 0x00000002
       * @const
       * @type {string}
       */
      type2gig: 'type2gig',

      /**
       * 0x00000004
       * @const
       * @type {string}
       */
      type4gig: 'type4gig',

      /**
       * 0x00000008
       * @const
       * @type {string}
       */
      type8gig: 'type8gig',

      /**
       * 0x00000010
       * @const
       * @type {string}
       */
      type16gig: 'type16gig',

      /**
       * 0x00000020
       * @const
       * @type {string}
       */
      type10gig: 'type10gig',

      /**
       * null
       * @const
       * @type {string}
       */
      type40gig: 'type40gig',

      /**
       * null
       * @const
       * @type {string}
       */
      type56gig: 'type56gig',

      /**
       * null
       * @const
       * @type {string}
       */
      type20gig: 'type20gig',

      /**
       * 25 Gbit per second.
       * @const
       * @type {string}
       */
      type25gig: 'type25gig',

      /**
       * 32 Gbit per second.
       * @const
       * @type {string}
       */
      type32gig: 'type32gig',

      /**
       * 100 Gbit per second.
       * @const
       * @type {string}
       */
      type100gig: 'type100gig',

      /**
       * 50 Gbit per second.
       * @const
       * @type {string}
       */
      type50gig: 'type50gig',

      /**
       * 200 Gbit per second.
       * @const
       * @type {string}
       */
      type200gig: 'type200gig',

      /**
       * 64 Gbit per second.
       * @const
       * @type {string}
       */
      type64gig: 'type64gig'
   },

   /**
    * This enumeration object is used to determine the transmission media of SFP component. This is a bit field as more than one can be true simultaneously.
    * @enum {string}
    */
   SFP_TRANSMISSION_MEDIA: {
      /**
       * Unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Twin Axial Pair.
       * @const
       * @type {string}
       */
      twinAxialPair: 'twinAxialPair',

      /**
       * Shielded Twisted Pair.
       * @const
       * @type {string}
       */
      tmShieldedTwistedPair: 'tmShieldedTwistedPair',

      /**
       * TM Miniature Coax.
       * @const
       * @type {string}
       */
      tmMiniatureCoax: 'tmMiniatureCoax',

      /**
       * TM Video Coax.
       * @const
       * @type {string}
       */
      tmVideoCoax: 'tmVideoCoax',

      /**
       * TM Multi-mode 62.5m(M6).
       * @const
       * @type {string}
       */
      tmMultiModeM6: 'tmMultiModeM6',

      /**
       * TM Multi-mode 50m(M5).
       * @const
       * @type {string}
       */
      tmMultiModeM5: 'tmMultiModeM5',

      /**
       * Single Mode.
       * @const
       * @type {string}
       */
      tmSingleMode: 'tmSingleMode',

      /**
       * For the current SFP type the concept of a transmission media type is not applicable. MSW will not show a transmission media type.
       * @const
       * @type {string}
       */
      na: 'na'
   },

   /**
    * This enumeration object is used to determine the Fibre Channel Transmitter Technology. See SFF-8436 Specification for QSFP+ 10 Gbs 4X PLUGGABLE TRANSCEIVER Rev 4.3 July 7, 2012 Table "Table 33 - Specification compliance (Address 131-138) (Page 00), "Fibre Channel Link Length/Transmitter Technology".
    * @enum {string}
    */
   SFP_TRANSMITTER_TYPE: {
      /**
       * Unknown transmitter type.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Long wave laser.
       * @const
       * @type {string}
       */
      lwlLc: 'lwlLc',

      /**
       * Electrical Inter-Enclosure.
       * @const
       * @type {string}
       */
      eiee: 'eiee',

      /**
       * Electrical Intra-Enclosure.
       * @const
       * @type {string}
       */
      eiae: 'eiae',

      /**
       * ShortWave Laser without OFC.
       * @const
       * @type {string}
       */
      swlwoofc: 'swlwoofc',

      /**
       * ShortWave Laser with OFC.
       * @const
       * @type {string}
       */
      swlwofc: 'swlwofc',

      /**
       * LongWave Laser.
       * @const
       * @type {string}
       */
      lwlLl: 'lwlLl',

      /**
       * Not applicable for non-Fibre Channel SFPs.
       * @const
       * @type {string}
       */
      na: 'na'
   },

   /**
    * This enumeration defines the SNMP USM authentication protocols.
    * @enum {string}
    */
   SNMPAuthProtocol: {
      /**
       * No authentication protocol is being used.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The HMAC-SHA authentication protocol is being used.
       * @const
       * @type {string}
       */
      hmacSha: 'hmacSha',

      /**
       * The HMAC-SHA-256 authentication protocol is being used.
       * @const
       * @type {string}
       */
      hmacSha256: 'hmacSha256',

      /**
       * The HMAC-SHA-512 authentication protocol is being used.
       * @const
       * @type {string}
       */
      hmacSha512: 'hmacSha512'
   },

   /**
    * This enumeration identifies the SNMP community permissions.
    * @enum {string}
    */
   SNMPCommunityPermissions: {
      /**
       * The community permissions are unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The community permissions are read only.
       * @const
       * @type {string}
       */
      readOnly: 'readOnly',

      /**
       * The community permissions are read/write. Note that although the notion of a read-write permission exists, the controller does not support SNMP SET operations so effectively everything is read-only.
       * @const
       * @type {string}
       */
      readWrite: 'readWrite'
   },

   /**
    * This enumeration defines the type of SNMP engine ID being used.
    * @enum {string}
    */
   SNMPEngineIdType: {
      /**
       * No engine ID is being used.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The local engine ID is being used.
       * @const
       * @type {string}
       */
      local: 'local',

      /**
       * A custom engine ID is being used.
       * @const
       * @type {string}
       */
      custom: 'custom'
   },

   /**
    * This enumeration defines the SNMP principal security model being used.
    * @enum {string}
    */
   SNMPPrincipalType: {
      /**
       * No principal protocol version is being used.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Community (SNMPv2c) is being used as the principal security model.
       * @const
       * @type {string}
       */
      community: 'community',

      /**
       * USM user (SNMPv3) is being used as the principal security model.
       * @const
       * @type {string}
       */
      usmUser: 'usmUser'
   },

   /**
    * This enumeration defines the SNMP USM privacy protocols.
    * @enum {string}
    */
   SNMPPrivProtocol: {
      /**
       * No privacy protocol is being used.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * AES128 is being used for the privacy protocol.
       * @const
       * @type {string}
       */
      aes128: 'aes128'
   },

   /**
    * This enumeration defines the SNMP USM security levels.
    * @enum {string}
    */
   SNMPSecurityLevel: {
      /**
       * No authentication protocol nor privacy protocol is being used.
       * @const
       * @type {string}
       */
      noauthNopriv: 'noauthNopriv',

      /**
       * An authentication protocol is being used, but no privacy protocol is.
       * @const
       * @type {string}
       */
      authNopriv: 'authNopriv',

      /**
       * Both an authentication protocol and a privacy protocol are being used.
       * @const
       * @type {string}
       */
      authPriv: 'authPriv'
   },

   /**
    * This enumeration represents possible SNMP system variables that can be set via SYMbol.
    * @enum {string}
    */
   SNMPSystemVariableID: {
      /**
       * The SNMP system variable is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The SNMP system variable is sysname.
       * @const
       * @type {string}
       */
      sysname: 'sysname',

      /**
       * The SNMP system variable is syscontact.
       * @const
       * @type {string}
       */
      syscontact: 'syscontact',

      /**
       * The SNMP system variable is syslocation.
       * @const
       * @type {string}
       */
      syslocation: 'syslocation'
   },

   /**
    * This enumeration identifies the SNMP USM user permissions.
    * @enum {string}
    */
   SNMPUsmUserPermissions: {
      /**
       * The USM user permissions are unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The USM user permissions are read only.
       * @const
       * @type {string}
       */
      readOnly: 'readOnly',

      /**
       * The USM user permissions are read/write.
       * @const
       * @type {string}
       */
      readWrite: 'readWrite'
   },

   /**
    * These statuses indicate the current status of a SSD block allocation scan.
    * @enum {string}
    */
   SSDBlockAllocationScanStatus: {
      /**
       * SSD Block Allocation Scan has not started.
       * @const
       * @type {string}
       */
      notStarted: 'notStarted',

      /**
       * SSD Block Allocation Scan is in progress.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * SSD Block Allocation Scan is complete.
       * @const
       * @type {string}
       */
      complete: 'complete'
   },

   /**
    * Reasons that SAML service assertion was rejected
    * @enum {string}
    */
   SamlServiceAssertionRejectReason: {
      /**
       * Reason for rejecting assertion not specified.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Assertion not from recognized IdP.
       * @const
       * @type {string}
       */
      invalidIdp: 'invalidIdp',

      /**
       * Assertion signature is not valid.
       * @const
       * @type {string}
       */
      signature: 'signature',

      /**
       * Current timestamp is not in specified range.
       * @const
       * @type {string}
       */
      timestamp: 'timestamp',

      /**
       * One-time use specified by IdP.
       * @const
       * @type {string}
       */
      oneTimeUse: 'oneTimeUse',

      /**
       * Session context is invalid.
       * @const
       * @type {string}
       */
      invalidContext: 'invalidContext',

      /**
       * X.509 certificate on file from the IdP is expired.
       * @const
       * @type {string}
       */
      expiredCertificate: 'expiredCertificate',

      /**
       * X.509 certificate on file from the IdP is revoked.
       * @const
       * @type {string}
       */
      revokedCertificate: 'revokedCertificate',

      /**
       * Authenticated user could not be mapped to any roles.
       * @const
       * @type {string}
       */
      invalidMapping: 'invalidMapping'
   },

   /**
    * Event for the SAML service
    * @enum {string}
    */
   SamlServiceEvent: {
      /**
       * The configuration for the IdP has been changed
       * @const
       * @type {string}
       */
      configChange: 'configChange',

      /**
       * The SAML service has been enabled
       * @const
       * @type {string}
       */
      enabled: 'enabled',

      /**
       * The SAML service has been disabled
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The SAML service has rejected an assertion received from an IdP
       * @const
       * @type {string}
       */
      assertionRejected: 'assertionRejected'
   },

   /**
    * This enumeration specifies the different kinds of devices that may be attached to a SAS port.
    * @enum {string}
    */
   SasAttachedDeviceType: {
      /**
       * The attached device is unknown or non-existent.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The attached device is a drive.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * The attached device is a SAS expander.
       * @const
       * @type {string}
       */
      expander: 'expander',

      /**
       * The attached device is the local RAID controller.
       * @const
       * @type {string}
       */
      localController: 'localController',

      /**
       * The attached device is the alternate RAID controller.
       * @const
       * @type {string}
       */
      alternateController: 'alternateController',

      /**
       * The attached device is a host computer.
       * @const
       * @type {string}
       */
      host: 'host'
   },

   /**
    * This enumeration specifies the different types of parent elements a SAS expander may have.
    * @enum {string}
    */
   SasExpanderParentType: {
      /**
       * The parent element is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Parent element is a controller
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The parent element is an ESM.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The parent element is a drawer.
       * @const
       * @type {string}
       */
      drawer: 'drawer'
   },

   /**
    * This enumeration is an enumeration defining the different types of SAS miswires.
    * @enum {string}
    */
   SasMiswireType: {
      /**
       * No miswire condition exists.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The miswire resulted in an invalid SAS topology.
       * @const
       * @type {string}
       */
      topology: 'topology',

      /**
       * The miswire is a result of cabling a controller host port to an expansion drive tray.
       * @const
       * @type {string}
       */
      ctlrHostPort: 'ctlrHostPort',

      /**
       * The miswire is a result of cabling a port on a host computer to a drive expansion port on the controller tray.
       * @const
       * @type {string}
       */
      ctlrDrivePortToHost: 'ctlrDrivePortToHost',

      /**
       * The miswire is a result of the cabling together of the two ESMs in a drive tray.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The miswire is a result of cabling a port on an end device to a drive expansion port on the controller tray.
       * @const
       * @type {string}
       */
      ctlrDrivePortToEndDevice: 'ctlrDrivePortToEndDevice',

      /**
       * The miswire resulted in an invalid SAS topology on Direct Attached Expansion due to an expectation of N phy port configuration where the customer uses cables that are smaller than N phys. This creates an opportunity for the user to create a port configuration with cables in the same port going to different domains, or with cables from different ports going to the same domain.
       * @const
       * @type {string}
       */
      topologyDirect: 'topologyDirect'
   },

   /**
    * This enumeration indicates what kind of non-optimal cabling type has occured with an associated port object. These values are not necessarily failures or degradations like missing phys in a port. These values handle conditions which are not ideal for performance, but do not degrade paths to devices.
    * @enum {string}
    */
   SasNonOptimalCablingType: {
      /**
       * This value indicates that there is no non-optimal condition associated with this port.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * This value indicates that there is a reduced number of connections between two expansion devices. The connections themselves may be optimal, but the number of connections between the two devices is non-optimal. This can cause performance issues during bandwidth related workloads, due to a reduced number of total phys between the two devices.
       * @const
       * @type {string}
       */
      reducedExpPorts: 'reducedExpPorts',

      /**
       * This value indicates that the external channel cabling on one of the controllers in the topology is flipped which will cause both controllers to use the same physical path to end devices. This causes only one of two SAS ports on an end device to be utilized by our controllers. This creates excessive congestion on the SAS topology, and it essentially halves max theoretical bandwidth to a device when all initiators are using the same SAS port.
       * @const
       * @type {string}
       */
      channelReorder: 'channelReorder'
   },

   /**
    * This enumeration object is used to identify the specific type of "port provider" device.
    * @enum {string}
    */
   SasPortProviderDeviceType: {
      /**
       * The port provider device is a RAID controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The port provider device is a drive.
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * The port provider device is a SAS expander.
       * @const
       * @type {string}
       */
      expander: 'expander',

      /**
       * The port provider device is a SAS host board.
       * @const
       * @type {string}
       */
      hostboard: 'hostboard'
   },

   /**
    * This enumeration specifies the different states of a SAS port.
    * @enum {string}
    */
   SasPortState: {
      /**
       * The state of the port is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The state of the port is optimal.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The state of the port is degraded.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The state of the port is failed.
       * @const
       * @type {string}
       */
      failed: 'failed'
   },

   /**
    * This enumeration specifies the different types of SAS ports.
    * @enum {string}
    */
   SasPortType: {
      /**
       * The port is an end device port.
       * @const
       * @type {string}
       */
      endDevice: 'endDevice',

      /**
       * The port is an expander port
       * @const
       * @type {string}
       */
      expander: 'expander'
   },

   /**
    * This enumeration specifies the different types of SAS routing methods.
    * @enum {string}
    */
   SasRoutingType: {
      /**
       * Direct routing method
       * @const
       * @type {string}
       */
      direct: 'direct',

      /**
       * Table routing method
       * @const
       * @type {string}
       */
      table: 'table',

      /**
       * Subtractive routing method
       * @const
       * @type {string}
       */
      subtractive: 'subtractive'
   },

   /**
    * This enumeration specifies the different types of SCSI-to-ATA translation hardware.
    * @enum {string}
    */
   SatType: {
      /**
       * The type of translation hardware is not known.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The translation hardware is drive-CRU-resident.
       * @const
       * @type {string}
       */
      driveCruResident: 'driveCruResident',

      /**
       * The translation hardware is controller-resident.
       * @const
       * @type {string}
       */
      controllerResident: 'controllerResident',

      /**
       * The translation hardware is enclosure-slot-resident.
       * @const
       * @type {string}
       */
      enclosureSlotResident: 'enclosureSlotResident'
   },

   /**
    * This enumeration specifies different types of schedule actions.
    * @enum {string}
    */
   ScheduleAction: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Snapshot scheduling
       * @const
       * @type {string}
       */
      resnap: 'resnap',

      /**
       * Take point in time image in a PiT Group.
       * @const
       * @type {string}
       */
      newpit: 'newpit',

      /**
       * Take point in time image on a PiT Consistency Group.
       * @const
       * @type {string}
       */
      newcgpit: 'newcgpit'
   },

   /**
    * This enumeration specifies the different types of scheduling methods.
    * @enum {string}
    */
   ScheduleMethod: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * This specifies a daily schedule.
       * @const
       * @type {string}
       */
      daily: 'daily',

      /**
       * This specifies a weekly schedule.
       * @const
       * @type {string}
       */
      weekly: 'weekly',

      /**
       * This specifies a monthly date-based schedule.
       * @const
       * @type {string}
       */
      monthlyDate: 'monthlyDate',

      /**
       * This specifies a monthly day-of-week-based schedule.
       * @const
       * @type {string}
       */
      monthlyDay: 'monthlyDay'
   },

   /**
    * This enumeration is used to specify schedule statuses.
    * @enum {string}
    */
   ScheduleStatus: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The schedule is active.
       * @const
       * @type {string}
       */
      active: 'active',

      /**
       * The schedule is disabled.
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The schedule has completed.
       * @const
       * @type {string}
       */
      completed: 'completed'
   },

   /**
    * This enumeration object is used to indicate the role of a SCSI protocol endpoint, either initiator or target.
    * @enum {string}
    */
   ScsiProtocolEndpointRole: {
      /**
       * The role of the SCSI endpoint is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The SCSI endpoint is acting in the initiator role.
       * @const
       * @type {string}
       */
      initiator: 'initiator',

      /**
       * The SCSI endpoint is acting in the target role.
       * @const
       * @type {string}
       */
      target: 'target'
   },

   /**
    * Describes a change in the Security Audit Log status
    * @enum {string}
    */
   SecurityAuditLogEvent: {
      /**
       * The Security Audit Log has been manually cleared
       * @const
       * @type {string}
       */
      cleared: 'cleared',

      /**
       * The Security Audit Full Policy has been changed
       * @const
       * @type {string}
       */
      fullPolicyChg: 'fullPolicyChg',

      /**
       * The Security Audit Log size has reached its warning threshold
       * @const
       * @type {string}
       */
      warnThresh: 'warnThresh',

      /**
       * The Security Audit Log is now full and the full policy is set to 'Manually Clear'
       * @const
       * @type {string}
       */
      full: 'full'
   },

   /**
    * Describes the current 'Full Policy' setting for the Security Audit Log
    * @enum {string}
    */
   SecurityAuditLogFullPolicy: {
      /**
       * The Security Audit Log Full Policy is unknown
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The Security Audit Log Full Policy is set to 'Overwrite'
       * @const
       * @type {string}
       */
      overwrite: 'overwrite',

      /**
       * The Security Audit Log Full Policy is set to 'Manually Clear'
       * @const
       * @type {string}
       */
      manualClear: 'manualClear'
   },

   /**
    * This enumeration describes the array's current key status.
    * @enum {string}
    */
   SecurityExternalKMSKeyStatus: {
      /**
       * The array controller does not need a key.
       * @const
       * @type {string}
       */
      ok: 'ok',

      /**
       * The array controller needs a key.
       * @const
       * @type {string}
       */
      keyNeeded: 'keyNeeded',

      /**
       * The array controller needs a new key.
       * @const
       * @type {string}
       */
      newKeyNeeded: 'newKeyNeeded',

      /**
       * The array controller needs to perform validation.
       * @const
       * @type {string}
       */
      validationNeeded: 'validationNeeded',

      /**
       * The array controller is requesting the Key Management Server Delete the indicated KEY from its database
       * @const
       * @type {string}
       */
      deleteKey: 'deleteKey'
   },

   /**
    * The Security Level describes the type of secure drives. This is used to distinguish between FDE and FIPS drives and to denote when there is a mix of drive types.
    * @enum {string}
    */
   SecurityLevel: {
      /**
       * The security level of the associated drive set is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * There is no specific security level for the associated drive set.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * There are a mix of security levels in the associated drive set.
       * @const
       * @type {string}
       */
      mixed: 'mixed',

      /**
       * The drives in the associated set are 100% FDE capable.
       * @const
       * @type {string}
       */
      fde: 'fde',

      /**
       * The drives in the associated set are 100% FIPS capable.
       * @const
       * @type {string}
       */
      fips: 'fips'
   },

   /**
    * This enumeration is used to describe the security status of the drive group and the volumes in the drive group
    * @enum {string}
    */
   SecurityType: {
      /**
       * The security type is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The drive group is a non-secure drive group and not secure capable.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * The drive group is a security capable drive group
       * @const
       * @type {string}
       */
      capable: 'capable',

      /**
       * The drive group is a security enabled drive group.
       * @const
       * @type {string}
       */
      enabled: 'enabled'
   },

   /**
    * This enumeration object is used to specify one of a set of supported algorithms for determining a supported new segment size based on a current segment size. The segTransitions array in the FeatureParams structure will contain values from this enumeration identifying which segment size transitions are supported on the storage array. It is specifically relevant to the use of the startVolumeSegmentSizing procedure that is defined as part of the SYMbol interface.
    * @enum {string}
    */
   SegmentSizeTransition: {
      /**
       * Indicates that the current segment size may be reduced by half to obtain a valid, new segment size. Note, however, that the result of doubling must still be a supported segment size, as specified in the FeatureParams object for the storage array.
       * @const
       * @type {string}
       */
      transitionHalf: 'transitionHalf',

      /**
       * Indicates that the current segment size may be doubled to obtain a valid, new segment size. Note, however, that the result of doubling must still be a supported segment size, as specified in the FeatureParameters object for the storage array.
       * @const
       * @type {string}
       */
      transitionDouble: 'transitionDouble'
   },

   /**
    * This enumeration is used to determine what action is being applied to the given snapshot.
    * @enum {string}
    */
   SnapshotAction: {
      /**
       * No action currently occurring.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Rollback is currently occurring. This is not supported in this release of software.
       * @const
       * @type {string}
       */
      rollback: 'rollback'
   },

   /**
    * This enumeration is used to determine the current status of a rollback operation.
    * @enum {string}
    */
   SnapshotRollbackStatus: {
      /**
       * No rollback.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Actively copying data.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * The rollback is waiting on resources to start background copy.
       * @const
       * @type {string}
       */
      pending: 'pending',

      /**
       * Active data copy paused due to error.
       * @const
       * @type {string}
       */
      paused: 'paused'
   },

   /**
    * An enumeration used to determine the status of a snapshot.
    * @enum {string}
    */
   SnapshotStatus: {
      /**
       * The snapshot is working correctly
       * @const
       * @type {string}
       */
      active: 'active',

      /**
       * The snapshot is not in working condition
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The snapshot has been disabled by user request
       * @const
       * @type {string}
       */
      disabled: 'disabled',

      /**
       * The snapshot will reject all IOs because of repository condition
       * @const
       * @type {string}
       */
      offline: 'offline'
   },

   /**
    * This enumeration object is used to indicate which type of statistics to return on a procedure call to get SOC error statistics.
    * @enum {string}
    */
   SocCommand: {
      /**
       * Report SOC error statistics, on a per-port basis, for all SOC ports local to the controller receiving the request, that are connected to controllers, drives, and SFPs in the controller or controller/drive tray. SOC error statistics for SOC ports local to the alternate controller must be obtained from the alternate controller.
       * @const
       * @type {string}
       */
      controllerTray: 'controllerTray',

      /**
       * Report SOC error statistics, on a per-port basis, for all SOC ports connected to ESMs, drives, and SFPs in all drive expansion trays that are accessible to the controller receiving the request. Error statistics for controllers, drives, or SFPs residing in controller trays or controller/drive trays are not reported. It is sufficient to just issue this command to one controller or the other.
       * @const
       * @type {string}
       */
      expansionTrays: 'expansionTrays'
   },

   /**
    * This enumeration object is used to identify the type of device attached to a SOC port.
    * @enum {string}
    */
   SocConnectedDeviceType: {
      /**
       * Controller attached directly to a local SOC port.
       * @const
       * @type {string}
       */
      controllerLocal: 'controllerLocal',

      /**
       * Alternate controller attached to a remote SOC port.
       * @const
       * @type {string}
       */
      controllerAlternate: 'controllerAlternate',

      /**
       * Drive device type
       * @const
       * @type {string}
       */
      drive: 'drive',

      /**
       * ESM device type
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * SFP device type
       * @const
       * @type {string}
       */
      sfp: 'sfp',

      /**
       * Unknown device type
       * @const
       * @type {string}
       */
      unknownDevice: 'unknownDevice',

      /**
       * Drawer device type
       * @const
       * @type {string}
       */
      drawer: 'drawer'
   },

   /**
    * This enumeration is used to indicate the state of a given loop.
    * @enum {string}
    */
   SocLoopState: {
      /**
       * The loop state is "DOWN".
       * @const
       * @type {string}
       */
      down: 'down',

      /**
       * The loop state is "INIT."
       * @const
       * @type {string}
       */
      init: 'init',

      /**
       * The loop state is "OPEN_INIT."
       * @const
       * @type {string}
       */
      openInit: 'openInit',

      /**
       * The loop state is "UP."
       * @const
       * @type {string}
       */
      up: 'up',

      /**
       * The loop state is "ACTIVE."
       * @const
       * @type {string}
       */
      active: 'active'
   },

   /**
    * This enumeration is used to indicate the device type for the parent of a SOC device.
    * @enum {string}
    */
   SocParentType: {
      /**
       * The SOC parent device is a controller.
       * @const
       * @type {string}
       */
      controller: 'controller',

      /**
       * The SOC parent device is an ESM.
       * @const
       * @type {string}
       */
      esm: 'esm',

      /**
       * The SOC parent device is a drawer (Wembley enclosure).
       * @const
       * @type {string}
       */
      drawer: 'drawer'
   },

   /**
    * This enumeration is used to indicate the operating mode of a given port. A port that is attached to a controller, drive, or ESM is always configured for device mode. A port that is attached to an SFP may be configured for either tree or string cascade mode.
    * @enum {string}
    */
   SocPortMode: {
      /**
       * The port is configured for non-cascade mode.
       * @const
       * @type {string}
       */
      device: 'device',

      /**
       * The port is configured for tree cascade mode.
       * @const
       * @type {string}
       */
      tree: 'tree',

      /**
       * The port is configured for string cascade mode.
       * @const
       * @type {string}
       */
      string: 'string'
   },

   /**
    * This enumeration is used to indicate the state of a given SOC port.
    * @enum {string}
    */
   SocPortState: {
      /**
       * The port state is "Unknown."
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The port state is "Inserted."
       * @const
       * @type {string}
       */
      inserted: 'inserted',

      /**
       * The port state is "Manually Inserted."
       * @const
       * @type {string}
       */
      insertedManual: 'insertedManual',

      /**
       * The port state is "Loopback."
       * @const
       * @type {string}
       */
      loopback: 'loopback',

      /**
       * The port state is "Diag_Xmit."
       * @const
       * @type {string}
       */
      diagXmit: 'diagXmit',

      /**
       * The port state is "Bypassed."
       * @const
       * @type {string}
       */
      bypassed: 'bypassed',

      /**
       * The port state is "Byp_NoFRU."
       * @const
       * @type {string}
       */
      bypNoFru: 'bypNoFru',

      /**
       * The port state is "Byp_TXFault."
       * @const
       * @type {string}
       */
      bypTxFault: 'bypTxFault',

      /**
       * The port state is "Byp_LIPF8."
       * @const
       * @type {string}
       */
      bypLipF8: 'bypLipF8',

      /**
       * The port state is "Byp_DataTimeout."
       * @const
       * @type {string}
       */
      bypDataTimeout: 'bypDataTimeout',

      /**
       * The port state is "Byp_RxLOS."
       * @const
       * @type {string}
       */
      bypRxLos: 'bypRxLos',

      /**
       * The port state is "Byp_SyncLoss."
       * @const
       * @type {string}
       */
      bypSyncLoss: 'bypSyncLoss',

      /**
       * The port state is "Byp_LIPIsol."
       * @const
       * @type {string}
       */
      bypLipIsol: 'bypLipIsol',

      /**
       * The port state is "Byp_PTBI."
       * @const
       * @type {string}
       */
      bypPtbi: 'bypPtbi',

      /**
       * The port state is "Byp_Manual."
       * @const
       * @type {string}
       */
      bypManual: 'bypManual',

      /**
       * The port state is "Byp_Redundant."
       * @const
       * @type {string}
       */
      bypRedundant: 'bypRedundant',

      /**
       * The port state is "Byp_Snoop."
       * @const
       * @type {string}
       */
      bypSnoop: 'bypSnoop',

      /**
       * The port state is "Byp_CRCThresh."
       * @const
       * @type {string}
       */
      bypCrcThresh: 'bypCrcThresh',

      /**
       * The port state is "Byp_InvalidOSThresh."
       * @const
       * @type {string}
       */
      bypInvalidOsThresh: 'bypInvalidOsThresh'
   },

   /**
    * An enumeration used to indicate how the device speed is controlled, Closely resembles values in mhm.h.
    * @enum {string}
    */
   SpeedControl: {
      /**
       * Method cannot be determined
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Device has fixed speed
       * @const
       * @type {string}
       */
      fixed: 'fixed',

      /**
       * Device speed controlled by a switch
       * @const
       * @type {string}
       */
      switched: 'switched',

      /**
       * Device speed is auto negotiated
       * @const
       * @type {string}
       */
      auto: 'auto'
   },

   /**
    * This enumeration type identifies the various types of statistical streams (sets of statistical observations collected over a period of time) supported by the controller firmware.
    * @enum {string}
    */
   StatStreamType: {
      /**
       * Average utilization for CPU 0 (polled at 1 Hz).
       * @const
       * @type {string}
       */
      acpu0: 'acpu0',

      /**
       * Average utilization for CPU 1 (polled at 1 Hz).
       * @const
       * @type {string}
       */
      acpu1: 'acpu1',

      /**
       * Controller I/O queue depth (on command receipt).
       * @const
       * @type {string}
       */
      ciqr: 'ciqr',

      /**
       * Drive I/O queue depth (on command receipt).
       * @const
       * @type {string}
       */
      diqr: 'diqr',

      /**
       * Drive I/O response time.
       * @const
       * @type {string}
       */
      dirt: 'dirt',

      /**
       * Host I/O response time.
       * @const
       * @type {string}
       */
      hirt: 'hirt'
   },

   /**
    * This enumeration used to determine the status of a statistic.
    * @enum {string}
    */
   StatisticQualifier: {
      /**
       * Statistic is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Statistic is valid.
       * @const
       * @type {string}
       */
      valid: 'valid',

      /**
       * Statistic is invalid due to stuck condition.
       * @const
       * @type {string}
       */
      invalidStuck: 'invalidStuck',

      /**
       * Statistic is invalid due to External Reset occurrence.
       * @const
       * @type {string}
       */
      invalidExternReset: 'invalidExternReset',

      /**
       * Statistic is not supported.
       * @const
       * @type {string}
       */
      notSupported: 'notSupported'
   },

   /**
    * This enumeration sets the degree of resolution in the statistics to be returned to the host.
    * @enum {string}
    */
   StatisticsResolutionType: {
      /**
       * Low resolution statistics will be returned.
       * @const
       * @type {string}
       */
      low: 'low',

      /**
       * High resolution statistics will be returned.
       * @const
       * @type {string}
       */
      high: 'high'
   },

   /**
    * This enumeration is used to determine the status of the support CRU.
    * @enum {string}
    */
   SupportCRUStatus: {
      /**
       * The status of the support CRU is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The support CRU is operating correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The support CRU is not working or is not present.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The support CRU has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The power supply in the support CRU has no input voltage.
       * @const
       * @type {string}
       */
      noinput: 'noinput',

      /**
       * The support CRU is not configured with all the necessary components.
       * @const
       * @type {string}
       */
      incorrectConfig: 'incorrectConfig'
   },

   /**
    * This enumeration data type identifies the different types of support CRUS that can be present.
    * @enum {string}
    */
   SupportCruType: {
      /**
       * The support CRU is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The support CRU is a power-fan CRU, meaning it can contain both power supplies and fans.
       * @const
       * @type {string}
       */
      powerFan: 'powerFan',

      /**
       * The support CRU is a battery CRU, meaning it is just for holding batteries.
       * @const
       * @type {string}
       */
      battery: 'battery',

      /**
       * The support CRU is a fan-only CRU.
       * @const
       * @type {string}
       */
      fan: 'fan',

      /**
       * The support CRU is a power supply-only CRU.
       * @const
       * @type {string}
       */
      powerSupply: 'powerSupply'
   },

   /**
    * This enumeration is used to determine the status of a thermal sensor component.
    * @enum {string}
    */
   ThermalSensorStatus: {
      /**
       * The thermal sensor is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The thermal sensor nominal temperature has been exceeded.
       * @const
       * @type {string}
       */
      nominalTempExceed: 'nominalTempExceed',

      /**
       * The thermal sensor maximum temperature has been exceeded.
       * @const
       * @type {string}
       */
      maxTempExceed: 'maxTempExceed',

      /**
       * The thermal sensor has been removed or is missing.
       * @const
       * @type {string}
       */
      removed: 'removed',

      /**
       * The status of the thermal sensor is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown'
   },

   /**
    * The value reported by a thermal sensor.
    * @enum {string}
    */
   ThermalSensorValue: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The sensor temperature is nominal.
       * @const
       * @type {string}
       */
      nominal: 'nominal',

      /**
       * An error occurred when accessing the sensor.
       * @const
       * @type {string}
       */
      accessError: 'accessError',

      /**
       * The sensor data was unreadable.
       * @const
       * @type {string}
       */
      unreadable: 'unreadable'
   },

   /**
    * This enumeration defines the actions to take on a thin volume re-initialize request.
    * @enum {string}
    */
   ThinVolumeReinitializeAction: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Reinitialize the thin volume.
       * @const
       * @type {string}
       */
      only: 'only',

      /**
       * Reinitialize the thin volume and resize the repository.
       * @const
       * @type {string}
       */
      andResize: 'andResize',

      /**
       * Reinitialize the thin volume and use a different repository.
       * @const
       * @type {string}
       */
      newRepository: 'newRepository'
   },

   /**
    * These types indicate how thin volumes are reported on the SCSI interface.
    * @enum {string}
    */
   ThinVolumeReportingPolicy: {
      /**
       * The thin volume reports as an unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The thin volume reports as a thick volume.
       * @const
       * @type {string}
       */
      asThick: 'asThick',

      /**
       * The thin volume reports as thin.
       * @const
       * @type {string}
       */
      asThin: 'asThin'
   },

   /**
    * This enumeration defines the repository expansion policies.
    * @enum {string}
    */
   ThinVolumeRepositoryExpansionPolicy: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The repository must be expanded manually.
       * @const
       * @type {string}
       */
      manual: 'manual',

      /**
       * The repository will be expanded automatically.
       * @const
       * @type {string}
       */
      automatic: 'automatic'
   },

   /**
    * This enumeration describes a thin volume's Expandable Repository Volume expansion event type.
    * @enum {string}
    */
   ThinVolumeRepositoryExpansionType: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      expansionTypeUnknown: 'expansionTypeUnknown',

      /**
       * The repository was expanded manually.
       * @const
       * @type {string}
       */
      expansionTypeManual: 'expansionTypeManual',

      /**
       * The repository was expanded automatically.
       * @const
       * @type {string}
       */
      expansionTypeAutomatic: 'expansionTypeAutomatic',

      /**
       * Thin Volume automatic contraction
       * @const
       * @type {string}
       */
      contractionTypeAutomatic: 'contractionTypeAutomatic'
   },

   /**
    * This enumeration defines the status values for thin volumes.
    * @enum {string}
    */
   ThinVolumeStatus: {
      /**
       * The thin volume is in an unknown state. This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The thin volume is optimal.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The thin volume's repository is full.
       * @const
       * @type {string}
       */
      full: 'full',

      /**
       * The thin volume's repository is over the threshold value.
       * @const
       * @type {string}
       */
      overThresh: 'overThresh',

      /**
       * The thin volume is in a failed state.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The thin volume is initializing.
       * @const
       * @type {string}
       */
      initializing: 'initializing'
   },

   /**
    * This enumeration defines how drives are to be numbered.
    * @enum {string}
    */
   Traversal: {
      /**
       * No drives are present in the enclosure
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Drives in the enclosure are numbered left to right.
       * @const
       * @type {string}
       */
      leftToRight: 'leftToRight',

      /**
       * Drives in the enclosure are numbered right to left.
       * @const
       * @type {string}
       */
      rightToLeft: 'rightToLeft',

      /**
       * Drives in the enclosure are numbered top to bottom.
       * @const
       * @type {string}
       */
      topToBottom: 'topToBottom',

      /**
       * Drives in the enclosure are numbered front to back.
       * @const
       * @type {string}
       */
      frontToBack: 'frontToBack'
   },

   /**
    * This enumeration defines the different types of tray attributes.
    * @enum {string}
    */
   TrayAttributeId: {
      /**
       * This value identifies an "asset tag" attribute.
       * @const
       * @type {string}
       */
      assetTag: 'assetTag',

      /**
       * This value identifies a "chassis name" attribute.
       * @const
       * @type {string}
       */
      chassisName: 'chassisName',

      /**
       * This value identifies a "service tag" attribute.
       * @const
       * @type {string}
       */
      serviceTag: 'serviceTag',

      /**
       * This value identifies a "spin up delay" attribute.
       * @const
       * @type {string}
       */
      spinUpDelay: 'spinUpDelay',

      /**
       * This value identifies a "spin up count" attribute.
       * @const
       * @type {string}
       */
      spinUpCount: 'spinUpCount'
   },

   /**
    * This enumeration defines the different tray orientations that are supported. The tray orientation describes the physical positioning of individual tray elements.
    * @enum {string}
    */
   TrayOrientation: {
      /**
       * The tray is oriented horizontally. Trays of this type are stacked on top of each other, but the individual trays appear in something akin to "landscape" mode.
       * @const
       * @type {string}
       */
      horizontal: 'horizontal',

      /**
       * Vertical tray orientation
       * @const
       * @type {string}
       */
      vertical: 'vertical'
   },

   /**
    * This enumeration defines the different tray interface technology types. This enumeration type is deprecated in favor of having explicit indicators in the Tray structure of the tray front-end interface and drive technologies.
    * @enum {string}
    */
   TrayTechnologyType: {
      /**
       * The interface technology of the tray is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * SCSI tray and SCSI drives.
       * @const
       * @type {string}
       */
      scsiScsi: 'scsiScsi',

      /**
       * Fibre tray and Fibre drives.
       * @const
       * @type {string}
       */
      fibreFibre: 'fibreFibre',

      /**
       * Fibre tray and Serial ATA drives.
       * @const
       * @type {string}
       */
      fibreSata: 'fibreSata',

      /**
       * Fibre tray and Parallel ATA drives.
       * @const
       * @type {string}
       */
      fibrePata: 'fibrePata',

      /**
       * New tray technology type for NVMe
       * @const
       * @type {string}
       */
      nvme: 'nvme'
   },

   /**
    * This enumeration defines the different tray, or enclosure,objects that may be present as part of a storage array.
    * @enum {string}
    */
   TrayType: {
      /**
       * The tray is a SYM1000 controller module (4766, 4665).
       * @const
       * @type {string}
       */
      sym1000: 'sym1000',

      /**
       * The tray is a SYM2000 drive module.
       * @const
       * @type {string}
       */
      sym2000: 'sym2000',

      /**
       * The tray is a 2772 or 2662 controller.
       * @const
       * @type {string}
       */
      sym2772: 'sym2772',

      /**
       * This value indicates that a PCI-based RAID controller is being used, so there is actually no standard enclosure acting as a container for the controller board.
       * @const
       * @type {string}
       */
      pciraid: 'pciraid',

      /**
       * The tray is a generic SAF-TE capable enclosure.
       * @const
       * @type {string}
       */
      generic: 'generic',

      /**
       * The tray is a SYM2200 drive module.
       * @const
       * @type {string}
       */
      sym2200: 'sym2200',

      /**
       * The tray is a SYM1200 or SYM1250 controller module (4774, 4884).
       * @const
       * @type {string}
       */
      sym1200: 'sym1200',

      /**
       * The tray is a 2882 controller.
       * @const
       * @type {string}
       */
      sym2882: 'sym2882',

      /**
       * XBB controller tray
       * @const
       * @type {string}
       */
      sym1500: 'sym1500',

      /**
       * 2-4 Gb/second Fibre channel controller or drive module
       * @const
       * @type {string}
       */
      fc4600: 'fc4600',

      /**
       * The tray is a Serial-AttachedSCSI/Serial-ATA controller/drive module.
       * @const
       * @type {string}
       */
      ss3600: 'ss3600',

      /**
       * The tray is a Serial-AttachedSCSI/Serial-ATA drive expansion module.
       * @const
       * @type {string}
       */
      md1000: 'md1000',

      /**
       * The tray is a Serial-AttachedSCSI/Serial-ATA controller/drive module.
       * @const
       * @type {string}
       */
      md3000: 'md3000',

      /**
       * The tray is an XBB-2 controller.
       * @const
       * @type {string}
       */
      xbb2: 'xbb2',

      /**
       * The tray is a high density drive module.
       * @const
       * @type {string}
       */
      fc6900: 'fc6900',

      /**
       * The tray is a Serial-Attached SCSI/Serial-ATA drive expansion module.
       * @const
       * @type {string}
       */
      md1200: 'md1200',

      /**
       * The tray is a Serial-Attached SCSI/Serial-ATA drive expansion module.
       * @const
       * @type {string}
       */
      md1220: 'md1220',

      /**
       * The tray is a Serial-Attached SCSI/Serial-ATA controller/drive module.
       * @const
       * @type {string}
       */
      de1600: 'de1600',

      /**
       * The tray is a Serial-Attached SCSI/Serial-ATA controller/drive module.
       * @const
       * @type {string}
       */
      de5600: 'de5600',

      /**
       * The tray is a Serial-Attached SCSI controller/drive module.
       * @const
       * @type {string}
       */
      de6600: 'de6600',

      /**
       * The tray is a Wembley 100 enclosure.
       * @const
       * @type {string}
       */
      de7600: 'de7600',

      /**
       * SAS-3 Enclosure Support -- Trafford enclosure
       * @const
       * @type {string}
       */
      de6650: 'de6650',

      /**
       * This tray supports the Atlantis controller.
       * @const
       * @type {string}
       */
      sc12: 'sc12',

      /**
       * This tray supports the Atlantis controller.
       * @const
       * @type {string}
       */
      sc24: 'sc24',

      /**
       * This identifies the Joshua tray type.
       * @const
       * @type {string}
       */
      de212c: 'de212c',

      /**
       * This identifies the Alder tray type.
       * @const
       * @type {string}
       */
      de224c: 'de224c',

      /**
       * This identifies the Trafford tray type.
       * @const
       * @type {string}
       */
      de460c: 'de460c',

      /**
       * New tray type value for Fiji enclosure used by Falcon controller
       * @const
       * @type {string}
       */
      fiji: 'fiji'
   },

   /**
    * This enumeration defines the different types of tray VPD fields that can be updated.
    * @enum {string}
    */
   TrayVPDId: {
      /**
       * This value identifies the chassis serial number field.
       * @const
       * @type {string}
       */
      serialNumber: 'serialNumber',

      /**
       * This value identifies the chassis part number field.
       * @const
       * @type {string}
       */
      partNumber: 'partNumber'
   },

   /**
    * This enumeration defines the values to be used in the shipped limit field in the feature bundle for FEATURE_ID_TRAY_VPD_SETTABLE. This feature indicates whether changing tray VPD data is allowed.
    * @enum {string}
    */
   TrayVPDSettable: {
      /**
       * Setting tray VPD data is not supported.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * Setting tray VPD data is supported for all enclosures in the storage array.
       * @const
       * @type {string}
       */
      all: 'all',

      /**
       * Setting tray VPD data is supported only for the controller RBOD enclosure.
       * @const
       * @type {string}
       */
      rbod: 'rbod'
   },

   /**
    * This enumeration is used to determine the status of an UPS component.
    * @enum {string}
    */
   UPSStatus: {
      /**
       * The UPS is working correctly.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The UPS is on a battery.
       * @const
       * @type {string}
       */
      onBattery: 'onBattery'
   },

   /**
    * This enumeration is used to describe the type of unreadable sector record.
    * @enum {string}
    */
   UsmRecordType: {
      /**
       * The sector is physically unreadable.
       * @const
       * @type {string}
       */
      physical: 'physical',

      /**
       * The sector is corrupted due to dynamic reconfiguration, reconstruction, etc.
       * @const
       * @type {string}
       */
      logical: 'logical',

      /**
       * The sector is corrupted due to a test.
       * @const
       * @type {string}
       */
      injected: 'injected',

      /**
       * The sector is considered bad because of an EDC error.
       * @const
       * @type {string}
       */
      edcError: 'edcError',

      /**
       * The sector is inconsistent with the data/parity redundancy.
       * @const
       * @type {string}
       */
      inconsistent: 'inconsistent',

      /**
       * The sector is considered bad due to a Protection Information error.
       * @const
       * @type {string}
       */
      piError: 'piError'
   },

   /**
    * This enumeration object is used to specify the volume transfer alert delay period.
    * @enum {string}
    */
   VolXferAlertDelayPeriod: {
      /**
       * The minimum delay period, currently 0 seconds.
       * @const
       * @type {string}
       */
      min: 'min',

      /**
       * The maximum delay period.
       * @const
       * @type {string}
       */
      max: 'max'
   },

   /**
    * This enumeration object is used to specify one of a set of volume actions that may be active for a volume. These volume actions represent "long-running" operations on a volume. Any time such an operation is active, the current progress can be determined using the getVolumeActionProgress procedure.
    * @enum {string}
    */
   VolumeAction: {
      /**
       * No long-running operations are currently in progress.
       * @const
       * @type {string}
       */
      none: 'none',

      /**
       * A hot-spare copyback operation is currently in progress. This action will occur after replacement of a failed drive that had been temporarily covered by a hot spare.
       * @const
       * @type {string}
       */
      copyback: 'copyback',

      /**
       * Volume initialization is currently in progress.
       * @const
       * @type {string}
       */
      initializing: 'initializing',

      /**
       * The volume's data is currently being reconstructed onto either a replaced drive or a hot-spare that will temporarily cover for a failed drive.
       * @const
       * @type {string}
       */
      reconstructing: 'reconstructing',

      /**
       * A volume remap operation is currently in progress. A DCE operation is occurring.
       * @const
       * @type {string}
       */
      remappingDce: 'remappingDce',

      /**
       * A volume remap operation is currently in progress. A DRM operation is occurring.
       * @const
       * @type {string}
       */
      remappingDrm: 'remappingDrm',

      /**
       * A volume remap operation is currently in progress. A DCE/DRM operation is occurring.
       * @const
       * @type {string}
       */
      remappingDcedrm: 'remappingDcedrm',

      /**
       * A volume remap operation is currently in progress. A DSEG operation is occurring.
       * @const
       * @type {string}
       */
      remappingDseg: 'remappingDseg',

      /**
       * A volume remap operation is currently in progress. A DVE operation is occurring.
       * @const
       * @type {string}
       */
      remappingDve: 'remappingDve',

      /**
       * A volume remap operation is currently in progress. A DCE/DVE operation is occurring.
       * @const
       * @type {string}
       */
      remappingDcedve: 'remappingDcedve',

      /**
       * A volume movement triggered internally (due to a DVE on another volume).
       * @const
       * @type {string}
       */
      remappingInternal: 'remappingInternal',

      /**
       * A defragmentation eliminating free extents (gaps) is taking place.
       * @const
       * @type {string}
       */
      remappingDefrag: 'remappingDefrag',

      /**
       * A volume format (i.e. write zeros) operation is in progress.
       * @const
       * @type {string}
       */
      formatting: 'formatting',

      /**
       * The volume is synchronizing.
       * @const
       * @type {string}
       */
      synchronizing: 'synchronizing',

      /**
       * A volume parity scan is currently in progress.
       * @const
       * @type {string}
       */
      parityScan: 'parityScan',

      /**
       * A volume copy is currently in progress.
       * @const
       * @type {string}
       */
      volumeCopy: 'volumeCopy',

      /**
       * A snapshot rollback is currently in progress.
       * @const
       * @type {string}
       */
      snapshotRollback: 'snapshotRollback',

      /**
       * A PiT rollback operation is currently in progress.
       * @const
       * @type {string}
       */
      pitRollback: 'pitRollback',

      /**
       * The initial synchronization for an async mirror volume is currently in progress.
       * @const
       * @type {string}
       */
      asyncMirrorGroupInitialSync: 'asyncMirrorGroupInitialSync',

      /**
       * Reported when DDP volumes are Critical.
       * @const
       * @type {string}
       */
      reconstructingCritical: 'reconstructingCritical',

      /**
       * A volume rebalancing operation is currently in progress.
       * @const
       * @type {string}
       */
      rebalancing: 'rebalancing',

      /**
       * A copyThenFail operation is evacuating data from a VolumeGroup.
       * @const
       * @type {string}
       */
      copyThenFail: 'copyThenFail',

      /**
       * A copyThenFail operation is waiting to start on a VolumeGroup.
       * @const
       * @type {string}
       */
      copyThenFailPending: 'copyThenFailPending',

      /**
       * A copyThenReplace operation is evacuating data from a VolumeGroup.
       * @const
       * @type {string}
       */
      copyThenReplace: 'copyThenReplace',

      /**
       * A copyThenReplace, followed by failing the drive, is evacuating data from a VolumeGroup.
       * @const
       * @type {string}
       */
      copyThenReplaceAndFail: 'copyThenReplaceAndFail',

      /**
       * Volume Defrag is in progress
       * @const
       * @type {string}
       */
      thinDefrag: 'thinDefrag',

      /**
       * Reported when a DDP volume is being created as a background operation
       * @const
       * @type {string}
       */
      creating: 'creating',

      /**
       * Reported when a DDP volume is being deleted as a background operation
       * @const
       * @type {string}
       */
      deleting: 'deleting',

      /**
       * Volume fast offline formatting is currently in progress
       * @const
       * @type {string}
       */
      offlineFormatting: 'offlineFormatting',

      /**
       * A drive-specific operation is currently in progress.
       * @const
       * @type {string}
       */
      driveSpecific: 'driveSpecific'
   },

   /**
    * This enumeration object is used to specify the priority of the volume copy operation.
    * @enum {string}
    */
   VolumeCopyPriority: {
      /**
       * Lowest level of I/O activity to the target.
       * @const
       * @type {string}
       */
      priority0: 'priority0',

      /**
       * Next to lowest level of I/O activity to the target.
       * @const
       * @type {string}
       */
      priority1: 'priority1',

      /**
       * Default value.
       * @const
       * @type {string}
       */
      priority2: 'priority2',

      /**
       * Next to highest level of I/O activity to the target.
       * @const
       * @type {string}
       */
      priority3: 'priority3',

      /**
       * Highest level of I/O activity to the target.
       * @const
       * @type {string}
       */
      priority4: 'priority4'
   },

   /**
    * This enumeration object is used to determine the status of a copy operation.
    * @enum {string}
    */
   VolumeCopyStatus: {
      /**
       * The source is being copied to the target.
       * @const
       * @type {string}
       */
      inProgress: 'inProgress',

      /**
       * The source has been copied to the target.
       * @const
       * @type {string}
       */
      complete: 'complete',

      /**
       * The copy was halted by user request (also initial state).
       * @const
       * @type {string}
       */
      halted: 'halted',

      /**
       * The copy process failed.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * Background copy start pending resources.
       * @const
       * @type {string}
       */
      pending: 'pending'
   },

   /**
    * The type of volume copy
    * @enum {string}
    */
   VolumeCopyType: {
      /**
       * Unknown copy type
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * Offline volume copy
       * @const
       * @type {string}
       */
      offline: 'offline',

      /**
       * Online volume copy - note this is online from the controller firmware perspective.
       * @const
       * @type {string}
       */
      online: 'online'
   },

   /**
    * This enumeration type identifies the possible states of a volume group.
    * @enum {string}
    */
   VolumeGroupState: {
      /**
       * A state in which it is likely, but not certain that the volume group will become complete and be made available for import. Generally, as long as a proper, non-empty subset of constituent drives remain in the group, the group remains in the contingent state.
       * @const
       * @type {string}
       */
      contingent: 'contingent',

      /**
       * A state in which the volume group is ready for import or is exported.
       * @const
       * @type {string}
       */
      exported: 'exported',

      /**
       * A state in which the volume group has been declared by an administrator to be ready for import.
       * @const
       * @type {string}
       */
      forced: 'forced',

      /**
       * A state in which all constituent drives of the volume group are assigned, present, and online; and in which the volume group is fully operable.
       * @const
       * @type {string}
       */
      complete: 'complete',

      /**
       * A state in which some or all redundancy of the group is lost, but in which the data is still accessible. The volume group is operable, but not exportable.
       * @const
       * @type {string}
       */
      partial: 'partial',

      /**
       * A state in which the subset of constituent drives available in the volume group is insufficient to allow processing of data. The volume group is neither operable nor exportable.
       * @const
       * @type {string}
       */
      incomplete: 'incomplete',

      /**
       * A state in which all constituent drives of the volume group have been removed from the array. The volume group is neither operable nor exportable.
       * @const
       * @type {string}
       */
      missing: 'missing'
   },

   /**
    * This enumeration is used to indicate the type of the volume group.
    * @enum {string}
    */
   VolumeGroupType: {
      /**
       * The type of the volume group is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The volume group is a traditional/legacy volume group (pre Disk Pools).
       * @const
       * @type {string}
       */
      traditional: 'traditional',

      /**
       * The volume group is a Disk Pool.
       * @const
       * @type {string}
       */
      diskPool: 'diskPool'
   },

   /**
    * This enumeration lists the volume group usage types.
    * @enum {string}
    */
   VolumeGroupUsage: {
      /**
       * This should never happen.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The volume group usage is standard.
       * @const
       * @type {string}
       */
      standard: 'standard',

      /**
       * The volume group usage is flash cache.
       * @const
       * @type {string}
       */
      flashcache: 'flashcache'
   },

   /**
    * Five priority levels are defined:
    * @enum {string}
    */
   VolumeScanPriority: {
      /**
       * Specifies the highest priority. At this setting the volume scan commands are executed at the same priority as normal host I/O.
       * @const
       * @type {string}
       */
      priority0: 'priority0',

      /**
       * The volume scan priority is 1.
       * @const
       * @type {string}
       */
      priority1: 'priority1',

      /**
       * The volume scan priority is 2.
       * @const
       * @type {string}
       */
      priority2: 'priority2',

      /**
       * The volume scan priority is 3.
       * @const
       * @type {string}
       */
      priority3: 'priority3',

      /**
       * This is the lowest priority.
       * @const
       * @type {string}
       */
      priority4: 'priority4'
   },

   /**
    * This enumeration object is used to specify the current operational state of a volume.
    * @enum {string}
    */
   VolumeStatus: {
      /**
       * The volume is fully operational.
       * @const
       * @type {string}
       */
      optimal: 'optimal',

      /**
       * The volume is operating in degraded mode due to one or more drive failures.
       * @const
       * @type {string}
       */
      degraded: 'degraded',

      /**
       * The volume has been marked failed due to excessive drive failures.
       * @const
       * @type {string}
       */
      failed: 'failed',

      /**
       * The volume has been marked impaired due to detection of inconsistent parity during a media scan operation.
       * @const
       * @type {string}
       */
      impaired: 'impaired',

      /**
       * Reported when a DDP volume is being created as a background operation
       * @const
       * @type {string}
       */
      creating: 'creating',

      /**
       * Reported when a DDP volume is being deleted as a background operation
       * @const
       * @type {string}
       */
      deleting: 'deleting'
   },

   /**
    * This enumeration is used to identify the capacity provisioning of a volume.
    * @enum {string}
    */
   VolumeType: {
      /**
       * The volume capacity provisioning is unknown.
       * @const
       * @type {string}
       */
      unknown: 'unknown',

      /**
       * The volume capacity provisioning is thin.
       * @const
       * @type {string}
       */
      thinProvisioned: 'thinProvisioned',

      /**
       * The volume capacity provisioning is thick.
       * @const
       * @type {string}
       */
      thickProvisioned: 'thickProvisioned'
   },

   /**
    * This enumeration object is used during the volume creation process to provide the controller with hints about how to optimize the new volume's performance characteristics.
    * @enum {string}
    */
   VolumeUsage: {
      /**
       * The volume will be used for multimedia data storage, where data is typically read and written in large, sequential units.
       * @const
       * @type {string}
       */
      multimedia: 'multimedia',

      /**
       * The volume will be used for transactional applications, such as database storage.
       * @const
       * @type {string}
       */
      transactional: 'transactional',

      /**
       * The volume will be used for typical file system storage.
       * @const
       * @type {string}
       */
      filesystem: 'filesystem'
   },

   /**
    * Defines the key length for X.509 certificates used for TLS connections. One of these values will be reflected in an NVSRAM region to specify which key length should be used. If the value is '0', then the application default should be used.
    * @enum {string}
    */
   X509CertificateKeyLength: {
      /**
       * Application should use the release default value.
       * @const
       * @type {string}
       */
      lengthDflt: 'lengthDflt',

      /**
       * Key length 2048.
       * @const
       * @type {string}
       */
      length2048: 'length2048',

      /**
       * Effective strength 128 bits.
       * @const
       * @type {string}
       */
      length3072: 'length3072',

      /**
       * Effective strength ~140 bits.
       * @const
       * @type {string}
       */
      length4096: 'length4096'
   }
};

/**
 * SYMbol Procedure Names
 */
symbolAPI.procedure = {
   /**
    * Returns a DiscoveryResponse object that identifies the storage arrays and controllers known to the RPC server that handles this request. Response also indicates if RPC server is RAID controller or SYMbol RPC UTM agent.
    * @const
    * @type {string}
    */
   discoverControllers: 'discoverControllers',

   /**
    * This function is used to bind a new connection to a particular controller. If the server is actually a controller itself, the controller will just ensure that its CONTROLLER REF is the same as the one passed in as an argument. If the server is an agent, it will use the CONTROLLER REF argument to determine which locally-attached controller should be used for all further interactions over the RPC connection.
    * @const
    * @type {string}
    */
   bindToController: 'bindToController',

   /**
    * Instructs the SYMbol Server's controller to transfer ownership of a volume group and its associated volumes to another controller.
    * @const
    * @type {string}
    */
   assignVolumeGroupOwnership: 'assignVolumeGroupOwnership',

   /**
    * This procedure causes the controller to automatically assign the specified number of drives as hot spares, in addition to any previously assigned hot spares.
    * @const
    * @type {string}
    */
   assignDrivesAsHotSpares: 'assignDrivesAsHotSpares',

   /**
    * Instructs the SYMbol Server's controller to create hot spare drives out of the given drives.
    * @const
    * @type {string}
    */
   assignSpecificDrivesAsHotSpares: 'assignSpecificDrivesAsHotSpares',

   /**
    * This procedure returns a list of volume candidates that can be used in an ensuing volume creation request.
    * @const
    * @type {string}
    */
   getVolumeCandidates: 'getVolumeCandidates',

   /**
    * This procedure causes a new volume to be created based on parameters provided by the caller in the argument structure. Note that a key parameter is a VolumeCandidate object that was previously returned by the controller as the result of a getVolumeCandidates operation. The user must select one such candidate, and then supply further information about the desired attributes of the volume when calling this procedure.
    * @const
    * @type {string}
    */
   createVolume: 'createVolume',

   /**
    * This procedure causes the drives specified by the argument to be deassigned as hot spares. They will be returned to the pool of unassigned drives, and thus be added to the unconfigured capacity pool of the storage array. Note that a hot spare drive cannot be deassigned if it is currently in use, sparing for a failed drive.
    * @const
    * @type {string}
    */
   deassignDrivesAsHotSpares: 'deassignDrivesAsHotSpares',

   /**
    * This procedure is used to delete a Thin Volume. The procedure has been deprecated for deleting RAID Volumes - it has been replaced by the procedure deleteVolumeFromGroup.
    * @const
    * @type {string}
    */
   deleteVolume: 'deleteVolume',

   /**
    * This procedure marks the specified controller as being failed. Furthermore, the alternate of the specified controller will force the failed controller into a reset state (if possible).
    * @const
    * @type {string}
    */
   setControllerToFailed: 'setControllerToFailed',

   /**
    * This procedure marks the specified drive as being failed. In general, this will also impact the operational state of the volume group to which the drive is assigned, plus all volumes defined on that volume group. The precise impact on the states of these other objects may vary, as it depends on the RAID level of the volumes, as well as the states of the other drives in the volume group.
    * @const
    * @type {string}
    */
   setDriveToFailed: 'setDriveToFailed',

   /**
    * This procedure causes the specified volume to be formatted. All data that is currently present on the volume will be irretrievably lost as a result of this operation. Once a format operation starts, the volume's action field will be changed to VOL_ACTION_INITIALIZING; the getVolumeActionProgress procedure can then be used to monitor the progress of the operation. Volume format operations are typically required only when reviving a volume that has been marked failed for some reason. Newly-created volumes need not be explicitly formatted using this procedure.
    * @const
    * @type {string}
    */
   startVolumeFormat: 'startVolumeFormat',

   /**
    * This procedure causes the specified drive object to be initialized for use in the system. All data on the drive is irretrievably lost as a result of this operation. Only offline drives or drives whose status is DRIVE_STAT_INCOMPATIBLE are candidates for initialization. This procedure implicitly transitions the drive to the online state.
    * @const
    * @type {string}
    */
   initializeDrive: 'initializeDrive',

   /**
    * To indicate the end of the iterative download sequence, call this procedure with a zero-length segment size. When the controller receives this end indicator, the controller writes the accumulated firmware image to stable storage (typically flash memory). The controller responds to this procedure call with the appropriate return code, delays for a short period, and then reboots to load and execute the new firmware.
    * @const
    * @type {string}
    */
   loadControllerFirmware: 'loadControllerFirmware',

   /**
    * To indicate the end of the iterative download sequence, call this procedure with a zero-length segment size. When the controller receives this end indicator, the controller writes the accumulated NVSRAM image to stable storage (typically flash memory). The controller responds to this procedure call with the appropriate return code, delays for a short period, and then reboots to load and execute the new NVSRAM.
    * @const
    * @type {string}
    */
   loadControllerNVSRAM: 'loadControllerNVSRAM',

   /**
    * This procedure clears all entries from the Major Events Log.
    * @const
    * @type {string}
    */
   resetMel: 'resetMel',

   /**
    * This procedure marks a volume group offline. When this operation completes, all volumes in the volume group will be inaccessible for I/O operations. The drives that comprise the volume group can be removed from the storage array and, if desired, inserted into a different storage array.
    * @const
    * @type {string}
    */
   setVolumeGroupToOffline: 'setVolumeGroupToOffline',

   /**
    * This procedure marks a volume group online. It is typically used when the drives assigned to a volume group have been transported from one storage array to another. After the last such drive has been inserted into the new storage array, it is necessary to manually mark the volume group online. When this operation completes, assuming the drives are all functioning properly, the volumes defined in the volume group will become accessible for I/O operations.
    * @const
    * @type {string}
    */
   setVolumeGroupToOnline: 'setVolumeGroupToOnline',

   /**
    * This procedure initiates the reconstruction of a failed drive in a degraded RAID volume. The procedure returns once the reconstruction has started. If the indicated failed drive has an integrated hot spare serving in its place, then this procedure will initiate the copyback from the hot spare to the failed drive.
    * @const
    * @type {string}
    */
   startDriveReconstruction: 'startDriveReconstruction',

   /**
    * This procedure initiates a long-running operation to defragment a volume group by shifting the physical storage location of each volume in the volume group to eliminate any free extents that reside between defined volumes. Note that all volumes remain fully accessible and online during this transition. While the operation is in progress, the client can make calls to the getVolumeActionProgress procedure to determine how much progress has been made in completing the operation for each affected volume. The end result of a volume group defragment operation is that free extents that existed between defined volumes will be eliminated, and a single large free extent (if any) will appear at the end of the volume group.
    * @const
    * @type {string}
    */
   startVolumeGroupDefrag: 'startVolumeGroupDefrag',

   /**
    * This procedure initiates a long-running operation to expand the capacity of a volume group by adding one or more drives to it. An expansion of this form requires that the controller transparently move the data of existing volumes within the volume group; volumes remain fully accessible and online during this transition. While the operation is in progress, the client can make calls to the getVolumeActionProgress procedure to determine how much progress has been made in completing the operation for each affected volume. The end result of a volume group expansion is the appearance of a new (or enlarged) free extent at the end of the volume group. The free extent can then be used to create new volumes as desired by the user.
    * @const
    * @type {string}
    */
   startVolumeGroupExpansion: 'startVolumeGroupExpansion',

   /**
    * This procedure initiates a long-running operation to change the RAID level of a volume group (and thus all volumes in the volume group) from one supported value to another. While the operation is in progress, the client can make calls to the getVolumeActionProgress procedure to determine how much progress has been made in completing the operation for each affected volume.
    * @const
    * @type {string}
    */
   startVolumeRAIDMigration: 'startVolumeRAIDMigration',

   /**
    * This procedure initiates a long-running operation to change the segment size (i.e. stripe depth) of a volume from one supported value to another. While the operation is in progress, the client can make calls to the getVolumeActionProgress procedure to determine how much progress has been made in completing the operation.
    * @const
    * @type {string}
    */
   startVolumeSegmentSizing: 'startVolumeSegmentSizing',

   /**
    * This procedure causes the specified controller to be transitioned to the passive state. All volume groups owned by the controller will be transitioned to the alternate controller, which remains in the active state.
    * @const
    * @type {string}
    */
   setControllerToPassive: 'setControllerToPassive',

   /**
    * This procedure causes the specified controller to be transitioned into the active state. If the controller was previously active, no visible changes will occur as a result of this operation. If it was previously passive or in service mode, it will be made active. After this transition occurs, it will be possible to assign ownership of volume groups to the controller so that it may participate in standard I/O operations.
    * @const
    * @type {string}
    */
   setControllerToActive: 'setControllerToActive',

   /**
    * This procedure updates the cache parameters that are maintained on a per-array basis, across all controllers in the array.
    * @const
    * @type {string}
    */
   setSACacheParams: 'setSACacheParams',

   /**
    * This procedure is used by a client to modify the user-assigned label for the storage array. The label value is stored in non-volatile storage and returned to the client as part of the SAInfo object.
    * @const
    * @type {string}
    */
   setSAUserLabel: 'setSAUserLabel',

   /**
    * This procedure allows the client to set the clock of the controller to the specified value. Note that the clock value is only set on the controller to which this request is directed. If the client wishes to set the clock value on each controller, then an independent request of this form should be directed to each controller.
    * @const
    * @type {string}
    */
   setControllerTime: 'setControllerTime',

   /**
    * This procedure updates the caching parameters for a particular volume as specified in the argument structure.
    * @const
    * @type {string}
    */
   setVolumeCacheParams: 'setVolumeCacheParams',

   /**
    * This procedure updates various parameters (outside of cache-related parameters) for a particular volume as specified in the argument structure.
    * @const
    * @type {string}
    */
   setVolumeParams: 'setVolumeParams',

   /**
    * This procedure is used by a client to modify the user-assigned label for a volume. The label value is stored in non-volatile storage and returned to the client as part of the Volume or SnapshotVolume object when the client requests this information from the controller.
    * @const
    * @type {string}
    */
   setVolumeUserLabel: 'setVolumeUserLabel',

   /**
    * This procedure causes visual indicators to be activated on the physical storage array unit to allow an end-user to visually identify the storage array. The indicators will remain active until the stopIdentification procedure is invoked.
    * @const
    * @type {string}
    */
   startSAIdentification: 'startSAIdentification',

   /**
    * This procedure causes visual indicators to be activated on the physical drives specified in the argument list to allow an end-user to visually identify the drives. The indicators will remain active until the stopIdentification procedure is invoked.
    * @const
    * @type {string}
    */
   startDriveIdentification: 'startDriveIdentification',

   /**
    * This procedure cancels the effects of any prior startDriveIdentification, startSAIdentification, startChannelIdentification and/or startTrayIdentification operations by deactivating all visual indicators.
    * @const
    * @type {string}
    */
   stopIdentification: 'stopIdentification',

   /**
    * This procedure updates the I/O interface parameters for the controller to which the request is directed.
    * @const
    * @type {string}
    */
   setHostInterfaceParams: 'setHostInterfaceParams',

   /**
    * This procedure causes the specified controller's state to be set to optimal. If the controller was previously in the failed state, it will be reactivated. If necessary, the alternate controller will also remove any forced reset signal being applied to the specified controller.
    * @const
    * @type {string}
    */
   setControllerToOptimal: 'setControllerToOptimal',

   /**
    * This procedure forces the specified drive to the optimal state, including clearing the PFA condition for the drive, if any. Returning the drive to optimal may cause volumes on the associated volume group to be returned to the optimal state as well. This is a potentially dangerous operation, since a failed drive is usually accompanied by some form of parity inconsistency. Forcing a drive from the failed state to the optimal state may disrupt the controller's normal methods of providing availability in a degraded state, and may thus result in corrupted data being returned on ensuing data transfers to the host system.
    * @const
    * @type {string}
    */
   setDriveToOptimal: 'setDriveToOptimal',

   /**
    * This is a potentially dangerous operation, since it causes data to be made available to the I/O host even though that data may have become corrupted due to device failures that occurred in the past.
    * @const
    * @type {string}
    */
   forceVolumeGroupToOptimal: 'forceVolumeGroupToOptimal',

   /**
    * This procedure is used by clients to query the referenced controller for up-to-date information about its host-side I/O interfaces. Since this interface information is highly volatile, the object graph data contains only a point-in-time snapshot of the interface data. This procedure can be used to obtain current information that may not be reflected in the most recent object graph.
    * @const
    * @type {string}
    */
   getControllerHostInterfaces: 'getControllerHostInterfaces',

   /**
    * This procedure causes all configuration and state information to be returned to the requester. The information is conveyed in the form of an object graph. The ObjectBundle object contains a set of all known logical and physical components. The reference values within these objects can be analyzed to determine the interrelationships and linkages between the key objects, and thus to establish the true graph-oriented image of the storage array state.
    * @const
    * @type {string}
    */
   getObjectGraph: 'getObjectGraph',

   /**
    * This procedure returns an indication of the extent to which a long-running operation on a volume has completed. The set of supported long-running operations is defined by the VolumeAction enumeration. This procedure can also be called for a snapshot volume. The set of supported long-running operations for snapshot volumes is defined by the SnapshotAction enumeration.
    * @const
    * @type {string}
    */
   getVolumeActionProgress: 'getVolumeActionProgress',

   /**
    * This procedure is used by clients to obtain information about all component or logic failures on the storage array that require some form of recovery action.
    * @const
    * @type {string}
    */
   getRecoveryFailureList: 'getRecoveryFailureList',

   /**
    * This procedure returns an object that contains high-level status information about the storage array as a whole.
    * @const
    * @type {string}
    */
   getSAData: 'getSAData',

   /**
    * This procedure is used by the client to retrieve performance monitoring data for one or more volumes.
    * @const
    * @type {string}
    */
   getVolumePerformance: 'getVolumePerformance',

   /**
    * This procedure is used by the client to request that the controller store (in nonvolatile storage) a TrayPositionList object that provides information about the relative physical positions of the storage array's trays within their enclosing rack(s) or container(s).
    * @const
    * @type {string}
    */
   setSATrayPositions: 'setSATrayPositions',

   /**
    * This procedure sets the media scan parameters for a particular volume. Each volume can be configured to either participate in media scans or not. Furthermore, if a volume is configured to participate, it can be further configured so that parity validation either occurs during the media scan or is skipped. The client uses this procedure to set these configuration options on a per-volume basis.
    * @const
    * @type {string}
    */
   setVolumeMediaScanParams: 'setVolumeMediaScanParams',

   /**
    * This procedure sets the target media scan period for background media scans to the value specified by the caller. The period is specified in units of days, and governs the approximate time required for a complete media scan of all volumes and drives in the system. The allowed period values can be determined by checking the appropriate fields of the FeatureParameters object for the storage array.
    * @const
    * @type {string}
    */
   setSAMediaScanPeriod: 'setSAMediaScanPeriod',

   /**
    * This procedure is used by clients to query the controller for indications of state changes that have occurred and which would necessitate that the client refresh its view of the storage array's state. If no state changes need to be reported, the controller will generally hold this request, without responding, for up to the amount of time specified in the argument. If, at any time during the hold period, a state change occurs, the controller will return immediately with the new configuration generation number and/or MEL sequence number. By using this hanging poll approach, the amount of traffic between the client and the server is reduced to an insignificant level, and yet near-immediate notification of changes is still possible.
    * @const
    * @type {string}
    */
   getChangeState: 'getChangeState',

   /**
    * Causes the entire configuration of the storage array to be cleared to an initial state.
    * @const
    * @type {string}
    */
   clearSAConfiguration: 'clearSAConfiguration',

   /**
    * Tells the controller to automatically configure the Storage Array.
    * @const
    * @type {string}
    */
   autoSAConfiguration: 'autoSAConfiguration',

   /**
    * This procedure is used to determine the head and tail sequence numbers of entries in the storage array's Major Event Log. The client can use these values to manage controlled fetching of log entries.
    * @const
    * @type {string}
    */
   getMelExtent: 'getMelExtent',

   /**
    * This procedure allows a client to fetch a set of entries from the storage array's Major Event Log for analysis or display. Note that the MEL_MAX_XFER_COUNT constant specifies that maximum number of entries that can be requested in one operation. If more entries are needed, the client must fetch them iteratively, ensuring that no single request exceeds the transfer limit.
    * @const
    * @type {string}
    */
   getMelEntries: 'getMelEntries',

   /**
    * This procedure allows a client to fetch a set of entries with a priority value of EVENT_PRIORITY_CRITICAL from the storage array's Major Event Log for analysis or display. If there are less critical MEL events than MEL_MAX_XFER_COUNT, all the critical events will be displayed on the first call. If the client receives a number of critical MEL events that is equal to MEL_MAX_XFER_COUNT, then the user must increment the first sequence number to be the highest sequence number in the list of entries returned and repeat the procedure. This process must be repeated until the number of entries returned is less than MEL_MAX_XFER_COUNT.
    * @const
    * @type {string}
    */
   getCriticalMelEntries: 'getCriticalMelEntries',

   /**
    * This procedure allows a client to fetch the data that resides within a designated region of the controller's NVSRAM. Note that the NVSRAM data is obtained only from the controller to which this request is directed.
    * @const
    * @type {string}
    */
   getControllerNVSRAM: 'getControllerNVSRAM',

   /**
    * This procedure is used to modify a portion of the controller's NVSRAM. Note that the NVSRAM data is changed only on the controller to which this request is directed.
    * @const
    * @type {string}
    */
   setControllerNVSRAM: 'setControllerNVSRAM',

   /**
    * This procedure allows a client to change the administrative password that protects the storage array against unauthorized configuration changes.
    * @const
    * @type {string}
    */
   setSAPassword: 'setSAPassword',

   /**
    * This procedure simply verifies that the controller is responsive and is operating properly.
    * @const
    * @type {string}
    */
   pingController: 'pingController',

   /**
    * Initiates an explicit parity check operation. This is a background task that verifies the correctness of all parity/redundancy data for the volume. Only one such operation may be active at any time on a given controller. After initiating the operation with this procedure, the operation's progress can be checked via the getParityCheckProgress procedure. This procedure is deprecated. The scanVolume procedure should be used instead.
    * @const
    * @type {string}
    */
   startVolumeParityCheck: 'startVolumeParityCheck',

   /**
    * This procedure returns an indication of the progress of an explicit parity check operation on a particular volume. This procedure is deprecated. The scanVolume procedure should be used instead.
    * @const
    * @type {string}
    */
   getParityCheckProgress: 'getParityCheckProgress',

   /**
    * This procedure returns a list of LUN mappings that apply to the object identified by the argument SYMbolRef.
    * @const
    * @type {string}
    */
   getLUNMappings: 'getLUNMappings',

   /**
    * Creates a new SAPortGroup & returns its ref. If a group by that name already exists, returns its ref.. OBSOLETE: Any call to createSAPortGroup will get a return status indicating the command is obsolete. No alternative procedure is available.
    * @const
    * @type {string}
    */
   createSAPortGroup: 'createSAPortGroup',

   /**
    * Removes all SAPorts from an SAPortGroup, and deletes the group. OBSOLETE: Any call to deleteSAPortGroup will get a return status indicating the command is obsolete. No alternative procedure is available.
    * @const
    * @type {string}
    */
   deleteSAPortGroup: 'deleteSAPortGroup',

   /**
    * Removes the SA Port 'itemRef' from any SA Port Group that it might be in, & moves it to the group 'containerRef'. If this leaves the previous SAPortGroup empty, the previous SAPortGroup is deleted. OBSOLETE: Any call to moveSAPort will get a return status indicating the command is obsolete. No alternative procedure is available.
    * @const
    * @type {string}
    */
   moveSAPort: 'moveSAPort',

   /**
    * Retrieves a storage array port. OBSOLETE: Any call to getSAPort will get a return status indicating the command is obsolete. No alternative procedure is available.
    * @const
    * @type {string}
    */
   getSAPort: 'getSAPort',

   /**
    * This procedure causes a new Host object to be created using the parameters in the creation descriptor argument. After creating a host, host ports can be added to it, mappings established, etc.
    * @const
    * @type {string}
    */
   createHost: 'createHost',

   /**
    * This procedure causes a new Cluster object to be created and assigned the specified label. After creating a cluster, hosts can be added to it, mappings established, etc.
    * @const
    * @type {string}
    */
   createCluster: 'createCluster',

   /**
    * This procedure causes the Cluster object identified by the argument value to be deleted from the Storage Partitions configuration.
    * @const
    * @type {string}
    */
   deleteCluster: 'deleteCluster',

   /**
    * This procedure changes the user-assigned label for a Cluster object.
    * @const
    * @type {string}
    */
   renameCluster: 'renameCluster',

   /**
    * This procedure causes the Host object identified by the argument value to be deleted from the Storage Partitions configuration.
    * @const
    * @type {string}
    */
   deleteHost: 'deleteHost',

   /**
    * This procedure changes the user-assigned label for a Host object.
    * @const
    * @type {string}
    */
   renameHost: 'renameHost',

   /**
    * Changes the Storage Partitions configuration for a Host object by modifying the host's cluster assignment.
    * @const
    * @type {string}
    */
   moveHost: 'moveHost',

   /**
    * This procedure causes a new HostPort object to be created using the parameters in the creation descriptor argument. After creating a host, host ports can be added to it, mappings established, etc. This procedure does not work for iSCSI.
    * @const
    * @type {string}
    */
   createHostPort: 'createHostPort',

   /**
    * This procedure causes the HostPort object identified by the argument value to be deleted from the Storage Partitions configuration.
    * @const
    * @type {string}
    */
   deleteHostPort: 'deleteHostPort',

   /**
    * This procedure changes the user-assigned label for a HostPort object.
    * @const
    * @type {string}
    */
   renameHostPort: 'renameHostPort',

   /**
    * Changes the Storage Partitions configuration for a HostPort object by modifying the port's host assignment. This procedure does not apply for iSCSI .
    * @const
    * @type {string}
    */
   moveHostPort: 'moveHostPort',

   /**
    * This procedure causes a new LUNMapping object to be created using the parameters in the creation descriptor argument. Once this mapping is created, it provides a new LUN-to-volume mapping for I/O accesses from the specified entities to a given volume.
    * @const
    * @type {string}
    */
   createLUNMapping: 'createLUNMapping',

   /**
    * This procedure causes the LUNMapping object identified by the argument value to be deleted from the Storage Partitions configuration.
    * @const
    * @type {string}
    */
   deleteLUNMapping: 'deleteLUNMapping',

   /**
    * This procedure returns information about host ports whose world-wide names are known to the controller, but which have not been defined as full HostPort objects via the SYMbol interface. Note that you only need to send the request to one of the controllers, and that the same list of unlabeled host ports are returned, regardless of which controller receives the request. This procedure does not apply to iSCSI. The getUnconfiguredInitiators procedure should be used instead.
    * @const
    * @type {string}
    */
   getUnlabeledHostPorts: 'getUnlabeledHostPorts',

   /**
    * Changes the "host port type" attribute of a given HostPort object. Changing an individual host port type will cause all host port types to be changed if SPM is not enabled. This procedure does not apply to iSCSI; for iSCSI, the host type is set at the host level.
    * @const
    * @type {string}
    */
   setHostPortType: 'setHostPortType',

   /**
    * Move a LUN mapping.
    * @const
    * @type {string}
    */
   moveLUNMapping: 'moveLUNMapping',

   /**
    * This procedure causes the "premium" features identified in the feature keys of the argument to be enabled.
    * @const
    * @type {string}
    */
   enableFeature: 'enableFeature',

   /**
    * Disable a single add-on(optional feature
    * @const
    * @type {string}
    */
   disableFeature: 'disableFeature',

   /**
    * This procedure is used to capture current controller conditions as specified by the function being passed through the variable string input.
    * @const
    * @type {string}
    */
   stateCapture: 'stateCapture',

   /**
    * Downloads a portion of a new firmware image to a drive in the SYMbol Server. loadDriveFirmware OBSOLETED by implementation of parallel drive firmware download
    * @const
    * @type {string}
    */
   loadDriveFirmware: 'loadDriveFirmware',

   /**
    * This procedure is used to download some or all of a new firmware image to the ESM cards in a tray. The argument object specifies tray where the ESMs are located, the size of the firmware segment being downloaded, and the offset of the segment within the overall firmware image. Downloads are accomplished using an iterative approach, where the overall image is segmented and each segment transferred to the controller via a call to this procedure. To indicate the end of the iterative download sequence, this procedure should be called with a zero-length segment size. When this end indicator is received by the controller, the accumulated firmware image will be written to the ESM cards.
    * @const
    * @type {string}
    */
   loadESMFirmware: 'loadESMFirmware',

   /**
    * This procedure allows the Host Specific NVSRAM region to be read to obtain information for a specific host.
    * @const
    * @type {string}
    */
   getHostSpecificNVSRAM: 'getHostSpecificNVSRAM',

   /**
    * This procedure updates the NVSRAM for the Host Specific region.
    * @const
    * @type {string}
    */
   setHostSpecificNVSRAM: 'setHostSpecificNVSRAM',

   /**
    * This procedure sets the battery parameters for the given battery.
    * @const
    * @type {string}
    */
   setBatteryParams: 'setBatteryParams',

   /**
    * Instructs the SYMbol Server's controller to transfer ownership of a volume to another controller.
    * @const
    * @type {string}
    */
   assignVolumeOwnership: 'assignVolumeOwnership',

   /**
    * This procedure is used to start the Runtime Diagnostics.
    * @const
    * @type {string}
    */
   issueRuntimeDiagnostics: 'issueRuntimeDiagnostics',

   /**
    * This procedure requests a reboot of the given controller.
    * @const
    * @type {string}
    */
   resetController: 'resetController',

   /**
    * This procedure is used to put the controller in a quiesced state.
    * @const
    * @type {string}
    */
   quiesceController: 'quiesceController',

   /**
    * This procedure is used to take a controller out of the quiesced state.
    * @const
    * @type {string}
    */
   unquiesceController: 'unquiesceController',

   /**
    * This procedure checks to make sure the additional capacity is available and then starts a DVE or DCE/DVE operation.
    * @const
    * @type {string}
    */
   startVolumeExpansion: 'startVolumeExpansion',

   /**
    * Create a snapshot volume of a given base.
    * @const
    * @type {string}
    */
   createSnapshot: 'createSnapshot',

   /**
    * This procedure will disable (stop) the indicated snapshot volume.
    * @const
    * @type {string}
    */
   disableSnapshot: 'disableSnapshot',

   /**
    * This procedure restarts a snapshot volume that was previously created. The snapshot must have been previously disabled for this procedure to succeed.
    * @const
    * @type {string}
    */
   recreateSnapshot: 'recreateSnapshot',

   /**
    * This procedure is used to set various snapshot parameters including the repository warning threshold, the repository full policy, and the rollback operation priority.
    * @const
    * @type {string}
    */
   setSnapshotParams: 'setSnapshotParams',

   /**
    * This procedure is used by clients to obtain information about the utilization of the repository volume for selected snapshots.
    * @const
    * @type {string}
    */
   getRepositoryUtilization: 'getRepositoryUtilization',

   /**
    * Calculates the volume's maximum capacity after a DVE operation
    * @const
    * @type {string}
    */
   calculateDVECapacity: 'calculateDVECapacity',

   /**
    * This procedure returns the Read Link Status information.
    * @const
    * @type {string}
    */
   getReadLinkStatus: 'getReadLinkStatus',

   /**
    * This procedure sets the RLS baseline for all devices. The baseline is used to indicate the difference in error counts from when the baseline was established and the time at which the RLS data is requested.
    * @const
    * @type {string}
    */
   setRLSBaseline: 'setRLSBaseline',

   /**
    * This procedure returns the amount of storage required for a metadata volume.
    * @const
    * @type {string}
    */
   getMetadataVolumeCapacity: 'getMetadataVolumeCapacity',

   /**
    * Create a metadata volume
    * @const
    * @type {string}
    */
   createMetadataVolume: 'createMetadataVolume',

   /**
    * Activate Remote Mirroring
    * @const
    * @type {string}
    */
   activateMirroring: 'activateMirroring',

   /**
    * Deactivate Remote Mirroring
    * @const
    * @type {string}
    */
   deactivateMirroring: 'deactivateMirroring',

   /**
    * Change MirrorProxy Synchronization Priority
    * @const
    * @type {string}
    */
   changeSynchronizationPriority: 'changeSynchronizationPriority',

   /**
    * This procedure returns a list of mirror volume candidates that can be used in an ensuing mirror volume creation request.
    * @const
    * @type {string}
    */
   getVolumeListForMirroring: 'getVolumeListForMirroring',

   /**
    * Create a Mirror
    * @const
    * @type {string}
    */
   createMirror: 'createMirror',

   /**
    * This procedure changes the role of the mirror volume.
    * @const
    * @type {string}
    */
   roleChange: 'roleChange',

   /**
    * Deletes a mirror volume.
    * @const
    * @type {string}
    */
   removeMirror: 'removeMirror',

   /**
    * This procedure starts the synchronization process on a mirror.
    * @const
    * @type {string}
    */
   startSyncMirror: 'startSyncMirror',

   /**
    * This procedure causes visual indicators to be activated on the specified channel. The indicators will remain active until the stopIdentification procedure is invoked.
    * @const
    * @type {string}
    */
   startChannelIdentification: 'startChannelIdentification',

   /**
    * This procedure causes visual indicators to be activated on the physical storage array unit to allow an end-user to visually identify the trays. The indicators will remain active until the stopIdentification procedure is invoked.
    * @const
    * @type {string}
    */
   startTrayIdentification: 'startTrayIdentification',

   /**
    * This procedure gets a list of volumes encroaching the requested Dacstore area.
    * @const
    * @type {string}
    */
   getDacstoreIncompatibleVolumes: 'getDacstoreIncompatibleVolumes',

   /**
    * This procedure gets the internal clock from the controllers. The time is expressed in seconds since midnight (GMT) on 1/1/1970.
    * @const
    * @type {string}
    */
   getControllerTime: 'getControllerTime',

   /**
    * This procedure establishes a volume copy.
    * @const
    * @type {string}
    */
   establishVolumeCopy: 'establishVolumeCopy',

   /**
    * Removes a volume copy.
    * @const
    * @type {string}
    */
   removeVolumeCopy: 'removeVolumeCopy',

   /**
    * This procedure modifies the parameters of a volume copy.
    * @const
    * @type {string}
    */
   setVolumeCopyParams: 'setVolumeCopyParams',

   /**
    * This procedure takes as its input a VolumeCopyRef and causes a copy operation to be initiated from the beginning of the Source volume. A failure status is returned if the Source and Target volumes do not meet compatibility requirements.
    * @const
    * @type {string}
    */
   startVolumeCopy: 'startVolumeCopy',

   /**
    * This procedure halts the active copy.
    * @const
    * @type {string}
    */
   stopVolumeCopy: 'stopVolumeCopy',

   /**
    * This procedure returns a list of volume target candidates for creating a volume copy. (NOTE: Going forward getVolumeCopyTargetCandidateList will replace this.)
    * @const
    * @type {string}
    */
   getVolumeCopyTargetCandidates: 'getVolumeCopyTargetCandidates',

   /**
    * This procedure returns a list of volume source candidates for creating a volume copy.
    * @const
    * @type {string}
    */
   getVolumeCopySourceCandidates: 'getVolumeCopySourceCandidates',

   /**
    * This procedure updates the network parameters.
    * @const
    * @type {string}
    */
   setNetworkParameters: 'setNetworkParameters',

   /**
    * This procedure allows rlogin to the controller to be enabled or disabled.
    * @const
    * @type {string}
    */
   setRloginCapability: 'setRloginCapability',

   /**
    * This procedure is used to set the delay period before a volume transfer alert is issued.
    * @const
    * @type {string}
    */
   setVolXferAlertDelayPeriod: 'setVolXferAlertDelayPeriod',

   /**
    * Get the list of persistent registrations on the array OBSOLETE: Any call to getPersistantReservations will get a return status indicating the command is obsolete. Please use the new command getPRegistrations.
    * @const
    * @type {string}
    */
   getPersistentRegistrations: 'getPersistentRegistrations',

   /**
    * Get the persistent registrations for the specified volume. The list will contain no more than one PersistentRegistration element. OBSOLETE: Any call to getPersistantReservationsForVolume will get a return status indicating the command is obsolete. Please use the new commands getPRegistrationsForVolume.
    * @const
    * @type {string}
    */
   getPersistentRegistrationsForVolume: 'getPersistentRegistrationsForVolume',

   /**
    * This procedure clears registrations and reservations for specific volumes. A UNIT ATTENTION, RESERVATIONS PREEMPTED condition is established for the former registrants.
    * @const
    * @type {string}
    */
   clearPersistentRegistrations: 'clearPersistentRegistrations',

   /**
    * Change mirror write mode
    * @const
    * @type {string}
    */
   changeMirrorWriteMode: 'changeMirrorWriteMode',

   /**
    * This procedure suspends the communication between a mirror pair.
    * @const
    * @type {string}
    */
   suspendMirror: 'suspendMirror',

   /**
    * This procedure resumes the communication between a mirror pair.
    * @const
    * @type {string}
    */
   resumeMirror: 'resumeMirror',

   /**
    * This procedure sets the allowable options for the auto resynchronization.
    * @const
    * @type {string}
    */
   setAutoResync: 'setAutoResync',

   /**
    * Activate staged controller firmware
    * @const
    * @type {string}
    */
   activateStagedControllerFirmware: 'activateStagedControllerFirmware',

   /**
    * This procedure invalidates the staged controller firmware.
    * @const
    * @type {string}
    */
   invalidateStagedControllerFirmware: 'invalidateStagedControllerFirmware',

   /**
    * This procedure gets the drive's log sense pages.
    * @const
    * @type {string}
    */
   getDriveLogData: 'getDriveLogData',

   /**
    * This procedure automatically gets the configuration candidates.
    * @const
    * @type {string}
    */
   getAutoConfigCandidates: 'getAutoConfigCandidates',

   /**
    * Create automatic configuration
    * @const
    * @type {string}
    */
   createAutoConfig: 'createAutoConfig',

   /**
    * Automatically assign hot spares
    * @const
    * @type {string}
    */
   autoAssignHotSpares: 'autoAssignHotSpares',

   /**
    * This procedure returns a list of all hot spare drives and their volume groups.
    * @const
    * @type {string}
    */
   getHotSpareCoverage: 'getHotSpareCoverage',

   /**
    * This procedure returns a list of hot spare candidates with the volume groups that they potentially cover.
    * @const
    * @type {string}
    */
   getHotSpareCandidates: 'getHotSpareCandidates',

   /**
    * This procedure returns a list of the known unreadable sectors for the system.
    * @const
    * @type {string}
    */
   readUnreadableSectorDatabase: 'readUnreadableSectorDatabase',

   /**
    * Clears all the unreadable sectors for the given Volume
    * @const
    * @type {string}
    */
   clearUnreadableSectors: 'clearUnreadableSectors',

   /**
    * Sending an RVM Communication Check command
    * @const
    * @type {string}
    */
   communicationCheck: 'communicationCheck',

   /**
    * This procedure starts the parallel drive firmware download process.
    * @const
    * @type {string}
    */
   startDriveFirmwareDownload: 'startDriveFirmwareDownload',

   /**
    * This procedure sends chunks to the parallel drive firmware download process.
    * @const
    * @type {string}
    */
   sendDriveFirmware: 'sendDriveFirmware',

   /**
    * This procedure starts the drive download stage of the parallel drive firmware download process.
    * @const
    * @type {string}
    */
   updateDriveFirmware: 'updateDriveFirmware',

   /**
    * This procedure stops the parallel drive firmware download process.
    * @const
    * @type {string}
    */
   stopDriveFirmwareDownload: 'stopDriveFirmwareDownload',

   /**
    * This procedure gets the progress of the firmware download.
    * @const
    * @type {string}
    */
   getDriveFirmwareDownloadProgress: 'getDriveFirmwareDownloadProgress',

   /**
    * This procedure creates a volume using the parameters of a volume that previously existed. Since no data or parity initialization is performed on the volume, the prior data is preserved resulting in a volume that is identical to the previous volume.
    * @const
    * @type {string}
    */
   recoverVolume: 'recoverVolume',

   /**
    * This procedure sets the drive channel state to either degraded or optimal.
    * @const
    * @type {string}
    */
   setDriveChannelState: 'setDriveChannelState',

   /**
    * This procedure gets statistical information about all of the drive channels.
    * @const
    * @type {string}
    */
   getDriveChannelStatistics: 'getDriveChannelStatistics',

   /**
    * Clear the drive channel cumulative statistic information
    * @const
    * @type {string}
    */
   clearDriveChannelStatistics: 'clearDriveChannelStatistics',

   /**
    * This procedure suspends the communications for all mirrors in a Write Consistency group with a specified group number.
    * @const
    * @type {string}
    */
   suspendConsistencyGroup: 'suspendConsistencyGroup',

   /**
    * This procedure resumes the communication for all mirrors in a Write Consistency group with a specified group number.
    * @const
    * @type {string}
    */
   resumeConsistencyGroup: 'resumeConsistencyGroup',

   /**
    * This procedure places a controller in Service Mode. It replaces the obsolete setControllerToPassive procedure. The command is serviced by the controller opposite to controllerRef.
    * @const
    * @type {string}
    */
   setControllerServiceMode: 'setControllerServiceMode',

   /**
    * This procedure causes a scan of the specified volume over the specified extent. The scan stops on any media or parity error encountered and reports the error. The procedure can also be used to repair media errors and parity errors.
    * @const
    * @type {string}
    */
   scanVolume: 'scanVolume',

   /**
    * This procedure changes the mgmtClientAttribute for a volume.
    * @const
    * @type {string}
    */
   updateVolumeAttribute: 'updateVolumeAttribute',

   /**
    * This procedure saves a new value of the specified MgmtClientRecord.
    * @const
    * @type {string}
    */
   writeMgmtClientRecords: 'writeMgmtClientRecords',

   /**
    * This procedure reads a range of (i.e. one or more) MgmtClient Record objects.
    * @const
    * @type {string}
    */
   readMgmtClientRecords: 'readMgmtClientRecords',

   /**
    * This procedure deletes a range of (i.e. one or more) specified MgmtCleintRecords.
    * @const
    * @type {string}
    */
   deleteMgmtClientRecords: 'deleteMgmtClientRecords',

   /**
    * This procedure suspends the communication between all mirrored pairs specified in the MirrorVolumeList.
    * @const
    * @type {string}
    */
   suspendMirrorList: 'suspendMirrorList',

   /**
    * This procedure resumes the communication between all mirrored pairs specified in the MirrorVolumeList.
    * @const
    * @type {string}
    */
   resumeMirrorList: 'resumeMirrorList',

   /**
    * This procedure returns a list of persistent registrations on the array.
    * @const
    * @type {string}
    */
   getPRegistrations: 'getPRegistrations',

   /**
    * Updates the Tray ID of a tray.
    * @const
    * @type {string}
    */
   updateTray: 'updateTray',

   /**
    * This procedure sets the allowed alarm controls.
    * @const
    * @type {string}
    */
   setAlarm: 'setAlarm',

   /**
    * This procedure executes the inter-controller discrete line diagnostics test.
    * @const
    * @type {string}
    */
   issueDiscreteLinesTest: 'issueDiscreteLinesTest',

   /**
    * This procedure turns the Ready to Remove indicator light on or off or puts the Ready to Remove indicator into automatic mode, for the component specified in the RTRUpdateDescriptor. This procedure is deprecated. The requestRemoval procedure should be used instead.
    * @const
    * @type {string}
    */
   requestToRemove: 'requestToRemove',

   /**
    * This procedure is used to enable and disable Simplex mode.
    * @const
    * @type {string}
    */
   setSimplexMode: 'setSimplexMode',

   /**
    * This procedure returns a list of the persistent registrations for the specified volume.
    * @const
    * @type {string}
    */
   getPRegistrationsForVolume: 'getPRegistrationsForVolume',

   /**
    * This procedure turns the Ready to Remove indicator light on or off or puts the Ready to Remove indicator into automatic mode, for the component specified in the RTRUpdateDescriptor.
    * @const
    * @type {string}
    */
   requestRemoval: 'requestRemoval',

   /**
    * This procedure returns SOC error statistics.
    * @const
    * @type {string}
    */
   getSocErrorStatistics: 'getSocErrorStatistics',

   /**
    * Set SOC error statistics baseline information
    * @const
    * @type {string}
    */
   clearSocErrorStatistics: 'clearSocErrorStatistics',

   /**
    * This procedure allows a client to retrieve diagnostic information from the storage array's diagnostic data capture. The client must specify a correct tag and appropriate chunk number. In case of failure, the client must either (1) retry the current chunk number or (2) discard any partially-received log data and retry from the first chunk number (which is one - zero is not a valid chunk number).
    * @const
    * @type {string}
    */
   getDdcLog: 'getDdcLog',

   /**
    * This procedure clears the Needs Attention signifying the availability of diagnostic data. The client must specify a correct tag. This procedure does not clears the DDC logs in the controller.
    * @const
    * @type {string}
    */
   clearDdcNeedsAttention: 'clearDdcNeedsAttention',

   /**
    * This command provides a programmatic means of powering off a storage array The operation is performed as gracefully as possible. Once this command is received, all open sockets, except for those that have in-process commands, are closed, meaning that any new SYMbol commands attempted will receive an RPC error. SYMbol commands that are in-process when this command is received are allowed to continue execution. In-process SYMbol commands in the "active" category are guaranteed to complete; In-process commands in the "passive" category may complete, but there is no guarantee. This command returns and reports status just prior to the actual power down event. Authentication is required for this command.
    * @const
    * @type {string}
    */
   powerDownArray: 'powerDownArray',

   /**
    * This procedure is used to download a new firmware image to the ESM cards in a tray. This procedure is identical in behavior to loadESMFirmware. with respect to interpretation of the argument and performing the download process. It differs from that command with respect to certain pre-validation checks it performs. In particular, it requires that an ESM firmware mismatch condition exist on the indicated tray before it will proceed with the download.
    * @const
    * @type {string}
    */
   loadEsmFirmwareOnMismatch: 'loadEsmFirmwareOnMismatch',

   /**
    * This procedure causes the controller to store some or all of the information contained in the PendingHost argument. The information is simply stored and made available for later retrieval (see getPendingHosts procedure); it is not incorporated into the configured topology, and it is not persisted to disk. If the controller determines that the pending definition is an exact match of configured topology elements, it does not store it. It bears pointing out that, for iSCSI, multiple ports belonging to the same initiator may be present in the pending host information - when this happens, the controller creates only a single initiator, no matter how many ports for that initiator are presented. No authentication is performed on this command.
    * @const
    * @type {string}
    */
   addPendingHost: 'addPendingHost',

   /**
    * This procedure is subject to SYMbol authentication.
    * @const
    * @type {string}
    */
   configurePendingHost: 'configurePendingHost',

   /**
    * @const
    * @type {string}
    */
   getPendingHosts: 'getPendingHosts',

   /**
    * This procedure sets arbitrary "attribute data" for a specified tray enclosure. Only the attributes specified in the argument are affected by this operation. The old data in an affected attribute is completely overwritten by the new attribute data.
    * @const
    * @type {string}
    */
   setTrayAttributes: 'setTrayAttributes',

   /**
    * This procedure gets the log data for the indicated environmental card.
    * @const
    * @type {string}
    */
   getEnvCardLogData: 'getEnvCardLogData',

   /**
    * This procedure returns the SAS PHY error statistics for all SAS devices in the storage array.
    * @const
    * @type {string}
    */
   getSasErrorStatistics: 'getSasErrorStatistics',

   /**
    * Clears SAS PHY error statistics for SAS I/O controller and expander devices in the array
    * @const
    * @type {string}
    */
   clearSasErrorStatistics: 'clearSasErrorStatistics',

   /**
    * This procedure causes the storage array to be migrated from one feature bundle definition to another, as specified in the BundleKey argument.
    * @const
    * @type {string}
    */
   applyBundleKey: 'applyBundleKey',

   /**
    * Removes all bundle keys that have been applied to change feature bundles.
    * @const
    * @type {string}
    */
   removeBundleKeys: 'removeBundleKeys',

   /**
    * This procedure creates a new initiator object.
    * @const
    * @type {string}
    */
   createInitiator: 'createInitiator',

   /**
    * This procedure deletes an initiator object.
    * @const
    * @type {string}
    */
   deleteInitiator: 'deleteInitiator',

   /**
    * This procedure returns data about active iSCSI sessions.
    * @const
    * @type {string}
    */
   getIscsiSessions: 'getIscsiSessions',

   /**
    * This procedure returns the default values for negotiable settings for sessions and connections. These represent the storage array's starting point for negotiations.
    * @const
    * @type {string}
    */
   getIscsiNegotiationDefaults: 'getIscsiNegotiationDefaults',

   /**
    * This procedure returns a list of initiators that have been detected by the storage array, but which are not configured into the storage array topology. An initiator is considered unconfigured if it is not associated with a host.
    * @const
    * @type {string}
    */
   getUnconfiguredInitiators: 'getUnconfiguredInitiators',

   /**
    * This procedure sets selected host properties as indicated by the input argument. It is a replacement for the deprecated moveHost, renameHost.
    * @const
    * @type {string}
    */
   setHostProperties: 'setHostProperties',

   /**
    * This procedure sets selected Initiator properties as indicated by the input argument.
    * @const
    * @type {string}
    */
   setInitiatorProperties: 'setInitiatorProperties',

   /**
    * This procedure sets selected iSCSI entity properties for the storage array as indicated by the input argument.
    * @const
    * @type {string}
    */
   setIscsiEntityProperties: 'setIscsiEntityProperties',

   /**
    * This procedure sets selected properties of a controller iSCSI interface, as indicated by the input argument.
    * @const
    * @type {string}
    */
   setIscsiInterfaceProperties: 'setIscsiInterfaceProperties',

   /**
    * This procedure sets selected Target properties as indicated by the input argument.
    * @const
    * @type {string}
    */
   setTargetProperties: 'setTargetProperties',

   /**
    * This procedure forcibly terminates an iSCSI session.
    * @const
    * @type {string}
    */
   stopIscsiSession: 'stopIscsiSession',

   /**
    * This procedure returns iSCSI statistical data collected by the storage array. The caller may request either the "raw" counts, which are relative to controller start-of-day, or baseline-relative counters, which are relative to the baseline which was last set using the setIscsiStatisticsBaselilne procedure. If the user has not set a baseline since controller start-of-day, then the time at start-of-day is the default baseline time.
    * @const
    * @type {string}
    */
   getIscsiStatistics: 'getIscsiStatistics',

   /**
    * This procedure, from the client's perspective, resets the iSCSI statistical counters to zero. It is a logical reset in the sense that the raw counts maintained in hardware and firmware are not actually reset; instead the firmware makes a snapshot of the current counter values and uses that to report deltas in counts when the statistics are fetched. The new baseline time is applied to both controllers, so that their counts are in sync with one another. If one controller resets without the other resetting, the counters become effectively out of sync and the client is made aware of this fact by the timestamp data reported along with the statistics.
    * @const
    * @type {string}
    */
   setIscsiStatisticsBaseline: 'setIscsiStatisticsBaseline',

   /**
    * This procedure sets selected properties for the storage array that is the recipient of the call.
    * @const
    * @type {string}
    */
   setStorageArrayProperties: 'setStorageArrayProperties',

   /**
    * This procedure validates the clients storage array password and reports a return code indicating whether or not the password is valid. Even though it does not modify the state of the array, this procedure behaves the same and has the same setup requirements as a procedure that does modify the state of the array.
    * @const
    * @type {string}
    */
   validatePassword: 'validatePassword',

   /**
    * This procedure performs a refresh of the DHCP parameters for the iSCSI interface specified by the input argument. The affected parameters are port IP address, subnet mask, and gateway IP address.
    * @const
    * @type {string}
    */
   refreshIscsiDhcpParameters: 'refreshIscsiDhcpParameters',

   /**
    * This procedure causes the storage array to refresh its idea of the network address information for the iSNS server
    * @const
    * @type {string}
    */
   refreshIsnsServerLocation: 'refreshIsnsServerLocation',

   /**
    * This procedure will disable (stop) each snapshot volume identified in the argument list. Validation checks for necessary snapshot-disable preconditions are performed prior to disabling any snapshot; if any of the requested snapshots do not meet the preconditions to be disabled, the entire command will be failed and no snapshots will be disabled. If command validation succeeds for all snapshots in the list, but one or more of the snapshots in the list fails to be disabled, the entire command will be failed and no snapshots will be disabled. Requests to disable an already-disabled Snapshot will be treated as no-ops and will be considered successful.
    * @const
    * @type {string}
    */
   disableSnapshotCollection: 'disableSnapshotCollection',

   /**
    * During snapshot recreation, all affected volumes (snapshots, base, and repository) will be appropriately quiesced; I/O will be resumed to all affected volumes once all snapshots have been successfully restarted.
    * @const
    * @type {string}
    */
   recreateSnapshotCollection: 'recreateSnapshotCollection',

   /**
    * Create an empty VolumeGroup
    * @const
    * @type {string}
    */
   createVolumeGroup: 'createVolumeGroup',

   /**
    * Delete VolumeGroup and all Volumes in that group
    * @const
    * @type {string}
    */
   deleteVolumeGroup: 'deleteVolumeGroup',

   /**
    * This procedure provides a way to clear the storage array configuration without bringing it all the way back to its initial state. Core security and identification may be retained, if desired.
    * @const
    * @type {string}
    */
   resetSAConfiguration: 'resetSAConfiguration',

   /**
    * Sets the user assigned label for the volume group specified in the VolumeGroupLabelUpdate structure.
    * @const
    * @type {string}
    */
   setVolumeGroupUserLabel: 'setVolumeGroupUserLabel',

   /**
    * This procedure causes a drive, A, that is not part of a volume group to replace a drive, B, that is part of a volume group. The end result is that the volume group drive composition is redefined to include A, and exclude B. The only candidate drives for being replaced are those that belong to a volume group and are either not-present or are failed. The only candidate drives for replacing a drive are those that are either unassigned or are a fully-integrated hot spare.
    * @const
    * @type {string}
    */
   replaceDrive: 'replaceDrive',

   /**
    * The firmware prioritizes the properties of candidates for constructing the return list, subject to the volume group having a given property in the first place. The prioritization and ordering of the list is as follows:
    * @const
    * @type {string}
    */
   getVolumeGroupExpansionCandidates: 'getVolumeGroupExpansionCandidates',

   /**
    * This procedure places the identified volume group in an "exported" state so that its drives may be removed and installed into another array.
    * @const
    * @type {string}
    */
   exportVolumeGroup: 'exportVolumeGroup',

   /**
    * This procedure applies to a volume group for which successful migration of drives from the source array to the target array could not be completed due to hardware errors. It causes the identified volume group to move to a state called the "forced" state, from which it is still permissible to perform an import operation on the volume group.
    * @const
    * @type {string}
    */
   forceVolumeGroup: 'forceVolumeGroup',

   /**
    * This procedure causes the identified volume group to be imported, which move it from either the "exported" state or the "forced" state to the "complete" state in which it is fully operable and available for use. Note that "higher-level" volumes (SnapshotVolume, MetadataVolume, VolumeCopy, and MirrorProxyVolume) - but not their underlying RAID volumes - are removed as part of the import.
    * @const
    * @type {string}
    */
   importVolumeGroup: 'importVolumeGroup',

   /**
    * This procedure activates the collection of a set of statistics known as a "discrete time series" (discrete time) on each control of the array. A discrete time is a time-ordered sequence of observations of a single statistic, sampled at regular intervals.
    * @const
    * @type {string}
    */
   activateDiscreteTimeSeries: 'activateDiscreteTimeSeries',

   /**
    * This procedure deactivates the discrete time series statistical streams
    * @const
    * @type {string}
    */
   deactivateDiscreteTimeSeries: 'deactivateDiscreteTimeSeries',

   /**
    * This returns up to two groups of discrete time series statistics, one per controller
    * @const
    * @type {string}
    */
   getDiscreteTimeSeriesBundle: 'getDiscreteTimeSeriesBundle',

   /**
    * This procedure resets the related discrete time series statistical streams on both controller, i.e., it sets the number of observations for the series back to zero.
    * @const
    * @type {string}
    */
   resetDiscreteTimeSeries: 'resetDiscreteTimeSeries',

   /**
    * This procedure returns up to two groups of histogram statistics, one per controller,
    * @const
    * @type {string}
    */
   getHistogramBundle: 'getHistogramBundle',

   /**
    * This procedure activates a type of statistics stream known as a histogram on each controller of the array. A histogram is a set of observations of a single statistic, organized into categories based on user criteria, with observation counts per category identified.
    * @const
    * @type {string}
    */
   activateHistogram: 'activateHistogram',

   /**
    * This procedure deactivates a histogram statistics set, given a stream ID.
    * @const
    * @type {string}
    */
   deactivateHistogram: 'deactivateHistogram',

   /**
    * This procedure resets the related histograms both controllers, i.e., it sets the number of entries in each category and all observation tallies back to zero.
    * @const
    * @type {string}
    */
   resetHistogram: 'resetHistogram',

   /**
    * This procedure returns up to two groups of statistical counters, one per controller, bundled together. A counter group is a set of related statistical counters, accumulated over a period of time, along with the associated base time.
    * @const
    * @type {string}
    */
   getCumulativeStatisticsBundle: 'getCumulativeStatisticsBundle',

   /**
    * This procedure sets all cumulative statistics on each controller back to zero and sets a new base time equal to the current time.
    * @const
    * @type {string}
    */
   resetCumulativeStatistics: 'resetCumulativeStatistics',

   /**
    * This procedure returns a list of volume group export dependencies for the identified volume group. The returned list consists of the input volume group's immediate export dependencies only. The procedure does not return transitive dependencies. It is up to the caller to create the complete dependency graph through successive calls to this procedure.
    * @const
    * @type {string}
    */
   getExportDependencies: 'getExportDependencies',

   /**
    * Deletes the snapshot volume identified by the input argument. All data on the volume is lost and all resources associated with maintaining the snapshot are released.
    * @const
    * @type {string}
    */
   deleteSnapshot: 'deleteSnapshot',

   /**
    * This procedure deletes the volume referenced by the input argument. The procedure allows the caller to specify which behavior is desired for the case of deleting the last volume in the volume group - either delete or retain the volume group.
    * @const
    * @type {string}
    */
   deleteVolumeFromGroup: 'deleteVolumeFromGroup',

   /**
    * This procedure indicates to the storage array firmware that the client does not want to proceed with a volume group import operation, and therefore the firmware may spin down the drives that were spun up by the get- ImportDependencies procedure.
    * @const
    * @type {string}
    */
   cancelImport: 'cancelImport',

   /**
    * This procedure returns a list of volume group import dependencies for the identified volume group. The reported information identifies the types of dependencies that exist for the volume group. It is necessary for this procedure to spin up the drives in the volume group so that their configuration databases can be read. An error is returned if the volume group is not in the exported or forced state.
    * @const
    * @type {string}
    */
   getImportDependencies: 'getImportDependencies',

   /**
    * This procedure is used for setting new values of certain volume properties. It supports setting some properties while leaving others unchanged.
    * @const
    * @type {string}
    */
   setVolumeProperties: 'setVolumeProperties',

   /**
    * This procedure caused the storage array to "adopt" all foreign drives that are eligible to be adopted. Adoption means accepting or incorporating elements of a foreign drive's configuration database into that of the recipient array. It must be possible for the storage array to match the adoption-candidate drives with ones that are currently being tracked as "not present." In addition, several other technical criteria must be met in order for the adoption to succeed.
    * @const
    * @type {string}
    */
   adoptAllDrives: 'adoptAllDrives',

   /**
    * This procedure caused the storage array to "adopt" a foreign drive that is eligible to be adopted. Adoption means accepting or incorporating elements of a foreign drive's configuration database into that of the recipient array. It must be possible for the storage array to match the adoption-candidate drive with one that is currently being tracked as "not present." In addition, several other technical criteria must be met in order for the adoption to succeed.
    * @const
    * @type {string}
    */
   adoptDrive: 'adoptDrive',

   /**
    * This procedure replaces the deprecated stateCapture procedure. It returns a single "chunk" of debug information and must be used in a series of like calls in order to retrieve the complete set of debug information.
    * @const
    * @type {string}
    */
   getControllerDebugInformation: 'getControllerDebugInformation',

   /**
    * This procedure returns attribute information for each InfiniBand I/O controller that is part of the Infiniband I/O Unit. An InfiniBand I/O Controller is a logical entity defined in the InfiniBand Architecture. It does not correlate one-to-one with a storage array controller
    * @const
    * @type {string}
    */
   getIbIocAttributes: 'getIbIocAttributes',

   /**
    * This procedure returns a group of InfiniBand port partition tables, one table for each InfiniBand port of the Infiniband I/O Unit (i.e., storage array).
    * @const
    * @type {string}
    */
   getIbPortPartitionTables: 'getIbPortPartitionTables',

   /**
    * This procedure returns various items of information about InfiniBand RDMA channels that are presently active in the Infiniband I/O Unit (i.e., storage array).
    * @const
    * @type {string}
    */
   getIbRdmaChannels: 'getIbRdmaChannels',

   /**
    * This procedure returns the InfiniBand statistics, which consist of start-of-day-relative interface statistics, baseline-relative interface statistics, target channel adapter statistics, and RDMA channel statistics.
    * @const
    * @type {string}
    */
   getIbStatistics: 'getIbStatistics',

   /**
    * This procedure, from the client's perspective, resets the InfiniBand baselined statistical counters to zero. It is a logical reset in the sense that the raw counts maintained in hardware and firmware are not actually reset; instead the firmware makes a snapshot of the current counter values and uses that to report deltas in counts when the statistics are fetched. The new baseline time is applied to both controllers, so that their counts are in sync with one another. If one controller resets without the other resetting, the counters become effectively out of sync and the client is made aware of this fact by the timestamp data reported along with the statistics.
    * @const
    * @type {string}
    */
   setIbStatisticsBaseline: 'setIbStatisticsBaseline',

   /**
    * This procedure creates a new host port having the attributes specified in the input argument. It is a replacement for the deprecated createHostPort procedure.
    * @const
    * @type {string}
    */
   createAHostPort: 'createAHostPort',

   /**
    * When this command is issued directly to the controller for which the Ethernet properties will change, controller firmware will issue a return code of RETCODE_BACKGROUND to the storage management software before resetting the Ethernet properties and stopping communication. Storage management software developers should maintain both old and new Ethernet properties for the controller in case the procedure fails (if the procedure fails at this point status will not be able to be returned and the storage management software should reestablish communication with the controller using the old Ethernet properties).
    * @const
    * @type {string}
    */
   setEthernetInterfaceProperties: 'setEthernetInterfaceProperties',

   /**
    * This procedure sets selected HostPort properties, as specified by the input argument. It is a replacement for the deprecated moveHostPort, renameHostPort.
    * @const
    * @type {string}
    */
   setHostPortProperties: 'setHostPortProperties',

   /**
    * This procedure is for setting certain changeable properties of an individual controller. The procedure works in such a way that specific properties can be changed while leaving others unchanged.
    * @const
    * @type {string}
    */
   setControllerProperties: 'setControllerProperties',

   /**
    * This procedure initiates a drive channel fault isolation diagnostic test. It returns a status code immediately and the requested tests proceed asynchronously. Any SYMbol request, other than getChannelDiagnosticsResults, cancelChannelDiagnostics, bindToController, and getSAData that is received while the test is running is rejected immediately. Since some SYMbol procedures do not provide a return code, the method of indicating the request rejection is specialized and entails the following: The RPC header that is returned to the client will consist of an RPC response of type "reply message." The reply will have a general status of "accepted," indicating the request was accepted by the controller for processing. The specific "accepted request status" value will be 0x80000001, which is an indication that the request could not be processed due to a diagnostic activity.
    * @const
    * @type {string}
    */
   startChannelDiagnostics: 'startChannelDiagnostics',

   /**
    * This procedure cancels a running channel diagnostic test sequence that was initiated by the startChannelDiagnostics procedure. It is possible to retrieve the (partial) results of a canceled test by calling getChannelDiagnosticsResults.
    * @const
    * @type {string}
    */
   stopChannelDiagnostics: 'stopChannelDiagnostics',

   /**
    * This procedure reports the results of drive channel fault isolation diagnostic tests that were initiated by the startChannelDIagnostics procedure.
    * @const
    * @type {string}
    */
   getChannelDiagnosticsResults: 'getChannelDiagnosticsResults',

   /**
    * NOTE: object graph data may not be the most recent.
    * @const
    * @type {string}
    */
   getControllerHostIoInterfaces: 'getControllerHostIoInterfaces',

   /**
    * Returns a structure containing information about the controller if it is locked down.
    * @const
    * @type {string}
    */
   getCtlLockDownInfo: 'getCtlLockDownInfo',

   /**
    * To indicate the end of the iterative download sequence, call this procedure with a zero-length segment size. When the controller receives this end indicator, the controller writes the accumulated firmware image to stable storage (typically flash memory). The controller responds to this procedure call with the appropriate return code, delays for a short period, and then reboots to load and execute the new firmware.
    * @const
    * @type {string}
    */
   loadControllerFirmwareOnLockdown: 'loadControllerFirmwareOnLockdown',

   /**
    * Disables protection information (PI) usage for the specified volume.
    * @const
    * @type {string}
    */
   disableVolumeProtectionInformation: 'disableVolumeProtectionInformation',

   /**
    * This procedure is used in conjunction with the createLockKey procedure. This request may be issued to change the existing array lock key or to set an array lock key after a database adoption. The procedure commits the lock key generated by the createLockKey procedure to the drives and to the controllers.
    * @const
    * @type {string}
    */
   setLockKey: 'setLockKey',

   /**
    * This procedure allows a security locked drive to be unlocked. An archived, wrapped and encrypted lock key is imported into the array. In response, the controller attempts to unlock all security-locked drives that have a matching lock key ID. The imported lock key and lock key id become the new array lock key and lock key ID.
    * @const
    * @type {string}
    */
   importLockKey: 'importLockKey',

   /**
    * This procedure returns the WrappedLockKeyReturn union for the array.The WrappedLockKeyReturn contains the WrappedLockKey structure for the array it was exported from.
    * @const
    * @type {string}
    */
   exportLockKey: 'exportLockKey',

   /**
    * This procedure resets each drive's lock key to a new, random value and disables each drive's security system.
    * @const
    * @type {string}
    */
   reprovisionDrive: 'reprovisionDrive',

   /**
    * This procedure converts the specified volume group to a secure volume group.
    * @const
    * @type {string}
    */
   secureVolumeGroup: 'secureVolumeGroup',

   /**
    * This procedure creates a new lock key for the array, but does not commit the key to the drives. There must be at least one FDE capable drive present on the array.
    * @const
    * @type {string}
    */
   createLockKey: 'createLockKey',

   /**
    * Activates an inactive host port.
    * @const
    * @type {string}
    */
   activateHostPort: 'activateHostPort',

   /**
    * Activates inactive iSCSI initiator.
    * @const
    * @type {string}
    */
   activateInitiator: 'activateInitiator',

   /**
    * This procedure retrieves a list of product capabilities supported by the array.
    * @const
    * @type {string}
    */
   getProductCapabilities: 'getProductCapabilities',

   /**
    * Disables external KMS.
    * @const
    * @type {string}
    */
   disableExternalKMS: 'disableExternalKMS',

   /**
    * Enables external KMS.
    * @const
    * @type {string}
    */
   enableExternalKMS: 'enableExternalKMS',

   /**
    * Passes an existing lock key for the array and unlocks the disks.
    * @const
    * @type {string}
    */
   installLockKey: 'installLockKey',

   /**
    * Passes a new lock key for the array and commits the key to the disks.
    * @const
    * @type {string}
    */
   installNewLockKey: 'installNewLockKey',

   /**
    * Starts a cache memory diagnostic test on the controller
    * @const
    * @type {string}
    */
   startCacheMemoryDiagnostic: 'startCacheMemoryDiagnostic',

   /**
    * Retrieves the status of a running, interrupted, or completed cache memory diagnostic test.
    * @const
    * @type {string}
    */
   getCacheMemoryDiagnosticStatus: 'getCacheMemoryDiagnosticStatus',

   /**
    * Cancels a running cache memory diagnostic test and returns the test status.
    * @const
    * @type {string}
    */
   cancelCacheMemoryDiagnostic: 'cancelCacheMemoryDiagnostic',

   /**
    * Starts a cache backup device diagnostic test on the controller
    * @const
    * @type {string}
    */
   startCacheBackupDeviceDiagnostic: 'startCacheBackupDeviceDiagnostic',

   /**
    * Retrieves the status of a running, interrupted, or completed cache backup device diagnostic test.
    * @const
    * @type {string}
    */
   getCacheBackupDeviceDiagnosticStatus: 'getCacheBackupDeviceDiagnosticStatus',

   /**
    * Cancels a running cache backup device diagnostic test and returns the test status.
    * @const
    * @type {string}
    */
   cancelCacheBackupDeviceDiagnostic: 'cancelCacheBackupDeviceDiagnostic',

   /**
    * Starts a host card diagnostic test on the controller
    * @const
    * @type {string}
    */
   startHostCardDiagnostic: 'startHostCardDiagnostic',

   /**
    * Retrieves the status of a running, interrupted, or completed host card diagnostic test.
    * @const
    * @type {string}
    */
   getHostCardDiagnosticStatus: 'getHostCardDiagnosticStatus',

   /**
    * Cancels a running host card diagnostic test and returns the test status
    * @const
    * @type {string}
    */
   cancelHostCardDiagnostic: 'cancelHostCardDiagnostic',

   /**
    * Starts a base controller diagnostic test on the controller.
    * @const
    * @type {string}
    */
   startBaseControllerDiagnostic: 'startBaseControllerDiagnostic',

   /**
    * Retrieves the status of a running, interrupted, or completed base controller diagnostic test.
    * @const
    * @type {string}
    */
   getBaseControllerDiagnosticStatus: 'getBaseControllerDiagnosticStatus',

   /**
    * Cancels a running base controller diagnostic test and returns the test status.
    * @const
    * @type {string}
    */
   cancelBaseControllerDiagnostic: 'cancelBaseControllerDiagnostic',

   /**
    * Used to download some or all of a new firmware image file to a controller when the authentication password is unavailable.
    * @const
    * @type {string}
    */
   loadControllerFirmwareNoPassword: 'loadControllerFirmwareNoPassword',

   /**
    * Used to start an evaluation of a specified feature using the duration specified for the sub-model ID in the FBDT.
    * @const
    * @type {string}
    */
   enableFeatureEvaluation: 'enableFeatureEvaluation',

   /**
    * Used to re-key the array with a new lock key.
    * @const
    * @type {string}
    */
   externalKMSReKey: 'externalKMSReKey',

   /**
    * Used to validate the supplied key with one currently on the controller.
    * @const
    * @type {string}
    */
   validateLockKey: 'validateLockKey',

   /**
    * Places the set of volumes online.
    * @const
    * @type {string}
    */
   setVolumeListOnline: 'setVolumeListOnline',

   /**
    * This procedure starts a raw data retrieval operation.
    * @const
    * @type {string}
    */
   startRawDataRetrieve: 'startRawDataRetrieve',

   /**
    * This procedure is called for each chunk of raw data to be transferred to the host. The first call must be preceded by a call to startRawDataRetrieve().
    * @const
    * @type {string}
    */
   continueRawDataRetrieve: 'continueRawDataRetrieve',

   /**
    * This procedure cancels a raw data retrieve operation.
    * @const
    * @type {string}
    */
   cancelRawDataRetrieve: 'cancelRawDataRetrieve',

   /**
    * starts a raw data restore operation.
    * @const
    * @type {string}
    */
   startRawDataRestore: 'startRawDataRestore',

   /**
    * This procedure is called once to restore each chunk of data, after first calling a startRawDataRestore to notify the controller that it needs to prepare for the restore. On the first call to this procedure, a return code of RETCODE_RAWDATA_TRANSFER_PREPARING indicates that the controller has not completed the preparation, and the first call should be retried. Upon successful completion of the first call (RETCODE_OK), subsequent calls should be made to transfer additional chunks of data, incrementing the sequence number by one for each call.
    * @const
    * @type {string}
    */
   continueRawDataRestore: 'continueRawDataRestore',

   /**
    * This procedure cancels a raw data restore operation.
    * @const
    * @type {string}
    */
   cancelRawDataRestore: 'cancelRawDataRestore',

   /**
    * This procedure sets the selected remote target properties as indicated by the input arguments.
    * @const
    * @type {string}
    */
   setRemoteTargetProperties: 'setRemoteTargetProperties',

   /**
    * This procedure saves a new value of the specified MgmtClientRecords.
    * @const
    * @type {string}
    */
   writeClientMgmtRecordsNoPassword: 'writeClientMgmtRecordsNoPassword',

   /**
    * This procedure deletes a range of (i.e. one or more) specified MgmtClientRecords.
    * @const
    * @type {string}
    */
   deleteClientMgmtRecordsNoPassword: 'deleteClientMgmtRecordsNoPassword',

   /**
    * This procedure is used to download factory default information to a controller or expansion enclosure.
    * @const
    * @type {string}
    */
   loadFactoryDefaults: 'loadFactoryDefaults',

   /**
    * This procedure will retrieve state capture information from controller and expansion enclosures, including DCMs, if any. Send the command to both controllers if the tray is an RBOD.
    * @const
    * @type {string}
    */
   getEnclosureStateCaptureData: 'getEnclosureStateCaptureData',

   /**
    * Allows a client to fetch a set of entries that have the alertable, needs attention, or collect support bundle flag set from the array's MEL for analysis or display.
    * @const
    * @type {string}
    */
   getAlertableMelEntries: 'getAlertableMelEntries',

   /**
    * This procedure will report progress on each actively running long-lived operation.
    * @const
    * @type {string}
    */
   getLongLivedOpsProgress: 'getLongLivedOpsProgress',

   /**
    * This procedure is used to initiate a snapshot rollback (to base) on one or more snapshots.
    * @const
    * @type {string}
    */
   startSnapshotRollback: 'startSnapshotRollback',

   /**
    * This procedure is used to cancel a snapshot rollback operation.
    * @const
    * @type {string}
    */
   cancelSnapshotRollback: 'cancelSnapshotRollback',

   /**
    * This procedure is used to resume suspended snapshot rollback operations.
    * @const
    * @type {string}
    */
   resumeSnapshotRollback: 'resumeSnapshotRollback',

   /**
    * This procedure is used to create a list of schedules.
    * @const
    * @type {string}
    */
   createScheduleList: 'createScheduleList',

   /**
    * This procedure is used to modify a list of schedules.
    * @const
    * @type {string}
    */
   modifyScheduleList: 'modifyScheduleList',

   /**
    * This procedure will delete a list of schedules.
    * @const
    * @type {string}
    */
   deleteScheduleList: 'deleteScheduleList',

   /**
    * This procedure will perform diagnostic tests on all channels of a given iSCSI HIC. These diagnostics are dependent on the PHY used on a particular HIC, so they may not be available on all ports of the controller.
    * @const
    * @type {string}
    */
   getIscsiCopperCableDiagnostics: 'getIscsiCopperCableDiagnostics',

   /**
    * This procedure is used to update the firmware on one or more power supplies.
    * @const
    * @type {string}
    */
   updatePSUFirmware: 'updatePSUFirmware',

   /**
    * This procedure is used to check the progress of a power supply firmware update operation.
    * @const
    * @type {string}
    */
   getPSUFirmwareUpdateProgress: 'getPSUFirmwareUpdateProgress',

   /**
    * This procedure retrieves temperature data for each thermal sensor in each enclosure in the storage array.
    * @const
    * @type {string}
    */
   getEnclosureTemperatures: 'getEnclosureTemperatures',

   /**
    * This procedure retrieves temperature data for drives in the storage array.
    * @const
    * @type {string}
    */
   getDriveTemperatures: 'getDriveTemperatures',

   /**
    * This procedure set the interval in minutes between automatic polls of drive temperatures. For interval > 0, automatic polling is enabled at the specified interval. For interval == 0, automatic polling is disabled. Each polling event will update the driveTemperature field in each Drive structure in the ObjectBundle.
    * @const
    * @type {string}
    */
   setDriveTemperaturePollingInterval: 'setDriveTemperaturePollingInterval',

   /**
    * This procedure attempts to acquire the Customer Support Bundle lock. If the lock is successfully acquired the procedure returns success and the lock key. If another client owns the lock a failure indication is returned along with an integer indicating the suggested number of seconds to wait before retrying the reservation.
    * @const
    * @type {string}
    */
   reserveSupportData: 'reserveSupportData',

   /**
    * This procedure attempts to release a previously acquired Customer Support Bundle (CSB) lock once the CSB retrieval is complete. If the provided lock key matches the current value of the lock, the lock is released and the procedure returns success. If the lock key does not match the current value of the lock or if the lock is not active, the procedure returns an error.
    * @const
    * @type {string}
    */
   releaseSupportData: 'releaseSupportData',

   /**
    * This procedure is used to create an empty disk pool.
    * @const
    * @type {string}
    */
   createDiskPool: 'createDiskPool',

   /**
    * This procedure is used to delete a disk pool and all volumes in that pool.
    * @const
    * @type {string}
    */
   deleteDiskPool: 'deleteDiskPool',

   /**
    * This procedure is used to instruct the controller to transfer ownership of a disk pool and its associated volumes to another controller.
    * @const
    * @type {string}
    */
   assignDiskPoolOwnership: 'assignDiskPoolOwnership',

   /**
    * This procedure is used to set the user assigned label for the disk pool.
    * @const
    * @type {string}
    */
   setDiskPoolUserLabel: 'setDiskPoolUserLabel',

   /**
    * This procedure creates a Volume Group and two RAID Volumes to be used for flash cache. Uses the VolumeCandidate for the RAID Volume creation and assigns labels as given. The capacity in the VolumeCandidate is split between the two RAID Volumes. A High Level Volume is also created to reference the RAID Volumes.
    * @const
    * @type {string}
    */
   createFlashCache: 'createFlashCache',

   /**
    * This procedure deletes the High Level Volume, the RAID Volumes on the SSD, and disables flash caching on any associated user volumes.
    * @const
    * @type {string}
    */
   deleteFlashCache: 'deleteFlashCache',

   /**
    * This procedure creates a flash cache proxy linked to the referenced user RAID Volume and the flash cache High Level Volume. The flash cache attribute on the RAID Volume will be turned on.
    * @const
    * @type {string}
    */
   enableFlashCacheVolume: 'enableFlashCacheVolume',

   /**
    * This procedure deletes the proxy and turns off flash cache volume attributes on the referenced user volume.
    * @const
    * @type {string}
    */
   disableFlashCacheVolume: 'disableFlashCacheVolume',

   /**
    * This procedure suspends caching on the specified flash cache.
    * @const
    * @type {string}
    */
   suspendFlashCache: 'suspendFlashCache',

   /**
    * This procedure reconfigures the flash cache volume group to add additional drives.
    * @const
    * @type {string}
    */
   addDrivesToFlashCache: 'addDrivesToFlashCache',

   /**
    * This procedure reconfigures the flash cache volume group to remove drives.
    * @const
    * @type {string}
    */
   removeDrivesFromFlashCache: 'removeDrivesFromFlashCache',

   /**
    * This procedure sets the parameters on a given flash cache.
    * @const
    * @type {string}
    */
   setFlashCacheParams: 'setFlashCacheParams',

   /**
    * This procedure resumes a previously suspended flash cache.
    * @const
    * @type {string}
    */
   resumeFlashCache: 'resumeFlashCache',

   /**
    * This procedure will create a new PiT Group.
    * @const
    * @type {string}
    */
   createPITGroup: 'createPITGroup',

   /**
    * This procedure will delete a PiT Group.
    * @const
    * @type {string}
    */
   deletePITGroup: 'deletePITGroup',

   /**
    * This procedure will update the changeable parameters of a PiT Group.
    * @const
    * @type {string}
    */
   setPITGroupParams: 'setPITGroupParams',

   /**
    * This procedure will create a new PiT in one or more existing PiT Group(s). Max list size is 64 PiT Groups.
    * @const
    * @type {string}
    */
   createPIT: 'createPIT',

   /**
    * This procedure will delete one or more PiTs.
    * @const
    * @type {string}
    */
   deletePIT: 'deletePIT',

   /**
    * This procedure will create a new PiT in a consistency group (a PiT of all members in the group).
    * @const
    * @type {string}
    */
   createCGPIT: 'createCGPIT',

   /**
    * This procedure will delete a PiT in one or more members of a consistency group.
    * @const
    * @type {string}
    */
   deleteCGPIT: 'deleteCGPIT',

   /**
    * This procedure will create a new PiT View.
    * @const
    * @type {string}
    */
   createPITView: 'createPITView',

   /**
    * This procedure will delete an existing PiT View.
    * @const
    * @type {string}
    */
   deletePITView: 'deletePITView',

   /**
    * This procedure will stop an existing PiT View.
    * @const
    * @type {string}
    */
   stopPITView: 'stopPITView',

   /**
    * This procedure will change the attributes of an existing PiT View.
    * @const
    * @type {string}
    */
   setPITViewParams: 'setPITViewParams',

   /**
    * This procedure will create a new PiT consistency group.
    * @const
    * @type {string}
    */
   createPITConsistencyGroup: 'createPITConsistencyGroup',

   /**
    * This procedure will delete an existing PiT consistency group, all of the child PiT groups and their PiTs and associated ERVs. All associated views are stopped.
    * @const
    * @type {string}
    */
   deletePITConsistencyGroup: 'deletePITConsistencyGroup',

   /**
    * This procedure will add a new member to a PiT consistency group (create a new PiT group for the member volume to add and add that PiT group to the consistency group). Returns the ref of the new PiT group created and added to the PCG.
    * @const
    * @type {string}
    */
   addPITConsistencyGroupMember: 'addPITConsistencyGroupMember',

   /**
    * This procedure will remove a member from a PiT consistency group.
    * @const
    * @type {string}
    */
   removePITConsistencyGroupMember: 'removePITConsistencyGroupMember',

   /**
    * This procedure will modify the attributes of a PiT consistency group.
    * @const
    * @type {string}
    */
   setPITConsistencyGroupParams: 'setPITConsistencyGroupParams',

   /**
    * This procedure will initiate a rollback on a specified list of PiTs. Note that this list could be a subset of a set of consistency group PiTs.
    * @const
    * @type {string}
    */
   startPITRollback: 'startPITRollback',

   /**
    * This procedure will initiate a rollback on a specified PiT on all members of a consistency group (all members that have the specified PiT may not necessarily be all of them).
    * @const
    * @type {string}
    */
   startCGRollback: 'startCGRollback',

   /**
    * This procedure will resume a paused rollback on the specified PiT.
    * @const
    * @type {string}
    */
   resumePITRollback: 'resumePITRollback',

   /**
    * This procedure will cancel a rollback on the specified PiT.
    * @const
    * @type {string}
    */
   cancelPITRollback: 'cancelPITRollback',

   /**
    * This procedure will expand a concatenated volume by adding another member RAID volume. Returns the ref for the new ConcatVolMember added.
    * @const
    * @type {string}
    */
   expandConcatVolume: 'expandConcatVolume',

   /**
    * This procedure will trim a concatenated volume by removing one or more member RAID volumes. Note this can only be done in cases where the ConcatVolume is not being used (definition of "used" depends on parent object usage).
    * @const
    * @type {string}
    */
   trimConcatVolume: 'trimConcatVolume',

   /**
    * This procedure will return repository utilization information for PiT groups.
    * @const
    * @type {string}
    */
   getPITGroupRepositoryUtilization: 'getPITGroupRepositoryUtilization',

   /**
    * This procedure will return repository utilization information for PiT Views.
    * @const
    * @type {string}
    */
   getPITViewRepositoryUtilization: 'getPITViewRepositoryUtilization',

   /**
    * This procedure will return the amount of repository capacity necessary to perform a rollback operation.
    * @const
    * @type {string}
    */
   estimatePITRollbackRepositoryUtilization: 'estimatePITRollbackRepositoryUtilization',

   /**
    * This procedure will convert a read-only view to a read-write view.
    * @const
    * @type {string}
    */
   convertReadOnlyPITViewToReadWrite: 'convertReadOnlyPITViewToReadWrite',

   /**
    * This procedure will create a View on the specified PiTs in a Consistency Group.
    * @const
    * @type {string}
    */
   createPITConsistencyGroupView: 'createPITConsistencyGroupView',

   /**
    * This procedure will delete the specified PITConsistencyGroupView.
    * @const
    * @type {string}
    */
   deletePITConsistencyGroupView: 'deletePITConsistencyGroupView',

   /**
    * This procedure will stop the specified PITConsistencyGroupView (and thus all of its associated member views).
    * @const
    * @type {string}
    */
   stopPITConsistencyGroupView: 'stopPITConsistencyGroupView',

   /**
    * This procedure will set the Disk Pool Reserved Drive Count value.
    * @const
    * @type {string}
    */
   setDiskPoolReservedDriveCount: 'setDiskPoolReservedDriveCount',

   /**
    * This procedure will set the Disk Pool Utilization Threshold values.
    * @const
    * @type {string}
    */
   setDiskPoolThreshold: 'setDiskPoolThreshold',

   /**
    * This procedure will set the Disk Pool Reconstruction and Background Operation priorities.
    * @const
    * @type {string}
    */
   setDiskPoolPriority: 'setDiskPoolPriority',

   /**
    * This procedure forces the Disk Pool to a complete (optimal) state. This may be necessary if a drive is missing and the drive is not going to be replaced.
    * @const
    * @type {string}
    */
   setDiskPoolToComplete: 'setDiskPoolToComplete',

   /**
    * This procedure returns a list of drive sets that are candidates for use in expanding the given Disk Pool.
    * @const
    * @type {string}
    */
   getDiskPoolExpansionCandidates: 'getDiskPoolExpansionCandidates',

   /**
    * This procedure initiates a long-running operation to expand the capacity of a Disk Pool by adding one or more drives to it.
    * @const
    * @type {string}
    */
   startDiskPoolExpansion: 'startDiskPoolExpansion',

   /**
    * This procedure is used to manually trigger a DPL Core Dump.
    * @const
    * @type {string}
    */
   triggerDPLCoreDumpOnDemand: 'triggerDPLCoreDumpOnDemand',

   /**
    * This procedure is used to request the information about a DPL core dump. The parameter is a DPL Core Dump Tag. The value of the tag is unique for each core dump and may be obtained from the DPLCoreDumpData structure in StorageArray.
    * @const
    * @type {string}
    */
   getDPLCoreDumpInformation: 'getDPLCoreDumpInformation',

   /**
    * This procedure is used to clear the flag indicating that a DPL core dump needs to be retrieved without offloading it. Otherwise, the available DPL core dump will remain in controller memory until overwritten by a new DPL core dump.
    * @const
    * @type {string}
    */
   clearDPLCoreDumpNeedsRetrieved: 'clearDPLCoreDumpNeedsRetrieved',

   /**
    * This procedure will restart a PiT View.
    * @const
    * @type {string}
    */
   restartPITView: 'restartPITView',

   /**
    * This procedure will restart a Consistency Group View (restart all of its associated member Views).
    * @const
    * @type {string}
    */
   restartPITConsistencyGroupView: 'restartPITConsistencyGroupView',

   /**
    * This procedure disables a feature.
    * @const
    * @type {string}
    */
   disableFeatureByRef: 'disableFeatureByRef',

   /**
    * This procedure will add a member to an Async Mirror Group on the primary array. This is step 1 of the add member process.
    * @const
    * @type {string}
    */
   addAsyncMirrorGroupPrimaryMember: 'addAsyncMirrorGroupPrimaryMember',

   /**
    * This procedure will add a member to an Async Mirror Group on the secondary array. This is step 2 of the add member process.
    * @const
    * @type {string}
    */
   addAsyncMirrorGroupSecondaryMember: 'addAsyncMirrorGroupSecondaryMember',

   /**
    * This procedure will change roles on an Async Mirror Group.
    * @const
    * @type {string}
    */
   changeAsyncMirrorGroupRole: 'changeAsyncMirrorGroupRole',

   /**
    * This procedure will clear a recovery failure posted for a given Async Mirror Group (AMG). Since some AMG needs attention / recovery failure conditions are "sticky" the user has to acknowledge the condition before it is cleared.
    * @const
    * @type {string}
    */
   clearAsyncMirrorGroupFaultIndication: 'clearAsyncMirrorGroupFaultIndication',

   /**
    * This procedure will clear a recovery failure posted for a given Async Mirror Group member. Since some mirror member needs attention / recovery failure conditions are "sticky" the user has to acknowledge the condition before it is cleared.
    * @const
    * @type {string}
    */
   clearAsyncMirrorGroupMemberFaultIndication: 'clearAsyncMirrorGroupMemberFaultIndication',

   /**
    * This procedure will create an Async Mirror Group (AMG).
    * @const
    * @type {string}
    */
   createAsyncMirrorGroup: 'createAsyncMirrorGroup',

   /**
    * This procedure will delete an Async Mirror Group (AMG).
    * @const
    * @type {string}
    */
   deleteAsyncMirrorGroup: 'deleteAsyncMirrorGroup',

   /**
    * This procedure is used to clean up a mirror "place holder."
    * @const
    * @type {string}
    */
   deleteAsyncMirrorGroupIncompleteMember: 'deleteAsyncMirrorGroupIncompleteMember',

   /**
    * This procedure will disable mirroring over Fibre Channel (freeing up dedicated channel).
    * @const
    * @type {string}
    */
   deactivateFibreChannelCheckPointBasedAsyncMirroring: 'deactivateFibreChannelCheckPointBasedAsyncMirroring',

   /**
    * This procedure will enable mirroring over Fibre Channel (setup dedicated channel).
    * @const
    * @type {string}
    */
   activateFibreChannelCheckPointBasedAsyncMirroring: 'activateFibreChannelCheckPointBasedAsyncMirroring',

   /**
    * This procedure will return sync progress information for Async Mirror Groups and their associated members. Calls to this procedure are valid even when a sync is not running.
    * @const
    * @type {string}
    */
   getAsyncMirrorGroupSyncProgress: 'getAsyncMirrorGroupSyncProgress',

   /**
    * This procedure will return repository utilization information for async mirror members.
    * @const
    * @type {string}
    */
   getAsyncMirrorRepositoryUtilization: 'getAsyncMirrorRepositoryUtilization',

   /**
    * This procedure will remove a member from an Async Mirror Group.
    * @const
    * @type {string}
    */
   removeAsyncMirrorGroupMember: 'removeAsyncMirrorGroupMember',

   /**
    * Resume an Async Mirror Group.
    * @const
    * @type {string}
    */
   resumeAsyncMirrorGroup: 'resumeAsyncMirrorGroup',

   /**
    * This procedure will change the parameters of an Async Mirror Group.
    * @const
    * @type {string}
    */
   setAsyncMirrorGroupParams: 'setAsyncMirrorGroupParams',

   /**
    * This procedure will suspend an Async Mirror Group.
    * @const
    * @type {string}
    */
   suspendAsyncMirrorGroup: 'suspendAsyncMirrorGroup',

   /**
    * This procedure will start a manual resynchronization on an Async Mirror Group.
    * @const
    * @type {string}
    */
   synchronizeAsyncMirrorGroup: 'synchronizeAsyncMirrorGroup',

   /**
    * This procedure will return the maximum Reserved Drive Count possible on a disk pool.
    * @const
    * @type {string}
    */
   getDiskPoolMaxReservedDriveCount: 'getDiskPoolMaxReservedDriveCount',

   /**
    * This procedure cancels a Pending PiT Creation for a PiT Consistency Group.
    * @const
    * @type {string}
    */
   cancelPendingCGPITCreation: 'cancelPendingCGPITCreation',

   /**
    * This procedure cancels a Pending PiT Creation for a PiT Group. This returns the pending PiT creation state back to "none" from either "waiting" or "failed".
    * @const
    * @type {string}
    */
   cancelPendingPITCreation: 'cancelPendingPITCreation',

   /**
    * This procedure revives a failed PiT Group.
    * @const
    * @type {string}
    */
   revivePITGroup: 'revivePITGroup',

   /**
    * This procedure revives a failed PiT View.
    * @const
    * @type {string}
    */
   revivePITView: 'revivePITView',

   /**
    * This procedure changes the user-settable parameters on a PITConsistencyGroupView.
    * @const
    * @type {string}
    */
   setPITConsistencyGroupViewParams: 'setPITConsistencyGroupViewParams',

   /**
    * This procedure creates a new Thin Provisioned Volume.
    * @const
    * @type {string}
    */
   createThinVolume: 'createThinVolume',

   /**
    * This procedure will expand a thin volume's virtual capacity. It does not affect the repository volume's capacity.
    * @const
    * @type {string}
    */
   expandThinVolumeVirtualCapacity: 'expandThinVolumeVirtualCapacity',

   /**
    * This procedure will retrieve a thin volume's Expandable Repository Volume consumed capacity.
    * @const
    * @type {string}
    */
   getThinVolumeConsumedCapacity: 'getThinVolumeConsumedCapacity',

   /**
    * This procedure will retrieve a thin volume's repository expansion history.
    * @const
    * @type {string}
    */
   getThinVolumeExpansionHistory: 'getThinVolumeExpansionHistory',

   /**
    * This procedure causes the referenced thin volume to be reinitialized to have no content.
    * @const
    * @type {string}
    */
   reinitializeThinVolume: 'reinitializeThinVolume',

   /**
    * This procedure will set a thin volume's capacity threshold warning level.
    * @const
    * @type {string}
    */
   setThinVolumeCapacityThreshold: 'setThinVolumeCapacityThreshold',

   /**
    * This procedure will set a thin volume's repository volume expansion policy.
    * @const
    * @type {string}
    */
   setThinVolumeExpansionPolicy: 'setThinVolumeExpansionPolicy',

   /**
    * This procedure will set a thin volume's provisioned capacity quota. This is the maximum value to which a thin volume's repository can grow.
    * @const
    * @type {string}
    */
   setThinVolumeProvisionedCapacityQuota: 'setThinVolumeProvisionedCapacityQuota',

   /**
    * This procedure returns the default values for system attributes.
    * @const
    * @type {string}
    */
   getSystemAttributeDefaults: 'getSystemAttributeDefaults',

   /**
    * This procedure is used to request a list of bundles of statistical data. The argument describes the statistics being requested.
    * @const
    * @type {string}
    */
   getCumulativeStatisticsBundles: 'getCumulativeStatisticsBundles',

   /**
    * This procedure creates a zero size FlashCache for performing analytics. It creates a flashcache with no repository to allow collection of projected cache hits during I/O.
    * @const
    * @type {string}
    */
   createFlashCacheAnalytics: 'createFlashCacheAnalytics',

   /**
    * This procedure starts collecting analytics data for flash cache. It resets analytics counters and begins capturing cache data.
    * @const
    * @type {string}
    */
   startFlashCacheAnalytics: 'startFlashCacheAnalytics',

   /**
    * This procedure stops the collection of analytics data for flash cache. It disables the collection of cache hits.
    * @const
    * @type {string}
    */
   stopFlashCacheAnalytics: 'stopFlashCacheAnalytics',

   /**
    * This procedure retrieves analytics data from the last capture period. It returns the cache hits for various sizes of flash cache.
    * @const
    * @type {string}
    */
   getFlashCacheAnalytics: 'getFlashCacheAnalytics',

   /**
    * This procedure will convert all snapshots of a given base volume to PiT groups.
    * @const
    * @type {string}
    */
   convertSnapshotsToPITGroups: 'convertSnapshotsToPITGroups',

   /**
    * This procedure will run an analysis on the metadata contained in a copy-on-write repository to identify possible causes for failure.
    * @const
    * @type {string}
    */
   analyzeCopyOnWriteRepository: 'analyzeCopyOnWriteRepository',

   /**
    * This procedure is used to retrieve stable store database metadata.
    * @const
    * @type {string}
    */
   getDatabaseMetadata: 'getDatabaseMetadata',

   /**
    * This procedure is used to cancel stable store database recovery.
    * @const
    * @type {string}
    */
   cancelDatabaseRecoveryMode: 'cancelDatabaseRecoveryMode',

   /**
    * This procedure is used to cancel an Async Mirror Group role change operation.
    * @const
    * @type {string}
    */
   cancelAsyncMirrorGroupRoleChange: 'cancelAsyncMirrorGroupRoleChange',

   /**
    * This procedure is used to initiate an Async Mirror Group link connectivity test.
    * @const
    * @type {string}
    */
   testAsyncMirrorGroupConnectivity: 'testAsyncMirrorGroupConnectivity',

   /**
    * This procedure is used to retrieve flash cache statistics.
    * @const
    * @type {string}
    */
   getFlashCacheStatistics: 'getFlashCacheStatistics',

   /**
    * This procedure is used to download a NVSRAM image file to a controller when the duplex setting gets erroneously inserted into a Native SATA array. In such a situation, none of the native SATA drives will be recognized by the firmware since the IOC will be set to enable the STP (SATA) layer only if the setting is Simplex. The Recovery Action in such a scenario is to download new NVSRAM using this command and boot with it.
    * @const
    * @type {string}
    */
   loadControllerNVSRAMNoPassword: 'loadControllerNVSRAMNoPassword',

   /**
    * This procedure is used to recover a stopped or failed Async Mirror Group Member.
    * @const
    * @type {string}
    */
   recoverAsyncMirrorGroupMember: 'recoverAsyncMirrorGroupMember',

   /**
    * This procedure attempts to revive the given disk pool.
    * @const
    * @type {string}
    */
   forceDiskPoolToOptimal: 'forceDiskPoolToOptimal',

   /**
    * This procedure converts the specified disk pool to a secure volume group.
    * @const
    * @type {string}
    */
   secureDiskPool: 'secureDiskPool',

   /**
    * This procedure is used to enable Autosupport.
    * @const
    * @type {string}
    */
   enableASUP: 'enableASUP',

   /**
    * This procedure is used to disable Autosupport.
    * @const
    * @type {string}
    */
   disableASUP: 'disableASUP',

   /**
    * This procedure returns information on the connections established to a remote array for an existing AsyncMirrorGroup. This will return connection information for both controllers.
    * @const
    * @type {string}
    */
   getAsyncMirrorGroupRemoteConnections: 'getAsyncMirrorGroupRemoteConnections',

   /**
    * This procedure will return synchronization time statistics for a list of mirror members.
    * @const
    * @type {string}
    */
   getAsyncMirrorSyncStatistics: 'getAsyncMirrorSyncStatistics',

   /**
    * This procedure returns information on the available connections between two arrays. This can be used prior to creation of an AsyncMirrorGroup to determine if there are wiring or other connection configuration issues between the two arrays. A call to this procedure acts like a ping test between the arrays and returns back information on the connections that succeed. This must be issued to each controller independently and should be called in fibre channel environments after activation of fibre channel remote mirroring.
    * @const
    * @type {string}
    */
   getRemoteConnections: 'getRemoteConnections',

   /**
    * This procedure will reset (clear) synchronization time statistics for a list of mirror members.
    * @const
    * @type {string}
    */
   resetAsyncMirrorSyncStatistics: 'resetAsyncMirrorSyncStatistics',

   /**
    * This procedure is used to set the initial view array password or change an existing view array password.
    * @const
    * @type {string}
    */
   setSAViewPassword: 'setSAViewPassword',

   /**
    * This procedure is used to retrieve the digest of the view array password and its associated salt value which are saved in the array by the setViewPassword procedure. If the view array password isn't set, the procedure returns a random salt value and the digest of the salt value message.
    * @const
    * @type {string}
    */
   getSAViewPasswordDigest: 'getSAViewPasswordDigest',

   /**
    * This procedure is used to add a known SNMP community string. SNMP GET/SET requests are only allowed for known communities.
    * @const
    * @type {string}
    */
   addSNMPCommunity: 'addSNMPCommunity',

   /**
    * This procedure is used to add an SNMP trap destination.
    * @const
    * @type {string}
    */
   addSNMPTrapDestination: 'addSNMPTrapDestination',

   /**
    * This procedure is used to remove a previous configured SNMP community from the list of known community strings.
    * @const
    * @type {string}
    */
   removeSNMPCommunity: 'removeSNMPCommunity',

   /**
    * This procedure is used to remove a previously configured SNMP trap destination.
    * @const
    * @type {string}
    */
   removeSNMPTrapDestination: 'removeSNMPTrapDestination',

   /**
    * This procedure is used to modify an existing SNMP community.
    * @const
    * @type {string}
    */
   setSNMPCommunityParams: 'setSNMPCommunityParams',

   /**
    * This procedure is used to set values of user-settable SNMP system variables.
    * @const
    * @type {string}
    */
   setSNMPSystemVariables: 'setSNMPSystemVariables',

   /**
    * This procedure is used to modify an existing SNMP trap destination.
    * @const
    * @type {string}
    */
   setSNMPTrapDestinationParams: 'setSNMPTrapDestinationParams',

   /**
    * This procedure initiates a long-running operation to reduce the capacity of a Disk Pool by removing one or more drives from it.
    * @const
    * @type {string}
    */
   startDiskPoolReduction: 'startDiskPoolReduction',

   /**
    * This procedure calculates the maximum number of drives that can be removed from a disk pool.
    * @const
    * @type {string}
    */
   getDiskPoolReductionDriveCount: 'getDiskPoolReductionDriveCount',

   /**
    * This procedure is used to test SNMP trap destinations (generate test trap).
    * @const
    * @type {string}
    */
   testSNMPTrapDestination: 'testSNMPTrapDestination',

   /**
    * This procedure is used to recover a stopped or failed asynchronous mirror group member.
    * @const
    * @type {string}
    */
   recoverAsyncMirrorGroupMemberDeleteRecoveryPoint: 'recoverAsyncMirrorGroupMemberDeleteRecoveryPoint',

   /**
    * This procedure is used to get the current Autosupport status values.
    * @const
    * @type {string}
    */
   getAsupStatus: 'getAsupStatus',

   /**
    * This procedure is used to set the current Autosupport status values.
    * @const
    * @type {string}
    */
   setAsupStatus: 'setAsupStatus',

   /**
    * This procedure is used to manually trigger an IOC Dump on the specified channel.
    * @const
    * @type {string}
    */
   triggerIOCDumpOnDemand: 'triggerIOCDumpOnDemand',

   /**
    * This procedure is used to request information about an IOC Dump. The parameter is an IOC Dump Tag. The value of the tag is unique for each dump and may be obtained from the IOCDumpData structure in StorageArray.
    * @const
    * @type {string}
    */
   getIOCDumpInformation: 'getIOCDumpInformation',

   /**
    * This procedure is used to tell the controller that corrective action has been taken to recover from a mis-wire condition. The controller will re-enable any SAS Ports that were disabled when a mis-wire was detected.
    * @const
    * @type {string}
    */
   recoverFromMiswire: 'recoverFromMiswire',

   /**
    * This procedure is used to request Energy Star data from all power supplies.
    * @const
    * @type {string}
    */
   getEnergyStarData: 'getEnergyStarData',

   /**
    * This procedure is used to get the state of a function, enable or disable the function, or revert the function back to its default value.
    * @const
    * @type {string}
    */
   setFunctionState: 'setFunctionState',

   /**
    * This procedure is used to power cycle an individual physical drive.
    * @const
    * @type {string}
    */
   powerCyclePhysicalDrive: 'powerCyclePhysicalDrive',

   /**
    * This command cancels an evacuation on the referenced drive.
    * @const
    * @type {string}
    */
   cancelEvacuation: 'cancelEvacuation',

   /**
    * This procedure triggers the copy of an assigned volume group drive to a standby hot spare. Upon successful completion of the copy, the assigned drive is failed and the hot spare becomes an active drive in the volume group, sparing for the failed drive.
    * @const
    * @type {string}
    */
   copyDriveThenFail: 'copyDriveThenFail',

   /**
    * This command will trigger an evacuation from an assigned volume group drive to an unassigned drive and replace the original drive in the volume group with the new one.
    * @const
    * @type {string}
    */
   copyDriveThenReplace: 'copyDriveThenReplace',

   /**
    * This procedure returns the InfiniBand statistics, which consists of start-of-day-relative interface statistics and baseline-relative statistics. It supersedes the deprecated getIbStatistics () routine.
    * @const
    * @type {string}
    */
   getEnhancedIbStatistics: 'getEnhancedIbStatistics',

   /**
    * This procedure returns the success of starting statistic data collection.
    * @const
    * @type {string}
    */
   startPerformanceMonitor: 'startPerformanceMonitor',

   /**
    * This procedure returns the success of stopping statistic data collection.
    * @const
    * @type {string}
    */
   stopPerformanceMonitor: 'stopPerformanceMonitor',

   /**
    * This procedure enables or disables high resolution statistics gathering.
    * @const
    * @type {string}
    */
   setHighResolutionSampling: 'setHighResolutionSampling',

   /**
    * This procedure enables or disables the auto load balancing capability on this array.
    * @const
    * @type {string}
    */
   setAutoLoadBalancing: 'setAutoLoadBalancing',

   /**
    * This procedure will perform an immediate fail-back of volume current ownership to the preferred owner.
    * @const
    * @type {string}
    */
   failBackVolumeOwnership: 'failBackVolumeOwnership',

   /**
    * This procedure requests an on-demand volume ownership redistribution for load balancing purposes.
    * @const
    * @type {string}
    */
   autoLoadBalanceRequest: 'autoLoadBalanceRequest',

   /**
    * This procedure is used to set the Physical Security ID for a drive. The PSID is required in order to set a FIPS drive back to factory settings if the previous PSID is lost. In that case, the drive must be set back to factory settings in order to be used.
    * @const
    * @type {string}
    */
   setDrivePhysicalSecurityID: 'setDrivePhysicalSecurityID',

   /**
    * This procedure changes the reporting policy of a thin volume. The reporting policy controls how a thin volume is reported to the host on the SCSI interface, i.e., as a thin volume that supports unmap commands or as a thick volume.
    * @const
    * @type {string}
    */
   setThinVolumeReportingPolicy: 'setThinVolumeReportingPolicy',

   /**
    * This procedure allows the user to limit the performance of a host cluster. The limitations that can be set are throughput (MB/s) and IOPs.
    * @const
    * @type {string}
    */
   setClusterPerformanceLimitationValues: 'setClusterPerformanceLimitationValues',

   /**
    * This procedures returns the performance limitation values for a host cluster. Those values include the limits on the IOPs and throughput (MB/s). The number of IOPs impacted by the performance limits is also returned.
    * @const
    * @type {string}
    */
   getClusterPerformanceLimitationValues: 'getClusterPerformanceLimitationValues',

   /**
    * This procedure is utilized to add new key-value tags to the persistent memory so they can be used for application awareness.
    * @const
    * @type {string}
    */
   createKeyValueTag: 'createKeyValueTag',

   /**
    * This procedure removes from the array the specified key-value tags. It is an error to remove in-use key-value tags.
    * @const
    * @type {string}
    */
   deleteKeyValueTag: 'deleteKeyValueTag',

   /**
    * This procedure persists the association between the Key-Value tags and the Volumes (or Workloads). This procedure is used both for creating the initial mappings and to update. Each execution will remove any existing mappings and replace them with the mappings defined within the argument list.
    * @const
    * @type {string}
    */
   setKeyValueTagMapping: 'setKeyValueTagMapping',

   /**
    * This procedure removes from the specified volumes all references to specific Key-Value tags.
    * @const
    * @type {string}
    */
   deleteKeyValueTagMapping: 'deleteKeyValueTagMapping',

   /**
    * This procedure is utilized to add new application awareness workloads to persistent memory. The workload objects are created but do not as yet have Key-Value Tags associated to them. That requires calling the setKeyValueTagMapping procedure.
    * @const
    * @type {string}
    */
   createWorkload: 'createWorkload',

   /**
    * This procedure removes the specified application awareness workloads. It is not an error to remove in-use (association mapped) workloads. All association mappings for the workload are removed including any KeyValueTag mappings. The actual KeyValueTag records are not deleted.
    * @const
    * @type {string}
    */
   deleteWorkload: 'deleteWorkload',

   /**
    * This procedure creates the mappings between the list of workloads and volumes specified by the input descriptor.
    * @const
    * @type {string}
    */
   createWorkloadVolumeMapping: 'createWorkloadVolumeMapping',

   /**
    * This procedure deletes the specified workload to volume mappings.
    * @const
    * @type {string}
    */
   deleteWorkloadVolumeMapping: 'deleteWorkloadVolumeMapping',

   /**
    * Generates a Key Management Server (KMS) Client Certificate Signing Request (CSR) that needs to be signed by a Certificate Authority (CA). The resulting signed certificate or client certificate is installed on the storage array for authenticating with the KMIP server.
    * @const
    * @type {string}
    */
   generateCertificateSigningRequest: 'generateCertificateSigningRequest',

   /**
    * Installs a Key Management Server (KMS) Certificate File on the storage array. In addition to the contents of the certificate file, the type of certificate must be specified. If a certificate of the type specified already exists on the storage array, it will be overwritten by the new certificate.
    * @const
    * @type {string}
    */
   installKMSCertificateFile: 'installKMSCertificateFile',

   /**
    * Retrieves a specified Key Management Server (KMS) ertificate currently installed on the storage array so that information about the certifiacte such as date of expiration can be extracted and displayed. This allows the storage administrator to know what is installed on the system and used for authentication with the KMIP server.
    * @const
    * @type {string}
    */
   retrieveKMSCertificateFile: 'retrieveKMSCertificateFile',

   /**
    * This procedure will remove a specified installed KMS certificate from the storage array.
    * @const
    * @type {string}
    */
   removeInstalledKMSCertificateFiles: 'removeInstalledKMSCertificateFiles',

   /**
    * This procedure sets selected HostPorts attributes, as specified by the input argument. It is meant to operate on a group of ports, for example all the ports on a host interface card or base board.
    * @const
    * @type {string}
    */
   setHostPortsAttributes: 'setHostPortsAttributes',

   /**
    * Sets parameters necessary to communicate with an external key management server. This procedure has been deprecated and replaced by setExternalKMSParametersList.
    * @const
    * @type {string}
    */
   setExternalKMSParameters: 'setExternalKMSParameters',

   /**
    * Uses the credentials (certificates, address of the KMIP server, and the KMIP port number) provided to verify that the storage array is able to communicate with the external KMIP server.
    * @const
    * @type {string}
    */
   verifyExternalKMSCommunication: 'verifyExternalKMSCommunication',

   /**
    * Deprecated. A procedure that provides a means to tunnel HTTP calls through the UTM Lun. The HTTP call is executed against the embedded web server.
    * @const
    * @type {string}
    */
   tunnelHttpCall: 'tunnelHttpCall',

   /**
    * This procedure sets the properties of a NVMe over Fabrics Host Interface port.
    * @const
    * @type {string}
    */
   setNVMeHostInterfaceProperties: 'setNVMeHostInterfaceProperties',

   /**
    * Intended to allow processes external to EOS to send messages and events into EOS. This is primarily to allow non-EOS processes (like the WebServices Proxy) to generate MEL and Needs Attention conditions, but is extensible to allow other types of messages as well
    * @const
    * @type {string}
    */
   handleInternalMessage: 'handleInternalMessage',

   /**
    * This procedure returns the NVMeoF statistics, which consist of start-of-day-relative interface/queue statistics and baseline-relative interface/queue statistics.
    * @const
    * @type {string}
    */
   getNVMeoFStatistics: 'getNVMeoFStatistics',

   /**
    * This procedure, from the client's perspective, resets the NVMe over Fabrics baselined statistical counters to zero. It is a logical reset in the sense that the raw counts maintained in hardware and firmware are not actually reset; instead the firmware makes a snapshot of the current counter values and uses that to report deltas in counts when the statistics are fetched. The new baseline time is applied to both storage controllers, so that their counts are in sync with one another. If one storage controller resets without the other resetting, the counters become effectively out of sync and the client is made aware of this fact by the timestamp data reported along with the statistics.
    * @const
    * @type {string}
    */
   setNVMeoFStatisticsBaseline: 'setNVMeoFStatisticsBaseline',

   /**
    * This procedure allows checking of protection information of cache mirroring to be enabled or disabled, if this feature is supported. There is a capability enumeration that indicates whether or not this feature is supported.
    * @const
    * @type {string}
    */
   setCacheMirroringProtectionInformation: 'setCacheMirroringProtectionInformation',

   /**
    * This procedure collects the wear life statistic information for the requested devices and returns this up to date information.
    * @const
    * @type {string}
    */
   getCurrentSSDWearLifeStats: 'getCurrentSSDWearLifeStats',

   /**
    * This procedure resets the super provisioning boundary for the requested devices.
    * @const
    * @type {string}
    */
   resetSuperProvisioningBoundary: 'resetSuperProvisioningBoundary',

   /**
    * This procedure starts a slow background scan of the free or both free and allocated blocks for the requested devices. Background scan is long running and can be checked using the getSSDBlockAllocationScanStatus procedure.
    * @const
    * @type {string}
    */
   startSSDBlockAllocationScan: 'startSSDBlockAllocationScan',

   /**
    * This procedure is used to retrieve the information collected by a SSD Block Allocation Scan. The requested devices and type of scan is set by the startSSDBlockAllocationScan procedure.
    * @const
    * @type {string}
    */
   getSSDBlockAllocationScanStatus: 'getSSDBlockAllocationScanStatus',

   /**
    * This procedure will run a given Health Check suite that is defined by the input parameters and return any relevant data back to the caller
    * @const
    * @type {string}
    */
   performHealthCheck: 'performHealthCheck',

   /**
    * Sets the certificate revocation settings.
    * @const
    * @type {string}
    */
   setCertificateRevocationSettings: 'setCertificateRevocationSettings',

   /**
    * This procedures enables or disables the host connectivity reporting feature on this array.
    * @const
    * @type {string}
    */
   setHostConnectivityReporting: 'setHostConnectivityReporting',

   /**
    * This procedure enables or disables P and Q parity validation during reconstruction of RAID 6 and disk pool volumes on the specified drive media type.
    * @const
    * @type {string}
    */
   setPQParityCheck: 'setPQParityCheck',

   /**
    * This procedure returns a list of initiators that have been detected by the storage array, but are not configured in the storage array topology. An initiator is considered unconfigured if it is not associated with a host.
    * @const
    * @type {string}
    */
   getExtendedUnconfiguredInitiators: 'getExtendedUnconfiguredInitiators',

   /**
    * This procedure sets VPD data for the specified tray enclosure. Only the VPD fields specified in the argument are affected by this operation.
    * @const
    * @type {string}
    */
   setTrayVPD: 'setTrayVPD',

   /**
    * This procedure returns a list of the file details that will be returned by an ASUP collection with the specified ASUPCollectionStartDetails.
    * @const
    * @type {string}
    */
   getASUPCollectionFileList: 'getASUPCollectionFileList',

   /**
    * This procedure sets/clears the cache pool ID for the specified volume.
    * @const
    * @type {string}
    */
   setVolumeCachePoolID: 'setVolumeCachePoolID',

   /**
    * This procedure starts a provisioning operation on a dulbe-enabled VolumeGroup. If successful, all of the Volumes in the VolumeGroup will become fully provisioned. Optionally, the VolumeGroup will transition to dulbe-disabled upon completion.
    * @const
    * @type {string}
    */
   startVolumeGroupFullProvisioningFormat: 'startVolumeGroupFullProvisioningFormat',

   /**
    * This procedure causes a scan of the specified volume over the specified extent and can be used to repair issues with a stripe including data/parity inconsistency, mapped/unmapped mismatches and PI issues.
    * @const
    * @type {string}
    */
   dataParityRepairVolume: 'dataParityRepairVolume',

   /**
    * Create a remote target group
    * @const
    * @type {string}
    */
   createRemoteTargetGroup: 'createRemoteTargetGroup',

   /**
    * Updates a remote target group
    * @const
    * @type {string}
    */
   updateRemoteTargetGroup: 'updateRemoteTargetGroup',

   /**
    * Delete a remote target group
    * @const
    * @type {string}
    */
   deleteRemoteTargetGroup: 'deleteRemoteTargetGroup',

   /**
    * Creates a remote target volume
    * @const
    * @type {string}
    */
   createRemoteTargetVolume: 'createRemoteTargetVolume',

   /**
    * Stores an encrypted secret
    * @const
    * @type {string}
    */
   putEncryptedSecret: 'putEncryptedSecret',

   /**
    * Gets a secret based on the descriptor and returns it
    * @const
    * @type {string}
    */
   getEncryptedSecret: 'getEncryptedSecret',

   /**
    * Delete a secret specified by the descriptor
    * @const
    * @type {string}
    */
   deleteEncryptedSecret: 'deleteEncryptedSecret',

   /**
    * Returns a list of secret keys
    * @const
    * @type {string}
    */
   listSecretKeys: 'listSecretKeys',

   /**
    * Sets parameters necessary to communicate with an external key management server.
    * @const
    * @type {string}
    */
   setExternalKMSParametersList: 'setExternalKMSParametersList',

   /**
    * Returns an estimate for a drive sanitization operation.
    * @const
    * @type {string}
    */
   getSanitizeDriveEstimate: 'getSanitizeDriveEstimate',

   /**
    * Starts a drive sanitization operation.
    * @const
    * @type {string}
    */
   sanitizeDrive: 'sanitizeDrive',

   /**
    * This procedure controls whether resource provisioning is enabled or disabled when a volume group or pool that supports this capability is created. For NVMe drives, this capability is supported only if all drives in the volume group or pool report that they support the DULBE feature.
    * @const
    * @type {string}
    */
   setResourceProvisionedVolumes: 'setResourceProvisionedVolumes',

   /**
    * Procedure that allows clients to verify they have the correct authentication secret for the supplied I/O entity
    * @const
    * @type {string}
    */
   validateIOTransportAuthenticationSecret: 'validateIOTransportAuthenticationSecret',

   /**
    * This procedure will return a list of volume target candidates for creating a volume copy.
    * @const
    * @type {string}
    */
   getVolumeCopyTargetCandidateList: 'getVolumeCopyTargetCandidateList',

   /**
    * This procedure starts the process of enabling resource provisioning on a volume group.
    * @const
    * @type {string}
    */
   startVolumeGroupResourceProvisioningEnablement: 'startVolumeGroupResourceProvisioningEnablement',

   /**
    * This procedure is used to add a known SNMP USM user.
    * @const
    * @type {string}
    */
   addSNMPUsmUser: 'addSNMPUsmUser',

   /**
    * This procedure is used to remove a previously configured SNMP USM user from the list of known users.
    * @const
    * @type {string}
    */
   removeSNMPUsmUser: 'removeSNMPUsmUser',

   /**
    * This procedure is used to modify an existing SNMP USM user.
    * @const
    * @type {string}
    */
   setSNMPUsmUserParams: 'setSNMPUsmUserParams',

   /**
    * Used to re-key the array when an External Key Management Server (EKMS) is in use and gives the user an option to delete the OLD key from the EKMS.
    * @const
    * @type {string}
    */
   externalKMSReKeyWithOption: 'externalKMSReKeyWithOption',

   /**
    * This procedure allows the user to dynamically move all volume ownership (LUNs) to one controller after fault or redistribute ownership after recovery. For target port-to-LUN configurations, it allows all LUNs to be accessible through a single controller when needed.
    * @const
    * @type {string}
    */
   assignPortToLunMappings: 'assignPortToLunMappings',

   /**
    * Starts a network trace on the receiving controller.
    * @const
    * @type {string}
    */
   startNetworkTrace: 'startNetworkTrace',

   /**
    * Stops a network trace on the receiving controller.
    * @const
    * @type {string}
    */
   stopNetworkTrace: 'stopNetworkTrace',

   /**
    * Returns the status for active and completed traces on the receiving controller as well as input guidelines for starting new traces.
    * @const
    * @type {string}
    */
   getNetworkTraceStatus: 'getNetworkTraceStatus',

   /**
    * Deletes the stored network trace (if it exists) on the controller receiving the request.
    * @const
    * @type {string}
    */
   deleteNetworkTrace: 'deleteNetworkTrace',

   /**
    * Sets a drive as verified. New drives inserted into the system will be marked as DRIVE_STAT_INCOMPATIBLE until a user dispositions the drive and marks it as verified.
    * @const
    * @type {string}
    */
   setDriveFwVerified: 'setDriveFwVerified'
};

/**
 * SYMbol Procedure Timeouts, in seconds
 */
symbolAPI.procTimeout = {
   /** @const */ discoverControllers: 40,
   /** @const */ bindToController: 40,
   /** @const */ assignVolumeGroupOwnership: 300,
   /** @const */ assignDrivesAsHotSpares: 40,
   /** @const */ assignSpecificDrivesAsHotSpares: 40,
   /** @const */ getVolumeCandidates: 60,
   /** @const */ createVolume: 540,
   /** @const */ deassignDrivesAsHotSpares: 40,
   /** @const */ deleteVolume: 540,
   /** @const */ setControllerToFailed: 180,
   /** @const */ setDriveToFailed: 90,
   /** @const */ startVolumeFormat: 40,
   /** @const */ initializeDrive: 540,
   /** @const */ loadControllerFirmware: 1200,
   /** @const */ loadControllerNVSRAM: 360,
   /** @const */ resetMel: 40,
   /** @const */ setVolumeGroupToOffline: 90,
   /** @const */ setVolumeGroupToOnline: 540,
   /** @const */ startDriveReconstruction: 540,
   /** @const */ startVolumeGroupDefrag: 540,
   /** @const */ startVolumeGroupExpansion: 540,
   /** @const */ startVolumeRAIDMigration: 540,
   /** @const */ startVolumeSegmentSizing: 540,
   /** @const */ setControllerToPassive: 60,
   /** @const */ setControllerToActive: 40,
   /** @const */ setSACacheParams: 40,
   /** @const */ setSAUserLabel: 40,
   /** @const */ setControllerTime: 40,
   /** @const */ setVolumeCacheParams: 40,
   /** @const */ setVolumeParams: 40,
   /** @const */ setVolumeUserLabel: 40,
   /** @const */ startSAIdentification: 40,
   /** @const */ startDriveIdentification: 40,
   /** @const */ stopIdentification: 90,
   /** @const */ setHostInterfaceParams: 40,
   /** @const */ setControllerToOptimal: 60,
   /** @const */ setDriveToOptimal: 540,
   /** @const */ forceVolumeGroupToOptimal: 600,
   /** @const */ getControllerHostInterfaces: 40,
   /** @const */ getObjectGraph: 60,
   /** @const */ getVolumeActionProgress: 40,
   /** @const */ getRecoveryFailureList: 40,
   /** @const */ getSAData: 60,
   /** @const */ getVolumePerformance: 90,
   /** @const */ setSATrayPositions: 40,
   /** @const */ setVolumeMediaScanParams: 40,
   /** @const */ setSAMediaScanPeriod: 40,
   /** @const */ getChangeState: 40,
   /** @const */ clearSAConfiguration: 120,
   /** @const */ autoSAConfiguration: 180,
   /** @const */ getMelExtent: 90,
   /** @const */ getMelEntries: 300,
   /** @const */ getCriticalMelEntries: 900,
   /** @const */ getControllerNVSRAM: 40,
   /** @const */ setControllerNVSRAM: 40,
   /** @const */ setSAPassword: 40,
   /** @const */ pingController: 40,
   /** @const */ startVolumeParityCheck: 40,
   /** @const */ getParityCheckProgress: 300,
   /** @const */ getLUNMappings: 40,
   /** @const */ createSAPortGroup: 40,
   /** @const */ deleteSAPortGroup: 40,
   /** @const */ moveSAPort: 40,
   /** @const */ getSAPort: 40,
   /** @const */ createHost: 40,
   /** @const */ createCluster: 40,
   /** @const */ deleteCluster: 40,
   /** @const */ renameCluster: 40,
   /** @const */ deleteHost: 40,
   /** @const */ renameHost: 40,
   /** @const */ moveHost: 40,
   /** @const */ createHostPort: 60,
   /** @const */ deleteHostPort: 40,
   /** @const */ renameHostPort: 40,
   /** @const */ moveHostPort: 40,
   /** @const */ createLUNMapping: 90,
   /** @const */ deleteLUNMapping: 40,
   /** @const */ getUnlabeledHostPorts: 40,
   /** @const */ setHostPortType: 40,
   /** @const */ moveLUNMapping: 40,
   /** @const */ enableFeature: 40,
   /** @const */ disableFeature: 40,
   /** @const */ stateCapture: 750,
   /** @const */ loadDriveFirmware: 300,
   /** @const */ loadESMFirmware: 900,
   /** @const */ getHostSpecificNVSRAM: 40,
   /** @const */ setHostSpecificNVSRAM: 40,
   /** @const */ setBatteryParams: 40,
   /** @const */ assignVolumeOwnership: 40,
   /** @const */ issueRuntimeDiagnostics: 180,
   /** @const */ resetController: 40,
   /** @const */ quiesceController: 40,
   /** @const */ unquiesceController: 40,
   /** @const */ startVolumeExpansion: 540,
   /** @const */ createSnapshot: 90,
   /** @const */ disableSnapshot: 40,
   /** @const */ recreateSnapshot: 40,
   /** @const */ setSnapshotParams: 40,
   /** @const */ getRepositoryUtilization: 40,
   /** @const */ calculateDVECapacity: 40,
   /** @const */ getReadLinkStatus: 40,
   /** @const */ setRLSBaseline: 40,
   /** @const */ getMetadataVolumeCapacity: 40,
   /** @const */ createMetadataVolume: 90,
   /** @const */ activateMirroring: 40,
   /** @const */ deactivateMirroring: 40,
   /** @const */ changeSynchronizationPriority: 40,
   /** @const */ getVolumeListForMirroring: 90,
   /** @const */ createMirror: 90,
   /** @const */ roleChange: 40,
   /** @const */ removeMirror: 40,
   /** @const */ startSyncMirror: 40,
   /** @const */ startChannelIdentification: 40,
   /** @const */ startTrayIdentification: 40,
   /** @const */ getDacstoreIncompatibleVolumes: 40,
   /** @const */ getControllerTime: 40,
   /** @const */ establishVolumeCopy: 40,
   /** @const */ removeVolumeCopy: 40,
   /** @const */ setVolumeCopyParams: 40,
   /** @const */ startVolumeCopy: 40,
   /** @const */ stopVolumeCopy: 40,
   /** @const */ getVolumeCopyTargetCandidates: 40,
   /** @const */ getVolumeCopySourceCandidates: 40,
   /** @const */ setNetworkParameters: 40,
   /** @const */ setRloginCapability: 40,
   /** @const */ setVolXferAlertDelayPeriod: 40,
   /** @const */ getPersistentRegistrations: 40,
   /** @const */ getPersistentRegistrationsForVolume: 40,
   /** @const */ clearPersistentRegistrations: 240,
   /** @const */ changeMirrorWriteMode: 40,
   /** @const */ suspendMirror: 40,
   /** @const */ resumeMirror: 40,
   /** @const */ setAutoResync: 40,
   /** @const */ activateStagedControllerFirmware: 480,
   /** @const */ invalidateStagedControllerFirmware: 240,
   /** @const */ getDriveLogData: 40,
   /** @const */ getAutoConfigCandidates: 40,
   /** @const */ createAutoConfig: 180,
   /** @const */ autoAssignHotSpares: 40,
   /** @const */ getHotSpareCoverage: 40,
   /** @const */ getHotSpareCandidates: 40,
   /** @const */ readUnreadableSectorDatabase: 600,
   /** @const */ clearUnreadableSectors: 600,
   /** @const */ communicationCheck: 600,
   /** @const */ startDriveFirmwareDownload: 300,
   /** @const */ sendDriveFirmware: 40,
   /** @const */ updateDriveFirmware: 40,
   /** @const */ stopDriveFirmwareDownload: 40,
   /** @const */ getDriveFirmwareDownloadProgress: 40,
   /** @const */ recoverVolume: 40,
   /** @const */ setDriveChannelState: 40,
   /** @const */ getDriveChannelStatistics: 40,
   /** @const */ clearDriveChannelStatistics: 40,
   /** @const */ suspendConsistencyGroup: 120,
   /** @const */ resumeConsistencyGroup: 40,
   /** @const */ setControllerServiceMode: 180,
   /** @const */ scanVolume: 60,
   /** @const */ updateVolumeAttribute: 40,
   /** @const */ writeMgmtClientRecords: 40,
   /** @const */ readMgmtClientRecords: 40,
   /** @const */ deleteMgmtClientRecords: 40,
   /** @const */ suspendMirrorList: 40,
   /** @const */ resumeMirrorList: 40,
   /** @const */ getPRegistrations: 40,
   /** @const */ updateTray: 40,
   /** @const */ setAlarm: 40,
   /** @const */ issueDiscreteLinesTest: 40,
   /** @const */ requestToRemove: 40,
   /** @const */ setSimplexMode: 40,
   /** @const */ getPRegistrationsForVolume: 40,
   /** @const */ requestRemoval: 40,
   /** @const */ getSocErrorStatistics: 40,
   /** @const */ clearSocErrorStatistics: 40,
   /** @const */ getDdcLog: 40,
   /** @const */ clearDdcNeedsAttention: 40,
   /** @const */ powerDownArray: 40,
   /** @const */ loadEsmFirmwareOnMismatch: 900,
   /** @const */ addPendingHost: 40,
   /** @const */ configurePendingHost: 40,
   /** @const */ getPendingHosts: 40,
   /** @const */ setTrayAttributes: 40,
   /** @const */ getEnvCardLogData: 40,
   /** @const */ getSasErrorStatistics: 40,
   /** @const */ clearSasErrorStatistics: 40,
   /** @const */ applyBundleKey: 40,
   /** @const */ removeBundleKeys: 40,
   /** @const */ createInitiator: 40,
   /** @const */ deleteInitiator: 40,
   /** @const */ getIscsiSessions: 40,
   /** @const */ getIscsiNegotiationDefaults: 40,
   /** @const */ getUnconfiguredInitiators: 40,
   /** @const */ setHostProperties: 40,
   /** @const */ setInitiatorProperties: 40,
   /** @const */ setIscsiEntityProperties: 180,
   /** @const */ setIscsiInterfaceProperties: 240,
   /** @const */ setTargetProperties: 40,
   /** @const */ stopIscsiSession: 40,
   /** @const */ getIscsiStatistics: 40,
   /** @const */ setIscsiStatisticsBaseline: 40,
   /** @const */ setStorageArrayProperties: 40,
   /** @const */ validatePassword: 40,
   /** @const */ refreshIscsiDhcpParameters: 210,
   /** @const */ refreshIsnsServerLocation: 180,
   /** @const */ disableSnapshotCollection: 180,
   /** @const */ recreateSnapshotCollection: 40,
   /** @const */ createVolumeGroup: 40,
   /** @const */ deleteVolumeGroup: 120,
   /** @const */ resetSAConfiguration: 120,
   /** @const */ setVolumeGroupUserLabel: 40,
   /** @const */ replaceDrive: 240,
   /** @const */ getVolumeGroupExpansionCandidates: 40,
   /** @const */ exportVolumeGroup: 180,
   /** @const */ forceVolumeGroup: 540,
   /** @const */ importVolumeGroup: 540,
   /** @const */ activateDiscreteTimeSeries: 40,
   /** @const */ deactivateDiscreteTimeSeries: 40,
   /** @const */ getDiscreteTimeSeriesBundle: 40,
   /** @const */ resetDiscreteTimeSeries: 40,
   /** @const */ getHistogramBundle: 40,
   /** @const */ activateHistogram: 40,
   /** @const */ deactivateHistogram: 40,
   /** @const */ resetHistogram: 40,
   /** @const */ getCumulativeStatisticsBundle: 40,
   /** @const */ resetCumulativeStatistics: 40,
   /** @const */ getExportDependencies: 40,
   /** @const */ deleteSnapshot: 40,
   /** @const */ deleteVolumeFromGroup: 540,
   /** @const */ cancelImport: 40,
   /** @const */ getImportDependencies: 600,
   /** @const */ setVolumeProperties: 40,
   /** @const */ adoptAllDrives: 540,
   /** @const */ adoptDrive: 180,
   /** @const */ getControllerDebugInformation: 120,
   /** @const */ getIbIocAttributes: 40,
   /** @const */ getIbPortPartitionTables: 40,
   /** @const */ getIbRdmaChannels: 40,
   /** @const */ getIbStatistics: 40,
   /** @const */ setIbStatisticsBaseline: 40,
   /** @const */ createAHostPort: 60,
   /** @const */ setEthernetInterfaceProperties: 40,
   /** @const */ setHostPortProperties: 40,
   /** @const */ setControllerProperties: 40,
   /** @const */ startChannelDiagnostics: 40,
   /** @const */ stopChannelDiagnostics: 40,
   /** @const */ getChannelDiagnosticsResults: 40,
   /** @const */ getControllerHostIoInterfaces: 40,
   /** @const */ getCtlLockDownInfo: 40,
   /** @const */ loadControllerFirmwareOnLockdown: 1200,
   /** @const */ disableVolumeProtectionInformation: 40,
   /** @const */ setLockKey: 40,
   /** @const */ importLockKey: 600,
   /** @const */ exportLockKey: 40,
   /** @const */ reprovisionDrive: 600,
   /** @const */ secureVolumeGroup: 40,
   /** @const */ createLockKey: 120,
   /** @const */ activateHostPort: 40,
   /** @const */ activateInitiator: 40,
   /** @const */ getProductCapabilities: 40,
   /** @const */ disableExternalKMS: 40,
   /** @const */ enableExternalKMS: 300,
   /** @const */ installLockKey: 600,
   /** @const */ installNewLockKey: 255,
   /** @const */ startCacheMemoryDiagnostic: 40,
   /** @const */ getCacheMemoryDiagnosticStatus: 40,
   /** @const */ cancelCacheMemoryDiagnostic: 40,
   /** @const */ startCacheBackupDeviceDiagnostic: 40,
   /** @const */ getCacheBackupDeviceDiagnosticStatus: 40,
   /** @const */ cancelCacheBackupDeviceDiagnostic: 40,
   /** @const */ startHostCardDiagnostic: 40,
   /** @const */ getHostCardDiagnosticStatus: 40,
   /** @const */ cancelHostCardDiagnostic: 90,
   /** @const */ startBaseControllerDiagnostic: 40,
   /** @const */ getBaseControllerDiagnosticStatus: 40,
   /** @const */ cancelBaseControllerDiagnostic: 40,
   /** @const */ loadControllerFirmwareNoPassword: 1200,
   /** @const */ enableFeatureEvaluation: 40,
   /** @const */ externalKMSReKey: 300,
   /** @const */ validateLockKey: 40,
   /** @const */ setVolumeListOnline: 40,
   /** @const */ startRawDataRetrieve: 2400,
   /** @const */ continueRawDataRetrieve: 2400,
   /** @const */ cancelRawDataRetrieve: 40,
   /** @const */ startRawDataRestore: 40,
   /** @const */ continueRawDataRestore: 1200,
   /** @const */ cancelRawDataRestore: 40,
   /** @const */ setRemoteTargetProperties: 40,
   /** @const */ writeClientMgmtRecordsNoPassword: 40,
   /** @const */ deleteClientMgmtRecordsNoPassword: 40,
   /** @const */ loadFactoryDefaults: 200,
   /** @const */ getEnclosureStateCaptureData: 40,
   /** @const */ getAlertableMelEntries: 900,
   /** @const */ getLongLivedOpsProgress: 40,
   /** @const */ startSnapshotRollback: 40,
   /** @const */ cancelSnapshotRollback: 40,
   /** @const */ resumeSnapshotRollback: 40,
   /** @const */ createScheduleList: 40,
   /** @const */ modifyScheduleList: 40,
   /** @const */ deleteScheduleList: 40,
   /** @const */ getIscsiCopperCableDiagnostics: 40,
   /** @const */ updatePSUFirmware: 40,
   /** @const */ getPSUFirmwareUpdateProgress: 40,
   /** @const */ getEnclosureTemperatures: 40,
   /** @const */ getDriveTemperatures: 40,
   /** @const */ setDriveTemperaturePollingInterval: 40,
   /** @const */ reserveSupportData: 40,
   /** @const */ releaseSupportData: 40,
   /** @const */ createDiskPool: 540,
   /** @const */ deleteDiskPool: 40,
   /** @const */ assignDiskPoolOwnership: 40,
   /** @const */ setDiskPoolUserLabel: 40,
   /** @const */ createFlashCache: 40,
   /** @const */ deleteFlashCache: 40,
   /** @const */ enableFlashCacheVolume: 40,
   /** @const */ disableFlashCacheVolume: 40,
   /** @const */ suspendFlashCache: 40,
   /** @const */ addDrivesToFlashCache: 40,
   /** @const */ removeDrivesFromFlashCache: 40,
   /** @const */ setFlashCacheParams: 40,
   /** @const */ resumeFlashCache: 40,
   /** @const */ createPITGroup: 40,
   /** @const */ deletePITGroup: 40,
   /** @const */ setPITGroupParams: 40,
   /** @const */ createPIT: 40,
   /** @const */ deletePIT: 40,
   /** @const */ createCGPIT: 40,
   /** @const */ deleteCGPIT: 40,
   /** @const */ createPITView: 40,
   /** @const */ deletePITView: 40,
   /** @const */ stopPITView: 40,
   /** @const */ setPITViewParams: 40,
   /** @const */ createPITConsistencyGroup: 40,
   /** @const */ deletePITConsistencyGroup: 40,
   /** @const */ addPITConsistencyGroupMember: 40,
   /** @const */ removePITConsistencyGroupMember: 40,
   /** @const */ setPITConsistencyGroupParams: 40,
   /** @const */ startPITRollback: 40,
   /** @const */ startCGRollback: 40,
   /** @const */ resumePITRollback: 40,
   /** @const */ cancelPITRollback: 40,
   /** @const */ expandConcatVolume: 40,
   /** @const */ trimConcatVolume: 40,
   /** @const */ getPITGroupRepositoryUtilization: 40,
   /** @const */ getPITViewRepositoryUtilization: 40,
   /** @const */ estimatePITRollbackRepositoryUtilization: 40,
   /** @const */ convertReadOnlyPITViewToReadWrite: 40,
   /** @const */ createPITConsistencyGroupView: 40,
   /** @const */ deletePITConsistencyGroupView: 40,
   /** @const */ stopPITConsistencyGroupView: 40,
   /** @const */ setDiskPoolReservedDriveCount: 40,
   /** @const */ setDiskPoolThreshold: 40,
   /** @const */ setDiskPoolPriority: 40,
   /** @const */ setDiskPoolToComplete: 40,
   /** @const */ getDiskPoolExpansionCandidates: 40,
   /** @const */ startDiskPoolExpansion: 540,
   /** @const */ triggerDPLCoreDumpOnDemand: 40,
   /** @const */ getDPLCoreDumpInformation: 40,
   /** @const */ clearDPLCoreDumpNeedsRetrieved: 40,
   /** @const */ restartPITView: 40,
   /** @const */ restartPITConsistencyGroupView: 40,
   /** @const */ disableFeatureByRef: 40,
   /** @const */ addAsyncMirrorGroupPrimaryMember: 150,
   /** @const */ addAsyncMirrorGroupSecondaryMember: 120,
   /** @const */ changeAsyncMirrorGroupRole: 150,
   /** @const */ clearAsyncMirrorGroupFaultIndication: 40,
   /** @const */ clearAsyncMirrorGroupMemberFaultIndication: 40,
   /** @const */ createAsyncMirrorGroup: 180,
   /** @const */ deleteAsyncMirrorGroup: 150,
   /** @const */ deleteAsyncMirrorGroupIncompleteMember: 120,
   /** @const */ deactivateFibreChannelCheckPointBasedAsyncMirroring: 40,
   /** @const */ activateFibreChannelCheckPointBasedAsyncMirroring: 40,
   /** @const */ getAsyncMirrorGroupSyncProgress: 40,
   /** @const */ getAsyncMirrorRepositoryUtilization: 40,
   /** @const */ removeAsyncMirrorGroupMember: 180,
   /** @const */ resumeAsyncMirrorGroup: 90,
   /** @const */ setAsyncMirrorGroupParams: 90,
   /** @const */ suspendAsyncMirrorGroup: 90,
   /** @const */ synchronizeAsyncMirrorGroup: 180,
   /** @const */ getDiskPoolMaxReservedDriveCount: 40,
   /** @const */ cancelPendingCGPITCreation: 40,
   /** @const */ cancelPendingPITCreation: 40,
   /** @const */ revivePITGroup: 40,
   /** @const */ revivePITView: 40,
   /** @const */ setPITConsistencyGroupViewParams: 40,
   /** @const */ createThinVolume: 40,
   /** @const */ expandThinVolumeVirtualCapacity: 40,
   /** @const */ getThinVolumeConsumedCapacity: 40,
   /** @const */ getThinVolumeExpansionHistory: 40,
   /** @const */ reinitializeThinVolume: 40,
   /** @const */ setThinVolumeCapacityThreshold: 40,
   /** @const */ setThinVolumeExpansionPolicy: 40,
   /** @const */ setThinVolumeProvisionedCapacityQuota: 40,
   /** @const */ getSystemAttributeDefaults: 40,
   /** @const */ getCumulativeStatisticsBundles: 40,
   /** @const */ createFlashCacheAnalytics: 40,
   /** @const */ startFlashCacheAnalytics: 40,
   /** @const */ stopFlashCacheAnalytics: 40,
   /** @const */ getFlashCacheAnalytics: 40,
   /** @const */ convertSnapshotsToPITGroups: 40,
   /** @const */ analyzeCopyOnWriteRepository: 1200,
   /** @const */ getDatabaseMetadata: 40,
   /** @const */ cancelDatabaseRecoveryMode: 40,
   /** @const */ cancelAsyncMirrorGroupRoleChange: 90,
   /** @const */ testAsyncMirrorGroupConnectivity: 300,
   /** @const */ getFlashCacheStatistics: 40,
   /** @const */ loadControllerNVSRAMNoPassword: 1200,
   /** @const */ recoverAsyncMirrorGroupMember: 90,
   /** @const */ forceDiskPoolToOptimal: 540,
   /** @const */ secureDiskPool: 40,
   /** @const */ enableASUP: 40,
   /** @const */ disableASUP: 40,
   /** @const */ getAsyncMirrorGroupRemoteConnections: 40,
   /** @const */ getAsyncMirrorSyncStatistics: 40,
   /** @const */ getRemoteConnections: 600,
   /** @const */ resetAsyncMirrorSyncStatistics: 40,
   /** @const */ setSAViewPassword: 40,
   /** @const */ getSAViewPasswordDigest: 40,
   /** @const */ addSNMPCommunity: 40,
   /** @const */ addSNMPTrapDestination: 40,
   /** @const */ removeSNMPCommunity: 40,
   /** @const */ removeSNMPTrapDestination: 40,
   /** @const */ setSNMPCommunityParams: 40,
   /** @const */ setSNMPSystemVariables: 40,
   /** @const */ setSNMPTrapDestinationParams: 40,
   /** @const */ startDiskPoolReduction: 40,
   /** @const */ getDiskPoolReductionDriveCount: 40,
   /** @const */ testSNMPTrapDestination: 40,
   /** @const */ recoverAsyncMirrorGroupMemberDeleteRecoveryPoint: 90,
   /** @const */ getAsupStatus: 90,
   /** @const */ setAsupStatus: 90,
   /** @const */ triggerIOCDumpOnDemand: 40,
   /** @const */ getIOCDumpInformation: 40,
   /** @const */ recoverFromMiswire: 60,
   /** @const */ getEnergyStarData: 40,
   /** @const */ setFunctionState: 40,
   /** @const */ powerCyclePhysicalDrive: 40,
   /** @const */ cancelEvacuation: 40,
   /** @const */ copyDriveThenFail: 540,
   /** @const */ copyDriveThenReplace: 540,
   /** @const */ getEnhancedIbStatistics: 40,
   /** @const */ startPerformanceMonitor: 40,
   /** @const */ stopPerformanceMonitor: 40,
   /** @const */ setHighResolutionSampling: 40,
   /** @const */ setAutoLoadBalancing: 40,
   /** @const */ failBackVolumeOwnership: 40,
   /** @const */ autoLoadBalanceRequest: 40,
   /** @const */ setDrivePhysicalSecurityID: 90,
   /** @const */ setThinVolumeReportingPolicy: 40,
   /** @const */ setClusterPerformanceLimitationValues: 40,
   /** @const */ getClusterPerformanceLimitationValues: 40,
   /** @const */ createKeyValueTag: 40,
   /** @const */ deleteKeyValueTag: 40,
   /** @const */ setKeyValueTagMapping: 40,
   /** @const */ deleteKeyValueTagMapping: 40,
   /** @const */ createWorkload: 40,
   /** @const */ deleteWorkload: 40,
   /** @const */ createWorkloadVolumeMapping: 40,
   /** @const */ deleteWorkloadVolumeMapping: 40,
   /** @const */ generateCertificateSigningRequest: 40,
   /** @const */ installKMSCertificateFile: 40,
   /** @const */ retrieveKMSCertificateFile: 40,
   /** @const */ removeInstalledKMSCertificateFiles: 40,
   /** @const */ setHostPortsAttributes: 40,
   /** @const */ setExternalKMSParameters: 40,
   /** @const */ verifyExternalKMSCommunication: 40,
   /** @const */ tunnelHttpCall: 300,
   /** @const */ setNVMeHostInterfaceProperties: 40,
   /** @const */ handleInternalMessage: 40,
   /** @const */ getNVMeoFStatistics: 40,
   /** @const */ setNVMeoFStatisticsBaseline: 40,
   /** @const */ setCacheMirroringProtectionInformation: 40,
   /** @const */ getCurrentSSDWearLifeStats: 40,
   /** @const */ resetSuperProvisioningBoundary: 40,
   /** @const */ startSSDBlockAllocationScan: 40,
   /** @const */ getSSDBlockAllocationScanStatus: 40,
   /** @const */ performHealthCheck: 300,
   /** @const */ setCertificateRevocationSettings: 40,
   /** @const */ setHostConnectivityReporting: 40,
   /** @const */ setPQParityCheck: 40,
   /** @const */ getExtendedUnconfiguredInitiators: 40,
   /** @const */ setTrayVPD: 40,
   /** @const */ getASUPCollectionFileList: 40,
   /** @const */ setVolumeCachePoolID: 60,
   /** @const */ startVolumeGroupFullProvisioningFormat: 60,
   /** @const */ dataParityRepairVolume: 60,
   /** @const */ createRemoteTargetGroup: 40,
   /** @const */ updateRemoteTargetGroup: 40,
   /** @const */ deleteRemoteTargetGroup: 40,
   /** @const */ createRemoteTargetVolume: 40,
   /** @const */ putEncryptedSecret: 40,
   /** @const */ getEncryptedSecret: 40,
   /** @const */ deleteEncryptedSecret: 40,
   /** @const */ listSecretKeys: 40,
   /** @const */ setExternalKMSParametersList: 40,
   /** @const */ getSanitizeDriveEstimate: 60,
   /** @const */ sanitizeDrive: 120,
   /** @const */ setResourceProvisionedVolumes: 40,
   /** @const */ validateIOTransportAuthenticationSecret: 40,
   /** @const */ getVolumeCopyTargetCandidateList: 40,
   /** @const */ startVolumeGroupResourceProvisioningEnablement: 40,
   /** @const */ addSNMPUsmUser: 40,
   /** @const */ removeSNMPUsmUser: 40,
   /** @const */ setSNMPUsmUserParams: 40,
   /** @const */ externalKMSReKeyWithOption: 300,
   /** @const */ assignPortToLunMappings: 40,
   /** @const */ startNetworkTrace: 40,
   /** @const */ stopNetworkTrace: 40,
   /** @const */ getNetworkTraceStatus: 40,
   /** @const */ deleteNetworkTrace: 40,
   /** @const */ setDriveFwVerified: 40
};

