# argocd-apps

A Helm chart for managing additional Argo CD Applications and Projects

To regenerate this document, from the root of this chart directory run:
```shell
docker run --rm --volume "$(pwd):/helm-docs" -u $(id -u) jnorwood/helm-docs:latest
```

## Prerequisites

- Helm v3.0.0+
- CRDs (Application and AppProject)
  - You need to install them via [argo-cd Helm chart](../argo-cd) or upstream.

## Changelog

For full list of changes, please check ArtifactHub [changelog].

## Installation

```console
$ helm repo add argo https://argoproj.github.io/argo-helm
$ helm install my-release argo/argocd-apps
```

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| applications | list | `[]` (See [values.yaml]) | Deploy Argo CD Applications within this helm release |
| applicationsets | list | `[]` (See [values.yaml]) | Deploy Argo CD ApplicationSets within this helm release |
| extensions | list | `[]` (See [values.yaml]) | Deploy Argo UI Extensions within this helm release |
| projects | list | `[]` (See [values.yaml]) | Deploy Argo CD Projects within this helm release |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs](https://github.com/norwoodj/helm-docs)

[changelog]: https://artifacthub.io/packages/helm/argo/argocd-apps?modal=changelog
